/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.peptide_inference;

import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationProvider;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.SpectrumMatchesIterator;
import com.compomics.util.experiment.identification.modification.peptide_mapping.ModificationPeptideMapping;
import com.compomics.util.experiment.identification.peptide_shaker.ModificationScoring;
import com.compomics.util.experiment.identification.peptide_shaker.PSModificationScores;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.ModificationLocalizationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class PeptideInference {
    public final int CONFIDENT_OWN_OFFSET = 400;
    public final int CONFIDENT_OTHER_OFFSET = 200;
    public final int CONFIDENT_RELATED_OFFSET = 100;

    public void peptideInference(Identification identification, IdentificationParameters identificationParameters, SequenceProvider sequenceProvider, ModificationProvider modificationProvider, WaitingHandler waitingHandler) {
        SpectrumMatch spectrumMatch;
        waitingHandler.setWaitingText("Peptide Inference. Please Wait...");
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        waitingHandler.setMaxSecondaryProgressCounter(identification.getSpectrumIdentificationSize());
        ModificationLocalizationParameters modificationLocalizationParameters = identificationParameters.getModificationLocalizationParameters();
        SequenceMatchingParameters modificationSequenceMatchingParameters = modificationLocalizationParameters.getSequenceMatchingParameters();
        SearchParameters searchParameters = identificationParameters.getSearchParameters();
        ModificationParameters modificationParameters = searchParameters.getModificationParameters();
        HashMap<Double, HashMap<String, HashSet<Long>>> confidentPeptideInference = new HashMap<Double, HashMap<String, HashSet<Long>>>();
        HashSet<Long> notConfidentPeptideInference = new HashSet<Long>();
        SpectrumMatchesIterator psmIterator = identification.getSpectrumMatchesIterator(waitingHandler);
        while ((spectrumMatch = psmIterator.next()) != null) {
            if (spectrumMatch.getBestPeptideAssumption() == null) continue;
            this.fillConfidentMaps(spectrumMatch, confidentPeptideInference, notConfidentPeptideInference, modificationParameters, modificationProvider, waitingHandler);
            if (!waitingHandler.isRunCanceled()) continue;
            return;
        }
        Iterator iterator = notConfidentPeptideInference.iterator();
        while (iterator.hasNext()) {
            long psmKey = (Long)iterator.next();
            this.peptideInference(psmKey, confidentPeptideInference, identification, modificationLocalizationParameters, modificationProvider);
            if (waitingHandler.isRunCanceled()) {
                return;
            }
            waitingHandler.increaseSecondaryProgressCounter();
        }
    }

    private void peptideInference(long spectrumKey, HashMap<Double, HashMap<String, HashSet<Long>>> confidentPeptideInference, Identification identification, ModificationLocalizationParameters modificationLocalizationParameters, ModificationProvider modificationProvider) {
        Object entrySiteOffsets;
        double modMass;
        SpectrumMatch spectrumMatch = identification.getSpectrumMatch(spectrumKey);
        PSModificationScores modificationScores = (PSModificationScores)spectrumMatch.getUrParam(PSModificationScores.dummy);
        Peptide peptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
        String sequence = peptide.getSequence();
        ModificationMatch[] modificationMatches = peptide.getVariableModifications();
        HashSet modMasses = Arrays.stream(modificationMatches).map(modificationMatch -> modificationProvider.getModification(modificationMatch.getModification()).getMass()).collect(Collectors.toCollection(HashSet::new));
        HashMap<Double, HashMap<Integer, Double>> modificationToSiteToScore = new HashMap<Double, HashMap<Integer, Double>>(modificationMatches.length);
        HashMap modificationToSiteToName = new HashMap(modificationMatches.length);
        boolean relatedPeptide = false;
        HashSet<Long> processed = new HashSet<Long>();
        Iterator iterator = modMasses.iterator();
        while (iterator.hasNext()) {
            modMass = (Double)iterator.next();
            modificationToSiteToScore.put(modMass, new HashMap(2));
            modificationToSiteToName.put(modMass, new HashMap(2));
        }
        iterator = modMasses.iterator();
        while (iterator.hasNext()) {
            modMass = (Double)iterator.next();
            HashMap<String, HashSet<Long>> modMap = confidentPeptideInference.get(modMass);
            if (modMap == null) continue;
            for (Map.Entry<String, HashSet<Long>> entry : modMap.entrySet()) {
                String tempSequence;
                int ref;
                ArrayList<Integer> offsetList;
                int tempIndex;
                String entrySequence = entry.getKey();
                double scoreOffset = Double.NaN;
                int[] peptideSiteOffsets = null;
                entrySiteOffsets = null;
                if (entrySequence.equals(sequence)) {
                    scoreOffset = 200.0;
                    peptideSiteOffsets = new int[]{0};
                    entrySiteOffsets = new int[]{0};
                } else if (entrySequence.length() > sequence.length() && (tempIndex = entrySequence.indexOf(sequence)) >= 0) {
                    scoreOffset = 100.0;
                    peptideSiteOffsets = new int[]{0};
                    offsetList = new ArrayList(1);
                    offsetList.add(tempIndex);
                    ref = tempIndex + 1;
                    tempSequence = entrySequence.substring(tempIndex + 1);
                    while ((tempIndex = tempSequence.indexOf(sequence)) >= 0) {
                        offsetList.add(ref += tempIndex);
                        tempSequence = tempSequence.substring(tempIndex + 1);
                        ++ref;
                    }
                    entrySiteOffsets = offsetList.stream().mapToInt(a -> a).toArray();
                } else if (entrySequence.length() < sequence.length() && (tempIndex = sequence.indexOf(entrySequence)) >= 0) {
                    scoreOffset = 100.0;
                    entrySiteOffsets = new int[]{0};
                    offsetList = new ArrayList<Integer>(1);
                    offsetList.add(tempIndex);
                    ref = tempIndex + 1;
                    tempSequence = sequence.substring(tempIndex + 1);
                    while ((tempIndex = tempSequence.indexOf(entrySequence)) >= 0) {
                        offsetList.add(ref += tempIndex);
                        tempSequence = tempSequence.substring(tempIndex + 1);
                        ++ref;
                    }
                    peptideSiteOffsets = offsetList.stream().mapToInt(a -> a).toArray();
                }
                if (peptideSiteOffsets == null) continue;
                offsetList = entry.getValue().iterator();
                while (offsetList.hasNext()) {
                    long key = offsetList.next();
                    if (key == spectrumKey || processed.contains(key)) continue;
                    SpectrumMatch tempMatch = identification.getSpectrumMatch(key);
                    PSModificationScores tempScores = (PSModificationScores)tempMatch.getUrParam(PSModificationScores.dummy);
                    for (ModificationMatch modMatch : tempMatch.getBestPeptideAssumption().getPeptide().getVariableModifications()) {
                        String modName;
                        Modification modification;
                        double tempMass;
                        if (!modMatch.getConfident() || !modMasses.contains(tempMass = (modification = modificationProvider.getModification(modName = modMatch.getModification())).getMass())) continue;
                        ModificationScoring modificationScoring = tempScores.getModificationScoring(modName);
                        int site = modMatch.getSite();
                        double score = modificationLocalizationParameters.isProbabilisticScoreCalculation() ? modificationScoring.getProbabilisticScore(site) : modificationScoring.getDeltaScore(site);
                        score += scoreOffset;
                        HashMap<Integer, Double> tempScoreMap = modificationToSiteToScore.get(tempMass);
                        HashMap tempNameMap = (HashMap)modificationToSiteToName.get(tempMass);
                        for (int siteOffset1 : peptideSiteOffsets) {
                            for (int siteOffset2 : entrySiteOffsets) {
                                Double currentScore;
                                int siteOnPeptide = site + siteOffset1 - siteOffset2;
                                if (siteOnPeptide < 0 || siteOnPeptide > sequence.length() + 1 || (currentScore = tempScoreMap.get(site)) != null && !(currentScore < score)) continue;
                                tempScoreMap.put(siteOnPeptide, score);
                                tempNameMap.put(siteOnPeptide, modName);
                                relatedPeptide = true;
                            }
                        }
                    }
                    processed.add(key);
                }
            }
        }
        if (relatedPeptide) {
            HashMap<Double, int[]> modificationToPossibleSiteMap = new HashMap<Double, int[]>(modificationMatches.length);
            HashMap<Double, Integer> modificationOccurrenceMap = new HashMap<Double, Integer>(modificationMatches.length);
            for (String modName : modificationScores.getScoredModifications()) {
                Double currentScore;
                double score;
                int site;
                HashMap<Integer, Double> siteToScore;
                Modification modification = modificationProvider.getModification(modName);
                double modMass2 = modification.getMass();
                HashMap<Integer, String> siteToName = (HashMap<Integer, String>)modificationToSiteToName.get(modMass2);
                if (siteToName == null) {
                    siteToName = new HashMap<Integer, String>(2);
                    modificationToSiteToName.put(modMass2, siteToName);
                }
                if ((siteToScore = modificationToSiteToScore.get(modMass2)) == null) {
                    siteToScore = new HashMap(2);
                    modificationToSiteToScore.put(modMass2, siteToScore);
                }
                ModificationScoring modificationScoring = modificationScores.getModificationScoring(modName);
                if (modificationLocalizationParameters.isProbabilisticScoreCalculation()) {
                    entrySiteOffsets = modificationScoring.getProbabilisticSites().iterator();
                    while (entrySiteOffsets.hasNext()) {
                        site = (Integer)entrySiteOffsets.next();
                        score = modificationScoring.getProbabilisticScore(site);
                        currentScore = siteToScore.get(site);
                        if (currentScore != null && !(currentScore < score)) continue;
                        siteToName.put(site, modName);
                        siteToScore.put(site, score);
                    }
                    continue;
                }
                entrySiteOffsets = modificationScoring.getDSites().iterator();
                while (entrySiteOffsets.hasNext()) {
                    site = (Integer)entrySiteOffsets.next();
                    score = modificationScoring.getDeltaScore(site);
                    currentScore = siteToScore.get(site);
                    if (currentScore != null && !(currentScore < score)) continue;
                    siteToName.put(site, modName);
                    siteToScore.put(site, score);
                }
            }
            for (ModificationMatch modMatch : modificationMatches) {
                Integer occurrence;
                String modName = modMatch.getModification();
                Modification modification = modificationProvider.getModification(modName);
                double modMass3 = modification.getMass();
                modMasses.add(modMass3);
                if (modMatch.getConfident()) {
                    HashMap<Integer, Double> siteToScore = modificationToSiteToScore.get(modMass3);
                    int site = modMatch.getSite();
                    double score = siteToScore.get(site);
                    siteToScore.put(site, score + 400.0);
                }
                if ((occurrence = modificationOccurrenceMap.get(modMass3)) == null) {
                    occurrence = 1;
                    modificationOccurrenceMap.put(modMass3, occurrence);
                    HashMap<Integer, Double> siteToScore = modificationToSiteToScore.get(modMass3);
                    HashSet<Integer> possibleSites = new HashSet<Integer>(siteToScore.keySet());
                    int[] possilbeSitesArray = possibleSites.stream().mapToInt(a -> a).toArray();
                    modificationToPossibleSiteMap.put(modMass3, possilbeSitesArray);
                    continue;
                }
                modificationOccurrenceMap.put(modMass3, occurrence + 1);
            }
            HashMap<Double, TreeSet<Integer>> mapping = ModificationPeptideMapping.mapModifications(modificationToPossibleSiteMap, modificationOccurrenceMap, modificationToSiteToScore);
            ModificationMatch[] newModificationMatches = new ModificationMatch[modificationMatches.length];
            int modI = 0;
            for (Map.Entry<Double, TreeSet<Integer>> mappingEntry : mapping.entrySet()) {
                double modMass4 = mappingEntry.getKey();
                for (int site : mappingEntry.getValue()) {
                    String modName = (String)((HashMap)modificationToSiteToName.get(modMass4)).get(site);
                    ModificationMatch modificationMatch2 = new ModificationMatch(modName, site);
                    double score = modificationToSiteToScore.get(modMass4).get(site);
                    if (score > 400.0) {
                        modificationMatch2.setConfident(true);
                    } else if (score > 100.0) {
                        modificationMatch2.setInferred(true);
                    }
                    newModificationMatches[modI] = modificationMatch2;
                    ++modI;
                }
            }
            if (modI < modificationMatches.length) {
                throw new IllegalArgumentException(modI + " modifications found where " + modificationMatches.length + " needed.");
            }
            peptide.setVariableModifications(newModificationMatches);
        }
    }

    private void fillConfidentMaps(SpectrumMatch spectrumMatch, HashMap<Double, HashMap<String, HashSet<Long>>> confidentPeptideInference, HashSet<Long> notConfidentPeptideInference, ModificationParameters modificationParameters, ModificationProvider modificationProvider, WaitingHandler waitingHandler) {
        boolean variableAA = false;
        Peptide peptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
        block0: for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
            String modName = modificationMatch.getModification();
            Modification modification = modificationProvider.getModification(modName);
            if (modification.getModificationType() == ModificationType.modaa) {
                variableAA = true;
                break;
            }
            double modMass = modification.getMass();
            for (String otherModName : modificationParameters.getAllNotFixedModifications()) {
                Object otherModification;
                if (otherModName.equals(modName) || ((Modification)(otherModification = modificationProvider.getModification(otherModName))).getMass() != modMass || modification.getModificationType() == ((Modification)otherModification).getModificationType()) continue;
                variableAA = true;
                continue block0;
            }
        }
        if (variableAA) {
            boolean confident = true;
            for (ModificationMatch modMatch : peptide.getVariableModifications()) {
                String sequence;
                HashSet<Long> spectra;
                boolean maybeNotTerminal;
                String modName = modMatch.getModification();
                Modification modification = modificationProvider.getModification(modName);
                double modMass = modification.getMass();
                boolean bl = maybeNotTerminal = modification.getModificationType() == ModificationType.modaa;
                if (!maybeNotTerminal) {
                    for (String otherModName : modificationParameters.getAllNotFixedModifications()) {
                        Modification otherModification;
                        if (otherModName.equals(modName) || (otherModification = modificationProvider.getModification(otherModName)).getMass() != modMass || modification.getModificationType() == otherModification.getModificationType()) continue;
                        maybeNotTerminal = true;
                        break;
                    }
                }
                if (!maybeNotTerminal) continue;
                if (!modMatch.getConfident()) {
                    notConfidentPeptideInference.add(spectrumMatch.getKey());
                    confident = false;
                    continue;
                }
                HashMap<String, HashSet<Long>> modMap = confidentPeptideInference.get(modMass);
                if (modMap == null) {
                    modMap = new HashMap(2);
                    confidentPeptideInference.put(modMass, modMap);
                }
                if ((spectra = modMap.get(sequence = spectrumMatch.getBestPeptideAssumption().getPeptide().getSequence())) == null) {
                    spectra = new HashSet(2);
                    modMap.put(sequence, spectra);
                }
                spectra.add(spectrumMatch.getKey());
            }
            if (confident) {
                waitingHandler.increaseSecondaryProgressCounter();
            }
        } else {
            waitingHandler.increaseSecondaryProgressCounter();
        }
    }
}

