/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_sequences.digestion.iterators;

import com.compomics.util.experiment.identification.protein_sequences.digestion.ExtendedPeptide;
import com.compomics.util.experiment.identification.protein_sequences.digestion.ProteinIteratorUtils;
import com.compomics.util.experiment.identification.protein_sequences.digestion.SequenceIterator;

public class NoDigestionIterator
implements SequenceIterator {
    private final ProteinIteratorUtils proteinIteratorUtils;
    private ExtendedPeptide peptideWithPosition = null;

    public NoDigestionIterator() {
        this.proteinIteratorUtils = null;
    }

    public NoDigestionIterator(ProteinIteratorUtils proteinIteratorUtils, String sequence, double massMin, double massMax) throws InterruptedException {
        this.proteinIteratorUtils = proteinIteratorUtils;
        this.setPeptide(sequence, massMin, massMax);
    }

    @Override
    public ExtendedPeptide getNextPeptide() {
        ExtendedPeptide result = this.peptideWithPosition;
        this.peptideWithPosition = null;
        return result;
    }

    private void setPeptide(String sequence, double massMin, double massMax) throws InterruptedException {
        ExtendedPeptide extendedPeptide = this.proteinIteratorUtils.getPeptideFromProtein(sequence.toCharArray(), sequence, 0, massMin, massMax);
        if (extendedPeptide != null && extendedPeptide.peptide.getMass() >= massMin && extendedPeptide.peptide.getMass() <= massMax) {
            this.peptideWithPosition = extendedPeptide;
        }
    }
}

