/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotation;

import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.ArrayList;
import java.util.HashMap;

public class NeutralLossesMap
extends ExperimentObject {
    static final long serialVersionUID = -4690159937753713106L;
    private HashMap<String, Integer> forwardBoundaries = new HashMap(2);
    private HashMap<String, Integer> rewindBoundaries = new HashMap(2);
    private ArrayList<String> accountedNeutralLosses = null;

    public void addNeutralLoss(NeutralLoss neutralLoss, int bStart, int yStart) {
        this.addNeutralLoss(neutralLoss.name, bStart, yStart);
        this.accountedNeutralLosses = null;
    }

    public void addNeutralLoss(String neutralLossName, int bStart, int yStart) {
        Integer position = this.forwardBoundaries.get(neutralLossName);
        if (position == null || bStart < position) {
            this.forwardBoundaries.put(neutralLossName, bStart);
        }
        if ((position = this.rewindBoundaries.get(neutralLossName)) == null || yStart < position) {
            this.rewindBoundaries.put(neutralLossName, yStart);
        }
        this.accountedNeutralLosses = null;
    }

    public void clearNeutralLosses() {
        this.forwardBoundaries.clear();
        this.rewindBoundaries.clear();
        this.accountedNeutralLosses = null;
    }

    public void makeSequenceIndependant() {
        for (String neutralLossName : this.forwardBoundaries.keySet()) {
            this.forwardBoundaries.put(neutralLossName, 1);
            this.rewindBoundaries.put(neutralLossName, 1);
        }
    }

    public boolean isEmpty() {
        return this.forwardBoundaries.isEmpty();
    }

    public ArrayList<String> getAccountedNeutralLosses() {
        if (this.accountedNeutralLosses == null) {
            this.accountedNeutralLosses = new ArrayList<String>(this.forwardBoundaries.keySet());
        }
        return this.accountedNeutralLosses;
    }

    public Integer getForwardStart(String neutralLossName) {
        return this.forwardBoundaries.get(neutralLossName);
    }

    public int getRewindStart(String neutralLossName) {
        Integer start = this.rewindBoundaries.get(neutralLossName);
        if (start == null) {
            return 0;
        }
        return start;
    }

    public boolean containsLoss(String neutralLossName) {
        return this.forwardBoundaries.containsKey(neutralLossName);
    }

    public NeutralLossesMap clone() {
        NeutralLossesMap result = new NeutralLossesMap();
        this.getAccountedNeutralLosses().forEach(neutralLossName -> result.addNeutralLoss((String)neutralLossName, (int)this.getForwardStart((String)neutralLossName), this.getRewindStart((String)neutralLossName)));
        return result;
    }
}

