/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotation.simple_annotators;

import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.experiment.biology.ions.impl.ElementaryIon;
import com.compomics.util.experiment.biology.ions.impl.PeptideFragmentIon;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.SimplePeptideAnnotator;
import com.compomics.util.experiment.identification.utils.ModificationUtils;
import com.compomics.util.experiment.mass_spectrometry.indexes.SpectrumIndex;
import com.compomics.util.experiment.mass_spectrometry.utils.StandardMasses;
import java.util.ArrayList;
import java.util.HashMap;

public class FragmentAnnotatorNL {
    private final ModificationFactory modificationFactory = ModificationFactory.getInstance();
    private final double[] forwardIonMz1;
    private final double[] complementaryIonMz1;
    private final int peptideLength;
    private final int forwardIonType;
    private final int complementaryIonType;
    private final ArrayList<double[]> forwardNeutralLossesMasses;
    private final ArrayList<ArrayList<NeutralLoss>> forwardNeutralLosses;
    private final ArrayList<double[]> complementaryNeutralLossesMasses;
    private final ArrayList<ArrayList<NeutralLoss>> complementaryNeutralLosses;

    public FragmentAnnotatorNL() {
        this.forwardIonMz1 = null;
        this.complementaryIonMz1 = null;
        this.peptideLength = 0;
        this.forwardIonType = 0;
        this.complementaryIonType = 0;
        this.forwardNeutralLossesMasses = null;
        this.forwardNeutralLosses = null;
        this.complementaryNeutralLossesMasses = null;
        this.complementaryNeutralLosses = null;
    }

    public FragmentAnnotatorNL(Peptide peptide, String[] fixedModifications, SimplePeptideAnnotator.IonSeries ionSeries, boolean sequenceDependent) {
        double complementaryMass;
        double forwardMass;
        ModificationMatch[] modificationMatches;
        int[] sites;
        int[] nArray;
        char[] aas = peptide.getSequence().toCharArray();
        this.peptideLength = aas.length;
        this.forwardIonMz1 = new double[this.peptideLength];
        this.complementaryIonMz1 = new double[this.peptideLength];
        NeutralLoss[] losses = new NeutralLoss[]{NeutralLoss.H2O, NeutralLoss.NH3};
        int[][] lossesIndexes = new int[2][2];
        if (sequenceDependent) {
            nArray = this.getLossesIndexes(aas);
        } else {
            int[] nArray2 = new int[4];
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray2[2] = this.peptideLength;
            nArray = nArray2;
            nArray2[3] = this.peptideLength;
        }
        int[] sequenceLossesIndexes = nArray;
        lossesIndexes[0][0] = sequenceLossesIndexes[0];
        lossesIndexes[0][1] = sequenceLossesIndexes[2];
        lossesIndexes[1][0] = sequenceLossesIndexes[1];
        lossesIndexes[1][1] = sequenceLossesIndexes[3];
        double[] modificationsMasses = new double[this.peptideLength];
        HashMap<String, int[]> modificationLossesSites = new HashMap<String, int[]>(1);
        for (int i = 0; i < fixedModifications.length; ++i) {
            int site;
            ModificationMatch[] modName = fixedModifications[i];
            if (modName == null) continue;
            Modification modification = this.modificationFactory.getModification((String)modName);
            int n = site = ModificationUtils.getSite(i, this.peptideLength) - 1;
            modificationsMasses[n] = modificationsMasses[n] + modification.getMass();
            for (NeutralLoss neutralLoss : modification.getNeutralLosses()) {
                sites = (int[])modificationLossesSites.get(neutralLoss.name);
                if (sites == null) {
                    sites = new int[]{site, site};
                    modificationLossesSites.put(neutralLoss.name, sites);
                    continue;
                }
                if (site < sites[0]) {
                    sites[0] = site;
                    continue;
                }
                if (site <= sites[1]) continue;
                sites[1] = site;
            }
        }
        for (ModificationMatch modificationMatch : modificationMatches = peptide.getVariableModifications()) {
            String modificationName = modificationMatch.getModification();
            Modification modification = this.modificationFactory.getModification(modificationName);
            double modificationMass = modification.getMass();
            int i = modificationMatch.getSite();
            int site = i > 0 && i < this.peptideLength + 1 ? i - 1 : (i == 0 ? i : i - 2);
            int n = site;
            modificationsMasses[n] = modificationsMasses[n] + modificationMass;
            for (NeutralLoss neutralLoss : modification.getNeutralLosses()) {
                int[] sites2 = (int[])modificationLossesSites.get(neutralLoss.name);
                if (sites2 == null) {
                    sites2 = new int[]{site, site};
                    modificationLossesSites.put(neutralLoss.name, sites2);
                    continue;
                }
                if (site < sites2[0]) {
                    sites2[0] = site;
                    continue;
                }
                if (site <= sites2[1]) continue;
                sites2[1] = site;
            }
        }
        if (!modificationLossesSites.isEmpty()) {
            int[][] newIndexes = new int[lossesIndexes.length + modificationLossesSites.size()][2];
            System.arraycopy(lossesIndexes, 0, newIndexes, 0, lossesIndexes.length);
            NeutralLoss[] newLosses = new NeutralLoss[losses.length + modificationLossesSites.size()];
            System.arraycopy(losses, 0, newLosses, 0, losses.length);
            int index = lossesIndexes.length;
            for (String lossName : modificationLossesSites.keySet()) {
                sites = (int[])modificationLossesSites.get(lossName);
                newIndexes[index][1] = sites[0];
                newIndexes[index][1] = sites[1];
                newLosses[index] = NeutralLoss.getNeutralLoss(lossName);
                ++index;
            }
            lossesIndexes = newIndexes;
            losses = newLosses;
        }
        if (ionSeries == SimplePeptideAnnotator.IonSeries.by) {
            forwardMass = ElementaryIon.proton.getTheoreticMass();
            complementaryMass = peptide.getMass() + ElementaryIon.protonMassMultiples[2];
            this.forwardIonType = 1;
            this.complementaryIonType = 4;
        } else if (ionSeries == SimplePeptideAnnotator.IonSeries.cz) {
            forwardMass = ElementaryIon.proton.getTheoreticMass() + StandardMasses.nh3.mass;
            complementaryMass = peptide.getMass() + ElementaryIon.protonMassMultiples[2] - StandardMasses.nh3.mass;
            this.forwardIonType = 2;
            this.complementaryIonType = 5;
        } else if (ionSeries == SimplePeptideAnnotator.IonSeries.ax) {
            forwardMass = ElementaryIon.proton.getTheoreticMass() - StandardMasses.co.mass;
            complementaryMass = peptide.getMass() + ElementaryIon.protonMassMultiples[2] + StandardMasses.co.mass;
            this.forwardIonType = 0;
            this.complementaryIonType = 3;
        } else {
            throw new UnsupportedOperationException("Ion series " + (Object)((Object)ionSeries) + " not supported.");
        }
        this.forwardNeutralLossesMasses = new ArrayList(this.peptideLength);
        this.forwardNeutralLosses = new ArrayList(this.peptideLength);
        this.complementaryNeutralLossesMasses = new ArrayList(this.peptideLength);
        this.complementaryNeutralLosses = new ArrayList(this.peptideLength);
        for (int i = 0; i < this.peptideLength; ++i) {
            char aa = aas[i];
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
            forwardMass += aminoAcid.getMonoisotopicMass();
            this.forwardIonMz1[i] = forwardMass += modificationsMasses[i];
            this.complementaryIonMz1[i] = complementaryMass - forwardMass;
            ArrayList<NeutralLoss> forwardIonlosses = new ArrayList<NeutralLoss>(lossesIndexes.length);
            ArrayList<NeutralLoss> complementaryIonlosses = new ArrayList<NeutralLoss>(lossesIndexes.length);
            double[] forwardMasses = new double[lossesIndexes.length];
            double[] complementaryMasses = new double[lossesIndexes.length];
            int indexForward = 0;
            int indexComplementary = 0;
            for (int j = 0; j < lossesIndexes.length; ++j) {
                int[] indexes = lossesIndexes[j];
                NeutralLoss neutralLoss = losses[j];
                if (i >= indexes[0]) {
                    forwardIonlosses.add(neutralLoss);
                    forwardMasses[indexForward++] = neutralLoss.getMass();
                }
                if (i > indexes[j]) continue;
                complementaryIonlosses.add(neutralLoss);
                complementaryMasses[indexComplementary++] = neutralLoss.getMass();
            }
            this.forwardNeutralLossesMasses.add(forwardMasses);
            this.forwardNeutralLosses.add(forwardIonlosses);
            this.complementaryNeutralLossesMasses.add(complementaryMasses);
            this.complementaryNeutralLosses.add(complementaryIonlosses);
        }
    }

    public FragmentAnnotatorNL(Peptide peptide, String[] fixedModifications, SimplePeptideAnnotator.IonSeries ionSeries, boolean sequenceDependent, boolean forward, boolean complementary) {
        double complementaryMass;
        double forwardMass;
        ModificationMatch[] modificationMatches;
        int[] sites;
        int[] nArray;
        char[] aas = peptide.getSequence().toCharArray();
        this.peptideLength = aas.length;
        this.forwardIonMz1 = new double[this.peptideLength];
        this.complementaryIonMz1 = new double[this.peptideLength];
        NeutralLoss[] losses = new NeutralLoss[]{NeutralLoss.H2O, NeutralLoss.NH3};
        int[][] lossesIndexes = new int[2][2];
        if (sequenceDependent) {
            nArray = this.getLossesIndexes(aas);
        } else {
            int[] nArray2 = new int[4];
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray2[2] = this.peptideLength;
            nArray = nArray2;
            nArray2[3] = this.peptideLength;
        }
        int[] sequenceLossesIndexes = nArray;
        lossesIndexes[0][0] = sequenceLossesIndexes[0];
        lossesIndexes[0][1] = sequenceLossesIndexes[2];
        lossesIndexes[1][0] = sequenceLossesIndexes[1];
        lossesIndexes[1][1] = sequenceLossesIndexes[3];
        double[] modificationsMasses = new double[this.peptideLength];
        HashMap<String, int[]> modificationLossesSites = new HashMap<String, int[]>(1);
        for (int i = 0; i < fixedModifications.length; ++i) {
            int site;
            ModificationMatch[] modName = fixedModifications[i];
            if (modName == null) continue;
            Modification modification = this.modificationFactory.getModification((String)modName);
            int n = site = ModificationUtils.getSite(i, this.peptideLength) - 1;
            modificationsMasses[n] = modificationsMasses[n] + modification.getMass();
            for (NeutralLoss neutralLoss : modification.getNeutralLosses()) {
                sites = (int[])modificationLossesSites.get(neutralLoss.name);
                if (sites == null) {
                    sites = new int[]{site, site};
                    modificationLossesSites.put(neutralLoss.name, sites);
                    continue;
                }
                if (site < sites[0]) {
                    sites[0] = site;
                    continue;
                }
                if (site <= sites[1]) continue;
                sites[1] = site;
            }
        }
        for (ModificationMatch modificationMatch : modificationMatches = peptide.getVariableModifications()) {
            String modificationName = modificationMatch.getModification();
            Modification modification = this.modificationFactory.getModification(modificationName);
            double modificationMass = modification.getMass();
            int i = modificationMatch.getSite();
            int site = i > 0 && i < this.peptideLength + 1 ? i - 1 : (i == 0 ? i : i - 2);
            int n = site;
            modificationsMasses[n] = modificationsMasses[n] + modificationMass;
            for (NeutralLoss neutralLoss : modification.getNeutralLosses()) {
                int[] sites2 = (int[])modificationLossesSites.get(neutralLoss.name);
                if (sites2 == null) {
                    sites2 = new int[]{site, site};
                    modificationLossesSites.put(neutralLoss.name, sites2);
                    continue;
                }
                if (site < sites2[0]) {
                    sites2[0] = site;
                    continue;
                }
                if (site <= sites2[1]) continue;
                sites2[1] = site;
            }
        }
        if (!modificationLossesSites.isEmpty()) {
            int[][] newIndexes = new int[lossesIndexes.length + modificationLossesSites.size()][2];
            System.arraycopy(lossesIndexes, 0, newIndexes, 0, lossesIndexes.length);
            NeutralLoss[] newLosses = new NeutralLoss[losses.length + modificationLossesSites.size()];
            System.arraycopy(losses, 0, newLosses, 0, losses.length);
            int index = lossesIndexes.length;
            for (String lossName : modificationLossesSites.keySet()) {
                sites = (int[])modificationLossesSites.get(lossName);
                newIndexes[index][1] = sites[0];
                newIndexes[index][1] = sites[1];
                newLosses[index] = NeutralLoss.getNeutralLoss(lossName);
                ++index;
            }
            lossesIndexes = newIndexes;
            losses = newLosses;
        }
        if (ionSeries == SimplePeptideAnnotator.IonSeries.by) {
            forwardMass = ElementaryIon.proton.getTheoreticMass();
            complementaryMass = peptide.getMass() + ElementaryIon.protonMassMultiples[2];
            this.forwardIonType = 1;
            this.complementaryIonType = 4;
        } else if (ionSeries == SimplePeptideAnnotator.IonSeries.cz) {
            forwardMass = ElementaryIon.proton.getTheoreticMass() + StandardMasses.nh3.mass;
            complementaryMass = peptide.getMass() + ElementaryIon.protonMassMultiples[2] - StandardMasses.nh3.mass;
            this.forwardIonType = 2;
            this.complementaryIonType = 5;
        } else if (ionSeries == SimplePeptideAnnotator.IonSeries.ax) {
            forwardMass = ElementaryIon.proton.getTheoreticMass() - StandardMasses.co.mass;
            complementaryMass = peptide.getMass() + ElementaryIon.protonMassMultiples[2] + StandardMasses.co.mass;
            this.forwardIonType = 0;
            this.complementaryIonType = 3;
        } else {
            throw new UnsupportedOperationException("Ion series " + (Object)((Object)ionSeries) + " not supported.");
        }
        if (forward) {
            this.forwardNeutralLossesMasses = new ArrayList(this.peptideLength);
            this.forwardNeutralLosses = new ArrayList(this.peptideLength);
        } else {
            this.forwardNeutralLossesMasses = null;
            this.forwardNeutralLosses = null;
        }
        if (complementary) {
            this.complementaryNeutralLossesMasses = new ArrayList(this.peptideLength);
            this.complementaryNeutralLosses = new ArrayList(this.peptideLength);
        } else {
            this.complementaryNeutralLossesMasses = null;
            this.complementaryNeutralLosses = null;
        }
        for (int i = 0; i < this.peptideLength; ++i) {
            NeutralLoss neutralLoss;
            int[] indexes;
            int j;
            char aa = aas[i];
            AminoAcid aminoAcid = AminoAcid.getAminoAcid(aa);
            forwardMass += aminoAcid.getMonoisotopicMass();
            forwardMass += modificationsMasses[i];
            if (forward) {
                this.forwardIonMz1[i] = forwardMass;
                ArrayList<NeutralLoss> forwardIonlosses = new ArrayList<NeutralLoss>(lossesIndexes.length);
                double[] forwardMasses = new double[lossesIndexes.length];
                int indexForward = 0;
                for (j = 0; j < lossesIndexes.length; ++j) {
                    indexes = lossesIndexes[j];
                    neutralLoss = losses[j];
                    if (i < indexes[0]) continue;
                    forwardIonlosses.add(neutralLoss);
                    forwardMasses[indexForward++] = neutralLoss.getMass();
                }
                this.forwardNeutralLossesMasses.add(forwardMasses);
                this.forwardNeutralLosses.add(forwardIonlosses);
            }
            if (!complementary) continue;
            this.complementaryIonMz1[i] = complementaryMass - forwardMass;
            ArrayList<NeutralLoss> complementaryIonlosses = new ArrayList<NeutralLoss>(lossesIndexes.length);
            double[] complementaryMasses = new double[lossesIndexes.length];
            int indexComplementary = 0;
            for (j = 0; j < lossesIndexes.length; ++j) {
                indexes = lossesIndexes[j];
                neutralLoss = losses[j];
                if (i > indexes[j]) continue;
                complementaryIonlosses.add(neutralLoss);
                complementaryMasses[indexComplementary++] = neutralLoss.getMass();
            }
            this.complementaryNeutralLossesMasses.add(complementaryMasses);
            this.complementaryNeutralLosses.add(complementaryIonlosses);
        }
    }

    private int[] getLossesIndexes(char[] aas) {
        int[] lossesIndexes = new int[]{aas.length, aas.length, 0, 0};
        boolean waterForward = false;
        boolean ammoniaForward = false;
        boolean waterComplementary = false;
        boolean ammoniaComplementary = false;
        for (int i = 0; i < aas.length; ++i) {
            char aa = aas[i];
            if (!waterForward) {
                for (char lossAa : NeutralLoss.H2O.aminoAcids) {
                    if (aa != lossAa) continue;
                    lossesIndexes[0] = i;
                    waterForward = true;
                    break;
                }
            }
            if (!ammoniaForward) {
                for (char lossAa : NeutralLoss.NH3.aminoAcids) {
                    if (aa != lossAa) continue;
                    lossesIndexes[1] = i;
                    ammoniaForward = true;
                    break;
                }
            }
            int rewindI = aas.length - i - 1;
            aa = aas[rewindI];
            if (!waterComplementary) {
                for (char lossAa : NeutralLoss.H2O.aminoAcids) {
                    if (aa != lossAa) continue;
                    lossesIndexes[2] = rewindI;
                    waterComplementary = true;
                    break;
                }
            }
            if (!ammoniaComplementary) {
                for (char lossAa : NeutralLoss.NH3.aminoAcids) {
                    if (aa != lossAa) continue;
                    lossesIndexes[3] = rewindI;
                    ammoniaComplementary = true;
                    break;
                }
            }
            if (waterForward && ammoniaForward && waterComplementary && ammoniaComplementary) break;
        }
        return lossesIndexes;
    }

    public ArrayList<IonMatch> getIonMatches(SpectrumIndex spectrumIndex, int peptideCharge) {
        ArrayList<IonMatch> results = new ArrayList<IonMatch>(0);
        for (int i = 0; i < this.peptideLength; ++i) {
            PeptideFragmentIon ion;
            double lossMass2;
            int k;
            PeptideFragmentIon ion2;
            double ionMass;
            int[] indexes;
            double mz1WithLoss;
            double lossMass1;
            int j;
            double ionMz1 = this.forwardIonMz1[i];
            int ionNumber = i + 1;
            ArrayList<NeutralLoss> neutralLosses = this.forwardNeutralLosses.get(i);
            double[] neutralLossesMasses = this.forwardNeutralLossesMasses.get(i);
            for (j = 0; j < neutralLosses.size(); ++j) {
                lossMass1 = neutralLossesMasses[j];
                mz1WithLoss = ionMz1 - lossMass1;
                indexes = spectrumIndex.getMatchingPeaks(mz1WithLoss);
                if (indexes.length > 0) {
                    NeutralLoss[] ionLosses = new NeutralLoss[]{neutralLosses.get(j)};
                    ionMass = mz1WithLoss - ElementaryIon.proton.getTheoreticMass();
                    for (int index : indexes) {
                        ion2 = new PeptideFragmentIon(this.forwardIonType, ionNumber, ionMass, ionLosses);
                        results.add(new IonMatch(spectrumIndex.mzArray[index], spectrumIndex.intensityArray[index], ion2, 1));
                    }
                }
                for (k = j + 1; k < neutralLosses.size(); ++k) {
                    lossMass2 = neutralLossesMasses[k];
                    double mz1WithLoss2 = mz1WithLoss - lossMass2;
                    indexes = spectrumIndex.getMatchingPeaks(mz1WithLoss2);
                    if (indexes.length <= 0) continue;
                    NeutralLoss[] ionLosses = new NeutralLoss[]{neutralLosses.get(j), neutralLosses.get(k)};
                    double ionMass2 = mz1WithLoss2 - ElementaryIon.proton.getTheoreticMass();
                    for (int index : indexes) {
                        ion = new PeptideFragmentIon(this.forwardIonType, ionNumber, ionMass2, ionLosses);
                        results.add(new IonMatch(spectrumIndex.mzArray[index], spectrumIndex.intensityArray[index], ion, 1));
                    }
                }
            }
            ionMz1 = this.complementaryIonMz1[i];
            ionNumber = this.peptideLength - ionNumber;
            neutralLosses = this.complementaryNeutralLosses.get(i);
            neutralLossesMasses = this.complementaryNeutralLossesMasses.get(i);
            for (j = 0; j < neutralLosses.size(); ++j) {
                lossMass1 = neutralLossesMasses[j];
                mz1WithLoss = ionMz1 - lossMass1;
                indexes = spectrumIndex.getMatchingPeaks(mz1WithLoss);
                if (indexes.length > 0) {
                    NeutralLoss[] ionLosses = new NeutralLoss[]{neutralLosses.get(j)};
                    ionMass = mz1WithLoss - ElementaryIon.proton.getTheoreticMass();
                    for (int index : indexes) {
                        ion2 = new PeptideFragmentIon(this.complementaryIonType, ionNumber, ionMass, ionLosses);
                        results.add(new IonMatch(spectrumIndex.mzArray[index], spectrumIndex.intensityArray[index], ion2, 1));
                    }
                }
                for (k = j + 1; k < neutralLosses.size(); ++k) {
                    lossMass2 = neutralLossesMasses[k];
                    double mz1WithLoss2 = mz1WithLoss - lossMass2;
                    indexes = spectrumIndex.getMatchingPeaks(mz1WithLoss2);
                    double ionMass3 = mz1WithLoss2 - ElementaryIon.proton.getTheoreticMass();
                    if (indexes.length <= 0) continue;
                    NeutralLoss[] ionLosses = new NeutralLoss[]{neutralLosses.get(j), neutralLosses.get(k)};
                    for (int index : indexes) {
                        ion = new PeptideFragmentIon(this.complementaryIonType, ionNumber, ionMass3, ionLosses);
                        results.add(new IonMatch(spectrumIndex.mzArray[index], spectrumIndex.intensityArray[index], ion, 1));
                    }
                }
            }
        }
        for (int ionCharge = 2; ionCharge < peptideCharge; ++ionCharge) {
            int extraProtons = ionCharge - 1;
            double protonContribution = ElementaryIon.getProtonMassMultiple(extraProtons);
            for (int i = 0; i < this.peptideLength; ++i) {
                PeptideFragmentIon ion;
                double lossMass2;
                double ionMass;
                int[] indexes;
                double mzWithLoss;
                double mz1WithLoss;
                double lossMass1;
                int j;
                double ionMz1 = this.forwardIonMz1[i];
                int ionNumber = i + 1;
                ArrayList<NeutralLoss> neutralLosses = this.forwardNeutralLosses.get(i);
                double[] neutralLossesMasses = this.forwardNeutralLossesMasses.get(i);
                for (j = 0; j < neutralLosses.size(); ++j) {
                    lossMass1 = neutralLossesMasses[j];
                    mz1WithLoss = ionMz1 - lossMass1;
                    mzWithLoss = (mz1WithLoss + protonContribution) / (double)ionCharge;
                    indexes = spectrumIndex.getMatchingPeaks(mzWithLoss);
                    if (indexes.length > 0) {
                        NeutralLoss[] ionLosses = new NeutralLoss[]{neutralLosses.get(j)};
                        ionMass = mz1WithLoss - ElementaryIon.proton.getTheoreticMass();
                        for (int index : indexes) {
                            PeptideFragmentIon ion3 = new PeptideFragmentIon(this.forwardIonType, ionNumber, ionMass, ionLosses);
                            results.add(new IonMatch(spectrumIndex.mzArray[index], spectrumIndex.intensityArray[index], ion3, ionCharge));
                        }
                    }
                    for (int k = j + 1; k < neutralLosses.size(); ++k) {
                        lossMass2 = neutralLossesMasses[k];
                        double mz1WithLoss2 = mz1WithLoss - lossMass2;
                        double mzWithLoss2 = (mz1WithLoss2 + protonContribution) / (double)ionCharge;
                        indexes = spectrumIndex.getMatchingPeaks(mzWithLoss2);
                        if (indexes.length <= 0) continue;
                        NeutralLoss[] ionLosses = new NeutralLoss[]{neutralLosses.get(j), neutralLosses.get(k)};
                        double ionMass4 = mz1WithLoss2 - ElementaryIon.proton.getTheoreticMass();
                        for (int index : indexes) {
                            ion = new PeptideFragmentIon(this.forwardIonType, ionNumber, ionMass4, ionLosses);
                            results.add(new IonMatch(spectrumIndex.mzArray[index], spectrumIndex.intensityArray[index], ion, ionCharge));
                        }
                    }
                }
                ionMz1 = this.complementaryIonMz1[i];
                ionNumber = this.peptideLength - ionNumber;
                neutralLosses = this.complementaryNeutralLosses.get(i);
                neutralLossesMasses = this.complementaryNeutralLossesMasses.get(i);
                for (j = 0; j < neutralLosses.size(); ++j) {
                    lossMass1 = neutralLossesMasses[j];
                    mz1WithLoss = ionMz1 - lossMass1;
                    mzWithLoss = (mz1WithLoss + protonContribution) / (double)ionCharge;
                    indexes = spectrumIndex.getMatchingPeaks(mzWithLoss);
                    if (indexes.length > 0) {
                        NeutralLoss[] ionLosses = new NeutralLoss[]{neutralLosses.get(j)};
                        ionMass = mz1WithLoss - ElementaryIon.proton.getTheoreticMass();
                        for (int index : indexes) {
                            PeptideFragmentIon ion4 = new PeptideFragmentIon(this.complementaryIonType, ionNumber, ionMass, ionLosses);
                            results.add(new IonMatch(spectrumIndex.mzArray[index], spectrumIndex.intensityArray[index], ion4, ionCharge));
                        }
                    }
                    for (int k = j + 1; k < neutralLosses.size(); ++k) {
                        lossMass2 = neutralLossesMasses[k];
                        double mz1WithLoss2 = mz1WithLoss - lossMass2;
                        double mzWithLoss2 = (mz1WithLoss2 + protonContribution) / (double)ionCharge;
                        indexes = spectrumIndex.getMatchingPeaks(mzWithLoss2);
                        double ionMass5 = mz1WithLoss2 - ElementaryIon.proton.getTheoreticMass();
                        if (indexes.length <= 0) continue;
                        NeutralLoss[] ionLosses = new NeutralLoss[]{neutralLosses.get(j), neutralLosses.get(k)};
                        for (int index : indexes) {
                            ion = new PeptideFragmentIon(this.complementaryIonType, ionNumber, ionMass5, ionLosses);
                            results.add(new IonMatch(spectrumIndex.mzArray[index], spectrumIndex.intensityArray[index], ion, ionCharge));
                        }
                    }
                }
            }
        }
        return results;
    }
}

