/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identification;

import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.enzymes.EnzymeFactory;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class MzIdentMLIdfileSearchParametersConverter
extends ExperimentObject {
    private File mzIdentMLFile;
    private SearchParameters searchParameters;
    private String species;
    private WaitingHandler waitingHandler;
    private String parametersReport;

    public MzIdentMLIdfileSearchParametersConverter(File mzIdentMLFile, SearchParameters searchParameters, String species, WaitingHandler waitingHandler) throws IOException {
        this.mzIdentMLFile = mzIdentMLFile;
        this.searchParameters = searchParameters;
        this.species = species;
        this.waitingHandler = waitingHandler;
    }

    public String getSearchParameters() throws FileNotFoundException, IOException, ClassNotFoundException, XmlPullParserException {
        this.parametersReport = "<br><b><u>Extracted Search Parameters</u></b><br>";
        if (this.waitingHandler != null) {
            this.waitingHandler.setSecondaryProgressCounterIndeterminate(true);
            try (SimpleFileReader reader = SimpleFileReader.getFileReader(this.mzIdentMLFile);){
                int lineCounter = 0;
                String line = reader.readLine();
                while (line != null) {
                    line = reader.readLine();
                    ++lineCounter;
                }
                this.waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                this.waitingHandler.setMaxSecondaryProgressCounter(lineCounter);
            }
        }
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        try (SimpleFileReader reader = SimpleFileReader.getFileReader(this.mzIdentMLFile);){
            parser.setInput(reader.getReader());
            int type = parser.next();
            while (type != 1) {
                if (type == 2 && parser.getName().equals("Enzymes")) {
                    this.parseEnzymes(parser);
                } else if (type == 2 && parser.getName().equals("FragmentTolerance")) {
                    this.parseFragmentTolerance(parser);
                } else if (type == 2 && parser.getName().equals("ParentTolerance")) {
                    this.parseParentTolerance(parser);
                }
                type = parser.next();
                if (this.waitingHandler == null) continue;
                this.waitingHandler.setSecondaryProgressCounter(parser.getLineNumber());
            }
        }
        this.parametersReport = this.parametersReport + "<br><br><b>Min Precusor Charge:</b> ";
        this.parametersReport = this.parametersReport + this.searchParameters.getMinChargeSearched() + " (default)";
        this.parametersReport = this.parametersReport + "<br><b>Max Precusor Charge:</b> ";
        this.parametersReport = this.parametersReport + this.searchParameters.getMaxChargeSearched() + " (default)";
        this.parametersReport = this.parametersReport + "<br><br><b>Species:</b> ";
        this.parametersReport = this.species == null || this.species.length() == 0 ? this.parametersReport + "unknown" : this.parametersReport + this.species;
        return this.parametersReport;
    }

    private void parseEnzymes(XmlPullParser parser) throws XmlPullParserException, IOException {
        parser.next();
        parser.next();
        this.parametersReport = this.parametersReport + "<br><br><b>Digestion:</b> ";
        DigestionParameters digestionPreferences = DigestionParameters.getDefaultParameters();
        boolean enzymesFound = false;
        while (parser.getName() != null && parser.getName().equalsIgnoreCase("Enzyme")) {
            String enzymeName = null;
            Integer nMissedCleavages = null;
            Boolean semiSpecific = null;
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                String attributeName = parser.getAttributeName(i);
                if (attributeName.equalsIgnoreCase("missedCleavages")) {
                    nMissedCleavages = Integer.valueOf(parser.getAttributeValue(i));
                    continue;
                }
                if (attributeName.equalsIgnoreCase("semiSpecific")) {
                    semiSpecific = Boolean.valueOf(parser.getAttributeValue(i));
                    continue;
                }
                if (!attributeName.equalsIgnoreCase("name")) continue;
                enzymeName = parser.getAttributeValue(i);
            }
            if (enzymeName != null) {
                String utilitiesEnzymeName;
                enzymesFound = true;
                Enzyme utilitiesEnzyme = EnzymeFactory.getInstance().getEnzyme(enzymeName);
                if (utilitiesEnzyme != null) {
                    utilitiesEnzymeName = utilitiesEnzyme.getName();
                    this.parametersReport = this.parametersReport + utilitiesEnzyme.getName();
                } else {
                    utilitiesEnzymeName = "Trypsin";
                    utilitiesEnzyme = EnzymeFactory.getInstance().getEnzyme(utilitiesEnzymeName);
                    this.parametersReport = this.parametersReport + utilitiesEnzyme.getName() + " (assumed)";
                }
                this.parametersReport = this.parametersReport + ", ";
                if (nMissedCleavages != null) {
                    this.parametersReport = this.parametersReport + nMissedCleavages;
                } else {
                    nMissedCleavages = 2;
                    this.parametersReport = this.parametersReport + nMissedCleavages + " (assumed)";
                }
                this.parametersReport = this.parametersReport + ", ";
                DigestionParameters.Specificity specificity = DigestionParameters.Specificity.specific;
                if (semiSpecific != null) {
                    if (semiSpecific.booleanValue()) {
                        specificity = DigestionParameters.Specificity.semiSpecific;
                    }
                    this.parametersReport = this.parametersReport + (Object)((Object)specificity);
                } else {
                    this.parametersReport = this.parametersReport + (Object)((Object)specificity) + " (assumed)";
                }
                digestionPreferences.addEnzyme(utilitiesEnzyme);
                digestionPreferences.setSpecificity(utilitiesEnzymeName, specificity);
                digestionPreferences.setnMissedCleavages(utilitiesEnzymeName, nMissedCleavages);
                digestionPreferences.setCleavageParameter(DigestionParameters.CleavageParameter.enzyme);
            }
            parser.next();
            while (parser.getName() != null && !parser.getName().equalsIgnoreCase("Enzyme")) {
                parser.next();
            }
            parser.next();
        }
        if (!enzymesFound) {
            this.parametersReport = this.parametersReport + "Trypsin (assumed), 2 allowed missed cleavages (assumed), specific (assumed)";
        }
        this.searchParameters.setDigestionParameters(digestionPreferences);
    }

    private void parseFragmentTolerance(XmlPullParser parser) throws XmlPullParserException, IOException {
        Double fragmentMinTolerance = null;
        Double fragmentMaxTolerance = null;
        Boolean fragmentToleranceTypeIsPpm = false;
        parser.next();
        parser.next();
        while (parser.getName() != null && parser.getName().equals("cvParam")) {
            String accession = null;
            String unit = null;
            Double value = null;
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                String attributeName = parser.getAttributeName(i);
                if (attributeName.equalsIgnoreCase("accession")) {
                    accession = parser.getAttributeValue(i);
                    continue;
                }
                if (attributeName.equalsIgnoreCase("unitAccession")) {
                    unit = parser.getAttributeValue(i);
                    continue;
                }
                if (!attributeName.equalsIgnoreCase("value")) continue;
                value = Double.valueOf(parser.getAttributeValue(i));
            }
            if (accession != null && unit != null && value != null) {
                if (accession.equalsIgnoreCase("MS:1001412")) {
                    fragmentMaxTolerance = value;
                    fragmentToleranceTypeIsPpm = unit.equalsIgnoreCase("UO:0000169");
                } else if (accession.equalsIgnoreCase("MS:1001413")) {
                    fragmentMinTolerance = value;
                    fragmentToleranceTypeIsPpm = unit.equalsIgnoreCase("UO:0000169");
                }
            }
            parser.next();
            parser.next();
            parser.next();
        }
        parser.next();
        this.parametersReport = this.parametersReport + "<br><b>Fragment Ion Mass Tolerance:</b> ";
        if (fragmentMinTolerance != null && fragmentMaxTolerance != null) {
            Double fragmentTolerance = Math.abs(fragmentMinTolerance) - Math.abs(fragmentMaxTolerance) < 1.0E-7 ? Double.valueOf(Math.abs(fragmentMinTolerance)) : Double.valueOf(Math.max(Math.abs(fragmentMinTolerance), Math.abs(fragmentMaxTolerance)));
            this.searchParameters.setFragmentIonAccuracy(fragmentTolerance);
            if (fragmentToleranceTypeIsPpm.booleanValue()) {
                this.searchParameters.setFragmentAccuracyType(SearchParameters.MassAccuracyType.PPM);
                this.parametersReport = this.parametersReport + fragmentTolerance + " ppm";
            } else {
                this.searchParameters.setFragmentAccuracyType(SearchParameters.MassAccuracyType.DA);
                this.parametersReport = this.parametersReport + fragmentTolerance + " Da";
            }
        } else {
            this.parametersReport = this.parametersReport + this.searchParameters.getFragmentIonAccuracy() + " Da (default)";
        }
    }

    private void parseParentTolerance(XmlPullParser parser) throws XmlPullParserException, IOException {
        Double precursorMinTolerance = null;
        Double precursorMaxTolerance = null;
        Boolean precursorToleranceTypeIsPpm = false;
        parser.next();
        parser.next();
        while (parser.getName() != null && parser.getName().equals("cvParam")) {
            String accession = null;
            String unit = null;
            Double value = null;
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                String attributeName = parser.getAttributeName(i);
                if (attributeName.equalsIgnoreCase("accession")) {
                    accession = parser.getAttributeValue(i);
                    continue;
                }
                if (attributeName.equalsIgnoreCase("unitAccession")) {
                    unit = parser.getAttributeValue(i);
                    continue;
                }
                if (!attributeName.equalsIgnoreCase("value")) continue;
                value = Double.valueOf(parser.getAttributeValue(i));
            }
            if (accession != null && unit != null && value != null) {
                if (accession.equalsIgnoreCase("MS:1001412")) {
                    precursorMaxTolerance = value;
                    precursorToleranceTypeIsPpm = unit.equalsIgnoreCase("UO:0000169");
                } else if (accession.equalsIgnoreCase("MS:1001413")) {
                    precursorMinTolerance = value;
                    precursorToleranceTypeIsPpm = unit.equalsIgnoreCase("UO:0000169");
                }
            }
            parser.next();
            parser.next();
            parser.next();
        }
        parser.next();
        this.parametersReport = this.parametersReport + "<br><b>Precursor Ion Mass Tolerance:</b> ";
        if (precursorMinTolerance != null && precursorMaxTolerance != null) {
            Double precursorTolerance = Math.abs(precursorMinTolerance) - Math.abs(precursorMaxTolerance) < 1.0E-7 ? Double.valueOf(Math.abs(precursorMinTolerance)) : Double.valueOf(Math.max(Math.abs(precursorMinTolerance), Math.abs(precursorMaxTolerance)));
            this.searchParameters.setPrecursorAccuracy(precursorTolerance);
            if (precursorToleranceTypeIsPpm.booleanValue()) {
                this.searchParameters.setPrecursorAccuracyType(SearchParameters.MassAccuracyType.PPM);
                this.parametersReport = this.parametersReport + precursorTolerance + " ppm";
            } else {
                this.searchParameters.setPrecursorAccuracyType(SearchParameters.MassAccuracyType.DA);
                this.parametersReport = this.parametersReport + precursorTolerance + " Da";
            }
        } else {
            this.parametersReport = this.parametersReport + this.searchParameters.getPrecursorAccuracy() + " Da (default)";
        }
    }
}

