/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identification.idfilereaders;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.identification.IdfileReader;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.math.NumberUtils;

public class CossIdfileReader
implements IdfileReader {
    private final String SOFTWARE_NAME = "COSS";
    private String softwareVersion = null;
    private File cossTsvFile;
    private final ModificationFactory modificationFactory = ModificationFactory.getInstance();

    public CossIdfileReader() {
    }

    public CossIdfileReader(File cossTsvFile) throws IOException {
        this(cossTsvFile, null);
    }

    public CossIdfileReader(File cossTsvFile, WaitingHandler waitingHandler) throws IOException {
        this.cossTsvFile = cossTsvFile;
    }

    private void extractVersionNumber() {
        try (SimpleFileReader reader = SimpleFileReader.getFileReader(this.cossTsvFile);){
            String versionNumberString = reader.readLine();
            if (versionNumberString.toLowerCase().startsWith("#version: ")) {
                this.softwareVersion = versionNumberString.substring("#version: ".length()).trim();
            }
        }
    }

    @Override
    public String getExtension() {
        return ".coss.tsv";
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        return this.getAllSpectrumMatches(spectrumProvider, waitingHandler, searchParameters, null, true);
    }

    @Override
    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingParameters sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        ArrayList<SpectrumMatch> result = new ArrayList<SpectrumMatch>();
        try (SimpleFileReader reader = SimpleFileReader.getFileReader(this.cossTsvFile);){
            String line;
            String versionNumberString = reader.readLine();
            String headerString = versionNumberString.toLowerCase().startsWith("#version: ") ? reader.readLine() : versionNumberString;
            String[] headers = headerString.split("\t");
            int fileIndex = -1;
            int titleIndex = -1;
            int rankIndex = -1;
            int libraryIndex = -1;
            int scanNumberIndex = -1;
            int rtIndex = -1;
            int sequenceIndex = -1;
            int precMassIndex = -1;
            int chargeQueryIndex = -1;
            int chargeLibIndex = -1;
            int cossScoreIndex = -1;
            int validationFdrIndex = -1;
            int modificationsIndex = -1;
            int proteinsIndex = -1;
            int filteredQueryPeaksIndex = -1;
            int filteredLibraryPeaksIndex = -1;
            int sumIntQueryIndex = -1;
            int sumIntLibIndex = -1;
            int matchedPeaksIndex = -1;
            int matchedIntQueryIndex = -1;
            int matchedIntLibIndex = -1;
            for (int i = 0; i < headers.length; ++i) {
                String header = headers[i];
                if (header.equalsIgnoreCase("File")) {
                    fileIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("Title")) {
                    titleIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("Rank")) {
                    rankIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("Library")) {
                    libraryIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("Scan No.")) {
                    scanNumberIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("RetentionT")) {
                    rtIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("Sequence")) {
                    sequenceIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("RetentionT")) {
                    rtIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("Prec. Mass")) {
                    precMassIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("ChargeQuery")) {
                    chargeQueryIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("ChargeLib")) {
                    chargeLibIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("Score")) {
                    cossScoreIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("Validation(FDR)")) {
                    validationFdrIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("Mods")) {
                    modificationsIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("Protein Accessions")) {
                    proteinsIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("#filteredQueryPeaks")) {
                    filteredQueryPeaksIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("#filteredLibraryPeaks")) {
                    filteredLibraryPeaksIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("SumIntQuery")) {
                    sumIntQueryIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("SumIntLib")) {
                    sumIntLibIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("#MatchedPeaks")) {
                    matchedPeaksIndex = i;
                    continue;
                }
                if (header.equalsIgnoreCase("MatchedIntQuery")) {
                    matchedIntQueryIndex = i;
                    continue;
                }
                if (!header.equalsIgnoreCase("MatchedIntLib")) continue;
                matchedIntLibIndex = i;
            }
            if (fileIndex == -1 || titleIndex == -1 || rankIndex == -1 || sequenceIndex == -1 || modificationsIndex == -1 || cossScoreIndex == -1 || chargeLibIndex == -1 || validationFdrIndex == -1) {
                throw new IllegalArgumentException("Mandatory columns are missing in the COSS tsv file. Please check the file!");
            }
            String currentSpectrumTitle = null;
            SpectrumMatch currentMatch = null;
            while ((line = reader.readLine()) != null) {
                String[] elements = line.split("\t");
                if (line.trim().isEmpty()) continue;
                String spectrumFileName = elements[fileIndex];
                String spectrumTitle = elements[titleIndex].trim();
                spectrumTitle = URLDecoder.decode(spectrumTitle, "utf-8");
                if (currentMatch == null || currentSpectrumTitle != null && !currentSpectrumTitle.equalsIgnoreCase(spectrumTitle)) {
                    if (currentMatch != null) {
                        result.add(currentMatch);
                    }
                    currentMatch = new SpectrumMatch(spectrumFileName, spectrumTitle);
                    currentSpectrumTitle = spectrumTitle;
                }
                String peptideSequence = elements[sequenceIndex].toUpperCase();
                int rank = Integer.valueOf(elements[rankIndex]);
                int charge = Integer.valueOf(elements[chargeLibIndex]);
                String scoreAsText = elements[cossScoreIndex];
                double cossRawScore = Util.readDoubleAsString(scoreAsText);
                double cossTransformedScore = Math.pow(10.0, -cossRawScore);
                String modifications = elements[modificationsIndex].trim();
                ArrayList<ModificationMatch> utilitiesModifications = new ArrayList<ModificationMatch>(1);
                if (!modifications.isEmpty() && !modifications.equalsIgnoreCase("0")) {
                    String[] modificationsString;
                    modifications = modifications.substring(modifications.indexOf("/") + 1);
                    for (String tempModAsString : modificationsString = modifications.split("/")) {
                        String[] modificationElements = tempModAsString.split(",");
                        if (modificationElements.length != 3) continue;
                        int modSite = Integer.valueOf(modificationElements[0]);
                        char target = peptideSequence.charAt(modSite);
                        if (NumberUtils.isCreatable((String)modificationElements[2])) {
                            double modMass = Double.parseDouble(modificationElements[2]);
                            utilitiesModifications.add(new ModificationMatch(modMass + "@" + target, modSite + 1));
                            continue;
                        }
                        String modName = modificationElements[2];
                        modName = modName.endsWith("yl") || modName.endsWith("tyl") || modName.endsWith("thyl") ? modName + "ation of " : (modName.equalsIgnoreCase("Phospho") ? "Phosphorylation of " : (modName.equalsIgnoreCase("Pyro-glu") || modName.equalsIgnoreCase("Pyro_glu") ? "Pyrolidone from " : (modName.startsWith("iTRAQ4plex") ? "iTRAQ 4-plex of " : (modName.startsWith("iTRAQ8plex") ? "iTRAQ 8-plex of " : (modName.startsWith("TMT6plex") ? "TMT 6-plex of " : modName + " of ")))));
                        String tempTarget = String.valueOf(target);
                        String modNameAtTarget = modName + tempTarget;
                        String modNameAtNTerminal = modName + "peptide N-term";
                        String modNameAtCTerminal = modName + "peptide C-term";
                        Modification utilitiesMod = this.modificationFactory.getModification(modNameAtTarget);
                        if (utilitiesMod == null && modSite == 0) {
                            utilitiesMod = this.modificationFactory.getModification(modNameAtNTerminal);
                        }
                        if (utilitiesMod == null && modSite == peptideSequence.length() - 1) {
                            utilitiesMod = this.modificationFactory.getModification(modNameAtCTerminal);
                        }
                        if (utilitiesMod != null) {
                            utilitiesModifications.add(new ModificationMatch(utilitiesMod.getMass() + "@" + target, modSite + 1));
                            continue;
                        }
                        utilitiesModifications.add(new ModificationMatch("10000@" + target, modSite + 1));
                    }
                }
                Peptide peptide = new Peptide(peptideSequence, utilitiesModifications.toArray(new ModificationMatch[utilitiesModifications.size()]), true);
                PeptideAssumption peptideAssumption = new PeptideAssumption(peptide, rank, Advocate.coss.getIndex(), charge, cossRawScore, cossTransformedScore, IoUtil.getFileName(this.cossTsvFile));
                if (expandAaCombinations && AminoAcidSequence.hasCombination(peptideSequence)) {
                    ModificationMatch[] previousModificationMatches = peptide.getVariableModifications();
                    for (StringBuilder expandedSequence : AminoAcidSequence.getCombinations(peptide.getSequence())) {
                        ModificationMatch[] newModificationMatches = (ModificationMatch[])Arrays.stream(previousModificationMatches).map(modificationMatch -> modificationMatch.clone()).toArray(ModificationMatch[]::new);
                        Peptide newPeptide = new Peptide(expandedSequence.toString(), newModificationMatches, true);
                        PeptideAssumption newAssumption = new PeptideAssumption(newPeptide, peptideAssumption.getRank(), peptideAssumption.getAdvocate(), peptideAssumption.getIdentificationCharge(), peptideAssumption.getRawScore(), peptideAssumption.getScore(), peptideAssumption.getIdentificationFile());
                        currentMatch.addPeptideAssumption(Advocate.msAmanda.getIndex(), newAssumption);
                    }
                } else {
                    currentMatch.addPeptideAssumption(Advocate.coss.getIndex(), peptideAssumption);
                }
                if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
                break;
            }
            if (currentMatch != null) {
                result.add(currentMatch);
            }
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.cossTsvFile = null;
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        ArrayList<String> versions = new ArrayList<String>();
        versions.add(this.softwareVersion);
        result.put("COSS", versions);
        return result;
    }

    @Override
    public boolean hasDeNovoTags() {
        return false;
    }
}

