/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.mass_spectrometry.indexes;

import com.compomics.util.experiment.mass_spectrometry.spectra.Precursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.math.util.FastMath;

public class PrecursorMap {
    double precursorTolerance;
    boolean ppm;
    private final HashMap<Integer, HashMap<Double, ArrayList<PrecursorWithTitle>>> precursorsMap = new HashMap();
    private static final double mzAnchor = 1000.0;
    private static final double mzAnchorLog = FastMath.log((double)1000.0);
    private double scalingFactor;
    private Double minMz = null;
    private Double maxMz = null;

    public PrecursorMap() {
    }

    public PrecursorMap(HashMap<String, Precursor> precursors, double precursorTolerance, boolean ppm) {
        this.precursorTolerance = precursorTolerance;
        this.ppm = ppm;
        if (ppm) {
            this.scalingFactor = FastMath.log((double)((1000000.0 - precursorTolerance) / (1000000.0 + precursorTolerance)));
        }
        for (String spectrumTitle : precursors.keySet()) {
            ArrayList<PrecursorWithTitle> precursorsAtMz;
            Integer bin;
            HashMap<Double, ArrayList<PrecursorWithTitle>> precursorsInBin;
            Precursor precursor = precursors.get(spectrumTitle);
            PrecursorWithTitle precursorWithTitle = new PrecursorWithTitle(precursor, spectrumTitle);
            double mz = precursor.mz;
            if (this.minMz == null || mz < this.minMz) {
                this.minMz = mz;
            }
            if (this.maxMz == null || mz > this.maxMz) {
                this.maxMz = mz;
            }
            if ((precursorsInBin = this.precursorsMap.get(bin = this.getBin(mz))) == null) {
                precursorsInBin = new HashMap(2);
                this.precursorsMap.put(bin, precursorsInBin);
            }
            if ((precursorsAtMz = precursorsInBin.get(mz)) == null) {
                precursorsAtMz = new ArrayList(1);
                precursorsInBin.put(mz, precursorsAtMz);
            }
            precursorsAtMz.add(precursorWithTitle);
        }
    }

    private Integer getBin(double mz) {
        if (this.ppm) {
            return this.getBinPpm(mz);
        }
        return this.getBinAbsolute(mz);
    }

    private Integer getBinAbsolute(double mz) {
        Integer bin = (int)(mz / this.precursorTolerance);
        return bin;
    }

    private Integer getBinPpm(double mz) {
        int bin = (int)((FastMath.log((double)mz) - mzAnchorLog) / this.scalingFactor);
        return bin;
    }

    public ArrayList<PrecursorWithTitle> getMatchingSpectra(double referenceMz) {
        double error;
        int bin0 = this.getBin(referenceMz);
        ArrayList<PrecursorWithTitle> result = new ArrayList<PrecursorWithTitle>(0);
        HashMap<Double, ArrayList<PrecursorWithTitle>> binContent = this.precursorsMap.get(bin0 - 1);
        if (binContent != null) {
            for (Double precursorMz : binContent.keySet()) {
                error = this.ppm ? 1000000.0 * (precursorMz - referenceMz) / referenceMz : precursorMz - referenceMz;
                if (!(Math.abs(error) <= this.precursorTolerance)) continue;
                result.addAll((Collection<PrecursorWithTitle>)binContent.get(precursorMz));
            }
        }
        if ((binContent = this.precursorsMap.get(bin0)) != null) {
            for (Double precursorMz : binContent.keySet()) {
                error = this.ppm ? 1000000.0 * (precursorMz - referenceMz) / referenceMz : precursorMz - referenceMz;
                if (!(Math.abs(error) <= this.precursorTolerance)) continue;
                result.addAll((Collection<PrecursorWithTitle>)binContent.get(precursorMz));
            }
        }
        if ((binContent = this.precursorsMap.get(bin0 + 1)) != null) {
            for (Double precursorMz : binContent.keySet()) {
                error = this.ppm ? 1000000.0 * (precursorMz - referenceMz) / referenceMz : precursorMz - referenceMz;
                if (!(Math.abs(error) <= this.precursorTolerance)) continue;
                result.addAll((Collection<PrecursorWithTitle>)binContent.get(precursorMz));
            }
        }
        return result;
    }

    public ArrayList<Integer> getBins() {
        return new ArrayList<Integer>(this.precursorsMap.keySet());
    }

    public HashMap<Double, ArrayList<PrecursorWithTitle>> getPrecursorsInBin(int bin) {
        return this.precursorsMap.get(bin);
    }

    public Double getMass(int bin) {
        if (this.ppm) {
            return FastMath.exp((double)(this.scalingFactor * (double)bin + mzAnchorLog));
        }
        return this.precursorTolerance * (0.5 + (double)bin);
    }

    public Double getMinMz() {
        return this.minMz;
    }

    public Double getMaxMz() {
        return this.maxMz;
    }

    public class PrecursorWithTitle {
        public final Precursor precursor;
        public final String spectrumTitle;

        public PrecursorWithTitle(Precursor precursor, String spectrumTitle) {
            this.precursor = precursor;
            this.spectrumTitle = spectrumTitle;
        }
    }
}

