/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.mass_spectrometry.spectra;

import com.compomics.util.experiment.mass_spectrometry.spectra.Precursor;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Spectrum
extends ExperimentObject {
    public Precursor precursor;
    public double[] mz;
    public double[] intensity;
    private Integer spectrumLevel = null;

    public Spectrum() {
        this.mz = new double[0];
        this.intensity = new double[0];
        this.precursor = null;
        this.spectrumLevel = null;
    }

    public Spectrum(Precursor precursor, double[] mz, double[] intensities, int spectrumLevel) {
        this.precursor = precursor;
        this.mz = mz;
        this.intensity = intensities;
        this.spectrumLevel = spectrumLevel;
    }

    public String getPeakListAsString() {
        return IntStream.range(0, this.mz.length).mapToObj(i -> String.join((CharSequence)"", "[", Double.toString(this.mz[i]), " ", Double.toString(this.intensity[i]), "]")).collect(Collectors.joining(",", "[", "]"));
    }

    public double getTotalIntensity() {
        return Arrays.stream(this.intensity).sum();
    }

    public double getMaxIntensity() {
        return Arrays.stream(this.intensity).max().orElse(0.0);
    }

    public double getMaxMz() {
        return this.mz[this.mz.length - 1];
    }

    public double getMinMz() {
        return this.mz[0];
    }

    public Precursor getPrecursor() {
        return this.precursor;
    }

    public int getNPeaks() {
        return this.mz.length;
    }

    public boolean isSameAs(Spectrum otherSpectrum) {
        if (this.precursor == null && otherSpectrum.precursor != null || this.precursor != null && otherSpectrum.precursor == null || this.precursor != null && otherSpectrum.precursor != null && !this.precursor.isSameAs(otherSpectrum.precursor)) {
            return false;
        }
        if (this.getNPeaks() != otherSpectrum.getNPeaks()) {
            return false;
        }
        for (int i = 0; i < this.getNPeaks(); ++i) {
            if (this.mz[i] == otherSpectrum.mz[i] && this.intensity[i] == otherSpectrum.intensity[i]) continue;
            return false;
        }
        return this.getSpectrumLevel() == otherSpectrum.getSpectrumLevel();
    }

    public String toString() {
        if (this.precursor != null) {
            return "{precursor: " + this.precursor.toString() + "}{spectrum level: " + this.spectrumLevel + "}{Peaks: " + this.getPeakListAsString() + "}";
        }
        return "{precursor: none}{spectrum level: " + this.spectrumLevel + "}{Peaks: " + this.getPeakListAsString() + "}";
    }

    public int getSpectrumLevel() {
        return this.spectrumLevel;
    }

    public void setSpectrumLevel(int spectrumLevel) {
        this.spectrumLevel = spectrumLevel;
    }
}

