/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification.advanced;

import com.compomics.util.experiment.identification.modification.ModificationLocalizationScore;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.parameters.identification.advanced.ModificationLocalizationParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ModificationLocalizationParametersDialog
extends JDialog {
    private Frame parentFrame;
    private boolean canceled = false;
    private boolean editable;
    private JComboBox alignOnConfidentCmb;
    private JLabel alignOnConfidentLbl;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JButton helpJButton;
    private JSeparator jSeparator1;
    private JComboBox neutralLossesCmb;
    private JLabel neutralLossesLabel;
    private JButton okButton;
    private JPanel ptmScoringPanel;
    private JComboBox scoreCmb;
    private JLabel scoreTypeLabel;
    private JPanel siteAlignmentPanel;
    private JLabel thresholdLabel;
    private JTextField thresholdTxt;

    public ModificationLocalizationParametersDialog() {
    }

    public ModificationLocalizationParametersDialog(Frame parentFrame, ModificationLocalizationParameters ptmScoringPreferences, boolean editable) {
        super(parentFrame, true);
        this.parentFrame = parentFrame;
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.populateGUI(ptmScoringPreferences);
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    public ModificationLocalizationParametersDialog(Dialog owner, Frame parentFrame, ModificationLocalizationParameters ptmScoringPreferences, boolean editable) {
        super(owner, true);
        this.parentFrame = parentFrame;
        this.editable = editable;
        this.initComponents();
        this.setUpGui();
        this.populateGUI(ptmScoringPreferences);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.neutralLossesCmb.setRenderer(new AlignedListCellRenderer(0));
        this.alignOnConfidentCmb.setRenderer(new AlignedListCellRenderer(0));
        this.scoreCmb.setRenderer(new AlignedListCellRenderer(0));
        this.scoreCmb.setEnabled(this.editable);
        this.neutralLossesCmb.setEnabled(this.editable);
        this.alignOnConfidentCmb.setEnabled(this.editable);
        this.thresholdTxt.setEditable(this.editable);
        this.thresholdTxt.setEnabled(this.editable);
    }

    private void populateGUI(ModificationLocalizationParameters ptmScoringPreferences) {
        this.scoreCmb.setSelectedItem((Object)ptmScoringPreferences.getSelectedProbabilisticScore());
        if (ptmScoringPreferences.isProbabilisticScoreCalculation()) {
            this.scoreCmb.setEnabled(this.editable);
            this.neutralLossesCmb.setEnabled(this.editable);
            if (ptmScoringPreferences.isProbabilisticScoreNeutralLosses()) {
                this.neutralLossesCmb.setSelectedIndex(0);
            } else {
                this.neutralLossesCmb.setSelectedIndex(1);
            }
            this.thresholdTxt.setEnabled(this.editable);
            this.thresholdTxt.setEditable(this.editable);
            this.thresholdTxt.setText(ptmScoringPreferences.getProbabilisticScoreThreshold() + "");
        } else {
            this.neutralLossesCmb.setEnabled(false);
            this.thresholdTxt.setEnabled(false);
            this.thresholdTxt.setEditable(false);
        }
        if (ptmScoringPreferences.getAlignNonConfidentModifications()) {
            this.alignOnConfidentCmb.setSelectedIndex(0);
        } else {
            this.alignOnConfidentCmb.setSelectedIndex(1);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean validateInput() {
        int outcome;
        try {
            Double temp;
            if (this.scoreCmb.getSelectedItem() != ModificationLocalizationScore.None && ((temp = Double.valueOf(this.thresholdTxt.getText().trim())) < 0.0 || temp > 100.0)) {
                JOptionPane.showMessageDialog(this, "Please verify the input for the score threshold.", "Input Error", 0);
                this.thresholdTxt.requestFocus();
                return false;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the score threshold.", "Input Error", 0);
            this.thresholdTxt.requestFocus();
            return false;
        }
        if (this.scoreCmb.getSelectedItem() == ModificationLocalizationScore.None && ((outcome = JOptionPane.showConfirmDialog(this, "Disabling the probabilistic score will impair PTM localization and thus distinction\nbetween peptides. See help for more details. Continue with this setting?", "Warning", 2)) == 2 || outcome == -1)) {
            return false;
        }
        return this.scoreCmb.getSelectedItem() == ModificationLocalizationScore.None || this.neutralLossesCmb.getSelectedIndex() != 0 || (outcome = JOptionPane.showConfirmDialog(this, "In our experience probabilistic scores perform poorly when accounting for\nneutral losses. See help for more details. Continue with this setting?", "Warning", 2)) != 2 && outcome != -1;
    }

    public ModificationLocalizationParameters getPtmScoringPreferences() {
        ModificationLocalizationParameters ptmScoringPreferences = new ModificationLocalizationParameters();
        ptmScoringPreferences.setProbabilisticScoreCalculation(this.scoreCmb.getSelectedItem() != ModificationLocalizationScore.None);
        ptmScoringPreferences.setSelectedProbabilisticScore((ModificationLocalizationScore)((Object)this.scoreCmb.getSelectedItem()));
        ptmScoringPreferences.setProbabilisticScoreNeutralLosses(this.neutralLossesCmb.getSelectedIndex() == 0);
        if (!this.thresholdTxt.getText().isEmpty()) {
            ptmScoringPreferences.setProbabilisticScoreThreshold(Double.valueOf(this.thresholdTxt.getText().trim()));
        }
        ptmScoringPreferences.setAlignNonConfidentModifications(this.alignOnConfidentCmb.getSelectedIndex() == 0);
        return ptmScoringPreferences;
    }

    private void initComponents() {
        this.jSeparator1 = new JSeparator();
        this.backgroundPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.ptmScoringPanel = new JPanel();
        this.scoreCmb = new JComboBox();
        this.thresholdTxt = new JTextField();
        this.thresholdLabel = new JLabel();
        this.scoreTypeLabel = new JLabel();
        this.neutralLossesLabel = new JLabel();
        this.neutralLossesCmb = new JComboBox();
        this.siteAlignmentPanel = new JPanel();
        this.alignOnConfidentLbl = new JLabel();
        this.alignOnConfidentCmb = new JComboBox();
        this.helpJButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("PTM Localization");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ModificationLocalizationParametersDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationLocalizationParametersDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationLocalizationParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.ptmScoringPanel.setBorder(BorderFactory.createTitledBorder("Modificatoin Scoring"));
        this.ptmScoringPanel.setOpaque(false);
        this.scoreCmb.setModel(new DefaultComboBoxModel<ModificationLocalizationScore>(ModificationLocalizationScore.values()));
        this.scoreCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationLocalizationParametersDialog.this.scoreCmbActionPerformed(evt);
            }
        });
        this.thresholdTxt.setHorizontalAlignment(0);
        this.thresholdLabel.setText("Threshold (Inclusive)");
        this.scoreTypeLabel.setText("Probabilistic Score");
        this.neutralLossesLabel.setText("Account Neutral Losses");
        this.neutralLossesCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        GroupLayout ptmScoringPanelLayout = new GroupLayout(this.ptmScoringPanel);
        this.ptmScoringPanel.setLayout(ptmScoringPanelLayout);
        ptmScoringPanelLayout.setHorizontalGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ptmScoringPanelLayout.createSequentialGroup().addContainerGap().addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ptmScoringPanelLayout.createSequentialGroup().addComponent(this.neutralLossesLabel, -2, 150, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 37, Short.MAX_VALUE).addComponent(this.neutralLossesCmb, -2, 150, -2)).addGroup(ptmScoringPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.scoreCmb, -2, 150, -2)).addGroup(GroupLayout.Alignment.TRAILING, ptmScoringPanelLayout.createSequentialGroup().addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scoreTypeLabel, -2, 150, -2).addComponent(this.thresholdLabel, -2, 150, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.thresholdTxt, -2, 150, -2))).addContainerGap()));
        ptmScoringPanelLayout.setVerticalGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ptmScoringPanelLayout.createSequentialGroup().addContainerGap().addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scoreTypeLabel).addComponent(this.scoreCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.neutralLossesLabel).addComponent(this.neutralLossesCmb, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ptmScoringPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.thresholdLabel).addComponent(this.thresholdTxt, -2, -1, -2)).addContainerGap()));
        this.siteAlignmentPanel.setBorder(BorderFactory.createTitledBorder("Site Alignment"));
        this.siteAlignmentPanel.setOpaque(false);
        this.alignOnConfidentLbl.setText("Confident Sites");
        this.alignOnConfidentLbl.setToolTipText("Align peptide ambiguously localized PTMs on confident sites");
        this.alignOnConfidentCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        GroupLayout siteAlignmentPanelLayout = new GroupLayout(this.siteAlignmentPanel);
        this.siteAlignmentPanel.setLayout(siteAlignmentPanelLayout);
        siteAlignmentPanelLayout.setHorizontalGroup(siteAlignmentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(siteAlignmentPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.alignOnConfidentLbl).addGap(18, 18, Short.MAX_VALUE).addComponent(this.alignOnConfidentCmb, -2, 150, -2).addContainerGap()));
        siteAlignmentPanelLayout.setVerticalGroup(siteAlignmentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(siteAlignmentPanelLayout.createSequentialGroup().addContainerGap().addGroup(siteAlignmentPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.alignOnConfidentLbl).addComponent(this.alignOnConfidentCmb, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.setFocusable(false);
        this.helpJButton.setHorizontalTextPosition(0);
        this.helpJButton.setVerticalTextPosition(3);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationLocalizationParametersDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationLocalizationParametersDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationLocalizationParametersDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.siteAlignmentPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.helpJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.ptmScoringPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.ptmScoringPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.siteAlignmentPanel, -2, -1, -2).addGap(18, 18, 18).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.helpJButton).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput()) {
            this.dispose();
        }
    }

    private void scoreCmbActionPerformed(ActionEvent evt) {
        if (this.scoreCmb.getSelectedItem() != ModificationLocalizationScore.None) {
            this.neutralLossesCmb.setEnabled(true);
            this.thresholdTxt.setEnabled(true);
            this.thresholdTxt.setEditable(true);
            if (this.thresholdTxt.getText().isEmpty()) {
                this.thresholdTxt.setText("95");
            }
        } else {
            this.neutralLossesCmb.setEnabled(false);
            this.thresholdTxt.setEnabled(false);
            this.thresholdTxt.setEditable(false);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.canceled = true;
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.parentFrame, this.getClass().getResource("/helpFiles/PtmLocalizationPreferences.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "PTM Localization - Help");
        this.setCursor(new Cursor(0));
    }
}

