/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.parameters.identification.algorithm;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.parameters.identification.AlgorithmParametersDialog;
import com.compomics.util.gui.parameters.identification.IdentificationAlgorithmParameter;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.parameters.identification.tool_specific.MsAmandaParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class MsAmandaParametersDialog
extends JDialog
implements AlgorithmParametersDialog {
    private boolean cancelled = false;
    private boolean editable;
    private JPanel advancedSearchSettingsPanel;
    private JPanel backgroundPanel;
    private JPanel basicPanel;
    private JButton closeButton;
    private JComboBox combineConsideredChargesCmb;
    private JLabel combineConsideredChargesLabel;
    private JComboBox decoyDatabaseCmb;
    private JLabel decoyDatabaseLabel;
    private JComboBox excludeFirstPrecursorCmb;
    private JLabel excludeFirstPrecursorLabel;
    private JComboBox generatePInFileCmb;
    private JLabel generatePInFileLabel;
    private JComboBox instrumentCmb;
    private JLabel instrumentLabel;
    private JComboBox keepY1Cmb;
    private JLabel keepY1Label;
    private JComboBox maxAllowedChargeStatesCmb;
    private JLabel maxAllowedChargeStatesLabel;
    private JComboBox maxModPerPeptideCmb;
    private JLabel maxModPerPeptideLabel;
    private JComboBox maxMultiplePrecursorsCmb;
    private JLabel maxMultiplePrecursorsLabel;
    private JComboBox maxNeutralLossesPerPeptideCmb;
    private JLabel maxNeutralLossesPerPeptideLabel;
    private JComboBox<String> maxPeakDepthComboBox;
    private JTextField maxPeptideLengthTxt;
    private JComboBox maxPotentialModSitePerPeptideCmb;
    private JLabel maxPotentialModSitePerPeptideLabel;
    private JLabel maxProteinsLoadedLabel;
    private JTextField maxProteinsLoadedTxt;
    private JComboBox maxPtmNeutalLossesPerPeptideCmb;
    private JLabel maxPtmNeutalLossesPerPeptideLabel;
    private JLabel maxRankLabel;
    private JTextField maxRankTxt;
    private JLabel maxSpectraLoadedLabel;
    private JTextField maxSpectraLoadedTxt;
    private JComboBox maxVariableModPerPeptideCmb;
    private JLabel maxVariableModPerPeptideLabel;
    private JComboBox<String> minPeakDepthComboBox;
    private JTextField minPeptideLengthTxt;
    private JComboBox monoIsotopicCmb;
    private JLabel monoIsotopicLabel;
    private JLabel msAmandaHelpPageLabel;
    private JButton okButton;
    private JButton openDialogHelpJButton;
    private JComboBox outputFormatCmb;
    private JLabel outputFormatLabel;
    private JLabel peakDepthDividerLabel;
    private JLabel peakDepthLabel;
    private JLabel peptideLengthDividerLabel;
    private JLabel peptideLengthLabel;
    private JComboBox performDeisotopingCmb;
    private JLabel performDeisotopingLabel;
    private JComboBox performSecondSearchCmb;
    private JLabel performSecondSearchLabel;
    private JPanel perolatorPanel;
    private JComboBox rankTargetAndDecoySeparatelyCmb;
    private JLabel rankTargetAndDecoySeparatelyLabel;
    private JComboBox removeAmmoniaLossesCmb;
    private JLabel removeAmmoniaLossesLabel;
    private JComboBox removeWaterLossesCmb;
    private JLabel removeWaterLossesLabel;
    private JComboBox runPercolatorCmb;
    private JLabel runPercolatorLabel;
    private JPanel searchPanel;
    private JPanel secondSearchPanel;
    private JTabbedPane tabbedPane;

    public MsAmandaParametersDialog() {
    }

    public MsAmandaParametersDialog(Frame parent, MsAmandaParameters msAmandaParameters, boolean editable) {
        super(parent, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(msAmandaParameters);
        this.validateInput(false);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public MsAmandaParametersDialog(Dialog owner, Frame parent, MsAmandaParameters msAmandaParameters, boolean editable) {
        super(owner, true);
        this.editable = editable;
        this.initComponents();
        this.setUpGUI();
        this.populateGUI(msAmandaParameters);
        this.validateInput(false);
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.decoyDatabaseCmb.setRenderer(new AlignedListCellRenderer(0));
        this.rankTargetAndDecoySeparatelyCmb.setRenderer(new AlignedListCellRenderer(0));
        this.instrumentCmb.setRenderer(new AlignedListCellRenderer(0));
        this.monoIsotopicCmb.setRenderer(new AlignedListCellRenderer(0));
        this.performDeisotopingCmb.setRenderer(new AlignedListCellRenderer(0));
        this.maxModPerPeptideCmb.setRenderer(new AlignedListCellRenderer(0));
        this.maxVariableModPerPeptideCmb.setRenderer(new AlignedListCellRenderer(0));
        this.maxPotentialModSitePerPeptideCmb.setRenderer(new AlignedListCellRenderer(0));
        this.maxNeutralLossesPerPeptideCmb.setRenderer(new AlignedListCellRenderer(0));
        this.maxPtmNeutalLossesPerPeptideCmb.setRenderer(new AlignedListCellRenderer(0));
        this.outputFormatCmb.setRenderer(new AlignedListCellRenderer(0));
        this.maxAllowedChargeStatesCmb.setRenderer(new AlignedListCellRenderer(0));
        this.performSecondSearchCmb.setRenderer(new AlignedListCellRenderer(0));
        this.keepY1Cmb.setRenderer(new AlignedListCellRenderer(0));
        this.removeWaterLossesCmb.setRenderer(new AlignedListCellRenderer(0));
        this.removeAmmoniaLossesCmb.setRenderer(new AlignedListCellRenderer(0));
        this.excludeFirstPrecursorCmb.setRenderer(new AlignedListCellRenderer(0));
        this.combineConsideredChargesCmb.setRenderer(new AlignedListCellRenderer(0));
        this.runPercolatorCmb.setRenderer(new AlignedListCellRenderer(0));
        this.generatePInFileCmb.setRenderer(new AlignedListCellRenderer(0));
        this.minPeakDepthComboBox.setRenderer(new AlignedListCellRenderer(0));
        this.maxPeakDepthComboBox.setRenderer(new AlignedListCellRenderer(0));
        this.maxMultiplePrecursorsCmb.setRenderer(new AlignedListCellRenderer(0));
        this.decoyDatabaseCmb.setEnabled(this.editable);
        this.rankTargetAndDecoySeparatelyCmb.setEnabled(this.editable);
        this.instrumentCmb.setEnabled(this.editable);
        this.monoIsotopicCmb.setEnabled(this.editable);
        this.maxRankTxt.setEditable(this.editable);
        this.maxRankTxt.setEnabled(this.editable);
        this.performDeisotopingCmb.setEnabled(this.editable);
        this.maxModPerPeptideCmb.setEnabled(this.editable);
        this.maxVariableModPerPeptideCmb.setEnabled(this.editable);
        this.maxPotentialModSitePerPeptideCmb.setEnabled(this.editable);
        this.maxNeutralLossesPerPeptideCmb.setEnabled(this.editable);
        this.maxPtmNeutalLossesPerPeptideCmb.setEnabled(this.editable);
        this.maxAllowedChargeStatesCmb.setEnabled(this.editable);
        this.performSecondSearchCmb.setEnabled(this.editable);
        this.keepY1Cmb.setEnabled(this.editable);
        this.removeWaterLossesCmb.setEnabled(this.editable);
        this.removeAmmoniaLossesCmb.setEnabled(this.editable);
        this.excludeFirstPrecursorCmb.setEnabled(this.editable);
        this.combineConsideredChargesCmb.setEnabled(this.editable);
        this.runPercolatorCmb.setEnabled(this.editable);
        this.generatePInFileCmb.setEnabled(this.editable);
        this.minPeakDepthComboBox.setEnabled(this.editable);
        this.maxPeakDepthComboBox.setEnabled(this.editable);
        this.minPeptideLengthTxt.setEnabled(this.editable);
        this.maxPeptideLengthTxt.setEnabled(this.editable);
        this.maxProteinsLoadedTxt.setEnabled(this.editable);
        this.maxSpectraLoadedTxt.setEnabled(this.editable);
    }

    private void populateGUI(MsAmandaParameters msAmandaParameters) {
        if (msAmandaParameters.generateDecoy()) {
            this.decoyDatabaseCmb.setSelectedIndex(0);
        } else {
            this.decoyDatabaseCmb.setSelectedIndex(1);
        }
        if (msAmandaParameters.reportBothBestHitsForTD()) {
            this.rankTargetAndDecoySeparatelyCmb.setSelectedIndex(0);
        } else {
            this.rankTargetAndDecoySeparatelyCmb.setSelectedIndex(1);
        }
        this.instrumentCmb.setSelectedItem(msAmandaParameters.getInstrumentID());
        this.maxRankTxt.setText(msAmandaParameters.getMaxRank().toString());
        if (msAmandaParameters.isMonoIsotopic()) {
            this.monoIsotopicCmb.setSelectedIndex(0);
        } else {
            this.monoIsotopicCmb.setSelectedIndex(1);
        }
        if (msAmandaParameters.isPerformDeisotoping()) {
            this.performDeisotopingCmb.setSelectedIndex(0);
        } else {
            this.performDeisotopingCmb.setSelectedIndex(1);
        }
        if (msAmandaParameters.getPerformSecondSearch().booleanValue()) {
            this.performSecondSearchCmb.setSelectedIndex(0);
        } else {
            this.performSecondSearchCmb.setSelectedIndex(1);
        }
        if (msAmandaParameters.getKeepY1Ion().booleanValue()) {
            this.keepY1Cmb.setSelectedIndex(0);
        } else {
            this.keepY1Cmb.setSelectedIndex(1);
        }
        if (msAmandaParameters.getRemoveWaterLosses().booleanValue()) {
            this.removeWaterLossesCmb.setSelectedIndex(0);
        } else {
            this.removeWaterLossesCmb.setSelectedIndex(1);
        }
        if (msAmandaParameters.getRemoveAmmoniaLosses().booleanValue()) {
            this.removeAmmoniaLossesCmb.setSelectedIndex(0);
        } else {
            this.removeAmmoniaLossesCmb.setSelectedIndex(1);
        }
        if (msAmandaParameters.getExcludeFirstPrecursor().booleanValue()) {
            this.excludeFirstPrecursorCmb.setSelectedIndex(0);
        } else {
            this.excludeFirstPrecursorCmb.setSelectedIndex(1);
        }
        if (msAmandaParameters.getCombineConsideredCharges().booleanValue()) {
            this.combineConsideredChargesCmb.setSelectedIndex(0);
        } else {
            this.combineConsideredChargesCmb.setSelectedIndex(1);
        }
        if (msAmandaParameters.getRunPercolator().booleanValue()) {
            this.runPercolatorCmb.setSelectedIndex(0);
        } else {
            this.runPercolatorCmb.setSelectedIndex(1);
        }
        if (msAmandaParameters.getGeneratePInFile().booleanValue()) {
            this.generatePInFileCmb.setSelectedIndex(0);
        } else {
            this.generatePInFileCmb.setSelectedIndex(1);
        }
        this.maxModPerPeptideCmb.setSelectedIndex(msAmandaParameters.getMaxModifications());
        this.maxVariableModPerPeptideCmb.setSelectedIndex(msAmandaParameters.getMaxVariableModifications());
        this.maxPotentialModSitePerPeptideCmb.setSelectedIndex(msAmandaParameters.getMaxModificationSites());
        this.maxNeutralLossesPerPeptideCmb.setSelectedIndex(msAmandaParameters.getMaxNeutralLosses());
        this.maxPtmNeutalLossesPerPeptideCmb.setSelectedIndex(msAmandaParameters.getMaxNeutralLossesPerModification());
        this.maxAllowedChargeStatesCmb.setSelectedItem(msAmandaParameters.getMaxAllowedChargeState());
        this.minPeakDepthComboBox.setSelectedItem(msAmandaParameters.getMinPeakDepth());
        this.maxPeakDepthComboBox.setSelectedItem(msAmandaParameters.getMaxPeakDepth());
        this.maxMultiplePrecursorsCmb.setSelectedItem(msAmandaParameters.getMaxMultiplePrecursors());
        this.minPeptideLengthTxt.setText(msAmandaParameters.getMinPeptideLength().toString());
        this.maxPeptideLengthTxt.setText(msAmandaParameters.getMaxPeptideLength().toString());
        this.maxProteinsLoadedTxt.setText(msAmandaParameters.getMaxLoadedProteins().toString());
        this.maxSpectraLoadedTxt.setText(msAmandaParameters.getMaxLoadedSpectra().toString());
        if (msAmandaParameters.getOutputFormat().equalsIgnoreCase("csv")) {
            this.outputFormatCmb.setSelectedIndex(0);
        } else {
            this.outputFormatCmb.setSelectedIndex(1);
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public IdentificationAlgorithmParameter getParameters() {
        return this.getInput();
    }

    public MsAmandaParameters getInput() {
        MsAmandaParameters result = new MsAmandaParameters();
        result.setGenerateDecoyDatabase(this.decoyDatabaseCmb.getSelectedIndex() == 0);
        result.setReportBothBestHitsForTD(this.rankTargetAndDecoySeparatelyCmb.getSelectedIndex() == 0);
        result.setInstrumentID((String)this.instrumentCmb.getSelectedItem());
        String input = this.maxRankTxt.getText().trim();
        if (!input.equals("")) {
            result.setMaxRank(Integer.valueOf(input));
        }
        result.setMonoIsotopic(this.monoIsotopicCmb.getSelectedIndex() == 0);
        result.setPerformDeisotoping(this.performDeisotopingCmb.getSelectedIndex() == 0);
        result.setMaxModifications(this.maxModPerPeptideCmb.getSelectedIndex());
        result.setMaxVariableModifications(this.maxVariableModPerPeptideCmb.getSelectedIndex());
        result.setMaxModificationSites(this.maxPotentialModSitePerPeptideCmb.getSelectedIndex());
        result.setMaxNeutralLosses(this.maxNeutralLossesPerPeptideCmb.getSelectedIndex());
        result.setMaxNeutralLossesPerModification(this.maxPtmNeutalLossesPerPeptideCmb.getSelectedIndex());
        input = this.minPeptideLengthTxt.getText().trim();
        if (!input.equals("")) {
            result.setMinPeptideLength(Integer.valueOf(input));
        }
        if (!(input = this.maxPeptideLengthTxt.getText().trim()).equals("")) {
            result.setMaxPeptideLength(Integer.valueOf(input));
        }
        if (!(input = this.maxProteinsLoadedTxt.getText().trim()).equals("")) {
            result.setMaxLoadedProteins(Integer.valueOf(input));
        }
        if (!(input = this.maxSpectraLoadedTxt.getText().trim()).equals("")) {
            result.setMaxLoadedSpectra(Integer.valueOf(input));
        }
        result.setOutputFormat((String)this.outputFormatCmb.getSelectedItem());
        result.setMaxAllowedChargeState((String)this.maxAllowedChargeStatesCmb.getSelectedItem());
        result.setMinPeakDepth(Integer.valueOf((String)this.minPeakDepthComboBox.getSelectedItem()));
        result.setMaxPeakDepth(Integer.valueOf((String)this.maxPeakDepthComboBox.getSelectedItem()));
        result.setPerformSecondSearch(this.performSecondSearchCmb.getSelectedIndex() == 0);
        result.setKeepY1Ion(this.keepY1Cmb.getSelectedIndex() == 0);
        result.setRemoveWaterLosses(this.removeWaterLossesCmb.getSelectedIndex() == 0);
        result.setRemoveAmmoniaLosses(this.removeAmmoniaLossesCmb.getSelectedIndex() == 0);
        result.setExcludeFirstPrecursor(this.excludeFirstPrecursorCmb.getSelectedIndex() == 0);
        result.setMaxMultiplePrecursors(Integer.valueOf((String)this.maxMultiplePrecursorsCmb.getSelectedItem()));
        result.setCombineConsideredCharges(this.combineConsideredChargesCmb.getSelectedIndex() == 0);
        result.setRunPercolator(this.runPercolatorCmb.getSelectedIndex() == 0);
        result.setGeneratePInFile(this.generatePInFileCmb.getSelectedIndex() == 0);
        return result;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.advancedSearchSettingsPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.searchPanel = new JPanel();
        this.instrumentLabel = new JLabel();
        this.instrumentCmb = new JComboBox();
        this.maxRankLabel = new JLabel();
        this.maxRankTxt = new JTextField();
        this.decoyDatabaseLabel = new JLabel();
        this.decoyDatabaseCmb = new JComboBox();
        this.performDeisotopingCmb = new JComboBox();
        this.performDeisotopingLabel = new JLabel();
        this.maxModPerPeptideLabel = new JLabel();
        this.maxVariableModPerPeptideLabel = new JLabel();
        this.maxPotentialModSitePerPeptideLabel = new JLabel();
        this.maxPotentialModSitePerPeptideCmb = new JComboBox();
        this.maxVariableModPerPeptideCmb = new JComboBox();
        this.maxModPerPeptideCmb = new JComboBox();
        this.maxNeutralLossesPerPeptideLabel = new JLabel();
        this.maxNeutralLossesPerPeptideCmb = new JComboBox();
        this.maxPtmNeutalLossesPerPeptideLabel = new JLabel();
        this.maxPtmNeutalLossesPerPeptideCmb = new JComboBox();
        this.rankTargetAndDecoySeparatelyLabel = new JLabel();
        this.rankTargetAndDecoySeparatelyCmb = new JComboBox();
        this.maxAllowedChargeStatesLabel = new JLabel();
        this.maxAllowedChargeStatesCmb = new JComboBox();
        this.peakDepthLabel = new JLabel();
        this.peakDepthDividerLabel = new JLabel();
        this.peptideLengthLabel = new JLabel();
        this.minPeptideLengthTxt = new JTextField();
        this.peptideLengthDividerLabel = new JLabel();
        this.maxPeptideLengthTxt = new JTextField();
        this.maxPeakDepthComboBox = new JComboBox();
        this.minPeakDepthComboBox = new JComboBox();
        this.secondSearchPanel = new JPanel();
        this.performSecondSearchLabel = new JLabel();
        this.performSecondSearchCmb = new JComboBox();
        this.keepY1Label = new JLabel();
        this.keepY1Cmb = new JComboBox();
        this.removeWaterLossesLabel = new JLabel();
        this.removeWaterLossesCmb = new JComboBox();
        this.removeAmmoniaLossesLabel = new JLabel();
        this.removeAmmoniaLossesCmb = new JComboBox();
        this.excludeFirstPrecursorLabel = new JLabel();
        this.excludeFirstPrecursorCmb = new JComboBox();
        this.maxMultiplePrecursorsLabel = new JLabel();
        this.maxMultiplePrecursorsCmb = new JComboBox();
        this.basicPanel = new JPanel();
        this.monoIsotopicLabel = new JLabel();
        this.monoIsotopicCmb = new JComboBox();
        this.combineConsideredChargesLabel = new JLabel();
        this.combineConsideredChargesCmb = new JComboBox();
        this.maxProteinsLoadedLabel = new JLabel();
        this.maxProteinsLoadedTxt = new JTextField();
        this.maxSpectraLoadedLabel = new JLabel();
        this.maxSpectraLoadedTxt = new JTextField();
        this.outputFormatLabel = new JLabel();
        this.outputFormatCmb = new JComboBox();
        this.perolatorPanel = new JPanel();
        this.generatePInFileLabel = new JLabel();
        this.generatePInFileCmb = new JComboBox();
        this.runPercolatorLabel = new JLabel();
        this.runPercolatorCmb = new JComboBox();
        this.okButton = new JButton();
        this.closeButton = new JButton();
        this.openDialogHelpJButton = new JButton();
        this.msAmandaHelpPageLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("MS Amanda Advanced Settings");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.advancedSearchSettingsPanel.setBorder(BorderFactory.createTitledBorder("Search Settings"));
        this.advancedSearchSettingsPanel.setOpaque(false);
        this.searchPanel.setOpaque(false);
        this.instrumentLabel.setText("Fragment Ion Types");
        this.instrumentCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"b, y", "b, y, -H2O, -NH3", "a, b, y, -H2O, -NH3, Imm", "a, b, y, -H2O, -NH3", "a, b, y", "a, b, y, Imm", "a, b, y, z, -H2O, -NH3, Imm", "c, y, z+1, z+2", "c, z, z+1", "c, z, z+1, z+2", "b, c, y, z+1, z+2", "b, y, INT", "b, y, INT, Imm", "a, b, y, INT", "a, b, y, INT, IMM", "a, b, y, INT, IMM, -H2O", "a, b, y, INT, IMM, -H2O, -NH3", "a, b, y, INT, IMM, -NH3", "a, b, c, x, y, z", "a+1, x, y-1, z", "a+1, b, x, y-1, z", "a+1, b, x, y, y-1, z", "a, a+1, b, c, x, y, y-1, z", "a+1, x, y, y-1, z", "a, a+1, a-1, b, b+1, b-1, c, c+1, c-1, x, x+1, x-1, y, y+1, y-1, z, z+1, z-1"}));
        this.maxRankLabel.setText("Max Rank");
        this.maxRankTxt.setHorizontalAlignment(0);
        this.maxRankTxt.setText("1");
        this.maxRankTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MsAmandaParametersDialog.this.maxRankTxtKeyReleased(evt);
            }
        });
        this.decoyDatabaseLabel.setText("Generate Decoy Database");
        this.decoyDatabaseCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.decoyDatabaseCmb.setSelectedIndex(1);
        this.performDeisotopingCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.performDeisotopingLabel.setText("Perform Deisotoping");
        this.maxModPerPeptideLabel.setText("Max PTM Duplicates per Peptide");
        this.maxModPerPeptideLabel.setToolTipText("Max number of occurrences of a specific modification on a peptide");
        this.maxVariableModPerPeptideLabel.setText("Max Variable PTMs per Peptide");
        this.maxVariableModPerPeptideLabel.setToolTipText("Max number of variable modifications per peptide");
        this.maxPotentialModSitePerPeptideLabel.setText("Max Potential PTM sites per PTM");
        this.maxPotentialModSitePerPeptideLabel.setToolTipText("Max number of potential modification sites per modification per peptide");
        this.maxPotentialModSitePerPeptideCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"}));
        this.maxPotentialModSitePerPeptideCmb.setSelectedIndex(6);
        this.maxPotentialModSitePerPeptideCmb.setToolTipText("Max number of potential modification sites per modification per peptide");
        this.maxVariableModPerPeptideCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"}));
        this.maxVariableModPerPeptideCmb.setSelectedIndex(4);
        this.maxVariableModPerPeptideCmb.setToolTipText("Max number of variable modifications per peptide");
        this.maxModPerPeptideCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"}));
        this.maxModPerPeptideCmb.setSelectedIndex(3);
        this.maxModPerPeptideCmb.setToolTipText("Max number of occurrences of a specific modification on a peptide");
        this.maxNeutralLossesPerPeptideLabel.setText("Max Neutral Losses per Peptide");
        this.maxNeutralLossesPerPeptideLabel.setToolTipText("Max number of water and ammonia losses per peptide");
        this.maxNeutralLossesPerPeptideCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5"}));
        this.maxNeutralLossesPerPeptideCmb.setSelectedIndex(1);
        this.maxNeutralLossesPerPeptideCmb.setToolTipText("Max number of water and ammonia losses per peptide");
        this.maxPtmNeutalLossesPerPeptideLabel.setText("Max PTM Neutral Losses per Peptide");
        this.maxPtmNeutalLossesPerPeptideLabel.setToolTipText("Max number identical modification specific losses per peptide");
        this.maxPtmNeutalLossesPerPeptideCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5"}));
        this.maxPtmNeutalLossesPerPeptideCmb.setSelectedIndex(1);
        this.maxPtmNeutalLossesPerPeptideCmb.setToolTipText("Max number identical modification specific losses per peptide");
        this.rankTargetAndDecoySeparatelyLabel.setText("Rank Target and Decoy Separately");
        this.rankTargetAndDecoySeparatelyCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.maxAllowedChargeStatesLabel.setText("Maximum Allowed Charge States");
        this.maxAllowedChargeStatesCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"+2", "+3", "+4", "Precursor - 1"}));
        this.peakDepthLabel.setText("Peak Depth");
        this.peakDepthDividerLabel.setHorizontalAlignment(0);
        this.peakDepthDividerLabel.setText("-");
        this.peptideLengthLabel.setText("Peptide Length (min - max)");
        this.minPeptideLengthTxt.setHorizontalAlignment(0);
        this.minPeptideLengthTxt.setText("8");
        this.minPeptideLengthTxt.setToolTipText("Minimum peptide length");
        this.minPeptideLengthTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MsAmandaParametersDialog.this.minPeptideLengthTxtKeyReleased(evt);
            }
        });
        this.peptideLengthDividerLabel.setHorizontalAlignment(0);
        this.peptideLengthDividerLabel.setText("-");
        this.maxPeptideLengthTxt.setHorizontalAlignment(0);
        this.maxPeptideLengthTxt.setText("30");
        this.maxPeptideLengthTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MsAmandaParametersDialog.this.maxPeptideLengthTxtKeyReleased(evt);
            }
        });
        this.maxPeakDepthComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30"}));
        this.maxPeakDepthComboBox.setSelectedIndex(9);
        this.minPeakDepthComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30"}));
        GroupLayout searchPanelLayout = new GroupLayout(this.searchPanel);
        this.searchPanel.setLayout(searchPanelLayout);
        searchPanelLayout.setHorizontalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addContainerGap().addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.instrumentLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.instrumentCmb, 0, 1, Short.MAX_VALUE)).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.maxRankLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxRankTxt)).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.decoyDatabaseLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.decoyDatabaseCmb, 0, -1, Short.MAX_VALUE)).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.performDeisotopingLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.performDeisotopingCmb, 0, -1, Short.MAX_VALUE)).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.maxModPerPeptideLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxModPerPeptideCmb, 0, -1, Short.MAX_VALUE)).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.maxVariableModPerPeptideLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxVariableModPerPeptideCmb, 0, -1, Short.MAX_VALUE)).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.maxPotentialModSitePerPeptideLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxPotentialModSitePerPeptideCmb, 0, -1, Short.MAX_VALUE)).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.maxNeutralLossesPerPeptideLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxNeutralLossesPerPeptideCmb, 0, -1, Short.MAX_VALUE)).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.maxPtmNeutalLossesPerPeptideLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxPtmNeutalLossesPerPeptideCmb, 0, -1, Short.MAX_VALUE)).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.rankTargetAndDecoySeparatelyLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rankTargetAndDecoySeparatelyCmb, 0, -1, Short.MAX_VALUE)).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.maxAllowedChargeStatesLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxAllowedChargeStatesCmb, 0, -1, Short.MAX_VALUE)).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.peakDepthLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minPeakDepthComboBox, -2, 66, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peakDepthDividerLabel, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxPeakDepthComboBox, -2, 72, -2)).addGroup(searchPanelLayout.createSequentialGroup().addComponent(this.peptideLengthLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minPeptideLengthTxt, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peptideLengthDividerLabel, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxPeptideLengthTxt, -2, 69, -2))).addContainerGap()));
        searchPanelLayout.linkSize(0, this.maxPeakDepthComboBox, this.maxPeptideLengthTxt, this.minPeakDepthComboBox, this.minPeptideLengthTxt);
        searchPanelLayout.setVerticalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addContainerGap().addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.instrumentCmb, -2, -1, -2).addComponent(this.instrumentLabel)).addGap(0, 0, 0).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxRankLabel).addComponent(this.maxRankTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.decoyDatabaseLabel).addComponent(this.decoyDatabaseCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.performDeisotopingLabel).addComponent(this.performDeisotopingCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxModPerPeptideCmb, -2, -1, -2).addComponent(this.maxModPerPeptideLabel)).addGap(0, 0, 0).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxVariableModPerPeptideCmb, -2, -1, -2).addComponent(this.maxVariableModPerPeptideLabel)).addGap(0, 0, 0).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxPotentialModSitePerPeptideCmb, -2, -1, -2).addComponent(this.maxPotentialModSitePerPeptideLabel)).addGap(0, 0, 0).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxNeutralLossesPerPeptideCmb, -2, -1, -2).addComponent(this.maxNeutralLossesPerPeptideLabel)).addGap(0, 0, 0).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxPtmNeutalLossesPerPeptideCmb, -2, -1, -2).addComponent(this.maxPtmNeutalLossesPerPeptideLabel)).addGap(0, 0, 0).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minPeptideLengthTxt, -2, -1, -2).addComponent(this.peptideLengthLabel).addComponent(this.maxPeptideLengthTxt, -2, -1, -2).addComponent(this.peptideLengthDividerLabel)).addGap(0, 0, 0).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rankTargetAndDecoySeparatelyLabel).addComponent(this.rankTargetAndDecoySeparatelyCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxAllowedChargeStatesCmb, -2, -1, -2).addComponent(this.maxAllowedChargeStatesLabel)).addGap(0, 0, 0).addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.peakDepthLabel).addComponent(this.minPeakDepthComboBox, -2, -1, -2).addComponent(this.peakDepthDividerLabel).addComponent(this.maxPeakDepthComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Search", this.searchPanel);
        this.secondSearchPanel.setOpaque(false);
        this.performSecondSearchLabel.setText("Perform Second Search");
        this.performSecondSearchCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.performSecondSearchCmb.setSelectedIndex(1);
        this.performSecondSearchCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MsAmandaParametersDialog.this.performSecondSearchCmbActionPerformed(evt);
            }
        });
        this.keepY1Label.setText("Keep Y1 Ion");
        this.keepY1Cmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.removeWaterLossesLabel.setText("Remove Water Losses");
        this.removeWaterLossesCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.removeAmmoniaLossesLabel.setText("Remove Ammonia Losses");
        this.removeAmmoniaLossesCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.excludeFirstPrecursorLabel.setText("Exclude First Precursor");
        this.excludeFirstPrecursorCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.maxMultiplePrecursorsLabel.setText("Max Multiple Precursors");
        this.maxMultiplePrecursorsCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "3", "7", "8", "9", "10"}));
        this.maxMultiplePrecursorsCmb.setSelectedIndex(4);
        GroupLayout secondSearchPanelLayout = new GroupLayout(this.secondSearchPanel);
        this.secondSearchPanel.setLayout(secondSearchPanelLayout);
        secondSearchPanelLayout.setHorizontalGroup(secondSearchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(secondSearchPanelLayout.createSequentialGroup().addContainerGap().addGroup(secondSearchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(secondSearchPanelLayout.createSequentialGroup().addComponent(this.performSecondSearchLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.performSecondSearchCmb, 0, 171, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, secondSearchPanelLayout.createSequentialGroup().addComponent(this.keepY1Label, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.keepY1Cmb, 0, -1, Short.MAX_VALUE)).addGroup(secondSearchPanelLayout.createSequentialGroup().addComponent(this.removeWaterLossesLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeWaterLossesCmb, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, secondSearchPanelLayout.createSequentialGroup().addComponent(this.removeAmmoniaLossesLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeAmmoniaLossesCmb, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, secondSearchPanelLayout.createSequentialGroup().addComponent(this.excludeFirstPrecursorLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.excludeFirstPrecursorCmb, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, secondSearchPanelLayout.createSequentialGroup().addComponent(this.maxMultiplePrecursorsLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxMultiplePrecursorsCmb, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        secondSearchPanelLayout.setVerticalGroup(secondSearchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(secondSearchPanelLayout.createSequentialGroup().addContainerGap().addGroup(secondSearchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.performSecondSearchLabel).addComponent(this.performSecondSearchCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(secondSearchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keepY1Label).addComponent(this.keepY1Cmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(secondSearchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.removeWaterLossesLabel).addComponent(this.removeWaterLossesCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(secondSearchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.removeAmmoniaLossesLabel).addComponent(this.removeAmmoniaLossesCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(secondSearchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.excludeFirstPrecursorLabel).addComponent(this.excludeFirstPrecursorCmb, -2, -1, -2)).addGap(1, 1, 1).addGroup(secondSearchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxMultiplePrecursorsLabel).addComponent(this.maxMultiplePrecursorsCmb, -2, -1, -2)).addContainerGap(191, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Second Search", this.secondSearchPanel);
        this.basicPanel.setOpaque(false);
        this.monoIsotopicLabel.setText("Monoisotopic");
        this.monoIsotopicCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.combineConsideredChargesLabel.setText("Combine Considered Charges");
        this.combineConsideredChargesCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.maxProteinsLoadedLabel.setText("Max Proteins Loaded into Memory");
        this.maxProteinsLoadedLabel.setToolTipText("Max number of proteins loaded into memory (1000-500000)");
        this.maxProteinsLoadedTxt.setHorizontalAlignment(0);
        this.maxProteinsLoadedTxt.setText("100000");
        this.maxProteinsLoadedTxt.setToolTipText("Max number of proteins loaded into memory (1000-500000)");
        this.maxProteinsLoadedTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MsAmandaParametersDialog.this.maxProteinsLoadedTxtKeyReleased(evt);
            }
        });
        this.maxSpectraLoadedLabel.setText("Max Spectra Loaded into Memory");
        this.maxSpectraLoadedLabel.setToolTipText("Max number of spectra loaded into memory (1000-500000)");
        this.maxSpectraLoadedTxt.setHorizontalAlignment(0);
        this.maxSpectraLoadedTxt.setText("2000");
        this.maxSpectraLoadedTxt.setToolTipText("Max number of spectra loaded into memory (1000-500000)");
        this.maxSpectraLoadedTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MsAmandaParametersDialog.this.maxSpectraLoadedTxtKeyReleased(evt);
            }
        });
        this.outputFormatLabel.setText("Output Format");
        this.outputFormatCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"csv", "mzIdentML"}));
        GroupLayout basicPanelLayout = new GroupLayout(this.basicPanel);
        this.basicPanel.setLayout(basicPanelLayout);
        basicPanelLayout.setHorizontalGroup(basicPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(basicPanelLayout.createSequentialGroup().addContainerGap().addGroup(basicPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(basicPanelLayout.createSequentialGroup().addComponent(this.monoIsotopicLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.monoIsotopicCmb, 0, 171, Short.MAX_VALUE)).addGroup(basicPanelLayout.createSequentialGroup().addComponent(this.combineConsideredChargesLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.combineConsideredChargesCmb, 0, 171, Short.MAX_VALUE)).addGroup(basicPanelLayout.createSequentialGroup().addComponent(this.maxProteinsLoadedLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxProteinsLoadedTxt)).addGroup(basicPanelLayout.createSequentialGroup().addComponent(this.maxSpectraLoadedLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxSpectraLoadedTxt)).addGroup(basicPanelLayout.createSequentialGroup().addComponent(this.outputFormatLabel, -2, 200, -2).addGap(26, 26, 26).addComponent(this.outputFormatCmb, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        basicPanelLayout.setVerticalGroup(basicPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(basicPanelLayout.createSequentialGroup().addContainerGap().addGroup(basicPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.monoIsotopicLabel).addComponent(this.monoIsotopicCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(basicPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.combineConsideredChargesLabel).addComponent(this.combineConsideredChargesCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(basicPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxProteinsLoadedTxt, -2, -1, -2).addComponent(this.maxProteinsLoadedLabel)).addGap(0, 0, 0).addGroup(basicPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxSpectraLoadedTxt, -2, -1, -2).addComponent(this.maxSpectraLoadedLabel)).addGap(0, 0, 0).addGroup(basicPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputFormatLabel).addComponent(this.outputFormatCmb, -2, -1, -2)).addContainerGap(214, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Basic", this.basicPanel);
        this.perolatorPanel.setOpaque(false);
        this.generatePInFileLabel.setText("Generate PIn File");
        this.generatePInFileCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.generatePInFileCmb.setSelectedIndex(1);
        this.runPercolatorLabel.setText("Run Percolator");
        this.runPercolatorCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.runPercolatorCmb.setSelectedIndex(1);
        this.runPercolatorCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MsAmandaParametersDialog.this.runPercolatorCmbActionPerformed(evt);
            }
        });
        GroupLayout perolatorPanelLayout = new GroupLayout(this.perolatorPanel);
        this.perolatorPanel.setLayout(perolatorPanelLayout);
        perolatorPanelLayout.setHorizontalGroup(perolatorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(perolatorPanelLayout.createSequentialGroup().addContainerGap().addGroup(perolatorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(perolatorPanelLayout.createSequentialGroup().addComponent(this.generatePInFileLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.generatePInFileCmb, 0, 171, Short.MAX_VALUE)).addGroup(perolatorPanelLayout.createSequentialGroup().addComponent(this.runPercolatorLabel, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.runPercolatorCmb, 0, 171, Short.MAX_VALUE))).addContainerGap()));
        perolatorPanelLayout.setVerticalGroup(perolatorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(perolatorPanelLayout.createSequentialGroup().addContainerGap().addGroup(perolatorPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.runPercolatorLabel).addComponent(this.runPercolatorCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(perolatorPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.generatePInFileLabel).addComponent(this.generatePInFileCmb, -2, -1, -2)).addContainerGap(296, Short.MAX_VALUE)));
        this.tabbedPane.addTab("Percolator", this.perolatorPanel);
        GroupLayout advancedSearchSettingsPanelLayout = new GroupLayout(this.advancedSearchSettingsPanel);
        this.advancedSearchSettingsPanel.setLayout(advancedSearchSettingsPanelLayout);
        advancedSearchSettingsPanelLayout.setHorizontalGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane).addContainerGap()));
        advancedSearchSettingsPanelLayout.setVerticalGroup(advancedSearchSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedSearchSettingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane).addContainerGap()));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MsAmandaParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MsAmandaParametersDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Help");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                MsAmandaParametersDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                MsAmandaParametersDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MsAmandaParametersDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        this.msAmandaHelpPageLabel.setText("Click to open the MS Amanda help page.");
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.advancedSearchSettingsPanel, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.openDialogHelpJButton).addGap(18, 18, 18).addComponent(this.msAmandaHelpPageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.advancedSearchSettingsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openDialogHelpJButton).addComponent(this.msAmandaHelpPageLabel).addComponent(this.okButton).addComponent(this.closeButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput(true)) {
            this.dispose();
        }
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://ms.imp.ac.at/?goto=msamanda");
        this.setCursor(new Cursor(0));
    }

    private void maxSpectraLoadedTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxProteinsLoadedTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxPeptideLengthTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void minPeptideLengthTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void maxRankTxtKeyReleased(KeyEvent evt) {
        this.validateInput(false);
    }

    private void performSecondSearchCmbActionPerformed(ActionEvent evt) {
        this.keepY1Cmb.setEnabled(this.performSecondSearchCmb.getSelectedIndex() == 0);
        this.removeWaterLossesCmb.setEnabled(this.performSecondSearchCmb.getSelectedIndex() == 0);
        this.removeAmmoniaLossesCmb.setEnabled(this.performSecondSearchCmb.getSelectedIndex() == 0);
        this.excludeFirstPrecursorCmb.setEnabled(this.performSecondSearchCmb.getSelectedIndex() == 0);
        this.maxMultiplePrecursorsCmb.setEnabled(this.performSecondSearchCmb.getSelectedIndex() == 0);
    }

    private void runPercolatorCmbActionPerformed(ActionEvent evt) {
        this.generatePInFileCmb.setEnabled(this.runPercolatorCmb.getSelectedIndex() == 0);
    }

    public boolean validateInput(boolean showMessage) {
        Integer value2;
        boolean valid = true;
        valid = GuiUtilities.validateIntegerInput(this, this.maxRankLabel, this.maxRankTxt, "number of spectrum matches", "Number Spectrum Matches Error", true, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.peptideLengthLabel, this.minPeptideLengthTxt, "minimum peptide length", "Minimum Peptide Length Error", false, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.peptideLengthLabel, this.maxPeptideLengthTxt, "maximum peptide length", "Maximum Peptide Length Error", false, showMessage, valid);
        valid = GuiUtilities.validateIntegerInput(this, this.maxProteinsLoadedLabel, this.maxProteinsLoadedTxt, "maximum number of proteins loaded into memory", "Maximum Proteins Loaded into Memory Error", true, showMessage, valid);
        if (valid = GuiUtilities.validateIntegerInput(this, this.maxSpectraLoadedLabel, this.maxSpectraLoadedTxt, "maximum number of spectra loaded into memory", "Maximum Spectra Loaded into Memory Error", true, showMessage, valid)) {
            try {
                value2 = Integer.valueOf(this.maxProteinsLoadedTxt.getText());
                if (value2 < 1000 || value2 > 500000) {
                    if (showMessage && valid) {
                        JOptionPane.showMessageDialog(this, "Please select an integer in the range (1000 - 500 000) for Max Proteins Loaded into Memory.", "Max Proteins Loaded into Memory Error", 2);
                    }
                    valid = false;
                    this.maxProteinsLoadedLabel.setForeground(Color.RED);
                    this.maxProteinsLoadedLabel.setToolTipText("Please select an integer in the range (1000 - 500 000)");
                }
            }
            catch (NumberFormatException value2) {
                // empty catch block
            }
        }
        if (valid) {
            try {
                value2 = Integer.valueOf(this.maxSpectraLoadedTxt.getText());
                if (value2 < 1000 || value2 > 500000) {
                    if (showMessage && valid) {
                        JOptionPane.showMessageDialog(this, "Please select an integer in the range (1000 - 500 000) for Max Spectra Loaded into Memory.", "Max Spectra Loaded into Memory Error", 2);
                    }
                    valid = false;
                    this.maxProteinsLoadedLabel.setForeground(Color.RED);
                    this.maxProteinsLoadedLabel.setToolTipText("Please select an integer in the range (1000 - 500 000)");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.okButton.setEnabled(valid);
        return valid;
    }
}

