/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.math;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.math.util.FastMath;

public class BasicMathFunctions {
    private static double logBase = 0.0;
    private static double logBaseValue;
    private static final long[] FACTORIALS_CACHE;

    public static long[] getFactorialsCache() {
        long[] result = new long[21];
        result[0] = 1L;
        for (int i = 1; i <= 20; ++i) {
            result[i] = result[i - 1] * (long)i;
        }
        return result;
    }

    public static double factorialDouble(int n) {
        if (n <= 20) {
            return BasicMathFunctions.factorial(n);
        }
        double result = BasicMathFunctions.factorial(20);
        for (int i = 21; i <= n; ++i) {
            result *= (double)i;
        }
        return result;
    }

    public static long factorial(int n) {
        if (n == 0) {
            return 0L;
        }
        if (n == 1) {
            return 1L;
        }
        if (n <= 20) {
            return FACTORIALS_CACHE[n];
        }
        if (n > 20) {
            throw new IllegalArgumentException("Reached the maximal capacity of a long.");
        }
        if (n < 0) {
            throw new ArithmeticException("Attempting to calculate the factorial of a negative number.");
        }
        throw new UnsupportedOperationException("Factorial not implemented for n = " + n + ".");
    }

    public static double factorialDouble(int n, int k) {
        if (n < k) {
            throw new ArithmeticException("n < k in n!/k!.");
        }
        if (n == k) {
            return 1.0;
        }
        if (n <= 20) {
            return BasicMathFunctions.factorial(n, k);
        }
        double result = BasicMathFunctions.factorialDouble(20) / BasicMathFunctions.factorialDouble(k);
        for (int i = 21; i <= n; ++i) {
            result *= (double)i;
        }
        return result;
    }

    public static long factorial(int n, int k) {
        if (n < k) {
            throw new ArithmeticException("n < k in n!/k!.");
        }
        if (n == k) {
            return 1L;
        }
        if (n <= 20) {
            return BasicMathFunctions.factorial(n) / BasicMathFunctions.factorial(k);
        }
        long nMinusOne = BasicMathFunctions.factorial(n - 1, k);
        if (nMinusOne == -1L || nMinusOne > Long.MAX_VALUE / (long)n) {
            throw new IllegalArgumentException("Reached the maximal capacity of a long.");
        }
        return nMinusOne * (long)n;
    }

    public static double getCombinationDouble(int k, int n) {
        if (k < n) {
            double kInN = BasicMathFunctions.factorialDouble(n, k);
            double nMinK = BasicMathFunctions.factorialDouble(n - k);
            return kInN / nMinK;
        }
        if (k == n || k == 0) {
            return 1.0;
        }
        throw new IllegalArgumentException("n>k in combination.");
    }

    public static double getOneOverCombinationDouble(int k, int n) {
        if (k < n) {
            double kInN = BasicMathFunctions.factorialDouble(n, k);
            double nMinK = BasicMathFunctions.factorialDouble(n - k);
            return nMinK / kInN;
        }
        if (k == 0 || k == n) {
            return 1.0;
        }
        throw new IllegalArgumentException("n>k in combination.");
    }

    public static long getCombination(int k, int n) {
        if (k < n) {
            long kInN = BasicMathFunctions.factorial(n, k);
            long nMinK = BasicMathFunctions.factorial(n - k);
            return kInN / nMinK;
        }
        if (k == n || k == 0) {
            return 1L;
        }
        throw new IllegalArgumentException("n>k in combination.");
    }

    public static double median(double[] input) {
        ArrayList<Double> tempValues = new ArrayList<Double>(input.length);
        for (double tempValue : input) {
            tempValues.add(tempValue);
        }
        Collections.sort(tempValues);
        return BasicMathFunctions.medianSorted(tempValues);
    }

    public static double medianSorted(double[] input) {
        int length = input.length;
        if (input.length == 1) {
            return input[0];
        }
        if (length % 2 == 1) {
            return input[(length - 1) / 2];
        }
        return (input[length / 2] + input[length / 2 - 1]) / 2.0;
    }

    public static double median(ArrayList<Double> input) {
        return BasicMathFunctions.percentile(input, 0.5);
    }

    public static double medianSorted(ArrayList<Double> input) {
        return BasicMathFunctions.percentileSorted(input, 0.5);
    }

    public static double percentile(double[] input, double percentile) {
        ArrayList<Double> tempValues = new ArrayList<Double>(input.length);
        for (double tempValue : input) {
            tempValues.add(tempValue);
        }
        Collections.sort(tempValues);
        return BasicMathFunctions.percentileSorted(tempValues, percentile);
    }

    public static double percentileSorted(double[] input, double percentile) {
        if (percentile < 0.0 || percentile > 1.0) {
            throw new IllegalArgumentException("Incorrect input for percentile: " + percentile + ". Input must be between 0 and 1.");
        }
        int length = input.length;
        if (length == 0) {
            throw new IllegalArgumentException("Attempting to estimate the percentile of an empty list.");
        }
        if (length == 1) {
            return input[0];
        }
        double indexDouble = percentile * (double)(length - 1);
        int index = (int)indexDouble;
        double valueAtIndex = input[index];
        double rest = indexDouble - (double)index;
        if (index == input.length - 1 || rest == 0.0) {
            return valueAtIndex;
        }
        return valueAtIndex + rest * (input[index + 1] - valueAtIndex);
    }

    public static double percentile(ArrayList<Double> input, double percentile) {
        if (input == null) {
            throw new IllegalArgumentException("Attempting to estimate the percentile of a null object.");
        }
        int length = input.size();
        if (length == 0) {
            throw new IllegalArgumentException("Attempting to estimate the percentile of an empty list.");
        }
        ArrayList<Double> sortedInput = new ArrayList<Double>(input);
        Collections.sort(sortedInput);
        return BasicMathFunctions.percentileSorted(sortedInput, percentile);
    }

    public static double percentileSorted(ArrayList<Double> input, double percentile) {
        if (percentile < 0.0 || percentile > 1.0) {
            throw new IllegalArgumentException("Incorrect input for percentile: " + percentile + ". Input must be between 0 and 1.");
        }
        if (input == null) {
            throw new IllegalArgumentException("Attempting to estimate the percentile of a null object.");
        }
        int length = input.size();
        if (length == 0) {
            throw new IllegalArgumentException("Attempting to estimate the percentile of an empty list.");
        }
        if (length == 1) {
            return input.get(0);
        }
        double indexDouble = percentile * (double)(length - 1);
        int index = (int)indexDouble;
        double valueAtIndex = input.get(index);
        double rest = indexDouble - (double)index;
        if (index == input.size() - 1 || rest == 0.0) {
            return valueAtIndex;
        }
        return valueAtIndex + rest * (input.get(index + 1) - valueAtIndex);
    }

    public static double mad(double[] ratios) {
        double[] deviations = new double[ratios.length];
        double med = BasicMathFunctions.median(ratios);
        for (int i = 0; i < ratios.length; ++i) {
            deviations[i] = Math.abs(ratios[i] - med);
        }
        return BasicMathFunctions.median(deviations);
    }

    public static double mad(ArrayList<Double> ratios) {
        double[] deviations = new double[ratios.size()];
        double med = BasicMathFunctions.median(ratios);
        for (int i = 0; i < ratios.size(); ++i) {
            deviations[i] = Math.abs(ratios.get(i) - med);
        }
        return BasicMathFunctions.median(deviations);
    }

    public static double log(double input, double base) {
        if (base <= 0.0) {
            throw new IllegalArgumentException("Attempting to comupute logarithm of base " + base + ".");
        }
        if (base != logBase) {
            logBase = base;
            logBaseValue = FastMath.log((double)base);
        }
        return FastMath.log((double)input) / logBaseValue;
    }

    public static double std(ArrayList<Double> input) {
        if (input == null || input.size() < 2) {
            return 0.0;
        }
        double result = 0.0;
        double mean = BasicMathFunctions.mean(input);
        for (Double x : input) {
            result += Math.pow(x - mean, 2.0);
        }
        result /= (double)(input.size() - 1);
        result = Math.sqrt(result);
        return result;
    }

    public static double mean(ArrayList<Double> input) {
        return BasicMathFunctions.sum(input) / (double)input.size();
    }

    public static double sum(ArrayList<Double> input) {
        double result = 0.0;
        for (Double x : input) {
            result += x.doubleValue();
        }
        return result;
    }

    public static double getCorrelation(ArrayList<Double> series1, ArrayList<Double> series2) {
        if (series1.size() != series2.size()) {
            throw new IllegalArgumentException("Series must be of same size for correlation analysis (series 1: " + series1.size() + " elements, series 1: " + series2.size() + " elements).");
        }
        int n = series1.size();
        if (n <= 1) {
            throw new IllegalArgumentException("At least two values are required for the estimation of correlation factors (" + n + " elements).");
        }
        double std1 = BasicMathFunctions.std(series1);
        double std2 = BasicMathFunctions.std(series2);
        if (std1 == 0.0 && std2 == 0.0) {
            return 1.0;
        }
        if (std1 == 0.0) {
            std1 = std2;
        }
        if (std2 == 0.0) {
            std2 = std1;
        }
        double mean1 = BasicMathFunctions.mean(series1);
        double mean2 = BasicMathFunctions.mean(series2);
        double corr = 0.0;
        for (int i = 0; i < n; ++i) {
            corr += (series1.get(i) - mean1) * (series2.get(i) - mean2);
        }
        corr /= std1 * std2;
        return corr /= (double)(n - 1);
    }

    public static double getRobustCorrelation(ArrayList<Double> series1, ArrayList<Double> series2) {
        if (series1.size() != series2.size()) {
            throw new IllegalArgumentException("Series must be of same size for correlation analysis (series 1: " + series1.size() + " elements, series 1: " + series2.size() + " elements).");
        }
        int n = series1.size();
        if (n <= 1) {
            throw new IllegalArgumentException("At least two values are required for the estimation of correlation factors (" + n + " elements).");
        }
        double std1 = (BasicMathFunctions.percentile(series1, 0.841) - BasicMathFunctions.percentile(series1, 0.159)) / 2.0;
        double std2 = (BasicMathFunctions.percentile(series2, 0.841) - BasicMathFunctions.percentile(series2, 0.159)) / 2.0;
        if (std1 == 0.0 && std2 == 0.0) {
            return 1.0;
        }
        if (std1 == 0.0) {
            std1 = std2;
        }
        if (std2 == 0.0) {
            std2 = std1;
        }
        double mean1 = BasicMathFunctions.median(series1);
        double mean2 = BasicMathFunctions.median(series2);
        double corr = 0.0;
        for (int i = 0; i < n; ++i) {
            corr += (series1.get(i) - mean1) * (series2.get(i) - mean2);
        }
        corr /= std1 * std2;
        return corr /= (double)(n - 1);
    }

    public static void checkProbabilityRange(double p) {
        if (p < 0.0) {
            throw new IllegalArgumentException("Probability <0%.");
        }
        if (p > 1.0) {
            throw new IllegalArgumentException("Probability >100%.");
        }
    }

    public static void checkProbabilityRangeInPercent(double p) {
        if (p < 0.0) {
            throw new IllegalArgumentException("Probability <0%.");
        }
        if (p > 100.0) {
            throw new IllegalArgumentException("Probability >100%.");
        }
    }

    public static int getRandomInteger(int min, int max) {
        double randomDouble = (double)min + Math.random() * (double)(max - min);
        if (randomDouble > (double)max) {
            return max;
        }
        if (randomDouble < (double)min) {
            return min;
        }
        return (int)Math.round(randomDouble);
    }

    public static ArrayList<Integer> getRandomIndexes(int n, int min, int max) {
        ArrayList<Integer> result = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            result.add(BasicMathFunctions.getRandomInteger(min, max));
        }
        return result;
    }

    static {
        FACTORIALS_CACHE = BasicMathFunctions.getFactorialsCache();
    }
}

