/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.math.roc;

import com.compomics.util.math.statistics.ROC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.math.MathException;

public class DataRoc
implements ROC {
    private ArrayList<Double> xValues;
    private ArrayList<Double> yValues;
    private RocInterpolation rocInterpolation;

    public DataRoc() {
    }

    public DataRoc(ArrayList<Double> controlValues, ArrayList<Double> patientValues, RocInterpolation rocInterpolation) {
        if (controlValues == null || controlValues.isEmpty()) {
            throw new IllegalArgumentException("No control values given for ROC curve creation.");
        }
        if (patientValues == null || patientValues.isEmpty()) {
            throw new IllegalArgumentException("No patient values given for ROC curve creation.");
        }
        this.rocInterpolation = rocInterpolation;
        HashMap<Double, int[]> valuesMap = new HashMap<Double, int[]>();
        int nControls = 0;
        for (Double d : controlValues) {
            int[] n = (int[])valuesMap.get(d);
            if (n == null) {
                n = new int[]{1, 0};
                valuesMap.put(d, n);
            } else {
                n[0] = n[0] + 1;
            }
            ++nControls;
        }
        int nPatients = 0;
        for (Double value : patientValues) {
            int[] n = (int[])valuesMap.get(value);
            if (n == null) {
                n = new int[]{0, 1};
                valuesMap.put(value, n);
            } else {
                n[1] = n[1] + 1;
            }
            ++nPatients;
        }
        this.xValues = new ArrayList();
        this.yValues = new ArrayList();
        ArrayList arrayList = new ArrayList(valuesMap.keySet());
        Collections.sort(arrayList);
        int patientCpt = 0;
        int controlCpt = 0;
        for (Double value : arrayList) {
            int[] counts = (int[])valuesMap.get(value);
            if (counts[1] > 0) {
                double x = (double)patientCpt / (double)nPatients;
                this.xValues.add(x);
                double y = (double)controlCpt / (double)nControls;
                this.yValues.add(y);
            }
            patientCpt += counts[1];
            controlCpt += counts[0];
        }
        this.xValues.add(1.0);
        this.yValues.add(1.0);
    }

    @Override
    public double getValueAt(double specificity) throws MathException {
        Double xBefore = null;
        Double yBefore = null;
        Double xAfter = null;
        Double yAfter = null;
        int i = 0;
        for (double xValue : this.xValues) {
            if (xBefore == null || xValue < specificity && xValue > xBefore) {
                xBefore = xValue;
                yBefore = this.yValues.get(i);
            } else if (xValue > specificity || i == this.xValues.size() - 1) {
                xAfter = xValue;
                yAfter = this.yValues.get(i);
                break;
            }
            ++i;
        }
        if (specificity == xBefore || this.rocInterpolation == RocInterpolation.minimum) {
            return yBefore;
        }
        if (specificity == xAfter || this.rocInterpolation == RocInterpolation.maximum) {
            return yAfter;
        }
        double y = yBefore + (specificity - xBefore) / (xAfter - xBefore) * (yAfter - yBefore);
        return y;
    }

    @Override
    public double getSpecificityAt(double sensitivity) throws MathException {
        Double xBefore = null;
        Double yBefore = null;
        Double xAfter = null;
        Double yAfter = null;
        int i = 0;
        for (double yValue : this.yValues) {
            if (xBefore == null || yValue < sensitivity && yValue > yBefore) {
                yBefore = yValue;
                xBefore = this.xValues.get(i);
            } else if (yValue > sensitivity || i == this.yValues.size() - 1) {
                yAfter = yValue;
                xAfter = this.xValues.get(i);
                break;
            }
            ++i;
        }
        if (sensitivity == yBefore || this.rocInterpolation == RocInterpolation.minimum) {
            return xBefore;
        }
        if (sensitivity == yAfter || this.rocInterpolation == RocInterpolation.maximum) {
            return xAfter;
        }
        double x = xBefore + (sensitivity - yBefore) / (yAfter - yBefore) * (xAfter - xBefore);
        return x;
    }

    @Override
    public double[][] getxYValues() throws MathException {
        double[][] result = new double[this.xValues.size()][2];
        int i = 0;
        Iterator<Double> iterator = this.xValues.iterator();
        while (iterator.hasNext()) {
            double xValue;
            result[i][0] = xValue = iterator.next().doubleValue();
            result[i][1] = this.yValues.get(i);
            ++i;
        }
        return result;
    }

    @Override
    public double getAuc() throws MathException {
        double auc = 0.0;
        for (int i = 0; i < this.xValues.size() - 1; ++i) {
            double xAfter = this.xValues.get(i + 1);
            double xBefore = this.xValues.get(i);
            if (this.rocInterpolation == RocInterpolation.minimum) {
                auc += this.yValues.get(i) * (xAfter - xBefore);
                continue;
            }
            if (this.rocInterpolation == RocInterpolation.maximum) {
                auc += this.yValues.get(i + 1) * (xAfter - xBefore);
                continue;
            }
            if (this.rocInterpolation == RocInterpolation.linear) {
                double yBefore = this.yValues.get(i);
                double yAfter = this.yValues.get(i + 1);
                auc += (yAfter + yBefore) / 2.0 * (xAfter - xBefore);
                continue;
            }
            throw new UnsupportedOperationException("No AUC calculation implemented for ROC interpolation " + (Object)((Object)this.rocInterpolation) + ".");
        }
        return auc;
    }

    public static enum RocInterpolation {
        maximum,
        linear,
        minimum;

    }
}

