/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.parameters.identification.advanced;

import com.compomics.util.experiment.personalization.ExperimentObject;

public class SequenceMatchingParameters
extends ExperimentObject {
    private MatchingType sequenceMatchingType;
    private double limitX = 0.25;
    private Boolean enzymaticTagsOnly = false;
    private int maxPtmsPerTagPeptide = 3;
    private Integer minAminoAcidScore = 30;
    private Integer minTagLength = 3;
    public static final SequenceMatchingParameters DEFAULT_STRING_MATCHING = SequenceMatchingParameters.getStringMatching();

    public static SequenceMatchingParameters getStringMatching() {
        SequenceMatchingParameters sequenceMatchingPreferences = new SequenceMatchingParameters();
        sequenceMatchingPreferences.setSequenceMatchingType(MatchingType.string);
        return sequenceMatchingPreferences;
    }

    public static SequenceMatchingParameters getDefaultSequenceMatching() {
        SequenceMatchingParameters sequenceMatchingPreferences = new SequenceMatchingParameters();
        sequenceMatchingPreferences.setSequenceMatchingType(MatchingType.indistiguishableAminoAcids);
        sequenceMatchingPreferences.setLimitX(0.25);
        sequenceMatchingPreferences.setMaxPtmsPerTagPeptide(3);
        return sequenceMatchingPreferences;
    }

    public MatchingType getSequenceMatchingType() {
        return this.sequenceMatchingType;
    }

    public void setSequenceMatchingType(MatchingType sequenceMatchingType) {
        this.sequenceMatchingType = sequenceMatchingType;
    }

    public double getLimitX() {
        return this.limitX;
    }

    public void setLimitX(double limitX) {
        this.limitX = limitX;
    }

    public boolean isSameAs(SequenceMatchingParameters sequenceMatchingPreferences) {
        if (this.sequenceMatchingType != sequenceMatchingPreferences.getSequenceMatchingType()) {
            return false;
        }
        if (this.limitX != sequenceMatchingPreferences.getLimitX()) {
            return false;
        }
        if (this.isEnzymaticTagsOnly() != sequenceMatchingPreferences.isEnzymaticTagsOnly()) {
            return false;
        }
        if (this.maxPtmsPerTagPeptide != sequenceMatchingPreferences.getMaxPtmsPerTagPeptide()) {
            return false;
        }
        if (this.getMinAminoAcidScore() != sequenceMatchingPreferences.getMinAminoAcidScore()) {
            return false;
        }
        return this.getMinTagLength() == sequenceMatchingPreferences.getMinTagLength();
    }

    public String getShortDescription() {
        String newLine = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        output.append("Method: ").append((Object)this.sequenceMatchingType).append(".").append(newLine);
        output.append("Max share of x's: ").append(this.limitX).append(".").append(newLine);
        output.append("Enzymatic tags matching: ").append(this.isEnzymaticTagsOnly()).append(".").append(newLine);
        output.append("Max PTMs per tag: ").append(this.getMaxPtmsPerTagPeptide()).append(".");
        output.append("Min amino acid score: ").append(this.getMinAminoAcidScore()).append(".");
        output.append("Min tag length: ").append(this.getMinTagLength()).append(".");
        return output.toString();
    }

    public boolean isEnzymaticTagsOnly() {
        if (this.enzymaticTagsOnly == null) {
            this.enzymaticTagsOnly = false;
        }
        return this.enzymaticTagsOnly;
    }

    public void setEnzymaticTagsOnly(boolean enzymaticTagsOnly) {
        this.enzymaticTagsOnly = enzymaticTagsOnly;
    }

    public int getMaxPtmsPerTagPeptide() {
        return this.maxPtmsPerTagPeptide;
    }

    public void setMaxPtmsPerTagPeptide(int numberOfPtmsPerTagPeptide) {
        this.maxPtmsPerTagPeptide = numberOfPtmsPerTagPeptide;
    }

    public int getMinAminoAcidScore() {
        if (this.minAminoAcidScore == null) {
            this.minAminoAcidScore = 30;
        }
        return this.minAminoAcidScore;
    }

    public void setMinAminoAcidScore(int minAminoAcidScore) {
        this.minAminoAcidScore = minAminoAcidScore;
    }

    public int getMinTagLength() {
        if (this.minAminoAcidScore == null) {
            this.minAminoAcidScore = 3;
        }
        return this.minTagLength;
    }

    public void setMinTagLength(int minTagLength) {
        this.minTagLength = minTagLength;
    }

    public static enum MatchingType {
        string(0, "Character Sequence"),
        aminoAcid(1, "Amino Acids"),
        indistiguishableAminoAcids(2, "Indistinguishable Amino Acids");

        public final int index;
        public final String description;

        private MatchingType(int index, String description) {
            this.index = index;
            this.description = description;
        }

        public String toString() {
            return this.description;
        }

        public static String getCommandLineOptions() {
            StringBuilder optionsStringBuilder = new StringBuilder();
            for (MatchingType matchingType : MatchingType.values()) {
                if (optionsStringBuilder.length() != 0) {
                    optionsStringBuilder.append(", ");
                }
                optionsStringBuilder.append(matchingType.index).append(": ").append(matchingType.description);
            }
            return optionsStringBuilder.toString();
        }

        public static MatchingType getMatchingType(int index) {
            for (MatchingType matchingType : MatchingType.values()) {
                if (matchingType.index != index) continue;
                return matchingType;
            }
            throw new IllegalArgumentException("No matching type found for index " + index + ".");
        }
    }
}

