/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.protein;

import com.compomics.util.interfaces.Modification;
import com.compomics.util.protein.ModificationTemplate;
import java.util.Collection;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModificationImplementation
implements Modification,
Cloneable {
    Logger logger = LogManager.getLogger(ModificationImplementation.class);
    protected ModificationTemplate iTemplate = null;
    protected int iLocation = -1;

    public ModificationImplementation() {
    }

    public ModificationImplementation(ModificationTemplate aTemplate, int aLocation) {
        this.iTemplate = aTemplate;
        this.iLocation = aLocation;
    }

    public ModificationImplementation(String aTitle, String aCode, HashMap aMassDeltas, int aLocation) {
        this(aTitle, aCode, aMassDeltas, false, aLocation);
    }

    public ModificationImplementation(String aTitle, String aCode, HashMap aMassDeltas, boolean aArtifact, int aLocation) {
        this(new ModificationTemplate(aTitle, aCode, aMassDeltas, aArtifact), aLocation);
    }

    @Override
    public double getAverageMassDelta(String aResidue) {
        return this.getMassDelta(aResidue, 1);
    }

    @Override
    public String getCode() {
        return this.iTemplate.getCode();
    }

    @Override
    public String getTitle() {
        return this.iTemplate.getTitle();
    }

    @Override
    public int getLocation() {
        return this.iLocation;
    }

    @Override
    public Collection getResidues() {
        return this.iTemplate.getResidues();
    }

    @Override
    public double getMonoisotopicMassDelta(String aResidue) {
        return this.getMassDelta(aResidue, 0);
    }

    @Override
    public void setLocation(int aLocation) {
        this.iLocation = aLocation;
    }

    @Override
    public boolean isArtifact() {
        return this.iTemplate.isArtifact();
    }

    public boolean equals(Object obj) {
        boolean result = true;
        result = obj == null || !obj.getClass().equals(this.getClass()) ? false : (((ModificationImplementation)obj).iLocation == this.iLocation ? this.iTemplate.equals(((ModificationImplementation)obj).iTemplate) : false);
        return result;
    }

    public int hashCode() {
        return this.iTemplate.hashCode();
    }

    @Override
    public String toString() {
        return this.iTemplate.toString() + "\n\tLocation: : " + this.iLocation;
    }

    public Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            this.logger.error(cnse.getMessage(), (Throwable)cnse);
        }
        return clone;
    }

    public int compareTo(Object o) {
        ModificationImplementation mi = (ModificationImplementation)o;
        int result = this.iLocation - mi.iLocation;
        if (result == 0) {
            result = this.iTemplate.compareTo(mi.iTemplate);
        }
        return result;
    }

    protected double getMassDelta(String aResidue, int aMonoOrAvg) {
        return this.iTemplate.getMassDelta(aResidue, aMonoOrAvg);
    }
}

