/*
 * Decompiled with CFR 0.152.
 */
package de.proteinms.omxparser.tools;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;

public class ProgressDialog
extends JDialog {
    private boolean doNothingOnClose = false;
    private JProgressBar progressBar;

    public ProgressDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(parent);
    }

    public ProgressDialog(JDialog parent, boolean modal) {
        super((Dialog)parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(parent);
    }

    public void setValue(final int value) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.progressBar.setValue(value);
            }
        });
    }

    public void setMax(final int value) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.progressBar.setMaximum(value);
            }
        });
    }

    public void setIntermidiate(final boolean intermidiate) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.progressBar.setStringPainted(!intermidiate);
                ProgressDialog.this.progressBar.setIndeterminate(intermidiate);
            }
        });
    }

    public void setString(final String currentFileName) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.progressBar.setStringPainted(currentFileName != null);
                ProgressDialog.this.progressBar.setString(currentFileName);
            }
        });
    }

    public void doNothingOnClose() {
        this.doNothingOnClose = true;
    }

    private void initComponents() {
        this.progressBar = new JProgressBar();
        this.setDefaultCloseOperation(0);
        this.setTitle("Please Wait");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ProgressDialog.this.formWindowClosing(evt);
            }
        });
        this.progressBar.setFont(this.progressBar.getFont().deriveFont((float)this.progressBar.getFont().getSize() - 1.0f));
        this.progressBar.setIndeterminate(true);
        this.progressBar.setStringPainted(true);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.progressBar, -1, 406, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.progressBar, -2, 19, -2).addContainerGap()));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        int option;
        if (!this.doNothingOnClose && (option = JOptionPane.showConfirmDialog(this.getParent(), "Closing the progress bar will close OMSSA Viewer.\nClose the progress bar?", "Close OMSSA Viewer?", 0)) == 0) {
            System.exit(0);
        }
    }
}

