/*
 * Decompiled with CFR 0.152.
 */
package de.proteinms.omxparser.util;

import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.identification.IdfileReader;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.io.IoUtil;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import de.proteinms.omxparser.OmssaOmxFile;
import de.proteinms.omxparser.util.MSHitSet;
import de.proteinms.omxparser.util.MSHits;
import de.proteinms.omxparser.util.MSModHit;
import de.proteinms.omxparser.util.MSRequest;
import de.proteinms.omxparser.util.MSResponse;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;

public class OMSSAIdfileReader
extends ExperimentObject
implements IdfileReader {
    private File identificationFile;
    private OmssaOmxFile omxFile;

    public OMSSAIdfileReader() {
    }

    public OMSSAIdfileReader(File idFile) {
        this.identificationFile = idFile;
        this.omxFile = new OmssaOmxFile(idFile.getPath(), false, false, false);
    }

    public String getFileName() {
        return this.identificationFile.getName();
    }

    public String getExtension() {
        return ".omx";
    }

    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        return this.getAllSpectrumMatches(spectrumProvider, waitingHandler, searchParameters, null, true);
    }

    public ArrayList<SpectrumMatch> getAllSpectrumMatches(SpectrumProvider spectrumProvider, WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingParameters sequenceMatchingParameters, boolean expandAaCombinations) throws IOException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        ArrayList<SpectrumMatch> result = new ArrayList<SpectrumMatch>();
        List<MSResponse> msSearchResponse = this.omxFile.getParserResult().MSSearch_response.MSResponse;
        List<MSRequest> msRequest = this.omxFile.getParserResult().MSSearch_request.MSRequest;
        int spectrumMatchCounter = 0;
        block0: for (int i = 0; i < msSearchResponse.size(); ++i) {
            String msFile = msRequest.get((int)i).MSRequest_settings.MSSearchSettings.MSSearchSettings_infiles.MSInFile.MSInFile_infile;
            Map<Integer, MSHitSet> msHitSetMap = msSearchResponse.get((int)i).MSResponse_hitsets.MSHitSet;
            if (waitingHandler != null) {
                waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                waitingHandler.setMaxSecondaryProgressCounter(msHitSetMap.size());
            }
            for (int spectrumIndex : msHitSetMap.keySet()) {
                MSHitSet msHitSet = msHitSetMap.get(spectrumIndex);
                List<MSHits> hitSet = msHitSet.MSHitSet_hits.MSHits;
                if (hitSet.size() > 0) {
                    HashMap hitMap = new HashMap();
                    for (MSHits msHits : hitSet) {
                        if (!hitMap.containsKey(msHits.MSHits_evalue)) {
                            hitMap.put(msHits.MSHits_evalue, new ArrayList());
                        }
                        ((ArrayList)hitMap.get(msHits.MSHits_evalue)).add(msHits);
                    }
                    ArrayList eValues = new ArrayList(hitMap.keySet());
                    Collections.sort(eValues);
                    String tempTitle = msHitSet.MSHitSet_ids.MSHitSet_ids_E.get(0);
                    String spectrumTitle = this.fixMgfTitle(tempTitle);
                    String fileName = IoUtil.getFileName((String)msFile);
                    SpectrumMatch currentMatch = new SpectrumMatch(fileName, spectrumTitle);
                    int rank = 1;
                    Iterator iterator = eValues.iterator();
                    while (iterator.hasNext()) {
                        double eValue = (Double)iterator.next();
                        for (MSHits msHits : (ArrayList)hitMap.get(eValue)) {
                            PeptideAssumption peptideAssumption = this.getPeptideAssumption(msHits, rank);
                            if (expandAaCombinations && AminoAcidSequence.hasCombination((String)peptideAssumption.getPeptide().getSequence())) {
                                Peptide peptide = peptideAssumption.getPeptide();
                                ModificationMatch[] previousModificationMatches = peptide.getVariableModifications();
                                for (StringBuilder expandedSequence : AminoAcidSequence.getCombinations((String)peptide.getSequence())) {
                                    ModificationMatch[] newModificationMatches = (ModificationMatch[])Arrays.stream(previousModificationMatches).map(modificationMatch -> modificationMatch.clone()).toArray(ModificationMatch[]::new);
                                    Peptide newPeptide = new Peptide(expandedSequence.toString(), newModificationMatches, true);
                                    PeptideAssumption newAssumption = new PeptideAssumption(newPeptide, peptideAssumption.getRank(), peptideAssumption.getAdvocate(), peptideAssumption.getIdentificationCharge(), peptideAssumption.getRawScore(), peptideAssumption.getScore(), peptideAssumption.getIdentificationFile());
                                    currentMatch.addPeptideAssumption(Advocate.omssa.getIndex(), newAssumption);
                                }
                                continue;
                            }
                            currentMatch.addPeptideAssumption(Advocate.omssa.getIndex(), peptideAssumption);
                        }
                        rank += ((ArrayList)hitMap.get(eValue)).size();
                    }
                    result.add(currentMatch);
                }
                if (waitingHandler == null) continue;
                if (waitingHandler.isRunCanceled()) continue block0;
                waitingHandler.setSecondaryProgressCounter(++spectrumMatchCounter);
            }
        }
        return result;
    }

    private PeptideAssumption getPeptideAssumption(MSHits currentMsHit, int rank) {
        int charge = currentMsHit.MSHits_charge;
        List<MSModHit> msModHits = currentMsHit.MSHits_mods.MSModHit;
        ArrayList<ModificationMatch> modificationsFound = new ArrayList<ModificationMatch>();
        for (MSModHit msModHit : msModHits) {
            int msMod = msModHit.MSModHit_modtype.MSMod;
            String name = msMod + "";
            int location = msModHit.MSModHit_site + 1;
            modificationsFound.add(new ModificationMatch(name, location));
        }
        String peptideSequence = currentMsHit.MSHits_pepstring;
        Peptide peptide = new Peptide(peptideSequence, modificationsFound.toArray(new ModificationMatch[modificationsFound.size()]), true);
        return new PeptideAssumption(peptide, rank, Advocate.omssa.getIndex(), charge, currentMsHit.MSHits_evalue, currentMsHit.MSHits_evalue, this.getFileName());
    }

    private String fixMgfTitle(String spectrumTitle) {
        try {
            spectrumTitle = URLDecoder.decode(spectrumTitle.trim(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("An exception was thrown when trying to decode an mgf tile!");
            e.printStackTrace();
        }
        spectrumTitle = spectrumTitle.replaceAll("\\\\\"", "\\\"");
        spectrumTitle = spectrumTitle.replaceAll("\\\\\\\\", "\\\\");
        return spectrumTitle;
    }

    public void close() throws IOException {
        this.omxFile = null;
    }

    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        ArrayList<String> versions = new ArrayList<String>();
        versions.add("2.1.9");
        result.put("OMSSA", versions);
        return result;
    }

    public boolean hasDeNovoTags() {
        return false;
    }
}

