/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker;

import com.compomics.software.CompomicsWrapper;
import com.compomics.util.db.object.ObjectsDB;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.ProjectParameters;
import com.compomics.util.experiment.biology.enzymes.EnzymeFactory;
import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.peptide_inference.PeptideInference;
import com.compomics.util.experiment.identification.peptide_shaker.Metrics;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.protein_inference.PeptideAndProteinBuilder;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.experiment.io.biology.protein.FastaSummary;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.quantification.spectrumcounting.ScalingFactorsEstimators;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.FractionParameters;
import com.compomics.util.parameters.identification.advanced.IdMatchValidationParameters;
import com.compomics.util.parameters.identification.advanced.ModificationLocalizationParameters;
import com.compomics.util.parameters.identification.advanced.PsmScoringParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.peptide_shaker.ProjectType;
import com.compomics.util.parameters.quantification.spectrum_counting.SpectrumCountingParameters;
import com.compomics.util.parameters.tools.ProcessingParameters;
import com.compomics.util.waiting.Duration;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.fileimport.FileImporter;
import eu.isas.peptideshaker.preferences.ProjectDetails;
import eu.isas.peptideshaker.processing.ProteinProcessor;
import eu.isas.peptideshaker.processing.PsmProcessor;
import eu.isas.peptideshaker.protein_inference.GroupSimplification;
import eu.isas.peptideshaker.protein_inference.ProteinInference;
import eu.isas.peptideshaker.ptm.ModificationLocalizationScorer;
import eu.isas.peptideshaker.scoring.PSMaps;
import eu.isas.peptideshaker.scoring.maps.InputMap;
import eu.isas.peptideshaker.scoring.psm_scoring.PsmScorer;
import eu.isas.peptideshaker.scoring.targetdecoy.TargetDecoyMap;
import eu.isas.peptideshaker.validation.MatchesValidator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;

public class PeptideShaker {
    public static final int TIMEOUT_DAYS = 365;
    private ProjectParameters projectParameters;
    private MatchesValidator matchesValidator;
    private final ModificationLocalizationScorer modificationLocalizationScorer = new ModificationLocalizationScorer();
    private FileImporter fileImporter = null;
    private static String USER_PREFERENCES_FILE = System.getProperty("user.home") + "/.peptideshaker/userpreferences_2.0.cpf";
    public static final String PEPTIDESHAKER_CONFIGURATION_FILE = "PeptideShaker_configuration.txt";
    private static String DATABASE_DIRECTORY = "matches";
    public static String DATA_DIRECTORY = "data";
    private static String SERIALIZATION_PARENT_DIRECTORY = "resources";
    private static File configFolder = null;
    private final ModificationFactory modificationFactory = ModificationFactory.getInstance();
    private final Metrics metrics = new Metrics();
    private GeneMaps geneMaps = new GeneMaps();
    private IdentificationFeaturesGenerator identificationFeaturesGenerator;
    private Duration projectCreationDuration;
    private ObjectsDB objectsDB;
    private Identification identification;
    private SequenceProvider sequenceProvider;
    private ProteinDetailsProvider proteinDetailsProvider;
    private HashMap<String, Integer> proteinCount;
    private InputMap inputMap;

    private PeptideShaker() {
    }

    public PeptideShaker(ProjectParameters projectParameters) {
        this.projectParameters = projectParameters;
    }

    public int importFiles(WaitingHandler waitingHandler, ArrayList<File> idFiles, SpectrumProvider spectrumProvider, IdentificationParameters identificationParameters, ProjectDetails projectDetails, ProcessingParameters processingParameters, ExceptionHandler exceptionHandler) {
        this.projectCreationDuration = new Duration();
        this.projectCreationDuration.start();
        waitingHandler.appendReport("Import process for " + this.projectParameters.getProjectUniqueName(), true, true);
        waitingHandler.appendReportEndLine();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss");
        String dbName = this.projectParameters.getProjectUniqueName() + df.format(this.projectParameters.getCreationTime()) + ".psdb";
        this.objectsDB = new ObjectsDB(PeptideShaker.getMatchesFolder().getAbsolutePath(), dbName);
        this.identification = new Identification(this.objectsDB);
        this.identification.addObject(ProjectParameters.key, this.projectParameters);
        this.fileImporter = new FileImporter(this.identification, identificationParameters, processingParameters, this.metrics, projectDetails, spectrumProvider, waitingHandler, exceptionHandler);
        int outcome = this.fileImporter.importFiles(idFiles);
        if (outcome == 0) {
            this.geneMaps = this.fileImporter.getGeneMaps();
            this.sequenceProvider = this.fileImporter.getSequenceProvider();
            this.proteinDetailsProvider = this.fileImporter.getProteinDetailsProvider();
            this.inputMap = this.fileImporter.getInputMap();
            this.proteinCount = this.fileImporter.getProteinCount();
            return 0;
        }
        return 1;
    }

    public void createProject(IdentificationParameters identificationParameters, ProcessingParameters processingParameters, SpectrumCountingParameters spectrumCountingParameters, SpectrumProvider spectrumProvider, ProjectDetails projectDetails, ProjectType projectType, WaitingHandler waitingHandler, boolean setWaitingHandlerFinshedWhenDone, ExceptionHandler exceptionHandler) throws InterruptedException, TimeoutException, IOException {
        this.identification.getObjectsDB().commit();
        this.identificationFeaturesGenerator = new IdentificationFeaturesGenerator(this.identification, identificationParameters, this.sequenceProvider, spectrumProvider, this.metrics, spectrumCountingParameters);
        this.matchesValidator = new MatchesValidator(new TargetDecoyMap(), new TargetDecoyMap(), new TargetDecoyMap());
        if (waitingHandler.isRunCanceled()) {
            return;
        }
        PsmScoringParameters psmScoringPreferences = identificationParameters.getPsmScoringParameters();
        FastaParameters fastaParameters = identificationParameters.getFastaParameters();
        FastaSummary fastaSummary = FastaSummary.getSummary(projectDetails.getFastaFile(), fastaParameters, waitingHandler);
        identificationParameters.getGeneParameters().setBackgroundSpeciesFromFastaSummary(fastaSummary);
        ArrayList<Integer> usedAlgorithms = projectDetails.getIdentificationAlgorithms();
        if (psmScoringPreferences.isScoringNeeded(usedAlgorithms)) {
            waitingHandler.appendReport("Estimating PSM scores.", true, true);
            PsmScorer psmScorer = new PsmScorer(fastaParameters, this.sequenceProvider, spectrumProvider);
            psmScorer.estimateIntermediateScores(this.identification, this.inputMap, processingParameters, identificationParameters, waitingHandler, exceptionHandler);
            if (psmScoringPreferences.isTargetDecoyNeededForPsmScoring(usedAlgorithms)) {
                if (fastaParameters.isTargetDecoy()) {
                    waitingHandler.appendReport("Estimating intermediate scores probabilities.", true, true);
                    psmScorer.estimateIntermediateScoreProbabilities(this.identification, this.inputMap, processingParameters, waitingHandler);
                } else {
                    waitingHandler.appendReport("No decoy sequences found. Impossible to estimate intermediate scores probabilities.", true, true);
                }
            }
            waitingHandler.appendReport("Scoring PSMs.", true, true);
            psmScorer.scorePsms(this.identification, this.inputMap, processingParameters, identificationParameters, waitingHandler);
        }
        this.identification.getObjectsDB().commit();
        System.gc();
        if (fastaParameters.isTargetDecoy()) {
            waitingHandler.appendReport("Computing assumptions probabilities.", true, true);
        } else {
            waitingHandler.appendReport("Importing assumptions scores.", true, true);
        }
        this.inputMap.estimateProbabilities(waitingHandler);
        waitingHandler.increasePrimaryProgressCounter();
        if (waitingHandler.isRunCanceled()) {
            return;
        }
        this.identification.getObjectsDB().commit();
        System.gc();
        waitingHandler.appendReport("Saving assumptions probabilities, selecting best match, scoring modification localization.", true, true);
        PsmProcessor psmProcessor = new PsmProcessor(this.identification);
        psmProcessor.processPsms(this.inputMap, identificationParameters, this.matchesValidator, this.modificationLocalizationScorer, this.sequenceProvider, spectrumProvider, this.modificationFactory, this.proteinCount, processingParameters.getnThreads(), waitingHandler, exceptionHandler);
        waitingHandler.increasePrimaryProgressCounter();
        if (waitingHandler.isRunCanceled()) {
            return;
        }
        this.identification.getObjectsDB().commit();
        System.gc();
        waitingHandler.appendReport("Computing PSM probabilities.", true, true);
        this.matchesValidator.getPsmMap().estimateProbabilities(waitingHandler);
        if (waitingHandler.isRunCanceled()) {
            return;
        }
        this.identification.getObjectsDB().commit();
        System.gc();
        if (projectType == ProjectType.peptide || projectType == ProjectType.protein) {
            PeptideInference peptideInference = new PeptideInference();
            ModificationLocalizationParameters modificationScoringPreferences = identificationParameters.getModificationLocalizationParameters();
            if (modificationScoringPreferences.getAlignNonConfidentModifications()) {
                waitingHandler.appendReport("Resolving peptide inference issues.", true, true);
                peptideInference.peptideInference(this.identification, identificationParameters, this.sequenceProvider, this.modificationFactory, waitingHandler);
                waitingHandler.increasePrimaryProgressCounter();
                if (waitingHandler.isRunCanceled()) {
                    return;
                }
            }
            this.identification.getObjectsDB().commit();
            System.gc();
        }
        String reportTxt = "Saving probabilities";
        String waitingTitle = "Saving Probabilities.";
        switch (projectType) {
            case psm: {
                reportTxt = reportTxt + ".";
                break;
            }
            case peptide: {
                reportTxt = reportTxt + ", building peptides.";
                waitingTitle = waitingTitle + " Building Peptides.";
                break;
            }
            default: {
                reportTxt = reportTxt + ", building peptides and proteins.";
                waitingTitle = waitingTitle + " Building Peptides and Proteins.";
            }
        }
        waitingHandler.appendReport(reportTxt, true, true);
        waitingHandler.setWaitingText(waitingTitle + " Please Wait...");
        this.attachSpectrumProbabilitiesAndBuildPeptidesAndProteins(this.sequenceProvider, identificationParameters.getSequenceMatchingParameters(), projectType, fastaParameters, waitingHandler);
        waitingHandler.increasePrimaryProgressCounter();
        if (waitingHandler.isRunCanceled()) {
            return;
        }
        this.identification.getObjectsDB().commit();
        System.gc();
        if (projectType == ProjectType.peptide || projectType == ProjectType.protein) {
            waitingHandler.appendReport("Generating peptide map.", true, true);
            this.matchesValidator.fillPeptideMaps(this.identification, this.metrics, waitingHandler, identificationParameters, this.sequenceProvider, spectrumProvider);
            if (waitingHandler.isRunCanceled()) {
                return;
            }
            this.identification.getObjectsDB().commit();
            System.gc();
            waitingHandler.appendReport("Computing peptide probabilities.", true, true);
            this.matchesValidator.getPeptideMap().estimateProbabilities(waitingHandler);
            if (waitingHandler.isRunCanceled()) {
                return;
            }
            this.identification.getObjectsDB().commit();
            System.gc();
            waitingHandler.appendReport("Saving peptide probabilities.", true, true);
            this.matchesValidator.attachPeptideProbabilities(this.identification, fastaParameters, waitingHandler);
            waitingHandler.increasePrimaryProgressCounter();
            if (waitingHandler.isRunCanceled()) {
                return;
            }
            this.identification.getObjectsDB().commit();
            System.gc();
            if (projectType == ProjectType.protein) {
                if (identificationParameters.getProteinInferenceParameters().getSimplifyGroups()) {
                    waitingHandler.appendReport("Simplifying protein groups.", true, true);
                    GroupSimplification groupSimplification = new GroupSimplification();
                    groupSimplification.removeRedundantGroups(this.identification, identificationParameters, this.sequenceProvider, this.proteinDetailsProvider, waitingHandler);
                    waitingHandler.increasePrimaryProgressCounter();
                    if (waitingHandler.isRunCanceled()) {
                        return;
                    }
                }
                this.identification.getObjectsDB().commit();
                System.gc();
                ProteinInference proteinInference = new ProteinInference();
                waitingHandler.appendReport("Mapping shared peptides.", true, true);
                proteinInference.distributeSharedPeptides(this.identification, waitingHandler);
                waitingHandler.increasePrimaryProgressCounter();
                if (waitingHandler.isRunCanceled()) {
                    return;
                }
                this.identification.getObjectsDB().commit();
                System.gc();
                waitingHandler.appendReport("Generating protein map.", true, true);
                this.matchesValidator.fillProteinMap(this.identification, spectrumProvider, waitingHandler);
                waitingHandler.increasePrimaryProgressCounter();
                if (waitingHandler.isRunCanceled()) {
                    return;
                }
                this.identification.getObjectsDB().commit();
                System.gc();
                waitingHandler.appendReport("Selecting leading proteins, inferring peptide and protein inference status.", true, true);
                proteinInference.inferPiStatus(this.identification, this.metrics, this.matchesValidator.getProteinMap(), identificationParameters, this.sequenceProvider, this.proteinDetailsProvider, waitingHandler);
                waitingHandler.increasePrimaryProgressCounter();
                if (waitingHandler.isRunCanceled()) {
                    return;
                }
                this.identification.getObjectsDB().commit();
                System.gc();
                waitingHandler.appendReport("Computing protein probabilities.", true, true);
                this.matchesValidator.getProteinMap().estimateProbabilities(waitingHandler);
                if (waitingHandler.isRunCanceled()) {
                    return;
                }
                this.identification.getObjectsDB().commit();
                System.gc();
                waitingHandler.appendReport("Saving protein probabilities.", true, true);
                this.matchesValidator.attachProteinProbabilities(this.identification, this.sequenceProvider, fastaParameters, this.metrics, waitingHandler, identificationParameters.getFractionParameters());
                waitingHandler.increasePrimaryProgressCounter();
                if (waitingHandler.isRunCanceled()) {
                    return;
                }
                this.identification.getObjectsDB().commit();
                System.gc();
            }
        }
        if (fastaParameters.isTargetDecoy()) {
            IdMatchValidationParameters idMatchValidationParameters = identificationParameters.getIdValidationParameters();
            if (idMatchValidationParameters.getDefaultPsmFDR() == 1.0 && idMatchValidationParameters.getDefaultPeptideFDR() == 1.0 && idMatchValidationParameters.getDefaultProteinFDR() == 1.0) {
                waitingHandler.appendReport("Validating identifications at 1% FDR, quality control of matches.", true, true);
            } else {
                waitingHandler.appendReport("Validating identifications, quality control of matches.", true, true);
            }
        } else {
            waitingHandler.appendReport("Quality control of matches.", true, true);
        }
        this.matchesValidator.validateIdentifications(this.identification, this.metrics, this.inputMap, waitingHandler, exceptionHandler, this.identificationFeaturesGenerator, this.sequenceProvider, this.proteinDetailsProvider, spectrumProvider, this.geneMaps, identificationParameters, projectType, processingParameters);
        waitingHandler.increasePrimaryProgressCounter();
        if (waitingHandler.isRunCanceled()) {
            return;
        }
        this.identification.getObjectsDB().commit();
        System.gc();
        if (projectType == ProjectType.peptide || projectType == ProjectType.protein) {
            waitingHandler.appendReport("Scoring PTMs in peptides.", true, true);
            this.modificationLocalizationScorer.scorePeptidePtms(this.identification, this.modificationFactory, this.sequenceProvider, waitingHandler, identificationParameters);
            waitingHandler.increasePrimaryProgressCounter();
            if (waitingHandler.isRunCanceled()) {
                return;
            }
            this.identification.getObjectsDB().commit();
            System.gc();
            if (projectType == ProjectType.protein) {
                waitingHandler.appendReport("Estimating spectrum counting scaling values.", true, true);
                ScalingFactorsEstimators scalingFactors = new ScalingFactorsEstimators(spectrumCountingParameters);
                scalingFactors.estimateScalingFactors(this.identification, this.metrics, this.sequenceProvider, this.identificationFeaturesGenerator, waitingHandler, exceptionHandler, processingParameters);
                waitingHandler.increasePrimaryProgressCounter();
                if (waitingHandler.isRunCanceled()) {
                    return;
                }
                this.identification.getObjectsDB().commit();
                System.gc();
                waitingHandler.appendReport("Scoring PTMs in proteins, gathering summary metrics.", true, true);
                ProteinProcessor proteinProcessor = new ProteinProcessor(this.identification, identificationParameters, this.identificationFeaturesGenerator, this.sequenceProvider);
                proteinProcessor.processProteins(this.modificationLocalizationScorer, this.metrics, this.modificationFactory, waitingHandler, exceptionHandler, processingParameters);
                waitingHandler.increasePrimaryProgressCounter();
                if (waitingHandler.isRunCanceled()) {
                    return;
                }
                this.identification.getObjectsDB().commit();
                System.gc();
            }
        }
        this.projectCreationDuration.end();
        String report = "Identification processing completed (" + this.projectCreationDuration.toString() + ").";
        waitingHandler.appendReport(report, true, true);
        waitingHandler.appendReportEndLine();
        waitingHandler.appendReportEndLine();
        this.identification.addUrParam(new PSMaps(this.inputMap, this.matchesValidator.getPsmMap(), this.matchesValidator.getPeptideMap(), this.matchesValidator.getProteinMap()));
        if (setWaitingHandlerFinshedWhenDone) {
            waitingHandler.setRunFinished();
        }
    }

    public void spectrumMapChanged(Identification identification, WaitingHandler waitingHandler, ProcessingParameters processingPreferences, IdentificationParameters identificationParameters, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, ProjectType projectType) {
        FastaParameters fastaParameters = identificationParameters.getFastaParameters();
        FractionParameters fractionParameters = identificationParameters.getFractionParameters();
        TargetDecoyMap peptideMap = new TargetDecoyMap();
        TargetDecoyMap proteinMap = new TargetDecoyMap();
        this.matchesValidator.setPeptideMap(peptideMap);
        this.matchesValidator.setProteinMap(proteinMap);
        this.attachSpectrumProbabilitiesAndBuildPeptidesAndProteins(sequenceProvider, identificationParameters.getSequenceMatchingParameters(), projectType, fastaParameters, waitingHandler);
        this.matchesValidator.fillPeptideMaps(identification, this.metrics, waitingHandler, identificationParameters, sequenceProvider, spectrumProvider);
        peptideMap.estimateProbabilities(waitingHandler);
        this.matchesValidator.attachPeptideProbabilities(identification, fastaParameters, waitingHandler);
        this.matchesValidator.fillProteinMap(identification, spectrumProvider, waitingHandler);
        proteinMap.estimateProbabilities(waitingHandler);
        this.matchesValidator.attachProteinProbabilities(identification, sequenceProvider, fastaParameters, this.metrics, waitingHandler, fractionParameters);
    }

    public void peptideMapChanged(Identification identification, WaitingHandler waitingHandler, IdentificationParameters identificationParameters, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider) {
        FastaParameters fastaParameters = identificationParameters.getFastaParameters();
        FractionParameters fractionParameters = identificationParameters.getFractionParameters();
        TargetDecoyMap proteinMap = new TargetDecoyMap();
        this.matchesValidator.setProteinMap(proteinMap);
        this.matchesValidator.attachPeptideProbabilities(identification, fastaParameters, waitingHandler);
        this.matchesValidator.fillProteinMap(identification, spectrumProvider, waitingHandler);
        proteinMap.estimateProbabilities(waitingHandler);
        this.matchesValidator.attachProteinProbabilities(identification, sequenceProvider, fastaParameters, this.metrics, waitingHandler, fractionParameters);
    }

    public void proteinMapChanged(Identification identification, WaitingHandler waitingHandler, IdentificationParameters identificationParameters, SequenceProvider sequenceProvider) {
        FastaParameters fastaParameters = identificationParameters.getFastaParameters();
        FractionParameters fractionParameters = identificationParameters.getFractionParameters();
        this.matchesValidator.attachProteinProbabilities(identification, sequenceProvider, fastaParameters, this.metrics, waitingHandler, fractionParameters);
    }

    private void attachSpectrumProbabilitiesAndBuildPeptidesAndProteins(SequenceProvider sequenceProvider, SequenceMatchingParameters sequenceMatchingPreferences, ProjectType projectType, FastaParameters fastaParameters, WaitingHandler waitingHandler) {
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        waitingHandler.setMaxSecondaryProgressCounter(this.identification.getSpectrumIdentificationSize());
        PeptideAndProteinBuilder peptideAndProteinBuilder = new PeptideAndProteinBuilder(this.identification);
        ((Stream)this.identification.getSpectrumIdentification().values().stream().flatMap(keys -> keys.stream()).parallel()).map(key -> this.identification.getSpectrumMatch((long)key)).forEach(spectrumMatch -> this.attachSpectrumProbabilitiesAndBuildPeptidesAndProteins((SpectrumMatch)spectrumMatch, peptideAndProteinBuilder, sequenceProvider, sequenceMatchingPreferences, projectType, fastaParameters, waitingHandler));
        waitingHandler.setSecondaryProgressCounterIndeterminate(true);
    }

    private void attachSpectrumProbabilitiesAndBuildPeptidesAndProteins(SpectrumMatch spectrumMatch, PeptideAndProteinBuilder peptideAndProteinBuilder, SequenceProvider sequenceProvider, SequenceMatchingParameters sequenceMatchingPreferences, ProjectType projectType, FastaParameters fastaParameters, WaitingHandler waitingHandler) {
        if (waitingHandler.isRunCanceled()) {
            return;
        }
        PSParameter psParameter = (PSParameter)spectrumMatch.getUrParam(PSParameter.dummy);
        if (spectrumMatch.getBestPeptideAssumption() == null) {
            return;
        }
        if (fastaParameters.isTargetDecoy()) {
            double probability = this.matchesValidator.getPsmMap().getProbability(psParameter.getScore());
            psParameter.setProbability(probability);
        } else {
            psParameter.setProbability(1.0);
        }
        if (projectType == ProjectType.peptide || projectType == ProjectType.protein) {
            peptideAndProteinBuilder.buildPeptidesAndProteins(spectrumMatch, sequenceMatchingPreferences, sequenceProvider, projectType == ProjectType.protein);
        }
        this.identification.updateObject(spectrumMatch.getKey(), spectrumMatch);
        waitingHandler.increaseSecondaryProgressCounter();
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public GeneMaps getGeneMaps() {
        return this.geneMaps;
    }

    public Identification getIdentification() {
        return this.identification;
    }

    public SequenceProvider getSequenceProvider() {
        return this.sequenceProvider;
    }

    public ProteinDetailsProvider getProteinDetailsProvider() {
        return this.proteinDetailsProvider;
    }

    public void setGeneMaps(GeneMaps geneMaps) {
        this.geneMaps = geneMaps;
    }

    public IdentificationFeaturesGenerator getIdentificationFeaturesGenerator() {
        return this.identificationFeaturesGenerator;
    }

    public static String loadModifications(SearchParameters searchParameters) {
        String error = null;
        ArrayList<String> toCheck = ModificationFactory.getInstance().loadBackedUpModifications(searchParameters, true);
        if (!toCheck.isEmpty()) {
            error = "The definition of the following PTM(s) seems to have changed and were overwritten:\n";
            for (int i = 0; i < toCheck.size(); ++i) {
                if (i > 0) {
                    error = i < toCheck.size() - 1 ? error + ", " : error + " and ";
                }
                error = error + toCheck.get(i);
            }
            error = error + ".\nPlease verify the definition of the PTM(s) in the modifications editor.";
        }
        return error;
    }

    public static String getUserPreferencesFile() {
        return USER_PREFERENCES_FILE;
    }

    public static String getUserPreferencesFolder() {
        File tempFile = new File(PeptideShaker.getUserPreferencesFile());
        return tempFile.getParent();
    }

    public static void setUserPreferencesFolder(String userPreferencesFolder) {
        File tempFile = new File(userPreferencesFolder, "userpreferences.cpf");
        USER_PREFERENCES_FILE = tempFile.getAbsolutePath();
    }

    public static String getMatchesDirectorySubPath() {
        return DATABASE_DIRECTORY;
    }

    public static String getMatchesDirectoryParent() {
        return SERIALIZATION_PARENT_DIRECTORY;
    }

    public static File getMatchesDirectoryParentFile() {
        String matchesParentDirectory = PeptideShaker.getMatchesDirectoryParent();
        return matchesParentDirectory.equals("resources") ? new File(PeptideShaker.getConfigFolder(), matchesParentDirectory) : new File(matchesParentDirectory);
    }

    public static void setMatchesDirectoryParent(String matchesDirectoryParent) throws IOException {
        SERIALIZATION_PARENT_DIRECTORY = matchesDirectoryParent;
        File serializationFolder = new File(matchesDirectoryParent, PeptideShaker.getMatchesDirectorySubPath());
        if (!serializationFolder.exists()) {
            serializationFolder.mkdirs();
            if (!serializationFolder.exists()) {
                throw new IOException("Impossible to create folder " + serializationFolder.getAbsolutePath() + ".");
            }
        }
    }

    public static File getMatchesFolder() {
        return new File(PeptideShaker.getMatchesDirectoryParentFile(), PeptideShaker.getMatchesDirectorySubPath());
    }

    public static void instantiateFacories(UtilitiesUserParameters utilitiesUserPreferences) {
        EnzymeFactory.getInstance();
        ModificationFactory.getInstance();
    }

    public static String getVersion() {
        Properties p = new Properties();
        try {
            InputStream is = new PeptideShaker().getClass().getClassLoader().getResourceAsStream("peptide-shaker.properties");
            p.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return p.getProperty("peptide-shaker.version");
    }

    public static String getJarFilePath() {
        return CompomicsWrapper.getJarFilePath(new PeptideShaker().getClass().getResource("PeptideShaker.class").getPath(), "PeptideShaker");
    }

    public static File getConfigFolder() {
        if (configFolder != null) {
            return configFolder;
        }
        return new File(PeptideShaker.getJarFilePath());
    }

    public static void setConfigFolder(File aConfigFolder) {
        configFolder = aConfigFolder;
    }
}

