/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.cmd;

import eu.isas.peptideshaker.cmd.PathSettingsCLIParams;
import eu.isas.peptideshaker.followup.FastaExport;
import eu.isas.peptideshaker.followup.InclusionListExport;
import eu.isas.peptideshaker.followup.ProgenesisExport;
import eu.isas.peptideshaker.followup.SpectrumExporter;
import org.apache.commons.cli.Options;

public enum FollowUpCLIParams {
    PSDB_FILE("in", "PeptideShaker project (.psdb or .zip file)", true, true),
    RECALIBRATION_FOLDER("recalibration_folder", "Output folder for the recalibrated files. (Existing files will be overwritten.)", true, false),
    RECALIBRATION_MODE("recalibration_mode", "Recalibration type. 0: precursor and fragment ions (default), 1: precursor only, 2: fragment ions only.", true, false),
    SPECTRUM_FOLDER("spectrum_folder", "Output folder for the spectra. (Existing files will be overwritten.)", true, false),
    PSM_TYPE("psm_type", "Type of PSMs. " + SpectrumExporter.ExportType.getCommandLineOptions(), true, false),
    ACCESSIONS_FILE("accessions_file", "Output file to export the protein accessions in text format. (Existing files will be overwritten.)", true, false),
    ACCESSIONS_TYPE("accessions_type", "When exporting accessions, select a category of proteins. " + FastaExport.ExportType.getCommandLineOptions(), true, false),
    SEQUENCES_FILE("sequences_file", "File where to export the protein details in fasta format. (Existing files will be overwritten.)", true, false),
    SEQUENCES_TYPE("sequences_type", "When exporting protein details, select a category of proteins. " + FastaExport.ExportType.getCommandLineOptions(), true, false),
    PROGENESIS_FILE("progenesis_file", "Output file for identification results in Progenesis LC-MS compatible format. (Existing files will be overwritten.)", true, false),
    PROGENESIS_TYPE("progenesis_type", "Type of hits to export to Progenesis. " + ProgenesisExport.ExportType.getCommandLineOptions(), true, false),
    PROGENESIS_TARGETED_PTMS("progenesis_ptms", "For the progenesis PTM export, the comma separated list of targeted PTMs in a list of PTM names", true, false),
    PEPNOVO_TRAINING_FOLDER("pepnovo_training_folder", "Output folder for PepNovo training files. (Existing files will be overwritten.)", true, false),
    PEPNOVO_TRAINING_RECALIBRATION("pepnovo_training_recalibration", "Indicate whether the exported mgf files shall be recalibrated. 0: No, 1: Yes (default).", true, false),
    PEPNOVO_TRAINING_FDR("pepnovo_training_fdr", "FDR used for the 'good spectra' export. If not set, the validation FDR will be used.", true, false),
    PEPNOVO_TRAINING_FNR("pepnovo_training_fnr", "FNR used for the 'bad spectra' export. If not set, the same value as for the 'good spectra' FDR will be used.", true, false),
    INCLUSION_LIST_FILE("inclusion_list_file", "Output file for an inclusion list of validated hits. (Existing files will be overwritten.)", true, false),
    INCLUSION_LIST_FORMAT("inclusion_list_format", "Format for the inclusion list. " + InclusionListExport.ExportFormat.getCommandLineOptions(), true, false),
    INCLUSION_LIST_PROTEIN_FILTERS("inclusion_list_protein_filters", "Protein inference filters to be used for the inclusion list export (comma separated). " + InclusionListExport.getProteinFiltersCommandLineOptions(), true, false),
    INCLUSION_LIST_PEPTIDE_FILTERS("inclusion_list_peptide_filters", "Peptide filters to be used for the inclusion list export (comma separated). " + InclusionListExport.PeptideFilterType.getCommandLineOptions(), true, false),
    INCLUSION_LIST_RT_WINDOW("inclusion_list_rt_window", "Retention time window for the inclusion list export (in seconds).", true, false),
    PROTEOFORMS_FILE("proteoforms_file", "Output file for the proteoforms. (Existing file will be overwritten.)", true, false),
    DEEPLC_FILE("deeplc_file", "Path to the file where to write DeepLC peptide files. If the PeptideShaker project was built using multiple MS files, one file per MS file will be exported. (Should end with .gz. Existing file will be overwritten.)", true, false),
    MS2PIP_FILE("ms2pip_file", "Path to the file where to write ms2pip peptide files. If the PeptideShaker project was built using multiple MS files, one file will be exported for all. (Should end with .gz. Existing file will be overwritten.)", true, false),
    MS2PIP_MODELS("ms2pip_models", "Comma separated list of models to write a config file for. Default: CID,HCD.", true, false),
    PERCOLATOR_RT("precolator_rt_file", "Path to the file containing the RT predictions to include in the percolator training file.", true, false),
    PERCOLATOR_FRAGMENTATION("precolator_fragmentation_file", "Path to the file containing the fragmentation predictions to include in the percolator training file.", true, false),
    PERCOLATOR_FILE("precolator_file", "Path to the file where to write the percolator training file. DeepLC and ms2pip files can be provided using the respective options. (Should end with .gz. Existing file will be overwritten.)", true, false),
    RT_OBS_PRED("rt_obs_pred_file", "Path to the file where to write the observed and predicted RT values for each PSM. (Existing file will be overwritten.)", true, false),
    PEAK_INTS_OBS_PRED("peaks_intensities_file", "Path to the file where to write the observed and predicted peaks intensities for each PSM. (Existing file will be overwritten.)", true, false),
    PSM_IDS_FOR_PEAKS_EXPORT("psm_ids_for_peaks_export", "Path to the file which includes the IDs of the PSMs for which the peaks of the predicted and observed spectra will be exported.", true, false),
    PERCOLATOR_BENCHMARK_RESULTS("percolator_benchmark_results", "Path to the file containing Percolator results for each PSM. (Existing file will be overwritten.)", true, false),
    PSM_IDENTIFIERS_EXPORT("psm_identifiers_file", "Path to the file where to write the existing identifiers for each PSM. (Existing file will be overwritten.)", true, false);

    public String id;
    public String description;
    public boolean mandatory;
    public final boolean hasArgument;

    private FollowUpCLIParams(String id, String description, boolean hasArgument, boolean mandatory) {
        this.id = id;
        this.description = description;
        this.hasArgument = hasArgument;
        this.mandatory = mandatory;
    }

    public static void createOptionsCLI(Options aOptions) {
        for (FollowUpCLIParams followUpCLIParams : FollowUpCLIParams.values()) {
            aOptions.addOption(followUpCLIParams.id, followUpCLIParams.hasArgument, followUpCLIParams.description);
        }
    }

    public static String getOptionsAsString() {
        String output = "";
        String formatter = "%-35s";
        output = output + "Mandatory Parameter:\n\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.PSDB_FILE.id) + " " + FollowUpCLIParams.PSDB_FILE.description + "\n";
        output = output + "\n\nOptional Output Parameters:\n";
        output = output + FollowUpCLIParams.getOutputOptionsAsString();
        output = output + "\n\nOptional Temporary Folder:\n\n";
        output = output + "-" + String.format(formatter, PathSettingsCLIParams.ALL.id) + " " + PathSettingsCLIParams.ALL.description + "\n";
        return output;
    }

    public static String getOutputOptionsAsString() {
        String output = "";
        String formatter = "%-35s";
        output = output + "\nRecalibration Parameters:\n\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.RECALIBRATION_FOLDER.id) + " " + FollowUpCLIParams.RECALIBRATION_FOLDER.description + "\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.RECALIBRATION_MODE.id) + " " + FollowUpCLIParams.RECALIBRATION_MODE.description + "\n";
        output = output + "\nSpectrum Export:\n\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.SPECTRUM_FOLDER.id) + " " + FollowUpCLIParams.SPECTRUM_FOLDER.description + "\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.PSM_TYPE.id) + " " + FollowUpCLIParams.PSM_TYPE.description + "\n";
        output = output + "\nProgenesis Export:\n\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.PROGENESIS_FILE.id) + " " + FollowUpCLIParams.PROGENESIS_FILE.description + "\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.PROGENESIS_TYPE.id) + " " + FollowUpCLIParams.PROGENESIS_TYPE.description + "\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.PROGENESIS_TARGETED_PTMS.id) + " " + FollowUpCLIParams.PROGENESIS_TARGETED_PTMS.description + "\n";
        output = output + "\nAccessions Export:\n\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.ACCESSIONS_FILE.id) + " " + FollowUpCLIParams.ACCESSIONS_FILE.description + "\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.ACCESSIONS_TYPE.id) + " " + FollowUpCLIParams.ACCESSIONS_TYPE.description + "\n";
        output = output + "\nProtein Details Export:\n\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.SEQUENCES_FILE.id) + " " + FollowUpCLIParams.SEQUENCES_FILE.description + "\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.SEQUENCES_TYPE.id) + " " + FollowUpCLIParams.SEQUENCES_TYPE.description + "\n";
        output = output + "\nInclusion List Generation\n\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.INCLUSION_LIST_FILE.id) + " " + FollowUpCLIParams.INCLUSION_LIST_FILE.description + "\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.INCLUSION_LIST_FORMAT.id) + " " + FollowUpCLIParams.INCLUSION_LIST_FORMAT.description + "\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.INCLUSION_LIST_PEPTIDE_FILTERS.id) + " " + FollowUpCLIParams.INCLUSION_LIST_PEPTIDE_FILTERS.description + "\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.INCLUSION_LIST_PROTEIN_FILTERS.id) + " " + FollowUpCLIParams.INCLUSION_LIST_PROTEIN_FILTERS.description + "\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.INCLUSION_LIST_RT_WINDOW.id) + " " + FollowUpCLIParams.INCLUSION_LIST_RT_WINDOW.description + "\n";
        output = output + "\nProteoforms Export:\n\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.PROTEOFORMS_FILE.id) + " " + FollowUpCLIParams.PROTEOFORMS_FILE.description + "\n";
        output = output + "\nDeepLC Export:\n\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.DEEPLC_FILE.id) + " " + FollowUpCLIParams.DEEPLC_FILE.description + "\n";
        output = output + "\nMS2PIP Export:\n\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.MS2PIP_FILE.id) + " " + FollowUpCLIParams.MS2PIP_FILE.description + "\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.MS2PIP_MODELS.id) + " " + FollowUpCLIParams.MS2PIP_MODELS.description + "\n";
        output = output + "\nPercolator Export:\n\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.PERCOLATOR_RT.id) + " " + FollowUpCLIParams.PERCOLATOR_RT.description + "\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.PERCOLATOR_FRAGMENTATION.id) + " " + FollowUpCLIParams.PERCOLATOR_FRAGMENTATION.description + "\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.PERCOLATOR_FILE.id) + " " + FollowUpCLIParams.PERCOLATOR_FILE.description + "\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.RT_OBS_PRED.id) + " " + FollowUpCLIParams.RT_OBS_PRED.description + "\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.PEAK_INTS_OBS_PRED.id) + " " + FollowUpCLIParams.PEAK_INTS_OBS_PRED.description + "\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.PSM_IDS_FOR_PEAKS_EXPORT.id) + " " + FollowUpCLIParams.PSM_IDS_FOR_PEAKS_EXPORT.description + "\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.PERCOLATOR_BENCHMARK_RESULTS.id) + " " + FollowUpCLIParams.PERCOLATOR_BENCHMARK_RESULTS.description + "\n";
        output = output + "-" + String.format(formatter, FollowUpCLIParams.PSM_IDENTIFIERS_EXPORT.id) + " " + FollowUpCLIParams.PSM_IDENTIFIERS_EXPORT.description + "\n";
        return output;
    }
}

