/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.cmd;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import com.compomics.cli.identification_parameters.IdentificationParametersInputBean;
import com.compomics.util.Util;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.ProjectParameters;
import com.compomics.util.experiment.biology.enzymes.EnzymeFactory;
import com.compomics.util.experiment.biology.genes.ProteinGeneDetailsProvider;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.taxonomy.SpeciesFactory;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.io.biology.protein.FastaSummary;
import com.compomics.util.experiment.io.mass_spectrometry.MsFileExporter;
import com.compomics.util.experiment.io.mass_spectrometry.MsFileHandler;
import com.compomics.util.experiment.io.mass_spectrometry.cms.CmsFolder;
import com.compomics.util.experiment.io.mass_spectrometry.mgf.IndexedMgfReader;
import com.compomics.util.experiment.io.mass_spectrometry.mgf.MgfIndex;
import com.compomics.util.experiment.io.temp.TempFilesManager;
import com.compomics.util.gui.DummyFrame;
import com.compomics.util.gui.UtilitiesGUIDefaults;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingDialog;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingHandlerCLIImpl;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.compression.ZipUtils;
import com.compomics.util.io.file.SerializationUtils;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.ValidationQcParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.quantification.spectrum_counting.SpectrumCountingParameters;
import com.compomics.util.parameters.tools.ProcessingParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.PeptideShaker;
import eu.isas.peptideshaker.cmd.CLIExportMethods;
import eu.isas.peptideshaker.cmd.FollowUpCLIInputBean;
import eu.isas.peptideshaker.cmd.MzidCLIInputBean;
import eu.isas.peptideshaker.cmd.PathSettingsCLI;
import eu.isas.peptideshaker.cmd.PathSettingsCLIInputBean;
import eu.isas.peptideshaker.cmd.PeptideShakerCLIInputBean;
import eu.isas.peptideshaker.cmd.PeptideShakerCLIParams;
import eu.isas.peptideshaker.cmd.ReportCLIInputBean;
import eu.isas.peptideshaker.export.ProjectExport;
import eu.isas.peptideshaker.preferences.ProjectDetails;
import eu.isas.peptideshaker.utils.Properties;
import eu.isas.peptideshaker.utils.PsZipUtils;
import eu.isas.peptideshaker.utils.PsdbParent;
import eu.isas.peptideshaker.utils.Tips;
import eu.isas.peptideshaker.validation.MatchesValidator;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.slf4j.LoggerFactory;

public class PeptideShakerCLI
extends PsdbParent
implements Callable {
    private WaitingHandler waitingHandler;
    private ExceptionHandler exceptionHandler;
    private PeptideShakerCLIInputBean cliInputBean = null;
    private ModificationFactory modificationFactory;
    private EnzymeFactory enzymeFactory;
    private UtilitiesUserParameters utilitiesUserParameters;
    private static File logFolder = null;

    public void setPeptideShakerCLIInputBean(PeptideShakerCLIInputBean cliInputBean) {
        this.cliInputBean = cliInputBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call() {
        block81: {
            try {
                File zipFile;
                MzidCLIInputBean mzidCLIInputBean;
                File mzidFile;
                if (this.cliInputBean.isGUI()) {
                    ArrayList<String> tips;
                    try {
                        UtilitiesGUIDefaults.setLookAndFeel();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        tips = Tips.getTips();
                    }
                    catch (Exception e) {
                        tips = new ArrayList();
                    }
                    this.waitingHandler = new WaitingDialog(new DummyFrame("PeptideShaker " + PeptideShaker.getVersion(), "/icons/peptide-shaker.gif"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), false, tips, "Importing Data", "PeptideShaker", PeptideShaker.getVersion(), true);
                    ((WaitingDialog)this.waitingHandler).setCloseDialogWhenImportCompletes(false, false);
                    ((WaitingDialog)this.waitingHandler).setLocationRelativeTo(null);
                    Point tempLocation = ((WaitingDialog)this.waitingHandler).getLocation();
                    ((WaitingDialog)this.waitingHandler).setLocation((int)tempLocation.getX() + 30, (int)tempLocation.getY() + 30);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ((WaitingDialog)PeptideShakerCLI.this.waitingHandler).setVisible(true);
                            }
                            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                                // empty catch block
                            }
                        }
                    }, "ProgressDialog").start();
                } else {
                    this.waitingHandler = new WaitingHandlerCLIImpl();
                }
                int progressCounter = this.cliInputBean.getIdFiles().size() + this.cliInputBean.getSpectrumFiles().size();
                ++progressCounter;
                ++progressCounter;
                ++progressCounter;
                progressCounter += 6;
                ++progressCounter;
                ++progressCounter;
                progressCounter += 4;
                progressCounter += 2;
                ++progressCounter;
                if (this.cliInputBean.getZipExport() != null) {
                    ++progressCounter;
                }
                this.waitingHandler.setMaxPrimaryProgressCounter(++progressCounter);
                this.waitingHandler.increasePrimaryProgressCounter();
                try {
                    Class<?> loggerClass = Class.forName("jdk.internal.module.IllegalAccessLogger");
                    Field loggerField = loggerClass.getDeclaredField("logger");
                    Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                    Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
                    unsafeField.setAccessible(true);
                    Object unsafe = unsafeField.get(null);
                    Long offset = (Long)unsafeClass.getMethod("staticFieldOffset", Field.class).invoke(unsafe, loggerField);
                    unsafeClass.getMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class).invoke(unsafe, loggerClass, offset, null);
                }
                catch (Throwable loggerClass) {
                    // empty catch block
                }
                LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                Logger logger = loggerContext.getLogger("org.zoodb");
                logger.setLevel(Level.toLevel((String)"ERROR"));
                if (this.cliInputBean.getConfigFolder() != null) {
                    PeptideShaker.setConfigFolder(this.cliInputBean.getConfigFolder());
                }
                this.setDbFolder(PeptideShaker.getMatchesFolder());
                this.utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
                PeptideShaker.instantiateFacories(this.utilitiesUserParameters);
                this.modificationFactory = ModificationFactory.getInstance();
                this.enzymeFactory = EnzymeFactory.getInstance();
                this.loadSpecies();
                ProteinGeneDetailsProvider geneFactory = new ProteinGeneDetailsProvider();
                geneFactory.initialize(PeptideShaker.getConfigFolder());
                try {
                    SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
                    speciesFactory.initiate(PeptideShaker.getConfigFolder());
                }
                catch (Exception e) {
                    this.waitingHandler.appendReport("An error occurred while loading the species mapping. Gene annotation might be impaired. " + PeptideShakerCLI.getLogFileMessage(), true, true);
                    e.printStackTrace();
                }
                try {
                    this.createProject();
                }
                catch (Exception e) {
                    this.waitingHandler.appendReport("An error occurred while creating the PeptideShaker project. " + PeptideShakerCLI.getLogFileMessage(), true, true);
                    e.printStackTrace();
                    this.waitingHandler.setRunCanceled();
                }
                if (this.waitingHandler.isRunCanceled()) {
                    try {
                        PeptideShakerCLI.closePeptideShaker(this.identification);
                    }
                    catch (Exception e) {
                        this.waitingHandler.appendReport("An error occurred while closing PeptideShaker. " + PeptideShakerCLI.getLogFileMessage(), true, true);
                        e.printStackTrace();
                    }
                    System.exit(1);
                    return 1;
                }
                this.waitingHandler.appendReport("Project successfully created.", true, true);
                this.waitingHandler.increasePrimaryProgressCounter();
                if (this.cliInputBean.getOutput() != null) {
                    try {
                        this.psdbFile = this.cliInputBean.getOutput();
                        this.waitingHandler.appendReport("Saving results.", true, true);
                        this.saveProject(this.waitingHandler, true);
                        this.waitingHandler.appendReport("Results saved to " + this.psdbFile.getAbsolutePath() + ".", true, true);
                        this.waitingHandler.appendReportEndLine();
                    }
                    catch (Exception e) {
                        this.waitingHandler.appendReport("An exception occurred while saving the project. " + PeptideShakerCLI.getLogFileMessage(), true, true);
                        e.printStackTrace();
                        this.waitingHandler.setRunCanceled();
                    }
                    this.waitingHandler.increasePrimaryProgressCounter();
                }
                this.waitingHandler.setPrimaryProgressCounterIndeterminate(false);
                this.waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                FollowUpCLIInputBean followUpCLIInputBean = this.cliInputBean.getFollowUpCLIInputBean();
                ArrayList<File> followupAnalysisFiles = new ArrayList<File>();
                if (followUpCLIInputBean.followUpNeeded()) {
                    this.waitingHandler.appendReport("Starting follow up tasks.", true, true);
                    if (followUpCLIInputBean.recalibrationNeeded()) {
                        this.waitingHandler.appendReport("Spectrum recalibration.", true, true);
                        try {
                            followupAnalysisFiles.addAll(CLIExportMethods.recalibrateSpectra(followUpCLIInputBean, this.identification, this.sequenceProvider, this.msFileHandler, this.identificationParameters, this.waitingHandler));
                        }
                        catch (Exception e) {
                            this.waitingHandler.appendReport("An error occurred while recalibrating the spectra. " + PeptideShakerCLI.getLogFileMessage(), true, true);
                            e.printStackTrace();
                            this.waitingHandler.setRunCanceled();
                        }
                    }
                    if (followUpCLIInputBean.spectrumExportNeeded()) {
                        this.waitingHandler.appendReport("Spectrum export.", true, true);
                        try {
                            followupAnalysisFiles.addAll(CLIExportMethods.exportSpectra(followUpCLIInputBean, this.identification, this.msFileHandler, this.waitingHandler, this.identificationParameters.getSequenceMatchingParameters()));
                        }
                        catch (Exception e) {
                            this.waitingHandler.appendReport("An error occurred while exporting the spectra. " + PeptideShakerCLI.getLogFileMessage(), true, true);
                            e.printStackTrace();
                            this.waitingHandler.setRunCanceled();
                        }
                    }
                    if (followUpCLIInputBean.accessionExportNeeded()) {
                        this.waitingHandler.appendReport("Protein accession export.", true, true);
                        try {
                            followupAnalysisFiles.add(CLIExportMethods.exportAccessions(followUpCLIInputBean, this.identification, this.sequenceProvider, this.waitingHandler, this.filterParameters));
                        }
                        catch (Exception e) {
                            this.waitingHandler.appendReport("An error occurred while exporting the protein accessions. " + PeptideShakerCLI.getLogFileMessage(), true, true);
                            e.printStackTrace();
                            this.waitingHandler.setRunCanceled();
                        }
                    }
                    if (followUpCLIInputBean.proteinSequencesExportNeeded()) {
                        this.waitingHandler.appendReport("Protein sequences export.", true, true);
                        try {
                            followupAnalysisFiles.add(CLIExportMethods.exportProteinSequences(followUpCLIInputBean, this.identification, this.sequenceProvider, this.waitingHandler, this.filterParameters));
                        }
                        catch (Exception e) {
                            this.waitingHandler.appendReport("An error occurred while exporting the protein details. " + PeptideShakerCLI.getLogFileMessage(), true, true);
                            e.printStackTrace();
                            this.waitingHandler.setRunCanceled();
                        }
                    }
                    if (followUpCLIInputBean.progenesisExportNeeded()) {
                        this.waitingHandler.appendReport("Progenesis export.", true, true);
                        try {
                            followupAnalysisFiles.add(CLIExportMethods.exportProgenesis(followUpCLIInputBean, this.identification, this.waitingHandler, this.sequenceProvider, this.proteinDetailsProvider, this.identificationParameters.getSequenceMatchingParameters()));
                            this.waitingHandler.appendReport("Progenesis export completed.", true, true);
                        }
                        catch (Exception e) {
                            this.waitingHandler.appendReport("An error occurred while exporting the Progenesis file. " + PeptideShakerCLI.getLogFileMessage(), true, true);
                            e.printStackTrace();
                            this.waitingHandler.setRunCanceled();
                        }
                    }
                    if (followUpCLIInputBean.inclusionListNeeded()) {
                        this.waitingHandler.appendReport("Inclusion list export.", true, true);
                        try {
                            followupAnalysisFiles.add(CLIExportMethods.exportInclusionList(followUpCLIInputBean, this.identification, this.identificationFeaturesGenerator, this.msFileHandler, this.identificationParameters.getSearchParameters(), this.waitingHandler, this.filterParameters));
                        }
                        catch (Exception e) {
                            this.waitingHandler.appendReport("An error occurred while generating the inclusion list.", true, true);
                            e.printStackTrace();
                            this.waitingHandler.setRunCanceled();
                        }
                    }
                    if (followUpCLIInputBean.proteoformsNeeded()) {
                        this.waitingHandler.appendReport("Proteoform export.", true, true);
                        try {
                            followupAnalysisFiles.add(CLIExportMethods.exportProteoforms(followUpCLIInputBean, this.identification, this.waitingHandler));
                        }
                        catch (Exception e) {
                            this.waitingHandler.appendReport("An error occurred while generating the proteoforms list.", true, true);
                            e.printStackTrace();
                            this.waitingHandler.setRunCanceled();
                        }
                    }
                    if (followUpCLIInputBean.deepLcExportNeeded()) {
                        this.waitingHandler.appendReport("DeepLC export.", true, true);
                        try {
                            followupAnalysisFiles.addAll(CLIExportMethods.exportDeepLC(followUpCLIInputBean, this.identification, this.identificationParameters.getSearchParameters().getModificationParameters(), this.identificationParameters.getSequenceMatchingParameters(), this.sequenceProvider, this.msFileHandler, this.waitingHandler));
                        }
                        catch (Exception e) {
                            this.waitingHandler.appendReport("An error occurred while generating the proteoforms list.", true, true);
                            e.printStackTrace();
                            this.waitingHandler.setRunCanceled();
                        }
                    }
                    if (followUpCLIInputBean.ms2pipExportNeeded()) {
                        this.waitingHandler.appendReport("ms2pip export.", true, true);
                        try {
                            followupAnalysisFiles.addAll(CLIExportMethods.exportMs2pip(followUpCLIInputBean, this.identification, this.identificationParameters.getSearchParameters(), this.identificationParameters.getSequenceMatchingParameters(), this.sequenceProvider, this.msFileHandler, this.waitingHandler));
                        }
                        catch (Exception e) {
                            this.waitingHandler.appendReport("An error occurred while generating the proteoforms list.", true, true);
                            e.printStackTrace();
                            this.waitingHandler.setRunCanceled();
                        }
                    }
                }
                ReportCLIInputBean reportCLIInputBean = this.cliInputBean.getReportCLIInputBean();
                ArrayList<File> reportFiles = new ArrayList<File>();
                if (reportCLIInputBean.exportNeeded()) {
                    boolean reportOutputFolderSet;
                    boolean bl = reportOutputFolderSet = reportCLIInputBean.getReportOutputFolder() != null;
                    if (!reportOutputFolderSet) {
                        if (this.cliInputBean.getOutput() == null) {
                            this.waitingHandler.appendReport("Report output folder not set. Please use -out_reports (or the more general -out option). Processing canceled.", true, true);
                            System.err.println("Report output folder not set. Please use -out_reports (or the more general -out option). Processing canceled.");
                            this.waitingHandler.setRunCanceled();
                        } else {
                            reportCLIInputBean.setReportOutputFolder(this.cliInputBean.getOutput().getParentFile());
                            reportOutputFolderSet = true;
                        }
                    }
                    if (reportOutputFolderSet) {
                        this.waitingHandler.appendReport("Exporting reports.", true, true);
                        if (reportCLIInputBean.exportNeeded()) {
                            int nSurroundingAAs = 2;
                            for (String reportType : reportCLIInputBean.getReportTypes()) {
                                this.waitingHandler.appendReport("Exporting " + reportType + ".", true, true);
                                try {
                                    reportFiles.add(CLIExportMethods.exportReport(reportCLIInputBean, reportType, this.projectParameters.getProjectUniqueName(), this.projectDetails, this.identification, this.geneMaps, this.identificationFeaturesGenerator, this.identificationParameters, this.sequenceProvider, this.proteinDetailsProvider, this.msFileHandler, nSurroundingAAs, this.spectrumCountingParameters, this.waitingHandler));
                                }
                                catch (Exception e) {
                                    this.waitingHandler.appendReport("An error occurred while exporting the " + reportType + ". " + PeptideShakerCLI.getLogFileMessage(), true, true);
                                    e.printStackTrace();
                                    this.waitingHandler.setRunCanceled();
                                }
                            }
                        }
                        if (reportCLIInputBean.documentationExportNeeded()) {
                            this.waitingHandler.appendReport("Exporting report documentation.", true, true);
                            for (String reportType : reportCLIInputBean.getReportTypes()) {
                                try {
                                    CLIExportMethods.exportDocumentation(reportCLIInputBean, reportType, this.waitingHandler);
                                }
                                catch (Exception e) {
                                    this.waitingHandler.appendReport("An error occurred while exporting the documentation for " + reportType + ". " + PeptideShakerCLI.getLogFileMessage(), true, true);
                                    e.printStackTrace();
                                    this.waitingHandler.setRunCanceled();
                                }
                            }
                        }
                    }
                }
                if ((mzidFile = (mzidCLIInputBean = this.cliInputBean.getMzidCLIInputBean()).getOutputFile()) != null) {
                    this.waitingHandler.appendReportEndLine();
                    this.waitingHandler.appendReport("Exporting project as mzIdentML.", true, true);
                    double currentIntensityLimit = this.getIdentificationParameters().getAnnotationParameters().getAnnotationIntensityLimit();
                    this.getIdentificationParameters().getAnnotationParameters().setIntensityLimit(0.0);
                    try {
                        CLIExportMethods.exportMzId(mzidCLIInputBean, this, this.waitingHandler);
                    }
                    catch (Exception e) {
                        this.waitingHandler.appendReport("An error occurred while generating the mzid file. " + PeptideShakerCLI.getLogFileMessage(), true, true);
                        e.printStackTrace();
                        this.waitingHandler.setRunCanceled();
                    }
                    finally {
                        this.getIdentificationParameters().getAnnotationParameters().setIntensityLimit(currentIntensityLimit);
                    }
                }
                if ((zipFile = this.cliInputBean.getZipExport()) != null) {
                    this.waitingHandler.appendReportEndLine();
                    this.waitingHandler.appendReport("Zipping project.", true, true);
                    File parent = zipFile.getParentFile();
                    try {
                        parent.mkdirs();
                    }
                    catch (Exception e) {
                        this.waitingHandler.appendReport("An error occurred while creating folder " + parent.getAbsolutePath() + ". " + PeptideShakerCLI.getLogFileMessage(), true, true);
                        this.waitingHandler.setRunCanceled();
                    }
                    ArrayList<File> spectrumFiles = new ArrayList<File>();
                    for (String spectrumFileName : this.getIdentification().getFractions()) {
                        File spectrumFile = new File(this.msFileHandler.getFilePaths().get(spectrumFileName));
                        spectrumFiles.add(spectrumFile);
                    }
                    File fastaFile = new File(this.projectDetails.getFastaFile());
                    try {
                        ProjectExport.exportProjectAsZip(zipFile, fastaFile, this.msFileHandler, followupAnalysisFiles, reportFiles, mzidFile, this.psdbFile, true, this.waitingHandler);
                        int NUMBER_OF_BYTES_PER_MEGABYTE = 0x100000;
                        double sizeOfZippedFile = Util.roundDouble((double)zipFile.length() / 1048576.0, 2);
                        this.waitingHandler.appendReport("Project zipped to '" + zipFile.getAbsolutePath() + "' (" + sizeOfZippedFile + " MB)", true, true);
                        boolean mgfExport = this.cliInputBean.getMgfExport();
                        if (mgfExport) {
                            this.waitingHandler.appendReportEndLine();
                            this.waitingHandler.appendReport("Writing mgf file(s) to output folder.", true, true);
                            int i = 0;
                            for (String spectrumFileName : this.msFileHandler.getCmsFilePaths().keySet()) {
                                if (this.waitingHandler.isRunCanceled()) break;
                                this.waitingHandler.appendReport("Writing: " + IoUtil.removeExtension(spectrumFileName) + ".mgf (" + (i + 1) + "/" + this.getIdentification().getFractions().size() + ")", true, true);
                                File mgfFile = new File(parent, IoUtil.removeExtension(spectrumFileName) + ".mgf");
                                MsFileExporter.writeMgfFile(this.msFileHandler, true, spectrumFileName, mgfFile, this.waitingHandler);
                                MgfIndex mgfIndex = IndexedMgfReader.getMgfIndex(mgfFile, this.waitingHandler);
                                File indexFile = new File(parent, IoUtil.removeExtension(mgfIndex.getFileName()) + ".cui");
                                SerializationUtils.writeObject(mgfIndex, indexFile);
                                ++i;
                            }
                            this.waitingHandler.appendReport("MGF file(s) written to output folder.", true, true);
                        }
                        this.waitingHandler.increasePrimaryProgressCounter();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.waitingHandler.appendReport("An error occurred while attempting to zip project in " + zipFile.getAbsolutePath() + ". " + PeptideShakerCLI.getLogFileMessage(), true, true);
                        this.waitingHandler.setRunCanceled();
                    }
                }
                this.waitingHandler.appendReportEndLine();
                try {
                    PeptideShakerCLI.closePeptideShaker(this.identification);
                }
                catch (Exception e) {
                    this.waitingHandler.appendReport("An error occurred while closing PeptideShaker. " + PeptideShakerCLI.getLogFileMessage(), true, true);
                    e.printStackTrace();
                }
                this.saveReport();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.waitingHandler == null) break block81;
                this.waitingHandler.appendReport("PeptideShaker processing failed. " + PeptideShakerCLI.getLogFileMessage(), true, true);
                this.saveReport();
                this.waitingHandler.setRunCanceled();
            }
        }
        if (this.waitingHandler != null && !this.waitingHandler.isRunCanceled()) {
            this.waitingHandler.appendReport("PeptideShaker process completed.", true, true);
            this.waitingHandler.setSecondaryProgressText("Processing Completed.");
            System.exit(0);
            return 0;
        }
        System.out.println("PeptideShaker process failed! " + PeptideShakerCLI.getLogFileMessage());
        System.exit(1);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveReport() {
        block12: {
            String report = this.waitingHandler instanceof WaitingDialog ? this.getExtendedProjectReport(((WaitingDialog)this.waitingHandler).getReport(null)) : this.getExtendedProjectReport(null);
            if (report != null) {
                if (this.waitingHandler instanceof WaitingDialog) {
                    report = "<html><br>";
                    report = report + "<b>Report:</b><br>";
                    report = report + "<pre>" + ((WaitingDialog)this.waitingHandler).getReport(null) + "</pre>";
                    report = report + "</html>";
                }
                try {
                    String fileName;
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH.mm.ss");
                    File psReportFile = null;
                    PathSettingsCLIInputBean pathSettingsCLIInputBean = this.cliInputBean.getPathSettingsCLIInputBean();
                    if (this.getPsdbFile() != null) {
                        fileName = "PeptideShaker Report " + this.getPsdbFile().getName() + " " + df.format(new Date()) + ".html";
                        psReportFile = new File(this.getPsdbFile().getParentFile(), fileName);
                    } else if (this.cliInputBean.getOutput() != null) {
                        fileName = "PeptideShaker Report " + df.format(new Date()) + ".html";
                        psReportFile = new File(this.cliInputBean.getOutput().getParentFile(), fileName);
                    } else if (pathSettingsCLIInputBean.getLogFolder() != null) {
                        fileName = "PeptideShaker Report " + df.format(new Date()) + ".html";
                        psReportFile = new File(pathSettingsCLIInputBean.getLogFolder(), fileName);
                    }
                    if (psReportFile == null) break block12;
                    try (FileWriter fw = new FileWriter(psReportFile);){
                        fw.write(report);
                    }
                }
                catch (Exception ex) {
                    this.waitingHandler.appendReport("An error occurred while saving the PeptideShaker report. " + PeptideShakerCLI.getLogFileMessage(), true, true);
                    ex.printStackTrace();
                }
            }
        }
    }

    public void createProject() throws IOException, InterruptedException, TimeoutException {
        PeptideShaker peptideShaker;
        int outcome;
        Boolean bl;
        SearchParameters searchParameters;
        String error;
        this.projectParameters = new ProjectParameters(this.cliInputBean.getExperimentID());
        this.projectDetails = new ProjectDetails();
        this.projectDetails.setCreationDate(new Date());
        this.projectDetails.setPeptideShakerVersion(new Properties().getVersion());
        this.msFileHandler = new MsFileHandler();
        ArrayList<File> identificationFilesInput = this.cliInputBean.getIdFiles();
        ArrayList<Object> dataFolders = new ArrayList<Object>();
        ArrayList<File> spectrumFiles = this.cliInputBean.getSpectrumFiles();
        Object fastaFile = null;
        ArrayList<File> identificationFiles = new ArrayList<File>();
        IdentificationParameters tempIdentificationParameters = null;
        for (File file : identificationFilesInput) {
            String fileName;
            Object dataFolder;
            File file2 = file.getParentFile();
            if (!dataFolders.contains(file2)) {
                dataFolders.add(file2);
            }
            if (((File)(dataFolder = new File(file2, "mgf"))).exists() && !dataFolders.contains(dataFolder)) {
                dataFolders.add(dataFolder);
            }
            if (((File)(dataFolder = new File(file2, "mzml"))).exists() && !dataFolders.contains(dataFolder)) {
                dataFolders.add(dataFolder);
            }
            if (((File)(dataFolder = new File(file2, "cms"))).exists() && !dataFolders.contains(dataFolder)) {
                dataFolders.add(dataFolder);
            }
            if (((File)(dataFolder = new File(file2, "fasta"))).exists() && !dataFolders.contains(dataFolder)) {
                dataFolders.add(dataFolder);
            }
            if (((File)(dataFolder = new File(file2, PeptideShaker.DATA_DIRECTORY))).exists() && !dataFolders.contains(dataFolder)) {
                dataFolders.add(dataFolder);
            }
            if ((fileName = file.getName()).toLowerCase().endsWith(".zip")) {
                this.waitingHandler.appendReport("Unzipping " + fileName + ".", true, true);
                String newName = PsZipUtils.getTempFolderName(fileName);
                String parentFolder = PsZipUtils.getUnzipParentFolder();
                if (parentFolder == null) {
                    parentFolder = file2.getAbsolutePath();
                }
                File file3 = new File(parentFolder, PsZipUtils.getUnzipSubFolder());
                File destinationFolder = new File(file3, newName);
                destinationFolder.mkdir();
                TempFilesManager.registerTempFolder(file3);
                ZipUtils.unzip(file, destinationFolder, this.waitingHandler);
                if (this.waitingHandler instanceof WaitingHandlerCLIImpl) {
                    this.waitingHandler.appendReportEndLine();
                }
                if (((File)(dataFolder = new File(destinationFolder, PeptideShaker.DATA_DIRECTORY))).exists() && !dataFolders.contains(dataFolder)) {
                    dataFolders.add(dataFolder);
                }
                if (((File)(dataFolder = new File(destinationFolder, ".mgf"))).exists() && !dataFolders.contains(dataFolder)) {
                    dataFolders.add(dataFolder);
                }
                if (((File)(dataFolder = new File(file2, "mzml"))).exists() && !dataFolders.contains(dataFolder)) {
                    dataFolders.add(dataFolder);
                }
                if (((File)(dataFolder = new File(destinationFolder, ".cms"))).exists() && !dataFolders.contains(dataFolder)) {
                    dataFolders.add(dataFolder);
                }
                if (((File)(dataFolder = new File(destinationFolder, ".fasta"))).exists() && !dataFolders.contains(dataFolder)) {
                    dataFolders.add(dataFolder);
                }
                File[] fileArray = destinationFolder.listFiles();
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File unzippedFile = fileArray[i];
                    String nameLowerCase = unzippedFile.getName().toLowerCase();
                    if (nameLowerCase.endsWith(".omx") || nameLowerCase.endsWith(".t.xml") || nameLowerCase.endsWith(".pep.xml") || nameLowerCase.endsWith(".dat") || nameLowerCase.endsWith(".mzid") || nameLowerCase.endsWith(".ms-amanda.csv") || nameLowerCase.endsWith(".res") || nameLowerCase.endsWith(".tide-search.target.txt") || nameLowerCase.endsWith(".tags") || nameLowerCase.endsWith(".pnovo.txt") || nameLowerCase.endsWith(".novor.csv") || nameLowerCase.endsWith(".coss.tsv") || nameLowerCase.endsWith(".sage.tsv") || nameLowerCase.endsWith(".psm") || nameLowerCase.endsWith(".omx.gz") || nameLowerCase.endsWith(".t.xml.gz") || nameLowerCase.endsWith(".pep.xml.gz") || nameLowerCase.endsWith(".mzid.gz") || nameLowerCase.endsWith(".ms-amanda.csv.gz") || nameLowerCase.endsWith(".res.gz") || nameLowerCase.endsWith(".tide-search.target.txt.gz") || nameLowerCase.endsWith(".tags.gz") || nameLowerCase.endsWith(".pnovo.txt.gz") || nameLowerCase.endsWith(".novor.csv.gz") || nameLowerCase.endsWith(".coss.tsv.gz") || nameLowerCase.endsWith(".sage.tsv.gz") || nameLowerCase.endsWith(".psm.gz")) {
                        identificationFiles.add(unzippedFile);
                        continue;
                    }
                    if (!nameLowerCase.endsWith(".par")) continue;
                    try {
                        tempIdentificationParameters = IdentificationParameters.getIdentificationParameters(unzippedFile);
                        ValidationQcParameters validationQCParameters = tempIdentificationParameters.getIdValidationParameters().getValidationQCParameters();
                        if (validationQCParameters != null && validationQCParameters.getPsmFilters() != null && validationQCParameters.getPeptideFilters() != null && validationQCParameters.getProteinFilters() != null && (!validationQCParameters.getPsmFilters().isEmpty() || !validationQCParameters.getPeptideFilters().isEmpty() || !validationQCParameters.getProteinFilters().isEmpty())) continue;
                        MatchesValidator.setDefaultMatchesQCFilters(validationQCParameters);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.waitingHandler.appendReport("An error occurred while parsing the parameters file " + unzippedFile.getName() + ". " + PeptideShakerCLI.getLogFileMessage(), true, true);
                        this.waitingHandler.setRunCanceled();
                    }
                }
                continue;
            }
            identificationFiles.add(file);
        }
        HashSet<String> dataFileNamesRequired = new HashSet<String>();
        for (File file : spectrumFiles) {
            dataFileNamesRequired.add(IoUtil.getFileName(file));
        }
        for (File file : dataFolders) {
            for (File file4 : file.listFiles()) {
                String string = file4.getName();
                if (string.endsWith(".mgf") || string.endsWith(".mgf.gz") || string.endsWith(".mzml") || string.endsWith(".mzml.gz") || string.endsWith(".cms")) {
                    if (dataFileNamesRequired.contains(string)) continue;
                    spectrumFiles.add(file4);
                    dataFileNamesRequired.add(string);
                    continue;
                }
                if (!string.endsWith(".fasta") || dataFileNamesRequired.contains(string)) continue;
                fastaFile = file4;
                dataFileNamesRequired.add(string);
            }
        }
        for (File file : spectrumFiles) {
            File folder = CmsFolder.getParentFolder() == null ? file.getParentFile() : new File(CmsFolder.getParentFolder());
            this.msFileHandler.register(file, folder, this.waitingHandler);
        }
        if (this.cliInputBean.getFastaFile() != null) {
            fastaFile = this.cliInputBean.getFastaFile();
        }
        IdentificationParametersInputBean identificationParametersInputBean = this.cliInputBean.getIdentificationParametersInputBean();
        if (tempIdentificationParameters != null && identificationParametersInputBean.getInputFile() == null) {
            identificationParametersInputBean.setIdentificationParameters(tempIdentificationParameters);
            identificationParametersInputBean.updateIdentificationParameters();
        }
        this.identificationParameters = identificationParametersInputBean.getIdentificationParameters();
        ValidationQcParameters validationQcParameters = this.identificationParameters.getIdValidationParameters().getValidationQCParameters();
        if (validationQcParameters == null || validationQcParameters.getPsmFilters() == null || validationQcParameters.getPeptideFilters() == null || validationQcParameters.getProteinFilters() == null || validationQcParameters.getPsmFilters().isEmpty() && validationQcParameters.getPeptideFilters().isEmpty() && validationQcParameters.getProteinFilters().isEmpty()) {
            MatchesValidator.setDefaultMatchesQCFilters(validationQcParameters);
        }
        if (this.identificationParameters == null) {
            this.waitingHandler.appendReport("Identification parameters not found!", true, true);
            this.waitingHandler.setRunCanceled();
        }
        if ((error = PeptideShaker.loadModifications(searchParameters = this.identificationParameters.getSearchParameters())) != null) {
            System.out.println(error);
        }
        if (fastaFile == null) {
            this.waitingHandler.appendReport("FASTA file not set (or not in zip file)!", true, true);
            this.waitingHandler.setRunCanceled();
        } else if (!((File)fastaFile).exists()) {
            boolean found = false;
            try {
                File tempDbFolder = this.utilitiesUserParameters.getDbFolder();
                File file = new File(tempDbFolder, ((File)fastaFile).getName());
                if (file.exists()) {
                    fastaFile = file;
                    this.projectDetails.setFastaFile((File)fastaFile);
                    found = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!found) {
                for (File file : dataFolders) {
                    String[] newFile = new File(file, ((File)fastaFile).getName());
                    if (!newFile.exists()) continue;
                    fastaFile = newFile;
                    this.projectDetails.setFastaFile((File)fastaFile);
                    found = true;
                    break;
                }
                if (!found) {
                    this.waitingHandler.appendReport("FASTA file '" + ((File)fastaFile).getName() + "' not found.", true, true);
                    this.waitingHandler.setRunCanceled();
                }
            }
        } else {
            this.projectDetails.setFastaFile((File)fastaFile);
        }
        try {
            FastaSummary fastaSummary = this.loadFastaFile(this.waitingHandler);
            this.identificationParameters.getGeneParameters().setBackgroundSpeciesFromFastaSummary(fastaSummary);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.waitingHandler.appendReport("An error occurred while parsing the FASTA file.", true, true);
            this.waitingHandler.setRunCanceled();
        }
        ProcessingParameters processingParameters = new ProcessingParameters();
        Integer nThreads = this.cliInputBean.getnThreads();
        if (nThreads != null) {
            processingParameters.setnThreads(nThreads);
        }
        if ((bl = this.cliInputBean.getCachePercolatorFeatures()) != null) {
            processingParameters.setCachePercolatorFeatures(bl);
        }
        this.spectrumCountingParameters = new SpectrumCountingParameters();
        this.projectType = this.cliInputBean.getProjectType();
        for (String forbiddenChar : Util.FORBIDDEN_CHARACTERS) {
            if (!this.cliInputBean.getExperimentID().contains(forbiddenChar)) continue;
            this.waitingHandler.appendReport("The project name cannot not contain " + forbiddenChar + ".", true, true);
            this.waitingHandler.setRunCanceled();
        }
        if (this.utilitiesUserParameters.isAutoUpdate()) {
            Util.sendGAUpdate("UA-36198780-1", "startrun-cl", "peptide-shaker-" + PeptideShaker.getVersion());
        }
        if ((outcome = (peptideShaker = new PeptideShaker(this.projectParameters)).importFiles(this.waitingHandler, identificationFiles, this.msFileHandler, this.identificationParameters, this.projectDetails, processingParameters, this.exceptionHandler)) == 0) {
            peptideShaker.createProject(this.identificationParameters, processingParameters, this.spectrumCountingParameters, this.msFileHandler, this.projectDetails, this.projectType, this.waitingHandler, false, this.exceptionHandler);
        }
        if (!this.waitingHandler.isRunCanceled()) {
            this.identification = peptideShaker.getIdentification();
            this.metrics = peptideShaker.getMetrics();
            this.geneMaps = peptideShaker.getGeneMaps();
            this.identificationFeaturesGenerator = peptideShaker.getIdentificationFeaturesGenerator();
            this.sequenceProvider = peptideShaker.getSequenceProvider();
            this.proteinDetailsProvider = peptideShaker.getProteinDetailsProvider();
            if (this.waitingHandler instanceof WaitingDialog) {
                this.projectDetails.setReport(((WaitingDialog)this.waitingHandler).getReport(null));
                ((WaitingDialog)this.waitingHandler).setRunNotFinished();
                ((WaitingDialog)this.waitingHandler).setCloseDialogWhenImportCompletes(true, false);
            }
        } else {
            if (this.waitingHandler instanceof WaitingDialog) {
                this.saveReport();
            }
            TempFilesManager.deleteTempFolders();
            this.waitingHandler.setWaitingText("PeptideShaker Processing Canceled.");
            System.out.println("<CompomicsError>PeptideShaker processing canceled. " + PeptideShakerCLI.getLogFileMessage() + "</CompomicsError>");
        }
    }

    public static void closePeptideShaker(Identification identification) throws IOException, SQLException {
        try {
            if (identification != null) {
                identification.close(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            File matchFolder = PeptideShaker.getMatchesFolder();
            File[] tempFiles = matchFolder.listFiles();
            if (tempFiles != null) {
                for (File currentFile : tempFiles) {
                    boolean deleted = IoUtil.deleteDir(currentFile);
                    if (deleted) continue;
                    System.out.println(currentFile.getAbsolutePath() + " could not be deleted!");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            TempFilesManager.deleteTempFolders();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getHeader() {
        return System.getProperty("line.separator") + "The PeptideShaker command line takes identification files from search engines and creates a PeptideShaker project saved as psdb file. Various exports can be generated from the project." + System.getProperty("line.separator") + System.getProperty("line.separator") + "For further help see https://compomics.github.io/projects/peptide-shaker.html and https://compomics.github.io/projects/peptide-shaker/wiki/PeptideshakerCLI.html." + System.getProperty("line.separator") + System.getProperty("line.separator") + "Or contact the developers at https://groups.google.com/group/peptide-shaker." + System.getProperty("line.separator") + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + "OPTIONS" + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + System.getProperty("line.separator");
    }

    private void loadSpecies() {
        try {
            SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
            speciesFactory.initiate(PeptideShaker.getConfigFolder());
        }
        catch (Exception e) {
            System.out.println("An error occurred while loading the species. " + PeptideShakerCLI.getLogFileMessage());
            e.printStackTrace();
        }
    }

    public static void redirectErrorStream(File aLogFolder) {
        logFolder = aLogFolder;
        try {
            logFolder.mkdirs();
            File file = new File(logFolder, "PeptideShaker.log");
            System.setErr(new PrintStream(new FileOutputStream(file, true)));
            System.err.println(System.getProperty("line.separator") + System.getProperty("line.separator") + new Date() + ": PeptideShaker version " + PeptideShaker.getVersion() + ".");
            System.err.println("Memory given to the Java virtual machine: " + Runtime.getRuntime().maxMemory() + ".");
            System.err.println("Total amount of memory in the Java virtual machine: " + Runtime.getRuntime().totalMemory() + ".");
            System.err.println("Free memory: " + Runtime.getRuntime().freeMemory() + ".");
            System.err.println("Java version: " + System.getProperty("java.version") + ".");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getLogFileMessage() {
        if (logFolder == null) {
            return "Please see the PeptideShaker log file.";
        }
        return "Please see the PeptideShaker log file: " + logFolder.getAbsolutePath() + File.separator + "PeptideShaker.log";
    }

    public static void main(String[] args) {
        try {
            String[] nonPathSettingArgsAsList = PathSettingsCLI.extractAndUpdatePathOptions(args);
            Options nonPathOptions = new Options();
            PeptideShakerCLIParams.createOptionsCLI(nonPathOptions);
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(nonPathOptions, nonPathSettingArgsAsList);
            if (!PeptideShakerCLIInputBean.isValidStartup(line)) {
                PrintWriter lPrintWriter = new PrintWriter(System.out);
                lPrintWriter.print(System.getProperty("line.separator") + "==============================" + System.getProperty("line.separator"));
                lPrintWriter.print("PeptideShaker - Command Line" + System.getProperty("line.separator"));
                lPrintWriter.print("==============================" + System.getProperty("line.separator"));
                lPrintWriter.print(PeptideShakerCLI.getHeader());
                lPrintWriter.print(PeptideShakerCLIParams.getOptionsAsString());
                lPrintWriter.flush();
                lPrintWriter.close();
                System.exit(0);
            } else {
                PeptideShakerCLI lPeptideShakerCLI = new PeptideShakerCLI();
                PeptideShakerCLIInputBean lCLIBean = new PeptideShakerCLIInputBean(line);
                lPeptideShakerCLI.setPeptideShakerCLIInputBean(lCLIBean);
                lPeptideShakerCLI.call();
            }
        }
        catch (OutOfMemoryError e) {
            System.out.println("<CompomicsError>PeptideShaker used up all the memory and had to be stopped. " + PeptideShakerCLI.getLogFileMessage() + "</CompomicsError>");
            System.err.println("Ran out of memory!");
            System.err.println("Memory given to the Java virtual machine: " + Runtime.getRuntime().maxMemory() + ".");
            System.err.println("Memory used by the Java virtual machine: " + Runtime.getRuntime().totalMemory() + ".");
            System.err.println("Free memory in the Java virtual machine: " + Runtime.getRuntime().freeMemory() + ".");
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("<CompomicsError>PeptideShaker processing failed. " + PeptideShakerCLI.getLogFileMessage() + "</CompomicsError>");
            e.printStackTrace();
        }
    }

    public String toString() {
        return "PeptideShakerCLI{, waitingHandler=" + this.waitingHandler + ", cliInputBean=" + this.cliInputBean + ", ptmFactory=" + this.modificationFactory + ", enzymeFactory=" + this.enzymeFactory + '}';
    }
}

