/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.cmd;

import com.compomics.cli.identification_parameters.IdentificationParametersCLIParams;
import com.compomics.util.parameters.peptide_shaker.ProjectType;
import eu.isas.peptideshaker.cmd.FollowUpCLIParams;
import eu.isas.peptideshaker.cmd.MzidCLIParams;
import eu.isas.peptideshaker.cmd.PathSettingsCLIParams;
import eu.isas.peptideshaker.cmd.PeptideShakerIdentificationParametersCLIParams;
import eu.isas.peptideshaker.cmd.ReportCLIParams;
import org.apache.commons.cli.Options;

public enum PeptideShakerCLIParams {
    REFERENCE("reference", "The reference/name for the project.", true),
    PROJECT_TYPE("project_type", "The type of project. " + ProjectType.getCommandLineOptions(), false),
    SPECTRUM_FILES("spectrum_files", "Spectrum files, comma separated list or an entire folder.", false),
    FASTA_FILE("fasta_file", "The complete path to the FASTA file.", false),
    IDENTIFICATION_FILES("identification_files", "Identification files, comma separated list or an entire folder.", true),
    PEPTIDESHAKER_OUTPUT("out", "PeptideShaker output file. Note: if file exists it will be overwritten.", false),
    GUI("gui", "Use a dialog to display the progress (1: true, 0: false, default is '0').", false),
    ZIP("zip", "Exports the entire project as a zip file in the file specified.", false),
    OUTPUT_MGF("output_mgf", "When using zipped output, exports mgf file(s) out of the zip file into the same folder in addition (0: no, 1: yes, default is '0').", false),
    THREADS("threads", "The number of threads to use. Defaults to the number of available CPUs.", false),
    PERCOLATOR_CACHE("percolator_cache", "Enable the caching of Percolator features (1: true, 0: false, default is '0').", false),
    CONFIG_FOLDER("config_folder", "The complete path to the config folder. Default resources\\conf.", false);

    public String id;
    public String description;
    public boolean mandatory;

    private PeptideShakerCLIParams(String id, String description, boolean mandatory) {
        this.id = id;
        this.description = description;
        this.mandatory = mandatory;
    }

    public static void createOptionsCLI(Options aOptions) {
        for (PeptideShakerCLIParams value : PeptideShakerCLIParams.values()) {
            aOptions.addOption(value.id, true, value.description);
        }
        PeptideShakerIdentificationParametersCLIParams.createOptionsCLI(aOptions);
        FollowUpCLIParams.createOptionsCLI(aOptions);
        ReportCLIParams.createOptionsCLI(aOptions);
        MzidCLIParams.createOptionsCLI(aOptions);
    }

    public static String getOptionsAsString() {
        String output = "";
        String formatter = "%-35s";
        output = output + "Mandatory Parameters:\n\n";
        output = output + "-" + String.format(formatter, PeptideShakerCLIParams.REFERENCE.id) + " " + PeptideShakerCLIParams.REFERENCE.description + "\n";
        output = output + "-" + String.format(formatter, PeptideShakerCLIParams.IDENTIFICATION_FILES.id) + " " + PeptideShakerCLIParams.IDENTIFICATION_FILES.description + "\n";
        output = output + "\n\nOptional Input Parametera:\n\n";
        output = output + "-" + String.format(formatter, PeptideShakerCLIParams.SPECTRUM_FILES.id) + " " + PeptideShakerCLIParams.SPECTRUM_FILES.description + "\n";
        output = output + "-" + String.format(formatter, PeptideShakerCLIParams.FASTA_FILE.id) + " " + PeptideShakerCLIParams.FASTA_FILE.description + "\n";
        output = output + "-" + String.format(formatter, IdentificationParametersCLIParams.IDENTIFICATION_PARAMETERS.id) + " " + IdentificationParametersCLIParams.IDENTIFICATION_PARAMETERS.description + "\n";
        output = output + "\n\nOptional Output Parameter:\n\n";
        output = output + "-" + String.format(formatter, PeptideShakerCLIParams.PEPTIDESHAKER_OUTPUT.id) + " " + PeptideShakerCLIParams.PEPTIDESHAKER_OUTPUT.description + "\n";
        output = output + "\n\nOptional Processing Parameters:\n\n";
        output = output + "-" + String.format(formatter, PeptideShakerCLIParams.PROJECT_TYPE.id) + " " + PeptideShakerCLIParams.PROJECT_TYPE.description + "\n";
        output = output + "-" + String.format(formatter, PeptideShakerCLIParams.GUI.id) + " " + PeptideShakerCLIParams.GUI.description + "\n";
        output = output + "-" + String.format(formatter, PeptideShakerCLIParams.THREADS.id) + " " + PeptideShakerCLIParams.THREADS.description + "\n";
        output = output + "-" + String.format(formatter, PeptideShakerCLIParams.PERCOLATOR_CACHE.id) + " " + PeptideShakerCLIParams.PERCOLATOR_CACHE.description + "\n";
        output = output + "\n\nOptional Export Parameters:\n\n";
        output = output + "-" + String.format(formatter, PeptideShakerCLIParams.ZIP.id) + " " + PeptideShakerCLIParams.ZIP.description + "\n";
        output = output + "-" + String.format(formatter, PeptideShakerCLIParams.OUTPUT_MGF.id) + " " + PeptideShakerCLIParams.OUTPUT_MGF.description + "\n";
        output = output + "\n\nOptional Log Folder:\n\n";
        output = output + "-" + String.format(formatter, PathSettingsCLIParams.LOG_FOLDER.id) + " " + PathSettingsCLIParams.LOG_FOLDER.description + "\n";
        output = output + "-" + String.format(formatter, PathSettingsCLIParams.USE_LOG_FOLDER.id) + " " + PathSettingsCLIParams.USE_LOG_FOLDER.description + "\n";
        output = output + "\n\nOptional Temporary Folders:\n\n";
        output = output + "-" + String.format(formatter, PathSettingsCLIParams.ALL.id) + " " + PathSettingsCLIParams.ALL.description + "\n";
        output = output + "-" + String.format(formatter, PeptideShakerCLIParams.CONFIG_FOLDER.id) + " " + PeptideShakerCLIParams.CONFIG_FOLDER.description + "\n";
        output = output + "\n\nFor identification parameters options:\nReplace eu.isas.peptideshaker.cmd.PeptideShakerCLI with eu.isas.peptideshaker.cmd.IdentificationParametersCLI\n\n";
        output = output + "\nFor follow up export options:\nReplace eu.isas.peptideshaker.cmd.PeptideShakerCLI with eu.isas.peptideshaker.cmd.FollowUpCLI\n\n";
        output = output + "\nFor report export options:\nReplace eu.isas.peptideshaker.cmd.PeptideShakerCLI with eu.isas.peptideshaker.cmd.ReportCLI\n";
        output = output + "\nFor mzid export options:\nReplace eu.isas.peptideshaker.cmd.PeptideShakerCLI with eu.isas.peptideshaker.cmd.MzidCLI\n";
        output = output + "\nFor path setting options:\nReplace eu.isas.peptideshaker.cmd.PeptideShakerCLI with eu.isas.peptideshaker.cmd.PathSettingsCLI\n";
        return output;
    }
}

