/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.cmd;

import com.compomics.util.experiment.biology.enzymes.EnzymeFactory;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.taxonomy.SpeciesFactory;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingHandlerCLIImpl;
import com.compomics.util.io.IoUtil;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.PeptideShaker;
import eu.isas.peptideshaker.cmd.CLIExportMethods;
import eu.isas.peptideshaker.cmd.PathSettingsCLI;
import eu.isas.peptideshaker.cmd.PeptideShakerCLI;
import eu.isas.peptideshaker.cmd.ReportCLIInputBean;
import eu.isas.peptideshaker.cmd.ReportCLIParams;
import eu.isas.peptideshaker.utils.PsdbParent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.sql.SQLException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;

public class ReportCLI
extends PsdbParent {
    private final ReportCLIInputBean reportCLIInputBean;
    private EnzymeFactory enzymeFactory;
    private WaitingHandler waitingHandler;
    private ModificationFactory modificationFactory;
    private UtilitiesUserParameters utilitiesUserPreferences;

    public ReportCLI(ReportCLIInputBean reportCLIInputBean) {
        this.reportCLIInputBean = reportCLIInputBean;
    }

    public Object call() {
        block31: {
            block30: {
                try {
                    Class<?> loggerClass = Class.forName("jdk.internal.module.IllegalAccessLogger");
                    Field loggerField = loggerClass.getDeclaredField("logger");
                    Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                    Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
                    unsafeField.setAccessible(true);
                    Object unsafe = unsafeField.get(null);
                    Long offset = (Long)unsafeClass.getMethod("staticFieldOffset", Field.class).invoke(unsafe, loggerField);
                    unsafeClass.getMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class).invoke(unsafe, loggerClass, offset, null);
                }
                catch (Throwable loggerClass) {
                    // empty catch block
                }
                this.setDbFolder(PeptideShaker.getMatchesFolder());
                this.utilitiesUserPreferences = UtilitiesUserParameters.loadUserParameters();
                PeptideShaker.instantiateFacories(this.utilitiesUserPreferences);
                this.modificationFactory = ModificationFactory.getInstance();
                this.enzymeFactory = EnzymeFactory.getInstance();
                this.loadSpecies();
                this.waitingHandler = new WaitingHandlerCLIImpl();
                String inputFilePath = null;
                try {
                    if (this.reportCLIInputBean.getZipFile() != null) {
                        inputFilePath = this.reportCLIInputBean.getZipFile().getAbsolutePath();
                        this.loadPsdbFromZipFile(this.reportCLIInputBean.getZipFile(), PeptideShaker.getMatchesFolder(), this.waitingHandler);
                        break block30;
                    }
                    if (this.reportCLIInputBean.getPsdbFile() != null) {
                        inputFilePath = this.reportCLIInputBean.getPsdbFile().getAbsolutePath();
                        this.psdbFile = this.reportCLIInputBean.getPsdbFile();
                        this.loadPsdbFile(PeptideShaker.getMatchesFolder(), this.waitingHandler, false);
                        break block30;
                    }
                    this.waitingHandler.appendReport("PeptideShaker project input missing.", true, true);
                    return 1;
                }
                catch (IOException e) {
                    this.waitingHandler.appendReport("An error occurred while reading: " + inputFilePath + ".", true, true);
                    e.printStackTrace();
                    try {
                        PeptideShakerCLI.closePeptideShaker(this.identification);
                    }
                    catch (Exception unsafeClass) {
                        // empty catch block
                    }
                    return 1;
                }
            }
            try {
                if (this.loadSpectrumFiles(this.waitingHandler)) break block31;
                if (this.identification.getFractions().size() > 1) {
                    this.waitingHandler.appendReport("The spectrum files were not found. Please provide their location in the command line parameters.", true, true);
                } else {
                    this.waitingHandler.appendReport("The spectrum file was not found. Please provide its location in the command line parameters.", true, true);
                }
                try {
                    PeptideShakerCLI.closePeptideShaker(this.identification);
                }
                catch (Exception e2) {
                    this.waitingHandler.appendReport("An error occurred while closing PeptideShaker.", true, true);
                    e2.printStackTrace();
                }
                return 1;
            }
            catch (Exception e) {
                this.waitingHandler.appendReport("An error occurred while loading the spectrum file(s).", true, true);
                e.printStackTrace();
                try {
                    PeptideShakerCLI.closePeptideShaker(this.identification);
                }
                catch (Exception e2) {
                    this.waitingHandler.appendReport("An error occurred while closing PeptideShaker.", true, true);
                    e2.printStackTrace();
                }
                return 1;
            }
        }
        try {
            this.loadFastaFile(this.waitingHandler);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.waitingHandler.appendReport("An error occurred while parsing the fasta file.", true, true);
            this.waitingHandler.setRunCanceled();
            return 1;
        }
        String error = PeptideShaker.loadModifications(this.getIdentificationParameters().getSearchParameters());
        if (error != null) {
            System.out.println(error);
        }
        if (this.reportCLIInputBean.exportNeeded()) {
            for (String reportType : this.reportCLIInputBean.getReportTypes()) {
                try {
                    CLIExportMethods.exportReport(this.reportCLIInputBean, reportType, this.projectParameters.getProjectUniqueName(), this.projectDetails, this.identification, this.geneMaps, this.identificationFeaturesGenerator, this.identificationParameters, this.sequenceProvider, this.proteinDetailsProvider, this.msFileHandler, this.displayParameters.getnAASurroundingPeptides(), this.spectrumCountingParameters, this.waitingHandler);
                }
                catch (Exception e) {
                    this.waitingHandler.appendReport("An error occurred while exporting the " + reportType + ".", true, true);
                    e.printStackTrace();
                    this.waitingHandler.setRunCanceled();
                }
            }
        }
        if (this.reportCLIInputBean.documentationExportNeeded()) {
            for (String reportType : this.reportCLIInputBean.getReportTypes()) {
                try {
                    CLIExportMethods.exportDocumentation(this.reportCLIInputBean, reportType, this.waitingHandler);
                }
                catch (Exception e) {
                    this.waitingHandler.appendReport("An error occurred while exporting the documentation for " + reportType + ".", true, true);
                    e.printStackTrace();
                    this.waitingHandler.setRunCanceled();
                }
            }
        }
        try {
            PeptideShakerCLI.closePeptideShaker(this.identification);
        }
        catch (Exception e2) {
            this.waitingHandler.appendReport("An error occurred while closing PeptideShaker.", true, true);
            e2.printStackTrace();
        }
        if (!this.waitingHandler.isRunCanceled()) {
            this.waitingHandler.appendReport("Report export completed.", true, true);
            System.exit(0);
            return 0;
        }
        System.exit(1);
        return 1;
    }

    private static String getHeader() {
        return System.getProperty("line.separator") + "The PeptideShaker report command line takes a psdb file and generates various types of reports." + System.getProperty("line.separator") + System.getProperty("line.separator") + "For further help see https://compomics.github.io/projects/peptide-shaker.html and https://compomics.github.io/projects/peptide-shaker/wiki/PeptideShakerCLI.html." + System.getProperty("line.separator") + System.getProperty("line.separator") + "Or contact the developers at https://groups.google.com/group/peptide-shaker." + System.getProperty("line.separator") + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + "OPTIONS" + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + System.getProperty("line.separator");
    }

    private static boolean isValidStartup(CommandLine aLine) throws IOException {
        if (aLine.getOptions().length == 0) {
            return false;
        }
        if (!aLine.hasOption(ReportCLIParams.PSDB_FILE.id) || aLine.getOptionValue(ReportCLIParams.PSDB_FILE.id).equals("")) {
            System.out.println("\n" + ReportCLIParams.PSDB_FILE.description + " not specified.\n");
            return false;
        }
        String fileTxt = aLine.getOptionValue(ReportCLIParams.PSDB_FILE.id);
        File testFile = new File(fileTxt.trim());
        if (!testFile.exists()) {
            System.out.println("\n" + ReportCLIParams.PSDB_FILE.description + " '" + testFile.getAbsolutePath() + "' not found.\n");
            return false;
        }
        if (!aLine.hasOption(ReportCLIParams.EXPORT_FOLDER.id) || aLine.getOptionValue(ReportCLIParams.EXPORT_FOLDER.id).equals("")) {
            System.out.println("\n" + ReportCLIParams.EXPORT_FOLDER.description + " not specified.\n");
            return false;
        }
        fileTxt = aLine.getOptionValue(ReportCLIParams.EXPORT_FOLDER.id);
        testFile = new File(fileTxt.trim());
        if (!testFile.exists()) {
            System.out.println("\n" + ReportCLIParams.EXPORT_FOLDER.description + " '" + testFile.getAbsolutePath() + "' not found.\n");
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            String[] nonPathSettingArgsAsList = PathSettingsCLI.extractAndUpdatePathOptions(args);
            Options nonPathOptions = new Options();
            ReportCLIParams.createOptionsCLI(nonPathOptions);
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(nonPathOptions, nonPathSettingArgsAsList);
            if (!ReportCLI.isValidStartup(line)) {
                PrintWriter lPrintWriter = new PrintWriter(System.out);
                lPrintWriter.print(System.getProperty("line.separator") + "===============================================" + System.getProperty("line.separator"));
                lPrintWriter.print("PeptideShaker Report Exporter - Command Line" + System.getProperty("line.separator"));
                lPrintWriter.print("===============================================" + System.getProperty("line.separator"));
                lPrintWriter.print(ReportCLI.getHeader());
                lPrintWriter.print(ReportCLIParams.getOptionsAsString());
                lPrintWriter.flush();
                lPrintWriter.close();
                System.exit(0);
            } else {
                ReportCLIInputBean lCLIBean = new ReportCLIInputBean(line);
                ReportCLI cli = new ReportCLI(lCLIBean);
                cli.call();
            }
        }
        catch (OutOfMemoryError e) {
            System.out.println("<CompomicsError>PeptideShaker used up all the memory and had to be stopped. See the PeptideShaker log for details.</CompomicsError>");
            System.err.println("Ran out of memory!");
            System.err.println("Memory given to the Java virtual machine: " + Runtime.getRuntime().maxMemory() + ".");
            System.err.println("Memory used by the Java virtual machine: " + Runtime.getRuntime().totalMemory() + ".");
            System.err.println("Free memory in the Java virtual machine: " + Runtime.getRuntime().freeMemory() + ".");
            e.printStackTrace();
            System.exit(1);
        }
        catch (Exception e) {
            System.out.print("<CompomicsError>PeptideShaker processing failed. See the PeptideShaker log for details.</CompomicsError>");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public String toString() {
        return "FollowUpCLI{, cliInputBean=" + this.reportCLIInputBean + '}';
    }

    public void closePeptideShaker() throws IOException, SQLException, InterruptedException, ClassNotFoundException {
        this.identification.close(false);
        File matchFolder = PeptideShaker.getMatchesFolder();
        File[] tempFiles = matchFolder.listFiles();
        if (tempFiles != null) {
            for (File currentFile : tempFiles) {
                IoUtil.deleteDir(currentFile);
            }
        }
    }

    private void loadSpecies() {
        try {
            SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
            speciesFactory.initiate(PeptideShaker.getConfigFolder());
        }
        catch (Exception e) {
            System.out.println("An error occurred while loading the species.");
            e.printStackTrace();
        }
    }
}

