/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.cmd;

import com.compomics.software.log.CliLogger;
import com.compomics.util.Util;
import eu.isas.peptideshaker.PeptideShaker;
import eu.isas.peptideshaker.cmd.StirredOptions;
import eu.isas.peptideshaker.cmd.StirredOptionsBean;
import eu.isas.peptideshaker.stirred.Stirred;
import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;

public class StirredCLI {
    public static void main(String[] args) {
        if (args.length == 0 || args.length == 1 && args[0].equals("-h") || args.length == 1 && args[0].equals("--help")) {
            StirredCLI.printHelp();
            return;
        }
        if (args.length == 1 && args[0].equals("-v") || args.length == 1 && args[0].equals("--version")) {
            System.out.println(Util.getVersion());
            return;
        }
        try {
            Options lOptions = new Options();
            StirredOptions.createOptionsCLI(lOptions);
            DefaultParser parser = new DefaultParser();
            CommandLine commandLine = parser.parse(lOptions, args);
            StirredOptionsBean optionBean = new StirredOptionsBean(commandLine);
            try (CliLogger cliLogger = new CliLogger(optionBean.logFile, "PeptideShaker", Util.getVersion());){
                cliLogger.writeComment("Software", "PeptideShaker");
                cliLogger.writeComment("Version", PeptideShaker.getVersion());
                cliLogger.writeComment("CLI", "StirredCLI");
                cliLogger.writeComment("Command", String.join((CharSequence)" ", args));
                Stirred stirred = new Stirred(optionBean.inputFile, optionBean.spectrumFile, optionBean.fastaFile, optionBean.outputFolder, optionBean.identificationParametersFile, optionBean.tempFolder, cliLogger, optionBean.nThreads, optionBean.timeOutDays, optionBean.contactFirstName, optionBean.contactLastName, optionBean.contactAddress, optionBean.contactEmail, optionBean.contactOrganizationName, optionBean.contactOrganizationAddress, optionBean.contactOrganizationEmail);
                stirred.run();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void printHelp() {
        try (PrintWriter lPrintWriter = new PrintWriter(System.out);){
            lPrintWriter.print(Util.LINE_SEPARATOR);
            lPrintWriter.print("==================================" + Util.LINE_SEPARATOR);
            lPrintWriter.print("          PeptideShaker           " + Util.LINE_SEPARATOR);
            lPrintWriter.print("               ****               " + Util.LINE_SEPARATOR);
            lPrintWriter.print("              Stirred             " + Util.LINE_SEPARATOR);
            lPrintWriter.print("==================================" + Util.LINE_SEPARATOR);
            lPrintWriter.print(Util.LINE_SEPARATOR + "The Stirred CLI maps peptides to proteins, scores modification localization, and exports mzIdentML from search engine results." + Util.LINE_SEPARATOR + Util.LINE_SEPARATOR + "For documentation and bug report please refer to our code repository github.com/compomics/compomics-utilities/." + Util.LINE_SEPARATOR + Util.LINE_SEPARATOR + "----------------------" + Util.LINE_SEPARATOR + "OPTIONS" + Util.LINE_SEPARATOR + "----------------------" + Util.LINE_SEPARATOR + Util.LINE_SEPARATOR);
            lPrintWriter.print(StirredOptions.getOptionsAsString());
            lPrintWriter.flush();
        }
    }
}

