/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.export;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.experiment.biology.ions.impl.ImmoniumIon;
import com.compomics.util.experiment.biology.ions.impl.PeptideFragmentIon;
import com.compomics.util.experiment.biology.ions.impl.PrecursorIon;
import com.compomics.util.experiment.biology.ions.impl.RelatedIon;
import com.compomics.util.experiment.biology.ions.impl.ReporterIon;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationProvider;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.PeptideMatchesIterator;
import com.compomics.util.experiment.identification.matches_iterators.ProteinMatchesIterator;
import com.compomics.util.experiment.identification.matches_iterators.SpectrumMatchesIterator;
import com.compomics.util.experiment.identification.modification.ModificationLocalizationScore;
import com.compomics.util.experiment.identification.peptide_shaker.ModificationScoring;
import com.compomics.util.experiment.identification.peptide_shaker.PSModificationScores;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.io.biology.protein.FastaSummary;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.io.identification.MzIdentMLVersion;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.flat.SimpleFileWriter;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.IdMatchValidationParameters;
import com.compomics.util.parameters.identification.advanced.ModificationLocalizationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.pride.CvTerm;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.preferences.ProjectDetails;
import eu.isas.peptideshaker.scoring.PSMaps;
import eu.isas.peptideshaker.scoring.targetdecoy.TargetDecoyMap;
import eu.isas.peptideshaker.scoring.targetdecoy.TargetDecoyResults;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.text.StringEscapeUtils;

public class MzIdentMLExport {
    private SimpleFileWriter writer;
    private int tabCounter = 0;
    private final ModificationProvider modificationProvider;
    private final int CONFIDENCE_DECIMALS = 4;
    private int maxNeutralLosses;
    private MzIdentMLVersion mzIdentMLVersion = MzIdentMLVersion.v1_1;
    private final SequenceProvider sequenceProvider;
    private final SpectrumProvider spectrumProvider;
    private final FastaSummary fastaSummary;
    private final ProteinDetailsProvider proteinDetailsProvider;
    private final String peptideShakerVersion;
    private final Identification identification;
    private final ProjectDetails projectDetails;
    private final IdentificationFeaturesGenerator identificationFeaturesGenerator;
    private final PeptideSpectrumAnnotator peptideSpectrumAnnotator;
    private final WaitingHandler waitingHandler;
    private final HashMap<String, String> pepEvidenceIds = new HashMap();
    private final HashMap<Long, String> spectrumIds = new HashMap();
    private final IdentificationParameters identificationParameters;
    private final HashMap<Double, Integer> modIndexMap = new HashMap();
    private final HashMap<String, HashMap<String, Integer>> spectrumTitleToIndexMap = new HashMap(0);
    private final boolean writeFragmentIons = true;
    private final boolean includeProteinSequences;

    public MzIdentMLExport(String peptideShakerVersion, Identification identification, ProjectDetails projectDetails, IdentificationParameters identificationParameters, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, SpectrumProvider spectrumProvider, ModificationProvider modificationProvider, FastaSummary fastaSummary, IdentificationFeaturesGenerator identificationFeaturesGenerator, File outputFile, boolean includeProteinSequences, WaitingHandler waitingHandler, boolean gzip) {
        this.peptideShakerVersion = peptideShakerVersion;
        this.identification = identification;
        this.projectDetails = projectDetails;
        this.identificationParameters = identificationParameters;
        this.sequenceProvider = sequenceProvider;
        this.proteinDetailsProvider = proteinDetailsProvider;
        this.spectrumProvider = spectrumProvider;
        this.modificationProvider = modificationProvider;
        this.fastaSummary = fastaSummary;
        this.identificationFeaturesGenerator = identificationFeaturesGenerator;
        this.includeProteinSequences = includeProteinSequences;
        this.waitingHandler = waitingHandler;
        this.peptideSpectrumAnnotator = new PeptideSpectrumAnnotator();
        this.setSpectrumTitlesMap();
        this.writer = new SimpleFileWriter(outputFile, gzip);
    }

    private void setSpectrumTitlesMap() {
        for (String fileNameWithoutExtension : this.spectrumProvider.getOrderedFileNamesWithoutExtensions()) {
            String[] spectrumTitles = this.spectrumProvider.getSpectrumTitles(fileNameWithoutExtension);
            HashMap<String, Integer> tempMap = new HashMap<String, Integer>(spectrumTitles.length);
            for (int i = 0; i < spectrumTitles.length; ++i) {
                tempMap.put(spectrumTitles[i], i);
            }
            this.spectrumTitleToIndexMap.put(fileNameWithoutExtension, tempMap);
        }
    }

    public void createMzIdentMLFile(MzIdentMLVersion mzIdentMLVersion) {
        this.mzIdentMLVersion = mzIdentMLVersion;
        switch (mzIdentMLVersion) {
            case v1_1: {
                this.maxNeutralLosses = 0;
                break;
            }
            case v1_2: {
                this.maxNeutralLosses = 1;
                break;
            }
            default: {
                throw new UnsupportedOperationException("mzIdentML version " + mzIdentMLVersion.name + " not supported.");
            }
        }
        this.waitingHandler.setPrimaryProgressCounterIndeterminate(true);
        this.writeMzIdentMLStartTag();
        this.writeCvList();
        this.writeAnalysisSoftwareList();
        this.writeProviderDetails();
        this.writeAuditCollection();
        this.waitingHandler.setPrimaryProgressCounterIndeterminate(false);
        this.waitingHandler.resetPrimaryProgressCounter();
        this.waitingHandler.setMaxPrimaryProgressCounter(this.fastaSummary.nSequences + this.identification.getPeptideIdentification().size() * 2 + this.identification.getSpectrumIdentificationSize() + this.identification.getProteinIdentification().size());
        this.writeSequenceCollection();
        this.writeAnalysisCollection();
        this.writeAnalysisProtocol();
        this.writeDataCollection();
        this.writeMzIdentMLEndTag();
        this.writer.close();
    }

    private void writeCvList() {
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<cvList>");
        this.writer.newLine();
        ++this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<cv id=\"PSI-MS\" ");
        this.writer.write("uri=\"https://raw.githubusercontent.com/HUPO-PSI/psi-ms-CV/master/psi-ms.obo\" ");
        this.writer.write("fullName=\"PSI-MS\"/>");
        this.writer.newLine();
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<cv id=\"UNIMOD\" ");
        this.writer.write("uri=\"http://www.unimod.org/obo/unimod.obo\" ");
        this.writer.write("fullName=\"UNIMOD\"/>");
        this.writer.newLine();
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<cv id=\"UO\" ");
        this.writer.write("uri=\"https://raw.githubusercontent.com/bio-ontology-research-group/unit-ontology/master/unit.obo\" ");
        this.writer.write("fullName=\"UNIT-ONTOLOGY\"/>");
        this.writer.newLine();
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<cv id=\"PRIDE\" ");
        this.writer.write("uri=\"https://github.com/PRIDE-Utilities/pride-ontology/blob/master/pride_cv.obo\" ");
        this.writer.write("fullName=\"PRIDE\"/>");
        this.writer.newLine();
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</cvList>");
        this.writer.newLine();
    }

    private void writeAnalysisSoftwareList() {
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<AnalysisSoftwareList>");
        this.writer.newLine();
        ++this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<AnalysisSoftware name=\"PeptideShaker\" version=\"");
        this.writer.write(this.peptideShakerVersion);
        this.writer.write("\" id=\"ID_software\" uri=\"https://compomics.github.io/projects/peptide-shaker.html\">");
        this.writer.newLine();
        ++this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<ContactRole contact_ref=\"PS_DEV\">");
        this.writer.newLine();
        ++this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<Role>");
        this.writer.newLine();
        ++this.tabCounter;
        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001267", "software vendor", null));
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</Role>");
        this.writer.newLine();
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</ContactRole>");
        this.writer.newLine();
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<SoftwareName>");
        this.writer.newLine();
        ++this.tabCounter;
        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002458", "PeptideShaker", null));
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</SoftwareName>");
        this.writer.newLine();
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<Customizations>No customisations</Customizations>");
        this.writer.newLine();
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</AnalysisSoftware>");
        this.writer.newLine();
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</AnalysisSoftwareList>");
        this.writer.newLine();
    }

    private void writeProviderDetails() {
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<Provider id=\"PROVIDER\">");
        this.writer.newLine();
        ++this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<ContactRole contact_ref=\"PROVIDER\">");
        this.writer.newLine();
        ++this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<Role>");
        this.writer.newLine();
        ++this.tabCounter;
        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001271", "researcher", null));
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</Role>");
        this.writer.newLine();
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</ContactRole>");
        this.writer.newLine();
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</Provider>");
        this.writer.newLine();
    }

    private void writeAuditCollection() {
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<AuditCollection>");
        this.writer.newLine();
        ++this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<Person firstName=\"");
        this.writer.write(StringEscapeUtils.escapeHtml4((String)this.projectDetails.getContactFirstName()));
        this.writer.write("\" lastName=\"");
        this.writer.write(StringEscapeUtils.escapeHtml4((String)this.projectDetails.getContactLastName()));
        this.writer.write("\" id=\"PROVIDER\">");
        this.writer.newLine();
        ++this.tabCounter;
        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1000587", "contact address", StringEscapeUtils.escapeHtml4((String)this.projectDetails.getContactAddress())));
        if (this.projectDetails.getContactUrl() != null && !this.projectDetails.getContactUrl().isEmpty()) {
            this.writeCvTerm(new CvTerm("PSI-MS", "MS:1000588", "contact URL", this.projectDetails.getContactUrl()));
        }
        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1000589", "contact email", this.projectDetails.getContactEmail()));
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<Affiliation organization_ref=\"ORG_DOC_OWNER\"/>");
        this.writer.newLine();
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</Person>");
        this.writer.newLine();
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<Organization name=\"");
        this.writer.write(StringEscapeUtils.escapeHtml4((String)this.projectDetails.getOrganizationName()));
        this.writer.write("\" id=\"ORG_DOC_OWNER\">");
        this.writer.newLine();
        ++this.tabCounter;
        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1000586", "contact name", StringEscapeUtils.escapeHtml4((String)this.projectDetails.getOrganizationName())));
        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1000587", "contact address", StringEscapeUtils.escapeHtml4((String)this.projectDetails.getOrganizationAddress())));
        if (this.projectDetails.getOrganizationUrl() != null && !this.projectDetails.getOrganizationUrl().isEmpty()) {
            this.writeCvTerm(new CvTerm("PSI-MS", "MS:1000588", "contact URL", this.projectDetails.getOrganizationUrl()));
        }
        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1000589", "contact email", this.projectDetails.getOrganizationEmail()));
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</Organization>");
        this.writer.newLine();
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<Organization name=\"PeptideShaker developers\" id=\"PS_DEV\">");
        this.writer.newLine();
        ++this.tabCounter;
        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1000586", "contact name", "PeptideShaker developers"));
        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1000587", "contact address", "Proteomics Unit, Building for Basic Biology, University of Bergen, Jonas Liesvei 91, N-5009 Bergen, Norway"));
        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1000588", "contact URL", "https://compomics.github.io/projects/peptide-shaker.html"));
        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1000589", "contact email", "peptide-shaker@googlegroups.com"));
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</Organization>");
        this.writer.newLine();
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</AuditCollection>");
        this.writer.newLine();
    }

    private void writeSequenceCollection() {
        PeptideMatch peptideMatch;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<SequenceCollection>");
        this.writer.newLine();
        ++this.tabCounter;
        for (String accession : this.sequenceProvider.getAccessions()) {
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("<DBSequence id=\"");
            this.writer.write(accession);
            this.writer.write("\" ");
            this.writer.write("accession=\"");
            this.writer.write(accession);
            this.writer.write("\" searchDatabase_ref=\"SearchDB_1\" >");
            this.writer.newLine();
            ++this.tabCounter;
            if (this.includeProteinSequences) {
                String sequence = this.sequenceProvider.getSequence(accession);
                this.writer.write(this.getCurrentTabSpace());
                this.writer.write("<Seq>");
                this.writer.write(sequence);
                this.writer.write("</Seq>");
                this.writer.newLine();
            }
            String description = this.proteinDetailsProvider.getDescription(accession);
            this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001088", "protein description", StringEscapeUtils.escapeHtml4((String)description)));
            --this.tabCounter;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("</DBSequence>");
            this.writer.newLine();
            this.waitingHandler.increasePrimaryProgressCounter();
            if (!this.waitingHandler.isRunCanceled()) continue;
            return;
        }
        PeptideMatchesIterator peptideMatchesIterator = this.identification.getPeptideMatchesIterator(this.waitingHandler);
        while ((peptideMatch = peptideMatchesIterator.next()) != null) {
            long peptideKey = peptideMatch.getKey();
            Peptide peptide = peptideMatch.getPeptide();
            String peptideSequence = peptide.getSequence();
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("<Peptide id=\"");
            this.writer.write(Long.toString(peptideKey));
            this.writer.write("\">");
            this.writer.newLine();
            ++this.tabCounter;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("<PeptideSequence>");
            this.writer.write(peptideSequence);
            this.writer.write("</PeptideSequence>");
            this.writer.newLine();
            String[] fixedModifications = peptide.getFixedModifications(this.identificationParameters.getSearchParameters().getModificationParameters(), this.sequenceProvider, this.identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters());
            for (int site = 0; site < fixedModifications.length; ++site) {
                String modName = fixedModifications[site];
                if (modName == null) continue;
                Modification modification = this.modificationProvider.getModification(modName);
                int aa = Math.min(Math.max(site, 1), peptideSequence.length());
                this.writer.write(this.getCurrentTabSpace());
                this.writer.write("<Modification monoisotopicMassDelta=\"");
                this.writer.write(Double.toString(modification.getRoundedMass()));
                this.writer.write("\" residues=\"");
                this.writer.write(Character.toString(peptideSequence.charAt(aa - 1)));
                this.writer.write("\" location=\"");
                this.writer.write(Integer.toString(site));
                this.writer.write("\" >");
                this.writer.newLine();
                CvTerm ptmCvTerm = modification.getUnimodCvTerm();
                if (ptmCvTerm != null) {
                    ++this.tabCounter;
                    this.writeCvTerm(ptmCvTerm, false);
                    --this.tabCounter;
                } else {
                    ptmCvTerm = modification.getPsiModCvTerm();
                    if (ptmCvTerm != null) {
                        ++this.tabCounter;
                        if (ptmCvTerm != null) {
                            this.writeCvTerm(ptmCvTerm);
                        } else {
                            this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001460", "unknown modification", null));
                        }
                        --this.tabCounter;
                    }
                }
                this.writer.write(this.getCurrentTabSpace());
                this.writer.write("</Modification>");
                this.writer.newLine();
            }
            for (ModificationMatch modMatch : peptide.getVariableModifications()) {
                Modification modification = this.modificationProvider.getModification(modMatch.getModification());
                int site = modMatch.getSite();
                int aa = Math.min(Math.max(site, 1), peptideSequence.length());
                this.writer.write(this.getCurrentTabSpace());
                this.writer.write("<Modification monoisotopicMassDelta=\"");
                this.writer.write(Double.toString(modification.getRoundedMass()));
                this.writer.write("\" residues=\"");
                this.writer.write(Character.toString(peptideSequence.charAt(aa - 1)));
                this.writer.write("\" location=\"");
                this.writer.write(Integer.toString(site));
                this.writer.write("\" >");
                this.writer.newLine();
                CvTerm ptmCvTerm = modification.getUnimodCvTerm();
                if (ptmCvTerm != null) {
                    ++this.tabCounter;
                    this.writeCvTerm(ptmCvTerm, false);
                    --this.tabCounter;
                } else {
                    ptmCvTerm = modification.getPsiModCvTerm();
                    ++this.tabCounter;
                    if (ptmCvTerm != null) {
                        this.writeCvTerm(ptmCvTerm);
                    } else {
                        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001460", "unknown modification", null));
                    }
                    --this.tabCounter;
                }
                this.writer.write(this.getCurrentTabSpace());
                this.writer.write("</Modification>");
                this.writer.newLine();
            }
            --this.tabCounter;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("</Peptide>");
            this.writer.newLine();
            this.waitingHandler.increasePrimaryProgressCounter();
            if (!this.waitingHandler.isRunCanceled()) continue;
            break;
        }
        int peptideEvidenceCounter = 0;
        int nAa = 1;
        peptideMatchesIterator = this.identification.getPeptideMatchesIterator(this.waitingHandler);
        while ((peptideMatch = peptideMatchesIterator.next()) != null) {
            long peptideKey = peptideMatch.getKey();
            Peptide peptide = peptideMatch.getPeptide();
            TreeMap<String, int[]> proteinMapping = peptide.getProteinMapping();
            for (Map.Entry<String, int[]> entry : proteinMapping.entrySet()) {
                int[] indexes;
                String accession = entry.getKey();
                for (int index : indexes = entry.getValue()) {
                    String aaAfter;
                    String aaBefore = PeptideUtils.getAaBefore(peptide, accession, index, nAa, this.sequenceProvider);
                    if (aaBefore.length() == 0) {
                        aaBefore = "-";
                    }
                    if ((aaAfter = PeptideUtils.getAaAfter(peptide, accession, index, nAa, this.sequenceProvider)).length() == 0) {
                        aaAfter = "-";
                    }
                    int peptideStart = index;
                    int peptideEnd = index + peptide.getSequence().length();
                    String pepEvidenceKey = MzIdentMLExport.getPeptideEvidenceKey(accession, peptideStart, peptideKey);
                    StringBuilder pepEvidenceValueBuilder = new StringBuilder();
                    pepEvidenceValueBuilder.append("PepEv_").append(++peptideEvidenceCounter);
                    String pepEvidenceValue = pepEvidenceValueBuilder.toString();
                    this.pepEvidenceIds.put(pepEvidenceKey, pepEvidenceValue);
                    this.writer.write(this.getCurrentTabSpace());
                    this.writer.write("<PeptideEvidence isDecoy=\"");
                    this.writer.write(Boolean.toString(PeptideUtils.isDecoy(peptideMatch.getPeptide(), this.sequenceProvider)));
                    this.writer.write("\" pre=\"");
                    this.writer.write(aaBefore);
                    this.writer.write("\" post=\"");
                    this.writer.write(aaAfter);
                    this.writer.write("\" start=\"");
                    this.writer.write(Integer.toString(peptideStart + 1));
                    this.writer.write("\" end=\"");
                    this.writer.write(Integer.toString(peptideEnd + 1));
                    this.writer.write("\" peptide_ref=\"");
                    this.writer.write(Long.toString(peptideKey));
                    this.writer.write("\" dBSequence_ref=\"");
                    this.writer.write(accession);
                    this.writer.write("\" id=\"");
                    this.writer.write(pepEvidenceValue);
                    this.writer.write("\" />");
                    this.writer.newLine();
                }
            }
            this.waitingHandler.increasePrimaryProgressCounter();
            if (!this.waitingHandler.isRunCanceled()) continue;
            break;
        }
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</SequenceCollection>");
        this.writer.newLine();
    }

    public static String getPeptideEvidenceKey(String accession, int peptideStart, long peptideKey) {
        String peptideStartAsString = Integer.toString(peptideStart);
        String peptideKeyAsString = Long.toString(peptideKey);
        StringBuilder pepEvidenceKeybuilder = new StringBuilder(accession.length() + peptideStartAsString.length() + peptideKeyAsString.length() + 2);
        pepEvidenceKeybuilder.append(accession).append('_').append(peptideStartAsString).append('_').append(peptideKeyAsString);
        return pepEvidenceKeybuilder.toString();
    }

    private void writeAnalysisCollection() {
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<AnalysisCollection>");
        this.writer.newLine();
        ++this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<SpectrumIdentification spectrumIdentificationList_ref=\"SIL_1\" ");
        this.writer.write("spectrumIdentificationProtocol_ref=\"SearchProtocol_1\" id=\"SpecIdent_1\">");
        this.writer.newLine();
        ++this.tabCounter;
        for (String spectrumFileNameWithoutExtension : this.spectrumProvider.getOrderedFileNamesWithoutExtensions()) {
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("<InputSpectra spectraData_ref=\"");
            this.writer.write(spectrumFileNameWithoutExtension);
            this.writer.write("\"/>");
            this.writer.newLine();
        }
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<SearchDatabaseRef searchDatabase_ref=\"SearchDB_1\"/>");
        this.writer.newLine();
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</SpectrumIdentification>");
        this.writer.newLine();
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<ProteinDetection proteinDetectionProtocol_ref=\"PeptideShaker_1\" ");
        this.writer.write("proteinDetectionList_ref=\"Protein_groups\" id=\"PD_1\">");
        this.writer.newLine();
        ++this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<InputSpectrumIdentifications spectrumIdentificationList_ref=\"SIL_1\"/>");
        this.writer.newLine();
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</ProteinDetection>");
        this.writer.newLine();
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</AnalysisCollection>");
        this.writer.newLine();
    }

    private void writeAnalysisProtocol() {
        String precursorIonToleranceUnit;
        String unitAccession;
        String fragmentIonToleranceUnit;
        CvTerm enzymeCvTerm;
        Object modification;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<AnalysisProtocolCollection>");
        this.writer.newLine();
        ++this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<SpectrumIdentificationProtocol analysisSoftware_ref=\"ID_software\" id=\"SearchProtocol_1\">");
        this.writer.newLine();
        ++this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<SearchType>");
        this.writer.newLine();
        ++this.tabCounter;
        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001083", "ms-ms search", null));
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</SearchType>");
        this.writer.newLine();
        SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<AdditionalSearchParams>");
        this.writer.newLine();
        ++this.tabCounter;
        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001211", "parent mass type mono", null));
        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001256", "fragment mass type mono", null));
        switch (this.mzIdentMLVersion) {
            case v1_1: {
                break;
            }
            case v1_2: {
                this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002492", "consensus scoring", null));
                this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002490", "peptide-level scoring", null));
                this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002497", "group PSMs by sequence with modifications", null));
                this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002491", "modification localization scoring", null));
                break;
            }
            default: {
                throw new UnsupportedOperationException("mzIdentML version " + this.mzIdentMLVersion.name + " not supported.");
            }
        }
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</AdditionalSearchParams>");
        this.writer.newLine();
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<ModificationParams>");
        this.writer.newLine();
        ++this.tabCounter;
        switch (this.mzIdentMLVersion) {
            case v1_1: {
                break;
            }
            case v1_2: {
                for (String modName : searchParameters.getModificationParameters().getAllModifications()) {
                    modification = this.modificationProvider.getModification(modName);
                    Double modMass = ((Modification)modification).getMass();
                    Integer index = this.modIndexMap.get(modMass);
                    if (index != null) continue;
                    this.modIndexMap.put(modMass, this.modIndexMap.size());
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("mzIdentML version " + this.mzIdentMLVersion.name + " not supported.");
            }
        }
        for (String modName : searchParameters.getModificationParameters().getAllModifications()) {
            CvTerm ptmCvTerm;
            String aminoAcidsAtTarget;
            modification = this.modificationProvider.getModification(modName);
            ModificationType modificationType = ((Modification)modification).getModificationType();
            double modMass = ((Modification)modification).getMass();
            if (modificationType == ModificationType.modaa || modificationType == ModificationType.modcaa_peptide || modificationType == ModificationType.modcaa_protein || modificationType == ModificationType.modnaa_peptide || modificationType == ModificationType.modnaa_protein) {
                StringBuilder sb = new StringBuilder();
                for (Character aa : ((Modification)modification).getPattern().getAminoAcidsAtTarget()) {
                    sb.append(aa);
                }
                aminoAcidsAtTarget = sb.toString();
            } else {
                aminoAcidsAtTarget = ".";
            }
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("<SearchModification residues=\"");
            this.writer.write(aminoAcidsAtTarget);
            this.writer.write("\" massDelta=\"");
            this.writer.write(Double.toString(((Modification)modification).getRoundedMass()));
            this.writer.write("\" fixedMod= \"");
            this.writer.write(Boolean.toString(searchParameters.getModificationParameters().getFixedModifications().contains(modName)));
            this.writer.write("\" >");
            this.writer.newLine();
            ++this.tabCounter;
            if (modificationType != ModificationType.modaa) {
                this.writer.write(this.getCurrentTabSpace());
                this.writer.write("<SpecificityRules>");
                this.writer.newLine();
                ++this.tabCounter;
                switch (modificationType) {
                    case modn_protein: 
                    case modnaa_protein: {
                        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002057", "modification specificity protein N-term", null));
                        break;
                    }
                    case modn_peptide: 
                    case modnaa_peptide: {
                        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001189", "modification specificity peptide N-term", null));
                        break;
                    }
                    case modc_protein: 
                    case modcaa_protein: {
                        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002058", "modification specificity protein C-term", null));
                        break;
                    }
                    case modc_peptide: 
                    case modcaa_peptide: {
                        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001190", "modification specificity peptide C-term", null));
                        break;
                    }
                }
                --this.tabCounter;
                this.writer.write(this.getCurrentTabSpace());
                this.writer.write("</SpecificityRules>");
                this.writer.newLine();
            }
            if ((ptmCvTerm = ((Modification)modification).getUnimodCvTerm()) != null) {
                this.writeCvTerm(ptmCvTerm);
            } else {
                ptmCvTerm = ((Modification)modification).getPsiModCvTerm();
                if (ptmCvTerm != null) {
                    this.writeCvTerm(ptmCvTerm);
                } else {
                    this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001460", "unknown modification", null));
                }
            }
            switch (this.mzIdentMLVersion) {
                case v1_1: {
                    break;
                }
                case v1_2: {
                    Integer modIndex = this.modIndexMap.get(modMass);
                    if (modIndex == null) {
                        throw new IllegalArgumentException("No index found for PTM " + ((Modification)modification).getName() + " of mass " + modMass + ".");
                    }
                    this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002504", "modification index", modIndex.toString()));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("mzIdentML version " + this.mzIdentMLVersion.name + " not supported.");
                }
            }
            --this.tabCounter;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("</SearchModification>");
            this.writer.newLine();
        }
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</ModificationParams>");
        this.writer.newLine();
        DigestionParameters digestionPreferences = searchParameters.getDigestionParameters();
        if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.unSpecific) {
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("<Enzymes independent=\"false\">");
            this.writer.newLine();
            ++this.tabCounter;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("<Enzyme name=\"unspecific cleavage\">");
            this.writer.newLine();
            ++this.tabCounter;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("<EnzymeName>");
            this.writer.newLine();
            ++this.tabCounter;
            enzymeCvTerm = new CvTerm("PSI-MS", "MS:1001091", "unspecific cleavage", null);
            this.writeCvTerm(enzymeCvTerm);
            --this.tabCounter;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("</EnzymeName>");
            this.writer.newLine();
            --this.tabCounter;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("</Enzyme>");
            this.writer.newLine();
        } else if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.wholeProtein) {
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("<Enzymes independent=\"false\">");
            this.writer.newLine();
            ++this.tabCounter;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("<Enzyme name=\"NoEnzyme\">");
            this.writer.newLine();
            ++this.tabCounter;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("<EnzymeName>");
            this.writer.newLine();
            ++this.tabCounter;
            enzymeCvTerm = new CvTerm("PSI-MS", "MS:1001955", "NoEnzyme", null);
            this.writeCvTerm(enzymeCvTerm);
            --this.tabCounter;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("</EnzymeName>");
            this.writer.newLine();
            --this.tabCounter;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("</Enzyme>");
            this.writer.newLine();
        } else {
            ArrayList<Enzyme> enzymes = digestionPreferences.getEnzymes();
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("<Enzymes independent=\"");
            this.writer.write(Boolean.toString(enzymes.size() > 1));
            this.writer.write("\">");
            this.writer.newLine();
            ++this.tabCounter;
            for (Enzyme enzyme : enzymes) {
                String enzymeName = enzyme.getName();
                this.writer.write(this.getCurrentTabSpace());
                this.writer.write("<Enzyme missedCleavages=\"");
                this.writer.write(Integer.toString(digestionPreferences.getnMissedCleavages(enzymeName)));
                this.writer.write("\" semiSpecific=\"");
                this.writer.write(Boolean.toString(digestionPreferences.getSpecificity(enzymeName) == DigestionParameters.Specificity.semiSpecific));
                this.writer.write("\" ");
                this.writer.write("id=\"Enz1\" name=\"");
                this.writer.write(enzyme.getName());
                this.writer.write("\">");
                this.writer.newLine();
                ++this.tabCounter;
                this.writer.write(this.getCurrentTabSpace());
                this.writer.write("<EnzymeName>");
                this.writer.newLine();
                ++this.tabCounter;
                CvTerm enzymeCvTerm2 = enzyme.getCvTerm();
                if (enzymeCvTerm2 != null) {
                    this.writeCvTerm(enzymeCvTerm2);
                } else {
                    this.writeUserParam(enzyme.getName());
                }
                --this.tabCounter;
                this.writer.write(this.getCurrentTabSpace());
                this.writer.write("</EnzymeName>");
                this.writer.newLine();
                --this.tabCounter;
                this.writer.write(this.getCurrentTabSpace());
                this.writer.write("</Enzyme>");
                this.writer.newLine();
                --this.tabCounter;
            }
        }
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</Enzymes>");
        this.writer.newLine();
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<FragmentTolerance>");
        this.writer.newLine();
        ++this.tabCounter;
        switch (searchParameters.getFragmentAccuracyType()) {
            case DA: {
                fragmentIonToleranceUnit = "dalton";
                unitAccession = "UO:0000221";
                break;
            }
            case PPM: {
                fragmentIonToleranceUnit = "parts per million";
                unitAccession = "UO:0000169";
                break;
            }
            default: {
                throw new UnsupportedOperationException("CV term not implemented for fragment accuracy in " + (Object)((Object)searchParameters.getFragmentAccuracyType()) + ".");
            }
        }
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<cvParam accession=\"MS:1001412\" cvRef=\"PSI-MS\" unitCvRef=\"UO\" unitName=\"");
        this.writer.write(fragmentIonToleranceUnit);
        this.writer.write("\" unitAccession=\"");
        this.writer.write(unitAccession);
        this.writer.write("\" value=\"");
        this.writer.write(Double.toString(searchParameters.getFragmentIonAccuracy()));
        this.writer.write("\" ");
        this.writer.write("name=\"search tolerance plus value\" />");
        this.writer.newLine();
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<cvParam accession=\"MS:1001413\" cvRef=\"PSI-MS\" unitCvRef=\"UO\" unitName=\"");
        this.writer.write(fragmentIonToleranceUnit);
        this.writer.write("\" unitAccession=\"");
        this.writer.write(unitAccession);
        this.writer.write("\" value=\"");
        this.writer.write(Double.toString(searchParameters.getFragmentIonAccuracy()));
        this.writer.write("\" name=\"search tolerance minus value\" />");
        this.writer.newLine();
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</FragmentTolerance>");
        this.writer.newLine();
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<ParentTolerance>");
        this.writer.newLine();
        ++this.tabCounter;
        switch (searchParameters.getPrecursorAccuracyType()) {
            case DA: {
                precursorIonToleranceUnit = "dalton";
                break;
            }
            case PPM: {
                precursorIonToleranceUnit = "parts per million";
                break;
            }
            default: {
                throw new UnsupportedOperationException("CV term not implemented for precursor accuracy in " + (Object)((Object)searchParameters.getFragmentAccuracyType()) + ".");
            }
        }
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<cvParam accession=\"MS:1001412\" cvRef=\"PSI-MS\" unitCvRef=\"UO\" unitName=\"");
        this.writer.write(precursorIonToleranceUnit);
        this.writer.write("\" unitAccession=\"UO:0000169\" value=\"");
        this.writer.write(Double.toString(searchParameters.getPrecursorAccuracy()));
        this.writer.write("\" name=\"search tolerance plus value\" />");
        this.writer.newLine();
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<cvParam accession=\"MS:1001413\" cvRef=\"PSI-MS\" unitCvRef=\"UO\" unitName=\"");
        this.writer.write(precursorIonToleranceUnit);
        this.writer.write("\" unitAccession=\"UO:0000169\" value=\"");
        this.writer.write(Double.toString(searchParameters.getPrecursorAccuracy()));
        this.writer.write("\" name=\"search tolerance minus value\" />");
        --this.tabCounter;
        this.writer.newLine();
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</ParentTolerance>");
        this.writer.newLine();
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<Threshold>");
        this.writer.newLine();
        ++this.tabCounter;
        boolean targetDecoy = this.identificationParameters.getFastaParameters().isTargetDecoy();
        if (!targetDecoy) {
            this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001494", "no threshold", null));
        } else {
            IdMatchValidationParameters idMatchValidationPreferences = this.identificationParameters.getIdValidationParameters();
            this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001364", "peptide sequence-level global FDR", Double.toString(Util.roundDouble(idMatchValidationPreferences.getDefaultPeptideFDR(), 4))));
            this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002350", "PSM-level global FDR", Double.toString(Util.roundDouble(idMatchValidationPreferences.getDefaultPsmFDR(), 4))));
            ModificationLocalizationParameters ptmScoringPreferences = this.identificationParameters.getModificationLocalizationParameters();
            if (ptmScoringPreferences.isProbabilisticScoreCalculation() && ptmScoringPreferences.getSelectedProbabilisticScore() == ModificationLocalizationScore.PhosphoRS) {
                this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002567", "phosphoRS score threshold", Double.toString(ptmScoringPreferences.getProbabilisticScoreThreshold())));
            }
            this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002557", "D-Score threshold", Double.toString(this.identificationParameters.getModificationLocalizationParameters().getDScoreThreshold())));
        }
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</Threshold>");
        this.writer.newLine();
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</SpectrumIdentificationProtocol>");
        this.writer.newLine();
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<ProteinDetectionProtocol analysisSoftware_ref=\"ID_software\" id=\"PeptideShaker_1\">");
        this.writer.newLine();
        ++this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<Threshold>");
        this.writer.newLine();
        ++this.tabCounter;
        if (!targetDecoy) {
            this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001494", "no threshold", null));
        } else {
            PSMaps psMaps = new PSMaps();
            psMaps = (PSMaps)this.identification.getUrParam(psMaps);
            TargetDecoyMap proteinMap = psMaps.getProteinMap();
            TargetDecoyResults proteinTargetDecoyResults = proteinMap.getTargetDecoyResults();
            double threshold = proteinTargetDecoyResults.getUserInput() / 100.0;
            int thresholdType = proteinTargetDecoyResults.getInputType();
            if (thresholdType == 0) {
                this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002461", "protein group-level global confidence", Double.toString(Util.roundDouble(threshold, 4))));
            } else if (proteinTargetDecoyResults.getInputType() == 1) {
                this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002369", "protein group-level global FDR", Double.toString(Util.roundDouble(threshold, 4))));
            } else if (proteinTargetDecoyResults.getInputType() == 2) {
                this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002460", "protein group-level global FNR", Double.toString(Util.roundDouble(threshold, 4))));
            }
        }
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</Threshold>");
        this.writer.newLine();
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</ProteinDetectionProtocol>");
        this.writer.newLine();
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</AnalysisProtocolCollection>");
        this.writer.newLine();
    }

    private void writeDataCollection() {
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<DataCollection>");
        this.writer.newLine();
        ++this.tabCounter;
        this.writeInputFileDetails();
        this.writeDataAnalysis();
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</DataCollection>");
        this.writer.newLine();
    }

    private void writeDataAnalysis() {
        SpectrumMatch spectrumMatch;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<AnalysisData>");
        this.writer.newLine();
        ++this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<SpectrumIdentificationList id=\"SIL_1\">");
        this.writer.newLine();
        ++this.tabCounter;
        this.writeFragmentationTable();
        int psmCount = 0;
        SpectrumMatchesIterator psmIterator = this.identification.getSpectrumMatchesIterator(this.waitingHandler);
        while ((spectrumMatch = psmIterator.next()) != null) {
            this.writeSpectrumIdentificationResult(spectrumMatch.getSpectrumFile(), spectrumMatch.getSpectrumTitle(), ++psmCount);
            this.waitingHandler.increasePrimaryProgressCounter();
            if (!this.waitingHandler.isRunCanceled()) continue;
        }
        if (this.waitingHandler.isRunCanceled()) {
            return;
        }
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</SpectrumIdentificationList>");
        this.writer.newLine();
        this.writeProteinDetectionList();
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</AnalysisData>");
        this.writer.newLine();
    }

    private void writeProteinDetectionList() {
        ProteinMatch proteinMatch;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<ProteinDetectionList id=\"Protein_groups\">");
        this.writer.newLine();
        ++this.tabCounter;
        int groupCpt = 0;
        ProteinMatchesIterator proteinMatchesIterator = this.identification.getProteinMatchesIterator(this.waitingHandler);
        while ((proteinMatch = proteinMatchesIterator.next()) != null) {
            long proteinGroupKey = proteinMatch.getKey();
            String proteinGroupId = "PAG_" + groupCpt++;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("<ProteinAmbiguityGroup id=\"");
            this.writer.write(proteinGroupId);
            this.writer.write("\">");
            this.writer.newLine();
            ++this.tabCounter;
            PSParameter psParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy);
            String[] accessions = proteinMatch.getAccessions();
            String mainAccession = proteinMatch.getLeadingAccession();
            for (int j = 0; j < accessions.length; ++j) {
                PeptideMatch peptideMatch;
                String accession = accessions[j];
                this.writer.write(this.getCurrentTabSpace());
                this.writer.write("<ProteinDetectionHypothesis id=\"");
                this.writer.write(proteinGroupId);
                this.writer.write("_");
                this.writer.write(Integer.toString(j + 1));
                this.writer.write("\" dBSequence_ref=\"");
                this.writer.write(accession);
                this.writer.write("\" passThreshold=\"");
                this.writer.write(Boolean.toString(psParameter.getMatchValidationLevel().isValidated()));
                this.writer.write("\">");
                this.writer.newLine();
                ++this.tabCounter;
                long[] peptideMatches = proteinMatch.getPeptideMatchesKeys();
                PeptideMatchesIterator peptideMatchesIterator = this.identification.getPeptideMatchesIterator(peptideMatches, this.waitingHandler);
                while ((peptideMatch = peptideMatchesIterator.next()) != null) {
                    int[] indexes;
                    long peptideKey = peptideMatch.getKey();
                    Peptide peptide = peptideMatch.getPeptide();
                    for (int index : indexes = peptide.getProteinMapping().get(accession)) {
                        String pepEvidenceKey = MzIdentMLExport.getPeptideEvidenceKey(accession, index, peptideKey);
                        String peptideEvidenceId = this.pepEvidenceIds.get(pepEvidenceKey);
                        if (peptideEvidenceId != null) {
                            this.writer.write(this.getCurrentTabSpace());
                            this.writer.write("<PeptideHypothesis peptideEvidence_ref=\"");
                            this.writer.write(peptideEvidenceId);
                            this.writer.write("\">");
                            this.writer.newLine();
                            ++this.tabCounter;
                            for (long spectrumKey : peptideMatch.getSpectrumMatchesKeys()) {
                                this.writer.write(this.getCurrentTabSpace());
                                this.writer.write("<SpectrumIdentificationItemRef spectrumIdentificationItem_ref=\"");
                                this.writer.write(this.spectrumIds.get(spectrumKey));
                                this.writer.write("\"/>");
                                this.writer.newLine();
                            }
                            --this.tabCounter;
                        } else {
                            throw new IllegalArgumentException("No peptide evidence id found for key '" + pepEvidenceKey + "'.");
                        }
                        this.writer.write(this.getCurrentTabSpace());
                        this.writer.write("</PeptideHypothesis>");
                        this.writer.newLine();
                    }
                }
                if (accession.equalsIgnoreCase(mainAccession)) {
                    this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002403", "group representative", null));
                }
                this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002401", "leading protein", null));
                if (accession.equalsIgnoreCase(mainAccession)) {
                    double validatedCoverage = this.identificationFeaturesGenerator.getValidatedSequenceCoverage(proteinGroupKey);
                    this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001093", "sequence coverage", Double.toString(Util.roundDouble(validatedCoverage, 4))));
                }
                --this.tabCounter;
                this.writer.write(this.getCurrentTabSpace());
                this.writer.write("</ProteinDetectionHypothesis>");
                this.writer.newLine();
            }
            this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002470", "PeptideShaker protein group score", Double.toString(Util.roundDouble(psParameter.getTransformedScore(), 4))));
            this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002471", "PeptideShaker protein group confidence", Double.toString(Util.roundDouble(psParameter.getConfidence(), 4))));
            this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002542", "PeptideShaker protein confidence type", psParameter.getMatchValidationLevel().getName()));
            this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002415", "protein group passes threshold", Boolean.toString(psParameter.getMatchValidationLevel().isValidated())));
            --this.tabCounter;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("</ProteinAmbiguityGroup>");
            this.writer.newLine();
            this.waitingHandler.increasePrimaryProgressCounter();
            if (!this.waitingHandler.isRunCanceled()) continue;
            break;
        }
        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002404", "count of identified proteins", Integer.toString(this.identificationFeaturesGenerator.getNValidatedProteins())));
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</ProteinDetectionList>");
        this.writer.newLine();
    }

    private void writeSpectrumIdentificationResult(String spectrumFile, String spectrumTitle, int spectrumMatchIndex) {
        long spectrumKey = SpectrumMatch.getKey(spectrumFile, spectrumTitle);
        SpectrumMatch spectrumMatch = (SpectrumMatch)this.identification.retrieveObject(spectrumKey);
        PeptideAssumption bestPeptideAssumption = spectrumMatch.getBestPeptideAssumption();
        if (bestPeptideAssumption != null) {
            String spectrumIdentificationResultItemKey = "SIR_" + spectrumMatchIndex;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("<SpectrumIdentificationResult spectraData_ref=\"");
            this.writer.write(spectrumFile);
            this.writer.write("\" spectrumID=\"index=");
            this.writer.write(this.spectrumTitleToIndexMap.get(spectrumFile).get(spectrumTitle).toString());
            this.writer.write("\" id=\"");
            this.writer.write(spectrumIdentificationResultItemKey);
            this.writer.write("\">");
            this.writer.newLine();
            ++this.tabCounter;
            PSParameter psmParameter = (PSParameter)spectrumMatch.getUrParam(PSParameter.dummy);
            int rank = 1;
            String spectrumIdentificationItemKey = "SII_" + spectrumMatchIndex + "_" + rank;
            this.spectrumIds.put(spectrumKey, spectrumIdentificationItemKey);
            long peptideMatchKey = bestPeptideAssumption.getPeptide().getMatchingKey(this.identificationParameters.getSequenceMatchingParameters());
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("<SpectrumIdentificationItem passThreshold=\"");
            this.writer.write(Boolean.toString(psmParameter.getMatchValidationLevel().isValidated()));
            this.writer.write("\" rank=\"");
            this.writer.write(Integer.toString(rank));
            this.writer.write("\" peptide_ref=\"");
            this.writer.write(Long.toString(peptideMatchKey));
            this.writer.write("\" calculatedMassToCharge=\"");
            this.writer.write(Double.toString(bestPeptideAssumption.getTheoreticMz()));
            this.writer.write("\" experimentalMassToCharge=\"");
            this.writer.write(Double.toString(this.spectrumProvider.getPrecursorMz(spectrumFile, spectrumTitle)));
            this.writer.write("\" chargeState=\"");
            this.writer.write(Integer.toString(bestPeptideAssumption.getIdentificationCharge()));
            this.writer.write("\" id=\"");
            this.writer.write(spectrumIdentificationItemKey);
            this.writer.write("\">");
            this.writer.newLine();
            ++this.tabCounter;
            TreeMap<String, int[]> proteinMapping = bestPeptideAssumption.getPeptide().getProteinMapping();
            String peptideSequence = bestPeptideAssumption.getPeptide().getSequence();
            for (Map.Entry<String, int[]> entry : proteinMapping.entrySet()) {
                int[] indexes;
                String accession = entry.getKey();
                for (int n : indexes = entry.getValue()) {
                    String pepEvidenceKey = MzIdentMLExport.getPeptideEvidenceKey(accession, n, peptideMatchKey);
                    String peptideEvidenceId = this.pepEvidenceIds.get(pepEvidenceKey);
                    this.writer.write(this.getCurrentTabSpace());
                    this.writer.write("<PeptideEvidenceRef peptideEvidence_ref=\"");
                    this.writer.write(peptideEvidenceId);
                    this.writer.write("\"/>");
                    this.writer.newLine();
                }
            }
            AnnotationParameters annotationParameters = this.identificationParameters.getAnnotationParameters();
            Spectrum spectrum = this.spectrumProvider.getSpectrum(spectrumFile, spectrumTitle);
            ModificationParameters modificationParameters = this.identificationParameters.getSearchParameters().getModificationParameters();
            SequenceMatchingParameters modificationSequenceMatchingParameters = this.identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
            SpecificAnnotationParameters specificAnnotationParameters = annotationParameters.getSpecificAnnotationParameters(spectrumFile, spectrumTitle, bestPeptideAssumption, modificationParameters, this.sequenceProvider, modificationSequenceMatchingParameters, this.peptideSpectrumAnnotator);
            IonMatch[] ionMatchArray = this.peptideSpectrumAnnotator.getSpectrumAnnotation(annotationParameters, specificAnnotationParameters, spectrumFile, spectrumTitle, spectrum, bestPeptideAssumption.getPeptide(), modificationParameters, this.sequenceProvider, modificationSequenceMatchingParameters);
            HashMap allFragmentIons = new HashMap();
            for (IonMatch ionMatch : ionMatchArray) {
                if (ionMatch.ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION && ionMatch.ion.getType() != Ion.IonType.IMMONIUM_ION && ionMatch.ion.getType() != Ion.IonType.PRECURSOR_ION && ionMatch.ion.getType() != Ion.IonType.REPORTER_ION && ionMatch.ion.getType() != Ion.IonType.RELATED_ION) continue;
                CvTerm fragmentIonCvTerm = ionMatch.ion.getPsiMsCvTerm();
                Integer charge = ionMatch.charge;
                boolean neutralLossesTestPassed = true;
                if (ionMatch.ion.hasNeutralLosses()) {
                    boolean bl = neutralLossesTestPassed = ionMatch.ion.getNeutralLosses().length <= this.maxNeutralLosses;
                }
                if (fragmentIonCvTerm == null || !neutralLossesTestPassed) continue;
                String fragmentIonName = ionMatch.ion.getName();
                if (!allFragmentIons.containsKey(fragmentIonName)) {
                    allFragmentIons.put(fragmentIonName, new HashMap(1));
                }
                if (!((HashMap)allFragmentIons.get(fragmentIonName)).containsKey(charge)) {
                    ((HashMap)allFragmentIons.get(fragmentIonName)).put(charge, new ArrayList(1));
                }
                ((ArrayList)((HashMap)allFragmentIons.get(fragmentIonName)).get(charge)).add(ionMatch);
            }
            if (!allFragmentIons.isEmpty()) {
                this.writer.write(this.getCurrentTabSpace());
                this.writer.write("<Fragmentation>");
                this.writer.newLine();
                ++this.tabCounter;
                for (String fragmentType : allFragmentIons.keySet()) {
                    for (Integer fragmentCharge : ((HashMap)allFragmentIons.get(fragmentType)).keySet()) {
                        ArrayList ionMatches = (ArrayList)((HashMap)allFragmentIons.get(fragmentType)).get(fragmentCharge);
                        Ion currentIon = ((IonMatch)ionMatches.get((int)0)).ion;
                        CvTerm fragmentIonCvTerm = currentIon.getPsiMsCvTerm();
                        StringBuilder indexes = new StringBuilder();
                        StringBuilder mzValues = new StringBuilder();
                        StringBuilder intensityValues = new StringBuilder();
                        StringBuilder errorValues = new StringBuilder();
                        for (IonMatch ionMatch : ionMatches) {
                            if (ionMatch.ion instanceof PeptideFragmentIon) {
                                indexes.append(((PeptideFragmentIon)ionMatch.ion).getNumber()).append(' ');
                            } else if (ionMatch.ion instanceof ImmoniumIon) {
                                char residue = ((ImmoniumIon)ionMatch.ion).aa;
                                char[] peptideAsArray = peptideSequence.toCharArray();
                                for (int i = 0; i < peptideAsArray.length; ++i) {
                                    if (peptideAsArray[i] != residue) continue;
                                    indexes.append(i + 1).append(' ');
                                }
                            } else if (ionMatch.ion instanceof ReporterIon || ionMatch.ion instanceof RelatedIon || ionMatch.ion instanceof PrecursorIon) {
                                indexes.append('0');
                            }
                            mzValues.append(ionMatch.peakMz).append(' ');
                            intensityValues.append(ionMatch.peakIntensity).append(' ');
                            errorValues.append(ionMatch.getAbsoluteError()).append(' ');
                        }
                        if (fragmentIonCvTerm == null) continue;
                        this.writer.write(this.getCurrentTabSpace());
                        this.writer.write("<IonType charge=\"");
                        this.writer.write(Integer.toString(fragmentCharge));
                        this.writer.write("\" index=\"");
                        this.writer.write(indexes.toString().trim());
                        this.writer.write("\">");
                        this.writer.newLine();
                        ++this.tabCounter;
                        this.writer.write(this.getCurrentTabSpace());
                        this.writer.write("<FragmentArray measure_ref=\"Measure_MZ\" values=\"");
                        this.writer.write(mzValues.toString().trim());
                        this.writer.write("\"/>");
                        this.writer.newLine();
                        this.writer.write(this.getCurrentTabSpace());
                        this.writer.write("<FragmentArray measure_ref=\"Measure_Int\" values=\"");
                        this.writer.write(intensityValues.toString().trim());
                        this.writer.write("\"/>");
                        this.writer.newLine();
                        this.writer.write(this.getCurrentTabSpace());
                        this.writer.write("<FragmentArray measure_ref=\"Measure_Error\" values=\"");
                        this.writer.write(errorValues.toString().trim());
                        this.writer.write("\"/>");
                        this.writer.newLine();
                        this.writeCvTerm(fragmentIonCvTerm);
                        if (currentIon.getNeutralLosses() != null) {
                            int neutralLossesCount = currentIon.getNeutralLosses().length;
                            if (neutralLossesCount > this.maxNeutralLosses) {
                                throw new IllegalArgumentException("A maximum of " + this.maxNeutralLosses + " neutral losses is supported.");
                            }
                            for (NeutralLoss tempNeutralLoss : currentIon.getNeutralLosses()) {
                                this.writeCvTerm(tempNeutralLoss.getPsiMsCvTerm());
                            }
                        }
                        --this.tabCounter;
                        this.writer.write(this.getCurrentTabSpace());
                        this.writer.write("</IonType>");
                        this.writer.newLine();
                    }
                }
                --this.tabCounter;
                this.writer.write(this.getCurrentTabSpace());
                this.writer.write("</Fragmentation>");
                this.writer.newLine();
            }
            this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002466", "PeptideShaker PSM score", Double.toString(Util.roundDouble(psmParameter.getTransformedScore(), 4))));
            this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002467", "PeptideShaker PSM confidence", Double.toString(Util.roundDouble(psmParameter.getConfidence(), 4))));
            switch (this.mzIdentMLVersion) {
                case v1_1: {
                    break;
                }
                case v1_2: {
                    Object peptide;
                    Peptide peptide2;
                    ModificationLocalizationParameters modificationLocalicationParameters = this.identificationParameters.getModificationLocalizationParameters();
                    PeptideMatch peptideMatch = (PeptideMatch)this.identification.retrieveObject(peptideMatchKey);
                    PSModificationScores psModificationScores = (PSModificationScores)spectrumMatch.getUrParam(PSModificationScores.dummy);
                    if (psModificationScores != null && (peptide2 = bestPeptideAssumption.getPeptide()).getVariableModifications().length > 0) {
                        Set<String> scoredModifications = psModificationScores.getScoredModifications();
                        HashSet<String> hashSet = new HashSet<String>(scoredModifications.size());
                        for (String string : scoredModifications) {
                            Modification modification = this.modificationProvider.getModification(string);
                            if (hashSet.contains(string)) continue;
                            hashSet.add(string);
                            double modMass = modification.getMass();
                            Integer modIndex = this.modIndexMap.get(modMass);
                            if (modIndex == null) {
                                throw new IllegalArgumentException("No index found for modification " + string + " of mass " + modMass + ".");
                            }
                            ModificationScoring modificationScoring = psModificationScores.getModificationScoring(string);
                            if (modificationScoring == null) continue;
                            for (int site = 1; site <= peptideSequence.length(); ++site) {
                                StringBuilder sb;
                                String valid;
                                double score;
                                if (modificationLocalicationParameters.isProbabilisticScoreCalculation() && (score = modificationScoring.getProbabilisticScore(site)) > 0.0) {
                                    valid = "true";
                                    if (score < modificationLocalicationParameters.getProbabilisticScoreThreshold()) {
                                        valid = "false";
                                    }
                                    if (modificationLocalicationParameters.getSelectedProbabilisticScore() == ModificationLocalizationScore.PhosphoRS) {
                                        sb = new StringBuilder();
                                        sb.append(modIndex).append(':').append(score).append(':').append(site).append(':').append(valid);
                                        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001969", "phosphoRS score", sb.toString()));
                                    }
                                }
                                if (!((score = modificationScoring.getDeltaScore(site)) > 0.0)) continue;
                                valid = "true";
                                if (score < this.identificationParameters.getModificationLocalizationParameters().getDScoreThreshold()) {
                                    valid = "false";
                                }
                                sb = new StringBuilder();
                                sb.append(modIndex).append(':').append(score).append(':').append(site).append(':').append(valid);
                                this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002536", "D-Score", sb.toString()));
                            }
                        }
                    }
                    PSParameter peptideParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
                    this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002469", "PeptideShaker peptide confidence", Double.toString(peptideParameter.getConfidence())));
                    this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002468", "PeptideShaker peptide score", Double.toString(peptideParameter.getTransformedScore())));
                    this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002500", "peptide passes threshold", Boolean.toString(peptideParameter.getMatchValidationLevel().isValidated())));
                    this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002520", "peptide group ID", Long.toString(peptideMatchKey)));
                    psModificationScores = (PSModificationScores)peptideMatch.getUrParam(PSModificationScores.dummy);
                    if (psModificationScores == null || ((Peptide)(peptide = peptideMatch.getPeptide())).getVariableModifications().length <= 0) break;
                    Set<String> set = psModificationScores.getScoredModifications();
                    HashSet<String> coveredModifications = new HashSet<String>(set.size());
                    for (String modName : set) {
                        if (coveredModifications.contains(modName)) continue;
                        coveredModifications.add(modName);
                        Modification modification = this.modificationProvider.getModification(modName);
                        double modMass = modification.getMass();
                        Integer modIndex = this.modIndexMap.get(modMass);
                        if (modIndex == null) {
                            throw new IllegalArgumentException("No index found for modification " + modName + " of mass " + modMass + ".");
                        }
                        ModificationScoring modificationScoring = psModificationScores.getModificationScoring(modName);
                        if (modificationScoring == null) continue;
                        for (int site = 1; site <= peptideSequence.length(); ++site) {
                            StringBuilder sb;
                            String valid;
                            double score;
                            if (modificationLocalicationParameters.isProbabilisticScoreCalculation() && (score = modificationScoring.getProbabilisticScore(site)) > 0.0) {
                                valid = "true";
                                if (score < modificationLocalicationParameters.getProbabilisticScoreThreshold()) {
                                    valid = "false";
                                }
                                if (modificationLocalicationParameters.getSelectedProbabilisticScore() == ModificationLocalizationScore.PhosphoRS) {
                                    sb = new StringBuilder();
                                    sb.append(modIndex).append(':').append(score).append(':').append(site).append(':').append(valid);
                                    this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002550", "peptide:phosphoRS score", sb.toString()));
                                }
                            }
                            if (!((score = modificationScoring.getDeltaScore(site)) > 0.0)) continue;
                            valid = "true";
                            if (score < this.identificationParameters.getModificationLocalizationParameters().getDScoreThreshold()) {
                                valid = "false";
                            }
                            sb = new StringBuilder();
                            sb.append(modIndex).append(':').append(score).append(':').append(site).append(':').append(valid);
                            this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002553", "peptide:D-Score", sb.toString()));
                        }
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("mzIdentML version " + this.mzIdentMLVersion.name + " not supported.");
                }
            }
            Double mascotScore = null;
            Double msAmandaScore = null;
            TreeMap<Integer, Double> scores = new TreeMap<Integer, Double>();
            HashMap<Integer, TreeMap<Double, ArrayList<PeptideAssumption>>> assumptions = this.identification.getSpectrumMatch(spectrumKey).getPeptideAssumptionsMap();
            for (Integer n : assumptions.keySet()) {
                TreeMap<Double, ArrayList<PeptideAssumption>> advocateMap = assumptions.get(n);
                for (double eValue : advocateMap.keySet()) {
                    for (PeptideAssumption peptideAssumption : advocateMap.get(eValue)) {
                        Double currentMinEvalue;
                        if (!peptideAssumption.getPeptide().isSameSequenceAndModificationStatus(bestPeptideAssumption.getPeptide(), this.identificationParameters.getSequenceMatchingParameters()) || (currentMinEvalue = (Double)scores.get(n)) != null && !(eValue < currentMinEvalue)) continue;
                        scores.put(n, eValue);
                        if (n.intValue() == Advocate.mascot.getIndex()) {
                            mascotScore = peptideAssumption.getRawScore();
                            continue;
                        }
                        if (n.intValue() != Advocate.msAmanda.getIndex()) continue;
                        msAmandaScore = peptideAssumption.getRawScore();
                    }
                }
            }
            for (Map.Entry entry : scores.entrySet()) {
                int advocate = (Integer)entry.getKey();
                double d = (Double)entry.getValue();
                if (advocate == Advocate.msgf.getIndex()) {
                    this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002052", "MS-GF:SpecEValue", Double.toString(d)));
                    continue;
                }
                if (advocate == Advocate.mascot.getIndex()) {
                    this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001172", "Mascot:expectation value", Double.toString(d)));
                    continue;
                }
                if (advocate == Advocate.omssa.getIndex()) {
                    this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001328", "OMSSA:evalue", Double.toString(d)));
                    continue;
                }
                if (advocate == Advocate.xtandem.getIndex()) {
                    this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001330", "X!Tandem:expect", Double.toString(d)));
                    continue;
                }
                if (advocate == Advocate.comet.getIndex()) {
                    this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002257", "Comet:expectation value", Double.toString(d)));
                    continue;
                }
                if (advocate == Advocate.myriMatch.getIndex()) {
                    this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001589", "MyriMatch:MVH", Double.toString(d)));
                    continue;
                }
                this.writeUserParam(Advocate.getAdvocate(advocate).getName() + " e-value", Double.toString(d));
            }
            if (mascotScore != null) {
                this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001171", "Mascot:score", Double.toString(mascotScore)));
            }
            if (msAmandaScore != null) {
                this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002319", "Amanda:AmandaScore", Double.toString(msAmandaScore)));
            }
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("<cvParam cvRef=\"PSI-MS\" accession=\"MS:1001117\" name=\"theoretical mass\" value=\"");
            this.writer.write(Double.toString(bestPeptideAssumption.getTheoreticMass()));
            this.writer.write("\" unitCvRef=\"UO\" unitAccession=\"UO:0000221\" unitName=\"dalton\"/>");
            this.writer.newLine();
            this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002540", "PeptideShaker PSM confidence type", psmParameter.getMatchValidationLevel().getName()));
            --this.tabCounter;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("</SpectrumIdentificationItem>");
            this.writer.newLine();
            this.writeCvTerm(new CvTerm("PSI-MS", "MS:1000796", "spectrum title", spectrumTitle));
            double precursorRt = this.spectrumProvider.getPrecursorRt(spectrumFile, spectrumTitle);
            if (!Double.isNaN(precursorRt)) {
                this.writer.write(this.getCurrentTabSpace());
                this.writer.write("<cvParam cvRef=\"PSI-MS\" accession=\"MS:1000894\" name=\"retention time\" value=\"");
                this.writer.write(Double.toString(precursorRt));
                this.writer.write("\" unitCvRef=\"UO\" unitAccession=\"UO:0000010\" unitName=\"second\"/>");
                this.writer.newLine();
            }
            --this.tabCounter;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("</SpectrumIdentificationResult>");
            this.writer.newLine();
        }
    }

    private void writeFragmentationTable() {
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<FragmentationTable>");
        this.writer.newLine();
        ++this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<Measure id=\"Measure_MZ\">");
        this.writer.newLine();
        ++this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<cvParam cvRef=\"PSI-MS\" accession=\"MS:1001225\" name=\"product ion m/z\" unitCvRef=\"PSI-MS\" unitAccession=\"MS:1000040\" unitName=\"m/z\" />");
        this.writer.newLine();
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</Measure>");
        this.writer.newLine();
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<Measure id=\"Measure_Int\">");
        this.writer.newLine();
        ++this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<cvParam cvRef=\"PSI-MS\" accession=\"MS:1001226\" name=\"product ion intensity\" unitCvRef=\"PSI-MS\" unitAccession=\"MS:1000131\" unitName=\"number of detector counts\"/>");
        this.writer.newLine();
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</Measure>");
        this.writer.newLine();
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<Measure id=\"Measure_Error\">");
        this.writer.newLine();
        ++this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<cvParam cvRef=\"PSI-MS\" accession=\"MS:1001227\" name=\"product ion m/z error\" unitCvRef=\"PSI-MS\" unitAccession=\"MS:1000040\" unitName=\"m/z\"/>");
        this.writer.newLine();
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</Measure>");
        this.writer.newLine();
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</FragmentationTable>");
        this.writer.newLine();
    }

    private void writeInputFileDetails() {
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<Inputs>");
        this.writer.newLine();
        ++this.tabCounter;
        int sourceFileCounter = 1;
        for (String idFilePath : this.projectDetails.getIdentificationFiles()) {
            File idFile = new File(idFilePath);
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("<SourceFile location=\"");
            this.writer.write(idFile.toURI().toString());
            this.writer.write("\" id=\"SourceFile_");
            this.writer.write(Integer.toString(sourceFileCounter++));
            this.writer.write("\">");
            this.writer.newLine();
            ++this.tabCounter;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("<FileFormat>");
            this.writer.newLine();
            ++this.tabCounter;
            String idFileName = IoUtil.getFileName(idFile);
            HashMap<String, ArrayList<String>> algorithms = this.projectDetails.getIdentificationAlgorithmsForFile(idFileName);
            for (String algorithmName : algorithms.keySet()) {
                Advocate advocate = Advocate.getAdvocate(algorithmName);
                int advocateIndex = advocate.getIndex();
                if (advocateIndex == Advocate.mascot.getIndex()) {
                    this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001199", "Mascot DAT format", null));
                    continue;
                }
                if (advocateIndex == Advocate.xtandem.getIndex()) {
                    this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001401", "X!Tandem xml format", null));
                    continue;
                }
                if (advocateIndex == Advocate.omssa.getIndex()) {
                    this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001400", "OMSSA xml format", null));
                    continue;
                }
                if (advocateIndex == Advocate.msgf.getIndex() || advocateIndex == Advocate.myriMatch.getIndex()) {
                    this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002073", "mzIdentML format", null));
                    continue;
                }
                if (advocateIndex == Advocate.msAmanda.getIndex()) {
                    this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002459", "MS Amanda csv format", null));
                    continue;
                }
                if (advocateIndex == Advocate.comet.getIndex()) {
                    this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001421", "pepXML format", null));
                    continue;
                }
                if (advocateIndex == Advocate.tide.getIndex()) {
                    this.writeCvTerm(new CvTerm("PSI-MS", "MS:1000914", "tab delimited text format", null));
                    continue;
                }
                if (advocateIndex != Advocate.andromeda.getIndex()) continue;
                this.writeCvTerm(new CvTerm("PSI-MS", "MS:1002576", "Andromeda result file", null));
            }
            --this.tabCounter;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("</FileFormat>");
            this.writer.newLine();
            --this.tabCounter;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("</SourceFile>");
            this.writer.newLine();
        }
        File fastaFile = new File(this.projectDetails.getFastaFile());
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<SearchDatabase numDatabaseSequences=\"");
        this.writer.write(Integer.toString(this.fastaSummary.nSequences));
        this.writer.write("\" location=\"");
        this.writer.write(fastaFile.toURI().toString());
        this.writer.write("\" id=\"SearchDB_1\">");
        this.writer.newLine();
        ++this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<FileFormat>");
        this.writer.newLine();
        ++this.tabCounter;
        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001348", "FASTA format", null));
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</FileFormat>");
        this.writer.newLine();
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<DatabaseName>");
        this.writer.newLine();
        ++this.tabCounter;
        this.writeUserParam(fastaFile.getName());
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</DatabaseName>");
        this.writer.newLine();
        this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001073", "database type amino acid", null));
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</SearchDatabase>");
        this.writer.newLine();
        for (String spectrumFileNameWithoutExtension : this.spectrumProvider.getOrderedFileNamesWithoutExtensions()) {
            String spectrumFilePath = this.projectDetails.getSpectrumFilePath(spectrumFileNameWithoutExtension);
            File spectrumFile = new File(spectrumFilePath);
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("<SpectraData location=\"");
            this.writer.write(spectrumFile.toURI().toString());
            this.writer.write("\" id=\"");
            this.writer.write(spectrumFileNameWithoutExtension);
            this.writer.write("\" name=\"");
            this.writer.write(spectrumFile.getName());
            this.writer.write("\">");
            this.writer.newLine();
            ++this.tabCounter;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("<FileFormat>");
            this.writer.newLine();
            ++this.tabCounter;
            this.writeCvTerm(new CvTerm("PSI-MS", "MS:1001062", "Mascot MGF format", null));
            --this.tabCounter;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("</FileFormat>");
            this.writer.newLine();
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("<SpectrumIDFormat>");
            this.writer.newLine();
            ++this.tabCounter;
            this.writeCvTerm(new CvTerm("PSI-MS", "MS:1000774", "multiple peak list nativeID format", null));
            --this.tabCounter;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("</SpectrumIDFormat>");
            this.writer.newLine();
            --this.tabCounter;
            this.writer.write(this.getCurrentTabSpace());
            this.writer.write("</SpectraData>");
            this.writer.newLine();
        }
        --this.tabCounter;
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("</Inputs>");
        this.writer.newLine();
    }

    private void writeMzIdentMLStartTag() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.writer.newLine();
        switch (this.mzIdentMLVersion) {
            case v1_1: {
                this.writer.writeLine("<MzIdentML id=\"PeptideShaker v" + this.peptideShakerVersion + "\" xmlns:xsi=\"https://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://psidev.info/psi/pi/mzIdentML/1.1\" version=\"1.1.0\" creationDate=\"" + df.format(new Date()) + "\">");
                break;
            }
            case v1_2: {
                this.writer.writeLine("<MzIdentML id=\"PeptideShaker v" + this.peptideShakerVersion + "\" xmlns:xsi=\"https://www.w3.org/2001/XMLSchema-instance\"  xmlns=\"http://psidev.info/psi/pi/mzIdentML/1.2\" version=\"1.2.0\" creationDate=\"" + df.format(new Date()) + "\">");
                break;
            }
            default: {
                throw new UnsupportedOperationException("mzIdentML version " + this.mzIdentMLVersion.name + " not supported.");
            }
        }
        ++this.tabCounter;
    }

    private void writeMzIdentMLEndTag() {
        --this.tabCounter;
        this.writer.write("</MzIdentML>");
    }

    private String getCurrentTabSpace() {
        switch (this.tabCounter) {
            case 0: {
                return "";
            }
            case 1: {
                return "\t";
            }
            case 2: {
                return "\t\t";
            }
            case 3: {
                return "\t\t\t";
            }
            case 4: {
                return "\t\t\t\t";
            }
            case 5: {
                return "\t\t\t\t\t";
            }
            case 6: {
                return "\t\t\t\t\t\t";
            }
            case 7: {
                return "\t\t\t\t\t\t\t";
            }
            case 8: {
                return "\t\t\t\t\t\t\t\t";
            }
            case 9: {
                return "\t\t\t\t\t\t\t\t\t";
            }
            case 10: {
                return "\t\t\t\t\t\t\t\t\t\t";
            }
            case 11: {
                return "\t\t\t\t\t\t\t\t\t\t\t";
            }
            case 12: {
                return "\t\t\t\t\t\t\t\t\t\t\t\t";
            }
        }
        StringBuilder sb = new StringBuilder(this.tabCounter);
        for (int i = 0; i < this.tabCounter; ++i) {
            sb.append('\t');
        }
        return sb.toString();
    }

    private void writeCvTerm(CvTerm cvTerm) {
        this.writeCvTerm(cvTerm, true);
    }

    private void writeCvTerm(CvTerm cvTerm, boolean showValue) {
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<cvParam cvRef=\"");
        this.writer.write(StringEscapeUtils.escapeHtml4((String)cvTerm.getOntology()));
        this.writer.write("\" accession=\"");
        this.writer.write(cvTerm.getAccession());
        this.writer.write("\" name=\"");
        this.writer.write(StringEscapeUtils.escapeHtml4((String)cvTerm.getName()));
        this.writer.write("\"");
        this.writeCvTermValue(cvTerm, showValue);
    }

    private void writeCvTermValue(CvTerm cvTerm, boolean showValue) {
        String value = cvTerm.getValue();
        if (showValue && value != null) {
            this.writer.write(" value=\"");
            this.writer.write(StringEscapeUtils.escapeHtml4((String)value));
            this.writer.write("\"/>");
        } else {
            this.writer.write("/>");
        }
        this.writer.newLine();
    }

    private void writeUserParam(String userParamAsString) {
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<userParam name=\"");
        this.writer.write(StringEscapeUtils.escapeHtml4((String)userParamAsString));
        this.writer.write("\"/>");
        this.writer.newLine();
    }

    private void writeUserParam(String name, String value) {
        this.writer.write(this.getCurrentTabSpace());
        this.writer.write("<userParam name=\"");
        this.writer.write(StringEscapeUtils.escapeHtml4((String)name));
        this.writer.write("\" value=\"");
        this.writer.write(StringEscapeUtils.escapeHtml4((String)value));
        this.writer.write("\" />");
        this.writer.newLine();
    }
}

