/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.export.sections;

import com.compomics.util.io.export.ExportFeature;
import com.compomics.util.io.export.ExportWriter;
import com.compomics.util.io.export.features.peptideshaker.PsPtmScoringFeature;
import com.compomics.util.parameters.identification.advanced.ModificationLocalizationParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;

public class PsPtmScoringSection {
    private final EnumSet<PsPtmScoringFeature> ptmScoringFeatures;
    private final boolean indexes;
    private final boolean header;
    private final ExportWriter writer;

    public PsPtmScoringSection(ArrayList<ExportFeature> exportFeatures, boolean indexes, boolean header, ExportWriter writer) {
        this.indexes = indexes;
        this.header = header;
        this.writer = writer;
        this.ptmScoringFeatures = EnumSet.noneOf(PsPtmScoringFeature.class);
        for (ExportFeature exportFeature : exportFeatures) {
            if (exportFeature instanceof PsPtmScoringFeature) {
                this.ptmScoringFeatures.add((PsPtmScoringFeature)exportFeature);
                continue;
            }
            throw new IllegalArgumentException("Impossible to export " + exportFeature.getClass().getName() + " as PTM scoring feature.");
        }
    }

    public void writeSection(ModificationLocalizationParameters ptmScoringPreferences, WaitingHandler waitingHandler) throws IOException {
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        if (this.header) {
            if (this.indexes) {
                this.writer.writeHeaderText("");
                this.writer.addSeparator();
            }
            this.writer.writeHeaderText("Parameter");
            this.writer.addSeparator();
            this.writer.writeHeaderText("Value");
            this.writer.newLine();
        }
        int line = 1;
        for (PsPtmScoringFeature ptmScoringFeature : this.ptmScoringFeatures) {
            if (this.indexes) {
                this.writer.write(Integer.toString(line));
                this.writer.addSeparator();
            }
            this.writer.write(ptmScoringFeature.getTitle());
            this.writer.addSeparator();
            switch (ptmScoringFeature) {
                case probabilitstic_score: {
                    this.writer.write(ptmScoringPreferences.getSelectedProbabilisticScore().getName());
                    break;
                }
                case threshold: {
                    this.writer.write(Double.toString(ptmScoringPreferences.getProbabilisticScoreThreshold()));
                    break;
                }
                case neutral_losses: {
                    if (ptmScoringPreferences.isProbabilisticScoreNeutralLosses()) {
                        this.writer.write("Yes");
                        break;
                    }
                    this.writer.write("No");
                    break;
                }
                default: {
                    this.writer.write("Not implemented");
                }
            }
            this.writer.newLine();
            ++line;
        }
    }
}

