/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.export.sections;

import com.compomics.util.Util;
import com.compomics.util.io.export.ExportFeature;
import com.compomics.util.io.export.ExportWriter;
import com.compomics.util.io.export.features.peptideshaker.PsValidationFeature;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.scoring.PSMaps;
import eu.isas.peptideshaker.scoring.targetdecoy.TargetDecoyMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class PsValidationSection {
    private final ArrayList<PsValidationFeature> validationFeatures;
    private final boolean indexes;
    private final boolean header;
    private final ExportWriter writer;

    public PsValidationSection(ArrayList<ExportFeature> exportFeatures, boolean indexes, boolean header, ExportWriter writer) {
        this.indexes = indexes;
        this.header = header;
        this.writer = writer;
        this.validationFeatures = new ArrayList(exportFeatures.size());
        for (ExportFeature exportFeature : exportFeatures) {
            if (exportFeature instanceof PsValidationFeature) {
                this.validationFeatures.add((PsValidationFeature)exportFeature);
                continue;
            }
            throw new IllegalArgumentException("Impossible to export " + exportFeature.getClass().getName() + " as validation feature.");
        }
        Collections.sort(this.validationFeatures);
    }

    public void writeSection(PSMaps psMaps, IdentificationParameters identificationParameters, WaitingHandler waitingHandler) throws IOException {
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        if (this.header) {
            if (this.indexes) {
                this.writer.writeHeaderText("");
                this.writer.addSeparator();
            }
            this.writer.writeHeaderText("Class");
            this.writer.addSeparator();
            this.writer.writeHeaderText("Parameter");
            this.writer.addSeparator();
            this.writer.writeHeaderText("Value");
            this.writer.newLine();
        }
        int line = 1;
        block23: for (PsValidationFeature validationFeature : this.validationFeatures) {
            switch (validationFeature) {
                case peptide_accuracy: {
                    if (this.indexes) {
                        this.writer.write(Integer.toString(line));
                        this.writer.addSeparator();
                    }
                    this.writer.write("Peptides");
                    this.writer.addSeparator();
                    this.writer.write(validationFeature.getTitle() + " [%]");
                    this.writer.addSeparator();
                    TargetDecoyMap targetDecoyMap = psMaps.getPeptideMap();
                    int nMax = targetDecoyMap.getnMax();
                    double pmin = nMax > 0 ? 0.0 : 100.0 / (double)nMax;
                    this.writer.write(Double.toString(Util.roundDouble(pmin, 2)));
                    this.writer.newLine();
                    ++line;
                    continue block23;
                }
                case peptide_confidence: {
                    if (this.indexes) {
                        this.writer.write(Integer.toString(line));
                        this.writer.addSeparator();
                    }
                    this.writer.write("Peptides");
                    this.writer.addSeparator();
                    this.writer.write(validationFeature.getTitle() + " [%]");
                    this.writer.addSeparator();
                    TargetDecoyMap targetDecoyMap = psMaps.getPeptideMap();
                    double result = targetDecoyMap.getTargetDecoyResults().getConfidenceLimit();
                    this.writer.write(Double.toString(Util.roundDouble(result, 2)));
                    this.writer.newLine();
                    ++line;
                    continue block23;
                }
                case peptide_fdr: {
                    if (this.indexes) {
                        this.writer.write(Integer.toString(line));
                        this.writer.addSeparator();
                    }
                    this.writer.write("Peptides");
                    this.writer.addSeparator();
                    this.writer.write(validationFeature.getTitle() + " [%]");
                    this.writer.addSeparator();
                    TargetDecoyMap targetDecoyMap = psMaps.getPeptideMap();
                    double result = targetDecoyMap.getTargetDecoyResults().getFdrLimit();
                    this.writer.write(Double.toString(Util.roundDouble(result, 2)));
                    this.writer.newLine();
                    ++line;
                    continue block23;
                }
                case peptide_fnr: {
                    if (this.indexes) {
                        this.writer.write(Integer.toString(line));
                        this.writer.addSeparator();
                    }
                    this.writer.write("Peptides");
                    this.writer.addSeparator();
                    this.writer.write(validationFeature.getTitle() + " [%]");
                    this.writer.addSeparator();
                    TargetDecoyMap targetDecoyMap = psMaps.getPeptideMap();
                    double result = targetDecoyMap.getTargetDecoyResults().getFnrLimit();
                    this.writer.write(Double.toString(Util.roundDouble(result, 2)));
                    this.writer.newLine();
                    ++line;
                    continue block23;
                }
                case peptide_pep: {
                    if (this.indexes) {
                        this.writer.write(Integer.toString(line));
                        this.writer.addSeparator();
                    }
                    this.writer.write("Peptides");
                    this.writer.addSeparator();
                    this.writer.write(validationFeature.getTitle() + " [%]");
                    this.writer.addSeparator();
                    TargetDecoyMap targetDecoyMap = psMaps.getPeptideMap();
                    double result = 100.0 - targetDecoyMap.getTargetDecoyResults().getConfidenceLimit();
                    this.writer.write(Double.toString(Util.roundDouble(result, 2)));
                    this.writer.newLine();
                    ++line;
                    continue block23;
                }
                case total_peptide: {
                    if (this.indexes) {
                        this.writer.write(Integer.toString(line));
                        this.writer.addSeparator();
                    }
                    this.writer.write("Peptides");
                    this.writer.addSeparator();
                    this.writer.write(validationFeature.getTitle());
                    this.writer.addSeparator();
                    TargetDecoyMap targetDecoyMap = psMaps.getPeptideMap();
                    double result = targetDecoyMap.getTargetDecoyResults().getnTPTotal();
                    this.writer.write(Double.toString(Util.roundDouble(result, 2)));
                    this.writer.newLine();
                    ++line;
                    continue block23;
                }
                case validated_peptide: {
                    if (this.indexes) {
                        this.writer.write(Integer.toString(line));
                        this.writer.addSeparator();
                    }
                    this.writer.write("Peptides");
                    this.writer.addSeparator();
                    this.writer.write(validationFeature.getTitle());
                    this.writer.addSeparator();
                    TargetDecoyMap targetDecoyMap = psMaps.getPeptideMap();
                    double result = targetDecoyMap.getTargetDecoyResults().getN();
                    this.writer.write(Double.toString(Util.roundDouble(result, 2)));
                    this.writer.newLine();
                    ++line;
                    continue block23;
                }
                case protein_accuracy: {
                    if (this.indexes) {
                        this.writer.write(Integer.toString(line));
                        this.writer.addSeparator();
                    }
                    this.writer.write("Proteins");
                    this.writer.addSeparator();
                    this.writer.write(validationFeature.getTitle() + " [%]");
                    this.writer.addSeparator();
                    TargetDecoyMap targetDecoyMap = psMaps.getProteinMap();
                    int nMax = targetDecoyMap.getnMax();
                    double pmin = nMax > 0 ? 0.0 : 100.0 / (double)nMax;
                    this.writer.write(Double.toString(Util.roundDouble(pmin, 2)));
                    this.writer.newLine();
                    ++line;
                    continue block23;
                }
                case protein_confidence: {
                    if (this.indexes) {
                        this.writer.write(Integer.toString(line));
                        this.writer.addSeparator();
                    }
                    this.writer.write("Proteins");
                    this.writer.addSeparator();
                    this.writer.write(validationFeature.getTitle() + " [%]");
                    this.writer.addSeparator();
                    TargetDecoyMap targetDecoyMap = psMaps.getProteinMap();
                    double result = targetDecoyMap.getTargetDecoyResults().getConfidenceLimit();
                    this.writer.write(Double.toString(Util.roundDouble(result, 2)));
                    this.writer.newLine();
                    ++line;
                    continue block23;
                }
                case protein_fdr: {
                    if (this.indexes) {
                        this.writer.write(Integer.toString(line));
                        this.writer.addSeparator();
                    }
                    this.writer.write("Proteins");
                    this.writer.addSeparator();
                    this.writer.write(validationFeature.getTitle() + " [%]");
                    this.writer.addSeparator();
                    TargetDecoyMap targetDecoyMap = psMaps.getProteinMap();
                    double result = targetDecoyMap.getTargetDecoyResults().getFdrLimit();
                    this.writer.write(Double.toString(Util.roundDouble(result, 2)));
                    this.writer.newLine();
                    ++line;
                    continue block23;
                }
                case protein_fnr: {
                    if (this.indexes) {
                        this.writer.write(Integer.toString(line));
                        this.writer.addSeparator();
                    }
                    this.writer.write("Proteins");
                    this.writer.addSeparator();
                    this.writer.write(validationFeature.getTitle() + " [%]");
                    this.writer.addSeparator();
                    TargetDecoyMap targetDecoyMap = psMaps.getProteinMap();
                    double result = targetDecoyMap.getTargetDecoyResults().getFnrLimit();
                    this.writer.write(Double.toString(Util.roundDouble(result, 2)));
                    this.writer.newLine();
                    ++line;
                    continue block23;
                }
                case protein_pep: {
                    if (this.indexes) {
                        this.writer.write(Integer.toString(line));
                        this.writer.addSeparator();
                    }
                    this.writer.write("Proteins");
                    this.writer.addSeparator();
                    this.writer.write(validationFeature.getTitle() + " [%]");
                    this.writer.addSeparator();
                    TargetDecoyMap targetDecoyMap = psMaps.getProteinMap();
                    double result = targetDecoyMap.getTargetDecoyResults().getConfidenceLimit();
                    this.writer.write(Double.toString(Util.roundDouble(result, 2)));
                    this.writer.newLine();
                    ++line;
                    continue block23;
                }
                case total_protein: {
                    if (this.indexes) {
                        this.writer.write(Integer.toString(line));
                        this.writer.addSeparator();
                    }
                    this.writer.write("Proteins");
                    this.writer.addSeparator();
                    this.writer.write(validationFeature.getTitle());
                    this.writer.addSeparator();
                    TargetDecoyMap targetDecoyMap = psMaps.getProteinMap();
                    double result = targetDecoyMap.getTargetDecoyResults().getnTPTotal();
                    this.writer.write(Double.toString(Util.roundDouble(result, 2)));
                    this.writer.newLine();
                    ++line;
                    continue block23;
                }
                case validated_protein: {
                    if (this.indexes) {
                        this.writer.write(Integer.toString(line));
                        this.writer.addSeparator();
                    }
                    this.writer.write("Proteins");
                    this.writer.addSeparator();
                    this.writer.write(validationFeature.getTitle());
                    this.writer.addSeparator();
                    TargetDecoyMap targetDecoyMap = psMaps.getProteinMap();
                    double result = targetDecoyMap.getTargetDecoyResults().getN();
                    this.writer.write(Double.toString(Util.roundDouble(result, 2)));
                    this.writer.newLine();
                    ++line;
                    continue block23;
                }
                case psm_accuracy: {
                    if (this.indexes) {
                        this.writer.write(Integer.toString(line));
                        this.writer.addSeparator();
                    }
                    this.writer.write("PSMs");
                    this.writer.addSeparator();
                    this.writer.write(validationFeature.getTitle() + " [%]");
                    this.writer.addSeparator();
                    TargetDecoyMap targetDecoyMap = psMaps.getPsmMap();
                    int nMax = targetDecoyMap.getnMax();
                    double pmin = nMax > 0 ? 0.0 : 100.0 / (double)nMax;
                    this.writer.write(Double.toString(Util.roundDouble(pmin, 2)));
                    this.writer.newLine();
                    ++line;
                    continue block23;
                }
                case psm_confidence: {
                    if (this.indexes) {
                        this.writer.write(Integer.toString(line));
                        this.writer.addSeparator();
                    }
                    this.writer.write("PSMs");
                    this.writer.addSeparator();
                    this.writer.write(validationFeature.getTitle() + " [%]");
                    this.writer.addSeparator();
                    TargetDecoyMap targetDecoyMap = psMaps.getPsmMap();
                    double result = targetDecoyMap.getTargetDecoyResults().getConfidenceLimit();
                    this.writer.write(Double.toString(Util.roundDouble(result, 2)));
                    this.writer.newLine();
                    ++line;
                    continue block23;
                }
                case psm_fdr: {
                    if (this.indexes) {
                        this.writer.write(Integer.toString(line));
                        this.writer.addSeparator();
                    }
                    this.writer.write("PSMs");
                    this.writer.addSeparator();
                    this.writer.write(validationFeature.getTitle() + " [%]");
                    this.writer.addSeparator();
                    TargetDecoyMap targetDecoyMap = psMaps.getPsmMap();
                    double result = targetDecoyMap.getTargetDecoyResults().getFdrLimit();
                    this.writer.write(Double.toString(Util.roundDouble(result, 2)));
                    this.writer.newLine();
                    ++line;
                    continue block23;
                }
                case psm_fnr: {
                    if (this.indexes) {
                        this.writer.write(Integer.toString(line));
                        this.writer.addSeparator();
                    }
                    this.writer.write("PSMs");
                    this.writer.addSeparator();
                    TargetDecoyMap targetDecoyMap = psMaps.getPsmMap();
                    double result = targetDecoyMap.getTargetDecoyResults().getFnrLimit();
                    this.writer.write(Double.toString(Util.roundDouble(result, 2)));
                    this.writer.newLine();
                    ++line;
                    continue block23;
                }
                case psm_pep: {
                    if (this.indexes) {
                        this.writer.write(Integer.toString(line));
                        this.writer.addSeparator();
                    }
                    this.writer.write("PSMs");
                    this.writer.addSeparator();
                    this.writer.write(validationFeature.getTitle() + " [%]");
                    this.writer.addSeparator();
                    TargetDecoyMap targetDecoyMap = psMaps.getPsmMap();
                    double result = 100.0 - targetDecoyMap.getTargetDecoyResults().getConfidenceLimit();
                    this.writer.write(Double.toString(Util.roundDouble(result, 2)));
                    this.writer.newLine();
                    ++line;
                    continue block23;
                }
                case total_psm: {
                    if (this.indexes) {
                        this.writer.write(Integer.toString(line));
                        this.writer.addSeparator();
                    }
                    this.writer.write("PSMs");
                    this.writer.addSeparator();
                    this.writer.write(validationFeature.getTitle());
                    this.writer.addSeparator();
                    TargetDecoyMap targetDecoyMap = psMaps.getPsmMap();
                    double result = targetDecoyMap.getTargetDecoyResults().getnTPTotal();
                    this.writer.write(Double.toString(Util.roundDouble(result, 2)));
                    this.writer.newLine();
                    ++line;
                    continue block23;
                }
                case validated_psm: {
                    if (this.indexes) {
                        this.writer.write(Integer.toString(line));
                        this.writer.addSeparator();
                    }
                    this.writer.write("PSMs");
                    this.writer.addSeparator();
                    this.writer.write(validationFeature.getTitle());
                    this.writer.addSeparator();
                    TargetDecoyMap targetDecoyMap = psMaps.getPsmMap();
                    double result = targetDecoyMap.getTargetDecoyResults().getN();
                    this.writer.write(Double.toString(Util.roundDouble(result, 2)));
                    this.writer.newLine();
                    ++line;
                    continue block23;
                }
            }
            this.writer.write("Not implemented");
        }
    }
}

