/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.fileimport;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.filtering.PeptideAssumptionFilter;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.spectrum_assumptions.TagAssumption;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.scoring.maps.InputMap;
import eu.isas.peptideshaker.scoring.psm_scoring.BestMatchSelection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class PsmFirstHitRunnable
implements Runnable {
    private final IdentificationParameters identificationParameters;
    private final SequenceProvider sequenceProvider;
    private final SpectrumProvider spectrumProvider;
    private final InputMap inputMap;
    private final PeptideSpectrumAnnotator peptideSpectrumAnnotator = new PeptideSpectrumAnnotator();
    private final BestMatchSelection bestMatchSelection;
    private final ConcurrentLinkedQueue<SpectrumMatch> spectrumMatchQueue;
    private int psmsRejected = 0;
    private int proteinIssue = 0;
    private int peptideIssue = 0;
    private int precursorIssue = 0;
    private int nRetained = 0;
    private int missingProteins = 0;
    private double maxPeptideErrorPpm = 0.0;
    private double maxPeptideErrorDa = 0.0;
    private double maxTagErrorPpm = 0.0;
    private double maxTagErrorDa = 0.0;
    private final HashSet<Integer> charges = new HashSet();
    private final WaitingHandler waitingHandler;
    private final ExceptionHandler exceptionHandler;

    public PsmFirstHitRunnable(ConcurrentLinkedQueue<SpectrumMatch> spectrumMatchQueue, IdentificationParameters identificationParameters, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, InputMap inputMap, HashMap<String, Integer> proteinCount, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) {
        this.spectrumMatchQueue = spectrumMatchQueue;
        this.identificationParameters = identificationParameters;
        this.sequenceProvider = sequenceProvider;
        this.spectrumProvider = spectrumProvider;
        this.inputMap = inputMap;
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        this.bestMatchSelection = new BestMatchSelection(proteinCount, sequenceProvider, spectrumProvider, identificationParameters, this.peptideSpectrumAnnotator);
    }

    @Override
    public void run() {
        try {
            SpectrumMatch spectrumMatch;
            while ((spectrumMatch = this.spectrumMatchQueue.poll()) != null) {
                this.processPsm(spectrumMatch);
                if (this.waitingHandler.isRunCanceled()) {
                    return;
                }
                this.waitingHandler.increaseSecondaryProgressCounter();
            }
        }
        catch (Exception e) {
            this.waitingHandler.setRunCanceled();
            this.exceptionHandler.catchException(e);
        }
    }

    private void processPsm(SpectrumMatch spectrumMatch) {
        String spectrumFile = spectrumMatch.getSpectrumFile();
        String spectrumTitle = spectrumMatch.getSpectrumTitle();
        PeptideAssumptionFilter peptideAssumptionFilter = this.identificationParameters.getPeptideAssumptionFilter();
        SequenceMatchingParameters sequenceMatchingPreferences = this.identificationParameters.getSequenceMatchingParameters();
        SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
        HashMap<Integer, TreeMap<Double, ArrayList<PeptideAssumption>>> peptideAssumptions = spectrumMatch.getPeptideAssumptionsMap();
        for (Map.Entry<Integer, TreeMap<Double, ArrayList<PeptideAssumption>>> entry : peptideAssumptions.entrySet()) {
            int advocateId = entry.getKey();
            TreeMap<Double, ArrayList<PeptideAssumption>> assumptionsForAdvocate = entry.getValue();
            PeptideAssumption firstPeptideHit = null;
            PeptideAssumption firstPeptideHitNoProtein = null;
            TagAssumption firstTagHit = null;
            if (assumptionsForAdvocate.isEmpty()) continue;
            for (Map.Entry<Double, ArrayList<PeptideAssumption>> entry1 : assumptionsForAdvocate.entrySet()) {
                ArrayList<PeptideAssumption> firstHits = new ArrayList<PeptideAssumption>(1);
                ArrayList<PeptideAssumption> firstHitsNoProteins = new ArrayList<PeptideAssumption>(1);
                for (PeptideAssumption peptideAssumption : entry1.getValue()) {
                    Peptide peptide = peptideAssumption.getPeptide();
                    boolean filterPassed = true;
                    if (!peptideAssumptionFilter.validatePeptide(peptide, sequenceMatchingPreferences, searchParameters.getDigestionParameters())) {
                        filterPassed = false;
                        ++this.peptideIssue;
                    } else if (!peptideAssumptionFilter.validatePrecursor(peptideAssumption, spectrumFile, spectrumTitle, this.spectrumProvider, searchParameters)) {
                        filterPassed = false;
                        ++this.precursorIssue;
                    } else if (!peptideAssumptionFilter.validateProteins(peptide, sequenceMatchingPreferences, this.sequenceProvider)) {
                        filterPassed = false;
                        ++this.proteinIssue;
                    } else if (peptide.getProteinMapping().isEmpty()) {
                        ++this.missingProteins;
                        filterPassed = false;
                        if (firstPeptideHitNoProtein != null) {
                            firstHitsNoProteins.add(peptideAssumption);
                        }
                    }
                    if (!filterPassed) continue;
                    firstHits.add(peptideAssumption);
                }
                if (!firstHits.isEmpty()) {
                    firstPeptideHit = this.bestMatchSelection.getBestMatch(spectrumFile, spectrumTitle, firstHits, true);
                }
                if (firstPeptideHit != null) {
                    this.inputMap.addEntry(advocateId, spectrumFile, firstPeptideHit.getScore(), PeptideUtils.isDecoy(firstPeptideHit.getPeptide(), this.sequenceProvider));
                    ++this.nRetained;
                    break;
                }
                if (firstHitsNoProteins.isEmpty()) continue;
                firstPeptideHit = this.bestMatchSelection.getBestMatch(spectrumFile, spectrumTitle, firstHits, true);
            }
            if (firstPeptideHit != null) {
                this.savePeptidesMassErrorsAndCharges(spectrumFile, spectrumTitle, firstPeptideHit);
            } else if (firstPeptideHitNoProtein != null) {
                this.savePeptidesMassErrorsAndCharges(spectrumFile, spectrumTitle, firstPeptideHitNoProtein);
            } else {
                TreeMap<Double, ArrayList<TagAssumption>> tagsForAdvocate = spectrumMatch.getAllTagAssumptions(advocateId);
                if (tagsForAdvocate != null) {
                    firstTagHit = (TagAssumption)tagsForAdvocate.keySet().stream().sorted().flatMap(score -> ((ArrayList)tagsForAdvocate.get(score)).stream()).findFirst().get();
                    this.checkTagMassErrorsAndCharge(spectrumFile, spectrumTitle, firstTagHit);
                }
            }
            if (firstPeptideHit != null || firstPeptideHitNoProtein != null || firstTagHit != null) continue;
            ++this.psmsRejected;
        }
    }

    private void savePeptidesMassErrorsAndCharges(String spectrumFile, String spectrumTitle, PeptideAssumption peptideAssumption) {
        SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
        double precursorMz = this.spectrumProvider.getPrecursorMz(spectrumFile, spectrumTitle);
        this.maxPeptideErrorPpm = Math.max(this.maxPeptideErrorPpm, Math.abs(peptideAssumption.getDeltaMz(precursorMz, true, searchParameters.getMinIsotopicCorrection(), searchParameters.getMaxIsotopicCorrection())));
        this.maxPeptideErrorDa = Math.max(this.maxPeptideErrorDa, Math.abs(peptideAssumption.getDeltaMz(precursorMz, false, searchParameters.getMinIsotopicCorrection(), searchParameters.getMaxIsotopicCorrection())));
        this.charges.add(peptideAssumption.getIdentificationCharge());
    }

    private void checkTagMassErrorsAndCharge(String spectrumFile, String spectrumTitle, TagAssumption tagAssumption) {
        SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
        double precursorMz = this.spectrumProvider.getPrecursorMz(spectrumFile, spectrumTitle);
        this.maxTagErrorPpm = Math.max(this.maxTagErrorPpm, Math.abs(tagAssumption.getDeltaMz(precursorMz, true, searchParameters.getMinIsotopicCorrection(), searchParameters.getMaxIsotopicCorrection())));
        this.maxTagErrorDa = Math.max(this.maxTagErrorDa, Math.abs(tagAssumption.getDeltaMz(precursorMz, false, searchParameters.getMinIsotopicCorrection(), searchParameters.getMaxIsotopicCorrection())));
        this.charges.add(tagAssumption.getIdentificationCharge());
    }

    public HashSet<Integer> getCharges() {
        return this.charges;
    }

    public double getMaxPeptideErrorPpm() {
        return this.maxPeptideErrorPpm;
    }

    public double getMaxPeptideErrorDa() {
        return this.maxPeptideErrorDa;
    }

    public double getMaxTagErrorPpm() {
        return this.maxTagErrorPpm;
    }

    public double getMaxTagErrorDa() {
        return this.maxTagErrorDa;
    }

    public int getPsmsRejected() {
        return this.psmsRejected;
    }

    public int getProteinIssue() {
        return this.proteinIssue;
    }

    public int getPeptideIssue() {
        return this.peptideIssue;
    }

    public int getPrecursorIssue() {
        return this.precursorIssue;
    }

    public int getMissingProteins() {
        return this.missingProteins;
    }

    public int getnRetained() {
        return this.nRetained;
    }
}

