/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.followup;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidPattern;
import com.compomics.util.experiment.biology.atoms.Atom;
import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.SpectrumMatchesIterator;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.export.xml.SimpleXmlWriter;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.pride.CvTerm;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;

public class PepXmlExport {
    private final ModificationFactory modificationFactory = ModificationFactory.getInstance();

    public void writePepXmlFile(Identification identification, IdentificationParameters identificationParameters, SpectrumProvider spectrumProvider, File destinationFile, String peptideShakerVersion, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) throws IOException {
        if (waitingHandler != null) {
            waitingHandler.setWaitingText("Exporting PSMs. Please Wait...");
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        try (SimpleXmlWriter sw = new SimpleXmlWriter(new BufferedWriter(new FileWriter(destinationFile)));){
            this.writeHeader(sw);
            this.writeMsmsPipelineAnalysis(sw, peptideShakerVersion, destinationFile, identification, spectrumProvider, identificationParameters, waitingHandler);
        }
    }

    private void writeHeader(SimpleXmlWriter sw) throws IOException {
        sw.writeLine("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    private void writeMsmsPipelineAnalysis(SimpleXmlWriter sw, String peptideShakerVersion, File destinationFile, Identification identification, SpectrumProvider spectrumProvider, IdentificationParameters identificationParameters, WaitingHandler waitingHandler) throws IOException {
        sw.writeLine("<msms_pipeline_analysis xmlns=\"https://regis-web.systemsbiology.net/pepXML\" xmlns:xsi=\"https://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://sashimi.sourceforge.net/schema_revision/pepXML/pepXML_v117.xsd\" summary_xml=\"" + destinationFile.getAbsolutePath() + "\">");
        this.writeAnalysisSummary(sw, peptideShakerVersion);
        this.writeMsmsRunSummary(sw, identification, spectrumProvider, identificationParameters, waitingHandler);
        sw.writeLineDecreasedIndent("</msms_pipeline_analysis>");
    }

    private void writeAnalysisSummary(SimpleXmlWriter sw, String peptideShakerVersion) throws IOException {
        sw.writeLineIncreasedIndent("<analysis_summary>");
        sw.writeLineIncreasedIndent("<analysis>PeptideShaker</analysis>");
        sw.writeIndent();
        sw.write("<version>");
        sw.write(peptideShakerVersion);
        sw.write("</version>");
        sw.newLine();
        sw.writeLineDecreasedIndent("</analysis_summary>");
    }

    private void writeMsmsRunSummary(SimpleXmlWriter sw, Identification identification, SpectrumProvider spectrumProvider, IdentificationParameters identificationParameters, WaitingHandler waitingHandler) throws IOException {
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(identification.getSpectrumIdentificationSize());
        }
        TreeSet<String> msFiles = new TreeSet<String>(identification.getSpectrumIdentification().keySet());
        for (String spectrumFileName : msFiles) {
            StringBuilder runStart = new StringBuilder();
            runStart.append("<msms_run_summary");
            String filePath = spectrumProvider.getFilePaths().get(spectrumFileName);
            if (filePath != null) {
                String baseName = IoUtil.removeExtension(filePath);
                String extension = IoUtil.getExtension(new File(filePath));
                runStart.append(" base_name=\"").append(baseName).append("\" ");
                runStart.append("raw_data_type=\"").append(extension).append("\" ");
                runStart.append("raw_data=\"").append(extension).append("\"");
            }
            runStart.append(">");
            sw.writeLine(runStart.toString());
            DigestionParameters digestionPreferences = identificationParameters.getSearchParameters().getDigestionParameters();
            if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
                for (Enzyme enzyme : digestionPreferences.getEnzymes()) {
                    DigestionParameters.Specificity specificity = digestionPreferences.getSpecificity(enzyme.getName());
                    this.writeEnzyme(sw, enzyme, specificity);
                }
            }
            this.writeSearchSummary(sw, identificationParameters);
            this.writeSpectrumQueries(sw, identification, spectrumProvider, identificationParameters, spectrumFileName, waitingHandler);
            sw.writeLineDecreasedIndent("</msms_run_summary>");
            if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
            break;
        }
    }

    private void writeEnzyme(SimpleXmlWriter sw, Enzyme enzyme, DigestionParameters.Specificity specificity) throws IOException {
        TreeSet<Character> aaAfter;
        sw.writeLineIncreasedIndent("<sample_enzyme name=\"" + enzyme.getName() + "\" fidelity=\"" + (Object)((Object)specificity) + "\">");
        sw.increaseIndent();
        TreeSet<Character> aaBefore = new TreeSet<Character>(enzyme.getAminoAcidBefore());
        if (!aaBefore.isEmpty()) {
            String cut = aaBefore.stream().map(aa -> aa.toString()).collect(Collectors.joining());
            TreeSet<Character> restrictionAfter = new TreeSet<Character>(enzyme.getRestrictionAfter());
            String noCut = restrictionAfter.stream().map(aa -> aa.toString()).collect(Collectors.joining());
            sw.writeLine("<specificity cut=\"" + cut + "\" no_cut=\"" + noCut + "\" sense=\"C\"/>");
        }
        if (!(aaAfter = new TreeSet<Character>(enzyme.getAminoAcidAfter())).isEmpty()) {
            String cut = aaAfter.stream().map(aa -> aa.toString()).collect(Collectors.joining());
            TreeSet<Character> restrictionBefore = new TreeSet<Character>(enzyme.getRestrictionBefore());
            String noCut = restrictionBefore.stream().map(aa -> aa.toString()).collect(Collectors.joining());
            sw.writeLine("<specificity cut=\"" + cut + "\" no_cut=\"" + noCut + "\" sense=\"N\"/>");
        }
        sw.writeLineDecreasedIndent("</sample_enzyme>");
    }

    private void writeSearchSummary(SimpleXmlWriter sw, IdentificationParameters identificationParameters) throws IOException {
        Modification modification;
        sw.writeLine("<search_summary precursor_mass_type=\"monoisotopic\" fragment_mass_type=\"monoisotopic\">");
        sw.increaseIndent();
        for (String modName : identificationParameters.getSearchParameters().getModificationParameters().getFixedModifications()) {
            modification = this.modificationFactory.getModification(modName);
            sw.writeLine(this.getModLine(modification, false));
        }
        for (String modName : identificationParameters.getSearchParameters().getModificationParameters().getAllNotFixedModifications()) {
            modification = this.modificationFactory.getModification(modName);
            sw.writeLine(this.getModLine(modification, true));
        }
        sw.writeLineDecreasedIndent("</search_summary>");
    }

    private String getModLine(Modification modification, boolean variable) {
        StringBuilder modificationLine = new StringBuilder();
        ModificationType modificationType = modification.getModificationType();
        if (modificationType == ModificationType.modaa || modificationType == ModificationType.modnaa_peptide || modificationType == ModificationType.modnaa_protein || modificationType == ModificationType.modcaa_peptide || modificationType == ModificationType.modcaa_protein) {
            Character aa;
            AminoAcid aminoAcid;
            modificationLine.append("<aminoacid_modification ");
            AminoAcidPattern aminoAcidPattern = modification.getPattern();
            modificationLine.append("aminoacid=\"").append(aminoAcidPattern.toString()).append("\" ");
            modificationLine.append("massdiff=\"").append(modification.getMass()).append("\" ");
            if (aminoAcidPattern.getAminoAcidsAtTarget().size() == 1 && !(aminoAcid = AminoAcid.getAminoAcid((aa = aminoAcidPattern.getAminoAcidsAtTarget().get(0)).charValue())).iscombination()) {
                Double mass = aminoAcid.getMonoisotopicMass() + modification.getMass();
                modificationLine.append("mass=\"").append(mass).append("\" ");
            }
            if (modificationType.isCTerm()) {
                modificationLine.append("peptide_terminus=\"c\" ");
            }
            if (modificationType.isNTerm()) {
                modificationLine.append("peptide_terminus=\"n\" ");
            }
        } else {
            double mass;
            modificationLine.append("<terminal_modification ");
            if (modificationType.isCTerm()) {
                modificationLine.append("terminus=\"c\" ");
            }
            if (modificationType.isNTerm()) {
                modificationLine.append("terminus=\"n\" ");
            }
            modificationLine.append("massdiff=\"").append(modification.getMass()).append("\" ");
            if (modificationType == ModificationType.modc_protein) {
                modificationLine.append("protein_terminus=\"c\" ");
            }
            if (modificationType == ModificationType.modn_protein) {
                modificationLine.append("protein_terminus=\"n\" ");
            }
            if (modificationType.isNTerm()) {
                mass = Atom.H.getMonoisotopicMass() + modification.getMass();
                modificationLine.append("mass=\"").append(mass).append("\" ");
            }
            if (modificationType.isCTerm()) {
                mass = Atom.H.getMonoisotopicMass() + Atom.O.getMonoisotopicMass() + modification.getMass();
                modificationLine.append("mass=\"").append(mass).append("\" ");
            }
        }
        if (variable) {
            modificationLine.append("variable=\"Y\" ");
        } else {
            modificationLine.append("variable=\"N\" ");
        }
        modificationLine.append("symbol=\"").append(modification.getName()).append("\" ");
        CvTerm cvTerm = modification.getUnimodCvTerm();
        if (cvTerm != null) {
            modificationLine.append("description=\"").append(cvTerm.getAccession()).append("\"");
        } else {
            cvTerm = modification.getPsiModCvTerm();
            if (cvTerm != null) {
                modificationLine.append("description=\"").append(cvTerm.getAccession()).append("\"");
            }
        }
        modificationLine.append("/>");
        return modificationLine.toString();
    }

    private void writeSpectrumQueries(SimpleXmlWriter sw, Identification identification, SpectrumProvider spectrumProvider, IdentificationParameters identificationParameters, String refSpectrumFile, WaitingHandler waitingHandler) throws IOException {
        SpectrumMatch spectrumMatch;
        SpectrumMatchesIterator psmIterator = identification.getSpectrumMatchesIterator(waitingHandler);
        while ((spectrumMatch = psmIterator.next()) != null) {
            String spectrumFile = spectrumMatch.getSpectrumFile();
            if (!spectrumFile.equals(refSpectrumFile)) continue;
            String spectrumTitle = spectrumMatch.getSpectrumTitle();
            StringBuilder spectrumQueryStart = new StringBuilder();
            spectrumQueryStart.append("<spectrum_query unique_search_id=\"").append(StringEscapeUtils.escapeHtml4((String)spectrumTitle)).append("\">");
            sw.writeLine(spectrumQueryStart.toString());
            this.writeSpectrumMatch(sw, identification, spectrumProvider, identificationParameters, spectrumMatch);
            sw.writeLineDecreasedIndent("</spectrum_query>");
            if (waitingHandler == null) continue;
            waitingHandler.increaseSecondaryProgressCounter();
            if (!waitingHandler.isRunCanceled()) continue;
            break;
        }
    }

    private void writeSpectrumMatch(SimpleXmlWriter sw, Identification identification, SpectrumProvider spectrumProvider, IdentificationParameters identificationParameters, SpectrumMatch spectrumMatch) throws IOException {
        PSParameter psParameter;
        double precursorMz = spectrumProvider.getPrecursorMz(spectrumMatch.getSpectrumFile(), spectrumMatch.getSpectrumTitle());
        sw.writeLineIncreasedIndent("<search_result>");
        sw.increaseIndent();
        PeptideAssumption peptideAssumption = spectrumMatch.getBestPeptideAssumption();
        if (peptideAssumption != null) {
            psParameter = (PSParameter)spectrumMatch.getUrParam(PSParameter.dummy);
            this.writeSearchHit(sw, identificationParameters, peptideAssumption, precursorMz, psParameter, true);
        }
        HashMap<Integer, TreeMap<Double, ArrayList<PeptideAssumption>>> assumptions = ((SpectrumMatch)identification.retrieveObject(spectrumMatch.getKey())).getPeptideAssumptionsMap();
        for (TreeMap<Double, ArrayList<PeptideAssumption>> scoreMap : assumptions.values()) {
            for (ArrayList<PeptideAssumption> spectrumIdentificationAssumptions : scoreMap.values()) {
                for (SpectrumIdentificationAssumption spectrumIdentificationAssumption : spectrumIdentificationAssumptions) {
                    peptideAssumption = (PeptideAssumption)spectrumIdentificationAssumption;
                    psParameter = (PSParameter)peptideAssumption.getUrParam(PSParameter.dummy);
                    this.writeSearchHit(sw, identificationParameters, peptideAssumption, precursorMz, psParameter, false);
                }
            }
        }
        sw.writeLineDecreasedIndent("</search_result>");
    }

    private void writeSearchHit(SimpleXmlWriter sw, IdentificationParameters identificationParameters, PeptideAssumption peptideAssumption, double precursorMz, PSParameter psParameter, boolean mainHit) throws IOException {
        StringBuilder searchScore;
        ModificationMatch[] modificationMatches;
        Peptide peptide = peptideAssumption.getPeptide();
        StringBuilder searchHitStart = new StringBuilder();
        searchHitStart.append("<search_hit hit_rank=\"").append(peptideAssumption.getRank()).append("\" ").append("peptide=\"").append(peptide.getSequence()).append("\" ");
        TreeMap<String, int[]> proteinMapping = peptide.getProteinMapping();
        String proteins = proteinMapping.navigableKeySet().stream().collect(Collectors.joining(","));
        searchHitStart.append("protein=\"").append(proteins).append("\" ").append("num_tot_proteins=\"").append(proteinMapping.size()).append("\" ").append("calc_neutral_pep_mass=\"").append(peptideAssumption.getTheoreticMass()).append("\" ").append("massdiff=\"").append(peptideAssumption.getDeltaMz(precursorMz, false, identificationParameters.getSearchParameters().getMinIsotopicCorrection(), identificationParameters.getSearchParameters().getMaxIsotopicCorrection())).append("\">");
        sw.writeLine(searchHitStart.toString());
        sw.increaseIndent();
        if (proteinMapping.size() > 1) {
            for (String accession : proteinMapping.navigableKeySet()) {
                StringBuilder proteinLine = new StringBuilder();
                proteinLine.append("<alternative_protein protein=\"").append(accession).append("\"/>");
                sw.writeLine(proteinLine.toString());
            }
        }
        if ((modificationMatches = peptide.getVariableModifications()).length > 0) {
            HashMap<Integer, Double> modifiedAminoAcids = new HashMap<Integer, Double>(modificationMatches.length);
            Double nTermMass = null;
            Double cTermMass = null;
            for (ModificationMatch modificationMatch : modificationMatches) {
                Modification modification = this.modificationFactory.getModification(modificationMatch.getModification());
                ModificationType modificationType = modification.getModificationType();
                if (modificationType == ModificationType.modn_protein || modificationType == ModificationType.modn_peptide) {
                    if (nTermMass == null) {
                        nTermMass = Atom.H.getMonoisotopicMass();
                    }
                    nTermMass = nTermMass + modification.getMass();
                    continue;
                }
                if (modificationType == ModificationType.modc_protein || modificationType == ModificationType.modc_peptide) {
                    if (cTermMass == null) {
                        cTermMass = Atom.H.getMonoisotopicMass() + Atom.O.getMonoisotopicMass();
                    }
                    cTermMass = cTermMass + modification.getMass();
                    continue;
                }
                int site = modificationMatch.getSite();
                Double modMass = (Double)modifiedAminoAcids.get(site);
                if (modMass == null) {
                    modMass = 0.0;
                }
                modMass = modMass + modification.getMass();
                modifiedAminoAcids.put(site, modMass);
            }
            StringBuilder modificationStart = new StringBuilder();
            modificationStart.append("<modification_info");
            if (nTermMass != null) {
                modificationStart.append(" mod_nterm_mass=\"").append(nTermMass).append("\"");
            }
            if (cTermMass != null) {
                modificationStart.append(" mod_cterm_mass=\"").append(nTermMass).append("\"");
            }
            modificationStart.append(">");
            sw.writeLine(modificationStart.toString());
            if (!modifiedAminoAcids.isEmpty()) {
                sw.increaseIndent();
                for (Integer site : modifiedAminoAcids.keySet()) {
                    double modifiedMass = (Double)modifiedAminoAcids.get(site);
                    StringBuilder modificationSite = new StringBuilder();
                    modificationSite.append("<mod_aminoacid_mass position=\"").append(site).append("\" mass=\"").append(modifiedMass).append("\"/>");
                    sw.writeLine(modificationSite.toString());
                }
                sw.decreaseIndent();
            }
            sw.writeLine("</modification_info>");
        }
        if (mainHit) {
            searchScore = new StringBuilder();
            searchScore.append("<search_score name=\"PSM raw score\" value=\"").append(psParameter.getTransformedScore()).append("\"/>");
            sw.writeLine(searchScore.toString());
            searchScore = new StringBuilder();
            searchScore.append("<search_score name=\"PSM score\" value=\"").append(psParameter.getTransformedScore()).append("\"/>");
            sw.writeLine(searchScore.toString());
            searchScore = new StringBuilder();
            searchScore.append("<search_score name=\"PSM PEP\" value=\"").append(psParameter.getProbability()).append("\"/>");
            sw.writeLine(searchScore.toString());
            searchScore = new StringBuilder();
            searchScore.append("<search_score name=\"PSM confidence\" value=\"").append(psParameter.getConfidence()).append("\"/>");
            sw.writeLine(searchScore.toString());
        } else {
            searchScore = new StringBuilder();
            searchScore.append("<search_score name=\"Identification algorithm raw score\" value=\"").append(peptideAssumption.getRawScore()).append("\"/>");
            sw.writeLine(searchScore.toString());
            searchScore = new StringBuilder();
            searchScore.append("<search_score name=\"Identification algorithm score\" value=\"").append(peptideAssumption.getScore()).append("\"/>");
            sw.writeLine(searchScore.toString());
            searchScore = new StringBuilder();
            searchScore.append("<search_score name=\"Identification algorithm PEP\" value=\"").append(psParameter.getProbability()).append("\"/>");
            sw.writeLine(searchScore.toString());
            searchScore = new StringBuilder();
            searchScore.append("<search_score name=\"Identification algorithm confidence\" value=\"").append(psParameter.getConfidence()).append("\"/>");
            sw.writeLine(searchScore.toString());
        }
        sw.writeLine("<analysis_result>");
        int advocateId = peptideAssumption.getAdvocate();
        Advocate advocate = Advocate.getAdvocate(advocateId);
        StringBuilder parameterLine = new StringBuilder();
        parameterLine.append("<parameter name=\"algorithm\" value=\"").append(advocate.getName()).append("\"/>");
        sw.writeLineIncreasedIndent(parameterLine.toString());
        for (ModificationMatch modificationMatch : modificationMatches) {
            parameterLine = new StringBuilder();
            parameterLine.append("<parameter name=\"ptm\" value=\"").append(modificationMatch.getModification()).append(" (").append(modificationMatch.getSite()).append(")").append("\"/>");
            sw.writeLine(parameterLine.toString());
        }
        parameterLine = new StringBuilder();
        parameterLine.append("<parameter name=\"charge\" value=\"").append(Integer.toString(peptideAssumption.getIdentificationCharge())).append("\"/>");
        sw.writeLine(parameterLine.toString());
        parameterLine = new StringBuilder();
        parameterLine.append("<parameter name=\"isotope\" value=\"").append(peptideAssumption.getIsotopeNumber(precursorMz, identificationParameters.getSearchParameters().getMinIsotopicCorrection(), identificationParameters.getSearchParameters().getMaxIsotopicCorrection())).append("\"/>");
        sw.writeLine(parameterLine.toString());
        sw.writeLineDecreasedIndent("</analysis_result>");
        sw.writeLineDecreasedIndent("</search_hit>");
    }
}

