/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.followup;

import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.SpectrumMatchesIterator;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.io.flat.SimpleFileWriter;
import com.compomics.util.parameters.identification.advanced.ModificationLocalizationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.threading.SimpleSemaphore;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.utils.DeepLcUtils;
import eu.isas.peptideshaker.utils.Ms2PipUtils;
import eu.isas.peptideshaker.utils.PercolatorUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class PercolatorExport {
    public static void percolatorExport(File destinationFile, File deepLcFile, File rtObsPredsFile, File ms2pipFile, Identification identification, SearchParameters searchParameters, SequenceMatchingParameters sequenceMatchingParameters, AnnotationParameters annotationParameters, ModificationLocalizationParameters modificationLocalizationParameters, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, WaitingHandler waitingHandler) {
        HashMap<String, ArrayList<Double>> rtPrediction = null;
        if (deepLcFile != null) {
            waitingHandler.setWaitingText("Exporting Percolator output - Parsing DeepLC results");
            rtPrediction = PercolatorExport.getRtPrediction(deepLcFile);
        }
        HashMap<String, ArrayList<Spectrum>> fragmentationPrediction = null;
        if (ms2pipFile != null) {
            waitingHandler.setWaitingText("Exporting Percolator output - Parsing ms2pip results");
            fragmentationPrediction = PercolatorExport.getIntensitiesPrediction(ms2pipFile);
        }
        waitingHandler.setWaitingText("Exporting Percolator output - Writing export");
        try {
            PercolatorExport.percolatorExport(destinationFile, rtObsPredsFile, rtPrediction, fragmentationPrediction, identification, searchParameters, sequenceMatchingParameters, annotationParameters, modificationLocalizationParameters, modificationParameters, sequenceProvider, spectrumProvider, waitingHandler);
        }
        catch (InterruptedException | ExecutionException ex) {
            Logger.getLogger(PercolatorExport.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static HashMap<String, ArrayList<Double>> getRtPrediction(File deepLcFile) {
        HashMap<String, ArrayList<Double>> result = new HashMap<String, ArrayList<Double>>();
        try (SimpleFileReader reader = SimpleFileReader.getFileReader(deepLcFile);){
            String line = reader.readLine();
            while ((line = reader.readLine()) != null) {
                String[] lineSplit = line.split(",");
                String key = String.join((CharSequence)",", lineSplit[1], lineSplit[2]);
                double rt = Double.parseDouble(lineSplit[4]);
                if (result.get(key) == null) {
                    ArrayList<Double> rtsForPeptide = new ArrayList<Double>(1);
                    rtsForPeptide.add(rt);
                    result.put(key, rtsForPeptide);
                    continue;
                }
                result.get(key).add(rt);
            }
        }
        return result;
    }

    public static HashMap<String, ArrayList<Spectrum>> getIntensitiesPrediction(File ms2pipFile) {
        HashMap<String, ArrayList<Spectrum>> result = new HashMap<String, ArrayList<Spectrum>>();
        try (SimpleFileReader reader = SimpleFileReader.getFileReader(ms2pipFile);){
            String line = reader.readLine();
            String firstDataLine = reader.readLine();
            String[] firstDataLineSplit = firstDataLine.split(",");
            String predictedSpectrumKey = firstDataLineSplit[0];
            String firstIon = firstDataLineSplit[2];
            double firstMz = Double.parseDouble(firstDataLineSplit[4]);
            double firstPrediction = Double.parseDouble(firstDataLineSplit[5]);
            ArrayList<Double> mzs = new ArrayList<Double>();
            ArrayList<Double> predictions = new ArrayList<Double>();
            mzs.add(firstMz);
            predictions.add(firstPrediction);
            ArrayList<Double> mzsB = new ArrayList<Double>();
            ArrayList<Double> predictionsB = new ArrayList<Double>();
            ArrayList<Double> mzsY = new ArrayList<Double>();
            ArrayList<Double> predictionsY = new ArrayList<Double>();
            if (firstIon.equals("B") || firstIon.equals("B2")) {
                mzsB.add(firstMz);
                predictionsB.add(firstPrediction);
            } else if (firstIon.equals("Y") || firstIon.equals("Y2")) {
                mzsY.add(firstMz);
                predictionsY.add(firstPrediction);
            }
            while ((line = reader.readLine()) != null) {
                String[] lineSplit = line.split(",");
                String key = lineSplit[0];
                String ion = lineSplit[2];
                double mz = Double.parseDouble(lineSplit[4]);
                double prediction = Double.parseDouble(lineSplit[5]);
                if (key.equals(predictedSpectrumKey)) {
                    mzs.add(mz);
                    predictions.add(prediction);
                    if (ion.equals("B") || ion.equals("B2")) {
                        mzsB.add(mz);
                        predictionsB.add(prediction);
                        continue;
                    }
                    if (!ion.equals("Y") && !ion.equals("Y2")) continue;
                    mzsY.add(mz);
                    predictionsY.add(prediction);
                    continue;
                }
                ArrayList mzsUnsorted = new ArrayList(mzs);
                Collections.sort(mzs);
                double[] mzsArray = new double[mzs.size()];
                double[] predictionsArray = new double[mzs.size()];
                for (int i = 0; i < predictionsArray.length; ++i) {
                    mzsArray[i] = (Double)mzs.get(i);
                    int index = mzsUnsorted.indexOf(mzs.get(i));
                    predictionsArray[i] = (Double)predictions.get(index);
                }
                Spectrum predictedSpectrum = new Spectrum(null, mzsArray, predictionsArray, 2);
                ArrayList mzsBUnsorted = new ArrayList(mzsB);
                Collections.sort(mzsB);
                double[] mzsBArray = new double[mzsB.size()];
                double[] predictionsBArray = new double[mzsB.size()];
                for (int i = 0; i < predictionsBArray.length; ++i) {
                    mzsBArray[i] = (Double)mzsB.get(i);
                    int index = mzsBUnsorted.indexOf(mzsB.get(i));
                    predictionsBArray[i] = (Double)predictionsB.get(index);
                }
                Spectrum predictedBionSpectrum = new Spectrum(null, mzsBArray, predictionsBArray, 2);
                ArrayList mzsYUnsorted = new ArrayList(mzsY);
                Collections.sort(mzsY);
                double[] mzsYArray = new double[mzsY.size()];
                double[] predictionsYArray = new double[mzsY.size()];
                for (int i = 0; i < predictionsYArray.length; ++i) {
                    mzsYArray[i] = (Double)mzsY.get(i);
                    int index = mzsYUnsorted.indexOf(mzsY.get(i));
                    predictionsYArray[i] = (Double)predictionsY.get(index);
                }
                Spectrum predictedYionSpectrum = new Spectrum(null, mzsYArray, predictionsYArray, 2);
                ArrayList<Spectrum> predictedSpectra = new ArrayList<Spectrum>();
                predictedSpectra.add(predictedSpectrum);
                predictedSpectra.add(predictedBionSpectrum);
                predictedSpectra.add(predictedYionSpectrum);
                result.put(predictedSpectrumKey, predictedSpectra);
                mzs = new ArrayList();
                predictions = new ArrayList();
                mzs.add(mz);
                predictions.add(prediction);
                mzsB = new ArrayList();
                predictionsB = new ArrayList();
                mzsY = new ArrayList();
                predictionsY = new ArrayList();
                if (ion.equals("B") || ion.equals("B2")) {
                    mzsB.add(mz);
                    predictionsB.add(prediction);
                } else if (ion.equals("Y") || ion.equals("Y2")) {
                    mzsY.add(mz);
                    predictionsY.add(prediction);
                }
                predictedSpectrumKey = key;
            }
            ArrayList mzsUnsorted = new ArrayList(mzs);
            Collections.sort(mzs);
            double[] mzsArray = new double[mzs.size()];
            double[] predictionsArray = new double[mzs.size()];
            for (int i = 0; i < predictionsArray.length; ++i) {
                mzsArray[i] = (Double)mzs.get(i);
                int index = mzsUnsorted.indexOf(mzs.get(i));
                predictionsArray[i] = (Double)predictions.get(index);
            }
            Spectrum predictedSpectrum = new Spectrum(null, mzsArray, predictionsArray, 2);
            ArrayList mzsBUnsorted = new ArrayList(mzsB);
            Collections.sort(mzsB);
            double[] mzsBArray = new double[mzsB.size()];
            double[] predictionsBArray = new double[mzsB.size()];
            for (int i = 0; i < predictionsBArray.length; ++i) {
                mzsBArray[i] = (Double)mzsB.get(i);
                int index = mzsBUnsorted.indexOf(mzsB.get(i));
                predictionsBArray[i] = (Double)predictionsB.get(index);
            }
            Spectrum predictedBionSpectrum = new Spectrum(null, mzsBArray, predictionsBArray, 2);
            ArrayList mzsYUnsorted = new ArrayList(mzsY);
            Collections.sort(mzsY);
            double[] mzsYArray = new double[mzsY.size()];
            double[] predictionsYArray = new double[mzsY.size()];
            for (int i = 0; i < predictionsYArray.length; ++i) {
                mzsYArray[i] = (Double)mzsY.get(i);
                int index = mzsYUnsorted.indexOf(mzsY.get(i));
                predictionsYArray[i] = (Double)predictionsY.get(index);
            }
            Spectrum predictedYionSpectrum = new Spectrum(null, mzsYArray, predictionsYArray, 2);
            ArrayList<Spectrum> predictedSpectra = new ArrayList<Spectrum>();
            predictedSpectra.add(predictedSpectrum);
            predictedSpectra.add(predictedBionSpectrum);
            predictedSpectra.add(predictedYionSpectrum);
            result.put(predictedSpectrumKey, predictedSpectra);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void percolatorExport(File destinationFile, File rtObsPredsFile, HashMap<String, ArrayList<Double>> rtPrediction, HashMap<String, ArrayList<Spectrum>> fragmentationPrediction, Identification identification, SearchParameters searchParameters, SequenceMatchingParameters sequenceMatchingParameters, AnnotationParameters annotationParameters, ModificationLocalizationParameters modificationLocalizationParameters, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, WaitingHandler waitingHandler) throws InterruptedException, ExecutionException {
        int threadCount = 10;
        waitingHandler.resetSecondaryProgressCounter();
        waitingHandler.setMaxSecondaryProgressCounter(identification.getSpectrumIdentificationSize());
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        SimpleSemaphore writingSemaphore = new SimpleSemaphore(1);
        try (SimpleFileWriter writer = new SimpleFileWriter(destinationFile, true);){
            SpectrumMatch match;
            Boolean rtPredictionsAvailable = rtPrediction != null;
            Boolean spectraPredictionsAvailable = fragmentationPrediction != null;
            HashMap<String, ArrayList<Double>> allRTvalues = null;
            if (rtPredictionsAvailable.booleanValue()) {
                allRTvalues = PercolatorExport.getAllObservedPredictedRT(identification, rtPrediction, searchParameters, sequenceProvider, sequenceMatchingParameters, modificationFactory, spectrumProvider, waitingHandler);
            }
            HashMap<String, ArrayList<Double>> allRTs = allRTvalues;
            String header = PercolatorUtils.getHeader(searchParameters, rtPredictionsAvailable, spectraPredictionsAvailable);
            writer.writeLine(header);
            SpectrumMatchesIterator spectrumMatchesIterator = identification.getSpectrumMatchesIterator(waitingHandler);
            System.out.println("Creating a custom thread pool: " + threadCount + " threads.");
            ForkJoinPool customThreadPool = new ForkJoinPool(threadCount);
            ArrayList<SpectrumMatch> allSpectrumMatches = new ArrayList<SpectrumMatch>();
            while ((match = spectrumMatchesIterator.next()) != null) {
                allSpectrumMatches.add(match);
            }
            System.out.println("Processing " + allSpectrumMatches.size() + " matches");
            try {
                ((ForkJoinTask)customThreadPool.submit(() -> allSpectrumMatches.parallelStream().forEach(spectrumMatch -> {
                    if (spectrumMatch == null) {
                        return;
                    }
                    HashSet processedPsmKeys = new HashSet();
                    if (waitingHandler != null) {
                        waitingHandler.increaseSecondaryProgressCounter();
                        if (waitingHandler.isRunCanceled()) {
                            return;
                        }
                    }
                    Boolean rtFileWriterFlag = false;
                    SpectrumMatch tempSpectrumMatch = spectrumMatch;
                    tempSpectrumMatch.getAllPeptideAssumptions().forEach(peptideAssumption -> PercolatorExport.writePeptideCandidate(tempSpectrumMatch, peptideAssumption, allRTs, rtFileWriterFlag, fragmentationPrediction, searchParameters, sequenceProvider, sequenceMatchingParameters, annotationParameters, modificationLocalizationParameters, modificationFactory, modificationParameters, spectrumProvider, processedPsmKeys, writingSemaphore, writer));
                }))).join();
            }
            finally {
                System.out.println("Shutting down thread pool.");
                customThreadPool.shutdown();
            }
        }
    }

    private static HashMap<String, ArrayList<Double>> getAllObservedPredictedRT(Identification identification, HashMap<String, ArrayList<Double>> rtPrediction, SearchParameters searchParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters sequenceMatchingParameters, ModificationFactory modificationFactory, SpectrumProvider spectrumProvider, WaitingHandler waitingHandler) {
        SpectrumMatch spectrumMatch;
        if (rtPrediction == null) {
            return null;
        }
        HashMap<String, ArrayList<Double>> allRTvalues = new HashMap<String, ArrayList<Double>>();
        SpectrumMatchesIterator spectrumMatchesIterator = identification.getSpectrumMatchesIterator(waitingHandler);
        while ((spectrumMatch = spectrumMatchesIterator.next()) != null) {
            HashMap<String, ArrayList<Double>> rtPreds = rtPrediction;
            SpectrumMatch tempSpectrumMatch = spectrumMatch;
            ((Stream)tempSpectrumMatch.getAllPeptideAssumptions().parallel()).forEach(peptideAssumption -> PercolatorExport.addPeptideCandidateRT(allRTvalues, tempSpectrumMatch, peptideAssumption, rtPreds, searchParameters, sequenceProvider, sequenceMatchingParameters, modificationFactory, spectrumProvider));
        }
        return allRTvalues;
    }

    public static void RTValuesExport(File deepLcFile, File rtObsPredsFile, Identification identification, SearchParameters searchParameters, SequenceMatchingParameters sequenceMatchingParameters, AnnotationParameters annotationParameters, ModificationLocalizationParameters modificationLocalizationParameters, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, WaitingHandler waitingHandler) {
        Boolean rtPredictionsAvailable = deepLcFile != null;
        HashMap<String, ArrayList<Double>> rtPrediction = new HashMap();
        if (deepLcFile == null) {
            return;
        }
        waitingHandler.setWaitingText("Exporting Percolator output - Parsing DeepLC results");
        rtPrediction = PercolatorExport.getRtPrediction(deepLcFile);
        waitingHandler.resetSecondaryProgressCounter();
        waitingHandler.setMaxSecondaryProgressCounter(identification.getSpectrumIdentificationSize());
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        SimpleSemaphore writingSemaphore = new SimpleSemaphore(1);
        HashMap<String, ArrayList<Double>> allRTvalues = PercolatorExport.getAllObservedPredictedRTScaled(identification, rtPrediction, searchParameters, sequenceProvider, sequenceMatchingParameters, modificationFactory, spectrumProvider, waitingHandler);
        try (SimpleFileWriter writer = new SimpleFileWriter(rtObsPredsFile, true);){
            SpectrumMatch spectrumMatch;
            String header = PercolatorUtils.getRTValuesHeader();
            writer.writeLine(header);
            SpectrumMatchesIterator spectrumMatchesIterator = identification.getSpectrumMatchesIterator(waitingHandler);
            while ((spectrumMatch = spectrumMatchesIterator.next()) != null) {
                HashSet processedPsmKeys = new HashSet();
                if (waitingHandler != null) {
                    waitingHandler.increaseSecondaryProgressCounter();
                    if (waitingHandler.isRunCanceled()) {
                        return;
                    }
                }
                Boolean rtFileWriterFlag = true;
                HashMap<String, ArrayList<Double>> allRTs = allRTvalues;
                SpectrumMatch tempSpectrumMatch = spectrumMatch;
                ((Stream)tempSpectrumMatch.getAllPeptideAssumptions().parallel()).forEach(peptideAssumption -> PercolatorExport.writePeptideCandidate(tempSpectrumMatch, peptideAssumption, allRTs, rtFileWriterFlag, null, searchParameters, sequenceProvider, sequenceMatchingParameters, annotationParameters, modificationLocalizationParameters, modificationFactory, modificationParameters, spectrumProvider, processedPsmKeys, writingSemaphore, writer));
            }
        }
    }

    private static HashMap<String, ArrayList<Double>> getAllObservedPredictedRTScaled(Identification identification, HashMap<String, ArrayList<Double>> rtPrediction, SearchParameters searchParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters sequenceMatchingParameters, ModificationFactory modificationFactory, SpectrumProvider spectrumProvider, WaitingHandler waitingHandler) {
        SpectrumMatch spectrumMatch;
        HashMap<String, ArrayList<Double>> allRTvalues = new HashMap<String, ArrayList<Double>>();
        SpectrumMatchesIterator spectrumMatchesIterator = identification.getSpectrumMatchesIterator(waitingHandler);
        while ((spectrumMatch = spectrumMatchesIterator.next()) != null) {
            HashMap<String, ArrayList<Double>> rtPreds = rtPrediction;
            SpectrumMatch tempSpectrumMatch = spectrumMatch;
            ((Stream)tempSpectrumMatch.getAllPeptideAssumptions().parallel()).forEach(peptideAssumption -> PercolatorExport.addPeptideCandidateRT(allRTvalues, tempSpectrumMatch, peptideAssumption, rtPreds, searchParameters, sequenceProvider, sequenceMatchingParameters, modificationFactory, spectrumProvider));
        }
        ArrayList<String> allDeepLCkeys = new ArrayList<String>();
        ArrayList<Double> allObservedRTs = new ArrayList<Double>();
        ArrayList<Double> allPredictedRTs = new ArrayList<Double>();
        for (Map.Entry entry : allRTvalues.entrySet()) {
            String key = (String)entry.getKey();
            ArrayList values = (ArrayList)entry.getValue();
            allDeepLCkeys.add(key);
            allObservedRTs.add((Double)values.get(0));
            allPredictedRTs.add((Double)values.get(1));
        }
        HashMap<String, ArrayList<Double>> allRTsCenterScale = PercolatorExport.comparePeptideRTCenterScale(allDeepLCkeys, allObservedRTs, allPredictedRTs);
        for (Map.Entry entry : allRTvalues.entrySet()) {
            String key = (String)entry.getKey();
            ArrayList values = (ArrayList)entry.getValue();
            values.addAll((Collection)allRTsCenterScale.get(key));
            allRTvalues.put(key, values);
        }
        return allRTvalues;
    }

    private static String comparePeptideRTranks() {
        return "";
    }

    private static HashMap<String, ArrayList<Double>> comparePeptideRTCenterScale(ArrayList<String> allDeepLCkeys, ArrayList<Double> allObservedRTs, ArrayList<Double> allPredictedRTs) {
        int i;
        HashMap<String, ArrayList<Double>> allRTsCenterScale = new HashMap<String, ArrayList<Double>>();
        double minObs = allObservedRTs.get(0);
        double maxObs = allObservedRTs.get(0);
        for (int i2 = 1; i2 < allObservedRTs.size(); ++i2) {
            double value = allObservedRTs.get(i2);
            if (value < minObs) {
                minObs = value;
            }
            if (!(value > maxObs)) continue;
            maxObs = value;
        }
        double minPreds = allPredictedRTs.get(0);
        double maxPreds = allPredictedRTs.get(0);
        for (i = 1; i < allPredictedRTs.size(); ++i) {
            double value = allPredictedRTs.get(i);
            if (value < minPreds) {
                minPreds = value;
            }
            if (!(value > maxPreds)) continue;
            maxPreds = value;
        }
        for (i = 0; i < allPredictedRTs.size(); ++i) {
            final double scaledObsRT = (allObservedRTs.get(i) - minObs) / (maxObs - minObs);
            final double scaledPredsRT = (allPredictedRTs.get(i) - minPreds) / (maxPreds - minPreds);
            ArrayList<Double> RTs = new ArrayList<Double>(){
                {
                    this.add(scaledObsRT);
                    this.add(scaledPredsRT);
                }
            };
            allRTsCenterScale.put(allDeepLCkeys.get(i), RTs);
        }
        return allRTsCenterScale;
    }

    private static ArrayList<Double> getPeptidePredictedRT(PeptideAssumption peptideAssumption, SearchParameters searchParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters sequenceMatchingParameters, ModificationFactory modificationFactory, HashMap<String, ArrayList<Double>> rtPrediction) {
        String deepLcKey = String.join((CharSequence)",", peptideAssumption.getPeptide().getSequence(), DeepLcUtils.getModifications(peptideAssumption.getPeptide(), searchParameters.getModificationParameters(), sequenceProvider, sequenceMatchingParameters, modificationFactory));
        ArrayList<Double> predictedRts = rtPrediction.get(deepLcKey);
        return predictedRts;
    }

    private static void addPeptideCandidateRT(HashMap<String, ArrayList<Double>> allRTvalues, SpectrumMatch spectrumMatch, PeptideAssumption peptideAssumption, HashMap<String, ArrayList<Double>> rtPrediction, SearchParameters searchParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters sequenceMatchingParameters, ModificationFactory modificationFactory, SpectrumProvider spectrumProvider) {
        String deepLcKey = String.join((CharSequence)",", peptideAssumption.getPeptide().getSequence(), DeepLcUtils.getModifications(peptideAssumption.getPeptide(), searchParameters.getModificationParameters(), sequenceProvider, sequenceMatchingParameters, modificationFactory));
        ArrayList<Double> predictedRts = PercolatorExport.getPeptidePredictedRT(peptideAssumption, searchParameters, sequenceProvider, sequenceMatchingParameters, modificationFactory, rtPrediction);
        if (predictedRts == null) {
            ArrayList<Double> peptideRTs = new ArrayList<Double>();
            peptideRTs.add(1000000.0);
            allRTvalues.put(deepLcKey, peptideRTs);
            return;
        }
        ArrayList<Double> peptideRTs = PercolatorUtils.getPeptideObservedPredictedRT(spectrumMatch, predictedRts, spectrumProvider);
        allRTvalues.put(deepLcKey, peptideRTs);
    }

    private static void writePeptideCandidate(SpectrumMatch spectrumMatch, PeptideAssumption peptideAssumption, HashMap<String, ArrayList<Double>> allRTvalues, Boolean rtFileWriterFlag, HashMap<String, ArrayList<Spectrum>> fragmentationPrediction, SearchParameters searchParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters sequenceMatchingParameters, AnnotationParameters annotationParameters, ModificationLocalizationParameters modificationLocalizationParameters, ModificationFactory modificationFactory, ModificationParameters modificationParameters, SpectrumProvider spectrumProvider, HashSet<Long> processedPsms, SimpleSemaphore writingSemaphore, SimpleFileWriter writer) {
        String peptideData;
        long peptideKey;
        String deepLcKey;
        Boolean rtPredictionsAvailable = allRTvalues != null;
        ArrayList<Double> peptideRTs = null;
        if (rtPredictionsAvailable.booleanValue() && (peptideRTs = allRTvalues.get(deepLcKey = String.join((CharSequence)",", peptideAssumption.getPeptide().getSequence(), DeepLcUtils.getModifications(peptideAssumption.getPeptide(), searchParameters.getModificationParameters(), sequenceProvider, sequenceMatchingParameters, modificationFactory)))) == null) {
            System.out.println("Missing DeepLC prediction for peptide: " + deepLcKey);
            return;
        }
        ArrayList<Spectrum> predictedSpectrum = null;
        Boolean spectraPredictionsAvailable = fragmentationPrediction != null;
        if (spectraPredictionsAvailable.booleanValue() && (predictedSpectrum = fragmentationPrediction.get(Long.toString(peptideKey = Ms2PipUtils.getPeptideKey(peptideData = Ms2PipUtils.getPeptideData(peptideAssumption, modificationParameters, sequenceProvider, sequenceMatchingParameters, modificationFactory))))) == null) {
            System.out.println("Missing MS2PIP prediction for peptide: " + Long.toString(peptideKey));
            return;
        }
        peptideData = rtFileWriterFlag != false && rtPredictionsAvailable != false ? PercolatorUtils.getPeptideRTData(spectrumMatch, peptideAssumption, modificationParameters, peptideRTs, sequenceProvider, spectrumProvider, sequenceMatchingParameters, modificationFactory) : PercolatorUtils.getPeptideData(spectrumMatch, peptideAssumption, peptideRTs, predictedSpectrum, searchParameters, sequenceProvider, sequenceMatchingParameters, annotationParameters, modificationLocalizationParameters, modificationFactory, spectrumProvider, modificationParameters);
        long psmKey = PercolatorUtils.getPsmKey(peptideData);
        writingSemaphore.acquire();
        if (!processedPsms.contains(psmKey)) {
            writer.writeLine(peptideData);
            processedPsms.add(psmKey);
        }
        writingSemaphore.release();
    }
}

