/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui;

import com.compomics.util.gui.waiting.waitinghandlers.WaitingDialog;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;

public class IdToSpectrumFileMappingDialog
extends JDialog {
    private final HashMap<File, String> missingFiles;
    private final HashMap<String, File> newFiles = new HashMap();
    private final ArrayList<File> idFiles;
    private File lastSelectedFolder;
    private final WaitingDialog waitingDialog;
    private JButton addButton;
    private JPanel backgroundPanel;
    private JButton browseButton;
    private JButton cancelButton;
    private JList fileList;
    private JScrollPane fileListScrollPane;
    private JTable fileTable;
    private JScrollPane fileTableScrollPane;
    private JLabel folderLabel;
    private JTextField folderTxt;
    private JLabel helpTextLabel;
    private JButton okButton;
    private JButton removeButton;

    public IdToSpectrumFileMappingDialog(WaitingDialog waitingDialog, HashMap<File, String> missingFiles) {
        super((Dialog)waitingDialog, true);
        this.waitingDialog = waitingDialog;
        this.missingFiles = missingFiles;
        this.idFiles = new ArrayList<File>(missingFiles.keySet());
        this.lastSelectedFolder = this.idFiles.get(0).getParentFile();
        this.initComponents();
        this.fileTable.getTableHeader().setReorderingAllowed(false);
        this.fileTableScrollPane.getViewport().setOpaque(false);
        this.newFolderLoaded();
        this.fileTable.setSelectionMode(0);
        this.fileTable.getColumn(" ").setMaxWidth(30);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void newFolderLoaded() {
        this.folderTxt.setText(this.lastSelectedFolder.getAbsolutePath());
        this.updateFileList();
    }

    private void updateFileList() {
        File[] files = this.lastSelectedFolder.listFiles();
        ArrayList<String> fileNames = new ArrayList<String>();
        for (File file : files) {
            String fileName = file.getName();
            boolean found = false;
            if (!fileName.toLowerCase().endsWith(".mgf")) continue;
            for (File newFile : this.newFiles.values()) {
                if (!newFile.getName().equals(fileName)) continue;
                found = true;
                break;
            }
            if (found) continue;
            fileNames.add(fileName);
        }
        Collections.sort(fileNames);
        String[] fileNamesArray = new String[fileNames.size()];
        for (int i = 0; i < fileNames.size(); ++i) {
            fileNamesArray[i] = (String)fileNames.get(i);
        }
        this.fileList.setListData(fileNamesArray);
    }

    private boolean validateInput() {
        for (File idFile : this.missingFiles.keySet()) {
            if (this.newFiles.keySet().contains(this.missingFiles.get(idFile))) continue;
            JOptionPane.showMessageDialog(null, "Please select the spectrum file corresponding to " + idFile.getName() + ".", "Input Error", 2);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.helpTextLabel = new JLabel();
        this.fileTableScrollPane = new JScrollPane();
        this.fileTable = new JTable();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.fileListScrollPane = new JScrollPane();
        this.fileList = new JList();
        this.folderLabel = new JLabel();
        this.browseButton = new JButton();
        this.folderTxt = new JTextField();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Spectrum Files Missing");
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.helpTextLabel.setText("Spectrum files missing. Please select them manually:");
        this.fileTable.setModel(new FileTable());
        this.fileTableScrollPane.setViewportView(this.fileTable);
        this.addButton.setText("<<");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdToSpectrumFileMappingDialog.this.addButtonActionPerformed(evt);
            }
        });
        this.removeButton.setText(">>");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdToSpectrumFileMappingDialog.this.removeButtonActionPerformed(evt);
            }
        });
        this.fileList.setSelectionMode(0);
        this.fileListScrollPane.setViewportView(this.fileList);
        this.folderLabel.setText("Folder:");
        this.browseButton.setText("Browse");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdToSpectrumFileMappingDialog.this.browseButtonActionPerformed(evt);
            }
        });
        this.folderTxt.setEditable(false);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdToSpectrumFileMappingDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IdToSpectrumFileMappingDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addComponent(this.fileTableScrollPane, -1, 375, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addButton).addComponent(this.removeButton))).addComponent(this.helpTextLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addComponent(this.folderLabel).addGap(18, 18, 18).addComponent(this.folderTxt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton, -2, 74, -2)).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, 74, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, 74, -2)).addComponent(this.fileListScrollPane, GroupLayout.Alignment.TRAILING, -1, 381, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.folderLabel).addComponent(this.browseButton).addComponent(this.folderTxt, -2, -1, -2).addComponent(this.helpTextLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.fileListScrollPane, -1, 286, Short.MAX_VALUE).addComponent(this.fileTableScrollPane, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput()) {
            this.dispose();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.waitingDialog.setRunCanceled();
        this.dispose();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Change Folder");
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.getName().toLowerCase().endsWith("mgf") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "New Folder";
            }
        };
        fileChooser.setFileFilter(filter);
        int returnVal = fileChooser.showDialog(null, "Open");
        if (returnVal == 0) {
            File mgfFolder = fileChooser.getSelectedFile();
            if (!mgfFolder.isDirectory()) {
                mgfFolder = mgfFolder.getParentFile();
            }
            this.lastSelectedFolder = mgfFolder;
            this.newFolderLoaded();
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int row = this.fileTable.getSelectedRow();
        if (row >= 0) {
            this.newFiles.remove(this.missingFiles.get(this.idFiles.get(row)));
            DefaultTableModel dm = (DefaultTableModel)this.fileTable.getModel();
            dm.fireTableDataChanged();
            this.updateFileList();
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        int row = this.fileTable.getSelectedRow();
        if (row == -1) {
            for (int i = 0; i < this.fileTable.getRowCount(); ++i) {
                if (this.newFiles.containsKey(this.missingFiles.get(this.idFiles.get(i)))) continue;
                row = i;
                break;
            }
        }
        String newFile = (String)this.fileList.getSelectedValue();
        String mgfFile = this.missingFiles.get(this.idFiles.get(row));
        if (mgfFile != null && newFile != null) {
            this.newFiles.put(mgfFile, new File(this.lastSelectedFolder, newFile));
        }
        DefaultTableModel dm = (DefaultTableModel)this.fileTable.getModel();
        dm.fireTableDataChanged();
        this.updateFileList();
    }

    public HashMap<String, File> getNewFiles() {
        return this.newFiles;
    }

    private class FileTable
    extends DefaultTableModel {
        private FileTable() {
        }

        @Override
        public int getRowCount() {
            return IdToSpectrumFileMappingDialog.this.idFiles.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Id File";
                }
                case 2: {
                    return "Expected File";
                }
                case 3: {
                    return "Spectrum File";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                switch (column) {
                    case 0: {
                        return row + 1;
                    }
                    case 1: {
                        return ((File)IdToSpectrumFileMappingDialog.this.idFiles.get(row)).getName();
                    }
                    case 2: {
                        return IdToSpectrumFileMappingDialog.this.missingFiles.get(IdToSpectrumFileMappingDialog.this.idFiles.get(row));
                    }
                    case 3: {
                        if (IdToSpectrumFileMappingDialog.this.newFiles.containsKey(IdToSpectrumFileMappingDialog.this.missingFiles.get(IdToSpectrumFileMappingDialog.this.idFiles.get(row)))) {
                            return ((File)IdToSpectrumFileMappingDialog.this.newFiles.get(IdToSpectrumFileMappingDialog.this.missingFiles.get(IdToSpectrumFileMappingDialog.this.idFiles.get(row)))).getName();
                        }
                        return "";
                    }
                }
                return "";
            }
            catch (Exception e) {
                return "Error: " + e.getLocalizedMessage();
            }
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return Double.valueOf(0.0).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

