/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui;

import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.peptide_shaker.ModificationScoring;
import com.compomics.util.experiment.identification.peptide_shaker.PSModificationScores;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.renderers.AlignedTableCellRenderer;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import eu.isas.peptideshaker.preferences.DisplayParameters;
import eu.isas.peptideshaker.ptm.ModificationLocalizationScorer;
import eu.isas.peptideshaker.utils.DisplayFeaturesGenerator;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.extra.NimbusCheckBoxRenderer;
import no.uib.jsparklines.renderers.JSparklinesIntegerColorTableCellRenderer;

public class ModificationSiteInferenceDialog
extends JDialog {
    private PeptideShakerGUI peptideShakerGUI;
    private Modification ptm;
    private ModificationFactory modificationFactory = ModificationFactory.getInstance();
    private PSModificationScores peptidePtmScore = null;
    private PeptideMatch peptideMatch;
    private ArrayList<SpectrumMatch> psms = new ArrayList();
    private boolean[] mainSelection;
    private boolean[] secondarySelection;
    private HashMap<Integer, String> ptmConfidenceTooltipMap;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JButton okButton;
    private JButton openDialogHelpJButton;
    private JPanel peptidePanel;
    private JPanel ptmSitePanel;
    private JTable ptmSiteTable;
    private JScrollPane ptmSiteTableScrollPane;
    private JTable ptmsTable;
    private JScrollPane ptmsTableScrollPane;
    private JLabel sequenceLabel;

    public ModificationSiteInferenceDialog(PeptideShakerGUI peptideShakerGUI, long peptideKey, Modification modification) {
        super((Frame)peptideShakerGUI, true);
        this.peptideShakerGUI = peptideShakerGUI;
        this.ptm = modification;
        double ptmMass = modification.getMass();
        Identification identification = peptideShakerGUI.getIdentification();
        this.peptideMatch = identification.getPeptideMatch(peptideKey);
        Peptide peptide = this.peptideMatch.getPeptide();
        this.mainSelection = new boolean[peptide.getSequence().length()];
        this.secondarySelection = new boolean[peptide.getSequence().length()];
        for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
            Modification tempMod = this.modificationFactory.getModification(modificationMatch.getModification());
            if (tempMod.getMass() != ptmMass) continue;
            int site = modificationMatch.getSite();
            if (modificationMatch.getConfident()) {
                this.mainSelection[site - 1] = true;
                continue;
            }
            this.secondarySelection[site - 1] = true;
        }
        this.psms.addAll(identification.retrieveObjects(Arrays.stream(this.peptideMatch.getSpectrumMatchesKeys()).boxed().collect(Collectors.toList()), null, false).stream().map(object -> (SpectrumMatch)object).collect(Collectors.toCollection(ArrayList::new)));
        this.initComponents();
        this.setTableProperties();
        this.updateSequenceLabel();
        String tooltip = peptideShakerGUI.getDisplayFeaturesGenerator().getPeptideModificationTooltipAsHtml((PeptideMatch)peptideShakerGUI.getIdentification().retrieveObject(peptideKey));
        this.sequenceLabel.setToolTipText(tooltip);
        this.setLocationRelativeTo(peptideShakerGUI);
        this.setVisible(true);
    }

    private void setTableProperties() {
        this.ptmSiteTableScrollPane.getViewport().setOpaque(false);
        this.ptmsTableScrollPane.getViewport().setOpaque(false);
        this.ptmSiteTable.getTableHeader().setReorderingAllowed(false);
        this.ptmsTable.getTableHeader().setReorderingAllowed(false);
        TableCellRenderer renderer = this.ptmSiteTable.getTableHeader().getDefaultRenderer();
        JLabel label = (JLabel)((Object)renderer);
        label.setHorizontalAlignment(0);
        this.ptmsTableScrollPane.setColumnHeaderView(null);
        this.ptmSiteTable.getColumn("").setCellRenderer(new AlignedTableCellRenderer(0, Color.LIGHT_GRAY));
        for (int i = 1; i < this.ptmSiteTable.getColumnCount(); ++i) {
            this.ptmSiteTable.getColumn(this.ptmSiteTable.getColumnName(i)).setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
        }
        this.ptmsTable.getColumn("").setCellRenderer(new AlignedTableCellRenderer(0, Color.LIGHT_GRAY));
        this.ptmSiteTable.getColumn("").setMinWidth(35);
        this.ptmSiteTable.getColumn("").setMaxWidth(35);
        this.ptmsTable.getColumn("").setMinWidth(35);
        this.ptmsTable.getColumn("").setMaxWidth(35);
        HashMap<Integer, Color> ptmConfidenceColorMap = new HashMap<Integer, Color>();
        ptmConfidenceColorMap.put(-1, Color.lightGray);
        ptmConfidenceColorMap.put(0, Color.RED);
        ptmConfidenceColorMap.put(1, Color.ORANGE);
        ptmConfidenceColorMap.put(2, Color.YELLOW);
        ptmConfidenceColorMap.put(3, this.peptideShakerGUI.getSparklineColor());
        this.ptmConfidenceTooltipMap = new HashMap();
        this.ptmConfidenceTooltipMap.put(-1, "Not Found");
        this.ptmConfidenceTooltipMap.put(0, "Random Assignment");
        this.ptmConfidenceTooltipMap.put(1, "Doubtful Assignment");
        this.ptmConfidenceTooltipMap.put(2, "Confident Assignment");
        this.ptmConfidenceTooltipMap.put(3, "Very Confident Assignment");
        for (int i = 1; i < this.ptmsTable.getColumnCount(); ++i) {
            this.ptmsTable.getColumn(this.ptmsTable.getColumnName(i)).setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(this.peptideShakerGUI.getSparklineColor(), ptmConfidenceColorMap, this.ptmConfidenceTooltipMap));
        }
    }

    private void updateSequenceLabel() {
        DisplayParameters displayParameters = this.peptideShakerGUI.getDisplayParameters();
        IdentificationParameters identificationParameters = this.peptideShakerGUI.getIdentificationParameters();
        ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
        SequenceProvider sequenceProvider = this.peptideShakerGUI.getSequenceProvider();
        SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
        Peptide peptide = this.peptideMatch.getPeptide();
        String[] allFixedModifications = peptide.getFixedModifications(modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
        String[] displayedFixedModifications = DisplayFeaturesGenerator.getDisplayedModifications(allFixedModifications, displayParameters.getDisplayedModifications());
        String[] confidentLocations = DisplayFeaturesGenerator.getFilteredConfidentModificationsSites(peptide, displayParameters.getDisplayedModifications());
        String[] ambiguousLocations = DisplayFeaturesGenerator.getFilteredAmbiguousModifications(peptide, displayParameters.getDisplayedModifications());
        String modName = this.ptm.getName();
        for (int i = 0; i < this.mainSelection.length; ++i) {
            int aa = i + 1;
            if (this.mainSelection[i]) {
                confidentLocations[aa] = modName;
            } else if (confidentLocations[aa].equals(modName)) {
                confidentLocations[aa] = null;
            }
            if (this.secondarySelection[i]) {
                ambiguousLocations[aa] = modName;
                continue;
            }
            if (!ambiguousLocations[aa].equals(modName)) continue;
            ambiguousLocations[aa] = null;
        }
        String taggedModifiedSequence = PeptideUtils.getTaggedModifiedSequence(peptide, modificationParameters, allFixedModifications, peptide.getIndexedVariableModifications(), confidentLocations, ambiguousLocations, null, displayedFixedModifications, true, true, true);
        this.sequenceLabel.setText(taggedModifiedSequence);
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.peptidePanel = new JPanel();
        this.sequenceLabel = new JLabel();
        this.ptmSitePanel = new JPanel();
        this.ptmSiteTableScrollPane = new JScrollPane();
        this.ptmSiteTable = new JTable();
        this.ptmsTableScrollPane = new JScrollPane();
        this.ptmsTable = new JTable();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.openDialogHelpJButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("PTM Site Assignment");
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.peptidePanel.setBorder(BorderFactory.createTitledBorder("Peptide"));
        this.peptidePanel.setOpaque(false);
        this.sequenceLabel.setText("Peptide Sequence");
        GroupLayout peptidePanelLayout = new GroupLayout(this.peptidePanel);
        this.peptidePanel.setLayout(peptidePanelLayout);
        peptidePanelLayout.setHorizontalGroup(peptidePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptidePanelLayout.createSequentialGroup().addGap(183, 183, 183).addComponent(this.sequenceLabel, -1, 259, Short.MAX_VALUE).addGap(225, 225, 225)));
        peptidePanelLayout.setVerticalGroup(peptidePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptidePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.sequenceLabel).addContainerGap(14, Short.MAX_VALUE)));
        this.ptmSitePanel.setBorder(BorderFactory.createTitledBorder("Potential Modification Sites"));
        this.ptmSitePanel.setOpaque(false);
        this.ptmSiteTableScrollPane.setVerticalScrollBarPolicy(22);
        this.ptmSiteTable.setModel(new SiteSelectionTable());
        this.ptmSiteTable.setFillsViewportHeight(true);
        this.ptmSiteTable.setOpaque(false);
        this.ptmSiteTableScrollPane.setViewportView(this.ptmSiteTable);
        this.ptmsTableScrollPane.setVerticalScrollBarPolicy(22);
        this.ptmsTable.setModel(new PtmTable());
        this.ptmsTable.setOpaque(false);
        this.ptmsTableScrollPane.setViewportView(this.ptmsTable);
        GroupLayout ptmSitePanelLayout = new GroupLayout(this.ptmSitePanel);
        this.ptmSitePanel.setLayout(ptmSitePanelLayout);
        ptmSitePanelLayout.setHorizontalGroup(ptmSitePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, ptmSitePanelLayout.createSequentialGroup().addContainerGap().addGroup(ptmSitePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.ptmsTableScrollPane, GroupLayout.Alignment.LEADING, -1, 647, Short.MAX_VALUE).addComponent(this.ptmSiteTableScrollPane, GroupLayout.Alignment.LEADING, -1, 647, Short.MAX_VALUE)).addContainerGap()));
        ptmSitePanelLayout.setVerticalGroup(ptmSitePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ptmSitePanelLayout.createSequentialGroup().addComponent(this.ptmSiteTableScrollPane, -2, 64, -2).addGap(2, 2, 2).addComponent(this.ptmsTableScrollPane, -1, 318, Short.MAX_VALUE).addContainerGap()));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationSiteInferenceDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationSiteInferenceDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Help");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationSiteInferenceDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationSiteInferenceDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationSiteInferenceDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.ptmSitePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.peptidePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.openDialogHelpJButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 510, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.peptidePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ptmSitePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.openDialogHelpJButton, -1, -1, Short.MAX_VALUE).addComponent(this.cancelButton, -1, -1, Short.MAX_VALUE).addComponent(this.okButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        boolean changed = false;
        if (changed) {
            try {
                Identification identification = this.peptideShakerGUI.getIdentification();
                ModificationLocalizationScorer ptmScorer = new ModificationLocalizationScorer();
                SequenceProvider sequenceProvider = this.peptideShakerGUI.getSequenceProvider();
                IdentificationParameters identificationParameters = this.peptideShakerGUI.getIdentificationParameters();
                identification.getProteinMatches(this.peptideMatch.getKey()).stream().map(key -> identification.getProteinMatch((long)key)).forEach(proteinMatch -> ptmScorer.scorePTMs(identification, (ProteinMatch)proteinMatch, identificationParameters, false, this.modificationFactory, sequenceProvider, null));
            }
            catch (Exception e) {
                this.peptideShakerGUI.catchException(e);
            }
        }
        this.dispose();
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.peptideShakerGUI, this.getClass().getResource("/helpFiles/PtmSiteInferenceDialog.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "PTM Site Assignment - Help");
        this.setCursor(new Cursor(0));
    }

    private class SiteSelectionTable
    extends DefaultTableModel {
        private SiteSelectionTable() {
        }

        @Override
        public int getRowCount() {
            return 2;
        }

        @Override
        public int getColumnCount() {
            return ModificationSiteInferenceDialog.this.peptideMatch.getPeptide().getSequence().length() + 1;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "";
                }
            }
            return "" + ModificationSiteInferenceDialog.this.peptideMatch.getPeptide().getSequence().charAt(column - 1) + column;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                if (row == 0) {
                    return "S1";
                }
                return "S2";
            }
            if (row == 0) {
                return ModificationSiteInferenceDialog.this.mainSelection[column - 1];
            }
            if (row == 1) {
                return ModificationSiteInferenceDialog.this.secondarySelection[column - 1];
            }
            return null;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            return Boolean.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (row == 0) {
                boolean bl = ((ModificationSiteInferenceDialog)ModificationSiteInferenceDialog.this).mainSelection[column - 1] = !ModificationSiteInferenceDialog.this.mainSelection[column - 1];
                if (ModificationSiteInferenceDialog.this.mainSelection[column - 1] && ModificationSiteInferenceDialog.this.secondarySelection[column - 1]) {
                    ((ModificationSiteInferenceDialog)ModificationSiteInferenceDialog.this).secondarySelection[column - 1] = false;
                }
                ModificationSiteInferenceDialog.this.updateSequenceLabel();
            } else if (row == 1) {
                boolean bl = ((ModificationSiteInferenceDialog)ModificationSiteInferenceDialog.this).secondarySelection[column - 1] = !ModificationSiteInferenceDialog.this.secondarySelection[column - 1];
                if (ModificationSiteInferenceDialog.this.mainSelection[column - 1] && ModificationSiteInferenceDialog.this.secondarySelection[column - 1]) {
                    ((ModificationSiteInferenceDialog)ModificationSiteInferenceDialog.this).mainSelection[column - 1] = false;
                }
                ModificationSiteInferenceDialog.this.updateSequenceLabel();
            }
            this.fireTableDataChanged();
        }
    }

    private class PtmTable
    extends DefaultTableModel {
        private PtmTable() {
        }

        @Override
        public int getRowCount() {
            return ModificationSiteInferenceDialog.this.psms.size();
        }

        @Override
        public int getColumnCount() {
            return ModificationSiteInferenceDialog.this.peptideMatch.getPeptide().getSequence().length() + 1;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "";
                }
            }
            return "" + ModificationSiteInferenceDialog.this.peptideMatch.getPeptide().getSequence().charAt(column - 1) + column;
        }

        @Override
        public Object getValueAt(int row, int column) {
            try {
                ModificationScoring psmScoring;
                if (column == 0) {
                    return row + 1;
                }
                int psmNumber = row;
                PSModificationScores psmScores = (PSModificationScores)((SpectrumMatch)ModificationSiteInferenceDialog.this.psms.get(psmNumber)).getUrParam(new PSModificationScores());
                if (psmScores != null && (psmScoring = psmScores.getModificationScoring(ModificationSiteInferenceDialog.this.ptm.getName())) != null) {
                    int site = column;
                    if (psmScoring.getConfidentPtmLocations().contains(site)) {
                        return psmScoring.getLocalizationConfidence(site);
                    }
                    return -1;
                }
                return 0;
            }
            catch (Exception e) {
                ModificationSiteInferenceDialog.this.peptideShakerGUI.catchException(e);
                return "";
            }
        }

        public Class getColumnClass(int columnIndex) {
            return Integer.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

