/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.parameters;

import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;

public class ProjectDetailsDialog
extends JDialog {
    private final PeptideShakerGUI peptideShakerGUI;
    private ProgressDialogX progressDialog;
    private JPanel backgroundPanel;
    private JButton closeButton;
    private JPanel detailsPanel;
    private JEditorPane projectDetailsJEditorPane;
    private JScrollPane projectDetailsJScrollPane;

    public ProjectDetailsDialog(PeptideShakerGUI peptideShakerGUI) {
        super((Frame)peptideShakerGUI, true);
        this.initComponents();
        this.peptideShakerGUI = peptideShakerGUI;
        this.setTitle("Project Properties - " + peptideShakerGUI.getProjectParameters().getProjectUniqueName());
        this.setUpGui();
    }

    private void setUpGui() {
        this.progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setTitle("Loading Project Details. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ProjectDetailsDialog.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("ProjectDetailsLoadingThread"){

            @Override
            public void run() {
                boolean newInformation = true;
                if (ProjectDetailsDialog.this.peptideShakerGUI.getProjectDetails().hasIdentificationAlgorithms()) {
                    newInformation = false;
                }
                String report = ProjectDetailsDialog.this.peptideShakerGUI.getExtendedProjectReport();
                if (newInformation) {
                    ProjectDetailsDialog.this.peptideShakerGUI.setDataSaved(false);
                }
                if (report == null) {
                    ProjectDetailsDialog.this.projectDetailsJEditorPane.setText("Project properties not availale.");
                } else {
                    ProjectDetailsDialog.this.projectDetailsJEditorPane.setText(report);
                    ProjectDetailsDialog.this.projectDetailsJEditorPane.setCaretPosition(0);
                }
                ProjectDetailsDialog.this.progressDialog.setRunFinished();
                ProjectDetailsDialog.this.setLocationRelativeTo(ProjectDetailsDialog.this.peptideShakerGUI);
                ProjectDetailsDialog.this.setVisible(true);
            }
        }.start();
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.closeButton = new JButton();
        this.detailsPanel = new JPanel();
        this.projectDetailsJScrollPane = new JScrollPane();
        this.projectDetailsJEditorPane = new JEditorPane();
        this.setDefaultCloseOperation(2);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectDetailsDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.detailsPanel.setBorder(BorderFactory.createTitledBorder("Details"));
        this.detailsPanel.setOpaque(false);
        this.projectDetailsJEditorPane.setEditable(false);
        this.projectDetailsJEditorPane.setContentType("text/html");
        this.projectDetailsJScrollPane.setViewportView(this.projectDetailsJEditorPane);
        GroupLayout detailsPanelLayout = new GroupLayout(this.detailsPanel);
        this.detailsPanel.setLayout(detailsPanelLayout);
        detailsPanelLayout.setHorizontalGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(detailsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.projectDetailsJScrollPane, -1, 730, Short.MAX_VALUE).addContainerGap()));
        detailsPanelLayout.setVerticalGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(detailsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.projectDetailsJScrollPane, -1, 508, Short.MAX_VALUE).addContainerGap()));
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.detailsPanel, GroupLayout.Alignment.LEADING, -2, -1, Short.MAX_VALUE).addComponent(this.closeButton)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.detailsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

