/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.parameters;

import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.IonFactory;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.spectrum.IonLabelColorTableModel;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesColorTableCellRenderer;

public class SpectrumColorsDialog
extends JDialog {
    private final HashMap<Ion.IonType, HashSet<Integer>> iontypes;
    private final HashSet<String> neutralLosses;
    private final PeptideShakerGUI peptideShakerGUI;
    private JLabel annotatedLabel;
    private JPanel annotatedPeakColorPanel;
    private JSpinner annotatedPeakWidthSpinner;
    private JLabel annotatedWidthLabel;
    private JPanel annotationColorsPanel;
    private JLabel backgroundLabel;
    private JPanel backgroundPanel;
    private JPanel backgroundPeakColorPanel;
    private JSpinner backgroundPeakWidthSpinner;
    private JLabel backgroundWidthLabel;
    private JScrollPane colorsScrollPane;
    private JTable colorsTable;
    private JButton helpJButton;
    private JLabel mirroredPeakColorLabel;
    private JPanel mirroredPeakColorPanel;
    private JButton okButton;
    private JPanel peakColorsPanel;

    public SpectrumColorsDialog(PeptideShakerGUI peptideShakerGUI) {
        super((Frame)peptideShakerGUI, true);
        this.peptideShakerGUI = peptideShakerGUI;
        this.iontypes = peptideShakerGUI.getIdentificationParameters().getAnnotationParameters().getIonTypes();
        ModificationParameters modificationParameters = peptideShakerGUI.getIdentificationParameters().getSearchParameters().getModificationParameters();
        this.neutralLosses = IonFactory.getNeutralLosses(modificationParameters);
        this.initComponents();
        this.setUpGui();
        this.setLocationRelativeTo(peptideShakerGUI);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.annotatedPeakColorPanel.setBackground(this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumAnnotatedPeakColor());
        this.backgroundPeakColorPanel.setBackground(this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumBackgroundPeakColor());
        this.mirroredPeakColorPanel.setBackground(this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumAnnotatedMirroredPeakColor());
        this.annotatedPeakWidthSpinner.setValue(Float.valueOf(this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumAnnotatedPeakWidth()));
        this.backgroundPeakWidthSpinner.setValue(Float.valueOf(this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumBackgroundPeakWidth()));
        this.colorsTable.getTableHeader().setReorderingAllowed(false);
        this.colorsScrollPane.getViewport().setOpaque(false);
        this.colorsTable.getColumn(" ").setMaxWidth(50);
        this.colorsTable.getColumn(" ").setMinWidth(50);
        this.colorsTable.getColumn("  ").setMaxWidth(40);
        this.colorsTable.getColumn("  ").setMinWidth(40);
        this.colorsTable.getColumn("  ").setCellRenderer((TableCellRenderer)new JSparklinesColorTableCellRenderer());
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.okButton = new JButton();
        this.annotationColorsPanel = new JPanel();
        this.colorsScrollPane = new JScrollPane();
        this.colorsTable = new JTable();
        this.peakColorsPanel = new JPanel();
        this.annotatedLabel = new JLabel();
        this.backgroundLabel = new JLabel();
        this.annotatedPeakColorPanel = new JPanel();
        this.backgroundPeakColorPanel = new JPanel();
        this.annotatedWidthLabel = new JLabel();
        this.backgroundWidthLabel = new JLabel();
        this.annotatedPeakWidthSpinner = new JSpinner();
        this.backgroundPeakWidthSpinner = new JSpinner();
        this.mirroredPeakColorLabel = new JLabel();
        this.mirroredPeakColorPanel = new JPanel();
        this.helpJButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Spectrum Colors");
        this.setMinimumSize(new Dimension(520, 500));
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpectrumColorsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.annotationColorsPanel.setBorder(BorderFactory.createTitledBorder("Annotation Colors"));
        this.annotationColorsPanel.setOpaque(false);
        this.colorsTable.setModel(new IonLabelColorTableModel(this.iontypes, this.neutralLosses));
        this.colorsTable.setOpaque(false);
        this.colorsTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                SpectrumColorsDialog.this.colorsTableMouseMoved(evt);
            }
        });
        this.colorsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                SpectrumColorsDialog.this.colorsTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SpectrumColorsDialog.this.colorsTableMouseReleased(evt);
            }
        });
        this.colorsScrollPane.setViewportView(this.colorsTable);
        GroupLayout annotationColorsPanelLayout = new GroupLayout(this.annotationColorsPanel);
        this.annotationColorsPanel.setLayout(annotationColorsPanelLayout);
        annotationColorsPanelLayout.setHorizontalGroup(annotationColorsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(annotationColorsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.colorsScrollPane, -2, 0, Short.MAX_VALUE).addContainerGap()));
        annotationColorsPanelLayout.setVerticalGroup(annotationColorsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(annotationColorsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.colorsScrollPane, -1, 247, Short.MAX_VALUE).addContainerGap()));
        this.peakColorsPanel.setBorder(BorderFactory.createTitledBorder("Peak Colors"));
        this.peakColorsPanel.setOpaque(false);
        this.annotatedLabel.setHorizontalAlignment(2);
        this.annotatedLabel.setText("Annotated Peak Color");
        this.backgroundLabel.setText("Backgrond Peak Color");
        this.annotatedPeakColorPanel.setBorder(BorderFactory.createEtchedBorder());
        this.annotatedPeakColorPanel.setForeground(new Color(255, 255, 255));
        this.annotatedPeakColorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SpectrumColorsDialog.this.annotatedPeakColorPanelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpectrumColorsDialog.this.annotatedPeakColorPanelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpectrumColorsDialog.this.annotatedPeakColorPanelMouseExited(evt);
            }
        });
        GroupLayout annotatedPeakColorPanelLayout = new GroupLayout(this.annotatedPeakColorPanel);
        this.annotatedPeakColorPanel.setLayout(annotatedPeakColorPanelLayout);
        annotatedPeakColorPanelLayout.setHorizontalGroup(annotatedPeakColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 27, Short.MAX_VALUE));
        annotatedPeakColorPanelLayout.setVerticalGroup(annotatedPeakColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 24, Short.MAX_VALUE));
        this.backgroundPeakColorPanel.setBorder(BorderFactory.createEtchedBorder());
        this.backgroundPeakColorPanel.setForeground(new Color(255, 255, 255));
        this.backgroundPeakColorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SpectrumColorsDialog.this.backgroundPeakColorPanelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpectrumColorsDialog.this.backgroundPeakColorPanelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpectrumColorsDialog.this.backgroundPeakColorPanelMouseExited(evt);
            }
        });
        GroupLayout backgroundPeakColorPanelLayout = new GroupLayout(this.backgroundPeakColorPanel);
        this.backgroundPeakColorPanel.setLayout(backgroundPeakColorPanelLayout);
        backgroundPeakColorPanelLayout.setHorizontalGroup(backgroundPeakColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 27, Short.MAX_VALUE));
        backgroundPeakColorPanelLayout.setVerticalGroup(backgroundPeakColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 24, Short.MAX_VALUE));
        this.annotatedWidthLabel.setText("Annotated Peak Width");
        this.backgroundWidthLabel.setText("Background Peak Width");
        this.annotatedPeakWidthSpinner.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(1.0f), null, Float.valueOf(1.0f)));
        this.annotatedPeakWidthSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SpectrumColorsDialog.this.annotatedPeakWidthSpinnerStateChanged(evt);
            }
        });
        this.backgroundPeakWidthSpinner.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(1.0f), null, Float.valueOf(1.0f)));
        this.backgroundPeakWidthSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SpectrumColorsDialog.this.backgroundPeakWidthSpinnerStateChanged(evt);
            }
        });
        this.mirroredPeakColorLabel.setHorizontalAlignment(2);
        this.mirroredPeakColorLabel.setText("Annotated Mirrored Peak Color");
        this.mirroredPeakColorPanel.setBorder(BorderFactory.createEtchedBorder());
        this.mirroredPeakColorPanel.setForeground(new Color(255, 255, 255));
        this.mirroredPeakColorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SpectrumColorsDialog.this.mirroredPeakColorPanelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpectrumColorsDialog.this.mirroredPeakColorPanelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpectrumColorsDialog.this.mirroredPeakColorPanelMouseExited(evt);
            }
        });
        GroupLayout mirroredPeakColorPanelLayout = new GroupLayout(this.mirroredPeakColorPanel);
        this.mirroredPeakColorPanel.setLayout(mirroredPeakColorPanelLayout);
        mirroredPeakColorPanelLayout.setHorizontalGroup(mirroredPeakColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 27, Short.MAX_VALUE));
        mirroredPeakColorPanelLayout.setVerticalGroup(mirroredPeakColorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        GroupLayout peakColorsPanelLayout = new GroupLayout(this.peakColorsPanel);
        this.peakColorsPanel.setLayout(peakColorsPanelLayout);
        peakColorsPanelLayout.setHorizontalGroup(peakColorsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peakColorsPanelLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(peakColorsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(peakColorsPanelLayout.createSequentialGroup().addComponent(this.backgroundLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.backgroundPeakColorPanel, -2, -1, -2)).addGroup(GroupLayout.Alignment.LEADING, peakColorsPanelLayout.createSequentialGroup().addComponent(this.mirroredPeakColorLabel, -2, 150, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.mirroredPeakColorPanel, -2, -1, -2)).addGroup(GroupLayout.Alignment.LEADING, peakColorsPanelLayout.createSequentialGroup().addComponent(this.annotatedLabel, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.annotatedPeakColorPanel, -2, -1, -2))).addGap(50, 50, 50).addGroup(peakColorsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(peakColorsPanelLayout.createSequentialGroup().addComponent(this.annotatedWidthLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.annotatedPeakWidthSpinner, -2, 55, -2)).addGroup(peakColorsPanelLayout.createSequentialGroup().addComponent(this.backgroundWidthLabel).addGap(18, 18, 18).addComponent(this.backgroundPeakWidthSpinner, -2, 55, -2))).addGap(21, 21, 21)));
        peakColorsPanelLayout.linkSize(0, this.annotatedLabel, this.annotatedWidthLabel, this.backgroundLabel, this.backgroundWidthLabel);
        peakColorsPanelLayout.setVerticalGroup(peakColorsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peakColorsPanelLayout.createSequentialGroup().addContainerGap().addGroup(peakColorsPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.annotatedLabel).addComponent(this.annotatedPeakColorPanel, -2, -1, -2).addComponent(this.annotatedWidthLabel).addComponent(this.annotatedPeakWidthSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(peakColorsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPeakColorPanel, -2, -1, -2).addGroup(peakColorsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.backgroundWidthLabel).addComponent(this.backgroundPeakWidthSpinner, -2, -1, -2)).addComponent(this.backgroundLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(peakColorsPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.mirroredPeakColorLabel).addComponent(this.mirroredPeakColorPanel, -2, -1, -2)).addContainerGap()));
        peakColorsPanelLayout.linkSize(1, this.annotatedLabel, this.annotatedPeakColorPanel, this.annotatedPeakWidthSpinner, this.annotatedWidthLabel, this.backgroundLabel, this.backgroundPeakColorPanel, this.backgroundPeakWidthSpinner, this.backgroundWidthLabel);
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpectrumColorsDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpectrumColorsDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpectrumColorsDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.helpJButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2)).addComponent(this.peakColorsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.annotationColorsPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.annotationColorsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peakColorsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.okButton).addComponent(this.helpJButton, -2, 24, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        UtilitiesUserParameters.saveUserParameters(this.peptideShakerGUI.getUtilitiesUserParameters());
        this.dispose();
    }

    private void colorsTableMouseMoved(MouseEvent evt) {
        int row = this.colorsTable.rowAtPoint(evt.getPoint());
        int column = this.colorsTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            if (column == this.colorsTable.getColumn("  ").getModelIndex()) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void colorsTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void colorsTableMouseReleased(MouseEvent evt) {
        Color newColor;
        int row = this.colorsTable.rowAtPoint(evt.getPoint());
        int column = this.colorsTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column == this.colorsTable.getColumn("  ").getModelIndex() && (newColor = JColorChooser.showDialog(this, "Pick a Color", (Color)this.colorsTable.getValueAt(row, column))) != null) {
            int[] selectedRows = this.colorsTable.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                SpectrumPanel.setIonColor(((IonLabelColorTableModel)this.colorsTable.getModel()).getIonAtRow(selectedRows[i]), newColor);
            }
            ((IonLabelColorTableModel)this.colorsTable.getModel()).fireTableDataChanged();
            this.peptideShakerGUI.updateSpectrumAnnotations();
        }
    }

    private void annotatedPeakColorPanelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void annotatedPeakColorPanelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void annotatedPeakColorPanelMouseClicked(MouseEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Pick a Color", this.annotatedPeakColorPanel.getBackground());
        if (newColor != null) {
            this.annotatedPeakColorPanel.setBackground(newColor);
            this.peptideShakerGUI.getUtilitiesUserParameters().setSpectrumAnnotatedPeakColor(this.annotatedPeakColorPanel.getBackground());
            this.peptideShakerGUI.updateSpectrumAnnotations();
            this.annotatedPeakColorPanel.repaint();
        }
    }

    private void backgroundPeakColorPanelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void backgroundPeakColorPanelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void backgroundPeakColorPanelMouseClicked(MouseEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Pick a Color", this.backgroundPeakColorPanel.getBackground());
        if (newColor != null) {
            newColor = new Color(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), 50);
            this.backgroundPeakColorPanel.setBackground(newColor);
            this.peptideShakerGUI.getUtilitiesUserParameters().setSpectrumBackgroundPeakColor(this.backgroundPeakColorPanel.getBackground());
            this.peptideShakerGUI.updateSpectrumAnnotations();
            this.backgroundPeakColorPanel.repaint();
        }
    }

    private void annotatedPeakWidthSpinnerStateChanged(ChangeEvent evt) {
        this.peptideShakerGUI.getUtilitiesUserParameters().setSpectrumAnnotatedPeakWidth(((Float)this.annotatedPeakWidthSpinner.getValue()).floatValue());
        this.peptideShakerGUI.updateSpectrumAnnotations();
    }

    private void backgroundPeakWidthSpinnerStateChanged(ChangeEvent evt) {
        this.peptideShakerGUI.getUtilitiesUserParameters().setSpectrumBackgroundPeakWidth(((Float)this.backgroundPeakWidthSpinner.getValue()).floatValue());
        this.peptideShakerGUI.updateSpectrumAnnotations();
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.peptideShakerGUI, this.getClass().getResource("/helpFiles/SpectrumColorsDialog.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Spectrum Colors - Help");
        this.setCursor(new Cursor(0));
    }

    private void mirroredPeakColorPanelMouseClicked(MouseEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Pick a Color", this.mirroredPeakColorPanel.getBackground());
        if (newColor != null) {
            this.mirroredPeakColorPanel.setBackground(newColor);
            this.peptideShakerGUI.getUtilitiesUserParameters().setSpectrumAnnotatedMirroredPeakColor(this.mirroredPeakColorPanel.getBackground());
            this.peptideShakerGUI.updateSpectrumAnnotations();
            this.annotatedPeakColorPanel.repaint();
        }
    }

    private void mirroredPeakColorPanelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void mirroredPeakColorPanelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }
}

