/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.protein_inference;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.experiment.io.biology.protein.Header;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.TableProperties;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.google.common.collect.Sets;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import eu.isas.peptideshaker.gui.protein_inference.ProteinInferenceGraphPanel;
import eu.isas.peptideshaker.gui.tablemodels.ProteinTableModel;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.data.Chromosome;
import no.uib.jsparklines.extra.ChromosomeTableCellRenderer;
import no.uib.jsparklines.extra.HtmlLinksRenderer;
import no.uib.jsparklines.extra.NimbusCheckBoxRenderer;
import no.uib.jsparklines.extra.TrueFalseIconRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesIntegerIconTableCellRenderer;
import org.jfree.chart.plot.PlotOrientation;

public class ProteinInferenceDialog
extends JDialog {
    private ProteinMatch inspectedMatch;
    private String[] accessions;
    private long[] uniqueMatches;
    private long[] associatedMatches;
    private PeptideShakerGUI peptideShakerGUI;
    private GeneMaps geneMaps;
    private ArrayList<String> candidateProteinsTableToolTips;
    private ArrayList<String> uniqueHitsTableToolTips;
    private ArrayList<String> relatedHitsTableToolTips;
    private Identification identification;
    private String previousMainMatch;
    private JPanel backgroundPanel;
    private JPanel detailsPanel;
    private JPanel graphInnerPanel;
    private JPanel graphPanel;
    private JComboBox groupClassJComboBox;
    private JPanel groupDetalsJPanel;
    private JButton helpJButton;
    private JButton okButton;
    private JPanel proteinMatchJPanel;
    private JScrollPane proteinMatchJScrollPane;
    private JTable proteinMatchTable;
    private JPanel relatedHitsJPanel;
    private JScrollPane relatedHitsJScrollPane;
    private JTable relatedHitsTable;
    private JTabbedPane tabbedPane;
    private JPanel uniqueHitsJPanel;
    private JScrollPane uniqueHitsJScrollPane;
    private JTable uniqueHitsTable;

    public ProteinInferenceDialog(PeptideShakerGUI peptideShakerGUI, GeneMaps geneMaps, long matchKey, Identification identification) {
        super((Frame)peptideShakerGUI, true);
        this.identification = identification;
        this.peptideShakerGUI = peptideShakerGUI;
        this.geneMaps = geneMaps;
        try {
            this.inspectedMatch = identification.getProteinMatch(matchKey);
            this.previousMainMatch = this.inspectedMatch.getLeadingAccession();
        }
        catch (Exception e) {
            peptideShakerGUI.catchException(e);
            this.dispose();
        }
        this.accessions = this.inspectedMatch.getAccessions();
        this.uniqueMatches = Arrays.stream(this.accessions).mapToLong(accession -> ExperimentObject.asLong(accession)).filter(key -> identification.getProteinIdentification().contains(key)).toArray();
        this.associatedMatches = Arrays.stream(this.accessions).flatMap(accession -> identification.getProteinMap().get(accession).stream()).mapToLong(key -> key).distinct().toArray();
        this.initComponents();
        this.tabbedPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.proteinMatchJScrollPane.getViewport().setOpaque(false);
        this.uniqueHitsJScrollPane.getViewport().setOpaque(false);
        this.relatedHitsJScrollPane.getViewport().setOpaque(false);
        this.groupClassJComboBox.setRenderer(new AlignedListCellRenderer(0));
        PSParameter psParameter = new PSParameter();
        try {
            psParameter = (PSParameter)this.inspectedMatch.getUrParam(psParameter);
            this.groupClassJComboBox.setSelectedIndex(psParameter.getProteinInferenceGroupClass());
        }
        catch (Exception e) {
            peptideShakerGUI.catchException(e);
        }
        this.setColumnProperies();
        ((TitledBorder)this.proteinMatchJPanel.getBorder()).setTitle("Candidate Proteins (" + this.accessions.length + ")");
        ((TitledBorder)this.uniqueHitsJPanel.getBorder()).setTitle("Unique Hits (" + this.uniqueMatches.length + ")");
        ((TitledBorder)this.relatedHitsJPanel.getBorder()).setTitle("Related Hits (" + this.associatedMatches.length + ")");
        this.drawGraph();
        this.setLocationRelativeTo(peptideShakerGUI);
        this.setVisible(true);
    }

    private void drawGraph() {
        ArrayList<String> nodes = new ArrayList<String>();
        HashMap<String, String> nodeProperties = new HashMap<String, String>();
        HashMap<String, String> edgeProperties = new HashMap<String, String>();
        HashMap<String, String> nodeToolTips = new HashMap<String, String>();
        HashMap<String, ArrayList<String>> edges = new HashMap<String, ArrayList<String>>();
        ArrayList<String> selectedNodes = new ArrayList<String>();
        long[] peptideKeys = this.inspectedMatch.getPeptideMatchesKeys();
        try {
            for (long tempPeptideKey : peptideKeys) {
                this.addPeptide(tempPeptideKey, nodeToolTips, nodes, nodeProperties, selectedNodes, edges, edgeProperties);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.graphInnerPanel.add(new ProteinInferenceGraphPanel(this, this.graphInnerPanel, this.peptideShakerGUI.getNormalIcon(), this.peptideShakerGUI.getWaitingIcon(), this.peptideShakerGUI.getLastSelectedFolder(), nodes, edges, nodeProperties, edgeProperties, nodeToolTips, selectedNodes));
    }

    private void addPeptide(long peptideKey, HashMap<String, String> nodeToolTips, ArrayList<String> nodes, HashMap<String, String> nodeProperties, ArrayList<String> selectedNodes, HashMap<String, ArrayList<String>> edges, HashMap<String, String> edgeProperties) {
        ProteinDetailsProvider proteinDetailsProvider = this.peptideShakerGUI.getProteinDetailsProvider();
        SequenceProvider sequenceProvider = this.peptideShakerGUI.getSequenceProvider();
        PeptideMatch peptideMatch = this.identification.getPeptideMatch(peptideKey);
        String peptideNodeName = "Peptide " + peptideKey;
        if (!nodes.contains(peptideNodeName)) {
            HashSet accessionsSet = Sets.newHashSet((Object[])this.accessions);
            PSParameter peptideMatchParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
            String matchValidationLevel = "Validation: " + (Object)((Object)peptideMatchParameter.getMatchValidationLevel());
            String peptideTooltip = this.peptideShakerGUI.getDisplayFeaturesGenerator().getTaggedPeptideSequence(peptideMatch, true, false, true);
            peptideTooltip = "<html>" + peptideTooltip + "<br><br>" + matchValidationLevel + "</html>";
            nodeToolTips.put(peptideNodeName, peptideTooltip);
            nodes.add(peptideNodeName);
            nodeProperties.put(peptideNodeName, "" + peptideMatchParameter.getMatchValidationLevel().getIndex());
            for (String tempProteinAccession : peptideMatch.getPeptide().getProteinMapping().keySet()) {
                ArrayList<String> tempEdges;
                String proteinNodeKey = "Protein " + tempProteinAccession;
                if (!nodes.contains(proteinNodeKey)) {
                    nodes.add(proteinNodeKey);
                    if (accessionsSet.contains(tempProteinAccession)) {
                        selectedNodes.add(proteinNodeKey);
                    }
                    String nodeProperty = "";
                    long tempKey = ExperimentObject.asLong(tempProteinAccession);
                    ProteinMatch proteinMatch = this.identification.getProteinMatch(tempKey);
                    if (proteinMatch != null) {
                        PSParameter proteinMatchParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy);
                        nodeProperty = nodeProperty + proteinMatchParameter.getMatchValidationLevel().getIndex();
                        matchValidationLevel = "Validation: " + (Object)((Object)proteinMatchParameter.getMatchValidationLevel());
                    } else {
                        nodeProperty = nodeProperty + -1;
                        matchValidationLevel = "Validation: (not available)";
                    }
                    String proteinEvidenceLevel = null;
                    Integer level = proteinDetailsProvider.getProteinEvidence(tempProteinAccession);
                    if (level != null) {
                        nodeProperty = nodeProperty + "|" + level;
                        try {
                            proteinEvidenceLevel = "Evidence: " + Header.getProteinEvidencAsString(level);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (proteinEvidenceLevel == null) {
                        proteinEvidenceLevel = "Evidence: (not available)";
                    }
                    nodeProperties.put(proteinNodeKey, nodeProperty);
                    nodeToolTips.put(proteinNodeKey, "<html>" + tempProteinAccession + "<br>" + proteinDetailsProvider.getSimpleDescription(tempProteinAccession) + "<br><br>" + matchValidationLevel + "<br>" + proteinEvidenceLevel + "<html>");
                    if (proteinMatch != null) {
                        long[] secondaryPeptides;
                        for (long tempPeptideKey2 : secondaryPeptides = proteinMatch.getPeptideMatchesKeys()) {
                            this.addPeptide(tempPeptideKey2, nodeToolTips, nodes, nodeProperties, selectedNodes, edges, edgeProperties);
                        }
                    } else if (this.identification.getProteinMap().containsKey(tempProteinAccession)) {
                        this.identification.getProteinMap().get(tempProteinAccession).stream().flatMap(key -> Arrays.stream(this.identification.getProteinMatch((long)key).getPeptideMatchesKeys()).boxed()).distinct().forEach(tempPeptideKey -> this.addPeptide((long)tempPeptideKey, nodeToolTips, nodes, nodeProperties, selectedNodes, edges, edgeProperties));
                    }
                }
                if ((tempEdges = edges.get(peptideNodeName)) == null) {
                    tempEdges = new ArrayList();
                }
                if (!tempEdges.contains(proteinNodeKey)) {
                    tempEdges.add(proteinNodeKey);
                    boolean enzymatic = false;
                    DigestionParameters digestionPreferences = this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getDigestionParameters();
                    if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
                        enzymatic = PeptideUtils.isEnzymatic(peptideMatch.getPeptide(), tempProteinAccession, sequenceProvider.getSequence(tempProteinAccession), digestionPreferences.getEnzymes());
                    }
                    edgeProperties.put(peptideNodeName + "|" + proteinNodeKey, Boolean.toString(enzymatic));
                }
                edges.put(peptideNodeName, tempEdges);
            }
        }
    }

    private void setColumnProperies() {
        this.proteinMatchTable.getTableHeader().setReorderingAllowed(false);
        this.uniqueHitsTable.getTableHeader().setReorderingAllowed(false);
        this.relatedHitsTable.getTableHeader().setReorderingAllowed(false);
        this.proteinMatchTable.getColumn("  ").setMinWidth(50);
        this.proteinMatchTable.getColumn("  ").setMaxWidth(50);
        this.proteinMatchTable.getColumn("Gene").setMinWidth(90);
        this.proteinMatchTable.getColumn("Gene").setMaxWidth(90);
        this.proteinMatchTable.getColumn("Chr").setMinWidth(90);
        this.proteinMatchTable.getColumn("Chr").setMaxWidth(90);
        this.proteinMatchTable.getColumn("Evidence").setMinWidth(90);
        this.proteinMatchTable.getColumn("Evidence").setMaxWidth(90);
        this.proteinMatchTable.getColumn("Enz").setMinWidth(50);
        this.proteinMatchTable.getColumn("Enz").setMaxWidth(50);
        Integer width = ProteinTableModel.getPreferredAccessionColumnWidth(this.proteinMatchTable, this.proteinMatchTable.getColumn("Accession").getModelIndex(), 6, this.peptideShakerGUI.getMetrics().getMaxProteinAccessionLength());
        if (width != null) {
            this.proteinMatchTable.getColumn("Accession").setMinWidth(width);
            this.proteinMatchTable.getColumn("Accession").setMaxWidth(width);
        } else {
            this.proteinMatchTable.getColumn("Accession").setMinWidth(15);
            this.proteinMatchTable.getColumn("Accession").setMaxWidth(Integer.MAX_VALUE);
        }
        this.uniqueHitsTable.getColumn(" ").setMaxWidth(30);
        this.relatedHitsTable.getColumn(" ").setMaxWidth(30);
        this.uniqueHitsTable.getColumn(" ").setMinWidth(30);
        this.relatedHitsTable.getColumn(" ").setMinWidth(30);
        this.proteinMatchTable.getColumn("").setMaxWidth(50);
        this.uniqueHitsTable.getColumn("").setMaxWidth(50);
        this.relatedHitsTable.getColumn("").setMaxWidth(50);
        this.proteinMatchTable.getColumn("").setMinWidth(50);
        this.uniqueHitsTable.getColumn("").setMinWidth(50);
        this.relatedHitsTable.getColumn("").setMinWidth(50);
        this.uniqueHitsTable.getColumn("Confidence").setMaxWidth(90);
        this.uniqueHitsTable.getColumn("Confidence").setMinWidth(90);
        this.relatedHitsTable.getColumn("Confidence").setMaxWidth(90);
        this.relatedHitsTable.getColumn("Confidence").setMinWidth(90);
        this.proteinMatchTable.getColumn("  ").setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
        this.proteinMatchTable.getColumn("Accession").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(TableProperties.getSelectedRowHtmlTagFontColor(), TableProperties.getNotSelectedRowHtmlTagFontColor()));
        this.proteinMatchTable.getColumn("Chr").setCellRenderer((TableCellRenderer)new ChromosomeTableCellRenderer(Color.WHITE, Color.BLACK));
        this.proteinMatchTable.getColumn("Enz").setCellRenderer((TableCellRenderer)new TrueFalseIconRenderer(new ImageIcon(this.getClass().getResource("/icons/selected_green-new.png")), null, "Enzymatic", "Not Enzymatic"));
        this.uniqueHitsTable.getColumn("Protein(s)").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(TableProperties.getSelectedRowHtmlTagFontColor(), TableProperties.getNotSelectedRowHtmlTagFontColor()));
        this.uniqueHitsTable.getColumn(" ").setCellRenderer((TableCellRenderer)new JSparklinesIntegerIconTableCellRenderer(MatchValidationLevel.getIconMap(this.getClass()), MatchValidationLevel.getTooltipMap()));
        this.uniqueHitsTable.getColumn("Confidence").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), this.peptideShakerGUI.getSparklineColor()));
        ((JSparklinesBarChartTableCellRenderer)this.uniqueHitsTable.getColumn("Confidence").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() + 5);
        this.relatedHitsTable.getColumn("Protein(s)").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(TableProperties.getSelectedRowHtmlTagFontColor(), TableProperties.getNotSelectedRowHtmlTagFontColor()));
        this.relatedHitsTable.getColumn(" ").setCellRenderer((TableCellRenderer)new JSparklinesIntegerIconTableCellRenderer(MatchValidationLevel.getIconMap(this.getClass()), MatchValidationLevel.getTooltipMap()));
        this.relatedHitsTable.getColumn("Confidence").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), this.peptideShakerGUI.getSparklineColor()));
        ((JSparklinesBarChartTableCellRenderer)this.relatedHitsTable.getColumn("Confidence").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() + 5);
        this.candidateProteinsTableToolTips = new ArrayList();
        this.candidateProteinsTableToolTips.add(null);
        this.candidateProteinsTableToolTips.add("Protein Group Representative");
        this.candidateProteinsTableToolTips.add("Protein Accession");
        this.candidateProteinsTableToolTips.add("Protein Description");
        this.candidateProteinsTableToolTips.add("Gene Name");
        this.candidateProteinsTableToolTips.add("Chromosome Number");
        this.candidateProteinsTableToolTips.add("Protein Evidence Level");
        this.candidateProteinsTableToolTips.add("Contains Enzymatic Peptides");
        this.uniqueHitsTableToolTips = new ArrayList();
        this.uniqueHitsTableToolTips.add(null);
        this.uniqueHitsTableToolTips.add("Protein Accession(s)");
        this.uniqueHitsTableToolTips.add("Protein Confidence");
        this.uniqueHitsTableToolTips.add("Validated");
        this.relatedHitsTableToolTips = new ArrayList();
        this.relatedHitsTableToolTips.add(null);
        this.relatedHitsTableToolTips.add("Protein Accession(s)");
        this.relatedHitsTableToolTips.add("Protein Confidence");
        this.relatedHitsTableToolTips.add("Validated");
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.detailsPanel = new JPanel();
        this.proteinMatchJPanel = new JPanel();
        this.proteinMatchJScrollPane = new JScrollPane();
        this.proteinMatchTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)ProteinInferenceDialog.this.candidateProteinsTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.uniqueHitsJPanel = new JPanel();
        this.uniqueHitsJScrollPane = new JScrollPane();
        this.uniqueHitsTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)ProteinInferenceDialog.this.uniqueHitsTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.relatedHitsJPanel = new JPanel();
        this.relatedHitsJScrollPane = new JScrollPane();
        this.relatedHitsTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)ProteinInferenceDialog.this.relatedHitsTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.groupDetalsJPanel = new JPanel();
        this.groupClassJComboBox = new JComboBox();
        this.helpJButton = new JButton();
        this.okButton = new JButton();
        this.graphPanel = new JPanel();
        this.graphInnerPanel = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Protein Inference - Protein Level");
        this.setMinimumSize(new Dimension(800, 650));
        this.backgroundPanel.setBackground(new Color(255, 255, 255));
        this.tabbedPane.setBackground(new Color(230, 230, 230));
        this.tabbedPane.setTabPlacement(3);
        this.detailsPanel.setBackground(new Color(230, 230, 230));
        this.detailsPanel.setOpaque(false);
        this.proteinMatchJPanel.setBorder(BorderFactory.createTitledBorder("Candidate Proteins"));
        this.proteinMatchJPanel.setOpaque(false);
        this.proteinMatchTable.setModel(new MatchTable());
        this.proteinMatchTable.setOpaque(false);
        this.proteinMatchTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinInferenceDialog.this.proteinMatchTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ProteinInferenceDialog.this.proteinMatchTableMouseReleased(evt);
            }
        });
        this.proteinMatchTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ProteinInferenceDialog.this.proteinMatchTableMouseMoved(evt);
            }
        });
        this.proteinMatchJScrollPane.setViewportView(this.proteinMatchTable);
        GroupLayout proteinMatchJPanelLayout = new GroupLayout(this.proteinMatchJPanel);
        this.proteinMatchJPanel.setLayout(proteinMatchJPanelLayout);
        proteinMatchJPanelLayout.setHorizontalGroup(proteinMatchJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinMatchJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinMatchJScrollPane, -1, 852, Short.MAX_VALUE).addContainerGap()));
        proteinMatchJPanelLayout.setVerticalGroup(proteinMatchJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinMatchJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinMatchJScrollPane, -1, 99, Short.MAX_VALUE).addContainerGap()));
        this.uniqueHitsJPanel.setBorder(BorderFactory.createTitledBorder("Unique Hits"));
        this.uniqueHitsJPanel.setOpaque(false);
        this.uniqueHitsTable.setModel(new UniqueMatches());
        this.uniqueHitsTable.setOpaque(false);
        this.uniqueHitsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinInferenceDialog.this.uniqueHitsTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ProteinInferenceDialog.this.uniqueHitsTableMouseReleased(evt);
            }
        });
        this.uniqueHitsTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ProteinInferenceDialog.this.uniqueHitsTableMouseMoved(evt);
            }
        });
        this.uniqueHitsJScrollPane.setViewportView(this.uniqueHitsTable);
        GroupLayout uniqueHitsJPanelLayout = new GroupLayout(this.uniqueHitsJPanel);
        this.uniqueHitsJPanel.setLayout(uniqueHitsJPanelLayout);
        uniqueHitsJPanelLayout.setHorizontalGroup(uniqueHitsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(uniqueHitsJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.uniqueHitsJScrollPane).addContainerGap()));
        uniqueHitsJPanelLayout.setVerticalGroup(uniqueHitsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(uniqueHitsJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.uniqueHitsJScrollPane, -1, 96, Short.MAX_VALUE).addGap(14, 14, 14)));
        this.relatedHitsJPanel.setBorder(BorderFactory.createTitledBorder("Related Hits"));
        this.relatedHitsJPanel.setOpaque(false);
        this.relatedHitsTable.setModel(new AssociatedMatches());
        this.relatedHitsTable.setOpaque(false);
        this.relatedHitsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinInferenceDialog.this.relatedHitsTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ProteinInferenceDialog.this.relatedHitsTableMouseReleased(evt);
            }
        });
        this.relatedHitsTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ProteinInferenceDialog.this.relatedHitsTableMouseMoved(evt);
            }
        });
        this.relatedHitsJScrollPane.setViewportView(this.relatedHitsTable);
        GroupLayout relatedHitsJPanelLayout = new GroupLayout(this.relatedHitsJPanel);
        this.relatedHitsJPanel.setLayout(relatedHitsJPanelLayout);
        relatedHitsJPanelLayout.setHorizontalGroup(relatedHitsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(relatedHitsJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.relatedHitsJScrollPane).addContainerGap()));
        relatedHitsJPanelLayout.setVerticalGroup(relatedHitsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(relatedHitsJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.relatedHitsJScrollPane, -1, 99, Short.MAX_VALUE).addContainerGap()));
        this.groupDetalsJPanel.setBorder(BorderFactory.createTitledBorder("Protein Group Type"));
        this.groupDetalsJPanel.setOpaque(false);
        this.groupClassJComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Single Protein", "Related Proteins", "Related and Unrelated Proteins", "Unrelated Proteins"}));
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.setFocusable(false);
        this.helpJButton.setHorizontalTextPosition(0);
        this.helpJButton.setVerticalTextPosition(3);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinInferenceDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinInferenceDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinInferenceDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("Update");
        this.okButton.setToolTipText("<html>\nUpdate the protein group type and<br>\nthe protein group representative\n</html>");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinInferenceDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout groupDetalsJPanelLayout = new GroupLayout(this.groupDetalsJPanel);
        this.groupDetalsJPanel.setLayout(groupDetalsJPanelLayout);
        groupDetalsJPanelLayout.setHorizontalGroup(groupDetalsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupDetalsJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.groupClassJComboBox, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.okButton, -2, 71, -2).addGap(18, 18, 18).addComponent(this.helpJButton).addGap(18, 18, 18)));
        groupDetalsJPanelLayout.setVerticalGroup(groupDetalsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupDetalsJPanelLayout.createSequentialGroup().addContainerGap().addGroup(groupDetalsJPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.groupClassJComboBox, -2, -1, -2).addComponent(this.okButton).addComponent(this.helpJButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout detailsPanelLayout = new GroupLayout(this.detailsPanel);
        this.detailsPanel.setLayout(detailsPanelLayout);
        detailsPanelLayout.setHorizontalGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(detailsPanelLayout.createSequentialGroup().addContainerGap().addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proteinMatchJPanel, -1, -1, Short.MAX_VALUE).addComponent(this.uniqueHitsJPanel, -1, -1, Short.MAX_VALUE).addComponent(this.relatedHitsJPanel, -1, -1, Short.MAX_VALUE).addComponent(this.groupDetalsJPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        detailsPanelLayout.setVerticalGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(detailsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.groupDetalsJPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.proteinMatchJPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.uniqueHitsJPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.relatedHitsJPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.tabbedPane.addTab("Group Details", this.detailsPanel);
        this.graphPanel.setBackground(new Color(230, 230, 230));
        this.graphPanel.setOpaque(false);
        this.graphInnerPanel.setBackground(new Color(255, 255, 255));
        this.graphInnerPanel.setLayout(new BoxLayout(this.graphInnerPanel, 2));
        GroupLayout graphPanelLayout = new GroupLayout(this.graphPanel);
        this.graphPanel.setLayout(graphPanelLayout);
        graphPanelLayout.setHorizontalGroup(graphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(graphPanelLayout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.graphInnerPanel, -1, 874, Short.MAX_VALUE).addGap(15, 15, 15)));
        graphPanelLayout.setVerticalGroup(graphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, graphPanelLayout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.graphInnerPanel, -1, 510, Short.MAX_VALUE).addGap(15, 15, 15)));
        this.tabbedPane.addTab("Protein Graph", this.graphPanel);
        this.tabbedPane.setSelectedIndex(1);
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        PSParameter psParameter = new PSParameter();
        try {
            psParameter = (PSParameter)((ProteinMatch)this.identification.retrieveObject(this.inspectedMatch.getKey())).getUrParam(psParameter);
        }
        catch (Exception e) {
            this.peptideShakerGUI.catchException(e);
            this.dispose();
            return;
        }
        if (!this.inspectedMatch.getLeadingAccession().equals(this.previousMainMatch) || this.groupClassJComboBox.getSelectedIndex() != psParameter.getProteinInferenceGroupClass()) {
            try {
                psParameter.setProteinInferenceClass(this.groupClassJComboBox.getSelectedIndex());
                this.peptideShakerGUI.updateMainMatch(this.inspectedMatch.getLeadingAccession(), this.groupClassJComboBox.getSelectedIndex());
            }
            catch (Exception e) {
                this.peptideShakerGUI.catchException(e);
            }
            this.peptideShakerGUI.setDataSaved(false);
        }
    }

    private void proteinMatchTableMouseReleased(MouseEvent evt) {
        int row = this.proteinMatchTable.rowAtPoint(evt.getPoint());
        int column = this.proteinMatchTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            if (column == 1) {
                try {
                    this.inspectedMatch.setLeadingAccession(this.accessions[row]);
                    this.peptideShakerGUI.getIdentificationFeaturesGenerator().updateCoverableAA(this.inspectedMatch.getKey());
                    this.peptideShakerGUI.getIdentificationFeaturesGenerator().updateSequenceCoverage(this.inspectedMatch.getKey());
                    this.peptideShakerGUI.getIdentificationFeaturesGenerator().updateObservableCoverage(this.inspectedMatch.getKey());
                }
                catch (Exception e) {
                    this.peptideShakerGUI.catchException(e);
                }
                this.proteinMatchTable.revalidate();
                this.proteinMatchTable.repaint();
            } else if (column == 2 && evt.getButton() == 1 && ((String)this.proteinMatchTable.getValueAt(row, column)).lastIndexOf("<a href=\"") != -1) {
                String link = (String)this.proteinMatchTable.getValueAt(row, column);
                link = link.substring(link.indexOf("\"") + 1);
                link = link.substring(0, link.indexOf("\""));
                this.setCursor(new Cursor(3));
                BareBonesBrowserLaunch.openURL(link);
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.peptideShakerGUI, this.getClass().getResource("/helpFiles/ProteinInference.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Protein Inference - Help");
        this.setCursor(new Cursor(0));
    }

    private void proteinMatchTableMouseMoved(MouseEvent evt) {
        int row = this.proteinMatchTable.rowAtPoint(evt.getPoint());
        int column = this.proteinMatchTable.columnAtPoint(evt.getPoint());
        this.proteinMatchTable.setToolTipText(null);
        if (column == 2 && this.proteinMatchTable.getValueAt(row, column) != null) {
            String tempValue = (String)this.proteinMatchTable.getValueAt(row, column);
            if (tempValue.lastIndexOf("<a href=\"") != -1) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        } else if (column == this.proteinMatchTable.getColumn("Description").getModelIndex() && this.proteinMatchTable.getValueAt(row, column) != null) {
            if (GuiUtilities.getPreferredWidthOfCell(this.proteinMatchTable, row, column) > this.proteinMatchTable.getColumn("Description").getWidth()) {
                this.proteinMatchTable.setToolTipText("" + this.proteinMatchTable.getValueAt(row, column));
            }
            this.setCursor(new Cursor(0));
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    private void proteinMatchTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void uniqueHitsTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void uniqueHitsTableMouseMoved(MouseEvent evt) {
        int row = this.uniqueHitsTable.rowAtPoint(evt.getPoint());
        int column = this.uniqueHitsTable.columnAtPoint(evt.getPoint());
        if (column == 1 && this.uniqueHitsTable.getValueAt(row, column) != null) {
            String tempValue = (String)this.uniqueHitsTable.getValueAt(row, column);
            if (tempValue.lastIndexOf("a href=") != -1) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    private void uniqueHitsTableMouseReleased(MouseEvent evt) {
        int row = this.uniqueHitsTable.getSelectedRow();
        int column = this.uniqueHitsTable.getSelectedColumn();
        if (row != -1 && column == 1 && evt != null && evt.getButton() == 1 && ((String)this.uniqueHitsTable.getValueAt(row, column)).lastIndexOf("a href=") != -1) {
            this.peptideShakerGUI.openProteinLinks((String)this.uniqueHitsTable.getValueAt(row, column));
        }
    }

    private void relatedHitsTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void relatedHitsTableMouseMoved(MouseEvent evt) {
        int row = this.relatedHitsTable.rowAtPoint(evt.getPoint());
        int column = this.relatedHitsTable.columnAtPoint(evt.getPoint());
        if (column == 1 && this.relatedHitsTable.getValueAt(row, column) != null) {
            String tempValue = (String)this.relatedHitsTable.getValueAt(row, column);
            if (tempValue.lastIndexOf("a href=") != -1) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    private void relatedHitsTableMouseReleased(MouseEvent evt) {
        int row = this.relatedHitsTable.getSelectedRow();
        int column = this.relatedHitsTable.getSelectedColumn();
        if (row != -1 && column == 1 && evt != null && evt.getButton() == 1 && ((String)this.relatedHitsTable.getValueAt(row, column)).lastIndexOf("a href=") != -1) {
            this.peptideShakerGUI.openProteinLinks((String)this.relatedHitsTable.getValueAt(row, column));
        }
    }

    private class MatchTable
    extends DefaultTableModel {
        private MatchTable() {
        }

        @Override
        public int getRowCount() {
            return ProteinInferenceDialog.this.accessions.length;
        }

        @Override
        public int getColumnCount() {
            return 8;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "";
                }
                case 1: {
                    return "  ";
                }
                case 2: {
                    return "Accession";
                }
                case 3: {
                    return "Description";
                }
                case 4: {
                    return "Gene";
                }
                case 5: {
                    return "Chr";
                }
                case 6: {
                    return "Evidence";
                }
                case 7: {
                    return "Enz";
                }
            }
            return " ";
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return ProteinInferenceDialog.this.inspectedMatch.getLeadingAccession().equals(ProteinInferenceDialog.this.accessions[row]);
                }
                case 2: {
                    return ProteinInferenceDialog.this.peptideShakerGUI.getDisplayFeaturesGenerator().getDatabaseLink(ProteinInferenceDialog.this.accessions[row]);
                }
                case 3: {
                    try {
                        String description = ProteinInferenceDialog.this.peptideShakerGUI.getProteinDetailsProvider().getSimpleDescription(ProteinInferenceDialog.this.accessions[row]);
                        if (description == null || description.trim().isEmpty()) {
                            description = ProteinInferenceDialog.this.inspectedMatch.getLeadingAccession();
                        }
                        return description;
                    }
                    catch (Exception e) {
                        ProteinInferenceDialog.this.peptideShakerGUI.catchException(e);
                        return "Database Error";
                    }
                }
                case 4: {
                    try {
                        return ProteinInferenceDialog.this.peptideShakerGUI.getProteinDetailsProvider().getGeneName(ProteinInferenceDialog.this.accessions[row]);
                    }
                    catch (Exception e) {
                        ProteinInferenceDialog.this.peptideShakerGUI.catchException(e);
                        return "Database Error";
                    }
                }
                case 5: {
                    try {
                        String geneName = ProteinInferenceDialog.this.peptideShakerGUI.getProteinDetailsProvider().getGeneName(ProteinInferenceDialog.this.accessions[row]);
                        String chromosomeNumber = ProteinInferenceDialog.this.geneMaps.getChromosome(geneName);
                        return new Chromosome(chromosomeNumber);
                    }
                    catch (Exception e) {
                        ProteinInferenceDialog.this.peptideShakerGUI.catchException(e);
                        return "Database Error";
                    }
                }
                case 6: {
                    try {
                        Integer level = ProteinInferenceDialog.this.peptideShakerGUI.getProteinDetailsProvider().getProteinEvidence(ProteinInferenceDialog.this.accessions[row]);
                        if (level != null) {
                            try {
                                return Header.getProteinEvidencAsString(level);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        return "";
                    }
                    catch (Exception e) {
                        ProteinInferenceDialog.this.peptideShakerGUI.catchException(e);
                        return "Database Error";
                    }
                }
                case 7: {
                    try {
                        return ProteinInferenceDialog.this.peptideShakerGUI.getIdentificationFeaturesGenerator().hasEnzymaticPeptides(ProteinInferenceDialog.this.inspectedMatch.getKey());
                    }
                    catch (Exception e) {
                        ProteinInferenceDialog.this.peptideShakerGUI.catchException(e);
                        return "Database Error";
                    }
                }
            }
            return " ";
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex < 4) {
                return this.getValueAt(0, columnIndex).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }
    }

    private class UniqueMatches
    extends DefaultTableModel {
        private UniqueMatches() {
        }

        @Override
        public int getRowCount() {
            return ProteinInferenceDialog.this.uniqueMatches.length;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "";
                }
                case 1: {
                    return "Protein(s)";
                }
                case 2: {
                    return "Confidence";
                }
                case 3: {
                    return " ";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            ProteinMatch proteinMatch = ProteinInferenceDialog.this.identification.getProteinMatch(ProteinInferenceDialog.this.uniqueMatches[row]);
            PSParameter psParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy);
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return ProteinInferenceDialog.this.peptideShakerGUI.getDisplayFeaturesGenerator().getDatabaseLinks(proteinMatch.getAccessions());
                }
                case 2: {
                    return psParameter.getConfidence();
                }
                case 3: {
                    return psParameter.getMatchValidationLevel().getIndex();
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            return this.getValueAt(0, columnIndex).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }

    private class AssociatedMatches
    extends DefaultTableModel {
        private AssociatedMatches() {
        }

        @Override
        public int getRowCount() {
            return ProteinInferenceDialog.this.associatedMatches.length;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "";
                }
                case 1: {
                    return "Protein(s)";
                }
                case 2: {
                    return "Confidence";
                }
                case 3: {
                    return " ";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            ProteinMatch proteinMatch = ProteinInferenceDialog.this.identification.getProteinMatch(ProteinInferenceDialog.this.associatedMatches[row]);
            PSParameter psParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy);
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return ProteinInferenceDialog.this.peptideShakerGUI.getDisplayFeaturesGenerator().getDatabaseLinks(proteinMatch.getAccessions());
                }
                case 2: {
                    return psParameter.getConfidence();
                }
                case 3: {
                    return psParameter.getMatchValidationLevel().getIndex();
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            return this.getValueAt(0, columnIndex).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

