/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.protein_inference;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.io.biology.protein.Header;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.TableProperties;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.google.common.collect.Sets;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import eu.isas.peptideshaker.gui.protein_inference.ProteinInferenceGraphPanel;
import eu.isas.peptideshaker.gui.tablemodels.ProteinTableModel;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.data.Chromosome;
import no.uib.jsparklines.extra.ChromosomeTableCellRenderer;
import no.uib.jsparklines.extra.HtmlLinksRenderer;
import no.uib.jsparklines.renderers.JSparklinesIntegerIconTableCellRenderer;

public class ProteinInferencePeptideLevelDialog
extends JDialog {
    private PeptideShakerGUI peptideShakerGUI;
    private Identification identification;
    private long peptideMatchKey;
    private ArrayList<String> retainedProteinsTableToolTips;
    private ArrayList<String> otherProteinsTableToolTips;
    private JPanel backgroundPanel;
    private JPanel detailsPanel;
    private JPanel graphInnerPanel;
    private JPanel graphPanel;
    private JButton helpJButton;
    private JButton okButton;
    private JTable otherProteinJTable;
    private JScrollPane otherProteinsJScrollPane;
    private JPanel otherProteinsPanel;
    private JPanel peptideDetailsPanel;
    private JLabel peptideSequenceLabel;
    private JPanel peptidesPanel;
    private JComboBox protInferenceTypeCmb;
    private JScrollPane proteinsJScrollPane;
    private JTable retainedProteinJTable;
    private JPanel retainedProteinsPanel;
    private JTabbedPane tabbedPane;

    public ProteinInferencePeptideLevelDialog(PeptideShakerGUI peptideShakerGUI, boolean modal, long peptideMatchKey, Long proteinMatchKey, GeneMaps geneMaps) {
        super((Frame)peptideShakerGUI, modal);
        this.peptideMatchKey = peptideMatchKey;
        this.peptideShakerGUI = peptideShakerGUI;
        this.identification = peptideShakerGUI.getIdentification();
        PeptideMatch peptideMatch = this.identification.getPeptideMatch(peptideMatchKey);
        this.initComponents();
        PSParameter psParameter = new PSParameter();
        psParameter = (PSParameter)peptideMatch.getUrParam(psParameter);
        this.protInferenceTypeCmb.setSelectedIndex(psParameter.getProteinInferenceGroupClass());
        this.peptideSequenceLabel.setText(peptideShakerGUI.getDisplayFeaturesGenerator().getTaggedPeptideSequence(peptideMatch, true, true, true));
        String tooltip = peptideShakerGUI.getDisplayFeaturesGenerator().getPeptideModificationTooltipAsHtml(peptideMatch);
        this.peptideSequenceLabel.setToolTipText(tooltip);
        HashSet retainedProteins = proteinMatchKey != null ? Sets.newHashSet((Object[])this.identification.getProteinMatch(proteinMatchKey).getAccessions()) : peptideMatch.getPeptide().getProteinMapping().keySet().stream().flatMap(accession -> this.identification.getProteinMap().get(accession).stream()).flatMap(key -> Arrays.stream(this.identification.getProteinMatch((long)key).getAccessions())).collect(Collectors.toCollection(HashSet::new));
        int possibleCpt = 0;
        int retainedCpt = 0;
        for (String proteinAccession : peptideMatch.getPeptide().getProteinMapping().keySet()) {
            ProteinDetailsProvider proteinDetailsProvider = peptideShakerGUI.getProteinDetailsProvider();
            String description = proteinDetailsProvider.getSimpleDescription(proteinAccession);
            if (description == null || description.trim().isEmpty()) {
                description = proteinAccession;
            }
            String geneName = proteinDetailsProvider.getGeneName(proteinAccession);
            Integer level = proteinDetailsProvider.getProteinEvidence(proteinAccession);
            String chromosomeNumber = geneMaps.getChromosome(geneName);
            Chromosome chromosome = new Chromosome(chromosomeNumber);
            if (retainedProteins.contains(proteinAccession)) {
                ((DefaultTableModel)this.retainedProteinJTable.getModel()).addRow(new Object[]{++retainedCpt, peptideShakerGUI.getDisplayFeaturesGenerator().getDatabaseLink(proteinAccession), description, geneName, chromosome, Header.getProteinEvidencAsString(level), peptideShakerGUI.getIdentificationFeaturesGenerator().getNEnzymaticTermini(peptideMatch.getPeptide(), proteinAccession)});
                continue;
            }
            ((DefaultTableModel)this.otherProteinJTable.getModel()).addRow(new Object[]{++possibleCpt, peptideShakerGUI.getDisplayFeaturesGenerator().getDatabaseLink(proteinAccession), description, geneName, chromosome, Header.getProteinEvidencAsString(level), peptideShakerGUI.getIdentificationFeaturesGenerator().getNEnzymaticTermini(peptideMatch.getPeptide(), proteinAccession)});
        }
        this.setUpGUI();
        this.drawGraph();
        this.setLocationRelativeTo(peptideShakerGUI);
        this.setVisible(true);
    }

    private void drawGraph() {
        ArrayList<String> nodes = new ArrayList<String>();
        HashMap<String, ArrayList<String>> edges = new HashMap<String, ArrayList<String>>();
        HashMap<String, String> nodeProperties = new HashMap<String, String>();
        HashMap<String, String> edgeProperties = new HashMap<String, String>();
        HashMap<String, String> nodeToolTips = new HashMap<String, String>();
        ArrayList<String> selectedNodes = new ArrayList<String>();
        try {
            String peptideNodeName = "Peptide " + this.peptideMatchKey;
            selectedNodes.add(peptideNodeName);
            this.addPeptide(this.peptideMatchKey, nodeToolTips, nodes, nodeProperties, selectedNodes, edges, edgeProperties);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.graphInnerPanel.add(new ProteinInferenceGraphPanel(this, this.graphInnerPanel, this.peptideShakerGUI.getNormalIcon(), this.peptideShakerGUI.getWaitingIcon(), this.peptideShakerGUI.getLastSelectedFolder(), nodes, edges, nodeProperties, edgeProperties, nodeToolTips, selectedNodes));
    }

    private void addPeptide(long peptideKey, HashMap<String, String> nodeToolTips, ArrayList<String> nodes, HashMap<String, String> nodeProperties, ArrayList<String> selectedNodes, HashMap<String, ArrayList<String>> edges, HashMap<String, String> edgeProperties) {
        PeptideMatch peptideMatch = (PeptideMatch)this.peptideShakerGUI.getIdentification().retrieveObject(peptideKey);
        String peptideNodeName = "Peptide " + peptideKey;
        if (!nodes.contains(peptideNodeName)) {
            ProteinDetailsProvider proteinDetailsProvider = this.peptideShakerGUI.getProteinDetailsProvider();
            SequenceProvider sequenceProvider = this.peptideShakerGUI.getSequenceProvider();
            nodes.add(peptideNodeName);
            PSParameter peptideMatchParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
            String matchValidationLevel = "Validation: " + (Object)((Object)peptideMatchParameter.getMatchValidationLevel());
            nodeProperties.put(peptideNodeName, "" + peptideMatchParameter.getMatchValidationLevel().getIndex());
            String peptideTooltip = this.peptideShakerGUI.getDisplayFeaturesGenerator().getTaggedPeptideSequence(peptideMatch, true, false, true);
            peptideTooltip = "<html>" + peptideTooltip + "<br><br>" + matchValidationLevel + "</html>";
            nodeToolTips.put(peptideNodeName, peptideTooltip);
            for (String tempProteinAccession : peptideMatch.getPeptide().getProteinMapping().keySet()) {
                ArrayList<String> tempEdges;
                String proteinNodeKey = "Protein " + tempProteinAccession;
                if (!nodes.contains(proteinNodeKey)) {
                    nodes.add(proteinNodeKey);
                    long tempKey = ExperimentObject.asLong(tempProteinAccession);
                    ProteinMatch tempProteinMatch = this.identification.getProteinMatch(tempKey);
                    String nodeProperty = "";
                    if (tempProteinMatch != null) {
                        PSParameter psParameter = (PSParameter)tempProteinMatch.getUrParam(PSParameter.dummy);
                        nodeProperty = nodeProperty + psParameter.getMatchValidationLevel().getIndex();
                        matchValidationLevel = "Validation: " + (Object)((Object)psParameter.getMatchValidationLevel());
                    } else {
                        nodeProperty = nodeProperty + -1;
                        matchValidationLevel = "Validation: (not available)";
                    }
                    Integer level = proteinDetailsProvider.getProteinEvidence(tempProteinAccession);
                    String proteinEvidenceLevel = "Evidence: (not available)";
                    if (level != null) {
                        nodeProperty = nodeProperty + "|" + level;
                        try {
                            proteinEvidenceLevel = "Evidence: " + Header.getProteinEvidencAsString(level);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    nodeProperties.put(proteinNodeKey, nodeProperty);
                    nodeToolTips.put(proteinNodeKey, "<html>" + tempProteinAccession + "<br>" + proteinDetailsProvider.getSimpleDescription(tempProteinAccession) + "<br><br>" + matchValidationLevel + "<br>" + proteinEvidenceLevel + "<html>");
                    if (tempProteinMatch != null) {
                        for (long tempPeptideKey2 : tempProteinMatch.getPeptideMatchesKeys()) {
                            this.addPeptide(tempPeptideKey2, nodeToolTips, nodes, nodeProperties, selectedNodes, edges, edgeProperties);
                        }
                    } else if (this.identification.getProteinMap().containsKey(tempProteinAccession)) {
                        this.identification.getProteinMap().get(tempProteinAccession).stream().flatMap(key -> Arrays.stream(this.identification.getProteinMatch((long)key).getPeptideMatchesKeys()).boxed()).distinct().forEach(tempPeptideKey -> this.addPeptide((long)tempPeptideKey, nodeToolTips, nodes, nodeProperties, selectedNodes, edges, edgeProperties));
                    }
                }
                if ((tempEdges = edges.get(peptideNodeName)) == null) {
                    tempEdges = new ArrayList();
                }
                if (!tempEdges.contains(proteinNodeKey)) {
                    tempEdges.add(proteinNodeKey);
                    Boolean enzymatic = false;
                    DigestionParameters digestionPreferences = this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getDigestionParameters();
                    if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
                        enzymatic = PeptideUtils.isEnzymatic(peptideMatch.getPeptide(), tempProteinAccession, sequenceProvider.getSequence(tempProteinAccession), digestionPreferences.getEnzymes());
                    }
                    edgeProperties.put(peptideNodeName + "|" + proteinNodeKey, enzymatic.toString());
                }
                edges.put(peptideNodeName, tempEdges);
            }
        }
    }

    private void setUpGUI() {
        this.tabbedPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.protInferenceTypeCmb.setRenderer(new AlignedListCellRenderer(0));
        this.proteinsJScrollPane.getViewport().setOpaque(false);
        this.otherProteinsJScrollPane.getViewport().setOpaque(false);
        this.otherProteinJTable.getTableHeader().setReorderingAllowed(false);
        this.otherProteinJTable.getColumn("Accession").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(TableProperties.getSelectedRowHtmlTagFontColor(), TableProperties.getNotSelectedRowHtmlTagFontColor()));
        this.retainedProteinJTable.getTableHeader().setReorderingAllowed(false);
        this.retainedProteinJTable.getColumn("Accession").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(TableProperties.getSelectedRowHtmlTagFontColor(), TableProperties.getNotSelectedRowHtmlTagFontColor()));
        this.retainedProteinJTable.getColumn(" ").setMinWidth(50);
        this.retainedProteinJTable.getColumn(" ").setMaxWidth(50);
        this.retainedProteinJTable.getColumn("Gene").setMinWidth(90);
        this.retainedProteinJTable.getColumn("Gene").setMaxWidth(90);
        this.retainedProteinJTable.getColumn("Chr").setMinWidth(90);
        this.retainedProteinJTable.getColumn("Chr").setMaxWidth(90);
        this.retainedProteinJTable.getColumn("Evidence").setMinWidth(90);
        this.retainedProteinJTable.getColumn("Evidence").setMaxWidth(90);
        this.retainedProteinJTable.getColumn("Enz").setMinWidth(50);
        this.retainedProteinJTable.getColumn("Enz").setMaxWidth(50);
        this.otherProteinJTable.getColumn(" ").setMinWidth(50);
        this.otherProteinJTable.getColumn(" ").setMaxWidth(50);
        this.otherProteinJTable.getColumn("Gene").setMinWidth(90);
        this.otherProteinJTable.getColumn("Gene").setMaxWidth(90);
        this.otherProteinJTable.getColumn("Chr").setMinWidth(90);
        this.otherProteinJTable.getColumn("Chr").setMaxWidth(90);
        this.otherProteinJTable.getColumn("Evidence").setMinWidth(90);
        this.otherProteinJTable.getColumn("Evidence").setMaxWidth(90);
        this.otherProteinJTable.getColumn("Enz").setMinWidth(50);
        this.otherProteinJTable.getColumn("Enz").setMaxWidth(50);
        Integer width = ProteinTableModel.getPreferredAccessionColumnWidth(this.otherProteinJTable, this.otherProteinJTable.getColumn("Accession").getModelIndex(), 6, this.peptideShakerGUI.getMetrics().getMaxProteinAccessionLength());
        if (width != null) {
            this.otherProteinJTable.getColumn("Accession").setMinWidth(width);
            this.otherProteinJTable.getColumn("Accession").setMaxWidth(width);
        } else {
            this.otherProteinJTable.getColumn("Accession").setMinWidth(15);
            this.otherProteinJTable.getColumn("Accession").setMaxWidth(Integer.MAX_VALUE);
        }
        this.otherProteinJTable.getColumn("Chr").setCellRenderer((TableCellRenderer)new ChromosomeTableCellRenderer(Color.WHITE, Color.BLACK));
        HashMap<Integer, ImageIcon> enzymeIcons = new HashMap<Integer, ImageIcon>();
        enzymeIcons.put(0, new ImageIcon(this.getClass().getResource("/icons/warning-red.png")));
        enzymeIcons.put(1, new ImageIcon(this.getClass().getResource("/icons/warning-new.png")));
        enzymeIcons.put(2, new ImageIcon(this.getClass().getResource("/icons/selected_green-new.png")));
        HashMap<Integer, String> enzymeIconTooltips = new HashMap<Integer, String>();
        enzymeIconTooltips.put(0, "Non-enzymatic");
        enzymeIconTooltips.put(1, "Semi-enzymatic");
        enzymeIconTooltips.put(2, "Enzymatic");
        this.otherProteinJTable.getColumn("Enz").setCellRenderer((TableCellRenderer)new JSparklinesIntegerIconTableCellRenderer(enzymeIcons, enzymeIconTooltips));
        width = ProteinTableModel.getPreferredAccessionColumnWidth(this.retainedProteinJTable, this.retainedProteinJTable.getColumn("Accession").getModelIndex(), 6, this.peptideShakerGUI.getMetrics().getMaxProteinAccessionLength());
        if (width != null) {
            this.retainedProteinJTable.getColumn("Accession").setMinWidth(width);
            this.retainedProteinJTable.getColumn("Accession").setMaxWidth(width);
        } else {
            this.retainedProteinJTable.getColumn("Accession").setMinWidth(15);
            this.retainedProteinJTable.getColumn("Accession").setMaxWidth(Integer.MAX_VALUE);
        }
        this.retainedProteinJTable.getColumn("Chr").setCellRenderer((TableCellRenderer)new ChromosomeTableCellRenderer(Color.WHITE, Color.BLACK));
        this.retainedProteinJTable.getColumn("Enz").setCellRenderer((TableCellRenderer)new JSparklinesIntegerIconTableCellRenderer(enzymeIcons, enzymeIconTooltips));
        this.retainedProteinsTableToolTips = new ArrayList();
        this.retainedProteinsTableToolTips.add(null);
        this.retainedProteinsTableToolTips.add("Protein Accession");
        this.retainedProteinsTableToolTips.add("Protein Description");
        this.retainedProteinsTableToolTips.add("Gene Name");
        this.retainedProteinsTableToolTips.add("Chromosome Number");
        this.retainedProteinsTableToolTips.add("Protein Evidence Level");
        this.retainedProteinsTableToolTips.add("Enzymatic Peptide");
        this.otherProteinsTableToolTips = new ArrayList();
        this.otherProteinsTableToolTips.add(null);
        this.otherProteinsTableToolTips.add("Protein Accession");
        this.otherProteinsTableToolTips.add("Protein Description");
        this.otherProteinsTableToolTips.add("Gene Name");
        this.otherProteinsTableToolTips.add("Chromosome Number");
        this.otherProteinsTableToolTips.add("Protein Evidence Level");
        this.otherProteinsTableToolTips.add("Enzymatic Peptide");
        ((TitledBorder)this.retainedProteinsPanel.getBorder()).setTitle("Retained Proteins (" + this.retainedProteinJTable.getRowCount() + ")");
        ((TitledBorder)this.otherProteinsPanel.getBorder()).setTitle("Other Proteins (" + this.otherProteinJTable.getRowCount() + ")");
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.detailsPanel = new JPanel();
        this.otherProteinsPanel = new JPanel();
        this.proteinsJScrollPane = new JScrollPane();
        this.otherProteinJTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)ProteinInferencePeptideLevelDialog.this.otherProteinsTableToolTips.get(realIndex);
                    }
                };
            }
        };
        this.peptidesPanel = new JPanel();
        this.protInferenceTypeCmb = new JComboBox();
        this.helpJButton = new JButton();
        this.okButton = new JButton();
        this.retainedProteinsPanel = new JPanel();
        this.otherProteinsJScrollPane = new JScrollPane();
        this.retainedProteinJTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)ProteinInferencePeptideLevelDialog.this.retainedProteinsTableToolTips.get(realIndex);
                    }
                };
            }
        };
        this.peptideDetailsPanel = new JPanel();
        this.peptideSequenceLabel = new JLabel();
        this.graphPanel = new JPanel();
        this.graphInnerPanel = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Protein Inference - Peptide Level");
        this.setMinimumSize(new Dimension(1000, 700));
        this.backgroundPanel.setBackground(new Color(255, 255, 255));
        this.tabbedPane.setTabPlacement(3);
        this.detailsPanel.setOpaque(false);
        this.otherProteinsPanel.setBorder(BorderFactory.createTitledBorder("Other Proteins"));
        this.otherProteinsPanel.setOpaque(false);
        this.proteinsJScrollPane.setOpaque(false);
        this.otherProteinJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Accession", "Description", "Gene", "Chr", "Evidence", "Enz"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, String.class, String.class, String.class, String.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.otherProteinJTable.setOpaque(false);
        this.otherProteinJTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinInferencePeptideLevelDialog.this.otherProteinJTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ProteinInferencePeptideLevelDialog.this.otherProteinJTableMouseReleased(evt);
            }
        });
        this.otherProteinJTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ProteinInferencePeptideLevelDialog.this.otherProteinJTableMouseMoved(evt);
            }
        });
        this.proteinsJScrollPane.setViewportView(this.otherProteinJTable);
        GroupLayout otherProteinsPanelLayout = new GroupLayout(this.otherProteinsPanel);
        this.otherProteinsPanel.setLayout(otherProteinsPanelLayout);
        otherProteinsPanelLayout.setHorizontalGroup(otherProteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(otherProteinsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinsJScrollPane).addContainerGap()));
        otherProteinsPanelLayout.setVerticalGroup(otherProteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(otherProteinsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinsJScrollPane, -1, 141, Short.MAX_VALUE).addContainerGap()));
        this.peptidesPanel.setBorder(BorderFactory.createTitledBorder("Protein Group Type"));
        this.peptidesPanel.setOpaque(false);
        this.protInferenceTypeCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Unique Protein", "Related Proteins", "Related and Unrelated Proteins", "Unrelated Proteins"}));
        this.protInferenceTypeCmb.setMinimumSize(new Dimension(112, 18));
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.setFocusable(false);
        this.helpJButton.setHorizontalTextPosition(0);
        this.helpJButton.setVerticalTextPosition(3);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinInferencePeptideLevelDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinInferencePeptideLevelDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinInferencePeptideLevelDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("Update");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinInferencePeptideLevelDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout peptidesPanelLayout = new GroupLayout(this.peptidesPanel);
        this.peptidesPanel.setLayout(peptidesPanelLayout);
        peptidesPanelLayout.setHorizontalGroup(peptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptidesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.protInferenceTypeCmb, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.okButton).addGap(24, 24, 24).addComponent(this.helpJButton).addGap(18, 18, 18)));
        peptidesPanelLayout.setVerticalGroup(peptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptidesPanelLayout.createSequentialGroup().addContainerGap().addGroup(peptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.protInferenceTypeCmb, -2, -1, -2).addComponent(this.okButton).addComponent(this.helpJButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.retainedProteinsPanel.setBorder(BorderFactory.createTitledBorder("Retained Proteins"));
        this.retainedProteinsPanel.setOpaque(false);
        this.retainedProteinJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Accession", "Description", "Gene", "Chr", "Evidence", "Enz"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, String.class, String.class, String.class, String.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.retainedProteinJTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinInferencePeptideLevelDialog.this.retainedProteinJTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ProteinInferencePeptideLevelDialog.this.retainedProteinJTableMouseReleased(evt);
            }
        });
        this.retainedProteinJTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ProteinInferencePeptideLevelDialog.this.retainedProteinJTableMouseMoved(evt);
            }
        });
        this.otherProteinsJScrollPane.setViewportView(this.retainedProteinJTable);
        GroupLayout retainedProteinsPanelLayout = new GroupLayout(this.retainedProteinsPanel);
        this.retainedProteinsPanel.setLayout(retainedProteinsPanelLayout);
        retainedProteinsPanelLayout.setHorizontalGroup(retainedProteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(retainedProteinsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.otherProteinsJScrollPane, -1, 852, Short.MAX_VALUE).addContainerGap()));
        retainedProteinsPanelLayout.setVerticalGroup(retainedProteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(retainedProteinsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.otherProteinsJScrollPane, -1, 142, Short.MAX_VALUE).addContainerGap()));
        this.peptideDetailsPanel.setBorder(BorderFactory.createTitledBorder("Peptide Details"));
        this.peptideDetailsPanel.setOpaque(false);
        this.peptideSequenceLabel.setText("peptideDetails");
        GroupLayout peptideDetailsPanelLayout = new GroupLayout(this.peptideDetailsPanel);
        this.peptideDetailsPanel.setLayout(peptideDetailsPanelLayout);
        peptideDetailsPanelLayout.setHorizontalGroup(peptideDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptideDetailsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.peptideSequenceLabel).addContainerGap(-1, Short.MAX_VALUE)));
        peptideDetailsPanelLayout.setVerticalGroup(peptideDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptideDetailsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.peptideSequenceLabel).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout detailsPanelLayout = new GroupLayout(this.detailsPanel);
        this.detailsPanel.setLayout(detailsPanelLayout);
        detailsPanelLayout.setHorizontalGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(detailsPanelLayout.createSequentialGroup().addContainerGap().addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.retainedProteinsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.peptidesPanel, -1, -1, Short.MAX_VALUE).addComponent(this.otherProteinsPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.peptideDetailsPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        detailsPanelLayout.setVerticalGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(detailsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.peptideDetailsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peptidesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.retainedProteinsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.otherProteinsPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.tabbedPane.addTab("Group Details", this.detailsPanel);
        this.graphPanel.setOpaque(false);
        this.graphInnerPanel.setBackground(new Color(255, 255, 255));
        this.graphInnerPanel.setLayout(new BoxLayout(this.graphInnerPanel, 2));
        GroupLayout graphPanelLayout = new GroupLayout(this.graphPanel);
        this.graphPanel.setLayout(graphPanelLayout);
        graphPanelLayout.setHorizontalGroup(graphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(graphPanelLayout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.graphInnerPanel, -1, 874, Short.MAX_VALUE).addGap(15, 15, 15)));
        graphPanelLayout.setVerticalGroup(graphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(graphPanelLayout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.graphInnerPanel, -1, 510, Short.MAX_VALUE).addGap(15, 15, 15)));
        this.tabbedPane.addTab("Protein Graph", this.graphPanel);
        this.tabbedPane.setSelectedIndex(1);
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.pack();
    }

    private void otherProteinJTableMouseReleased(MouseEvent evt) {
        int row = this.otherProteinJTable.rowAtPoint(evt.getPoint());
        int column = this.otherProteinJTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column == 1 && evt.getButton() == 1 && ((String)this.otherProteinJTable.getValueAt(row, column)).lastIndexOf("<a href=\"") != -1) {
            String link = (String)this.otherProteinJTable.getValueAt(row, column);
            link = link.substring(link.indexOf("\"") + 1);
            link = link.substring(0, link.indexOf("\""));
            this.setCursor(new Cursor(3));
            BareBonesBrowserLaunch.openURL(link);
            this.setCursor(new Cursor(0));
        }
    }

    private void otherProteinJTableMouseMoved(MouseEvent evt) {
        int row = this.otherProteinJTable.rowAtPoint(evt.getPoint());
        int column = this.otherProteinJTable.columnAtPoint(evt.getPoint());
        this.otherProteinJTable.setToolTipText(null);
        if (this.otherProteinJTable.getValueAt(row, column) != null) {
            if (column == this.otherProteinJTable.getColumn("Accession").getModelIndex()) {
                String tempValue = (String)this.otherProteinJTable.getValueAt(row, column);
                if (tempValue.lastIndexOf("a href=") != -1) {
                    this.setCursor(new Cursor(12));
                } else {
                    this.setCursor(new Cursor(0));
                }
            }
        } else if (column == this.otherProteinJTable.getColumn("Description").getModelIndex() && this.otherProteinJTable.getValueAt(row, column) != null) {
            if (GuiUtilities.getPreferredWidthOfCell(this.otherProteinJTable, row, column) > this.otherProteinJTable.getColumn("Description").getWidth()) {
                this.otherProteinJTable.setToolTipText("" + this.otherProteinJTable.getValueAt(row, column));
            }
            this.setCursor(new Cursor(0));
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    private void otherProteinJTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void retainedProteinJTableMouseReleased(MouseEvent evt) {
        int row = this.retainedProteinJTable.rowAtPoint(evt.getPoint());
        int column = this.retainedProteinJTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column == 1 && evt.getButton() == 1 && ((String)this.retainedProteinJTable.getValueAt(row, column)).lastIndexOf("<a href=\"") != -1) {
            String link = (String)this.retainedProteinJTable.getValueAt(row, column);
            link = link.substring(link.indexOf("\"") + 1);
            link = link.substring(0, link.indexOf("\""));
            this.setCursor(new Cursor(3));
            BareBonesBrowserLaunch.openURL(link);
            this.setCursor(new Cursor(0));
        }
    }

    private void retainedProteinJTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        PSParameter psParameter = new PSParameter();
        try {
            psParameter = (PSParameter)((PeptideMatch)this.peptideShakerGUI.getIdentification().retrieveObject(this.peptideMatchKey)).getUrParam(psParameter);
            if (psParameter.getProteinInferenceGroupClass() != this.protInferenceTypeCmb.getSelectedIndex()) {
                psParameter.setProteinInferenceClass(this.protInferenceTypeCmb.getSelectedIndex());
                this.peptideShakerGUI.setDataSaved(false);
                this.peptideShakerGUI.setUpdated(0, false);
                this.peptideShakerGUI.setUpdated(3, false);
                this.peptideShakerGUI.updateTabbedPanes();
            }
        }
        catch (Exception e) {
            this.peptideShakerGUI.catchException(e);
            this.dispose();
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.peptideShakerGUI, this.getClass().getResource("/helpFiles/ProteinInferencePeptideLevel.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Protein Inference - Help");
        this.setCursor(new Cursor(0));
    }

    private void retainedProteinJTableMouseMoved(MouseEvent evt) {
        int row = this.retainedProteinJTable.rowAtPoint(evt.getPoint());
        int column = this.retainedProteinJTable.columnAtPoint(evt.getPoint());
        this.retainedProteinJTable.setToolTipText(null);
        if (column == 1 && this.retainedProteinJTable.getValueAt(row, column) != null) {
            String tempValue = (String)this.retainedProteinJTable.getValueAt(row, column);
            if (tempValue.lastIndexOf("<a href=\"") != -1) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        } else if (column == this.retainedProteinJTable.getColumn("Description").getModelIndex() && this.retainedProteinJTable.getValueAt(row, column) != null) {
            if (GuiUtilities.getPreferredWidthOfCell(this.retainedProteinJTable, row, column) > this.retainedProteinJTable.getColumn("Description").getWidth()) {
                this.retainedProteinJTable.setToolTipText("" + this.retainedProteinJTable.getValueAt(row, column));
            }
            this.setCursor(new Cursor(0));
        } else {
            this.setCursor(new Cursor(0));
        }
    }
}

