/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.tablemodels;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.utils.ProteinUtils;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.gui.TableProperties;
import com.compomics.util.gui.tablemodels.SelfUpdatingTableModel;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.utils.DisplayFeaturesGenerator;
import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import no.uib.jsparklines.data.ArrrayListDataPoints;
import no.uib.jsparklines.data.Chromosome;
import no.uib.jsparklines.extra.ChromosomeTableCellRenderer;
import no.uib.jsparklines.extra.HtmlLinksRenderer;
import no.uib.jsparklines.extra.TrueFalseIconRenderer;
import no.uib.jsparklines.renderers.JSparklinesArrayListBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesIntegerColorTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesIntegerIconTableCellRenderer;
import org.jfree.chart.plot.PlotOrientation;

public class ProteinTableModel
extends SelfUpdatingTableModel {
    private Identification identification;
    private IdentificationFeaturesGenerator identificationFeaturesGenerator;
    private ProteinDetailsProvider proteinDetailsProvider;
    private SequenceProvider sequenceProvider;
    private DisplayFeaturesGenerator displayFeaturesGenerator;
    private GeneMaps geneMaps;
    private final ExceptionHandler exceptionHandler;
    private long[] proteinKeys = null;
    private boolean showScores = false;

    public ProteinTableModel() {
        this.identification = null;
        this.identificationFeaturesGenerator = null;
        this.proteinDetailsProvider = null;
        this.sequenceProvider = null;
        this.geneMaps = null;
        this.displayFeaturesGenerator = null;
        this.exceptionHandler = null;
        this.proteinKeys = new long[0];
    }

    public ProteinTableModel(Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, ProteinDetailsProvider proteinDetailsProvider, SequenceProvider sequenceProvider, GeneMaps geneMaps, DisplayFeaturesGenerator displayFeaturesGenerator, ExceptionHandler exceptionHandler, long[] proteinKeys) {
        this.identification = identification;
        this.identificationFeaturesGenerator = identificationFeaturesGenerator;
        this.proteinDetailsProvider = proteinDetailsProvider;
        this.sequenceProvider = sequenceProvider;
        this.geneMaps = geneMaps;
        this.displayFeaturesGenerator = displayFeaturesGenerator;
        this.exceptionHandler = exceptionHandler;
        this.proteinKeys = proteinKeys;
    }

    public void updateDataModel(Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, ProteinDetailsProvider proteinDetailsProvider, SequenceProvider sequenceProvider, GeneMaps geneMaps, DisplayFeaturesGenerator displayFeaturesGenerator, long[] proteinKeys) {
        this.identification = identification;
        this.identificationFeaturesGenerator = identificationFeaturesGenerator;
        this.proteinDetailsProvider = proteinDetailsProvider;
        this.sequenceProvider = sequenceProvider;
        this.geneMaps = geneMaps;
        this.displayFeaturesGenerator = displayFeaturesGenerator;
        this.proteinKeys = proteinKeys;
    }

    public void showScores(boolean showScores) {
        this.showScores = showScores;
    }

    public void reset() {
        this.proteinKeys = null;
    }

    @Override
    public int getRowCount() {
        return this.proteinKeys == null ? 0 : this.proteinKeys.length;
    }

    @Override
    public int getColumnCount() {
        return 13;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return " ";
            }
            case 1: {
                return "  ";
            }
            case 2: {
                return "PI";
            }
            case 3: {
                return "Accession";
            }
            case 4: {
                return "Description";
            }
            case 5: {
                return "Chr";
            }
            case 6: {
                return "Coverage";
            }
            case 7: {
                return "#Peptides";
            }
            case 8: {
                return "#Spectra";
            }
            case 9: {
                return "Quant";
            }
            case 10: {
                return "MW";
            }
            case 11: {
                return this.showScores ? "Score" : "Confidence";
            }
            case 12: {
                return "";
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.proteinKeys != null) {
            int viewIndex = this.getViewIndex(row);
            if (column == 0) {
                return viewIndex + 1;
            }
            long proteinKey = this.proteinKeys[viewIndex];
            ProteinMatch proteinMatch = this.identification.getProteinMatch(proteinKey);
            switch (column) {
                case 1: {
                    PSParameter psParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy);
                    return psParameter.getStarred();
                }
                case 2: {
                    PSParameter psParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy);
                    return psParameter.getProteinInferenceGroupClass();
                }
                case 3: {
                    return this.isScrolling ? proteinMatch.getLeadingAccession() : this.displayFeaturesGenerator.getDatabaseLink(proteinMatch.getLeadingAccession());
                }
                case 4: {
                    return this.proteinDetailsProvider.getSimpleDescription(proteinMatch.getLeadingAccession());
                }
                case 5: {
                    String geneName = this.proteinDetailsProvider.getGeneName(proteinMatch.getLeadingAccession());
                    String chromosomeName = this.geneMaps.getChromosome(geneName);
                    return chromosomeName == null || chromosomeName.length() == 0 ? new Chromosome(null) : new Chromosome(chromosomeName);
                }
                case 6: {
                    HashMap<Integer, Double> sequenceCoverage = this.identificationFeaturesGenerator.getSequenceCoverage(proteinKey);
                    Double sequenceCoverageConfident = 100.0 * sequenceCoverage.get(MatchValidationLevel.confident.getIndex());
                    Double sequenceCoverageDoubtful = 100.0 * sequenceCoverage.get(MatchValidationLevel.doubtful.getIndex());
                    Double sequenceCoverageNotValidated = 100.0 * sequenceCoverage.get(MatchValidationLevel.not_validated.getIndex());
                    double possibleCoverage = 100.0 * this.identificationFeaturesGenerator.getObservableCoverage(proteinKey);
                    ArrayList<Double> doubleValues = new ArrayList<Double>(4);
                    doubleValues.add(sequenceCoverageConfident);
                    doubleValues.add(sequenceCoverageDoubtful);
                    doubleValues.add(sequenceCoverageNotValidated);
                    doubleValues.add(possibleCoverage - sequenceCoverageConfident - sequenceCoverageDoubtful - sequenceCoverageNotValidated);
                    return new ArrrayListDataPoints(doubleValues, JSparklinesArrayListBarChartTableCellRenderer.ValueDisplayType.sumExceptLastNumber);
                }
                case 7: {
                    int nPeptides = proteinMatch.getPeptideCount();
                    int nConfidentPeptides = this.identificationFeaturesGenerator.getNConfidentPeptides(proteinKey);
                    int nValidatedPeptides = this.identificationFeaturesGenerator.getNValidatedPeptides(proteinKey);
                    int nDoubtfulPeptides = nValidatedPeptides - nConfidentPeptides;
                    ArrayList<Double> doubleValues = new ArrayList<Double>(3);
                    doubleValues.add(Double.valueOf(nConfidentPeptides));
                    doubleValues.add(Double.valueOf(nDoubtfulPeptides));
                    doubleValues.add(Double.valueOf(nPeptides - nConfidentPeptides - nDoubtfulPeptides));
                    return new ArrrayListDataPoints(doubleValues, JSparklinesArrayListBarChartTableCellRenderer.ValueDisplayType.sumOfNumbers);
                }
                case 8: {
                    int nPsms = this.identificationFeaturesGenerator.getNSpectra(proteinKey);
                    int nConfidentPsms = this.identificationFeaturesGenerator.getNConfidentSpectra(proteinKey);
                    int nValidatedPsms = this.identificationFeaturesGenerator.getNValidatedSpectra(proteinKey);
                    int nDoubtfulPsms = nValidatedPsms - nConfidentPsms;
                    ArrayList<Double> doubleValues = new ArrayList<Double>(3);
                    doubleValues.add(Double.valueOf(nConfidentPsms));
                    doubleValues.add(Double.valueOf(nDoubtfulPsms));
                    doubleValues.add(Double.valueOf(nPsms - nConfidentPsms - nDoubtfulPsms));
                    return new ArrrayListDataPoints(doubleValues, JSparklinesArrayListBarChartTableCellRenderer.ValueDisplayType.sumOfNumbers);
                }
                case 9: {
                    return this.identificationFeaturesGenerator.getNormalizedSpectrumCounting(proteinKey);
                }
                case 10: {
                    return ProteinUtils.computeMolecularWeight(this.sequenceProvider.getSequence(proteinMatch.getLeadingAccession()));
                }
                case 11: {
                    PSParameter psParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy);
                    return this.showScores ? psParameter.getTransformedScore() : psParameter.getConfidence();
                }
                case 12: {
                    PSParameter psParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy);
                    return psParameter.getMatchValidationLevel().getIndex();
                }
            }
            return null;
        }
        return null;
    }

    public boolean isInstantiated() {
        return this.identification != null;
    }

    public Class getColumnClass(int columnIndex) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getValueAt(i, columnIndex) == null) continue;
            return this.getValueAt(i, columnIndex).getClass();
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    protected void catchException(Exception e) {
        this.setSelfUpdating(false);
        this.exceptionHandler.catchException(e);
    }

    @Override
    protected int loadDataForRows(ArrayList<Integer> rows, WaitingHandler waitingHandler) {
        boolean canceled = rows.parallelStream().map(i -> (ProteinMatch)this.identification.retrieveObject(this.proteinKeys[i])).anyMatch(proteinMatch -> {
            long proteinKey = proteinMatch.getKey();
            this.identificationFeaturesGenerator.getSequenceCoverage(proteinKey);
            this.identificationFeaturesGenerator.getObservableCoverage(proteinKey);
            this.identificationFeaturesGenerator.getNValidatedPeptides(proteinKey);
            this.identificationFeaturesGenerator.getNValidatedSpectra(proteinKey);
            this.identificationFeaturesGenerator.getNSpectra(proteinKey);
            this.identificationFeaturesGenerator.getSpectrumCounting(proteinKey);
            return waitingHandler.isRunCanceled();
        });
        return canceled ? rows.get(0) : rows.get(rows.size() - 1);
    }

    public static void setProteinTableProperties(JTable proteinTable, Color sparklineColor, Color sparklineColorNotValidated, Color sparklineColorNotFound, Color sparklineColorDoubtful, DecimalFormat scoreAndConfidenceDecimalFormat, Class parentClass, Integer maxProteinKeyLength) {
        proteinTable.getColumn(" ").setMaxWidth(50);
        proteinTable.getColumn(" ").setMinWidth(50);
        proteinTable.getColumn("Chr").setMaxWidth(50);
        proteinTable.getColumn("Chr").setMinWidth(50);
        try {
            proteinTable.getColumn("Confidence").setMaxWidth(90);
            proteinTable.getColumn("Confidence").setMinWidth(90);
        }
        catch (IllegalArgumentException w) {
            proteinTable.getColumn("Score").setMaxWidth(90);
            proteinTable.getColumn("Score").setMinWidth(90);
        }
        proteinTable.getColumn("").setMaxWidth(30);
        proteinTable.getColumn("").setMinWidth(30);
        proteinTable.getColumn("  ").setMaxWidth(30);
        proteinTable.getColumn("  ").setMinWidth(30);
        proteinTable.getColumn("PI").setMaxWidth(37);
        proteinTable.getColumn("PI").setMinWidth(37);
        HashMap<Integer, Color> proteinInferenceColorMap = new HashMap<Integer, Color>();
        proteinInferenceColorMap.put(0, sparklineColor);
        proteinInferenceColorMap.put(1, Color.YELLOW);
        proteinInferenceColorMap.put(2, Color.ORANGE);
        proteinInferenceColorMap.put(3, Color.RED);
        HashMap<Integer, String> proteinInferenceTooltipMap = new HashMap<Integer, String>();
        proteinInferenceTooltipMap.put(0, "Single Protein");
        proteinInferenceTooltipMap.put(1, "Related Proteins");
        proteinInferenceTooltipMap.put(2, "Related and Unrelated Proteins");
        proteinInferenceTooltipMap.put(3, "Unrelated Proteins");
        proteinTable.getColumn("Accession").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(TableProperties.getSelectedRowHtmlTagFontColor(), TableProperties.getNotSelectedRowHtmlTagFontColor()));
        proteinTable.getColumn("PI").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(sparklineColor, proteinInferenceColorMap, proteinInferenceTooltipMap));
        Color nonValidatedColor = sparklineColorNotValidated;
        ArrayList<Color> sparklineColors = new ArrayList<Color>(4);
        sparklineColors.add(sparklineColor);
        sparklineColors.add(sparklineColorDoubtful);
        sparklineColors.add(nonValidatedColor);
        sparklineColors.add(sparklineColorNotFound);
        JSparklinesArrayListBarChartTableCellRenderer coverageCellRendered = new JSparklinesArrayListBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), sparklineColors, JSparklinesArrayListBarChartTableCellRenderer.ValueDisplayType.sumExceptLastNumber);
        coverageCellRendered.showNumberAndChart(true, TableProperties.getLabelWidth(), new DecimalFormat("0.00"));
        proteinTable.getColumn("Coverage").setCellRenderer((TableCellRenderer)coverageCellRendered);
        JSparklinesArrayListBarChartTableCellRenderer peptidesCellRenderer = new JSparklinesArrayListBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), sparklineColors, JSparklinesArrayListBarChartTableCellRenderer.ValueDisplayType.sumOfNumbers);
        peptidesCellRenderer.showNumberAndChart(true, TableProperties.getLabelWidth(), new DecimalFormat("0"));
        proteinTable.getColumn("#Peptides").setCellRenderer((TableCellRenderer)peptidesCellRenderer);
        JSparklinesArrayListBarChartTableCellRenderer spectraCellRenderer = new JSparklinesArrayListBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), sparklineColors, JSparklinesArrayListBarChartTableCellRenderer.ValueDisplayType.sumOfNumbers);
        spectraCellRenderer.showNumberAndChart(true, TableProperties.getLabelWidth(), new DecimalFormat("0"));
        proteinTable.getColumn("#Spectra").setCellRenderer((TableCellRenderer)spectraCellRenderer);
        JSparklinesBarChartTableCellRenderer spectrumCountingCellRenderer = new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(10.0), sparklineColor);
        spectrumCountingCellRenderer.showNumberAndChart(true, TableProperties.getLabelWidth() + 20, new DecimalFormat("0.00E00"));
        proteinTable.getColumn("Quant").setCellRenderer((TableCellRenderer)spectrumCountingCellRenderer);
        JSparklinesBarChartTableCellRenderer mwCellRenderer = new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(10.0), sparklineColor);
        mwCellRenderer.showNumberAndChart(true, TableProperties.getLabelWidth());
        proteinTable.getColumn("MW").setCellRenderer((TableCellRenderer)mwCellRenderer);
        proteinTable.getColumn("Chr").setCellRenderer((TableCellRenderer)new ChromosomeTableCellRenderer(Color.WHITE, Color.BLACK));
        try {
            proteinTable.getColumn("Confidence").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), sparklineColor));
            ((JSparklinesBarChartTableCellRenderer)proteinTable.getColumn("Confidence").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 20, scoreAndConfidenceDecimalFormat);
        }
        catch (IllegalArgumentException e) {
            proteinTable.getColumn("Score").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), sparklineColor));
            ((JSparklinesBarChartTableCellRenderer)proteinTable.getColumn("Score").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 20, scoreAndConfidenceDecimalFormat);
        }
        proteinTable.getColumn("").setCellRenderer((TableCellRenderer)new JSparklinesIntegerIconTableCellRenderer(MatchValidationLevel.getIconMap(parentClass), MatchValidationLevel.getTooltipMap()));
        proteinTable.getColumn("  ").setCellRenderer((TableCellRenderer)new TrueFalseIconRenderer(new ImageIcon(parentClass.getResource("/icons/star_yellow.png")), new ImageIcon(parentClass.getResource("/icons/star_grey.png")), new ImageIcon(parentClass.getResource("/icons/star_grey.png")), "Starred", null, null));
        if (maxProteinKeyLength != null) {
            Integer width = ProteinTableModel.getPreferredAccessionColumnWidth(proteinTable, proteinTable.getColumn("Accession").getModelIndex(), 6, maxProteinKeyLength);
            if (width != null) {
                proteinTable.getColumn("Accession").setMinWidth(width);
                proteinTable.getColumn("Accession").setMaxWidth(width);
            } else {
                proteinTable.getColumn("Accession").setMinWidth(15);
                proteinTable.getColumn("Accession").setMaxWidth(Integer.MAX_VALUE);
            }
        }
    }

    public static Integer getPreferredAccessionColumnWidth(JTable table, int colIndex, int margin, Integer maxProteinKeyLength) {
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
        TableColumn col = colModel.getColumn(colIndex);
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
        int width = comp.getPreferredSize().width;
        if (maxProteinKeyLength == null || maxProteinKeyLength + 5 > table.getColumnName(colIndex).length() + margin) {
            return null;
        }
        return width += 2 * margin;
    }
}

