/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.tablemodels;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.gui.tablemodels.SelfUpdatingTableModel;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.gui.tabpanels.SpectrumIdentificationPanel;
import eu.isas.peptideshaker.scoring.PSMaps;
import eu.isas.peptideshaker.scoring.maps.InputMap;
import eu.isas.peptideshaker.utils.DisplayFeaturesGenerator;
import java.util.ArrayList;

public class PsmTableModel
extends SelfUpdatingTableModel {
    private Identification identification;
    private DisplayFeaturesGenerator displayFeaturesGenerator;
    private InputMap inputMap;
    private final SpectrumProvider spectrumProvider;
    private final ExceptionHandler exceptionHandler;
    private IdentificationParameters identificationParameters;
    private long[] psmKeys = null;
    private boolean showScores = false;

    public PsmTableModel() {
        this.identification = null;
        this.displayFeaturesGenerator = null;
        this.identificationParameters = null;
        this.psmKeys = new long[0];
        this.showScores = false;
        this.exceptionHandler = null;
        this.inputMap = null;
        this.spectrumProvider = null;
    }

    public PsmTableModel(Identification identification, DisplayFeaturesGenerator displayFeaturesGenerator, SpectrumProvider spectrumProvider, IdentificationParameters identificationParameters, long[] psmKeys, boolean displayScores, ExceptionHandler exceptionHandler) {
        this.identification = identification;
        this.displayFeaturesGenerator = displayFeaturesGenerator;
        this.spectrumProvider = spectrumProvider;
        this.identificationParameters = identificationParameters;
        this.psmKeys = psmKeys;
        this.showScores = displayScores;
        this.exceptionHandler = exceptionHandler;
        PSMaps pSMaps = new PSMaps();
        pSMaps = (PSMaps)identification.getUrParam(pSMaps);
        this.inputMap = pSMaps.getInputMap();
    }

    public void updateDataModel(Identification identification, DisplayFeaturesGenerator displayFeaturesGenerator, IdentificationParameters identificationParameters, long[] psmKeys) {
        this.identification = identification;
        this.displayFeaturesGenerator = displayFeaturesGenerator;
        this.identificationParameters = identificationParameters;
        this.psmKeys = psmKeys;
        PSMaps pSMaps = new PSMaps();
        pSMaps = (PSMaps)identification.getUrParam(pSMaps);
        this.inputMap = pSMaps.getInputMap();
    }

    public void showScores(boolean showScores) {
        this.showScores = showScores;
    }

    public void reset() {
        this.psmKeys = null;
    }

    @Override
    public int getRowCount() {
        return this.psmKeys == null ? 0 : this.psmKeys.length;
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return " ";
            }
            case 1: {
                return "  ";
            }
            case 2: {
                return "ID";
            }
            case 3: {
                return "Sequence";
            }
            case 4: {
                return "Charge";
            }
            case 5: {
                return "m/z Error";
            }
            case 6: {
                return this.showScores ? "Score" : "Confidence";
            }
            case 7: {
                return "";
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int row, int column) {
        int viewIndex = this.getViewIndex(row);
        if (viewIndex < this.psmKeys.length) {
            if (column == 0) {
                return viewIndex + 1;
            }
            long psmKey = this.psmKeys[viewIndex];
            SpectrumMatch spectrumMatch = this.identification.getSpectrumMatch(psmKey);
            switch (column) {
                case 1: {
                    PSParameter psParameter = (PSParameter)spectrumMatch.getUrParam(PSParameter.dummy);
                    return psParameter.getStarred();
                }
                case 2: {
                    return SpectrumIdentificationPanel.isBestPsmEqualForAllIdSoftware(spectrumMatch, this.identificationParameters.getSequenceMatchingParameters(), this.inputMap.getInputAlgorithmsSorted().size());
                }
                case 3: {
                    return this.displayFeaturesGenerator.getTaggedPeptideSequence(spectrumMatch, true, true, true);
                }
                case 4: {
                    if (spectrumMatch.getBestPeptideAssumption() != null) {
                        return spectrumMatch.getBestPeptideAssumption().getIdentificationCharge();
                    }
                    if (spectrumMatch.getBestTagAssumption() != null) {
                        return spectrumMatch.getBestTagAssumption().getIdentificationCharge();
                    }
                    throw new IllegalArgumentException("No best assumption found for spectrum " + psmKey + ".");
                }
                case 5: {
                    String spectrumFile = spectrumMatch.getSpectrumFile();
                    String spectrumTitle = spectrumMatch.getSpectrumTitle();
                    double precursorMz = this.spectrumProvider.getPrecursorMz(spectrumFile, spectrumTitle);
                    SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
                    if (spectrumMatch.getBestPeptideAssumption() != null) {
                        return Math.abs(spectrumMatch.getBestPeptideAssumption().getDeltaMz(precursorMz, searchParameters.isPrecursorAccuracyTypePpm(), searchParameters.getMinIsotopicCorrection(), searchParameters.getMaxIsotopicCorrection()));
                    }
                    if (spectrumMatch.getBestTagAssumption() != null) {
                        return Math.abs(spectrumMatch.getBestTagAssumption().getDeltaMz(precursorMz, searchParameters.isPrecursorAccuracyTypePpm(), searchParameters.getMinIsotopicCorrection(), searchParameters.getMaxIsotopicCorrection()));
                    }
                    throw new IllegalArgumentException("No best assumption found for spectrum " + psmKey + ".");
                }
                case 6: {
                    PSParameter psParameter = (PSParameter)spectrumMatch.getUrParam(PSParameter.dummy);
                    return this.showScores ? psParameter.getTransformedScore() : psParameter.getConfidence();
                }
                case 7: {
                    PSParameter psParameter = (PSParameter)spectrumMatch.getUrParam(PSParameter.dummy);
                    return psParameter.getMatchValidationLevel().getIndex();
                }
            }
            return null;
        }
        return null;
    }

    public boolean isInstantiated() {
        return this.identification != null;
    }

    public Class getColumnClass(int columnIndex) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getValueAt(i, columnIndex) == null) continue;
            return this.getValueAt(i, columnIndex).getClass();
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    protected void catchException(Exception e) {
        this.setSelfUpdating(false);
        this.exceptionHandler.catchException(e);
    }

    @Override
    protected int loadDataForRows(ArrayList<Integer> rows, WaitingHandler waitingHandler) {
        boolean canceled = rows.stream().map(i -> this.identification.getSpectrumMatch(this.psmKeys[i])).anyMatch(dummy -> waitingHandler.isRunCanceled());
        return canceled ? rows.get(0) : rows.get(rows.size() - 1);
    }
}

