/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.tabpanels;

import com.compomics.util.Util;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.biology.genes.ProteinGeneDetailsProvider;
import com.compomics.util.experiment.biology.genes.go.GoDomains;
import com.compomics.util.experiment.biology.genes.go.GoMapping;
import com.compomics.util.experiment.biology.taxonomy.SpeciesFactory;
import com.compomics.util.experiment.biology.taxonomy.mappings.EnsemblSpecies;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.ProteinMatchesIterator;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.experiment.io.biology.protein.FastaSummary;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.TableProperties;
import com.compomics.util.gui.XYPlottingDialog;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.export.graphics.ExportGraphicsDialog;
import com.compomics.util.gui.parameters.identification.advanced.BackgroundSpeciesDialog;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.json.JsonMarshaller;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.GeneParameters;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import eu.isas.peptideshaker.gui.tablemodels.ProteinGoTableModel;
import eu.isas.peptideshaker.gui.tablemodels.ProteinTableModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.data.JSparklinesDataSeries;
import no.uib.jsparklines.data.JSparklinesDataset;
import no.uib.jsparklines.data.ValueAndBooleanDataPoint;
import no.uib.jsparklines.data.XYDataPoint;
import no.uib.jsparklines.extra.HtmlLinksRenderer;
import no.uib.jsparklines.extra.TrueFalseIconRenderer;
import no.uib.jsparklines.renderers.JSparklinesArrayListBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesIntegerIconTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesTableCellRenderer;
import no.uib.jsparklines.renderers.util.BarChartColorRenderer;
import org.apache.commons.math.distribution.HypergeometricDistributionImpl;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryMarker;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.Layer;

public class GOEAPanel
extends JPanel {
    private ArrayList<String> proteinTableToolTips;
    private ProgressDialogX progressDialog;
    private final PeptideShakerGUI peptideShakerGUI;
    private ArrayList<String> mappingsTableToolTips;
    private ChartPanel distributionChartPanel = null;
    private ChartPanel signChartPanel = null;
    private String currentGoMappingsColumn = null;
    private SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
    private JPanel contextMenuMappingsBackgroundPanel;
    private JPanel contextMenuPlotsBackgroundPanel;
    private JMenuItem deselectAllMenuItem;
    private JButton exportMappingsJButton;
    private JButton exportPlotsJButton;
    private JRadioButton fivePercentRadioButton;
    private JPanel goFrequencyPlotPanel;
    private JTable goMappingsTable;
    private JTabbedPane goPlotsTabbedPane;
    private JLabel goProteinCountLabel;
    private JPanel goSignificancePlotPanel;
    private JPopupMenu.Separator jSeparator1;
    private JButton mappingsHelpJButton;
    private JPanel mappingsPanel;
    private JLayeredPane mappingsTableLayeredPane;
    private JRadioButton onePercentRadioButton;
    private JButton plotHelpJButton;
    private JLayeredPane plotLayeredPane;
    private JPanel plotPanel;
    private JScrollPane proteinGoMappingsScrollPane;
    private JTable proteinTable;
    private JPanel proteinsPanel;
    private JScrollPane proteinsScrollPane;
    private JMenuItem selectAllMenuItem;
    private JMenuItem selectSignificantMenuItem;
    private JPopupMenu selectTermsJPopupMenu;
    private JLabel significanceJLabel;
    private ButtonGroup significanceLevelButtonGroup;
    private JMenuItem statisticsMenuItem;

    public GOEAPanel(PeptideShakerGUI peptideShakerGUI) {
        this.peptideShakerGUI = peptideShakerGUI;
        this.initComponents();
        this.setUpGUI();
    }

    private void setUpGUI() {
        JPanel proteinCorner = new JPanel();
        proteinCorner.setBackground(this.goMappingsTable.getTableHeader().getBackground());
        this.proteinsScrollPane.setCorner("UPPER_RIGHT_CORNER", proteinCorner);
        JPanel goMappingsCorner = new JPanel();
        goMappingsCorner.setBackground(this.goMappingsTable.getTableHeader().getBackground());
        this.proteinGoMappingsScrollPane.setCorner("UPPER_RIGHT_CORNER", goMappingsCorner);
        JTableHeader header = this.goMappingsTable.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (GOEAPanel.this.peptideShakerGUI.getIdentification() != null) {
                    GOEAPanel.this.updateGoPlots();
                }
            }
        });
        this.goMappingsTable.getTableHeader().setReorderingAllowed(false);
        this.proteinTable.getTableHeader().setReorderingAllowed(false);
        this.goMappingsTable.setAutoCreateRowSorter(true);
        this.proteinTable.setAutoCreateRowSorter(true);
        this.proteinGoMappingsScrollPane.getViewport().setOpaque(false);
        this.proteinsScrollPane.getViewport().setOpaque(false);
        this.goMappingsTable.getColumn("").setMaxWidth(60);
        this.goMappingsTable.getColumn("").setMinWidth(60);
        this.goMappingsTable.getColumn("  ").setMaxWidth(30);
        this.goMappingsTable.getColumn("  ").setMinWidth(30);
        double significanceLevel = 0.05;
        if (this.onePercentRadioButton.isSelected()) {
            significanceLevel = 0.01;
        }
        this.goMappingsTable.getColumn("GO Accession").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(TableProperties.getSelectedRowHtmlTagFontColor(), TableProperties.getNotSelectedRowHtmlTagFontColor()));
        this.goMappingsTable.getColumn("Frequency All (%)").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), Color.RED));
        ((JSparklinesBarChartTableCellRenderer)this.goMappingsTable.getColumn("Frequency All (%)").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth());
        this.goMappingsTable.getColumn("Frequency Dataset (%)").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), this.peptideShakerGUI.getSparklineColor()));
        ((JSparklinesBarChartTableCellRenderer)this.goMappingsTable.getColumn("Frequency Dataset (%)").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth());
        this.goMappingsTable.getColumn("p-value").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(1.0), this.peptideShakerGUI.getSparklineColor(), Color.lightGray, significanceLevel));
        ((JSparklinesBarChartTableCellRenderer)this.goMappingsTable.getColumn("p-value").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth());
        this.goMappingsTable.getColumn("Log2 Diff").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(-10.0), Double.valueOf(10.0), Color.RED, this.peptideShakerGUI.getSparklineColor(), Color.lightGray, 0.0));
        ((JSparklinesBarChartTableCellRenderer)this.goMappingsTable.getColumn("Log2 Diff").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth());
        this.goMappingsTable.getColumn("Frequency (%)").setCellRenderer((TableCellRenderer)new JSparklinesTableCellRenderer(JSparklinesTableCellRenderer.PlotType.barChart, PlotOrientation.HORIZONTAL, Double.valueOf(0.0), Double.valueOf(100.0)));
        this.goMappingsTable.getColumn("  ").setCellRenderer((TableCellRenderer)new TrueFalseIconRenderer(new ImageIcon(this.getClass().getResource("/icons/selected_green-new.png")), null, "Selected", null));
        this.goPlotsTabbedPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.mappingsTableToolTips = new ArrayList();
        this.mappingsTableToolTips.add(null);
        this.mappingsTableToolTips.add("Gene Ontology Accession");
        this.mappingsTableToolTips.add("Gene Ontology Term");
        this.mappingsTableToolTips.add("Gene Ontology Domain");
        this.mappingsTableToolTips.add("Frequency All (%)");
        this.mappingsTableToolTips.add("Frequency Dataset (%)");
        this.mappingsTableToolTips.add("Frequency (%) (All & Dataset))");
        this.mappingsTableToolTips.add("Log2 Difference (Dataset / All)");
        this.mappingsTableToolTips.add("<html>Hypergeometic Test<br>FDR-Corrected</html>");
        this.mappingsTableToolTips.add("Selected for Plots");
        this.proteinTableToolTips = new ArrayList();
        this.proteinTableToolTips.add(null);
        this.proteinTableToolTips.add("Protein Accession Number");
        this.proteinTableToolTips.add("Protein Description");
        this.proteinTableToolTips.add("Protein Sequence Coverage (%) (Confident / Doubtful / Not Validated / Possible)");
        this.proteinTableToolTips.add("Number of Peptides (Validated / Doubtful / Not Validated)");
        this.proteinTableToolTips.add("Number of Spectra (Validated / Doubtful / Not Validated)");
        this.proteinTableToolTips.add("MS2 Quantification");
        this.proteinTableToolTips.add("Protein Confidence");
        this.proteinTableToolTips.add("Validated");
    }

    private void setProteinGoTableProperties() {
        this.proteinTable.getColumn(" ").setMaxWidth(60);
        this.proteinTable.getColumn(" ").setMinWidth(60);
        this.proteinTable.getColumn("  ").setMaxWidth(30);
        this.proteinTable.getColumn("  ").setMinWidth(30);
        try {
            this.proteinTable.getColumn("Confidence").setMaxWidth(90);
            this.proteinTable.getColumn("Confidence").setMinWidth(90);
        }
        catch (IllegalArgumentException w) {
            this.proteinTable.getColumn("Score").setMaxWidth(90);
            this.proteinTable.getColumn("Score").setMinWidth(90);
        }
        Integer width = ProteinTableModel.getPreferredAccessionColumnWidth(this.proteinTable, this.proteinTable.getColumn("Accession").getModelIndex(), 6, this.peptideShakerGUI.getMetrics().getMaxProteinAccessionLength());
        if (width != null) {
            this.proteinTable.getColumn("Accession").setMinWidth(width);
            this.proteinTable.getColumn("Accession").setMaxWidth(width);
        } else {
            this.proteinTable.getColumn("Accession").setMinWidth(15);
            this.proteinTable.getColumn("Accession").setMaxWidth(Integer.MAX_VALUE);
        }
        this.proteinTable.getColumn("Accession").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(TableProperties.getSelectedRowHtmlTagFontColor(), TableProperties.getNotSelectedRowHtmlTagFontColor()));
        Color nonValidatedColor = this.peptideShakerGUI.getSparklineColorNonValidated();
        if (!this.peptideShakerGUI.getIdentificationParameters().getFastaParameters().isTargetDecoy()) {
            nonValidatedColor = this.peptideShakerGUI.getUtilitiesUserParameters().getSparklineColorNotFound();
        }
        ArrayList<Color> sparklineColors = new ArrayList<Color>();
        sparklineColors.add(this.peptideShakerGUI.getSparklineColor());
        sparklineColors.add(this.peptideShakerGUI.getUtilitiesUserParameters().getSparklineColorDoubtful());
        sparklineColors.add(nonValidatedColor);
        this.proteinTable.getColumn("#Peptides").setCellRenderer((TableCellRenderer)new JSparklinesArrayListBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), sparklineColors, JSparklinesArrayListBarChartTableCellRenderer.ValueDisplayType.sumOfNumbers));
        ((JSparklinesArrayListBarChartTableCellRenderer)this.proteinTable.getColumn("#Peptides").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth(), new DecimalFormat("0"));
        this.proteinTable.getColumn("#Spectra").setCellRenderer((TableCellRenderer)new JSparklinesArrayListBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), sparklineColors, JSparklinesArrayListBarChartTableCellRenderer.ValueDisplayType.sumOfNumbers));
        ((JSparklinesArrayListBarChartTableCellRenderer)this.proteinTable.getColumn("#Spectra").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth(), new DecimalFormat("0"));
        this.proteinTable.getColumn("MS2 Quant.").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(10.0), this.peptideShakerGUI.getSparklineColor()));
        ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("MS2 Quant.").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth(), new DecimalFormat("0.00E00"));
        try {
            this.proteinTable.getColumn("Confidence").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), this.peptideShakerGUI.getSparklineColor()));
            ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("Confidence").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 20, this.peptideShakerGUI.getScoreAndConfidenceDecimalFormat());
        }
        catch (IllegalArgumentException e) {
            this.proteinTable.getColumn("Score").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), this.peptideShakerGUI.getSparklineColor()));
            ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("Score").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 20, this.peptideShakerGUI.getScoreAndConfidenceDecimalFormat());
        }
        this.proteinTable.getColumn("  ").setCellRenderer((TableCellRenderer)new JSparklinesIntegerIconTableCellRenderer(MatchValidationLevel.getIconMap(this.getClass()), MatchValidationLevel.getTooltipMap()));
        sparklineColors = new ArrayList();
        sparklineColors.add(this.peptideShakerGUI.getSparklineColor());
        sparklineColors.add(this.peptideShakerGUI.getUtilitiesUserParameters().getSparklineColorDoubtful());
        sparklineColors.add(nonValidatedColor);
        sparklineColors.add(this.peptideShakerGUI.getUtilitiesUserParameters().getSparklineColorNotFound());
        JSparklinesArrayListBarChartTableCellRenderer coverageCellRendered = new JSparklinesArrayListBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), sparklineColors, JSparklinesArrayListBarChartTableCellRenderer.ValueDisplayType.sumExceptLastNumber);
        coverageCellRendered.showNumberAndChart(true, TableProperties.getLabelWidth(), new DecimalFormat("0.00"));
        this.proteinTable.getColumn("Coverage").setCellRenderer((TableCellRenderer)coverageCellRendered);
        this.proteinTable.getRowSorter().addRowSorterListener(new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent e) {
                if (e.getType() == RowSorterEvent.Type.SORT_ORDER_CHANGED) {
                    GOEAPanel.this.peptideShakerGUI.setCursor(new Cursor(3));
                    GOEAPanel.this.proteinTable.getTableHeader().setCursor(new Cursor(3));
                    GOEAPanel.this.peptideShakerGUI.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")));
                } else if (e.getType() == RowSorterEvent.Type.SORTED) {
                    GOEAPanel.this.peptideShakerGUI.setCursor(new Cursor(0));
                    GOEAPanel.this.proteinTable.getTableHeader().setCursor(new Cursor(0));
                    GOEAPanel.this.peptideShakerGUI.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                }
            }
        });
    }

    public void displayResults() {
        GeneMaps geneMaps;
        if (this.peptideShakerGUI.getIdentification() != null && (geneMaps = this.peptideShakerGUI.getGeneMaps()).hasGoMappings()) {
            this.progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            this.progressDialog.setTitle("Getting GO Mappings. Please Wait...");
            this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        GOEAPanel.this.progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("GoThread"){

                @Override
                public void run() {
                    DefaultTableModel dm = (DefaultTableModel)GOEAPanel.this.goMappingsTable.getModel();
                    dm.getDataVector().removeAllElements();
                    dm.fireTableDataChanged();
                    TreeMap<String, Integer> datasetGoTermUsage = new TreeMap<String, Integer>();
                    try {
                        GOEAPanel.this.progressDialog.setTitle("Importing GO (1/3). Please Wait...");
                        GoMapping backgroundGoMapping = new GoMapping();
                        String speciesLatinName = null;
                        IdentificationParameters identificationParameters = GOEAPanel.this.peptideShakerGUI.getIdentificationParameters();
                        GeneParameters genePreferences = identificationParameters.getGeneParameters();
                        if (genePreferences != null) {
                            speciesLatinName = genePreferences.getBackgroundSpecies();
                        }
                        if (speciesLatinName == null) {
                            FastaSummary fastaSummary = FastaSummary.getSummary(GOEAPanel.this.peptideShakerGUI.getProjectDetails().getFastaFile(), identificationParameters.getFastaParameters(), GOEAPanel.this.progressDialog);
                            BackgroundSpeciesDialog backgroundSpeciesDialog = new BackgroundSpeciesDialog(GOEAPanel.this.peptideShakerGUI, genePreferences, fastaSummary);
                            if (!backgroundSpeciesDialog.isCanceled()) {
                                genePreferences = backgroundSpeciesDialog.getGeneParameters();
                                identificationParameters.setGeneParameters(genePreferences);
                                speciesLatinName = genePreferences.getBackgroundSpecies();
                            }
                        }
                        if (speciesLatinName != null) {
                            ProteinMatch proteinMatch;
                            String speciesSynonym;
                            String organismNameLowerCase = speciesLatinName.toLowerCase();
                            if (organismNameLowerCase.lastIndexOf("(") != -1) {
                                organismNameLowerCase = organismNameLowerCase.substring(0, organismNameLowerCase.indexOf("(") - 1);
                            }
                            organismNameLowerCase = organismNameLowerCase.toLowerCase().replaceAll(" ", "_");
                            if (!GOEAPanel.this.speciesFactory.getEnsemblSpecies().getLatinNames().contains(organismNameLowerCase) && (speciesSynonym = GOEAPanel.this.speciesFactory.getUniprotTaxonomy().getSynonym(speciesLatinName)) != null) {
                                organismNameLowerCase = speciesSynonym.toLowerCase().replaceAll(" ", "_");
                            }
                            EnsemblSpecies.EnsemblDivision ensemblDivision = GOEAPanel.this.speciesFactory.getEnsemblSpecies().getDivision(organismNameLowerCase);
                            String ensemblDatasetName = GOEAPanel.this.speciesFactory.getEnsemblDatasetName(organismNameLowerCase, ensemblDivision);
                            File goMappingFile = ProteinGeneDetailsProvider.getGoMappingFile(ensemblDatasetName);
                            backgroundGoMapping.loadMappingsFromFile(goMappingFile, GOEAPanel.this.progressDialog);
                            GoDomains goDomains = new GoDomains();
                            File goDomainsFile = ProteinGeneDetailsProvider.getGoDomainsFile();
                            goDomains.loadMappingFromFile(goDomainsFile, GOEAPanel.this.progressDialog);
                            Identification identification = GOEAPanel.this.peptideShakerGUI.getIdentification();
                            GOEAPanel.this.progressDialog.setTitle("Getting GO Mappings (2/3). Please Wait...");
                            GOEAPanel.this.progressDialog.setPrimaryProgressCounterIndeterminate(false);
                            GOEAPanel.this.progressDialog.setMaxPrimaryProgressCounter(identification.getProteinIdentification().size());
                            GOEAPanel.this.progressDialog.setValue(0);
                            int totalNumberOfGoMappedProteinsInProject = 0;
                            ProteinMatchesIterator proteinMatchesIterator = identification.getProteinMatchesIterator(GOEAPanel.this.progressDialog);
                            while ((proteinMatch = proteinMatchesIterator.next()) != null) {
                                String mainMatch;
                                HashSet<String> goTerms;
                                PSParameter psParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy);
                                if (psParameter.getMatchValidationLevel().isValidated() && !proteinMatch.isDecoy() && !psParameter.getHidden() && (goTerms = backgroundGoMapping.getGoAccessions(mainMatch = proteinMatch.getLeadingAccession())) != null && !goTerms.isEmpty()) {
                                    ++totalNumberOfGoMappedProteinsInProject;
                                    for (String goTerm : goTerms) {
                                        Integer usage = (Integer)datasetGoTermUsage.get(goTerm);
                                        if (usage == null) {
                                            usage = 0;
                                        }
                                        datasetGoTermUsage.put(goTerm, usage + 1);
                                    }
                                }
                                if (GOEAPanel.this.progressDialog.isRunCanceled()) {
                                    return;
                                }
                                GOEAPanel.this.progressDialog.increasePrimaryProgressCounter();
                            }
                            ArrayList<String> termNamesMapped = backgroundGoMapping.getSortedTermNames();
                            int nBackgroundProteins = backgroundGoMapping.getProteinToGoMap().size();
                            GOEAPanel.this.progressDialog.setTitle("Creating GO Plots (3/3). Please Wait...");
                            GOEAPanel.this.progressDialog.setValue(0);
                            GOEAPanel.this.progressDialog.setMaxPrimaryProgressCounter(termNamesMapped.size());
                            Double maxLog2Diff = 0.0;
                            ArrayList<Integer> indexes = new ArrayList<Integer>();
                            ArrayList<Double> pValues = new ArrayList<Double>();
                            GOEAPanel.this.goProteinCountLabel.setText("[GO Proteins: Ensembl: " + nBackgroundProteins + ", Project: " + totalNumberOfGoMappedProteinsInProject + "]");
                            boolean goDomainChanged = false;
                            for (String goTermName : termNamesMapped) {
                                String goDomain;
                                if (GOEAPanel.this.progressDialog.isRunCanceled()) break;
                                String goAccession = backgroundGoMapping.getTermAccession(goTermName);
                                Integer frequencyBackground = backgroundGoMapping.getProteinAccessions(goAccession).size();
                                Integer frequencyDataset = 0;
                                Double percentDataset = 0.0;
                                if (datasetGoTermUsage.get(goAccession) != null) {
                                    frequencyDataset = (Integer)datasetGoTermUsage.get(goAccession);
                                    percentDataset = (double)frequencyDataset.intValue() * 100.0 / (double)totalNumberOfGoMappedProteinsInProject;
                                }
                                Double percentAll = (double)frequencyBackground.intValue() * 100.0 / (double)nBackgroundProteins;
                                Double pValue = new HypergeometricDistributionImpl(nBackgroundProteins, frequencyBackground.intValue(), totalNumberOfGoMappedProteinsInProject).probability(frequencyDataset.intValue());
                                Double log2Diff = Math.log(percentDataset / percentAll) / Math.log(2.0);
                                if (!log2Diff.isInfinite() && Math.abs(log2Diff) > maxLog2Diff) {
                                    maxLog2Diff = Math.abs(log2Diff);
                                }
                                if ((goDomain = goDomains.getTermDomain(goAccession)) == null) {
                                    URL u = new URL("https://www.ebi.ac.uk/QuickGO/services/ontology/go/terms/" + goAccession);
                                    JsonMarshaller jsonMarshaller = new JsonMarshaller();
                                    QuickGoTerm result = (QuickGoTerm)jsonMarshaller.fromJson(QuickGoTerm.class, u);
                                    for (QuickGoTerm.DummyResults tempResult : result.results) {
                                        goDomain = tempResult.aspect;
                                    }
                                    goDomains.addDomain(goAccession, goDomain);
                                    goDomainChanged = true;
                                }
                                ArrayList<Double> dataAll = new ArrayList<Double>();
                                dataAll.add(percentAll);
                                ArrayList<Double> dataDataset = new ArrayList<Double>();
                                dataDataset.add(percentDataset);
                                JSparklinesDataSeries sparklineDataseriesAll = new JSparklinesDataSeries(dataAll, Color.RED, "All");
                                JSparklinesDataSeries sparklineDataseriesDataset = new JSparklinesDataSeries(dataDataset, GOEAPanel.this.peptideShakerGUI.getSparklineColor(), "Dataset");
                                ArrayList<JSparklinesDataSeries> sparkLineDataSeries = new ArrayList<JSparklinesDataSeries>();
                                sparkLineDataSeries.add(sparklineDataseriesAll);
                                sparkLineDataSeries.add(sparklineDataseriesDataset);
                                JSparklinesDataset dataset = new JSparklinesDataset(sparkLineDataSeries);
                                pValues.add(pValue);
                                indexes.add(GOEAPanel.this.goMappingsTable.getRowCount());
                                ((DefaultTableModel)GOEAPanel.this.goMappingsTable.getModel()).addRow(new Object[]{GOEAPanel.this.goMappingsTable.getRowCount() + 1, GOEAPanel.this.peptideShakerGUI.getDisplayFeaturesGenerator().addGoLink(goAccession), goTermName, goDomain, percentAll, percentDataset, dataset, new ValueAndBooleanDataPoint(log2Diff.doubleValue(), false), pValue, true});
                                GOEAPanel.this.progressDialog.increasePrimaryProgressCounter();
                            }
                            if (indexes.isEmpty()) {
                                GOEAPanel.this.progressDialog.setRunCanceled();
                            }
                            int significantCounter = 0;
                            double significanceLevel = 0.05;
                            if (GOEAPanel.this.onePercentRadioButton.isSelected()) {
                                significanceLevel = 0.01;
                            }
                            if (!GOEAPanel.this.progressDialog.isRunCanceled()) {
                                ((DefaultTableModel)GOEAPanel.this.goMappingsTable.getModel()).fireTableDataChanged();
                                GOEAPanel.this.sortPValues(pValues, indexes);
                                ((ValueAndBooleanDataPoint)((DefaultTableModel)GOEAPanel.this.goMappingsTable.getModel()).getValueAt((Integer)indexes.get(0), GOEAPanel.this.goMappingsTable.getColumn("Log2 Diff").getModelIndex())).setSignificant((Double)pValues.get(0) < significanceLevel);
                                ((DefaultTableModel)GOEAPanel.this.goMappingsTable.getModel()).setValueAt(new XYDataPoint(((Double)pValues.get(0)).doubleValue(), ((Double)pValues.get(0)).doubleValue()), (Integer)indexes.get(0), GOEAPanel.this.goMappingsTable.getColumn("p-value").getModelIndex());
                                if ((Double)pValues.get(0) < significanceLevel) {
                                    ++significantCounter;
                                }
                                for (int i = 1; i < pValues.size() && !GOEAPanel.this.progressDialog.isRunCanceled(); ++i) {
                                    double tempPvalue = (Double)pValues.get(i) * (double)pValues.size() / (double)(pValues.size() - i);
                                    if (tempPvalue > 1.0) {
                                        tempPvalue = 1.0;
                                    }
                                    ((ValueAndBooleanDataPoint)((DefaultTableModel)GOEAPanel.this.goMappingsTable.getModel()).getValueAt((Integer)indexes.get(i), GOEAPanel.this.goMappingsTable.getColumn("Log2 Diff").getModelIndex())).setSignificant(tempPvalue < significanceLevel);
                                    ((DefaultTableModel)GOEAPanel.this.goMappingsTable.getModel()).setValueAt(new XYDataPoint(tempPvalue, tempPvalue), (Integer)indexes.get(i), GOEAPanel.this.goMappingsTable.getColumn("p-value").getModelIndex());
                                    if (!(tempPvalue < significanceLevel)) continue;
                                    ++significantCounter;
                                }
                            }
                            if (!GOEAPanel.this.progressDialog.isRunCanceled()) {
                                ((TitledBorder)GOEAPanel.this.mappingsPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Gene Ontology Mappings (" + significantCounter + "/" + GOEAPanel.this.goMappingsTable.getRowCount() + ")" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
                                GOEAPanel.this.mappingsPanel.repaint();
                                GOEAPanel.this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
                                Integer width = ProteinTableModel.getPreferredAccessionColumnWidth(GOEAPanel.this.goMappingsTable, GOEAPanel.this.goMappingsTable.getColumn("GO Accession").getModelIndex(), 6, GOEAPanel.this.peptideShakerGUI.getMetrics().getMaxProteinAccessionLength());
                                if (width != null) {
                                    GOEAPanel.this.goMappingsTable.getColumn("GO Accession").setMinWidth(width);
                                    GOEAPanel.this.goMappingsTable.getColumn("GO Accession").setMaxWidth(width);
                                } else {
                                    GOEAPanel.this.goMappingsTable.getColumn("GO Accession").setMinWidth(15);
                                    GOEAPanel.this.goMappingsTable.getColumn("GO Accession").setMaxWidth(Integer.MAX_VALUE);
                                }
                                maxLog2Diff = Math.ceil(maxLog2Diff);
                                GOEAPanel.this.goMappingsTable.getColumn("Log2 Diff").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(-maxLog2Diff.doubleValue()), maxLog2Diff, Color.RED, GOEAPanel.this.peptideShakerGUI.getSparklineColor(), Color.lightGray, 0.0));
                                ((JSparklinesBarChartTableCellRenderer)GOEAPanel.this.goMappingsTable.getColumn("Log2 Diff").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth());
                                GOEAPanel.this.updateGoPlots();
                                GOEAPanel.this.exportMappingsJButton.setEnabled(true);
                                GOEAPanel.this.exportPlotsJButton.setEnabled(true);
                                GOEAPanel.this.peptideShakerGUI.setUpdated(6, true);
                            }
                            if (goDomainChanged && goDomainsFile.exists()) {
                                goDomains.saveMapping(goDomainsFile);
                            }
                            GOEAPanel.this.progressDialog.setRunFinished();
                        }
                    }
                    catch (Exception e) {
                        GOEAPanel.this.progressDialog.setRunFinished();
                        GOEAPanel.this.peptideShakerGUI.catchException(e);
                    }
                }
            }.start();
        }
    }

    private void updateGoPlots() {
        this.setCursor(new Cursor(3));
        DefaultCategoryDataset frquencyPlotDataset = new DefaultCategoryDataset();
        DefaultCategoryDataset significancePlotDataset = new DefaultCategoryDataset();
        ArrayList<Color> significanceColors = new ArrayList<Color>();
        Double maxLog2Diff = 0.0;
        for (int i = 0; i < this.goMappingsTable.getRowCount(); ++i) {
            boolean selected = (Boolean)this.goMappingsTable.getValueAt(i, this.goMappingsTable.getColumn("  ").getModelIndex());
            boolean significant = ((ValueAndBooleanDataPoint)this.goMappingsTable.getValueAt(i, this.goMappingsTable.getColumn("Log2 Diff").getModelIndex())).isSignificant();
            if (!selected) continue;
            String goTerm = (String)this.goMappingsTable.getValueAt(i, this.goMappingsTable.getColumn("GO Term").getModelIndex());
            Double percentAll = (Double)this.goMappingsTable.getValueAt(i, this.goMappingsTable.getColumn("Frequency All (%)").getModelIndex());
            Double percentDataset = (Double)this.goMappingsTable.getValueAt(i, this.goMappingsTable.getColumn("Frequency Dataset (%)").getModelIndex());
            Double log2Diff = ((ValueAndBooleanDataPoint)this.goMappingsTable.getValueAt(i, this.goMappingsTable.getColumn("Log2 Diff").getModelIndex())).getValue();
            frquencyPlotDataset.addValue((Number)percentAll, (Comparable)((Object)"All"), (Comparable)((Object)goTerm));
            frquencyPlotDataset.addValue((Number)percentDataset, (Comparable)((Object)"Dataset"), (Comparable)((Object)goTerm));
            if (!log2Diff.isInfinite()) {
                significancePlotDataset.addValue((Number)log2Diff, (Comparable)((Object)"Difference"), (Comparable)((Object)goTerm));
            } else {
                significancePlotDataset.addValue(0.0, (Comparable)((Object)"Difference"), (Comparable)((Object)goTerm));
            }
            if (significant) {
                if (log2Diff > 0.0) {
                    significanceColors.add(this.peptideShakerGUI.getSparklineColor());
                } else {
                    significanceColors.add(new Color(255, 51, 51));
                }
            } else {
                significanceColors.add(Color.lightGray);
            }
            if (log2Diff.isInfinite() || !(Math.abs(log2Diff) > maxLog2Diff)) continue;
            maxLog2Diff = Math.abs(log2Diff);
        }
        maxLog2Diff = Math.ceil(maxLog2Diff);
        JFreeChart distributionChart = ChartFactory.createBarChart(null, (String)"GO Terms", (String)"Frequency (%)", (CategoryDataset)frquencyPlotDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)true);
        this.distributionChartPanel = new ChartPanel(distributionChart, false);
        ((CategoryPlot)this.distributionChartPanel.getChart().getPlot()).getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        BarRenderer3D renderer = new BarRenderer3D(0.0, 0.0);
        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        renderer.setSeriesPaint(0, (Paint)Color.RED);
        renderer.setSeriesPaint(1, (Paint)this.peptideShakerGUI.getSparklineColor());
        distributionChart.getCategoryPlot().setRenderer((CategoryItemRenderer)renderer);
        this.distributionChartPanel.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent cme) {
                if (cme.getEntity() instanceof CategoryItemEntity) {
                    CategoryItemEntity categoryItem = (CategoryItemEntity)cme.getEntity();
                    String columnKey = (String)((Object)categoryItem.getColumnKey());
                    boolean categoryFound = false;
                    for (int i = 0; i < GOEAPanel.this.goMappingsTable.getRowCount() && !categoryFound; ++i) {
                        if (!((String)GOEAPanel.this.goMappingsTable.getValueAt(i, GOEAPanel.this.goMappingsTable.getColumn("GO Term").getModelIndex())).equalsIgnoreCase(columnKey)) continue;
                        GOEAPanel.this.goMappingsTable.setRowSelectionInterval(i, i);
                        GOEAPanel.this.goMappingsTable.scrollRectToVisible(GOEAPanel.this.goMappingsTable.getCellRect(i, 0, false));
                        GOEAPanel.this.goMappingsTableMouseReleased(null);
                    }
                }
            }

            public void chartMouseMoved(ChartMouseEvent cme) {
            }
        });
        distributionChart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
        distributionChart.setBackgroundPaint((Paint)Color.WHITE);
        this.distributionChartPanel.setBackground(Color.WHITE);
        distributionChart.getPlot().setOutlineVisible(false);
        this.goFrequencyPlotPanel.removeAll();
        this.goFrequencyPlotPanel.add((Component)this.distributionChartPanel);
        this.goFrequencyPlotPanel.revalidate();
        this.goFrequencyPlotPanel.repaint();
        JFreeChart significanceChart = ChartFactory.createBarChart(null, (String)"GO Terms", (String)"Log2 Difference", (CategoryDataset)significancePlotDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)true);
        this.signChartPanel = new ChartPanel(significanceChart, false);
        ((CategoryPlot)this.signChartPanel.getChart().getPlot()).getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        ((CategoryPlot)this.signChartPanel.getChart().getPlot()).getRangeAxis().setUpperBound(maxLog2Diff.doubleValue());
        ((CategoryPlot)this.signChartPanel.getChart().getPlot()).getRangeAxis().setLowerBound(-maxLog2Diff.doubleValue());
        BarChartColorRenderer signRenderer = new BarChartColorRenderer(significanceColors);
        signRenderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        significanceChart.getCategoryPlot().setRenderer((CategoryItemRenderer)signRenderer);
        this.signChartPanel.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent cme) {
                if (cme.getEntity() instanceof CategoryItemEntity) {
                    CategoryItemEntity categoryItem = (CategoryItemEntity)cme.getEntity();
                    String columnKey = (String)((Object)categoryItem.getColumnKey());
                    boolean categoryFound = false;
                    for (int i = 0; i < GOEAPanel.this.goMappingsTable.getRowCount() && !categoryFound; ++i) {
                        if (!((String)GOEAPanel.this.goMappingsTable.getValueAt(i, GOEAPanel.this.goMappingsTable.getColumn("GO Term").getModelIndex())).equalsIgnoreCase(columnKey)) continue;
                        GOEAPanel.this.goMappingsTable.setRowSelectionInterval(i, i);
                        GOEAPanel.this.goMappingsTable.scrollRectToVisible(GOEAPanel.this.goMappingsTable.getCellRect(i, 0, false));
                        GOEAPanel.this.goMappingsTableMouseReleased(null);
                    }
                }
            }

            public void chartMouseMoved(ChartMouseEvent cme) {
            }
        });
        significanceChart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
        significanceChart.setBackgroundPaint((Paint)Color.WHITE);
        this.signChartPanel.setBackground(Color.WHITE);
        significanceChart.getPlot().setOutlineVisible(false);
        this.goSignificancePlotPanel.removeAll();
        this.goSignificancePlotPanel.add((Component)this.signChartPanel);
        this.goSignificancePlotPanel.revalidate();
        this.goSignificancePlotPanel.repaint();
        this.updatePlotMarkers();
        this.setCursor(new Cursor(0));
    }

    private void initComponents() {
        this.selectTermsJPopupMenu = new JPopupMenu();
        this.selectAllMenuItem = new JMenuItem();
        this.deselectAllMenuItem = new JMenuItem();
        this.selectSignificantMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.statisticsMenuItem = new JMenuItem();
        this.significanceLevelButtonGroup = new ButtonGroup();
        this.mappingsTableLayeredPane = new JLayeredPane();
        this.mappingsPanel = new JPanel();
        this.proteinGoMappingsScrollPane = new JScrollPane();
        this.goMappingsTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)GOEAPanel.this.mappingsTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.significanceJLabel = new JLabel();
        this.fivePercentRadioButton = new JRadioButton();
        this.onePercentRadioButton = new JRadioButton();
        this.goProteinCountLabel = new JLabel();
        this.mappingsHelpJButton = new JButton();
        this.exportMappingsJButton = new JButton();
        this.contextMenuMappingsBackgroundPanel = new JPanel();
        this.plotLayeredPane = new JLayeredPane();
        this.plotPanel = new JPanel();
        this.goPlotsTabbedPane = new JTabbedPane();
        this.proteinsPanel = new JPanel();
        this.proteinsScrollPane = new JScrollPane();
        this.proteinTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)GOEAPanel.this.proteinTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.goFrequencyPlotPanel = new JPanel();
        this.goSignificancePlotPanel = new JPanel();
        this.plotHelpJButton = new JButton();
        this.exportPlotsJButton = new JButton();
        this.contextMenuPlotsBackgroundPanel = new JPanel();
        this.selectAllMenuItem.setText("Select All");
        this.selectAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GOEAPanel.this.selectAllMenuItemActionPerformed(evt);
            }
        });
        this.selectTermsJPopupMenu.add(this.selectAllMenuItem);
        this.deselectAllMenuItem.setText("Deselect All");
        this.deselectAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GOEAPanel.this.deselectAllMenuItemActionPerformed(evt);
            }
        });
        this.selectTermsJPopupMenu.add(this.deselectAllMenuItem);
        this.selectSignificantMenuItem.setText("Select Significant");
        this.selectSignificantMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GOEAPanel.this.selectSignificantMenuItemActionPerformed(evt);
            }
        });
        this.selectTermsJPopupMenu.add(this.selectSignificantMenuItem);
        this.selectTermsJPopupMenu.add(this.jSeparator1);
        this.statisticsMenuItem.setText("Statistics (beta)");
        this.statisticsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GOEAPanel.this.statisticsMenuItemActionPerformed(evt);
            }
        });
        this.selectTermsJPopupMenu.add(this.statisticsMenuItem);
        this.setBackground(new Color(255, 255, 255));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                GOEAPanel.this.formComponentResized(evt);
            }
        });
        this.mappingsPanel.setBorder(BorderFactory.createTitledBorder(null, "Gene Ontology Mappings", 0, 0, new Font("sansserif", 1, 14)));
        this.mappingsPanel.setOpaque(false);
        this.goMappingsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"", "GO Accession", "GO Term", "GO Domain", "Frequency All (%)", "Frequency Dataset (%)", "Frequency (%)", "Log2 Diff", "p-value", "  "}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, String.class, String.class, Double.class, Double.class, ValueAndBooleanDataPoint.class, Object.class, Double.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false, false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.goMappingsTable.setOpaque(false);
        this.goMappingsTable.setSelectionMode(0);
        this.goMappingsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                GOEAPanel.this.goMappingsTableMouseReleased(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                GOEAPanel.this.goMappingsTableMouseExited(evt);
            }
        });
        this.goMappingsTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                GOEAPanel.this.goMappingsTableMouseMoved(evt);
            }
        });
        this.goMappingsTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                GOEAPanel.this.goMappingsTableKeyReleased(evt);
            }
        });
        this.proteinGoMappingsScrollPane.setViewportView(this.goMappingsTable);
        this.significanceJLabel.setText("Significance Level:");
        this.significanceLevelButtonGroup.add(this.fivePercentRadioButton);
        this.fivePercentRadioButton.setSelected(true);
        this.fivePercentRadioButton.setText("0.05");
        this.fivePercentRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GOEAPanel.this.fivePercentRadioButtonActionPerformed(evt);
            }
        });
        this.significanceLevelButtonGroup.add(this.onePercentRadioButton);
        this.onePercentRadioButton.setText("0.01");
        this.onePercentRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GOEAPanel.this.onePercentRadioButtonActionPerformed(evt);
            }
        });
        this.goProteinCountLabel.setText("[GO Proteins: Ensembl: -, Project: -]");
        this.goProteinCountLabel.setToolTipText("Number of GO mapped proteins");
        GroupLayout mappingsPanelLayout = new GroupLayout(this.mappingsPanel);
        this.mappingsPanel.setLayout(mappingsPanelLayout);
        mappingsPanelLayout.setHorizontalGroup(mappingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mappingsPanelLayout.createSequentialGroup().addGroup(mappingsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(mappingsPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.proteinGoMappingsScrollPane, -1, 988, Short.MAX_VALUE)).addGroup(mappingsPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.goProteinCountLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.significanceJLabel).addGap(18, 18, 18).addComponent(this.onePercentRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fivePercentRadioButton).addGap(13, 13, 13))).addContainerGap()));
        mappingsPanelLayout.setVerticalGroup(mappingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mappingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinGoMappingsScrollPane, -1, 285, Short.MAX_VALUE).addGap(12, 12, 12).addGroup(mappingsPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.significanceJLabel).addComponent(this.onePercentRadioButton).addComponent(this.fivePercentRadioButton).addComponent(this.goProteinCountLabel)).addContainerGap()));
        this.mappingsTableLayeredPane.add(this.mappingsPanel);
        this.mappingsPanel.setBounds(0, 0, 1020, 372);
        this.mappingsHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.mappingsHelpJButton.setToolTipText("Help");
        this.mappingsHelpJButton.setBorder(null);
        this.mappingsHelpJButton.setBorderPainted(false);
        this.mappingsHelpJButton.setContentAreaFilled(false);
        this.mappingsHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.mappingsHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                GOEAPanel.this.mappingsHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                GOEAPanel.this.mappingsHelpJButtonMouseExited(evt);
            }
        });
        this.mappingsHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GOEAPanel.this.mappingsHelpJButtonActionPerformed(evt);
            }
        });
        this.mappingsTableLayeredPane.setLayer(this.mappingsHelpJButton, JLayeredPane.POPUP_LAYER);
        this.mappingsTableLayeredPane.add(this.mappingsHelpJButton);
        this.mappingsHelpJButton.setBounds(990, 0, 10, 19);
        this.exportMappingsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportMappingsJButton.setToolTipText("Copy to Clipboard");
        this.exportMappingsJButton.setBorder(null);
        this.exportMappingsJButton.setBorderPainted(false);
        this.exportMappingsJButton.setContentAreaFilled(false);
        this.exportMappingsJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportMappingsJButton.setEnabled(false);
        this.exportMappingsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportMappingsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                GOEAPanel.this.exportMappingsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                GOEAPanel.this.exportMappingsJButtonMouseExited(evt);
            }
        });
        this.exportMappingsJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GOEAPanel.this.exportMappingsJButtonActionPerformed(evt);
            }
        });
        this.mappingsTableLayeredPane.setLayer(this.exportMappingsJButton, JLayeredPane.POPUP_LAYER);
        this.mappingsTableLayeredPane.add(this.exportMappingsJButton);
        this.exportMappingsJButton.setBounds(980, 0, 10, 19);
        this.contextMenuMappingsBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuMappingsBackgroundPanelLayout = new GroupLayout(this.contextMenuMappingsBackgroundPanel);
        this.contextMenuMappingsBackgroundPanel.setLayout(contextMenuMappingsBackgroundPanelLayout);
        contextMenuMappingsBackgroundPanelLayout.setHorizontalGroup(contextMenuMappingsBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        contextMenuMappingsBackgroundPanelLayout.setVerticalGroup(contextMenuMappingsBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.mappingsTableLayeredPane.setLayer(this.contextMenuMappingsBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.mappingsTableLayeredPane.add(this.contextMenuMappingsBackgroundPanel);
        this.contextMenuMappingsBackgroundPanel.setBounds(980, 0, 30, 19);
        this.plotPanel.setBorder(BorderFactory.createTitledBorder(null, "Gene Ontology Enrichment Analysis", 0, 0, new Font("sansserif", 1, 14)));
        this.plotPanel.setOpaque(false);
        this.goPlotsTabbedPane.setTabPlacement(3);
        this.goPlotsTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                GOEAPanel.this.goPlotsTabbedPaneStateChanged(evt);
            }
        });
        this.proteinsPanel.setOpaque(false);
        this.proteinTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Accession", "Description", "Coverage", "#Peptides", "#Spectra", "MS2 Quant.", "Confidence", "  "}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, String.class, Object.class, Integer.class, Integer.class, Double.class, Double.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.proteinTable.setSelectionMode(0);
        this.proteinTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                GOEAPanel.this.proteinTableMouseReleased(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                GOEAPanel.this.proteinTableMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                GOEAPanel.this.proteinTableMouseExited(evt);
            }
        });
        this.proteinTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                GOEAPanel.this.proteinTableMouseMoved(evt);
            }
        });
        this.proteinTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                GOEAPanel.this.proteinTableKeyReleased(evt);
            }
        });
        this.proteinsScrollPane.setViewportView(this.proteinTable);
        GroupLayout proteinsPanelLayout = new GroupLayout(this.proteinsPanel);
        this.proteinsPanel.setLayout(proteinsPanelLayout);
        proteinsPanelLayout.setHorizontalGroup(proteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proteinsScrollPane, -1, 982, Short.MAX_VALUE));
        proteinsPanelLayout.setVerticalGroup(proteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, proteinsPanelLayout.createSequentialGroup().addComponent(this.proteinsScrollPane, -1, 277, Short.MAX_VALUE).addContainerGap()));
        this.goPlotsTabbedPane.addTab("Proteins", this.proteinsPanel);
        this.goFrequencyPlotPanel.setBackground(new Color(255, 255, 255));
        this.goFrequencyPlotPanel.setLayout(new BoxLayout(this.goFrequencyPlotPanel, 2));
        this.goPlotsTabbedPane.addTab("Frequency", this.goFrequencyPlotPanel);
        this.goSignificancePlotPanel.setBackground(new Color(255, 255, 255));
        this.goSignificancePlotPanel.setLayout(new BoxLayout(this.goSignificancePlotPanel, 2));
        this.goPlotsTabbedPane.addTab("Significance", this.goSignificancePlotPanel);
        this.goPlotsTabbedPane.setSelectedIndex(2);
        GroupLayout plotPanelLayout = new GroupLayout(this.plotPanel);
        this.plotPanel.setLayout(plotPanelLayout);
        plotPanelLayout.setHorizontalGroup(plotPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.goPlotsTabbedPane).addContainerGap()));
        plotPanelLayout.setVerticalGroup(plotPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, plotPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.goPlotsTabbedPane, -1, 313, Short.MAX_VALUE).addContainerGap()));
        this.plotLayeredPane.add(this.plotPanel);
        this.plotPanel.setBounds(0, 0, 1022, 370);
        this.plotHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.plotHelpJButton.setToolTipText("Help");
        this.plotHelpJButton.setBorder(null);
        this.plotHelpJButton.setBorderPainted(false);
        this.plotHelpJButton.setContentAreaFilled(false);
        this.plotHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.plotHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                GOEAPanel.this.plotHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                GOEAPanel.this.plotHelpJButtonMouseExited(evt);
            }
        });
        this.plotHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GOEAPanel.this.plotHelpJButtonActionPerformed(evt);
            }
        });
        this.plotLayeredPane.setLayer(this.plotHelpJButton, JLayeredPane.POPUP_LAYER);
        this.plotLayeredPane.add(this.plotHelpJButton);
        this.plotHelpJButton.setBounds(990, 0, 10, 19);
        this.exportPlotsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportPlotsJButton.setToolTipText("Export");
        this.exportPlotsJButton.setBorder(null);
        this.exportPlotsJButton.setBorderPainted(false);
        this.exportPlotsJButton.setContentAreaFilled(false);
        this.exportPlotsJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportPlotsJButton.setEnabled(false);
        this.exportPlotsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportPlotsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                GOEAPanel.this.exportPlotsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                GOEAPanel.this.exportPlotsJButtonMouseExited(evt);
            }
        });
        this.exportPlotsJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GOEAPanel.this.exportPlotsJButtonActionPerformed(evt);
            }
        });
        this.plotLayeredPane.setLayer(this.exportPlotsJButton, JLayeredPane.POPUP_LAYER);
        this.plotLayeredPane.add(this.exportPlotsJButton);
        this.exportPlotsJButton.setBounds(980, 0, 10, 19);
        this.contextMenuPlotsBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuPlotsBackgroundPanelLayout = new GroupLayout(this.contextMenuPlotsBackgroundPanel);
        this.contextMenuPlotsBackgroundPanel.setLayout(contextMenuPlotsBackgroundPanelLayout);
        contextMenuPlotsBackgroundPanelLayout.setHorizontalGroup(contextMenuPlotsBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        contextMenuPlotsBackgroundPanelLayout.setVerticalGroup(contextMenuPlotsBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.plotLayeredPane.setLayer(this.contextMenuPlotsBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.plotLayeredPane.add(this.contextMenuPlotsBackgroundPanel);
        this.contextMenuPlotsBackgroundPanel.setBounds(980, 0, 30, 19);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.plotLayeredPane, GroupLayout.Alignment.LEADING, -1, 1019, Short.MAX_VALUE).addComponent(this.mappingsTableLayeredPane, GroupLayout.Alignment.LEADING, -1, 1019, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.mappingsTableLayeredPane, -2, 365, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.plotLayeredPane, -1, 372, Short.MAX_VALUE).addContainerGap()));
    }

    private void goMappingsTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void goMappingsTableMouseMoved(MouseEvent evt) {
        int row = this.goMappingsTable.rowAtPoint(evt.getPoint());
        int column = this.goMappingsTable.columnAtPoint(evt.getPoint());
        if (column == this.goMappingsTable.getColumn("GO Accession").getModelIndex() && this.goMappingsTable.getValueAt(row, column) != null) {
            String tempValue = (String)this.goMappingsTable.getValueAt(row, column);
            if (tempValue.lastIndexOf("<a href=\"") != -1) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    private void goMappingsTableMouseReleased(MouseEvent evt) {
        int row = this.goMappingsTable.getSelectedRow();
        int column = this.goMappingsTable.getSelectedColumn();
        if (row != -1) {
            this.setCursor(new Cursor(3));
            if (evt == null || evt.getButton() == 1) {
                if (column == this.goMappingsTable.getColumn("GO Accession").getModelIndex() && evt != null && evt.getButton() == 1 && ((String)this.goMappingsTable.getValueAt(row, column)).lastIndexOf("<a href=\"") != -1) {
                    String link = (String)this.goMappingsTable.getValueAt(row, column);
                    link = link.substring(link.indexOf("\"") + 1);
                    link = link.substring(0, link.indexOf("\""));
                    this.setCursor(new Cursor(3));
                    BareBonesBrowserLaunch.openURL(link);
                    this.setCursor(new Cursor(0));
                } else if (column == this.goMappingsTable.getColumn("  ").getModelIndex()) {
                    this.updateGoPlots();
                }
                this.updatePlotMarkers();
                this.updateProteinTable();
            }
            this.setCursor(new Cursor(0));
        }
        if (evt != null && this.goMappingsTable.getRowCount() > 0 && evt.getButton() == 3) {
            this.currentGoMappingsColumn = this.goMappingsTable.getColumnName(this.goMappingsTable.columnAtPoint(evt.getPoint()));
            this.selectTermsJPopupMenu.show(this.goMappingsTable, evt.getX(), evt.getY());
        } else {
            this.currentGoMappingsColumn = null;
        }
    }

    private void selectAllMenuItemActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.goMappingsTable.getRowCount(); ++i) {
            ((DefaultTableModel)this.goMappingsTable.getModel()).setValueAt(true, i, this.goMappingsTable.getColumn("  ").getModelIndex());
        }
        this.updateGoPlots();
    }

    private void deselectAllMenuItemActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.goMappingsTable.getRowCount(); ++i) {
            ((DefaultTableModel)this.goMappingsTable.getModel()).setValueAt(false, i, this.goMappingsTable.getColumn("  ").getModelIndex());
        }
        this.updateGoPlots();
    }

    private void selectSignificantMenuItemActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.goMappingsTable.getRowCount(); ++i) {
            if (((ValueAndBooleanDataPoint)this.goMappingsTable.getModel().getValueAt(i, this.goMappingsTable.getColumn("Log2 Diff").getModelIndex())).isSignificant()) {
                ((DefaultTableModel)this.goMappingsTable.getModel()).setValueAt(true, i, this.goMappingsTable.getColumn("  ").getModelIndex());
                continue;
            }
            ((DefaultTableModel)this.goMappingsTable.getModel()).setValueAt(false, i, this.goMappingsTable.getColumn("  ").getModelIndex());
        }
        this.updateGoPlots();
    }

    private void goMappingsTableKeyReleased(KeyEvent evt) {
        this.updatePlotMarkers();
        this.updateProteinTable();
    }

    private void formComponentResized(ComponentEvent evt) {
        this.mappingsTableLayeredPane.getComponent(0).setBounds(this.mappingsTableLayeredPane.getWidth() - this.mappingsTableLayeredPane.getComponent(0).getWidth() - 10, -3, this.mappingsTableLayeredPane.getComponent(0).getWidth(), this.mappingsTableLayeredPane.getComponent(0).getHeight());
        this.mappingsTableLayeredPane.getComponent(1).setBounds(this.mappingsTableLayeredPane.getWidth() - this.mappingsTableLayeredPane.getComponent(1).getWidth() - 20, -3, this.mappingsTableLayeredPane.getComponent(1).getWidth(), this.mappingsTableLayeredPane.getComponent(1).getHeight());
        this.mappingsTableLayeredPane.getComponent(2).setBounds(this.mappingsTableLayeredPane.getWidth() - this.mappingsTableLayeredPane.getComponent(2).getWidth() - 5, -3, this.mappingsTableLayeredPane.getComponent(2).getWidth(), this.mappingsTableLayeredPane.getComponent(2).getHeight());
        this.mappingsTableLayeredPane.getComponent(3).setBounds(0, 0, this.mappingsTableLayeredPane.getWidth(), this.mappingsTableLayeredPane.getHeight());
        this.mappingsTableLayeredPane.revalidate();
        this.mappingsTableLayeredPane.repaint();
        this.plotLayeredPane.getComponent(0).setBounds(this.plotLayeredPane.getWidth() - this.plotLayeredPane.getComponent(0).getWidth() - 10, -3, this.plotLayeredPane.getComponent(0).getWidth(), this.plotLayeredPane.getComponent(0).getHeight());
        this.plotLayeredPane.getComponent(1).setBounds(this.plotLayeredPane.getWidth() - this.plotLayeredPane.getComponent(1).getWidth() - 20, -3, this.plotLayeredPane.getComponent(1).getWidth(), this.plotLayeredPane.getComponent(1).getHeight());
        this.plotLayeredPane.getComponent(2).setBounds(this.plotLayeredPane.getWidth() - this.plotLayeredPane.getComponent(2).getWidth() - 5, -3, this.plotLayeredPane.getComponent(2).getWidth(), this.plotLayeredPane.getComponent(2).getHeight());
        this.plotLayeredPane.getComponent(3).setBounds(0, 0, this.plotLayeredPane.getWidth(), this.plotLayeredPane.getHeight());
        this.plotLayeredPane.revalidate();
        this.plotLayeredPane.repaint();
    }

    private void mappingsHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void mappingsHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void mappingsHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.peptideShakerGUI, this.getClass().getResource("/helpFiles/GOEA.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Gene Ontology Analysis - Help");
        this.setCursor(new Cursor(0));
    }

    private void exportMappingsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportMappingsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportMappingsJButtonActionPerformed(ActionEvent evt) {
        this.progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setTitle("Copying to Clipboard. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                GOEAPanel.this.progressDialog.setVisible(true);
            }
        }, "ProgressDialog").start();
        new Thread("ExportThread"){

            @Override
            public void run() {
                try {
                    String clipboardString = Util.tableToText(GOEAPanel.this.goMappingsTable, "\t", GOEAPanel.this.progressDialog, true);
                    StringSelection stringSelection = new StringSelection(clipboardString);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, GOEAPanel.this.peptideShakerGUI);
                    boolean processCancelled = GOEAPanel.this.progressDialog.isRunCanceled();
                    GOEAPanel.this.progressDialog.setRunFinished();
                    if (!processCancelled) {
                        JOptionPane.showMessageDialog(GOEAPanel.this.peptideShakerGUI, "Table content copied to clipboard.", "Copied to Clipboard", 1);
                    }
                }
                catch (Exception e) {
                    GOEAPanel.this.progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(GOEAPanel.this.peptideShakerGUI, "An error occurred while generating the output.", "Output Error.", 0);
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private void plotHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void plotHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void plotHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        if (this.goPlotsTabbedPane.getSelectedIndex() == 0) {
            new HelpDialog(this.peptideShakerGUI, this.getClass().getResource("/helpFiles/GOEA.html"), "#Proteins", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Gene Ontology Analysis - Help");
        } else {
            new HelpDialog(this.peptideShakerGUI, this.getClass().getResource("/helpFiles/GOEA.html"), "#GO_Plots", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Gene Ontology Analysis - Help");
        }
        this.setCursor(new Cursor(0));
    }

    private void exportPlotsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportPlotsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportPlotsJButtonActionPerformed(ActionEvent evt) {
        int index = this.goPlotsTabbedPane.getSelectedIndex();
        if (index == 1) {
            new ExportGraphicsDialog((JFrame)this.peptideShakerGUI, this.peptideShakerGUI.getNormalIcon(), this.peptideShakerGUI.getWaitingIcon(), true, (ChartPanel)this.goFrequencyPlotPanel.getComponent(0), this.peptideShakerGUI.getLastSelectedFolder());
        } else if (index == 2) {
            new ExportGraphicsDialog((JFrame)this.peptideShakerGUI, this.peptideShakerGUI.getNormalIcon(), this.peptideShakerGUI.getWaitingIcon(), true, (ChartPanel)this.goSignificancePlotPanel.getComponent(0), this.peptideShakerGUI.getLastSelectedFolder());
        } else {
            final File selectedFile = this.peptideShakerGUI.getUserSelectedFile("proteins.txt", ".txt", "Tab separated text file (.txt)", "Export...", false);
            if (selectedFile != null) {
                this.progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
                this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
                this.progressDialog.setTitle("Exporting to File. Please Wait...");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            GOEAPanel.this.progressDialog.setVisible(true);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                }, "ProgressDialog").start();
                new Thread("ExportThread"){

                    @Override
                    public void run() {
                        try {
                            BufferedWriter writer = new BufferedWriter(new FileWriter(selectedFile));
                            Util.tableToFile(GOEAPanel.this.proteinTable, "\t", GOEAPanel.this.progressDialog, true, writer);
                            writer.close();
                            boolean processCancelled = GOEAPanel.this.progressDialog.isRunCanceled();
                            GOEAPanel.this.progressDialog.setRunFinished();
                            if (!processCancelled) {
                                JOptionPane.showMessageDialog(GOEAPanel.this.peptideShakerGUI, "Data copied to file:\n" + selectedFile.getAbsolutePath(), "Data Exported.", 1);
                            }
                        }
                        catch (IOException e) {
                            GOEAPanel.this.progressDialog.setRunFinished();
                            JOptionPane.showMessageDialog(null, "An error occurred when exporting the table content.", "Export Failed", 0);
                            e.printStackTrace();
                        }
                    }
                }.start();
            }
        }
    }

    private void fivePercentRadioButtonActionPerformed(ActionEvent evt) {
        this.updateMappings();
    }

    private void onePercentRadioButtonActionPerformed(ActionEvent evt) {
        this.updateMappings();
    }

    private void proteinTableMouseMoved(MouseEvent evt) {
        int row = this.proteinTable.rowAtPoint(evt.getPoint());
        int column = this.proteinTable.columnAtPoint(evt.getPoint());
        this.proteinTable.setToolTipText(null);
        if (row != -1 && column != -1 && column == this.proteinTable.getColumn("Accession").getModelIndex() && this.proteinTable.getValueAt(row, column) != null) {
            String tempValue = (String)this.proteinTable.getValueAt(row, column);
            if (tempValue.lastIndexOf("<a href=\"") != -1) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        } else if (column == this.proteinTable.getColumn("Description").getModelIndex() && this.proteinTable.getValueAt(row, column) != null) {
            if (GuiUtilities.getPreferredWidthOfCell(this.proteinTable, row, column) > this.proteinTable.getColumn("Description").getWidth()) {
                this.proteinTable.setToolTipText("" + this.proteinTable.getValueAt(row, column));
            }
            this.setCursor(new Cursor(0));
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    private void proteinTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void proteinTableMouseReleased(MouseEvent evt) {
        int row = this.proteinTable.getSelectedRow();
        int column = this.proteinTable.getSelectedColumn();
        if (row != -1 && evt.getButton() == 1) {
            this.proteinTableKeyReleased(null);
            if (column == this.proteinTable.getColumn("Accession").getModelIndex() && ((String)this.proteinTable.getValueAt(row, column)).lastIndexOf("<a href=\"") != -1) {
                String link = (String)this.proteinTable.getValueAt(row, column);
                link = link.substring(link.indexOf("\"") + 1);
                link = link.substring(0, link.indexOf("\""));
                this.setCursor(new Cursor(3));
                BareBonesBrowserLaunch.openURL(link);
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void proteinTableKeyReleased(KeyEvent evt) {
        int row = this.proteinTable.getSelectedRow();
        if (row != -1) {
            ProteinGoTableModel proteinGoTableModel = (ProteinGoTableModel)this.proteinTable.getModel();
            int selectedGroupIndex = this.proteinTable.convertRowIndexToModel(this.proteinTable.getSelectedRow());
            long proteinGroupKey = proteinGoTableModel.getProteins().get(selectedGroupIndex);
            String spectrumFile = null;
            String spectrumTitle = null;
            long peptideKey = this.peptideShakerGUI.getDefaultPeptideSelection(proteinGroupKey);
            if (peptideKey != ExperimentObject.NO_KEY) {
                long psmKey = this.peptideShakerGUI.getDefaultPsmSelection(peptideKey);
                SpectrumMatch spectrumMatch = this.peptideShakerGUI.getIdentification().getSpectrumMatch(psmKey);
                spectrumFile = spectrumMatch.getSpectrumFile();
                spectrumTitle = spectrumMatch.getSpectrumTitle();
            }
            this.peptideShakerGUI.setSelectedItems(proteinGroupKey, peptideKey, spectrumFile, spectrumTitle);
        }
    }

    private void statisticsMenuItemActionPerformed(ActionEvent evt) {
        new XYPlottingDialog(this.peptideShakerGUI, this.goMappingsTable, this.currentGoMappingsColumn, XYPlottingDialog.PlottingDialogPlotType.densityPlot, this.mappingsTableToolTips, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
    }

    private void goPlotsTabbedPaneStateChanged(ChangeEvent evt) {
        if (this.goPlotsTabbedPane.getSelectedIndex() == 0 && this.goMappingsTable.getSelectedRow() == -1 && this.goMappingsTable.getRowCount() > 0) {
            this.goMappingsTable.setRowSelectionInterval(0, 0);
            this.goMappingsTableKeyReleased(null);
        }
    }

    private void proteinTableMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3 && this.proteinTable.getRowCount() > 0) {
            final MouseEvent event = evt;
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Statistics (beta)");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    new XYPlottingDialog(GOEAPanel.this.peptideShakerGUI, GOEAPanel.this.proteinTable, GOEAPanel.this.proteinTable.getColumnName(GOEAPanel.this.proteinTable.columnAtPoint(event.getPoint())), XYPlottingDialog.PlottingDialogPlotType.densityPlot, GOEAPanel.this.proteinTableToolTips, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
                }
            });
            popupMenu.add(menuItem);
            popupMenu.show(this.proteinTable, evt.getX(), evt.getY());
        }
    }

    private void updatePlotMarkers() {
        this.setCursor(new Cursor(3));
        if (this.signChartPanel != null && this.goMappingsTable.getSelectedRow() != -1) {
            this.removePlotMarkers();
            this.signChartPanel.getChart().getCategoryPlot().addDomainMarker(new CategoryMarker((Comparable)((Object)((String)this.goMappingsTable.getValueAt(this.goMappingsTable.getSelectedRow(), this.goMappingsTable.getColumn("GO Term").getModelIndex()))), (Paint)Color.LIGHT_GRAY, (Stroke)new BasicStroke(1.0f), (Paint)Color.LIGHT_GRAY, (Stroke)new BasicStroke(1.0f), 0.2f), Layer.BACKGROUND);
            this.distributionChartPanel.getChart().getCategoryPlot().addDomainMarker(new CategoryMarker((Comparable)((Object)((String)this.goMappingsTable.getValueAt(this.goMappingsTable.getSelectedRow(), this.goMappingsTable.getColumn("GO Term").getModelIndex()))), (Paint)Color.LIGHT_GRAY, (Stroke)new BasicStroke(1.0f), (Paint)Color.LIGHT_GRAY, (Stroke)new BasicStroke(1.0f), 0.2f), Layer.BACKGROUND);
            ((TitledBorder)this.plotPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Gene Ontology Enrichment Analysis - " + this.goMappingsTable.getValueAt(this.goMappingsTable.getSelectedRow(), this.goMappingsTable.getColumn("GO Term").getModelIndex()) + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
        } else {
            ((TitledBorder)this.plotPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Gene Ontology Enrichment Analysis" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
        }
        this.plotPanel.repaint();
        this.setCursor(new Cursor(0));
    }

    private void removePlotMarkers() {
        if (this.signChartPanel != null && this.signChartPanel.getChart().getCategoryPlot().getDomainMarkers(Layer.BACKGROUND) != null) {
            int i;
            Iterator iterator = this.signChartPanel.getChart().getCategoryPlot().getDomainMarkers(Layer.BACKGROUND).iterator();
            ArrayList<CategoryMarker> tempMarkers = new ArrayList<CategoryMarker>();
            while (iterator.hasNext()) {
                tempMarkers.add((CategoryMarker)iterator.next());
            }
            for (i = 0; i < tempMarkers.size(); ++i) {
                this.signChartPanel.getChart().getCategoryPlot().removeDomainMarker(i, (Marker)tempMarkers.get(i), Layer.BACKGROUND);
            }
            iterator = this.distributionChartPanel.getChart().getCategoryPlot().getDomainMarkers(Layer.BACKGROUND).iterator();
            tempMarkers = new ArrayList();
            while (iterator.hasNext()) {
                tempMarkers.add((CategoryMarker)iterator.next());
            }
            for (i = 0; i < tempMarkers.size(); ++i) {
                this.distributionChartPanel.getChart().getCategoryPlot().removeDomainMarker(i, (Marker)tempMarkers.get(i), Layer.BACKGROUND);
            }
            this.goPlotsTabbedPane.repaint();
        }
    }

    private void sortPValues(ArrayList<Double> pValues, ArrayList<Integer> tableIndexes) {
        for (int i = 0; i < pValues.size(); ++i) {
            double maxValue = -1.0;
            int maxIndex = -1;
            for (int j = i; j < pValues.size(); ++j) {
                if (!(pValues.get(j) > maxValue)) continue;
                maxValue = pValues.get(j);
                maxIndex = j;
            }
            double oldValue = pValues.get(i);
            pValues.set(i, pValues.get(maxIndex));
            pValues.set(maxIndex, oldValue);
            int oldIntValue = tableIndexes.get(i);
            tableIndexes.set(i, tableIndexes.get(maxIndex));
            tableIndexes.set(maxIndex, oldIntValue);
        }
    }

    public void updateMappings() {
        double significanceLevel = 0.05;
        if (this.onePercentRadioButton.isSelected()) {
            significanceLevel = 0.01;
        }
        this.goMappingsTable.getColumn("p-value").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(1.0), this.peptideShakerGUI.getSparklineColor(), Color.lightGray, significanceLevel));
        ((JSparklinesBarChartTableCellRenderer)this.goMappingsTable.getColumn("p-value").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth());
        this.clearOldResults();
        if (this.peptideShakerGUI.getIdentification() != null) {
            final Thread displayThread = new Thread("DisplayThread"){

                @Override
                public void run() {
                    GOEAPanel.this.displayResults();
                }
            };
            Thread appThread = new Thread(){

                @Override
                public void run() {
                    try {
                        SwingUtilities.invokeAndWait(displayThread);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            appThread.start();
        }
    }

    public void clearOldResults() {
        DefaultTableModel dm = (DefaultTableModel)this.goMappingsTable.getModel();
        dm.getDataVector().removeAllElements();
        dm.fireTableDataChanged();
        dm = (DefaultTableModel)this.proteinTable.getModel();
        dm.getDataVector().removeAllElements();
        dm.fireTableDataChanged();
        this.goFrequencyPlotPanel.removeAll();
        this.goFrequencyPlotPanel.revalidate();
        this.goFrequencyPlotPanel.repaint();
        this.goSignificancePlotPanel.removeAll();
        this.goSignificancePlotPanel.revalidate();
        this.goSignificancePlotPanel.repaint();
        ((TitledBorder)this.mappingsPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Gene Ontology Mappings" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
        this.mappingsPanel.revalidate();
        this.mappingsPanel.repaint();
        ((TitledBorder)this.plotPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Gene Ontology Enrichment Analysis" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
        this.plotPanel.repaint();
        this.goProteinCountLabel.setText("[GO Proteins: Ensembl: -, Project: -]");
    }

    public void updateScores() {
        ((DefaultTableModel)this.proteinTable.getModel()).fireTableStructureChanged();
        this.setProteinGoTableProperties();
        if (this.peptideShakerGUI.getDisplayParameters().showScores()) {
            this.proteinTableToolTips.set(this.proteinTable.getColumnCount() - 2, "Protein Score");
        } else {
            this.proteinTableToolTips.set(this.proteinTable.getColumnCount() - 2, "Protein Confidence");
        }
        this.setProteinGoTableProperties();
    }

    public void showSparkLines(boolean showSparkLines) {
        ((JSparklinesBarChartTableCellRenderer)this.goMappingsTable.getColumn("Frequency All (%)").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesBarChartTableCellRenderer)this.goMappingsTable.getColumn("Frequency Dataset (%)").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesBarChartTableCellRenderer)this.goMappingsTable.getColumn("Log2 Diff").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesBarChartTableCellRenderer)this.goMappingsTable.getColumn("p-value").getCellRenderer()).showNumbers(!showSparkLines);
        this.goMappingsTable.revalidate();
        this.goMappingsTable.repaint();
        if (this.proteinTable.getModel() instanceof ProteinGoTableModel) {
            ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("MS2 Quant.").getCellRenderer()).showNumbers(!showSparkLines);
            ((JSparklinesArrayListBarChartTableCellRenderer)this.proteinTable.getColumn("Coverage").getCellRenderer()).showNumbers(!showSparkLines);
            ((JSparklinesArrayListBarChartTableCellRenderer)this.proteinTable.getColumn("#Peptides").getCellRenderer()).showNumbers(!showSparkLines);
            ((JSparklinesArrayListBarChartTableCellRenderer)this.proteinTable.getColumn("#Spectra").getCellRenderer()).showNumbers(!showSparkLines);
            try {
                ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("Confidence").getCellRenderer()).showNumbers(!showSparkLines);
            }
            catch (IllegalArgumentException e) {
                ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("Score").getCellRenderer()).showNumbers(!showSparkLines);
            }
            this.proteinTable.revalidate();
            this.proteinTable.repaint();
        }
    }

    private void updateProteinTable() {
        if (this.goMappingsTable.getSelectedRow() != -1) {
            this.progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
            this.progressDialog.setTitle("Loading Protein Data. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        GOEAPanel.this.progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("DisplayThread"){

                @Override
                public void run() {
                    try {
                        HashSet<Long> tempKeys;
                        DefaultTableModel dm = (DefaultTableModel)GOEAPanel.this.proteinTable.getModel();
                        dm.getDataVector().removeAllElements();
                        dm.fireTableDataChanged();
                        String selectedGoAccession = (String)GOEAPanel.this.goMappingsTable.getValueAt(GOEAPanel.this.goMappingsTable.getSelectedRow(), GOEAPanel.this.goMappingsTable.getColumn("GO Accession").getModelIndex());
                        selectedGoAccession = selectedGoAccession.substring(selectedGoAccession.lastIndexOf("GTerm?id=") + "GTerm?id=".length(), selectedGoAccession.lastIndexOf("\"><font"));
                        GeneMaps geneMaps = GOEAPanel.this.peptideShakerGUI.getGeneMaps();
                        HashSet<String> goProteins = geneMaps.getProteinsForGoTerm(selectedGoAccession);
                        Identification identification = GOEAPanel.this.peptideShakerGUI.getIdentification();
                        ArrayList<Long> proteinKeys = new ArrayList<Long>(goProteins.size());
                        HashMap<String, HashSet<Long>> proteinMap = identification.getProteinMap();
                        for (String goProtein : goProteins) {
                            tempKeys = proteinMap.get(goProtein);
                            if (tempKeys == null) continue;
                            proteinKeys.addAll(tempKeys);
                        }
                        if (GOEAPanel.this.proteinTable.getModel() instanceof ProteinGoTableModel) {
                            ((ProteinGoTableModel)GOEAPanel.this.proteinTable.getModel()).updateDataModel(proteinKeys);
                        } else {
                            ProteinGoTableModel proteinTableModel = new ProteinGoTableModel(GOEAPanel.this.peptideShakerGUI.getIdentification(), GOEAPanel.this.peptideShakerGUI.getProteinDetailsProvider(), GOEAPanel.this.peptideShakerGUI.getIdentificationFeaturesGenerator(), GOEAPanel.this.peptideShakerGUI.getDisplayFeaturesGenerator(), proteinKeys, GOEAPanel.this.peptideShakerGUI.getDisplayParameters().showScores());
                            GOEAPanel.this.proteinTable.setModel(proteinTableModel);
                        }
                        GOEAPanel.this.setProteinGoTableProperties();
                        ((DefaultTableModel)GOEAPanel.this.proteinTable.getModel()).fireTableDataChanged();
                        if (GOEAPanel.this.proteinTable.getRowCount() > 0) {
                            int nConfident = 0;
                            int nDoubtful = 0;
                            tempKeys = proteinKeys.iterator();
                            while (tempKeys.hasNext()) {
                                long proteinKey = (Long)tempKeys.next();
                                PSParameter psParameter = (PSParameter)identification.getProteinMatch(proteinKey).getUrParam(PSParameter.dummy);
                                MatchValidationLevel level = psParameter.getMatchValidationLevel();
                                if (level == MatchValidationLevel.confident) {
                                    ++nConfident;
                                    continue;
                                }
                                if (level != MatchValidationLevel.doubtful) continue;
                                ++nDoubtful;
                            }
                            String title = PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Gene Ontology Enrichment Analysis - " + GOEAPanel.this.goMappingsTable.getValueAt(GOEAPanel.this.goMappingsTable.getSelectedRow(), GOEAPanel.this.goMappingsTable.getColumn("GO Term").getModelIndex()) + " (";
                            try {
                                title = nConfident > 0 ? title + (nConfident + nDoubtful) + "/" + proteinKeys.size() + " - " + nConfident + " confident, " + nDoubtful + " doubtful" : title + proteinKeys.size();
                            }
                            catch (Exception eNValidated) {
                                GOEAPanel.this.peptideShakerGUI.catchException(eNValidated);
                            }
                            title = title + ")" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING;
                            ((TitledBorder)GOEAPanel.this.plotPanel.getBorder()).setTitle(title);
                            GOEAPanel.this.plotPanel.repaint();
                            GOEAPanel.this.proteinTable.setRowSelectionInterval(0, 0);
                            GOEAPanel.this.proteinTable.scrollRectToVisible(GOEAPanel.this.proteinTable.getCellRect(0, 0, false));
                            ProteinGoTableModel proteinGoTableModel = (ProteinGoTableModel)GOEAPanel.this.proteinTable.getModel();
                            int selectedGroupIndex = GOEAPanel.this.proteinTable.convertRowIndexToModel(GOEAPanel.this.proteinTable.getSelectedRow());
                            long proteinGroupKey = proteinGoTableModel.getProteins().get(selectedGroupIndex);
                            GOEAPanel.this.peptideShakerGUI.setSelectedItems(proteinGroupKey, ExperimentObject.NO_KEY, null, null);
                            GOEAPanel.this.proteinTableKeyReleased(null);
                        }
                        GOEAPanel.this.progressDialog.setRunFinished();
                    }
                    catch (Exception e) {
                        GOEAPanel.this.progressDialog.setRunFinished();
                        GOEAPanel.this.peptideShakerGUI.catchException(e);
                    }
                }
            }.start();
        }
    }

    public class QuickGoTerm {
        DummyResults[] results;

        public class DummyResults {
            String aspect;
        }
    }
}

