/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.tabpanels;

import com.compomics.util.ArrayUtil;
import com.compomics.util.Util;
import com.compomics.util.experiment.biology.ions.Charge;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.TagSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.spectrum_assumptions.TagAssumption;
import com.compomics.util.experiment.identification.utils.ModificationUtils;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Precursor;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.gui.TableProperties;
import com.compomics.util.gui.XYPlottingDialog;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.export.graphics.ExportGraphicsDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.gui.spectrum.MassErrorBubblePlot;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import eu.isas.peptideshaker.preferences.DisplayParameters;
import eu.isas.peptideshaker.scoring.PSMaps;
import eu.isas.peptideshaker.scoring.maps.InputMap;
import eu.isas.peptideshaker.utils.DisplayFeaturesGenerator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.extra.HtmlLinksRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesIntegerColorTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesIntegerIconTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesIntervalChartTableCellRenderer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class SpectrumIdentificationPanel
extends JPanel {
    private ProgressDialogX progressDialog;
    private boolean updateSelection = true;
    public static final int NO_ID = 0;
    public static final int CONFLICT = 1;
    public static final int PARTIALLY_MISSING = 2;
    public static final int AGREEMENT = 3;
    public static final int AGREEMENT_WITH_MODS = 4;
    private ArrayList<String> searchResultsTablePeptideTooltips = null;
    private String peptideShakerJTablePeptideTooltip = null;
    private ArrayList<String> idSoftwareTableToolTips;
    private ArrayList<String> spectrumTableToolTips;
    private ArrayList<String> peptideShakerTableToolTips;
    private ArrayList<String> idResultsTableToolTips;
    private ArrayList<SpectrumIdentificationAssumption> currentAssumptionsList = new ArrayList();
    private final PeptideShakerGUI peptideShakerGUI;
    private Identification identification;
    private InputMap inputMap;
    private String fileSelected = null;
    private ArrayList<Integer> advocatesUsed;
    private SpectrumPanel spectrumPanel;
    ChartPanel numberPsmsPlot;
    ChartPanel uniquePsmsPlot;
    ChartPanel unassignedPsmsPlot;
    ChartPanel idRatePlot;
    private JSlider accuracySlider;
    private JPanel backgroundPanel;
    private JLabel colorLegendLabel;
    private JPanel contextMenuIdSoftwareBackgroundPanel;
    private JPanel contextMenuPsmsBackgroundPanel;
    private JPanel contextMenuSpectrumBackgroundPanel;
    private JPanel contextMenuSpectrumSelectionBackgroundPanel;
    private JButton exportIdPerformancePerformanceJButton;
    private JButton exportPsmsJButton;
    private JButton exportSpectrumJButton;
    private JButton exportSpectrumSelectionJButton;
    private JComboBox fileNamesCmb;
    private JPopupMenu idPlotsPopupMenu;
    private JMenuItem idRateMenuItem;
    private JPanel idResultsPanel;
    private JScrollPane idResultsTableJScrollPane;
    private JButton idSoftwareHelpJButton;
    private JLayeredPane idSoftwareJLayeredPane;
    private JPanel idSoftwareJPanel;
    private JPanel idSoftwarePanel;
    private JSlider intensitySlider;
    private JMenuItem numberPsmsPlotMenuItem;
    private JPanel overviewPlotsPanel;
    private JScrollPane peptideShakerJScrollPane;
    private JTable peptideShakerJTable;
    private JSplitPane psmAndSpectrumSplitPane;
    private JButton psmsHelpJButton;
    private JPanel psmsJPanel;
    private JLayeredPane psmsLayeredPane;
    private JPanel psmsPanel;
    private JTable searchResultsTable;
    private JPanel slidersPanel;
    private JSplitPane slidersSplitPane;
    private JPanel spectrumAnnotationMenuPanel;
    private JPanel spectrumChartPanel;
    private JButton spectrumHelpJButton;
    private JLabel spectrumIdResultsLabel;
    private JPanel spectrumJPanel;
    private JPanel spectrumJPanel1;
    private JToolBar spectrumJToolBar;
    private JLayeredPane spectrumLayeredPane;
    private JPanel spectrumPanelPanel;
    private JDialog spectrumSelectionDialog;
    private JButton spectrumSelectionHelpJButton;
    private JPanel spectrumSelectionJPanel;
    private JLayeredPane spectrumSelectionLayeredPane;
    private JButton spectrumSelectionOptionsJButton;
    private JPanel spectrumSelectionPanel;
    private JSplitPane spectrumSelectionPsmSplitPane;
    private JTable spectrumTable;
    private JScrollPane spectrumTableJScrollPane;
    private JMenuItem unassignedPlotMenuItem;
    private JMenuItem uniquePsmsMenuItem;
    private JCheckBox vallidatedPsmsCheckBox;

    public SpectrumIdentificationPanel(PeptideShakerGUI peptideShakerGUI) {
        this.peptideShakerGUI = peptideShakerGUI;
        this.initComponents();
        this.formComponentResized(null);
        this.spectrumTableJScrollPane.getViewport().setOpaque(false);
        this.peptideShakerJScrollPane.getViewport().setOpaque(false);
        this.idResultsTableJScrollPane.getViewport().setOpaque(false);
        this.fileNamesCmb.setRenderer(new AlignedListCellRenderer(0));
        this.setUpGUI();
        this.setTableProperties();
    }

    private void setUpGUI() {
        ((TitledBorder)this.idSoftwarePanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Spectrum Identification Overview" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
        ((TitledBorder)this.psmsPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Peptide Spectrum Matches" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
        ((TitledBorder)this.spectrumPanelPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Spectrum & Fragment Ions" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
        ((TitledBorder)this.spectrumSelectionPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Spectrum Selection" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
        this.spectrumSelectionDialog.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
        this.spectrumSelectionDialog.setModal(true);
    }

    private void setTableProperties() {
        JPanel spectrumCorner = new JPanel();
        spectrumCorner.setBackground(this.spectrumTable.getTableHeader().getBackground());
        this.spectrumTableJScrollPane.setCorner("UPPER_RIGHT_CORNER", spectrumCorner);
        JPanel idResultsCorner = new JPanel();
        idResultsCorner.setBackground(this.searchResultsTable.getTableHeader().getBackground());
        this.idResultsTableJScrollPane.setCorner("UPPER_RIGHT_CORNER", idResultsCorner);
        this.peptideShakerJTable.getColumn("  ").setCellRenderer((TableCellRenderer)new JSparklinesIntegerIconTableCellRenderer(MatchValidationLevel.getIconMap(this.getClass()), MatchValidationLevel.getTooltipMap()));
        this.searchResultsTable.getColumn("  ").setCellRenderer((TableCellRenderer)new JSparklinesIntegerIconTableCellRenderer(MatchValidationLevel.getIconMap(this.getClass()), MatchValidationLevel.getTooltipMap()));
        this.peptideShakerJTable.getTableHeader().setReorderingAllowed(false);
        this.spectrumTable.getTableHeader().setReorderingAllowed(false);
        this.searchResultsTable.getTableHeader().setReorderingAllowed(false);
        this.spectrumTable.setAutoCreateRowSorter(true);
        this.spectrumTable.getRowSorter().addRowSorterListener(new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent e) {
                if (e.getType() == RowSorterEvent.Type.SORT_ORDER_CHANGED) {
                    SpectrumIdentificationPanel.this.peptideShakerGUI.setCursor(new Cursor(3));
                    SpectrumIdentificationPanel.this.spectrumTable.getTableHeader().setCursor(new Cursor(3));
                    SpectrumIdentificationPanel.this.peptideShakerGUI.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")));
                } else if (e.getType() == RowSorterEvent.Type.SORTED) {
                    SpectrumIdentificationPanel.this.peptideShakerGUI.setCursor(new Cursor(0));
                    SpectrumIdentificationPanel.this.spectrumTable.getTableHeader().setCursor(new Cursor(0));
                    SpectrumIdentificationPanel.this.peptideShakerGUI.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                }
            }
        });
        this.spectrumTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SpectrumIdentificationPanel.this.spectrumTableMouseClicked(e);
            }
        });
        this.peptideShakerJTable.getColumn(" ").setMinWidth(30);
        this.peptideShakerJTable.getColumn(" ").setMaxWidth(30);
        this.peptideShakerJTable.getColumn("  ").setMinWidth(30);
        this.peptideShakerJTable.getColumn("  ").setMaxWidth(30);
        this.spectrumTable.getColumn(" ").setMinWidth(50);
        this.spectrumTable.getColumn(" ").setMaxWidth(50);
        this.spectrumTable.getColumn("  ").setMinWidth(30);
        this.spectrumTable.getColumn("  ").setMaxWidth(30);
        this.spectrumTable.getColumn("ID").setMinWidth(37);
        this.spectrumTable.getColumn("ID").setMaxWidth(37);
        this.spectrumTable.getColumn("Level").setMinWidth(42);
        this.spectrumTable.getColumn("Level").setMaxWidth(42);
        this.spectrumTable.getColumn("Confidence").setMinWidth(90);
        this.spectrumTable.getColumn("Confidence").setMaxWidth(90);
        this.searchResultsTable.getColumn(" ").setMinWidth(30);
        this.searchResultsTable.getColumn(" ").setMaxWidth(30);
        this.searchResultsTable.getColumn("SE").setMinWidth(37);
        this.searchResultsTable.getColumn("SE").setMaxWidth(37);
        this.searchResultsTable.getColumn("Rnk").setMinWidth(37);
        this.searchResultsTable.getColumn("Rnk").setMaxWidth(37);
        this.searchResultsTable.getColumn("  ").setMinWidth(30);
        this.searchResultsTable.getColumn("  ").setMaxWidth(30);
        this.peptideShakerJTable.getColumn("ID").setMinWidth(37);
        this.peptideShakerJTable.getColumn("ID").setMaxWidth(37);
        this.peptideShakerJTable.getColumn("Confidence").setMinWidth(90);
        this.peptideShakerJTable.getColumn("Confidence").setMaxWidth(90);
        this.searchResultsTable.getColumn("Confidence").setMinWidth(90);
        this.searchResultsTable.getColumn("Confidence").setMaxWidth(90);
        this.searchResultsTable.getColumn("Charge").setMinWidth(90);
        this.searchResultsTable.getColumn("Charge").setMaxWidth(90);
        HashMap<Integer, Color> softwareAgreementColorMap = new HashMap<Integer, Color>();
        softwareAgreementColorMap.put(4, this.peptideShakerGUI.getSparklineColor());
        softwareAgreementColorMap.put(3, Color.CYAN);
        softwareAgreementColorMap.put(1, Color.YELLOW);
        softwareAgreementColorMap.put(2, Color.ORANGE);
        HashMap<Integer, String> idSoftwareTooltipMap = new HashMap<Integer, String>();
        idSoftwareTooltipMap.put(4, "ID Software Agree");
        idSoftwareTooltipMap.put(3, "ID Software Agree - PTM Certainty Issues");
        idSoftwareTooltipMap.put(1, "ID Software Disagree");
        idSoftwareTooltipMap.put(2, "ID Software(s) Missing");
        this.peptideShakerJTable.getColumn("ID").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(Color.lightGray, softwareAgreementColorMap, idSoftwareTooltipMap));
        this.peptideShakerJTable.getColumn("Protein(s)").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(TableProperties.getSelectedRowHtmlTagFontColor(), TableProperties.getNotSelectedRowHtmlTagFontColor()));
        this.peptideShakerJTable.getColumn("Confidence").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), this.peptideShakerGUI.getSparklineColor()));
        ((JSparklinesBarChartTableCellRenderer)this.peptideShakerJTable.getColumn("Confidence").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 20, this.peptideShakerGUI.getScoreAndConfidenceDecimalFormat());
        this.searchResultsTable.getColumn("SE").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(Color.lightGray, Advocate.getAdvocateColorMap(), Advocate.getAdvocateToolTipMap()));
        this.searchResultsTable.getColumn("Confidence").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), this.peptideShakerGUI.getSparklineColor()));
        ((JSparklinesBarChartTableCellRenderer)this.searchResultsTable.getColumn("Confidence").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 20, this.peptideShakerGUI.getScoreAndConfidenceDecimalFormat());
        this.searchResultsTable.getColumn("Charge").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(10.0), this.peptideShakerGUI.getSparklineColor()));
        ((JSparklinesBarChartTableCellRenderer)this.searchResultsTable.getColumn("Charge").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 30);
        HashMap<Integer, Color> idSoftwareSpectrumLevelColorMap = new HashMap<Integer, Color>();
        idSoftwareSpectrumLevelColorMap.put(4, this.peptideShakerGUI.getSparklineColor());
        idSoftwareSpectrumLevelColorMap.put(3, Color.CYAN);
        idSoftwareSpectrumLevelColorMap.put(1, Color.YELLOW);
        idSoftwareSpectrumLevelColorMap.put(2, Color.ORANGE);
        idSoftwareSpectrumLevelColorMap.put(0, Color.lightGray);
        HashMap<Integer, String> idSoftwareSpectrumLevelTooltipMap = new HashMap<Integer, String>();
        idSoftwareSpectrumLevelTooltipMap.put(4, "ID Software Agree");
        idSoftwareSpectrumLevelTooltipMap.put(3, "ID Software Agree - PTM Certainty Issues");
        idSoftwareSpectrumLevelTooltipMap.put(1, "ID Software Disagree");
        idSoftwareSpectrumLevelTooltipMap.put(2, "ID Software(s) Missing");
        idSoftwareSpectrumLevelTooltipMap.put(0, "(No PSM)");
        this.spectrumTable.getColumn("ID").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(Color.lightGray, idSoftwareSpectrumLevelColorMap, idSoftwareSpectrumLevelTooltipMap));
        this.spectrumTable.getColumn("m/z").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), this.peptideShakerGUI.getSparklineColor()));
        this.spectrumTable.getColumn("Charge").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(4.0), this.peptideShakerGUI.getSparklineColor()));
        this.spectrumTable.getColumn("Intensity").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(1000.0), this.peptideShakerGUI.getSparklineColor()));
        this.spectrumTable.getColumn("RT (min)").setCellRenderer((TableCellRenderer)new JSparklinesIntervalChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(0.0), Double.valueOf(1000.0), Double.valueOf(10.0), this.peptideShakerGUI.getSparklineColor(), this.peptideShakerGUI.getSparklineColor()));
        ((JSparklinesBarChartTableCellRenderer)this.spectrumTable.getColumn("m/z").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth());
        ((JSparklinesBarChartTableCellRenderer)this.spectrumTable.getColumn("Charge").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 30);
        ((JSparklinesBarChartTableCellRenderer)this.spectrumTable.getColumn("Intensity").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth());
        ((JSparklinesIntervalChartTableCellRenderer)this.spectrumTable.getColumn("RT (min)").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() + 5);
        ((JSparklinesIntervalChartTableCellRenderer)this.spectrumTable.getColumn("RT (min)").getCellRenderer()).showReferenceLine(true, 0.02, Color.BLACK);
        this.spectrumTable.getColumn("Confidence").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), this.peptideShakerGUI.getSparklineColor()));
        ((JSparklinesBarChartTableCellRenderer)this.spectrumTable.getColumn("Confidence").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 20, this.peptideShakerGUI.getScoreAndConfidenceDecimalFormat());
        this.spectrumTable.getColumn("  ").setCellRenderer((TableCellRenderer)new JSparklinesIntegerIconTableCellRenderer(MatchValidationLevel.getIconMap(this.getClass()), MatchValidationLevel.getTooltipMap()));
        this.spectrumTable.getColumn("Protein(s)").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(TableProperties.getSelectedRowHtmlTagFontColor(), TableProperties.getNotSelectedRowHtmlTagFontColor()));
        this.idSoftwareTableToolTips = new ArrayList();
        this.idSoftwareTableToolTips.add(null);
        this.idSoftwareTableToolTips.add("Identification Software");
        this.idSoftwareTableToolTips.add("Validated Peptide Spectrum Matches");
        this.idSoftwareTableToolTips.add("Unique Pepttide-Spectrum Matches");
        this.idSoftwareTableToolTips.add("Unassigned Spectra");
        this.idSoftwareTableToolTips.add("Identificaiton Rate (%)");
        if (this.peptideShakerGUI.getDisplayParameters().showScores()) {
            this.spectrumTable.getColumn("Score").setMaxWidth(90);
            this.spectrumTable.getColumn("Score").setMinWidth(90);
            this.peptideShakerJTable.getColumn("Score").setMaxWidth(90);
            this.peptideShakerJTable.getColumn("Score").setMinWidth(90);
            this.searchResultsTable.getColumn("Score").setMaxWidth(90);
            this.searchResultsTable.getColumn("Score").setMinWidth(90);
            this.spectrumTable.getColumn("Score").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), this.peptideShakerGUI.getSparklineColor()));
            ((JSparklinesBarChartTableCellRenderer)this.spectrumTable.getColumn("Score").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 20, this.peptideShakerGUI.getScoreAndConfidenceDecimalFormat());
            this.peptideShakerJTable.getColumn("Score").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), this.peptideShakerGUI.getSparklineColor()));
            ((JSparklinesBarChartTableCellRenderer)this.peptideShakerJTable.getColumn("Score").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 20, this.peptideShakerGUI.getScoreAndConfidenceDecimalFormat());
            this.searchResultsTable.getColumn("Score").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), this.peptideShakerGUI.getSparklineColor()));
            ((JSparklinesBarChartTableCellRenderer)this.searchResultsTable.getColumn("Score").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 20, this.peptideShakerGUI.getScoreAndConfidenceDecimalFormat());
            this.spectrumTableToolTips = new ArrayList();
            this.spectrumTableToolTips.add(null);
            this.spectrumTableToolTips.add("ID Software Agreement");
            this.spectrumTableToolTips.add("Spectrum Title");
            this.spectrumTableToolTips.add("Spectrum Level");
            this.spectrumTableToolTips.add("Precursor m/z");
            this.spectrumTableToolTips.add("Precursor Charge");
            this.spectrumTableToolTips.add("Precursor Intensity");
            this.spectrumTableToolTips.add("Precursor Retention Time in Minutes");
            this.spectrumTableToolTips.add("Peptide Sequence");
            this.spectrumTableToolTips.add("Mapping Protein(s)");
            this.spectrumTableToolTips.add("Peptide Spectrum Match Score");
            this.spectrumTableToolTips.add("Peptide Spectrum Match Confidence");
            this.spectrumTableToolTips.add("Validated");
            this.peptideShakerTableToolTips = new ArrayList();
            this.peptideShakerTableToolTips.add(null);
            this.peptideShakerTableToolTips.add("ID Software Agreement");
            this.peptideShakerTableToolTips.add("Peptide Sequence");
            this.peptideShakerTableToolTips.add("Mapping Protein(s)");
            this.peptideShakerTableToolTips.add("Peptide Spectrum Match score");
            this.peptideShakerTableToolTips.add("Peptide Spectrum Match Confidence");
            this.peptideShakerTableToolTips.add("Validated");
            this.idResultsTableToolTips = new ArrayList();
            this.idResultsTableToolTips.add("Peptide Rank");
            this.idResultsTableToolTips.add("Search Engine / Identification Software");
            this.idResultsTableToolTips.add("Search Engine Rank / Identification Software Rank");
            this.idResultsTableToolTips.add("Peptide Sequence");
            this.idResultsTableToolTips.add("Precursor Charge");
            this.idResultsTableToolTips.add("Peptide Spectrum Match Score");
            this.idResultsTableToolTips.add("Peptide Spectrum Match Confidence");
            this.idResultsTableToolTips.add("Validated");
        } else {
            this.spectrumTableToolTips = new ArrayList();
            this.spectrumTableToolTips.add(null);
            this.spectrumTableToolTips.add("ID Software Agreement");
            this.spectrumTableToolTips.add("Spectrum Title");
            this.spectrumTableToolTips.add("Spectrum Level");
            this.spectrumTableToolTips.add("Precursor m/z");
            this.spectrumTableToolTips.add("Precursor Charge");
            this.spectrumTableToolTips.add("Precursor Intensity");
            this.spectrumTableToolTips.add("Precursor Retention Time in Minutes");
            this.spectrumTableToolTips.add("Peptide Sequence");
            this.spectrumTableToolTips.add("Mapping Protein(s)");
            this.spectrumTableToolTips.add("Peptide Spectrum Match Confidence");
            this.spectrumTableToolTips.add("Validated");
            this.peptideShakerTableToolTips = new ArrayList();
            this.peptideShakerTableToolTips.add(null);
            this.peptideShakerTableToolTips.add("ID Software Agreement");
            this.peptideShakerTableToolTips.add("Peptide Sequence");
            this.peptideShakerTableToolTips.add("Mapping Protein(s)");
            this.peptideShakerTableToolTips.add("Peptide Spectrum Match Confidence");
            this.peptideShakerTableToolTips.add("Validated");
            this.idResultsTableToolTips = new ArrayList();
            this.idResultsTableToolTips.add("Peptide Rank");
            this.idResultsTableToolTips.add("Search Engine / Identification Software");
            this.idResultsTableToolTips.add("Search Engine Rank / Identification Software Rank");
            this.idResultsTableToolTips.add("Peptide Sequence");
            this.idResultsTableToolTips.add("Precursor Charge");
            this.idResultsTableToolTips.add("Peptide Spectrum Match Confidence");
            this.idResultsTableToolTips.add("Validated");
        }
    }

    public void showSparkLines(boolean showSparkLines) {
        ((JSparklinesBarChartTableCellRenderer)this.spectrumTable.getColumn("m/z").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesBarChartTableCellRenderer)this.spectrumTable.getColumn("Charge").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesBarChartTableCellRenderer)this.spectrumTable.getColumn("Intensity").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesIntervalChartTableCellRenderer)this.spectrumTable.getColumn("RT (min)").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesBarChartTableCellRenderer)this.spectrumTable.getColumn("Confidence").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesBarChartTableCellRenderer)this.peptideShakerJTable.getColumn("Confidence").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesBarChartTableCellRenderer)this.searchResultsTable.getColumn("Confidence").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesBarChartTableCellRenderer)this.searchResultsTable.getColumn("Charge").getCellRenderer()).showNumbers(!showSparkLines);
        this.spectrumTable.revalidate();
        this.spectrumTable.repaint();
        this.peptideShakerJTable.revalidate();
        this.peptideShakerJTable.repaint();
        this.searchResultsTable.revalidate();
        this.searchResultsTable.repaint();
    }

    private void initComponents() {
        this.spectrumSelectionDialog = new JDialog();
        this.backgroundPanel = new JPanel();
        this.fileNamesCmb = new JComboBox();
        this.idPlotsPopupMenu = new JPopupMenu();
        this.numberPsmsPlotMenuItem = new JMenuItem();
        this.uniquePsmsMenuItem = new JMenuItem();
        this.unassignedPlotMenuItem = new JMenuItem();
        this.idRateMenuItem = new JMenuItem();
        this.spectrumSelectionPsmSplitPane = new JSplitPane();
        this.spectrumSelectionJPanel = new JPanel();
        this.spectrumSelectionLayeredPane = new JLayeredPane();
        this.spectrumSelectionPanel = new JPanel();
        this.spectrumTableJScrollPane = new JScrollPane();
        this.spectrumTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)SpectrumIdentificationPanel.this.spectrumTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.spectrumSelectionOptionsJButton = new JButton();
        this.spectrumSelectionHelpJButton = new JButton();
        this.exportSpectrumSelectionJButton = new JButton();
        this.contextMenuSpectrumSelectionBackgroundPanel = new JPanel();
        this.psmAndSpectrumSplitPane = new JSplitPane();
        this.psmsJPanel = new JPanel();
        this.psmsLayeredPane = new JLayeredPane();
        this.psmsPanel = new JPanel();
        this.peptideShakerJScrollPane = new JScrollPane();
        this.peptideShakerJTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)SpectrumIdentificationPanel.this.peptideShakerTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.idResultsPanel = new JPanel();
        this.spectrumIdResultsLabel = new JLabel();
        this.idResultsTableJScrollPane = new JScrollPane();
        this.searchResultsTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)SpectrumIdentificationPanel.this.idResultsTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.vallidatedPsmsCheckBox = new JCheckBox();
        this.colorLegendLabel = new JLabel();
        this.psmsHelpJButton = new JButton();
        this.exportPsmsJButton = new JButton();
        this.contextMenuPsmsBackgroundPanel = new JPanel();
        this.spectrumJPanel = new JPanel();
        this.spectrumLayeredPane = new JLayeredPane();
        this.spectrumPanelPanel = new JPanel();
        this.slidersSplitPane = new JSplitPane();
        this.slidersPanel = new JPanel();
        this.accuracySlider = new JSlider();
        this.intensitySlider = new JSlider();
        this.spectrumJPanel1 = new JPanel();
        this.spectrumJToolBar = new JToolBar();
        this.spectrumAnnotationMenuPanel = new JPanel();
        this.spectrumChartPanel = new JPanel();
        this.spectrumHelpJButton = new JButton();
        this.exportSpectrumJButton = new JButton();
        this.contextMenuSpectrumBackgroundPanel = new JPanel();
        this.idSoftwareJPanel = new JPanel();
        this.idSoftwareJLayeredPane = new JLayeredPane();
        this.idSoftwarePanel = new JPanel();
        this.overviewPlotsPanel = new JPanel();
        this.idSoftwareHelpJButton = new JButton();
        this.exportIdPerformancePerformanceJButton = new JButton();
        this.contextMenuIdSoftwareBackgroundPanel = new JPanel();
        this.spectrumSelectionDialog.setTitle("Spectrum Selection");
        this.spectrumSelectionDialog.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.fileNamesCmb.setMinimumSize(new Dimension(200, 20));
        this.fileNamesCmb.setPreferredSize(new Dimension(400, 20));
        this.fileNamesCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpectrumIdentificationPanel.this.fileNamesCmbActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fileNamesCmb, 0, -1, Short.MAX_VALUE).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fileNamesCmb, -1, -1, Short.MAX_VALUE).addContainerGap()));
        GroupLayout spectrumSelectionDialogLayout = new GroupLayout(this.spectrumSelectionDialog.getContentPane());
        this.spectrumSelectionDialog.getContentPane().setLayout(spectrumSelectionDialogLayout);
        spectrumSelectionDialogLayout.setHorizontalGroup(spectrumSelectionDialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        spectrumSelectionDialogLayout.setVerticalGroup(spectrumSelectionDialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.numberPsmsPlotMenuItem.setText("#PSMs Plot");
        this.numberPsmsPlotMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpectrumIdentificationPanel.this.numberPsmsPlotMenuItemActionPerformed(evt);
            }
        });
        this.idPlotsPopupMenu.add(this.numberPsmsPlotMenuItem);
        this.uniquePsmsMenuItem.setText("#Unique PSMs Plot");
        this.uniquePsmsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpectrumIdentificationPanel.this.uniquePsmsMenuItemActionPerformed(evt);
            }
        });
        this.idPlotsPopupMenu.add(this.uniquePsmsMenuItem);
        this.unassignedPlotMenuItem.setText("#Unassinged PSMs Plot");
        this.unassignedPlotMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpectrumIdentificationPanel.this.unassignedPlotMenuItemActionPerformed(evt);
            }
        });
        this.idPlotsPopupMenu.add(this.unassignedPlotMenuItem);
        this.idRateMenuItem.setText("ID Rate Plot");
        this.idRateMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpectrumIdentificationPanel.this.idRateMenuItemActionPerformed(evt);
            }
        });
        this.idPlotsPopupMenu.add(this.idRateMenuItem);
        this.setBackground(new Color(255, 255, 255));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SpectrumIdentificationPanel.this.formComponentResized(evt);
            }
        });
        this.spectrumSelectionPsmSplitPane.setBorder(null);
        this.spectrumSelectionPsmSplitPane.setDividerLocation(340);
        this.spectrumSelectionPsmSplitPane.setDividerSize(0);
        this.spectrumSelectionPsmSplitPane.setOrientation(0);
        this.spectrumSelectionPsmSplitPane.setResizeWeight(0.5);
        this.spectrumSelectionJPanel.setOpaque(false);
        this.spectrumSelectionPanel.setBorder(BorderFactory.createTitledBorder(null, "Spectrum Selection", 0, 0, new Font("sansserif", 1, 14)));
        this.spectrumSelectionPanel.setOpaque(false);
        this.spectrumSelectionPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                SpectrumIdentificationPanel.this.spectrumSelectionPanelMouseMoved(evt);
            }
        });
        this.spectrumSelectionPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                SpectrumIdentificationPanel.this.spectrumSelectionPanelMouseReleased(evt);
            }
        });
        this.spectrumTable.setModel(new SpectrumTableModel());
        this.spectrumTable.setOpaque(false);
        this.spectrumTable.setSelectionMode(0);
        this.spectrumTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                SpectrumIdentificationPanel.this.spectrumTableMouseMoved(evt);
            }
        });
        this.spectrumTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SpectrumIdentificationPanel.this.spectrumTableMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpectrumIdentificationPanel.this.spectrumTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SpectrumIdentificationPanel.this.spectrumTableMouseReleased(evt);
            }
        });
        this.spectrumTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SpectrumIdentificationPanel.this.spectrumTableKeyReleased(evt);
            }
        });
        this.spectrumTableJScrollPane.setViewportView(this.spectrumTable);
        GroupLayout spectrumSelectionPanelLayout = new GroupLayout(this.spectrumSelectionPanel);
        this.spectrumSelectionPanel.setLayout(spectrumSelectionPanelLayout);
        spectrumSelectionPanelLayout.setHorizontalGroup(spectrumSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumSelectionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.spectrumTableJScrollPane, -1, 1238, Short.MAX_VALUE).addContainerGap()));
        spectrumSelectionPanelLayout.setVerticalGroup(spectrumSelectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumSelectionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.spectrumTableJScrollPane, -1, 263, Short.MAX_VALUE).addContainerGap()));
        this.spectrumSelectionLayeredPane.add(this.spectrumSelectionPanel);
        this.spectrumSelectionPanel.setBounds(0, 0, 1270, 320);
        this.spectrumSelectionOptionsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/contextual_menu_gray.png")));
        this.spectrumSelectionOptionsJButton.setToolTipText("Spectrum File Selection");
        this.spectrumSelectionOptionsJButton.setBorder(null);
        this.spectrumSelectionOptionsJButton.setBorderPainted(false);
        this.spectrumSelectionOptionsJButton.setContentAreaFilled(false);
        this.spectrumSelectionOptionsJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/contextual_menu_gray.png")));
        this.spectrumSelectionOptionsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/contextual_menu_black.png")));
        this.spectrumSelectionOptionsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                SpectrumIdentificationPanel.this.spectrumSelectionOptionsJButtonMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpectrumIdentificationPanel.this.spectrumSelectionOptionsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpectrumIdentificationPanel.this.spectrumSelectionOptionsJButtonMouseExited(evt);
            }
        });
        this.spectrumSelectionLayeredPane.setLayer(this.spectrumSelectionOptionsJButton, JLayeredPane.POPUP_LAYER);
        this.spectrumSelectionLayeredPane.add(this.spectrumSelectionOptionsJButton);
        this.spectrumSelectionOptionsJButton.setBounds(1230, 0, 10, 19);
        this.spectrumSelectionHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.spectrumSelectionHelpJButton.setToolTipText("Help");
        this.spectrumSelectionHelpJButton.setBorder(null);
        this.spectrumSelectionHelpJButton.setBorderPainted(false);
        this.spectrumSelectionHelpJButton.setContentAreaFilled(false);
        this.spectrumSelectionHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.spectrumSelectionHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpectrumIdentificationPanel.this.spectrumSelectionHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpectrumIdentificationPanel.this.spectrumSelectionHelpJButtonMouseExited(evt);
            }
        });
        this.spectrumSelectionHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpectrumIdentificationPanel.this.spectrumSelectionHelpJButtonActionPerformed(evt);
            }
        });
        this.spectrumSelectionLayeredPane.setLayer(this.spectrumSelectionHelpJButton, JLayeredPane.POPUP_LAYER);
        this.spectrumSelectionLayeredPane.add(this.spectrumSelectionHelpJButton);
        this.spectrumSelectionHelpJButton.setBounds(1250, 0, 10, 19);
        this.exportSpectrumSelectionJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportSpectrumSelectionJButton.setToolTipText("Copy to File");
        this.exportSpectrumSelectionJButton.setBorder(null);
        this.exportSpectrumSelectionJButton.setBorderPainted(false);
        this.exportSpectrumSelectionJButton.setContentAreaFilled(false);
        this.exportSpectrumSelectionJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportSpectrumSelectionJButton.setEnabled(false);
        this.exportSpectrumSelectionJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportSpectrumSelectionJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpectrumIdentificationPanel.this.exportSpectrumSelectionJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpectrumIdentificationPanel.this.exportSpectrumSelectionJButtonMouseExited(evt);
            }
        });
        this.exportSpectrumSelectionJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpectrumIdentificationPanel.this.exportSpectrumSelectionJButtonActionPerformed(evt);
            }
        });
        this.spectrumSelectionLayeredPane.setLayer(this.exportSpectrumSelectionJButton, JLayeredPane.POPUP_LAYER);
        this.spectrumSelectionLayeredPane.add(this.exportSpectrumSelectionJButton);
        this.exportSpectrumSelectionJButton.setBounds(1240, 0, 10, 19);
        this.contextMenuSpectrumSelectionBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuSpectrumSelectionBackgroundPanelLayout = new GroupLayout(this.contextMenuSpectrumSelectionBackgroundPanel);
        this.contextMenuSpectrumSelectionBackgroundPanel.setLayout(contextMenuSpectrumSelectionBackgroundPanelLayout);
        contextMenuSpectrumSelectionBackgroundPanelLayout.setHorizontalGroup(contextMenuSpectrumSelectionBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        contextMenuSpectrumSelectionBackgroundPanelLayout.setVerticalGroup(contextMenuSpectrumSelectionBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.spectrumSelectionLayeredPane.setLayer(this.contextMenuSpectrumSelectionBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.spectrumSelectionLayeredPane.add(this.contextMenuSpectrumSelectionBackgroundPanel);
        this.contextMenuSpectrumSelectionBackgroundPanel.setBounds(1230, 0, 30, 19);
        GroupLayout spectrumSelectionJPanelLayout = new GroupLayout(this.spectrumSelectionJPanel);
        this.spectrumSelectionJPanel.setLayout(spectrumSelectionJPanelLayout);
        spectrumSelectionJPanelLayout.setHorizontalGroup(spectrumSelectionJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spectrumSelectionLayeredPane, -1, 1284, Short.MAX_VALUE));
        spectrumSelectionJPanelLayout.setVerticalGroup(spectrumSelectionJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spectrumSelectionLayeredPane));
        this.spectrumSelectionPsmSplitPane.setTopComponent(this.spectrumSelectionJPanel);
        this.psmAndSpectrumSplitPane.setBorder(null);
        this.psmAndSpectrumSplitPane.setDividerLocation(675);
        this.psmAndSpectrumSplitPane.setDividerSize(0);
        this.psmAndSpectrumSplitPane.setResizeWeight(0.5);
        this.psmsJPanel.setOpaque(false);
        this.psmsPanel.setBorder(BorderFactory.createTitledBorder(null, "Peptide Spectrum Matches", 0, 0, new Font("sansserif", 1, 14)));
        this.psmsPanel.setOpaque(false);
        this.peptideShakerJTable.setModel(new PeptideShakerPsmTableModel());
        this.peptideShakerJTable.setFocusable(false);
        this.peptideShakerJTable.setOpaque(false);
        this.peptideShakerJTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                SpectrumIdentificationPanel.this.peptideShakerJTableMouseMoved(evt);
            }
        });
        this.peptideShakerJTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                SpectrumIdentificationPanel.this.peptideShakerJTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SpectrumIdentificationPanel.this.peptideShakerJTableMouseReleased(evt);
            }
        });
        this.peptideShakerJScrollPane.setViewportView(this.peptideShakerJTable);
        this.idResultsPanel.setOpaque(false);
        this.spectrumIdResultsLabel.setFont(this.spectrumIdResultsLabel.getFont().deriveFont(this.spectrumIdResultsLabel.getFont().getStyle() & 0xFFFFFFFD));
        this.spectrumIdResultsLabel.setText("Spectrum Identification Results");
        this.idResultsTableJScrollPane.setMinimumSize(new Dimension(23, 87));
        this.searchResultsTable.setModel(new IdAlgorithmsPsmTableModel());
        this.searchResultsTable.setOpaque(false);
        this.searchResultsTable.setSelectionMode(2);
        this.searchResultsTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                SpectrumIdentificationPanel.this.searchResultsTableMouseMoved(evt);
            }
        });
        this.searchResultsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SpectrumIdentificationPanel.this.searchResultsTableMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpectrumIdentificationPanel.this.searchResultsTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SpectrumIdentificationPanel.this.searchResultsTableMouseReleased(evt);
            }
        });
        this.searchResultsTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                SpectrumIdentificationPanel.this.searchResultsTableKeyReleased(evt);
            }
        });
        this.idResultsTableJScrollPane.setViewportView(this.searchResultsTable);
        this.vallidatedPsmsCheckBox.setFont(this.vallidatedPsmsCheckBox.getFont().deriveFont((float)this.vallidatedPsmsCheckBox.getFont().getSize() - 1.0f));
        this.vallidatedPsmsCheckBox.setText("Validated");
        this.vallidatedPsmsCheckBox.setToolTipText("Show validated PSMs only");
        this.vallidatedPsmsCheckBox.setIconTextGap(6);
        this.vallidatedPsmsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpectrumIdentificationPanel.this.vallidatedPsmsCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout idResultsPanelLayout = new GroupLayout(this.idResultsPanel);
        this.idResultsPanel.setLayout(idResultsPanelLayout);
        idResultsPanelLayout.setHorizontalGroup(idResultsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(idResultsPanelLayout.createSequentialGroup().addComponent(this.spectrumIdResultsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.vallidatedPsmsCheckBox).addContainerGap()).addComponent(this.idResultsTableJScrollPane, -1, -1, Short.MAX_VALUE));
        idResultsPanelLayout.setVerticalGroup(idResultsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(idResultsPanelLayout.createSequentialGroup().addGroup(idResultsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spectrumIdResultsLabel).addComponent(this.vallidatedPsmsCheckBox, -2, 18, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.idResultsTableJScrollPane, -1, 234, Short.MAX_VALUE)));
        this.colorLegendLabel.setText(" ");
        GroupLayout psmsPanelLayout = new GroupLayout(this.psmsPanel);
        this.psmsPanel.setLayout(psmsPanelLayout);
        psmsPanelLayout.setHorizontalGroup(psmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psmsPanelLayout.createSequentialGroup().addGroup(psmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psmsPanelLayout.createSequentialGroup().addContainerGap().addGroup(psmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.idResultsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.peptideShakerJScrollPane, -1, 618, Short.MAX_VALUE))).addGroup(psmsPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.colorLegendLabel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        psmsPanelLayout.setVerticalGroup(psmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, psmsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.peptideShakerJScrollPane, -2, 45, -2).addGap(18, 18, 18).addComponent(this.idResultsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colorLegendLabel).addGap(6, 6, 6)));
        this.psmsLayeredPane.add(this.psmsPanel);
        this.psmsPanel.setBounds(0, 0, 650, 400);
        this.psmsHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.psmsHelpJButton.setToolTipText("Help");
        this.psmsHelpJButton.setBorder(null);
        this.psmsHelpJButton.setBorderPainted(false);
        this.psmsHelpJButton.setContentAreaFilled(false);
        this.psmsHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.psmsHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpectrumIdentificationPanel.this.psmsHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpectrumIdentificationPanel.this.psmsHelpJButtonMouseExited(evt);
            }
        });
        this.psmsHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpectrumIdentificationPanel.this.psmsHelpJButtonActionPerformed(evt);
            }
        });
        this.psmsLayeredPane.setLayer(this.psmsHelpJButton, JLayeredPane.POPUP_LAYER);
        this.psmsLayeredPane.add(this.psmsHelpJButton);
        this.psmsHelpJButton.setBounds(630, 0, 10, 19);
        this.exportPsmsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportPsmsJButton.setToolTipText("Copy to File");
        this.exportPsmsJButton.setBorder(null);
        this.exportPsmsJButton.setBorderPainted(false);
        this.exportPsmsJButton.setContentAreaFilled(false);
        this.exportPsmsJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportPsmsJButton.setEnabled(false);
        this.exportPsmsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportPsmsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpectrumIdentificationPanel.this.exportPsmsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpectrumIdentificationPanel.this.exportPsmsJButtonMouseExited(evt);
            }
        });
        this.exportPsmsJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpectrumIdentificationPanel.this.exportPsmsJButtonActionPerformed(evt);
            }
        });
        this.psmsLayeredPane.setLayer(this.exportPsmsJButton, JLayeredPane.POPUP_LAYER);
        this.psmsLayeredPane.add(this.exportPsmsJButton);
        this.exportPsmsJButton.setBounds(620, 0, 10, 19);
        this.contextMenuPsmsBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuPsmsBackgroundPanelLayout = new GroupLayout(this.contextMenuPsmsBackgroundPanel);
        this.contextMenuPsmsBackgroundPanel.setLayout(contextMenuPsmsBackgroundPanelLayout);
        contextMenuPsmsBackgroundPanelLayout.setHorizontalGroup(contextMenuPsmsBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        contextMenuPsmsBackgroundPanelLayout.setVerticalGroup(contextMenuPsmsBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.psmsLayeredPane.setLayer(this.contextMenuPsmsBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.psmsLayeredPane.add(this.contextMenuPsmsBackgroundPanel);
        this.contextMenuPsmsBackgroundPanel.setBounds(610, 0, 30, 19);
        GroupLayout psmsJPanelLayout = new GroupLayout(this.psmsJPanel);
        this.psmsJPanel.setLayout(psmsJPanelLayout);
        psmsJPanelLayout.setHorizontalGroup(psmsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psmsJPanelLayout.createSequentialGroup().addComponent(this.psmsLayeredPane).addContainerGap()));
        psmsJPanelLayout.setVerticalGroup(psmsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, psmsJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.psmsLayeredPane, -1, 398, Short.MAX_VALUE)));
        this.psmAndSpectrumSplitPane.setLeftComponent(this.psmsJPanel);
        this.spectrumJPanel.setOpaque(false);
        this.spectrumJPanel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                SpectrumIdentificationPanel.this.spectrumJPanelMouseWheelMoved(evt);
            }
        });
        this.spectrumPanelPanel.setBorder(BorderFactory.createTitledBorder(null, "Spectrum & Fragment Ions", 0, 0, new Font("sansserif", 1, 14)));
        this.spectrumPanelPanel.setMinimumSize(new Dimension(200, 200));
        this.spectrumPanelPanel.setOpaque(false);
        this.slidersSplitPane.setBorder(null);
        this.slidersSplitPane.setDividerLocation(558);
        this.slidersSplitPane.setDividerSize(0);
        this.slidersPanel.setOpaque(false);
        this.accuracySlider.setOrientation(1);
        this.accuracySlider.setPaintTicks(true);
        this.accuracySlider.setToolTipText("Annotation Accuracy");
        this.accuracySlider.setValue(100);
        this.accuracySlider.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                SpectrumIdentificationPanel.this.accuracySliderMouseWheelMoved(evt);
            }
        });
        this.accuracySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SpectrumIdentificationPanel.this.accuracySliderStateChanged(evt);
            }
        });
        this.intensitySlider.setOrientation(1);
        this.intensitySlider.setPaintTicks(true);
        this.intensitySlider.setToolTipText("Annotation Intensity Level");
        this.intensitySlider.setValue(75);
        this.intensitySlider.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                SpectrumIdentificationPanel.this.intensitySliderMouseWheelMoved(evt);
            }
        });
        this.intensitySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SpectrumIdentificationPanel.this.intensitySliderStateChanged(evt);
            }
        });
        GroupLayout slidersPanelLayout = new GroupLayout(this.slidersPanel);
        this.slidersPanel.setLayout(slidersPanelLayout);
        slidersPanelLayout.setHorizontalGroup(slidersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, slidersPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(slidersPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.intensitySlider, -2, -1, -2).addComponent(this.accuracySlider, -2, -1, -2)).addGap(0, 0, 0)));
        slidersPanelLayout.setVerticalGroup(slidersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, slidersPanelLayout.createSequentialGroup().addGap(36, 36, 36).addComponent(this.accuracySlider, -1, 148, Short.MAX_VALUE).addGap(30, 30, 30).addComponent(this.intensitySlider, -1, 149, Short.MAX_VALUE).addContainerGap()));
        this.slidersSplitPane.setRightComponent(this.slidersPanel);
        this.spectrumJPanel1.setBackground(new Color(255, 255, 255));
        this.spectrumJToolBar.setBackground(new Color(255, 255, 255));
        this.spectrumJToolBar.setBorder(null);
        this.spectrumJToolBar.setFloatable(false);
        this.spectrumJToolBar.setRollover(true);
        this.spectrumJToolBar.setBorderPainted(false);
        this.spectrumAnnotationMenuPanel.setLayout(new BoxLayout(this.spectrumAnnotationMenuPanel, 2));
        this.spectrumJToolBar.add(this.spectrumAnnotationMenuPanel);
        this.spectrumChartPanel.setOpaque(false);
        this.spectrumChartPanel.setLayout(new BoxLayout(this.spectrumChartPanel, 1));
        GroupLayout spectrumJPanel1Layout = new GroupLayout(this.spectrumJPanel1);
        this.spectrumJPanel1.setLayout(spectrumJPanel1Layout);
        spectrumJPanel1Layout.setHorizontalGroup(spectrumJPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumJPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.spectrumJToolBar, -1, -1, Short.MAX_VALUE).addContainerGap()).addComponent(this.spectrumChartPanel, -1, -1, Short.MAX_VALUE));
        spectrumJPanel1Layout.setVerticalGroup(spectrumJPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, spectrumJPanel1Layout.createSequentialGroup().addComponent(this.spectrumChartPanel, -1, 369, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.spectrumJToolBar, -2, -1, -2)));
        this.slidersSplitPane.setLeftComponent(this.spectrumJPanel1);
        GroupLayout spectrumPanelPanelLayout = new GroupLayout(this.spectrumPanelPanel);
        this.spectrumPanelPanel.setLayout(spectrumPanelPanelLayout);
        spectrumPanelPanelLayout.setHorizontalGroup(spectrumPanelPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumPanelPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.slidersSplitPane, -1, 558, Short.MAX_VALUE).addContainerGap()));
        spectrumPanelPanelLayout.setVerticalGroup(spectrumPanelPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, spectrumPanelPanelLayout.createSequentialGroup().addComponent(this.slidersSplitPane).addContainerGap()));
        this.spectrumLayeredPane.add(this.spectrumPanelPanel);
        this.spectrumPanelPanel.setBounds(0, 0, 590, 420);
        this.spectrumHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.spectrumHelpJButton.setToolTipText("Help");
        this.spectrumHelpJButton.setBorder(null);
        this.spectrumHelpJButton.setBorderPainted(false);
        this.spectrumHelpJButton.setContentAreaFilled(false);
        this.spectrumHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.spectrumHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpectrumIdentificationPanel.this.spectrumHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpectrumIdentificationPanel.this.spectrumHelpJButtonMouseExited(evt);
            }
        });
        this.spectrumHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpectrumIdentificationPanel.this.spectrumHelpJButtonActionPerformed(evt);
            }
        });
        this.spectrumLayeredPane.setLayer(this.spectrumHelpJButton, JLayeredPane.POPUP_LAYER);
        this.spectrumLayeredPane.add(this.spectrumHelpJButton);
        this.spectrumHelpJButton.setBounds(600, 0, 10, 19);
        this.exportSpectrumJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportSpectrumJButton.setToolTipText("Export");
        this.exportSpectrumJButton.setBorder(null);
        this.exportSpectrumJButton.setBorderPainted(false);
        this.exportSpectrumJButton.setContentAreaFilled(false);
        this.exportSpectrumJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportSpectrumJButton.setEnabled(false);
        this.exportSpectrumJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportSpectrumJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpectrumIdentificationPanel.this.exportSpectrumJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpectrumIdentificationPanel.this.exportSpectrumJButtonMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SpectrumIdentificationPanel.this.exportSpectrumJButtonMouseReleased(evt);
            }
        });
        this.spectrumLayeredPane.setLayer(this.exportSpectrumJButton, JLayeredPane.POPUP_LAYER);
        this.spectrumLayeredPane.add(this.exportSpectrumJButton);
        this.exportSpectrumJButton.setBounds(590, 0, 10, 19);
        this.contextMenuSpectrumBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuSpectrumBackgroundPanelLayout = new GroupLayout(this.contextMenuSpectrumBackgroundPanel);
        this.contextMenuSpectrumBackgroundPanel.setLayout(contextMenuSpectrumBackgroundPanelLayout);
        contextMenuSpectrumBackgroundPanelLayout.setHorizontalGroup(contextMenuSpectrumBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        contextMenuSpectrumBackgroundPanelLayout.setVerticalGroup(contextMenuSpectrumBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.spectrumLayeredPane.setLayer(this.contextMenuSpectrumBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.spectrumLayeredPane.add(this.contextMenuSpectrumBackgroundPanel);
        this.contextMenuSpectrumBackgroundPanel.setBounds(590, 0, 30, 19);
        GroupLayout spectrumJPanelLayout = new GroupLayout(this.spectrumJPanel);
        this.spectrumJPanel.setLayout(spectrumJPanelLayout);
        spectrumJPanelLayout.setHorizontalGroup(spectrumJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spectrumLayeredPane));
        spectrumJPanelLayout.setVerticalGroup(spectrumJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, spectrumJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.spectrumLayeredPane, -1, 398, Short.MAX_VALUE)));
        this.psmAndSpectrumSplitPane.setRightComponent(this.spectrumJPanel);
        this.spectrumSelectionPsmSplitPane.setBottomComponent(this.psmAndSpectrumSplitPane);
        this.idSoftwareJPanel.setOpaque(false);
        this.idSoftwarePanel.setBorder(BorderFactory.createTitledBorder(null, "Spectrum Identification Overview", 0, 0, new Font("sansserif", 1, 14)));
        this.idSoftwarePanel.setOpaque(false);
        this.overviewPlotsPanel.setOpaque(false);
        this.overviewPlotsPanel.setLayout(new BoxLayout(this.overviewPlotsPanel, 2));
        GroupLayout idSoftwarePanelLayout = new GroupLayout(this.idSoftwarePanel);
        this.idSoftwarePanel.setLayout(idSoftwarePanelLayout);
        idSoftwarePanelLayout.setHorizontalGroup(idSoftwarePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(idSoftwarePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.overviewPlotsPanel, -1, 1248, Short.MAX_VALUE).addContainerGap()));
        idSoftwarePanelLayout.setVerticalGroup(idSoftwarePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(idSoftwarePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.overviewPlotsPanel, -1, 93, Short.MAX_VALUE).addContainerGap()));
        this.idSoftwareJLayeredPane.add(this.idSoftwarePanel);
        this.idSoftwarePanel.setBounds(0, 10, 1280, 150);
        this.idSoftwareHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.idSoftwareHelpJButton.setToolTipText("Help");
        this.idSoftwareHelpJButton.setBorder(null);
        this.idSoftwareHelpJButton.setBorderPainted(false);
        this.idSoftwareHelpJButton.setContentAreaFilled(false);
        this.idSoftwareHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.idSoftwareHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpectrumIdentificationPanel.this.idSoftwareHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpectrumIdentificationPanel.this.idSoftwareHelpJButtonMouseExited(evt);
            }
        });
        this.idSoftwareHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpectrumIdentificationPanel.this.idSoftwareHelpJButtonActionPerformed(evt);
            }
        });
        this.idSoftwareJLayeredPane.setLayer(this.idSoftwareHelpJButton, JLayeredPane.POPUP_LAYER);
        this.idSoftwareJLayeredPane.add(this.idSoftwareHelpJButton);
        this.idSoftwareHelpJButton.setBounds(1270, 0, 10, 19);
        this.exportIdPerformancePerformanceJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportIdPerformancePerformanceJButton.setToolTipText("Copy to File");
        this.exportIdPerformancePerformanceJButton.setBorder(null);
        this.exportIdPerformancePerformanceJButton.setBorderPainted(false);
        this.exportIdPerformancePerformanceJButton.setContentAreaFilled(false);
        this.exportIdPerformancePerformanceJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportIdPerformancePerformanceJButton.setEnabled(false);
        this.exportIdPerformancePerformanceJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportIdPerformancePerformanceJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SpectrumIdentificationPanel.this.exportIdPerformancePerformanceJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SpectrumIdentificationPanel.this.exportIdPerformancePerformanceJButtonMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SpectrumIdentificationPanel.this.exportIdPerformancePerformanceJButtonMouseReleased(evt);
            }
        });
        this.idSoftwareJLayeredPane.setLayer(this.exportIdPerformancePerformanceJButton, JLayeredPane.POPUP_LAYER);
        this.idSoftwareJLayeredPane.add(this.exportIdPerformancePerformanceJButton);
        this.exportIdPerformancePerformanceJButton.setBounds(1260, 0, 10, 19);
        this.contextMenuIdSoftwareBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuIdSoftwareBackgroundPanelLayout = new GroupLayout(this.contextMenuIdSoftwareBackgroundPanel);
        this.contextMenuIdSoftwareBackgroundPanel.setLayout(contextMenuIdSoftwareBackgroundPanelLayout);
        contextMenuIdSoftwareBackgroundPanelLayout.setHorizontalGroup(contextMenuIdSoftwareBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        contextMenuIdSoftwareBackgroundPanelLayout.setVerticalGroup(contextMenuIdSoftwareBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.idSoftwareJLayeredPane.setLayer(this.contextMenuIdSoftwareBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.idSoftwareJLayeredPane.add(this.contextMenuIdSoftwareBackgroundPanel);
        this.contextMenuIdSoftwareBackgroundPanel.setBounds(1260, 0, 30, 19);
        GroupLayout idSoftwareJPanelLayout = new GroupLayout(this.idSoftwareJPanel);
        this.idSoftwareJPanel.setLayout(idSoftwareJPanelLayout);
        idSoftwareJPanelLayout.setHorizontalGroup(idSoftwareJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.idSoftwareJLayeredPane, GroupLayout.Alignment.TRAILING, -1, 1284, Short.MAX_VALUE));
        idSoftwareJPanelLayout.setVerticalGroup(idSoftwareJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.idSoftwareJLayeredPane, -1, 166, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1304, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.idSoftwareJPanel, -1, -1, Short.MAX_VALUE).addContainerGap())).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.spectrumSelectionPsmSplitPane).addContainerGap())));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 938, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(761, Short.MAX_VALUE).addComponent(this.idSoftwareJPanel, -2, -1, -2).addContainerGap())).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.spectrumSelectionPsmSplitPane, -1, 747, Short.MAX_VALUE).addGap(180, 180, 180))));
    }

    private void formComponentResized(ComponentEvent evt) {
        this.spectrumSelectionPsmSplitPane.setDividerLocation(this.spectrumSelectionPsmSplitPane.getHeight() / 100 * 34);
        this.psmAndSpectrumSplitPane.setDividerLocation(this.psmAndSpectrumSplitPane.getWidth() / 2);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SpectrumIdentificationPanel.this.psmsLayeredPane.getComponent(0).setBounds(SpectrumIdentificationPanel.this.psmsLayeredPane.getWidth() - SpectrumIdentificationPanel.this.psmsLayeredPane.getComponent(0).getWidth() - 10, -3, SpectrumIdentificationPanel.this.psmsLayeredPane.getComponent(0).getWidth(), SpectrumIdentificationPanel.this.psmsLayeredPane.getComponent(0).getHeight());
                SpectrumIdentificationPanel.this.psmsLayeredPane.getComponent(1).setBounds(SpectrumIdentificationPanel.this.psmsLayeredPane.getWidth() - SpectrumIdentificationPanel.this.psmsLayeredPane.getComponent(1).getWidth() - 20, -3, SpectrumIdentificationPanel.this.psmsLayeredPane.getComponent(1).getWidth(), SpectrumIdentificationPanel.this.psmsLayeredPane.getComponent(1).getHeight());
                SpectrumIdentificationPanel.this.psmsLayeredPane.getComponent(2).setBounds(SpectrumIdentificationPanel.this.psmsLayeredPane.getWidth() - SpectrumIdentificationPanel.this.psmsLayeredPane.getComponent(2).getWidth() - 5, -3, SpectrumIdentificationPanel.this.psmsLayeredPane.getComponent(2).getWidth(), SpectrumIdentificationPanel.this.psmsLayeredPane.getComponent(2).getHeight());
                SpectrumIdentificationPanel.this.psmsLayeredPane.getComponent(3).setBounds(0, 0, SpectrumIdentificationPanel.this.psmsLayeredPane.getWidth(), SpectrumIdentificationPanel.this.psmsLayeredPane.getHeight());
                SpectrumIdentificationPanel.this.psmsLayeredPane.revalidate();
                SpectrumIdentificationPanel.this.psmsLayeredPane.repaint();
                SpectrumIdentificationPanel.this.idSoftwareJLayeredPane.getComponent(0).setBounds(SpectrumIdentificationPanel.this.idSoftwareJLayeredPane.getWidth() - SpectrumIdentificationPanel.this.idSoftwareJLayeredPane.getComponent(0).getWidth() - 10, -3, SpectrumIdentificationPanel.this.idSoftwareJLayeredPane.getComponent(0).getWidth(), SpectrumIdentificationPanel.this.idSoftwareJLayeredPane.getComponent(0).getHeight());
                SpectrumIdentificationPanel.this.idSoftwareJLayeredPane.getComponent(1).setBounds(SpectrumIdentificationPanel.this.idSoftwareJLayeredPane.getWidth() - SpectrumIdentificationPanel.this.idSoftwareJLayeredPane.getComponent(1).getWidth() - 20, -3, SpectrumIdentificationPanel.this.idSoftwareJLayeredPane.getComponent(1).getWidth(), SpectrumIdentificationPanel.this.idSoftwareJLayeredPane.getComponent(1).getHeight());
                SpectrumIdentificationPanel.this.idSoftwareJLayeredPane.getComponent(2).setBounds(SpectrumIdentificationPanel.this.idSoftwareJLayeredPane.getWidth() - SpectrumIdentificationPanel.this.idSoftwareJLayeredPane.getComponent(2).getWidth() - 5, -3, SpectrumIdentificationPanel.this.idSoftwareJLayeredPane.getComponent(2).getWidth(), SpectrumIdentificationPanel.this.idSoftwareJLayeredPane.getComponent(2).getHeight());
                SpectrumIdentificationPanel.this.idSoftwareJLayeredPane.getComponent(3).setBounds(0, 0, SpectrumIdentificationPanel.this.idSoftwareJLayeredPane.getWidth(), SpectrumIdentificationPanel.this.idSoftwareJLayeredPane.getHeight());
                SpectrumIdentificationPanel.this.idSoftwareJLayeredPane.revalidate();
                SpectrumIdentificationPanel.this.idSoftwareJLayeredPane.repaint();
                SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.getComponent(0).setBounds(SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.getWidth() - SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.getComponent(0).getWidth() - 34, 0, SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.getComponent(0).getWidth(), SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.getComponent(0).getHeight());
                SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.getComponent(1).setBounds(SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.getWidth() - SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.getComponent(1).getWidth() - 10, -3, SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.getComponent(1).getWidth(), SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.getComponent(1).getHeight());
                SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.getComponent(2).setBounds(SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.getWidth() - SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.getComponent(2).getWidth() - 20, -3, SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.getComponent(2).getWidth(), SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.getComponent(2).getHeight());
                SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.getComponent(3).setBounds(SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.getWidth() - SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.getComponent(3).getWidth() - 5, -3, SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.getComponent(3).getWidth(), SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.getComponent(3).getHeight());
                SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.getComponent(4).setBounds(0, 0, SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.getWidth(), SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.getHeight());
                SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.revalidate();
                SpectrumIdentificationPanel.this.spectrumSelectionLayeredPane.repaint();
                SpectrumIdentificationPanel.this.spectrumLayeredPane.getComponent(0).setBounds(SpectrumIdentificationPanel.this.spectrumLayeredPane.getWidth() - SpectrumIdentificationPanel.this.spectrumLayeredPane.getComponent(0).getWidth() - 10, -3, SpectrumIdentificationPanel.this.spectrumLayeredPane.getComponent(0).getWidth(), SpectrumIdentificationPanel.this.spectrumLayeredPane.getComponent(0).getHeight());
                SpectrumIdentificationPanel.this.spectrumLayeredPane.getComponent(1).setBounds(SpectrumIdentificationPanel.this.spectrumLayeredPane.getWidth() - SpectrumIdentificationPanel.this.spectrumLayeredPane.getComponent(1).getWidth() - 20, -3, SpectrumIdentificationPanel.this.spectrumLayeredPane.getComponent(1).getWidth(), SpectrumIdentificationPanel.this.spectrumLayeredPane.getComponent(1).getHeight());
                SpectrumIdentificationPanel.this.spectrumLayeredPane.getComponent(2).setBounds(SpectrumIdentificationPanel.this.spectrumLayeredPane.getWidth() - SpectrumIdentificationPanel.this.spectrumLayeredPane.getComponent(2).getWidth() - 5, -3, SpectrumIdentificationPanel.this.spectrumLayeredPane.getComponent(2).getWidth(), SpectrumIdentificationPanel.this.spectrumLayeredPane.getComponent(2).getHeight());
                SpectrumIdentificationPanel.this.spectrumLayeredPane.getComponent(3).setBounds(0, 0, SpectrumIdentificationPanel.this.spectrumLayeredPane.getWidth(), SpectrumIdentificationPanel.this.spectrumLayeredPane.getHeight());
                SpectrumIdentificationPanel.this.spectrumLayeredPane.revalidate();
                SpectrumIdentificationPanel.this.spectrumLayeredPane.repaint();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (SpectrumIdentificationPanel.this.peptideShakerGUI.getUserParameters().showSliders()) {
                            SpectrumIdentificationPanel.this.slidersSplitPane.setDividerLocation(SpectrumIdentificationPanel.this.slidersSplitPane.getWidth() - 30);
                        } else {
                            SpectrumIdentificationPanel.this.slidersSplitPane.setDividerLocation(SpectrumIdentificationPanel.this.slidersSplitPane.getWidth());
                        }
                    }
                });
            }
        });
    }

    private void searchResultsTableKeyReleased(KeyEvent evt) {
        this.searchResultsTableMouseClicked(null);
    }

    private void searchResultsTableMouseClicked(MouseEvent evt) {
        if (this.searchResultsTable.getSelectedRow() != -1) {
            this.updateSpectrum();
        }
    }

    private void searchResultsTableMouseReleased(MouseEvent evt) {
        if (this.searchResultsTable.getSelectedRow() != -1) {
            this.updateSpectrum();
            if (evt != null) {
                int row = this.searchResultsTable.rowAtPoint(evt.getPoint());
                int column = this.searchResultsTable.columnAtPoint(evt.getPoint());
                if (column == 1 && evt.getButton() == 1 && ((String)this.searchResultsTable.getValueAt(row, column)).lastIndexOf("a href=") != -1) {
                    this.peptideShakerGUI.openProteinLinks((String)this.searchResultsTable.getValueAt(row, column));
                }
            }
            this.showSpectrumAnnotationMenu();
        }
    }

    private void peptideShakerJTableMouseMoved(MouseEvent evt) {
        int column;
        int row = this.peptideShakerJTable.rowAtPoint(evt.getPoint());
        if (this.peptideShakerJTable.getValueAt(row, column = this.peptideShakerJTable.columnAtPoint(evt.getPoint())) != null) {
            if (column == this.peptideShakerJTable.getColumn("Protein(s)").getModelIndex()) {
                String tempValue = (String)this.peptideShakerJTable.getValueAt(row, column);
                if (tempValue.lastIndexOf("a href=") != -1) {
                    this.setCursor(new Cursor(12));
                } else {
                    this.setCursor(new Cursor(0));
                }
                this.peptideShakerJTable.setToolTipText(null);
            } else if (column == this.peptideShakerJTable.getColumn("Sequence").getModelIndex()) {
                this.setCursor(new Cursor(0));
                this.peptideShakerJTable.setToolTipText(this.peptideShakerJTablePeptideTooltip);
            } else {
                this.setCursor(new Cursor(0));
                this.peptideShakerJTable.setToolTipText(null);
            }
        }
    }

    private void peptideShakerJTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void peptideShakerJTableMouseReleased(MouseEvent evt) {
        int row = this.peptideShakerJTable.rowAtPoint(evt.getPoint());
        int column = this.peptideShakerJTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column == 3 && evt.getButton() == 1 && ((String)this.peptideShakerJTable.getValueAt(row, column)).lastIndexOf("a href=") != -1) {
            this.peptideShakerGUI.openProteinLinks((String)this.peptideShakerJTable.getValueAt(row, column));
        }
    }

    private void searchResultsTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void searchResultsTableMouseMoved(MouseEvent evt) {
        int column;
        int row = this.searchResultsTable.rowAtPoint(evt.getPoint());
        if (this.searchResultsTable.getValueAt(row, column = this.searchResultsTable.columnAtPoint(evt.getPoint())) != null) {
            if (column == this.searchResultsTable.getColumn("Sequence").getModelIndex()) {
                this.setCursor(new Cursor(0));
                this.searchResultsTable.setToolTipText(this.searchResultsTablePeptideTooltips.get(row));
            } else {
                this.setCursor(new Cursor(0));
                this.searchResultsTable.setToolTipText(null);
            }
        } else {
            this.searchResultsTable.setToolTipText(null);
        }
    }

    private void intensitySliderMouseWheelMoved(MouseWheelEvent evt) {
        this.spectrumJPanelMouseWheelMoved(evt);
    }

    private void intensitySliderStateChanged(ChangeEvent evt) {
        this.peptideShakerGUI.getIdentificationParameters().getAnnotationParameters().setIntensityLimit((double)Integer.valueOf(this.intensitySlider.getValue()).intValue() / 100.0);
        this.peptideShakerGUI.updateSpectrumAnnotations();
        this.peptideShakerGUI.setDataSaved(false);
        this.intensitySlider.setToolTipText("Annotation Level: " + this.intensitySlider.getValue() + "%");
        this.updateSpectrumSliderToolTip();
    }

    private void spectrumJPanelMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.isControlDown()) {
            if (evt.getWheelRotation() > 0) {
                this.accuracySlider.setValue(this.accuracySlider.getValue() - 1);
            } else {
                int oldValue = this.accuracySlider.getValue();
                int newValue = oldValue + 1;
                this.accuracySlider.setValue(newValue);
                while (oldValue == this.accuracySlider.getValue()) {
                    this.accuracySlider.setValue(newValue++);
                    if (this.accuracySlider.getValue() != this.accuracySlider.getMaximum()) continue;
                    break;
                }
            }
        } else if (evt.getWheelRotation() > 0) {
            this.intensitySlider.setValue(this.intensitySlider.getValue() - 1);
        } else {
            int oldValue = this.intensitySlider.getValue();
            int newValue = oldValue + 1;
            this.intensitySlider.setValue(newValue);
            while (oldValue == this.intensitySlider.getValue()) {
                this.intensitySlider.setValue(newValue++);
                if (this.intensitySlider.getValue() != this.intensitySlider.getMaximum()) continue;
            }
        }
        this.updateSpectrumSliderToolTip();
    }

    private void accuracySliderMouseWheelMoved(MouseWheelEvent evt) {
        this.spectrumJPanelMouseWheelMoved(evt);
    }

    private void accuracySliderStateChanged(ChangeEvent evt) {
        SearchParameters searchParameters = this.peptideShakerGUI.getIdentificationParameters().getSearchParameters();
        double accuracy = (double)this.accuracySlider.getValue() / 100.0 * searchParameters.getFragmentIonAccuracy();
        this.peptideShakerGUI.getIdentificationParameters().getAnnotationParameters().setFragmentIonAccuracy(accuracy);
        this.peptideShakerGUI.updateSpectrumAnnotations();
        this.peptideShakerGUI.setDataSaved(false);
        this.accuracySlider.setToolTipText("Annotation Accuracy: " + Util.roundDouble(accuracy, 2) + " " + (Object)((Object)searchParameters.getFragmentAccuracyType()));
        this.updateSpectrumSliderToolTip();
    }

    private void psmsHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void psmsHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void psmsHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.peptideShakerGUI, this.getClass().getResource("/helpFiles/PSMs.html"), "#PSM", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Spectrum IDs - Help");
        this.setCursor(new Cursor(0));
    }

    private void exportPsmsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportPsmsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportPsmsJButtonActionPerformed(ActionEvent evt) {
        this.copyTableContentToClipboardOrFile(TableIndex.PSM_TABLES);
    }

    private void idSoftwareHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void idSoftwareHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void idSoftwareHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.peptideShakerGUI, this.getClass().getResource("/helpFiles/PSMs.html"), "#IdSoftwarePerformance", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Spectrum IDs - Help");
        this.setCursor(new Cursor(0));
    }

    private void exportIdPerformancePerformanceJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportIdPerformancePerformanceJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void spectrumSelectionHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void spectrumSelectionHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void spectrumSelectionHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.peptideShakerGUI, this.getClass().getResource("/helpFiles/PSMs.html"), "#SpectrumSelection", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Spectrum IDs - Help");
        this.setCursor(new Cursor(0));
    }

    private void exportSpectrumSelectionJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportSpectrumSelectionJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportSpectrumSelectionJButtonActionPerformed(ActionEvent evt) {
        this.copyTableContentToClipboardOrFile(TableIndex.SPECTRUM_FILES);
    }

    private void spectrumHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void spectrumHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void spectrumHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.peptideShakerGUI, this.getClass().getResource("/helpFiles/PSMs.html"), "#Spectrum", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Spectrum IDs - Help");
        this.setCursor(new Cursor(0));
    }

    private void exportSpectrumJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportSpectrumJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportIdPerformancePerformanceJButtonMouseReleased(MouseEvent evt) {
        this.idPlotsPopupMenu.show(this.exportIdPerformancePerformanceJButton, evt.getX(), evt.getY());
    }

    private void exportSpectrumJButtonMouseReleased(MouseEvent evt) {
        JMenuItem menuItem;
        JPopupMenu popupMenu = new JPopupMenu();
        if (this.searchResultsTable.getSelectedRowCount() <= 2) {
            menuItem = new JMenuItem("Spectrum");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SpectrumIdentificationPanel.this.peptideShakerGUI.exportSpectrumAsFigure();
                }
            });
            popupMenu.add(menuItem);
        }
        if (this.searchResultsTable.getSelectedRowCount() > 2) {
            menuItem = new JMenuItem("Bubble Plot");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SpectrumIdentificationPanel.this.peptideShakerGUI.exportBubblePlotAsFigure();
                }
            });
            popupMenu.add(menuItem);
        }
        menuItem = new JMenuItem("Spectrum as MGF");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    SpectrumIdentificationPanel.this.peptideShakerGUI.exportSelectedSpectraAsMgf();
                }
                catch (Exception e) {
                    SpectrumIdentificationPanel.this.peptideShakerGUI.catchException(e);
                }
            }
        });
        popupMenu.add(menuItem);
        menuItem = new JMenuItem("Spectrum Annotation");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    SpectrumIdentificationPanel.this.peptideShakerGUI.exportAnnotatedSpectrum();
                }
                catch (Exception e) {
                    SpectrumIdentificationPanel.this.peptideShakerGUI.catchException(e);
                }
            }
        });
        popupMenu.add(menuItem);
        popupMenu.show(this.exportSpectrumJButton, evt.getX(), evt.getY());
    }

    private void spectrumTableKeyReleased(KeyEvent evt) {
        this.spectrumSelectionChanged();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void spectrumTableMouseMoved(MouseEvent evt) {
        int column;
        int row = this.spectrumTable.rowAtPoint(evt.getPoint());
        if (this.spectrumTable.getValueAt(row, column = this.spectrumTable.columnAtPoint(evt.getPoint())) == null) return;
        if (column == this.spectrumTable.getColumn("Protein(s)").getModelIndex()) {
            String tempValue = (String)this.spectrumTable.getValueAt(row, column);
            if (tempValue.lastIndexOf("a href=") != -1) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
            this.spectrumTable.setToolTipText(null);
            return;
        } else if (column == this.spectrumTable.getColumn("Sequence").getModelIndex()) {
            this.setCursor(new Cursor(0));
            int spectrumIndex = this.spectrumTable.convertRowIndexToModel(row);
            String spectrumTitle = this.peptideShakerGUI.getSpectrumProvider().getSpectrumTitles(this.fileSelected)[spectrumIndex];
            long spectrumMatchKey = SpectrumMatch.getKey(this.fileSelected, spectrumTitle);
            DisplayFeaturesGenerator displayFeaturesGenerator = this.peptideShakerGUI.getDisplayFeaturesGenerator();
            SpectrumMatch spectrumMatch = this.identification.getSpectrumMatch(spectrumMatchKey);
            if (spectrumMatch.getBestPeptideAssumption() != null) {
                String tooltip = displayFeaturesGenerator.getPeptideModificationTooltipAsHtml(spectrumMatch);
                this.spectrumTable.setToolTipText(tooltip);
                return;
            } else {
                if (spectrumMatch.getBestTagAssumption() == null) throw new IllegalArgumentException("No best match found for spectrum " + spectrumMatch.getKey() + ".");
                TagAssumption tagAssumption = spectrumMatch.getBestTagAssumption();
                this.spectrumTable.setToolTipText(this.peptideShakerGUI.getDisplayFeaturesGenerator().getTagModificationTooltipAsHtml(tagAssumption.getTag()));
            }
            return;
        } else {
            this.setCursor(new Cursor(0));
            this.spectrumTable.setToolTipText(null);
        }
    }

    private void spectrumTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void spectrumTableMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3 && this.spectrumTable.getRowCount() > 0) {
            final MouseEvent event = evt;
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Statistics (beta)");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    new XYPlottingDialog(SpectrumIdentificationPanel.this.peptideShakerGUI, SpectrumIdentificationPanel.this.spectrumTable, SpectrumIdentificationPanel.this.spectrumTable.getColumnName(SpectrumIdentificationPanel.this.spectrumTable.columnAtPoint(event.getPoint())), XYPlottingDialog.PlottingDialogPlotType.densityPlot, SpectrumIdentificationPanel.this.spectrumTableToolTips, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
                }
            });
            popupMenu.add(menuItem);
            popupMenu.show(this.spectrumTable, evt.getX(), evt.getY());
        }
    }

    private void spectrumTableMouseReleased(MouseEvent evt) {
        int row = this.spectrumTable.getSelectedRow();
        int column = this.spectrumTable.getSelectedColumn();
        if (evt.getButton() == 1 && row != -1 && column != -1 && column == this.spectrumTable.getColumn("Protein(s)").getModelIndex() && evt.getButton() == 1 && this.spectrumTable.getValueAt(row, column) != null && ((String)this.spectrumTable.getValueAt(row, column)).lastIndexOf("<a href=\"") != -1) {
            this.peptideShakerGUI.openProteinLinks((String)this.spectrumTable.getValueAt(row, column));
        }
        this.spectrumSelectionChanged();
    }

    private void fileNamesCmbActionPerformed(ActionEvent evt) {
        this.spectrumSelectionDialog.setVisible(false);
        if (this.updateSelection) {
            this.clearItemSelection();
            this.fileSelectionChanged();
        }
    }

    private void spectrumSelectionOptionsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void spectrumSelectionOptionsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void spectrumSelectionOptionsJButtonMouseReleased(MouseEvent evt) {
        this.spectrumSelectionDialog.setSize(400, 65);
        this.spectrumSelectionDialog.setLocationRelativeTo(this.spectrumSelectionOptionsJButton);
        this.spectrumSelectionDialog.setVisible(true);
    }

    private void spectrumSelectionPanelMouseReleased(MouseEvent evt) {
        if (evt.getX() > 180 && evt.getX() < 400 && evt.getY() < 25) {
            this.spectrumSelectionDialog.setSize(400, 65);
            this.spectrumSelectionDialog.setLocation(evt.getLocationOnScreen());
            this.spectrumSelectionDialog.setVisible(true);
        }
    }

    private void spectrumSelectionPanelMouseMoved(MouseEvent evt) {
        if (evt.getX() > 180 && evt.getX() < 400 && evt.getY() < 25) {
            this.spectrumSelectionPanel.setToolTipText("Select Spectrum File");
            this.setCursor(new Cursor(12));
        } else {
            this.spectrumSelectionPanel.setToolTipText(null);
            this.setCursor(new Cursor(0));
        }
    }

    private void numberPsmsPlotMenuItemActionPerformed(ActionEvent evt) {
        ChartPanel tempChartPanel = new ChartPanel(this.numberPsmsPlot.getChart(), false);
        tempChartPanel.setBounds(new Rectangle(this.numberPsmsPlot.getBounds().width * 2, this.numberPsmsPlot.getBounds().height * 2));
        new ExportGraphicsDialog((JFrame)this.peptideShakerGUI, this.peptideShakerGUI.getNormalIcon(), this.peptideShakerGUI.getWaitingIcon(), true, tempChartPanel, this.peptideShakerGUI.getLastSelectedFolder());
    }

    private void uniquePsmsMenuItemActionPerformed(ActionEvent evt) {
        ChartPanel tempChartPanel = new ChartPanel(this.uniquePsmsPlot.getChart(), false);
        tempChartPanel.setBounds(new Rectangle(this.uniquePsmsPlot.getBounds().width * 2, this.uniquePsmsPlot.getBounds().height * 2));
        new ExportGraphicsDialog((JFrame)this.peptideShakerGUI, this.peptideShakerGUI.getNormalIcon(), this.peptideShakerGUI.getWaitingIcon(), true, tempChartPanel, this.peptideShakerGUI.getLastSelectedFolder());
    }

    private void unassignedPlotMenuItemActionPerformed(ActionEvent evt) {
        ChartPanel tempChartPanel = new ChartPanel(this.unassignedPsmsPlot.getChart(), false);
        tempChartPanel.setBounds(new Rectangle(this.unassignedPsmsPlot.getBounds().width * 2, this.unassignedPsmsPlot.getBounds().height * 2));
        new ExportGraphicsDialog((JFrame)this.peptideShakerGUI, this.peptideShakerGUI.getNormalIcon(), this.peptideShakerGUI.getWaitingIcon(), true, tempChartPanel, this.peptideShakerGUI.getLastSelectedFolder());
    }

    private void idRateMenuItemActionPerformed(ActionEvent evt) {
        ChartPanel tempChartPanel = new ChartPanel(this.idRatePlot.getChart(), false);
        tempChartPanel.setBounds(new Rectangle(this.idRatePlot.getBounds().width * 2, this.idRatePlot.getBounds().height * 2));
        new ExportGraphicsDialog((JFrame)this.peptideShakerGUI, this.peptideShakerGUI.getNormalIcon(), this.peptideShakerGUI.getWaitingIcon(), true, tempChartPanel, this.peptideShakerGUI.getLastSelectedFolder());
    }

    private void vallidatedPsmsCheckBoxActionPerformed(ActionEvent evt) {
        this.spectrumSelectionChanged();
    }

    public void displayResults() {
        this.progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setTitle("Loading Data. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                SpectrumIdentificationPanel.this.progressDialog.setVisible(true);
            }
        }, "ProgressDialog").start();
        new Thread("DisplayThread"){

            @Override
            public void run() {
                try {
                    SpectrumIdentificationPanel.this.identification = SpectrumIdentificationPanel.this.peptideShakerGUI.getIdentification();
                    SpectrumIdentificationPanel.this.updateSparklines();
                    PSMaps pSMaps = new PSMaps();
                    pSMaps = (PSMaps)SpectrumIdentificationPanel.this.identification.getUrParam(pSMaps);
                    SpectrumIdentificationPanel.this.inputMap = pSMaps.getInputMap();
                    SpectrumIdentificationPanel.this.advocatesUsed = new ArrayList<Integer>(SpectrumIdentificationPanel.this.inputMap.getInputAlgorithmsSorted());
                    SpectrumIdentificationPanel.this.updateOverviewPlots();
                    ArrayList<Integer> usedAdvocatedAndPeptideShaker = new ArrayList<Integer>();
                    usedAdvocatedAndPeptideShaker.addAll(SpectrumIdentificationPanel.this.advocatesUsed);
                    if (!usedAdvocatedAndPeptideShaker.contains(Advocate.peptideShaker.getIndex())) {
                        usedAdvocatedAndPeptideShaker.add(Advocate.peptideShaker.getIndex());
                    }
                    String colorLegend = "<html>";
                    Iterator iterator = usedAdvocatedAndPeptideShaker.iterator();
                    while (iterator.hasNext()) {
                        int tempAdvocate = (Integer)iterator.next();
                        colorLegend = colorLegend + "<font color=\"rgb(" + Advocate.getAdvocateColorMap().get(tempAdvocate).getRed() + "," + Advocate.getAdvocateColorMap().get(tempAdvocate).getGreen() + "," + Advocate.getAdvocateColorMap().get(tempAdvocate).getBlue() + ")\">&#9632;</font> " + Advocate.getAdvocate(tempAdvocate).getName() + " &nbsp;";
                    }
                    colorLegend = colorLegend + "</html>";
                    SpectrumIdentificationPanel.this.colorLegendLabel.setText(colorLegend);
                    SpectrumIdentificationPanel.this.showSparkLines(SpectrumIdentificationPanel.this.peptideShakerGUI.showSparklines());
                    SpectrumIdentificationPanel.this.progressDialog.setTitle("Updating Spectrum Table. Please Wait...");
                    String[] filesArray = SpectrumIdentificationPanel.this.identification.getFractions().toArray(new String[SpectrumIdentificationPanel.this.identification.getFractions().size()]);
                    SpectrumIdentificationPanel.this.fileNamesCmb.setModel(new DefaultComboBoxModel<String>(filesArray));
                    SearchParameters searchParameters = SpectrumIdentificationPanel.this.peptideShakerGUI.getIdentificationParameters().getSearchParameters();
                    double accuracy = (double)SpectrumIdentificationPanel.this.accuracySlider.getValue() / 100.0 * searchParameters.getFragmentIonAccuracy();
                    SpectrumIdentificationPanel.this.accuracySlider.setToolTipText("Annotation Accuracy: " + Util.roundDouble(accuracy, 2) + " " + (Object)((Object)searchParameters.getFragmentAccuracyType()));
                    SpectrumIdentificationPanel.this.intensitySlider.setToolTipText("Annotation Level: " + SpectrumIdentificationPanel.this.intensitySlider.getValue() + "%");
                    SpectrumIdentificationPanel.this.exportIdPerformancePerformanceJButton.setEnabled(true);
                    SpectrumIdentificationPanel.this.exportSpectrumSelectionJButton.setEnabled(true);
                    SpectrumIdentificationPanel.this.exportSpectrumJButton.setEnabled(true);
                    SpectrumIdentificationPanel.this.exportPsmsJButton.setEnabled(true);
                    SpectrumIdentificationPanel.this.peptideShakerGUI.setUpdated(1, true);
                    boolean processCancelled = SpectrumIdentificationPanel.this.progressDialog.isRunCanceled();
                    SpectrumIdentificationPanel.this.progressDialog.setRunFinished();
                    if (!processCancelled) {
                        SpectrumIdentificationPanel.this.fileSelectionChanged();
                    }
                }
                catch (Exception e) {
                    SpectrumIdentificationPanel.this.progressDialog.setRunFinished();
                    SpectrumIdentificationPanel.this.peptideShakerGUI.catchException(e);
                }
            }
        }.start();
    }

    private void fileSelectionChanged() {
        this.progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setTitle("Updating Spectrum Table. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                SpectrumIdentificationPanel.this.progressDialog.setVisible(true);
            }
        }, "ProgressDialog").start();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultTableModel dm = (DefaultTableModel)SpectrumIdentificationPanel.this.spectrumTable.getModel();
                dm.getDataVector().removeAllElements();
                dm.fireTableDataChanged();
                SpectrumIdentificationPanel.this.fileSelected = (String)SpectrumIdentificationPanel.this.fileNamesCmb.getSelectedItem();
                SpectrumProvider spectrumProvider = SpectrumIdentificationPanel.this.peptideShakerGUI.getSpectrumProvider();
                double maxMz = spectrumProvider.getMaxPrecMz(SpectrumIdentificationPanel.this.fileSelected);
                int nSpectra = spectrumProvider.getSpectrumTitles(SpectrumIdentificationPanel.this.fileSelected).length;
                SpectrumIdentificationPanel.this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
                if (!SpectrumIdentificationPanel.this.progressDialog.isRunCanceled()) {
                    Integer nValidated = SpectrumIdentificationPanel.this.inputMap.getPeptideShakerHits(SpectrumIdentificationPanel.this.fileSelected);
                    ((TitledBorder)SpectrumIdentificationPanel.this.spectrumSelectionPanel.getBorder()).setTitle("<html>" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING_HTML + "Spectrum Selection (" + nValidated + "/" + nSpectra + " - <a href=\"dummy\">" + SpectrumIdentificationPanel.this.fileSelected + "</a>)" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING_HTML + "</html>");
                    SpectrumIdentificationPanel.this.spectrumSelectionPanel.repaint();
                    ((JSparklinesBarChartTableCellRenderer)SpectrumIdentificationPanel.this.spectrumTable.getColumn("m/z").getCellRenderer()).setMaxValue(maxMz);
                    SpectrumIdentificationPanel.this.updateSelection();
                    SpectrumIdentificationPanel.this.peptideShakerGUI.spectrumFileSelectionChanged(SpectrumIdentificationPanel.this.fileSelected);
                    SpectrumIdentificationPanel.this.spectrumTable.requestFocus();
                }
                SpectrumIdentificationPanel.this.progressDialog.setRunFinished();
            }
        });
    }

    public String getSelectedSpectrumTitle() {
        if (this.fileSelected == null) {
            return null;
        }
        String[] titles = this.peptideShakerGUI.getSpectrumProvider().getSpectrumTitles(this.fileSelected);
        int spectrumIndex = this.spectrumTable.convertRowIndexToModel(this.spectrumTable.getSelectedRow());
        return titles[spectrumIndex];
    }

    public TreeMap<String, TreeSet<String>> getSelectedSpectrumTitles() {
        TreeMap<String, TreeSet<String>> result = new TreeMap<String, TreeSet<String>>();
        TreeSet<String> spectrumTitles = new TreeSet<String>();
        spectrumTitles.add(this.getSelectedSpectrumTitle());
        result.put(this.fileSelected, spectrumTitles);
        return result;
    }

    public HashMap<Long, ArrayList<SpectrumIdentificationAssumption>> getSelectedIdentificationAssumptions() {
        int[] selectedRows = this.searchResultsTable.getSelectedRows();
        ArrayList<SpectrumIdentificationAssumption> assumptions = new ArrayList<SpectrumIdentificationAssumption>();
        for (int i = 0; i < this.searchResultsTable.getSelectedRowCount(); ++i) {
            assumptions.add(this.currentAssumptionsList.get(selectedRows[i]));
        }
        HashMap<Long, ArrayList<SpectrumIdentificationAssumption>> result = new HashMap<Long, ArrayList<SpectrumIdentificationAssumption>>(selectedRows.length);
        long spectrumMatchKey = SpectrumMatch.getKey(this.fileSelected, this.getSelectedSpectrumTitle());
        result.put(spectrumMatchKey, assumptions);
        return result;
    }

    public void updateSelection() {
        String spectrumFile = this.peptideShakerGUI.getSelectedSpectrumFile();
        String spectrumTitle = this.peptideShakerGUI.getSelectedSpectrumTitle();
        if (spectrumFile == null) {
            this.spectrumTable.setRowSelectionInterval(0, 0);
            this.spectrumTable.scrollRectToVisible(this.spectrumTable.getCellRect(0, 0, false));
            this.spectrumSelectionChanged();
        } else {
            this.selectSpectrum(spectrumFile, spectrumTitle);
        }
    }

    private void newItemSelection() {
        this.peptideShakerGUI.setSelectedItems(ExperimentObject.NO_KEY, ExperimentObject.NO_KEY, this.fileSelected, this.getSelectedSpectrumTitle());
    }

    private void clearItemSelection() {
        this.peptideShakerGUI.setSelectedItems(ExperimentObject.NO_KEY, ExperimentObject.NO_KEY, null, null);
    }

    private void selectSpectrum(String spectrumFile, String spectrumTitle) {
        if (this.fileNamesCmb.getSelectedItem() != null) {
            String[] spectrumTitles;
            int spectrumIndex;
            this.peptideShakerGUI.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")));
            if (!((String)this.fileNamesCmb.getSelectedItem()).equalsIgnoreCase(spectrumFile)) {
                this.updateSelection = false;
                this.fileNamesCmb.setSelectedItem(spectrumFile);
                this.updateSelection = true;
                this.fileSelected = (String)this.fileNamesCmb.getSelectedItem();
            }
            if ((spectrumIndex = IntStream.range(0, (spectrumTitles = this.peptideShakerGUI.getSpectrumProvider().getSpectrumTitles(spectrumFile)).length).filter(i -> spectrumTitles[i].equals(spectrumTitle)).findAny().orElse(-1)) >= 0) {
                int rowIndex = this.spectrumTable.convertRowIndexToView(spectrumIndex);
                this.spectrumTable.setRowSelectionInterval(rowIndex, rowIndex);
                this.spectrumTable.scrollRectToVisible(this.spectrumTable.getCellRect(rowIndex, 0, false));
                this.spectrumSelectionChanged();
            }
            this.peptideShakerGUI.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
        }
    }

    private void spectrumSelectionChanged() {
        if (this.spectrumTable.getSelectedRow() != -1) {
            this.setCursor(new Cursor(3));
            try {
                long spectrumMatchKey = SpectrumMatch.getKey(this.fileSelected, this.getSelectedSpectrumTitle());
                this.populateIdResultsTable(spectrumMatchKey);
                ((DefaultTableModel)this.peptideShakerJTable.getModel()).fireTableDataChanged();
                ((DefaultTableModel)this.searchResultsTable.getModel()).fireTableDataChanged();
                if (this.searchResultsTable.getRowCount() > 0) {
                    this.searchResultsTable.setRowSelectionInterval(0, 0);
                }
                this.peptideShakerJTable.revalidate();
                this.peptideShakerJTable.repaint();
                this.searchResultsTable.revalidate();
                this.searchResultsTable.repaint();
                this.newItemSelection();
                this.setCursor(new Cursor(0));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpectrumIdentificationPanel.this.updateSpectrum();
                    }
                });
            }
            catch (Exception e) {
                this.setCursor(new Cursor(0));
                this.peptideShakerGUI.catchException(e);
            }
        }
    }

    private void populateIdResultsTable(long spectrumMatchKey) {
        this.currentAssumptionsList = new ArrayList(8);
        this.searchResultsTablePeptideTooltips = new ArrayList(8);
        SpectrumMatch spectrumMatch = this.identification.getSpectrumMatch(spectrumMatchKey);
        if (spectrumMatch != null) {
            HashMap<Integer, TreeMap<Double, ArrayList<PeptideAssumption>>> peptideAssumptions = spectrumMatch.getPeptideAssumptionsMap();
            TreeMap peptideAssumptionsByPep = new TreeMap();
            for (Map.Entry<Integer, TreeMap<Double, ArrayList<PeptideAssumption>>> entry1 : peptideAssumptions.entrySet()) {
                int tool = entry1.getKey();
                for (Map.Entry<Double, ArrayList<PeptideAssumption>> entry2 : entry1.getValue().entrySet()) {
                    ArrayList<PeptideAssumption> assumptions = entry2.getValue();
                    for (PeptideAssumption peptideAssumption2 : assumptions) {
                        String sequence;
                        ArrayList<PeptideAssumption> sequenceAssumptions;
                        TreeMap<String, ArrayList<PeptideAssumption>> toolMap;
                        PSParameter psParameter = (PSParameter)peptideAssumption2.getUrParam(PSParameter.dummy);
                        double pep = psParameter.getProbability();
                        TreeMap mapAtPep = (TreeMap)peptideAssumptionsByPep.get(pep);
                        if (mapAtPep == null) {
                            mapAtPep = new TreeMap();
                            peptideAssumptionsByPep.put(pep, mapAtPep);
                        }
                        if ((toolMap = (TreeMap<String, ArrayList<PeptideAssumption>>)mapAtPep.get(tool)) == null) {
                            toolMap = new TreeMap<String, ArrayList<PeptideAssumption>>();
                            mapAtPep.put(tool, toolMap);
                        }
                        if ((sequenceAssumptions = (ArrayList<PeptideAssumption>)toolMap.get(sequence = peptideAssumption2.getPeptide().getSequence())) == null) {
                            sequenceAssumptions = new ArrayList<PeptideAssumption>(1);
                            toolMap.put(sequence, sequenceAssumptions);
                        }
                        sequenceAssumptions.add(peptideAssumption2);
                    }
                }
            }
            peptideAssumptionsByPep.values().stream().flatMap(subMap -> subMap.values().stream()).flatMap(subMap -> subMap.values().stream()).flatMap(assumptionList -> assumptionList.stream()).forEach(peptideAssumption -> {
                Peptide peptide = peptideAssumption.getPeptide();
                if (this.peptideShakerGUI.getIdentificationParameters().getPeptideAssumptionFilter().validatePeptide(peptide, this.peptideShakerGUI.getIdentificationParameters().getSequenceMatchingParameters(), this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getDigestionParameters())) {
                    if (this.vallidatedPsmsCheckBox.isSelected()) {
                        PSParameter psParameter = (PSParameter)peptideAssumption.getUrParam(PSParameter.dummy);
                        if (psParameter.getMatchValidationLevel().isValidated()) {
                            this.currentAssumptionsList.add((SpectrumIdentificationAssumption)peptideAssumption);
                            this.searchResultsTablePeptideTooltips.add(this.peptideShakerGUI.getDisplayFeaturesGenerator().getPeptideModificationTooltipAsHtml(peptide));
                        }
                    } else {
                        this.currentAssumptionsList.add((SpectrumIdentificationAssumption)peptideAssumption);
                        this.searchResultsTablePeptideTooltips.add(this.peptideShakerGUI.getDisplayFeaturesGenerator().getPeptideModificationTooltipAsHtml(peptide));
                    }
                }
            });
            spectrumMatch.getTagAssumptionsMap().values().stream().flatMap(subMap -> subMap.values().stream()).flatMap(array -> array.stream()).forEach(tagAssumption -> {
                this.currentAssumptionsList.add((SpectrumIdentificationAssumption)tagAssumption);
                String toolTip = this.peptideShakerGUI.getDisplayFeaturesGenerator().getTagModificationTooltipAsHtml(tagAssumption.getTag());
                this.searchResultsTablePeptideTooltips.add(toolTip);
            });
        }
    }

    public void updateSpectrum() {
        if (this.spectrumTable.getSelectedRow() != -1) {
            this.spectrumChartPanel.removeAll();
            String spectrumTitle = this.getSelectedSpectrumTitle();
            Spectrum currentSpectrum = this.peptideShakerGUI.getSpectrumProvider().getSpectrum(this.fileSelected, spectrumTitle);
            AnnotationParameters annotationParameters = this.peptideShakerGUI.getIdentificationParameters().getAnnotationParameters();
            long spectrumMatchKey = SpectrumMatch.getKey(this.fileSelected, spectrumTitle);
            SpectrumMatch spectrumMatch = this.identification.getSpectrumMatch(spectrumMatchKey);
            if (currentSpectrum != null && currentSpectrum.getNPeaks() > 0) {
                Precursor precursor = currentSpectrum.getPrecursor();
                String chargeAsString = "";
                if (spectrumMatch != null) {
                    if (spectrumMatch.getBestPeptideAssumption() != null) {
                        chargeAsString = Charge.toString(spectrumMatch.getBestPeptideAssumption().getIdentificationCharge());
                    } else if (spectrumMatch.getBestTagAssumption() != null) {
                        chargeAsString = Charge.toString(spectrumMatch.getBestTagAssumption().getIdentificationCharge());
                    }
                } else {
                    chargeAsString = precursor.getPossibleChargesAsString();
                }
                double[] intensitiesAsArray = this.searchResultsTable.getSelectedRowCount() == 1 ? currentSpectrum.intensity : ArrayUtil.scaleToMax(currentSpectrum.intensity, true);
                this.spectrumPanel = new SpectrumPanel(currentSpectrum.mz, intensitiesAsArray, precursor.mz, chargeAsString, "", 40, false, false, false, 2, false);
                SpectrumPanel.setKnownMassDeltas(this.peptideShakerGUI.getCurrentMassDeltas());
                this.spectrumPanel.setDeltaMassWindow(annotationParameters.getFragmentIonAccuracy());
                this.spectrumPanel.setBorder(null);
                this.spectrumPanel.setDataPointAndLineColor(this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumAnnotatedPeakColor(), 0);
                this.spectrumPanel.setPeakWaterMarkColor(this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumBackgroundPeakColor());
                this.spectrumPanel.setPeakWidth(this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumAnnotatedPeakWidth());
                this.spectrumPanel.setBackgroundPeakWidth(this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumBackgroundPeakWidth());
                if (this.searchResultsTable.getSelectedRowCount() == 2) {
                    this.spectrumPanel.addMirroredSpectrum(currentSpectrum.mz, ArrayUtil.scaleToMax(currentSpectrum.intensity, true), precursor.mz, chargeAsString, "", false, this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumAnnotatedMirroredPeakColor(), this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumAnnotatedMirroredPeakColor());
                }
            }
            if (spectrumMatch != null) {
                SequenceProvider sequenceProvider = this.peptideShakerGUI.getSequenceProvider();
                IdentificationParameters identificationParameters = this.peptideShakerGUI.getIdentificationParameters();
                ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
                SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
                SearchParameters searchParameters = identificationParameters.getSearchParameters();
                DisplayParameters displayParameters = this.peptideShakerGUI.getDisplayParameters();
                int forwardIon = searchParameters.getForwardIons().get(0);
                int rewindIon = searchParameters.getRewindIons().get(0);
                if (currentSpectrum != null && this.spectrumPanel != null && currentSpectrum.getNPeaks() > 0) {
                    int maxPrecursorCharge = 1;
                    String modifiedSequence = "";
                    HashSet<String> allModifications = new HashSet<String>();
                    ArrayList<IonMatch[]> allAnnotations = new ArrayList<IonMatch[]>();
                    ArrayList<Spectrum> allSpectra = new ArrayList<Spectrum>();
                    ArrayList<String> selectedIndexes = new ArrayList<String>();
                    SpecificAnnotationParameters specificAnnotationParameters = null;
                    for (int i = 0; i < this.searchResultsTable.getSelectedRowCount(); ++i) {
                        SpectrumIdentificationAssumption currentAssumption = this.currentAssumptionsList.get(this.searchResultsTable.getSelectedRows()[i]);
                        if (currentAssumption == null) continue;
                        selectedIndexes.add(i + 1 + " " + Charge.toString(currentAssumption.getIdentificationCharge()));
                        if (currentAssumption instanceof PeptideAssumption) {
                            PeptideAssumption currentPeptideAssumption = (PeptideAssumption)currentAssumption;
                            Peptide peptide = currentPeptideAssumption.getPeptide();
                            PeptideSpectrumAnnotator peptideSpectrumAnnotator = new PeptideSpectrumAnnotator();
                            specificAnnotationParameters = this.peptideShakerGUI.getSpecificAnnotationParameters(this.fileSelected, spectrumTitle, currentPeptideAssumption);
                            IonMatch[] annotations = peptideSpectrumAnnotator.getSpectrumAnnotation(annotationParameters, specificAnnotationParameters, this.fileSelected, spectrumTitle, currentSpectrum, peptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
                            allAnnotations.add(annotations);
                            allSpectra.add(currentSpectrum);
                            if (i == 0) {
                                this.spectrumPanel.setAnnotations(SpectrumAnnotator.getSpectrumAnnotation(annotations), annotationParameters.getTiesResolution() == SpectrumAnnotator.TiesResolution.mostIntense);
                                this.spectrumPanel.addAutomaticDeNovoSequencing(peptide, annotations, forwardIon, rewindIon, annotationParameters.getDeNovoCharge(), annotationParameters.showForwardIonDeNovoTags(), annotationParameters.showRewindIonDeNovoTags(), false, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
                            } else {
                                this.spectrumPanel.setAnnotationsMirrored(SpectrumAnnotator.getSpectrumAnnotation(annotations));
                                this.spectrumPanel.addAutomaticDeNovoSequencing(peptide, annotations, forwardIon, rewindIon, annotationParameters.getDeNovoCharge(), annotationParameters.showForwardIonDeNovoTags(), annotationParameters.showRewindIonDeNovoTags(), true, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
                            }
                            if (currentPeptideAssumption.getIdentificationCharge() > maxPrecursorCharge) {
                                maxPrecursorCharge = currentPeptideAssumption.getIdentificationCharge();
                            }
                            if (!modifiedSequence.isEmpty()) {
                                modifiedSequence = modifiedSequence + " vs. ";
                            }
                            modifiedSequence = modifiedSequence + peptide.getTaggedModifiedSequence(modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, false, false, true, displayParameters.getDisplayedModifications());
                            allModifications.addAll(ModificationUtils.getAllModifications(peptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters));
                            continue;
                        }
                        if (currentAssumption instanceof TagAssumption) {
                            TagAssumption tagAssumption = (TagAssumption)currentAssumption;
                            TagSpectrumAnnotator spectrumAnnotator = new TagSpectrumAnnotator();
                            specificAnnotationParameters = this.peptideShakerGUI.getSpecificAnnotationParameters(this.fileSelected, spectrumTitle, tagAssumption);
                            IonMatch[] annotations = spectrumAnnotator.getSpectrumAnnotation(annotationParameters, modificationParameters, modificationSequenceMatchingParameters, specificAnnotationParameters, this.fileSelected, spectrumTitle, currentSpectrum, tagAssumption.getTag());
                            this.spectrumPanel.setAnnotations(SpectrumAnnotator.getSpectrumAnnotation(annotations), annotationParameters.getTiesResolution() == SpectrumAnnotator.TiesResolution.mostIntense);
                            this.spectrumPanel.addAutomaticDeNovoSequencing(tagAssumption.getTag(), annotations, forwardIon, rewindIon, annotationParameters.getDeNovoCharge(), annotationParameters.showForwardIonDeNovoTags(), annotationParameters.showRewindIonDeNovoTags(), false);
                            allModifications.addAll(ModificationUtils.getAllModifications(tagAssumption.getTag(), modificationParameters, modificationSequenceMatchingParameters));
                            if (tagAssumption.getIdentificationCharge() > maxPrecursorCharge) {
                                maxPrecursorCharge = tagAssumption.getIdentificationCharge();
                            }
                            if (!modifiedSequence.isEmpty()) {
                                modifiedSequence = modifiedSequence + " vs. ";
                            }
                            modifiedSequence = modifiedSequence + tagAssumption.getTag().getTaggedModifiedSequence(modificationParameters, false, false, true, false, modificationSequenceMatchingParameters, displayParameters.getDisplayedModifications());
                            continue;
                        }
                        throw new UnsupportedOperationException("Spectrum annotation not implemented for identification assumption of type " + currentAssumption.getClass() + ".");
                    }
                    this.spectrumPanel.showAnnotatedPeaksOnly(!annotationParameters.showAllPeaks());
                    this.spectrumPanel.setYAxisZoomExcludesBackgroundPeaks(annotationParameters.yAxisZoomExcludesBackgroundPeaks());
                    this.peptideShakerGUI.updateAnnotationMenus(specificAnnotationParameters, maxPrecursorCharge, allModifications);
                    if (this.searchResultsTable.getSelectedRowCount() == 1) {
                        ((TitledBorder)this.spectrumPanelPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Spectrum & Fragment Ions (" + modifiedSequence + "   " + maxPrecursorCharge + "   " + Util.roundDouble(currentSpectrum.getPrecursor().mz, 2) + " m/z)" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
                    } else if (this.searchResultsTable.getSelectedRowCount() == 2) {
                        ((TitledBorder)this.spectrumPanelPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Spectrum & Fragment Ions (" + modifiedSequence + ")" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
                    } else if (this.searchResultsTable.getSelectedRowCount() > 2) {
                        ((TitledBorder)this.spectrumPanelPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Spectrum & Fragment Ions (" + this.searchResultsTable.getSelectedRowCount() + " PSMs)" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
                    }
                    this.spectrumPanelPanel.repaint();
                    if (this.searchResultsTable.getSelectedRowCount() > 2) {
                        SearchParameters.MassAccuracyType fragmentAccuracyType = this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getFragmentAccuracyType();
                        double bubbleScale = annotationParameters.getFragmentIonAccuracy() * 10.0 * this.peptideShakerGUI.getBubbleScale();
                        DisplayParameters displayPreferences = this.peptideShakerGUI.getDisplayParameters();
                        MassErrorBubblePlot massErrorBubblePlot = new MassErrorBubblePlot(selectedIndexes, allAnnotations, allSpectra, annotationParameters.getFragmentIonAccuracy(), bubbleScale, selectedIndexes.size() == 1, displayPreferences.showBars(), fragmentAccuracyType == SearchParameters.MassAccuracyType.PPM);
                        if (selectedIndexes.size() > 20) {
                            massErrorBubblePlot.getChartPanel().getChart().getLegend().setVisible(false);
                        }
                        massErrorBubblePlot.getChartPanel().getChart().getPlot().setOutlineVisible(false);
                        this.spectrumChartPanel.add(massErrorBubblePlot);
                    }
                }
                if (this.searchResultsTable.getSelectedRowCount() <= 2) {
                    this.spectrumChartPanel.add(this.spectrumPanel);
                }
            } else {
                ((TitledBorder)this.spectrumPanelPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Spectrum & Fragment Ions (" + Util.roundDouble(currentSpectrum.getPrecursor().mz, 2) + " m/z)" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
                if (currentSpectrum.getNPeaks() > 0) {
                    this.spectrumChartPanel.add(this.spectrumPanel);
                }
                this.spectrumPanelPanel.repaint();
            }
        }
        this.spectrumChartPanel.revalidate();
        this.spectrumChartPanel.repaint();
    }

    public Component getSpectrum() {
        return this.spectrumChartPanel.getComponent(0);
    }

    public void showSpectrumAnnotationMenu() {
        this.spectrumAnnotationMenuPanel.removeAll();
        this.spectrumAnnotationMenuPanel.add(this.peptideShakerGUI.getAnnotationMenuBar());
        this.peptideShakerGUI.updateAnnotationMenuBarVisableOptions(this.searchResultsTable.getSelectedRowCount() <= 2, this.searchResultsTable.getSelectedRowCount() > 2, false, false, this.searchResultsTable.getSelectedRowCount() == 1);
    }

    public Component getBubblePlot() {
        if (this.searchResultsTable.getSelectedRowCount() > 2) {
            return ((MassErrorBubblePlot)this.spectrumChartPanel.getComponent(0)).getChartPanel();
        }
        return null;
    }

    public void setIntensitySliderValue(int value) {
        this.intensitySlider.setValue(value);
    }

    public void setAccuracySliderValue(int value) {
        this.accuracySlider.setValue(value);
    }

    public void updateModificationColors() {
        this.setCursor(new Cursor(3));
        this.spectrumSelectionChanged();
        this.setCursor(new Cursor(0));
    }

    private void copyTableContentToClipboardOrFile(TableIndex index) {
        File selectedFile;
        final TableIndex tableIndex = index;
        if ((tableIndex == TableIndex.SPECTRUM_FILES || tableIndex == TableIndex.PSM_TABLES) && (selectedFile = this.peptideShakerGUI.getUserSelectedFile("table_export.txt", ".txt", "Tab separated text file (.txt)", "Export...", false)) != null) {
            try {
                final BufferedWriter writer = new BufferedWriter(new FileWriter(selectedFile));
                this.progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
                this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
                this.progressDialog.setTitle("Copying to File. Please Wait...");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SpectrumIdentificationPanel.this.progressDialog.setVisible(true);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                }, "ProgressDialog").start();
                new Thread("ExportThread"){

                    @Override
                    public void run() {
                        try {
                            if (tableIndex == TableIndex.SPECTRUM_FILES) {
                                Util.tableToFile(SpectrumIdentificationPanel.this.spectrumTable, "\t", SpectrumIdentificationPanel.this.progressDialog, true, writer);
                            } else if (tableIndex == TableIndex.PSM_TABLES) {
                                Util.tableToFile(SpectrumIdentificationPanel.this.searchResultsTable, "\t", SpectrumIdentificationPanel.this.progressDialog, true, writer);
                            }
                            writer.close();
                            boolean processCancelled = SpectrumIdentificationPanel.this.progressDialog.isRunCanceled();
                            SpectrumIdentificationPanel.this.progressDialog.setRunFinished();
                            if (!processCancelled) {
                                JOptionPane.showMessageDialog(SpectrumIdentificationPanel.this.peptideShakerGUI, "Table content copied to file:\n" + selectedFile.getPath(), "Copied to File", 1);
                            }
                        }
                        catch (IOException e) {
                            SpectrumIdentificationPanel.this.progressDialog.setRunFinished();
                            JOptionPane.showMessageDialog(SpectrumIdentificationPanel.this.peptideShakerGUI, "An error occurred while generating the output.", "Output Error.", 0);
                            e.printStackTrace();
                        }
                    }
                }.start();
            }
            catch (IOException e) {
                this.progressDialog.setRunFinished();
                JOptionPane.showMessageDialog(this.peptideShakerGUI, "An error occurred while generating the output.", "Output Error.", 0);
                e.printStackTrace();
            }
        }
    }

    public void updateSeparators() {
        if (this.peptideShakerGUI.getUserParameters().showSliders()) {
            this.slidersSplitPane.setDividerLocation(this.slidersSplitPane.getWidth() - 30);
        } else {
            this.slidersSplitPane.setDividerLocation(this.slidersSplitPane.getWidth());
        }
    }

    private void updateSpectrumSliderToolTip() {
        SearchParameters searchParameters = this.peptideShakerGUI.getIdentificationParameters().getSearchParameters();
        double accuracy = (double)this.accuracySlider.getValue() / 100.0 * searchParameters.getFragmentIonAccuracy();
        this.spectrumJPanel.setToolTipText("<html>Accuracy: " + Util.roundDouble(accuracy, 2) + " " + (Object)((Object)searchParameters.getFragmentAccuracyType()) + "<br>Level: " + this.intensitySlider.getValue() + "%</html>");
        ToolTipManager.sharedInstance().mouseMoved(new MouseEvent(this.spectrumJPanel, 0, 0L, 0, this.spectrumJPanel.getWidth() - 150, this.spectrumJPanel.getY() + 20, 0, false));
    }

    public static int isBestPsmEqualForAllIdSoftware(SpectrumMatch spectrumMatch, SequenceMatchingParameters sequenceMatchingPreferences, Integer numberOfAdvocatesUsed) {
        PeptideAssumption bestPeptideAssumption = spectrumMatch.getBestPeptideAssumption();
        HashMap<Integer, TreeMap<Double, ArrayList<PeptideAssumption>>> peptideAssumptions = spectrumMatch.getPeptideAssumptionsMap();
        if (bestPeptideAssumption == null || peptideAssumptions == null || peptideAssumptions.isEmpty()) {
            return 0;
        }
        if (peptideAssumptions.size() == 1) {
            return numberOfAdvocatesUsed == 1 ? 4 : 2;
        }
        int agreement = 4;
        for (Map.Entry<Integer, TreeMap<Double, ArrayList<PeptideAssumption>>> entry1 : peptideAssumptions.entrySet()) {
            Map.Entry<Double, ArrayList<PeptideAssumption>> entry2 = entry1.getValue().firstEntry();
            boolean advocateSameSequence = false;
            boolean advocateSameModifications = false;
            if (entry2 != null) {
                for (PeptideAssumption peptideAssumption : entry2.getValue()) {
                    if (bestPeptideAssumption.getPeptide().isSameSequenceAndModificationStatus(peptideAssumption.getPeptide(), sequenceMatchingPreferences)) {
                        advocateSameSequence = true;
                        if (bestPeptideAssumption.getPeptide().sameModificationsAs(peptideAssumption.getPeptide())) {
                            advocateSameModifications = true;
                        }
                    }
                    if (!advocateSameSequence || !advocateSameModifications) continue;
                    break;
                }
            }
            if (!advocateSameSequence) {
                return 1;
            }
            if (advocateSameModifications) continue;
            agreement = 3;
        }
        return peptideAssumptions.size() < numberOfAdvocatesUsed ? 2 : agreement;
    }

    private void updateOverviewPlots() {
        String selectedFileName = null;
        HashMap<Integer, Double> searchEngineValidated = new HashMap<Integer, Double>();
        HashMap<Integer, Double> searchEngineUniqueContribution = new HashMap<Integer, Double>();
        int totalNumberOfSpectra = 0;
        if (selectedFileName == null) {
            for (String spectrumFileName : this.identification.getFractions()) {
                totalNumberOfSpectra += this.peptideShakerGUI.getSpectrumProvider().getSpectrumTitles(spectrumFileName).length;
            }
            Iterator<Object> iterator = this.inputMap.getInputAlgorithmsSorted().iterator();
            while (iterator.hasNext()) {
                int advocateId = (Integer)iterator.next();
                double contribution = this.inputMap.getAdvocateContribution(advocateId);
                searchEngineValidated.put(advocateId, contribution);
                double uniqueContribution = this.inputMap.getAdvocateUniqueContribution(advocateId);
                searchEngineUniqueContribution.put(advocateId, uniqueContribution);
            }
            double contribution = this.inputMap.getPeptideShakerHits();
            searchEngineValidated.put(Advocate.peptideShaker.getIndex(), contribution);
            double uniqueContribution = this.inputMap.getPeptideShakerUniqueContribution();
            searchEngineUniqueContribution.put(Advocate.peptideShaker.getIndex(), uniqueContribution);
        } else {
            totalNumberOfSpectra = this.peptideShakerGUI.getSpectrumProvider().getSpectrumTitles(selectedFileName).length;
            for (int advocateId : this.inputMap.getInputAlgorithmsSorted()) {
                double contribution = this.inputMap.getAdvocateContribution(advocateId, selectedFileName);
                searchEngineValidated.put(advocateId, contribution);
                double uniqueContribution = this.inputMap.getAdvocateUniqueContribution(advocateId, selectedFileName);
                searchEngineUniqueContribution.put(advocateId, uniqueContribution);
            }
            double contribution = this.inputMap.getPeptideShakerHits(selectedFileName);
            searchEngineValidated.put(Advocate.peptideShaker.getIndex(), contribution);
            double uniqueContribution = this.inputMap.getPeptideShakerUniqueContribution(selectedFileName);
            searchEngineUniqueContribution.put(Advocate.peptideShaker.getIndex(), uniqueContribution);
        }
        this.updateOverviewPlots(searchEngineValidated, searchEngineUniqueContribution, totalNumberOfSpectra);
    }

    private void updateOverviewPlots(final HashMap<Integer, Double> totalAdvocateId, final HashMap<Integer, Double> uniqueAdvocateId, final int totalNumberOfSpectra) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SpectrumIdentificationPanel.this.overviewPlotsPanel.removeAll();
                SpectrumIdentificationPanel.this.numberPsmsPlot = SpectrumIdentificationPanel.this.createPlot(totalAdvocateId, "#PSMs", false);
                SpectrumIdentificationPanel.this.overviewPlotsPanel.add((Component)SpectrumIdentificationPanel.this.numberPsmsPlot);
                SpectrumIdentificationPanel.this.uniquePsmsPlot = SpectrumIdentificationPanel.this.createPlot(uniqueAdvocateId, "#Unique PSMs", false);
                SpectrumIdentificationPanel.this.overviewPlotsPanel.add((Component)SpectrumIdentificationPanel.this.uniquePsmsPlot);
                HashMap<Integer, Double> unassignedAdvocate = new HashMap<Integer, Double>();
                Iterator iterator = SpectrumIdentificationPanel.this.advocatesUsed.iterator();
                while (iterator.hasNext()) {
                    int tempAdvocate = (Integer)iterator.next();
                    if (!totalAdvocateId.containsKey(tempAdvocate)) continue;
                    unassignedAdvocate.put(tempAdvocate, (double)totalNumberOfSpectra - (Double)totalAdvocateId.get(tempAdvocate));
                }
                unassignedAdvocate.put(Advocate.peptideShaker.getIndex(), (double)totalNumberOfSpectra - (Double)totalAdvocateId.get(Advocate.peptideShaker.getIndex()));
                SpectrumIdentificationPanel.this.unassignedPsmsPlot = SpectrumIdentificationPanel.this.createPlot(unassignedAdvocate, "#Unassigned", false);
                SpectrumIdentificationPanel.this.overviewPlotsPanel.add((Component)SpectrumIdentificationPanel.this.unassignedPsmsPlot);
                HashMap<Integer, Double> idRateAdvocate = new HashMap<Integer, Double>();
                Iterator iterator2 = SpectrumIdentificationPanel.this.advocatesUsed.iterator();
                while (iterator2.hasNext()) {
                    int tempAdvocate = (Integer)iterator2.next();
                    if (!totalAdvocateId.containsKey(tempAdvocate)) continue;
                    idRateAdvocate.put(tempAdvocate, (Double)totalAdvocateId.get(tempAdvocate) / (double)totalNumberOfSpectra * 100.0);
                }
                idRateAdvocate.put(Advocate.peptideShaker.getIndex(), (Double)totalAdvocateId.get(Advocate.peptideShaker.getIndex()) / (double)totalNumberOfSpectra * 100.0);
                SpectrumIdentificationPanel.this.idRatePlot = SpectrumIdentificationPanel.this.createPlot(idRateAdvocate, "ID Rate (%)", true);
                SpectrumIdentificationPanel.this.overviewPlotsPanel.add((Component)SpectrumIdentificationPanel.this.idRatePlot);
                SpectrumIdentificationPanel.this.overviewPlotsPanel.revalidate();
                SpectrumIdentificationPanel.this.overviewPlotsPanel.repaint();
            }
        });
    }

    private ChartPanel createPlot(HashMap<Integer, Double> data, String xAxisLabel, boolean roundDecimals) {
        DefaultCategoryDataset psmDataset = new DefaultCategoryDataset();
        for (Integer tempAdvocate : this.advocatesUsed) {
            psmDataset.addValue((Number)data.get(tempAdvocate), (Comparable)((Object)Advocate.getAdvocate(tempAdvocate).getName()), (Comparable)((Object)xAxisLabel));
        }
        psmDataset.addValue((Number)data.get(Advocate.peptideShaker.getIndex()), (Comparable)((Object)Advocate.peptideShaker.getName()), (Comparable)((Object)xAxisLabel));
        JFreeChart chart = ChartFactory.createBarChart(null, null, null, (CategoryDataset)psmDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        CategoryPlot plot = chart.getCategoryPlot();
        ChartPanel chartPanel = new ChartPanel(chart, false);
        chartPanel.setBackground(Color.WHITE);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setLowerMargin(0.15);
        rangeAxis.setUpperMargin(0.15);
        plot.setOutlineVisible(false);
        BarRenderer renderer = new BarRenderer();
        renderer.setShadowVisible(false);
        renderer.setBarPainter((BarPainter)new StandardBarPainter());
        int dataSeriesCounter = 0;
        for (Integer tempAdvocate : this.advocatesUsed) {
            if (!this.advocatesUsed.contains(tempAdvocate)) continue;
            renderer.setSeriesPaint(dataSeriesCounter++, (Paint)Advocate.getAdvocateColorMap().get(tempAdvocate));
        }
        renderer.setSeriesPaint(dataSeriesCounter, (Paint)Advocate.getAdvocateColorMap().get(Advocate.peptideShaker.getIndex()));
        if (roundDecimals) {
            renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("{2}", (NumberFormat)new DecimalFormat("0.0")));
        } else {
            renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        }
        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        renderer.setBaseItemLabelsVisible(true);
        plot.setRenderer((CategoryItemRenderer)renderer);
        return chartPanel;
    }

    public void updateScores() {
        ((DefaultTableModel)this.spectrumTable.getModel()).fireTableStructureChanged();
        ((DefaultTableModel)this.peptideShakerJTable.getModel()).fireTableStructureChanged();
        ((DefaultTableModel)this.searchResultsTable.getModel()).fireTableStructureChanged();
        this.setTableProperties();
        this.updateSparklines();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SpectrumIdentificationPanel.this.updateSelection();
            }
        });
    }

    private void updateSparklines() {
        if (this.identification != null) {
            SpectrumProvider spectrumProvider = this.peptideShakerGUI.getSpectrumProvider();
            int maxCharge = this.peptideShakerGUI.getMetrics().getMaxCharge();
            this.spectrumTable.getColumn("Charge").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxCharge), this.peptideShakerGUI.getSparklineColor()));
            this.spectrumTable.getColumn("Intensity").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(spectrumProvider.getMaxPrecInt()), this.peptideShakerGUI.getSparklineColor()));
            this.spectrumTable.getColumn("RT (min)").setCellRenderer((TableCellRenderer)new JSparklinesIntervalChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(0.0), Double.valueOf(spectrumProvider.getMaxPrecRT() / 60.0), Double.valueOf(spectrumProvider.getMaxPrecRT() / 60.0 / 50.0), this.peptideShakerGUI.getSparklineColor(), this.peptideShakerGUI.getSparklineColor()));
            ((JSparklinesBarChartTableCellRenderer)this.spectrumTable.getColumn("Charge").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 30);
            if (spectrumProvider.getMaxPrecInt() > 100000.0) {
                ((JSparklinesBarChartTableCellRenderer)this.spectrumTable.getColumn("Intensity").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() + 20, new DecimalFormat("0.00E00"));
            } else {
                ((JSparklinesBarChartTableCellRenderer)this.spectrumTable.getColumn("Intensity").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() + 20);
            }
            ((JSparklinesBarChartTableCellRenderer)this.spectrumTable.getColumn("Intensity").getCellRenderer()).setLogScale(true);
            ((JSparklinesIntervalChartTableCellRenderer)this.spectrumTable.getColumn("RT (min)").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth());
            ((JSparklinesIntervalChartTableCellRenderer)this.spectrumTable.getColumn("RT (min)").getCellRenderer()).showReferenceLine(true, 0.02, Color.BLACK);
        }
    }

    static {
        BarRenderer.setDefaultBarPainter((BarPainter)new StandardBarPainter());
    }

    private class SpectrumTableModel
    extends DefaultTableModel {
        private SpectrumTableModel() {
        }

        @Override
        public int getRowCount() {
            if (SpectrumIdentificationPanel.this.fileSelected != null) {
                return SpectrumIdentificationPanel.this.peptideShakerGUI.getSpectrumProvider().getSpectrumTitles(SpectrumIdentificationPanel.this.fileSelected).length;
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            if (SpectrumIdentificationPanel.this.peptideShakerGUI.getDisplayParameters().showScores()) {
                return 13;
            }
            return 12;
        }

        @Override
        public String getColumnName(int column) {
            int columnIndex = column;
            if (!SpectrumIdentificationPanel.this.peptideShakerGUI.getDisplayParameters().showScores() && column > 9) {
                columnIndex = column + 1;
            }
            switch (columnIndex) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "ID";
                }
                case 2: {
                    return "Title";
                }
                case 3: {
                    return "Level";
                }
                case 4: {
                    return "m/z";
                }
                case 5: {
                    return "Charge";
                }
                case 6: {
                    return "Intensity";
                }
                case 7: {
                    return "RT (min)";
                }
                case 8: {
                    return "Sequence";
                }
                case 9: {
                    return "Protein(s)";
                }
                case 10: {
                    return "Score";
                }
                case 11: {
                    return "Confidence";
                }
                case 12: {
                    return "  ";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            int columnIndex = column;
            if (!SpectrumIdentificationPanel.this.peptideShakerGUI.getDisplayParameters().showScores() && column > 9) {
                columnIndex = column + 1;
            }
            try {
                String[] spectrumTitles = SpectrumIdentificationPanel.this.peptideShakerGUI.getSpectrumProvider().getSpectrumTitles(SpectrumIdentificationPanel.this.fileSelected);
                String spectrumTitle = spectrumTitles[row];
                long spectrumMatchKey = SpectrumMatch.getKey(SpectrumIdentificationPanel.this.fileSelected, spectrumTitle);
                SpectrumMatch spectrumMatch = SpectrumIdentificationPanel.this.identification.getSpectrumMatch(spectrumMatchKey);
                switch (columnIndex) {
                    case 0: {
                        return row + 1;
                    }
                    case 1: {
                        return spectrumMatch == null ? 0 : SpectrumIdentificationPanel.isBestPsmEqualForAllIdSoftware(spectrumMatch, SpectrumIdentificationPanel.this.peptideShakerGUI.getIdentificationParameters().getSequenceMatchingParameters(), SpectrumIdentificationPanel.this.advocatesUsed.size());
                    }
                    case 2: {
                        return spectrumTitle;
                    }
                    case 3: {
                        return SpectrumIdentificationPanel.this.peptideShakerGUI.getSpectrumProvider().getSpectrum(SpectrumIdentificationPanel.this.fileSelected, spectrumTitle).getSpectrumLevel();
                    }
                    case 4: {
                        return SpectrumIdentificationPanel.this.peptideShakerGUI.getSpectrumProvider().getPrecursorMz(SpectrumIdentificationPanel.this.fileSelected, spectrumTitle);
                    }
                    case 5: {
                        Precursor precursor = SpectrumIdentificationPanel.this.peptideShakerGUI.getSpectrumProvider().getPrecursor(SpectrumIdentificationPanel.this.fileSelected, spectrumTitle);
                        return precursor == null ? null : precursor.getPossibleChargesAsString();
                    }
                    case 6: {
                        Precursor precursor = SpectrumIdentificationPanel.this.peptideShakerGUI.getSpectrumProvider().getPrecursor(SpectrumIdentificationPanel.this.fileSelected, spectrumTitle);
                        return precursor == null ? null : (precursor.intensity > 0.0 ? Double.valueOf(precursor.intensity) : null);
                    }
                    case 7: {
                        Precursor precursor = SpectrumIdentificationPanel.this.peptideShakerGUI.getSpectrumProvider().getPrecursor(SpectrumIdentificationPanel.this.fileSelected, spectrumTitle);
                        return precursor == null ? null : Double.valueOf(precursor.getRtInMinutes());
                    }
                    case 8: {
                        if (spectrumMatch != null) {
                            DisplayFeaturesGenerator displayFeaturesGenerator = SpectrumIdentificationPanel.this.peptideShakerGUI.getDisplayFeaturesGenerator();
                            if (spectrumMatch.getBestPeptideAssumption() != null) {
                                return displayFeaturesGenerator.getTaggedPeptideSequence(spectrumMatch, true, true, true);
                            }
                            if (spectrumMatch.getBestTagAssumption() != null) {
                                IdentificationParameters identificationParameters = SpectrumIdentificationPanel.this.peptideShakerGUI.getIdentificationParameters();
                                ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
                                SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
                                DisplayParameters displayParameters = SpectrumIdentificationPanel.this.peptideShakerGUI.getDisplayParameters();
                                return spectrumMatch.getBestTagAssumption().getTag().getTaggedModifiedSequence(modificationParameters, true, true, true, false, modificationSequenceMatchingParameters, displayParameters.getDisplayedModifications());
                            }
                        }
                        return null;
                    }
                    case 9: {
                        if (spectrumMatch != null) {
                            DisplayFeaturesGenerator displayFeaturesGenerator = SpectrumIdentificationPanel.this.peptideShakerGUI.getDisplayFeaturesGenerator();
                            if (spectrumMatch.getBestPeptideAssumption() != null) {
                                String[] accessions = (String[])spectrumMatch.getBestPeptideAssumption().getPeptide().getProteinMapping().keySet().stream().toArray(String[]::new);
                                return displayFeaturesGenerator.getDatabaseLinks(accessions);
                            }
                        }
                        return null;
                    }
                    case 10: {
                        if (spectrumMatch != null) {
                            PSParameter psParameter = (PSParameter)spectrumMatch.getUrParam(PSParameter.dummy);
                            if (psParameter != null) {
                                return psParameter.getTransformedScore();
                            }
                            return null;
                        }
                        return null;
                    }
                    case 11: {
                        PSParameter psParameter;
                        if (spectrumMatch != null && (psParameter = (PSParameter)spectrumMatch.getUrParam(PSParameter.dummy)) != null && psParameter.getMatchValidationLevel() != MatchValidationLevel.none) {
                            return psParameter.getConfidence();
                        }
                        return null;
                    }
                    case 12: {
                        PSParameter psParameter;
                        if (spectrumMatch != null && (psParameter = (PSParameter)spectrumMatch.getUrParam(PSParameter.dummy)) != null) {
                            return psParameter.getMatchValidationLevel().getIndex();
                        }
                        return null;
                    }
                }
                return "";
            }
            catch (Exception e) {
                SpectrumIdentificationPanel.this.peptideShakerGUI.catchException(e);
                return "";
            }
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return Double.valueOf(0.0).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }

    private class PeptideShakerPsmTableModel
    extends DefaultTableModel {
        private PeptideShakerPsmTableModel() {
        }

        @Override
        public int getRowCount() {
            if (SpectrumIdentificationPanel.this.fileSelected == null || SpectrumIdentificationPanel.this.spectrumTable.getSelectedRow() == -1) {
                return 0;
            }
            return 1;
        }

        @Override
        public int getColumnCount() {
            if (SpectrumIdentificationPanel.this.peptideShakerGUI.getDisplayParameters().showScores()) {
                return 7;
            }
            return 6;
        }

        @Override
        public String getColumnName(int column) {
            int columnIndex = column;
            if (!SpectrumIdentificationPanel.this.peptideShakerGUI.getDisplayParameters().showScores() && column > 3) {
                columnIndex = column + 1;
            }
            switch (columnIndex) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "ID";
                }
                case 2: {
                    return "Sequence";
                }
                case 3: {
                    return "Protein(s)";
                }
                case 4: {
                    return "Score";
                }
                case 5: {
                    return "Confidence";
                }
                case 6: {
                    return "  ";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            int columnIndex = column;
            if (!SpectrumIdentificationPanel.this.peptideShakerGUI.getDisplayParameters().showScores() && column > 3) {
                columnIndex = column + 1;
            }
            try {
                long spectrumMatchKey = SpectrumMatch.getKey(SpectrumIdentificationPanel.this.fileSelected, SpectrumIdentificationPanel.this.getSelectedSpectrumTitle());
                SpectrumMatch spectrumMatch = SpectrumIdentificationPanel.this.identification.getSpectrumMatch(spectrumMatchKey);
                if (spectrumMatch != null) {
                    PSParameter psParameter = (PSParameter)spectrumMatch.getUrParam(PSParameter.dummy);
                    DisplayFeaturesGenerator displayFeaturesGenerator = SpectrumIdentificationPanel.this.peptideShakerGUI.getDisplayFeaturesGenerator();
                    String proteins = "";
                    String sequence = "";
                    boolean matchFound = false;
                    if (spectrumMatch.getBestPeptideAssumption() != null) {
                        String[] proteinAccessions = (String[])spectrumMatch.getBestPeptideAssumption().getPeptide().getProteinMapping().keySet().stream().toArray(String[]::new);
                        proteins = displayFeaturesGenerator.getDatabaseLinks(proteinAccessions);
                        sequence = displayFeaturesGenerator.getTaggedPeptideSequence(spectrumMatch, true, true, true);
                        SpectrumIdentificationPanel.this.peptideShakerJTablePeptideTooltip = displayFeaturesGenerator.getPeptideModificationTooltipAsHtml(spectrumMatch);
                        matchFound = true;
                    } else if (spectrumMatch.getBestTagAssumption() != null) {
                        IdentificationParameters identificationParameters = SpectrumIdentificationPanel.this.peptideShakerGUI.getIdentificationParameters();
                        ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
                        SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
                        DisplayParameters displayParameters = SpectrumIdentificationPanel.this.peptideShakerGUI.getDisplayParameters();
                        sequence = spectrumMatch.getBestTagAssumption().getTag().getTaggedModifiedSequence(modificationParameters, true, true, true, false, modificationSequenceMatchingParameters, displayParameters.getDisplayedModifications());
                        SpectrumIdentificationPanel.this.peptideShakerJTablePeptideTooltip = displayFeaturesGenerator.getTagModificationTooltipAsHtml(spectrumMatch.getBestTagAssumption().getTag());
                        matchFound = true;
                    }
                    if (matchFound) {
                        switch (columnIndex) {
                            case 0: {
                                return row + 1;
                            }
                            case 1: {
                                return SpectrumIdentificationPanel.isBestPsmEqualForAllIdSoftware(spectrumMatch, SpectrumIdentificationPanel.this.peptideShakerGUI.getIdentificationParameters().getSequenceMatchingParameters(), SpectrumIdentificationPanel.this.advocatesUsed.size());
                            }
                            case 2: {
                                return sequence;
                            }
                            case 3: {
                                return proteins;
                            }
                            case 4: {
                                return psParameter.getTransformedScore();
                            }
                            case 5: {
                                return spectrumMatch.getBestPeptideAssumption() != null || spectrumMatch.getBestTagAssumption() != null ? Double.valueOf(psParameter.getConfidence()) : "";
                            }
                            case 6: {
                                return spectrumMatch.getBestPeptideAssumption() != null ? psParameter.getMatchValidationLevel().getIndex() : MatchValidationLevel.none.getIndex();
                            }
                        }
                        return "";
                    }
                    return null;
                }
            }
            catch (Exception e) {
                SpectrumIdentificationPanel.this.peptideShakerGUI.catchException(e);
                return "";
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return new String().getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }

    private class IdAlgorithmsPsmTableModel
    extends DefaultTableModel {
        private IdAlgorithmsPsmTableModel() {
        }

        @Override
        public int getRowCount() {
            if (SpectrumIdentificationPanel.this.currentAssumptionsList == null) {
                return 0;
            }
            return SpectrumIdentificationPanel.this.currentAssumptionsList.size();
        }

        @Override
        public int getColumnCount() {
            if (SpectrumIdentificationPanel.this.peptideShakerGUI.getDisplayParameters().showScores()) {
                return 8;
            }
            return 7;
        }

        @Override
        public String getColumnName(int column) {
            int columnIndex = column;
            if (!SpectrumIdentificationPanel.this.peptideShakerGUI.getDisplayParameters().showScores() && column > 4) {
                columnIndex = column + 1;
            }
            switch (columnIndex) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "SE";
                }
                case 2: {
                    return "Rnk";
                }
                case 3: {
                    return "Sequence";
                }
                case 4: {
                    return "Charge";
                }
                case 5: {
                    return "Score";
                }
                case 6: {
                    return "Confidence";
                }
                case 7: {
                    return "  ";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            int columnIndex = column;
            if (!SpectrumIdentificationPanel.this.peptideShakerGUI.getDisplayParameters().showScores() && column > 4) {
                columnIndex = column + 1;
            }
            try {
                if (SpectrumIdentificationPanel.this.currentAssumptionsList == null || SpectrumIdentificationPanel.this.currentAssumptionsList.isEmpty()) {
                    return null;
                }
                SpectrumIdentificationAssumption spectrumIdentificationAssumption = (SpectrumIdentificationAssumption)SpectrumIdentificationPanel.this.currentAssumptionsList.get(row);
                switch (columnIndex) {
                    case 0: {
                        return row + 1;
                    }
                    case 1: {
                        return spectrumIdentificationAssumption.getAdvocate();
                    }
                    case 2: {
                        return spectrumIdentificationAssumption.getRank();
                    }
                    case 3: {
                        IdentificationParameters identificationParameters = SpectrumIdentificationPanel.this.peptideShakerGUI.getIdentificationParameters();
                        ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
                        SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
                        DisplayParameters displayParameters = SpectrumIdentificationPanel.this.peptideShakerGUI.getDisplayParameters();
                        if (spectrumIdentificationAssumption instanceof PeptideAssumption) {
                            SequenceProvider sequenceProvider = SpectrumIdentificationPanel.this.peptideShakerGUI.getSequenceProvider();
                            Peptide peptide = ((PeptideAssumption)spectrumIdentificationAssumption).getPeptide();
                            return peptide.getTaggedModifiedSequence(modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, true, true, true, displayParameters.getDisplayedModifications());
                        }
                        if (spectrumIdentificationAssumption instanceof TagAssumption) {
                            TagAssumption tagAssumption = (TagAssumption)spectrumIdentificationAssumption;
                            return tagAssumption.getTag().getTaggedModifiedSequence(modificationParameters, true, true, true, false, modificationSequenceMatchingParameters, displayParameters.getDisplayedModifications());
                        }
                        throw new UnsupportedOperationException("Sequence display not implemented for assumption " + spectrumIdentificationAssumption.getClass() + ".");
                    }
                    case 4: {
                        return spectrumIdentificationAssumption.getIdentificationCharge();
                    }
                    case 5: {
                        return spectrumIdentificationAssumption.getRawScore();
                    }
                    case 6: {
                        PSParameter psParameter = (PSParameter)spectrumIdentificationAssumption.getUrParam(PSParameter.dummy);
                        return psParameter.getConfidence();
                    }
                    case 7: {
                        PSParameter psParameter = (PSParameter)spectrumIdentificationAssumption.getUrParam(PSParameter.dummy);
                        return psParameter == null || psParameter.getMatchValidationLevel() == null ? MatchValidationLevel.none.getIndex() : psParameter.getMatchValidationLevel().getIndex();
                    }
                }
                return "";
            }
            catch (Exception e) {
                SpectrumIdentificationPanel.this.peptideShakerGUI.catchException(e);
                return "";
            }
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return new String().getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }

    private static enum TableIndex {
        SPECTRUM_FILES,
        PSM_TABLES;

    }
}

