/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.protein_inference;

import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches_iterators.PeptideMatchesIterator;
import com.compomics.util.experiment.identification.peptide_shaker.Metrics;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.waiting.WaitingHandler;
import com.google.common.collect.Sets;
import eu.isas.peptideshaker.scoring.targetdecoy.TargetDecoyMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;

public class ProteinInference {
    public static final String[] KEYWORDS_UNCHARACTERIZED = new String[]{"uncharacterized"};

    public void inferPiStatus(Identification identification, Metrics metrics, TargetDecoyMap proteinMap, IdentificationParameters identificationParameters, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, WaitingHandler waitingHandler) {
        waitingHandler.setWaitingText("Inferring PI Status and Sorting Proteins. Please Wait...");
        waitingHandler.setMaxSecondaryProgressCounter(identification.getProteinIdentification().size());
        identification.getProteinIdentification().parallelStream().map(key -> identification.getProteinMatch((long)key)).forEach(proteinMatch -> this.inferPiStatus((ProteinMatch)proteinMatch, identification, metrics, proteinMap, identificationParameters, sequenceProvider, proteinDetailsProvider, waitingHandler));
        waitingHandler.setSecondaryProgressCounterIndeterminate(true);
    }

    public void inferPiStatus(ProteinMatch proteinMatch, Identification identification, Metrics metrics, TargetDecoyMap proteinMap, IdentificationParameters identificationParameters, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, WaitingHandler waitingHandler) {
        if (waitingHandler.isRunCanceled()) {
            return;
        }
        PSParameter proteinMatchParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy);
        String[] accessions = proteinMatch.getAccessions();
        String mainAccession = proteinMatch.getLeadingAccession();
        if (accessions.length > 1) {
            boolean similarityFound = false;
            boolean allSimilar = false;
            for (String accession : accessions) {
                if (this.compareMainProtein(proteinMatch, mainAccession, proteinMatch, accession, sequenceProvider, proteinDetailsProvider, identificationParameters, identification) <= 0) continue;
                mainAccession = accession;
            }
            block1: for (int i = 0; i < accessions.length - 1; ++i) {
                for (int j = i + 1; j < accessions.length; ++j) {
                    if (!this.getSimilarity(accessions[i], accessions[j], proteinDetailsProvider)) continue;
                    similarityFound = true;
                    if (this.compareMainProtein(proteinMatch, mainAccession, proteinMatch, accessions[j], sequenceProvider, proteinDetailsProvider, identificationParameters, identification) <= 0) break block1;
                    mainAccession = accessions[i];
                    break block1;
                }
            }
            if (similarityFound) {
                allSimilar = true;
                for (String accession : accessions) {
                    if (mainAccession.equals(accession) || this.getSimilarity(mainAccession, accession, proteinDetailsProvider)) continue;
                    allSimilar = false;
                    break;
                }
            }
            if (!similarityFound) {
                proteinMatchParameter.setProteinInferenceClass(3);
                for (long peptideKey : proteinMatch.getPeptideMatchesKeys()) {
                    PeptideMatch peptideMatch = identification.getPeptideMatch(peptideKey);
                    PSParameter peptideParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
                    peptideParameter.setProteinInferenceClass(3);
                    identification.updateObject(peptideKey, peptideMatch);
                }
            } else if (!allSimilar) {
                proteinMatchParameter.setProteinInferenceClass(2);
                for (long peptideKey : proteinMatch.getPeptideMatchesKeys()) {
                    PeptideMatch peptideMatch = identification.getPeptideMatch(peptideKey);
                    PSParameter peptideParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
                    peptideParameter.setProteinInferenceClass(2);
                    identification.updateObject(peptideKey, peptideMatch);
                }
            } else {
                proteinMatchParameter.setProteinInferenceClass(1);
                HashSet proteinGroupAccessions = Sets.newHashSet((Object[])proteinMatch.getAccessions());
                for (long peptideKey : proteinMatch.getPeptideMatchesKeys()) {
                    PeptideMatch peptideMatch = identification.getPeptideMatch(peptideKey);
                    boolean unrelated = false;
                    for (String proteinAccession : peptideMatch.getPeptide().getProteinMapping().navigableKeySet()) {
                        if (proteinGroupAccessions.contains(proteinAccession) || this.getSimilarity(mainAccession, proteinAccession, proteinDetailsProvider)) continue;
                        unrelated = true;
                        break;
                    }
                    PSParameter peptideParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
                    if (unrelated) {
                        peptideParameter.setProteinInferenceClass(2);
                    } else {
                        peptideParameter.setProteinInferenceClass(1);
                    }
                    identification.updateObject(peptideKey, peptideMatch);
                }
            }
        } else {
            HashSet proteinGroupAccessions = Sets.newHashSet((Object[])proteinMatch.getAccessions());
            for (long peptideKey : proteinMatch.getPeptideMatchesKeys()) {
                PeptideMatch peptideMatch = identification.getPeptideMatch(peptideKey);
                boolean related = false;
                boolean unrelated = false;
                for (String proteinAccession : peptideMatch.getPeptide().getProteinMapping().navigableKeySet()) {
                    if (proteinGroupAccessions.contains(proteinAccession)) continue;
                    boolean similar = this.getSimilarity(mainAccession, proteinAccession, proteinDetailsProvider);
                    if (similar) {
                        related = true;
                        continue;
                    }
                    unrelated = true;
                }
                PSParameter peptideParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
                if (related && unrelated) {
                    peptideParameter.setProteinInferenceClass(2);
                } else if (related) {
                    peptideParameter.setProteinInferenceClass(1);
                } else if (unrelated) {
                    peptideParameter.setProteinInferenceClass(3);
                }
                identification.updateObject(peptideKey, peptideMatch);
            }
        }
        if (proteinMatch.getAccessions().length > 1 && !proteinMatch.getLeadingAccession().equals(mainAccession)) {
            proteinMatch.setLeadingAccession(mainAccession);
            identification.updateObject(proteinMatch.getKey(), proteinMatch);
        }
        waitingHandler.increaseSecondaryProgressCounter();
    }

    private HashSet<String> parseDescription(String proteinDescription) {
        if (proteinDescription == null) {
            return new HashSet<String>(0);
        }
        return Arrays.stream(proteinDescription.split(" ")).filter(component -> component.length() > 3).collect(Collectors.toCollection(HashSet::new));
    }

    private int compareMainProtein(ProteinMatch oldProteinMatch, String oldAccession, ProteinMatch newProteinMatch, String newAccession, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, IdentificationParameters identificationParameters, Identification identification) {
        String newDescription;
        String oldDescription;
        DigestionParameters digestionPreferences = identificationParameters.getSearchParameters().getDigestionParameters();
        if (digestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
            boolean newEnzymatic = Arrays.stream(newProteinMatch.getPeptideMatchesKeys()).mapToObj(key -> identification.getPeptideMatch(key)).anyMatch(peptideMatch -> PeptideUtils.isEnzymatic(peptideMatch.getPeptide(), newAccession, sequenceProvider.getSequence(newAccession), digestionPreferences.getEnzymes()));
            boolean oldEnzymatic = Arrays.stream(oldProteinMatch.getPeptideMatchesKeys()).mapToObj(key -> identification.getPeptideMatch(key)).anyMatch(peptideMatch -> PeptideUtils.isEnzymatic(peptideMatch.getPeptide(), oldAccession, sequenceProvider.getSequence(oldAccession), digestionPreferences.getEnzymes()));
            if (newEnzymatic && !oldEnzymatic) {
                return 1;
            }
            if (!newEnzymatic && oldEnzymatic) {
                return 0;
            }
        }
        Integer evidenceLevelOld = proteinDetailsProvider.getProteinEvidence(oldAccession);
        Integer evidenceLevelNew = proteinDetailsProvider.getProteinEvidence(newAccession);
        if (evidenceLevelOld != null && evidenceLevelNew != null) {
            if (evidenceLevelNew < evidenceLevelOld) {
                return 2;
            }
            if (evidenceLevelOld < evidenceLevelNew) {
                return 0;
            }
        }
        if ((oldDescription = proteinDetailsProvider.getSimpleDescription(oldAccession)) == null || oldDescription.trim().isEmpty()) {
            oldDescription = proteinDetailsProvider.getDescription(oldAccession);
        }
        if ((newDescription = proteinDetailsProvider.getSimpleDescription(newAccession)) == null || newDescription.trim().isEmpty()) {
            newDescription = proteinDetailsProvider.getDescription(newAccession);
        }
        boolean oldUncharacterized = false;
        boolean newUncharacterized = false;
        for (String keyWord : KEYWORDS_UNCHARACTERIZED) {
            if (newDescription != null && newDescription.contains(keyWord)) {
                newUncharacterized = true;
            }
            if (oldDescription == null || !oldDescription.contains(keyWord)) continue;
            oldUncharacterized = true;
        }
        if (oldUncharacterized && !newUncharacterized) {
            return 3;
        }
        if (!oldUncharacterized && newUncharacterized) {
            return 0;
        }
        return 0;
    }

    private boolean getSimilarity(String primaryProteinAccession, String secondaryProteinAccession, ProteinDetailsProvider proteinDetailsProvider) {
        String geneNamePrimaryProtein = proteinDetailsProvider.getGeneName(primaryProteinAccession);
        String geneNameSecondaryProtein = proteinDetailsProvider.getGeneName(secondaryProteinAccession);
        boolean sameGene = false;
        if (geneNamePrimaryProtein != null && geneNameSecondaryProtein != null) {
            sameGene = geneNamePrimaryProtein.equalsIgnoreCase(geneNameSecondaryProtein);
        }
        if (sameGene) {
            return true;
        }
        if (geneNamePrimaryProtein != null && geneNameSecondaryProtein != null) {
            if (geneNamePrimaryProtein.contains(geneNameSecondaryProtein) || geneNameSecondaryProtein.contains(geneNamePrimaryProtein)) {
                return true;
            }
            if (geneNameSecondaryProtein.length() > 2 && geneNamePrimaryProtein.contains(geneNameSecondaryProtein.substring(0, geneNameSecondaryProtein.length() - 2)) || geneNamePrimaryProtein.length() > 2 && geneNameSecondaryProtein.contains(geneNamePrimaryProtein.substring(0, geneNamePrimaryProtein.length() - 2))) {
                return true;
            }
            if (geneNameSecondaryProtein.length() > 3 && geneNamePrimaryProtein.contains(geneNameSecondaryProtein.substring(0, geneNameSecondaryProtein.length() - 3)) || geneNamePrimaryProtein.length() > 3 && geneNameSecondaryProtein.contains(geneNamePrimaryProtein.substring(0, geneNamePrimaryProtein.length() - 3))) {
                return true;
            }
        }
        HashSet<String> primaryDescription = this.parseDescription(proteinDetailsProvider.getSimpleDescription(primaryProteinAccession));
        HashSet<String> secondaryDescription = this.parseDescription(proteinDetailsProvider.getSimpleDescription(secondaryProteinAccession));
        if (primaryDescription.size() > secondaryDescription.size()) {
            int nMatch = 0;
            for (String secondaryDescription1 : secondaryDescription) {
                if (!primaryDescription.contains(secondaryDescription1)) continue;
                ++nMatch;
            }
            return nMatch >= secondaryDescription.size() / 2;
        }
        int nMatch = 0;
        for (String primaryDescription1 : primaryDescription) {
            if (!secondaryDescription.contains(primaryDescription1)) continue;
            ++nMatch;
        }
        return nMatch >= primaryDescription.size() / 2;
    }

    public void distributeSharedPeptides(Identification identification, WaitingHandler waitingHandler) {
        PeptideMatch peptideMatch;
        waitingHandler.setWaitingText("Inferring PI Status and Sorting Proteins. Please Wait...");
        waitingHandler.setMaxSecondaryProgressCounter(identification.getProteinIdentification().size());
        PeptideMatchesIterator peptideMatchesIterator = identification.getPeptideMatchesIterator(waitingHandler);
        while ((peptideMatch = peptideMatchesIterator.next()) != null) {
            Peptide peptide = peptideMatch.getPeptide();
            if (peptide.getProteinMapping().size() > 1) {
                long peptideMatchKey = peptideMatch.getKey();
                for (String protein : peptide.getProteinMapping().keySet()) {
                    HashSet<Long> proteinKeys = identification.getProteinMap().get(protein);
                    if (proteinKeys == null) continue;
                    for (long proteinKey : proteinKeys) {
                        ProteinMatch proteinMatch = identification.getProteinMatch(proteinKey);
                        if (!Arrays.stream(proteinMatch.getAccessions()).allMatch(accession -> peptide.getProteinMapping().containsKey(accession)) || !Arrays.stream(proteinMatch.getPeptideMatchesKeys()).allMatch(key -> key != peptideMatchKey)) continue;
                        proteinMatch.addPeptideMatchKey(peptideMatchKey);
                        identification.updateObject(proteinMatch.getKey(), proteinMatch);
                    }
                }
            }
            waitingHandler.increaseSecondaryProgressCounter();
            if (!waitingHandler.isRunCanceled()) continue;
            return;
        }
        waitingHandler.setSecondaryProgressCounterIndeterminate(true);
    }

    public static enum GroupSimplificationOption {
        lowerEvidence(0, "protein groups supported by predicted or uncertain proteins"),
        lowerConfidence(0, "protein groups supported by low confidence peptides"),
        nonEnzymatic(1, "protein groups supported by non-enzymatic shared peptides"),
        variant(2, "protein groups supported by peptides shared by variant only"),
        simplerGroups(3, "protein groups explained by simpler groups");

        public final int index;
        public final String description;

        private GroupSimplificationOption(int index, String description) {
            this.index = index;
            this.description = description;
        }
    }
}

