/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.protein_inference;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.amino_acid_tags.MassGap;
import com.compomics.util.experiment.identification.amino_acid_tags.Tag;
import com.compomics.util.experiment.identification.amino_acid_tags.TagComponent;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.protein_inference.FastaMapper;
import com.compomics.util.experiment.identification.protein_inference.PeptideProteinMapping;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.spectrum_assumptions.TagAssumption;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.identification.tool_specific.PepnovoParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

public class TagMapper {
    private final IdentificationParameters identificationParameters;
    private final ExceptionHandler exceptionHandler;

    public TagMapper(IdentificationParameters identificationParameters, ExceptionHandler exceptionHandler) {
        this.identificationParameters = identificationParameters;
        this.exceptionHandler = exceptionHandler;
    }

    public void mapTags(ArrayList<SpectrumMatch> spectrumMatches, FastaMapper fastaMapper, WaitingHandler waitingHandler) {
        for (SpectrumMatch spectrumMatch : spectrumMatches) {
            if (waitingHandler.isRunCanceled()) continue;
            this.mapTagsForSpectrumMatch(spectrumMatch, fastaMapper);
            waitingHandler.increaseSecondaryProgressCounter();
        }
    }

    private void mapTagsForSpectrumMatch(SpectrumMatch spectrumMatch, FastaMapper fastaMapper) {
        SequenceMatchingParameters sequenceMatchingPreferences = this.identificationParameters.getSequenceMatchingParameters();
        HashMap<Integer, TreeMap<Double, ArrayList<TagAssumption>>> assumptionsMap = spectrumMatch.getTagAssumptionsMap();
        for (Map.Entry<Integer, TreeMap<Double, ArrayList<TagAssumption>>> entry : assumptionsMap.entrySet()) {
            int advocateId = entry.getKey();
            TreeMap<Double, ArrayList<TagAssumption>> algorithmAssumptions = entry.getValue();
            HashSet<String> inspectedTags = new HashSet<String>(algorithmAssumptions.size());
            HashSet<Long> peptidesFound = new HashSet<Long>(algorithmAssumptions.size());
            for (ArrayList<TagAssumption> assumptionsAtScore : algorithmAssumptions.values()) {
                for (TagAssumption tagAssumption : assumptionsAtScore) {
                    String tagSequence = tagAssumption.getTag().asSequence();
                    if (inspectedTags.contains(tagSequence)) continue;
                    Tag tag = tagAssumption.getTag();
                    this.mapModificationsForTag(tag, advocateId);
                    ArrayList<PeptideProteinMapping> proteinMapping = fastaMapper.getProteinMapping(tag, sequenceMatchingPreferences);
                    for (Peptide peptide : PeptideProteinMapping.getPeptides(proteinMapping, sequenceMatchingPreferences)) {
                        long peptideKey = peptide.getKey();
                        if (peptidesFound.contains(peptideKey)) continue;
                        PeptideAssumption peptideAssumption = new PeptideAssumption(peptide, tagAssumption.getRank(), advocateId, tagAssumption.getIdentificationCharge(), tagAssumption.getRawScore(), tagAssumption.getScore(), tagAssumption.getIdentificationFile());
                        spectrumMatch.addPeptideAssumption(advocateId, peptideAssumption);
                        peptidesFound.add(peptideKey);
                    }
                    inspectedTags.add(tagSequence);
                }
            }
        }
    }

    private void mapModificationsForTag(Tag tag, int advocateId) {
        SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
        for (TagComponent tagComponent : tag.getContent()) {
            if (tagComponent instanceof AminoAcidSequence) {
                AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)tagComponent;
                for (ModificationMatch modificationMatch : aminoAcidSequence.getVariableModifications()) {
                    if (advocateId == Advocate.direcTag.getIndex() || advocateId == Advocate.pNovo.getIndex() || advocateId == Advocate.novor.getIndex()) continue;
                    if (advocateId == Advocate.pepnovo.getIndex()) {
                        String pepnovoPtmName = modificationMatch.getModification();
                        PepnovoParameters pepnovoParameters = (PepnovoParameters)searchParameters.getIdentificationAlgorithmParameter(advocateId);
                        String utilitiesPtmName = pepnovoParameters.getUtilitiesPtmName(pepnovoPtmName);
                        if (utilitiesPtmName == null) {
                            throw new IllegalArgumentException("PepNovo+ PTM " + pepnovoPtmName + " not recognized.");
                        }
                        modificationMatch.setModification(utilitiesPtmName);
                        continue;
                    }
                    Advocate notImplemented = Advocate.getAdvocate(advocateId);
                    if (notImplemented == null) {
                        throw new IllegalArgumentException("Advocate of id " + advocateId + " not recognized.");
                    }
                    throw new IllegalArgumentException("PTM mapping not implemented for " + Advocate.getAdvocate(advocateId).getName() + ".");
                }
                continue;
            }
            if (tagComponent instanceof MassGap) continue;
            throw new UnsupportedOperationException("PTM mapping not implemeted for tag component " + tagComponent.getClass() + ".");
        }
    }
}

