/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.scoring.maps;

import com.compomics.util.parameters.identification.advanced.PsmScoringParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.scoring.targetdecoy.TargetDecoyMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class InputMap
implements Serializable {
    static final long serialVersionUID = 1117083720476649996L;
    private final HashMap<Integer, TargetDecoyMap> inputMap = new HashMap();
    private final HashMap<Integer, HashMap<String, TargetDecoyMap>> inputSpecificMap = new HashMap();
    private final HashMap<String, HashMap<Integer, HashMap<Integer, TargetDecoyMap>>> intermediateScores = new HashMap();
    private HashMap<Integer, HashMap<String, Integer>> advocateContribution;
    private HashMap<Integer, HashMap<String, Integer>> advocateUniqueContribution;
    private HashMap<String, Integer> fileIdRate;
    private HashMap<String, Integer> peptideShakerUniqueContribution;

    public boolean isMultipleAlgorithms() {
        return this.inputMap.size() > 1;
    }

    public int getNalgorithms() {
        return this.inputMap.size();
    }

    public Set<Integer> getInputAlgorithms() {
        return this.inputMap.keySet();
    }

    public TreeSet<Integer> getInputAlgorithmsSorted() {
        return new TreeSet<Integer>(this.inputMap.keySet());
    }

    public Set<Integer> getIntermediateScoreInputAlgorithms(String fileName) {
        return this.intermediateScores.get(fileName).keySet();
    }

    public TargetDecoyMap getTargetDecoyMap(int algorithm) {
        return this.inputMap.get(algorithm);
    }

    public TargetDecoyMap getTargetDecoyMap(int algorithm, String fileName) {
        HashMap<String, TargetDecoyMap> algorithmInput = this.inputSpecificMap.get(algorithm);
        return algorithmInput == null ? null : algorithmInput.get(fileName);
    }

    public TargetDecoyMap getMap() {
        if (this.inputMap == null || this.inputMap.isEmpty()) {
            throw new IllegalArgumentException("No algorithm input found.");
        }
        if (this.isMultipleAlgorithms()) {
            throw new IllegalArgumentException("Multiple search engine results found.");
        }
        Iterator<TargetDecoyMap> iterator = this.inputMap.values().iterator();
        if (iterator.hasNext()) {
            TargetDecoyMap firstMap = iterator.next();
            return firstMap;
        }
        return null;
    }

    public void estimateProbabilities(WaitingHandler waitingHandler) {
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        waitingHandler.resetSecondaryProgressCounter();
        waitingHandler.setMaxSecondaryProgressCounter(this.getNEntries() + this.getNEntriesSpecific());
        for (TargetDecoyMap targetDecoyMap : this.inputMap.values()) {
            targetDecoyMap.estimateProbabilities(waitingHandler);
            waitingHandler.increaseSecondaryProgressCounter();
            if (!waitingHandler.isRunCanceled()) continue;
            return;
        }
        for (HashMap hashMap : this.inputSpecificMap.values()) {
            for (TargetDecoyMap targetDecoyMap : hashMap.values()) {
                targetDecoyMap.estimateProbabilities(waitingHandler);
                waitingHandler.increaseSecondaryProgressCounter();
                if (!waitingHandler.isRunCanceled()) continue;
                return;
            }
        }
        waitingHandler.setSecondaryProgressCounterIndeterminate(true);
    }

    public double getProbability(int searchEngine, double eValue) {
        TargetDecoyMap targetDecoyMap = this.inputMap.get(searchEngine);
        return targetDecoyMap == null ? 1.0 : targetDecoyMap.getProbability(eValue);
    }

    public void addEntry(int searchEngine, String spectrumFileName, double eValue, boolean isDecoy) {
        TargetDecoyMap targetDecoyMap = this.inputMap.get(searchEngine);
        if (targetDecoyMap == null) {
            targetDecoyMap = this.createTargetDecoyInputMap(searchEngine);
        }
        targetDecoyMap.put(eValue, isDecoy);
        HashMap<String, TargetDecoyMap> algorithmMap = this.inputSpecificMap.get(searchEngine);
        if (algorithmMap == null) {
            algorithmMap = this.createIntermediateInputSpecificMap(searchEngine);
        }
        if ((targetDecoyMap = algorithmMap.get(spectrumFileName)) == null) {
            targetDecoyMap = this.createTargetDecoySpecificMap(spectrumFileName, algorithmMap);
        }
        targetDecoyMap.put(eValue, isDecoy);
    }

    private synchronized TargetDecoyMap createTargetDecoyInputMap(int searchEngine) {
        TargetDecoyMap targetDecoyMap = this.inputMap.get(searchEngine);
        if (targetDecoyMap == null) {
            targetDecoyMap = new TargetDecoyMap();
            this.inputMap.put(searchEngine, targetDecoyMap);
        }
        return targetDecoyMap;
    }

    private synchronized HashMap<String, TargetDecoyMap> createIntermediateInputSpecificMap(int searchEngine) {
        HashMap<String, TargetDecoyMap> algorithmMap = this.inputSpecificMap.get(searchEngine);
        if (algorithmMap == null) {
            algorithmMap = new HashMap(2);
            this.inputSpecificMap.put(searchEngine, algorithmMap);
        }
        return algorithmMap;
    }

    private synchronized TargetDecoyMap createTargetDecoySpecificMap(String spectrumFileName, HashMap<String, TargetDecoyMap> algorithmMap) {
        TargetDecoyMap targetDecoyMap = algorithmMap.get(spectrumFileName);
        if (targetDecoyMap == null) {
            targetDecoyMap = new TargetDecoyMap();
            algorithmMap.put(spectrumFileName, targetDecoyMap);
        }
        return targetDecoyMap;
    }

    public int getNEntries() {
        return this.inputMap.values().stream().mapToInt(map -> map.getMapSize()).sum();
    }

    public int getNEntriesSpecific() {
        return this.inputSpecificMap.values().stream().flatMap(map -> map.values().stream()).mapToInt(map -> map.getMapSize()).sum();
    }

    public void resetAdvocateContributions(String fileName) {
        if (this.advocateContribution == null) {
            this.advocateContribution = new HashMap();
        } else {
            for (HashMap<String, Integer> advocateMapping : this.advocateContribution.values()) {
                advocateMapping.put(fileName, 0);
            }
        }
        if (this.advocateUniqueContribution == null) {
            this.advocateUniqueContribution = new HashMap();
        } else {
            for (HashMap<String, Integer> advocateMapping : this.advocateUniqueContribution.values()) {
                advocateMapping.put(fileName, 0);
            }
        }
    }

    public void resetAdvocateContributions() {
        if (this.advocateContribution == null) {
            this.advocateContribution = new HashMap();
        } else {
            this.advocateContribution.clear();
        }
        if (this.advocateUniqueContribution == null) {
            this.advocateUniqueContribution = new HashMap();
        } else {
            this.advocateUniqueContribution.clear();
        }
        if (this.fileIdRate == null) {
            this.fileIdRate = new HashMap();
        } else {
            this.fileIdRate.clear();
        }
        if (this.peptideShakerUniqueContribution == null) {
            this.peptideShakerUniqueContribution = new HashMap();
        } else {
            this.peptideShakerUniqueContribution.clear();
        }
    }

    public synchronized void addAdvocateContribution(int advocateId, String fileName, boolean unique) {
        Integer contribution;
        HashMap<String, Integer> advocateContributions = this.advocateContribution.get(advocateId);
        if (advocateContributions == null) {
            advocateContributions = new HashMap();
            this.advocateContribution.put(advocateId, advocateContributions);
        }
        if ((contribution = advocateContributions.get(fileName)) == null) {
            advocateContributions.put(fileName, 1);
        } else {
            advocateContributions.put(fileName, contribution + 1);
        }
        if (unique) {
            Integer uniqueContribution;
            HashMap<String, Integer> advocateUniqueContributions = this.advocateUniqueContribution.get(advocateId);
            if (advocateUniqueContributions == null) {
                advocateUniqueContributions = new HashMap();
                this.advocateUniqueContribution.put(advocateId, advocateUniqueContributions);
            }
            if ((uniqueContribution = advocateUniqueContributions.get(fileName)) == null) {
                advocateUniqueContributions.put(fileName, 1);
            } else {
                advocateUniqueContributions.put(fileName, uniqueContribution + 1);
            }
        }
    }

    public synchronized void addPeptideShakerHit(String fileName, boolean unique) {
        Integer contribution = this.fileIdRate.get(fileName);
        if (contribution == null) {
            this.fileIdRate.put(fileName, 1);
        } else {
            this.fileIdRate.put(fileName, contribution + 1);
        }
        if (unique) {
            contribution = this.peptideShakerUniqueContribution.get(fileName);
            if (contribution == null) {
                this.peptideShakerUniqueContribution.put(fileName, 1);
            } else {
                this.peptideShakerUniqueContribution.put(fileName, contribution + 1);
            }
        }
    }

    public int getAdvocateContribution(int advocateId, String fileName) {
        Integer contribution;
        HashMap<String, Integer> advocateContributions = this.advocateContribution.get(advocateId);
        if (advocateContributions != null && (contribution = advocateContributions.get(fileName)) != null) {
            return contribution;
        }
        return 0;
    }

    public int getPeptideShakerHits(String fileName) {
        Integer contribution = this.fileIdRate.get(fileName);
        if (contribution != null) {
            return contribution;
        }
        return 0;
    }

    public int getAdvocateContribution(int advocateId) {
        HashMap<String, Integer> advocateContributions = this.advocateContribution.get(advocateId);
        if (advocateContributions != null) {
            int contribution = 0;
            for (int tempContribution : advocateContributions.values()) {
                contribution += tempContribution;
            }
            return contribution;
        }
        return 0;
    }

    public int getPeptideShakerHits() {
        int contribution = 0;
        for (int tempContribution : this.fileIdRate.values()) {
            contribution += tempContribution;
        }
        return contribution;
    }

    public int getAdvocateUniqueContribution(int advocateId, String fileName) {
        Integer contribution;
        HashMap<String, Integer> advocateContributions = this.advocateUniqueContribution.get(advocateId);
        if (advocateContributions != null && (contribution = advocateContributions.get(fileName)) != null) {
            return contribution;
        }
        return 0;
    }

    public int getPeptideShakerUniqueContribution(String fileName) {
        Integer contribution = this.peptideShakerUniqueContribution.get(fileName);
        if (contribution != null) {
            return contribution;
        }
        return 0;
    }

    public int getAdvocateUniqueContribution(int advocateId) {
        HashMap<String, Integer> advocateContributions = this.advocateUniqueContribution.get(advocateId);
        return advocateContributions == null ? 0 : advocateContributions.values().stream().mapToInt(a -> a).sum();
    }

    public int getPeptideShakerUniqueContribution() {
        return this.peptideShakerUniqueContribution.values().stream().mapToInt(a -> a).sum();
    }

    public ArrayList<TargetDecoyMap> getTargetDecoyMaps() {
        return this.inputSpecificMap.values().stream().flatMap(advocateMapping -> advocateMapping.values().stream()).collect(Collectors.toCollection(ArrayList::new));
    }

    public boolean hasAdvocateContribution() {
        return this.advocateContribution != null;
    }

    public void setIntermediateScore(String fileName, int advocateIndex, int scoreIndex, double score, boolean decoy, PsmScoringParameters psmScoringPreferences) {
        TargetDecoyMap targetDecoyMap;
        HashMap<Integer, TargetDecoyMap> scoreMap;
        HashMap<Integer, HashMap<Integer, TargetDecoyMap>> advocateMap = this.intermediateScores.get(fileName);
        if (advocateMap == null) {
            advocateMap = this.createIntermediateScoreMap(fileName);
        }
        if ((scoreMap = advocateMap.get(advocateIndex)) == null) {
            scoreMap = this.createIntermediateScoreMap(advocateIndex, advocateMap);
        }
        if ((targetDecoyMap = scoreMap.get(scoreIndex)) == null) {
            targetDecoyMap = this.createTargetDecoyMap(scoreIndex, scoreMap, psmScoringPreferences);
        }
        targetDecoyMap.put(score, decoy);
    }

    private synchronized HashMap<Integer, HashMap<Integer, TargetDecoyMap>> createIntermediateScoreMap(String fileName) {
        HashMap<Integer, HashMap<Integer, TargetDecoyMap>> advocateMap = this.intermediateScores.get(fileName);
        if (advocateMap == null) {
            advocateMap = new HashMap();
            this.intermediateScores.put(fileName, advocateMap);
        }
        return advocateMap;
    }

    private synchronized HashMap<Integer, TargetDecoyMap> createIntermediateScoreMap(int advocateIndex, HashMap<Integer, HashMap<Integer, TargetDecoyMap>> advocateMap) {
        HashMap<Integer, TargetDecoyMap> scoreMap = advocateMap.get(advocateIndex);
        if (scoreMap == null) {
            scoreMap = new HashMap();
            advocateMap.put(advocateIndex, scoreMap);
        }
        return scoreMap;
    }

    private synchronized TargetDecoyMap createTargetDecoyMap(int scoreIndex, HashMap<Integer, TargetDecoyMap> scoreMap, PsmScoringParameters psmScoringPreferences) {
        TargetDecoyMap targetDecoyMap = scoreMap.get(scoreIndex);
        if (targetDecoyMap == null) {
            targetDecoyMap = new TargetDecoyMap(psmScoringPreferences.getDecoysInFirstBin());
            scoreMap.put(scoreIndex, targetDecoyMap);
        }
        return targetDecoyMap;
    }

    public TargetDecoyMap getIntermediateScoreMap(String fileName, int advocateIndex, int scoreIndex) {
        HashMap<Integer, TargetDecoyMap> scoreMap;
        HashMap<Integer, HashMap<Integer, TargetDecoyMap>> advocateMap = this.intermediateScores.get(fileName);
        if (advocateMap != null && (scoreMap = advocateMap.get(advocateIndex)) != null) {
            TargetDecoyMap targetDecoyMap = scoreMap.get(scoreIndex);
            return targetDecoyMap;
        }
        return null;
    }
}

