/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.scoring.psm_scoring;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.SpectrumMatchesIterator;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.psm_scoring.PsmScore;
import com.compomics.util.experiment.identification.psm_scoring.PsmScoresEstimator;
import com.compomics.util.experiment.identification.psm_scoring.psm_scores.HyperScore;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.math.HistogramUtils;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.PsmScoringParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.tools.ProcessingParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.scoring.maps.InputMap;
import eu.isas.peptideshaker.scoring.targetdecoy.TargetDecoyMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.math.util.FastMath;

public class PsmScorer {
    private final SequenceProvider sequenceProvider;
    private final SpectrumProvider spectrumProvider;
    private final FastaParameters fastaParameters;
    private final PsmScoresEstimator psmScoresEstimator = new PsmScoresEstimator();

    public PsmScorer(FastaParameters fastaParameters, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider) {
        this.sequenceProvider = sequenceProvider;
        this.fastaParameters = fastaParameters;
        this.spectrumProvider = spectrumProvider;
    }

    public void estimateIntermediateScores(Identification identification, InputMap inputMap, ProcessingParameters processingParameters, IdentificationParameters identificationParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) throws InterruptedException, TimeoutException {
        AnnotationParameters annotationSettings = identificationParameters.getAnnotationParameters();
        double intensityThreshold = annotationSettings.getAnnotationIntensityLimit();
        annotationSettings.setIntensityLimit(0.0);
        waitingHandler.setWaitingText("Scoring PSMs. Please Wait...");
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        waitingHandler.setMaxSecondaryProgressCounter(identification.getSpectrumIdentificationSize());
        ExecutorService pool = Executors.newFixedThreadPool(processingParameters.getnThreads());
        SpectrumMatchesIterator psmIterator = identification.getSpectrumMatchesIterator(null);
        ArrayList<PsmScorerRunnable> psmScorerRunnables = new ArrayList<PsmScorerRunnable>(processingParameters.getnThreads());
        for (int i = 1; i <= processingParameters.getnThreads() && !waitingHandler.isRunCanceled(); ++i) {
            PsmScorerRunnable runnable = new PsmScorerRunnable(psmIterator, identification, inputMap, identificationParameters, waitingHandler, exceptionHandler);
            psmScorerRunnables.add(runnable);
            pool.submit(runnable);
        }
        if (waitingHandler.isRunCanceled()) {
            pool.shutdownNow();
            return;
        }
        pool.shutdown();
        if (!pool.awaitTermination(identification.getSpectrumIdentificationSize(), TimeUnit.MINUTES)) {
            throw new TimeoutException("PSM scoring timed out. Please contact the developers.");
        }
        ArrayList<HashMap<Double, Integer>> aHistograms = new ArrayList<HashMap<Double, Integer>>(processingParameters.getnThreads());
        ArrayList<HashMap<Double, Integer>> bHistograms = new ArrayList<HashMap<Double, Integer>>(processingParameters.getnThreads());
        HashMap<Long, ArrayList<Integer>> missingValuesMap = new HashMap<Long, ArrayList<Integer>>();
        for (PsmScorerRunnable runnable : psmScorerRunnables) {
            HashMap<Long, ArrayList<Integer>> currentMissingValuesMap = runnable.getMissingEValues();
            missingValuesMap.putAll(currentMissingValuesMap);
            HyperScore hyperScore = runnable.getHyperScore();
            aHistograms.add(hyperScore.getAs());
            bHistograms.add(hyperScore.getBs());
        }
        if (!missingValuesMap.isEmpty()) {
            HashMap<Double, Integer> aHistogram = HistogramUtils.mergeHistograms(aHistograms);
            HashMap<Double, Integer> bHistogram = HistogramUtils.mergeHistograms(bHistograms);
            double defaultA = aHistogram.isEmpty() ? Double.NaN : HistogramUtils.getMedianValue(aHistogram);
            double defaultB = bHistogram.isEmpty() ? Double.NaN : HistogramUtils.getMedianValue(bHistogram);
            long[] spectrumKeys = missingValuesMap.keySet().stream().mapToLong(Long::longValue).toArray();
            psmIterator = identification.getSpectrumMatchesIterator(spectrumKeys, null);
            pool = Executors.newFixedThreadPool(processingParameters.getnThreads());
            for (int i = 1; i <= processingParameters.getnThreads() && !waitingHandler.isRunCanceled(); ++i) {
                MissingEValueEstimatorRunnable runnable = new MissingEValueEstimatorRunnable(missingValuesMap, defaultA, defaultB, psmIterator, inputMap, identificationParameters, waitingHandler, exceptionHandler);
                pool.submit(runnable);
            }
            if (waitingHandler.isRunCanceled()) {
                pool.shutdownNow();
                return;
            }
            pool.shutdown();
            if (!pool.awaitTermination(identification.getSpectrumIdentificationSize(), TimeUnit.MINUTES)) {
                throw new TimeoutException("PSM scoring timed out. Please contact the developers.");
            }
        }
        waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        annotationSettings.setIntensityLimit(intensityThreshold);
    }

    public ArrayList<Integer> estimateIntermediateScores(Identification identification, SpectrumMatch spectrumMatch, InputMap inputMap, IdentificationParameters identificationParameters, PeptideSpectrumAnnotator peptideSpectrumAnnotator, HyperScore hyperScore, WaitingHandler waitingHandler) {
        AnnotationParameters annotationPreferences = identificationParameters.getAnnotationParameters();
        PsmScoringParameters psmScoringPreferences = identificationParameters.getPsmScoringParameters();
        String spectrumFile = spectrumMatch.getSpectrumFile();
        String spectrumTitle = spectrumMatch.getSpectrumTitle();
        HashMap<Integer, TreeMap<Double, ArrayList<PeptideAssumption>>> assumptions = spectrumMatch.getPeptideAssumptionsMap();
        ArrayList<Integer> missingEvalue = new ArrayList<Integer>(0);
        for (Map.Entry<Integer, TreeMap<Double, ArrayList<PeptideAssumption>>> entry1 : assumptions.entrySet()) {
            int advocateIndex = entry1.getKey();
            if (!psmScoringPreferences.isScoringNeeded(advocateIndex)) continue;
            HashSet<Integer> scoresForAdvocate = psmScoringPreferences.getScoreForAlgorithm(advocateIndex);
            TreeMap<Double, ArrayList<PeptideAssumption>> algorthmAssumptions = entry1.getValue();
            ArrayList<Double> hyperScores = null;
            ArrayList<PSParameter> hyperScoreParameters = null;
            ArrayList<Boolean> hyperScoreDecoys = null;
            if (scoresForAdvocate.contains(PsmScore.hyperScore.index)) {
                hyperScores = new ArrayList<Double>(algorthmAssumptions.size());
                hyperScoreParameters = new ArrayList<PSParameter>(algorthmAssumptions.size());
                hyperScoreDecoys = new ArrayList<Boolean>(algorthmAssumptions.size());
            }
            for (Map.Entry<Double, ArrayList<PeptideAssumption>> entry2 : algorthmAssumptions.entrySet()) {
                for (PeptideAssumption peptideAssumption : entry2.getValue()) {
                    PSParameter assumptionParameter = new PSParameter();
                    Peptide peptide = peptideAssumption.getPeptide();
                    boolean decoy = PeptideUtils.isDecoy(peptide, this.sequenceProvider);
                    Spectrum spectrum = this.spectrumProvider.getSpectrum(spectrumFile, spectrumTitle);
                    for (Integer scoreIndex : scoresForAdvocate) {
                        double score;
                        if (scoreIndex.equals(PsmScore.native_score.index)) {
                            score = peptideAssumption.getScore();
                        } else {
                            ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
                            SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
                            SpecificAnnotationParameters specificAnnotationPreferences = annotationPreferences.getSpecificAnnotationParameters(spectrumFile, spectrumTitle, peptideAssumption, modificationParameters, this.sequenceProvider, modificationSequenceMatchingParameters, peptideSpectrumAnnotator);
                            score = this.psmScoresEstimator.getDecreasingScore(peptide, peptideAssumption.getIdentificationCharge(), spectrumFile, spectrumTitle, spectrum, identificationParameters, specificAnnotationPreferences, modificationParameters, this.sequenceProvider, modificationSequenceMatchingParameters, peptideSpectrumAnnotator, scoreIndex);
                        }
                        assumptionParameter.setIntermediateScore(scoreIndex, score);
                        if (scoreIndex.equals(PsmScore.hyperScore.index)) {
                            hyperScores.add(-score);
                            hyperScoreParameters.add(assumptionParameter);
                            hyperScoreDecoys.add(decoy);
                            continue;
                        }
                        inputMap.setIntermediateScore(spectrumFile, advocateIndex, scoreIndex, score, decoy, psmScoringPreferences);
                    }
                    peptideAssumption.addUrParam(assumptionParameter);
                }
            }
            if (!scoresForAdvocate.contains(PsmScore.hyperScore.index)) continue;
            HashMap<Double, Double> eValuesMap = hyperScore.getEValueMap(hyperScores);
            if (eValuesMap != null) {
                for (int i = 0; i < hyperScores.size(); ++i) {
                    double score = hyperScores.get(i);
                    PSParameter psParameter = (PSParameter)hyperScoreParameters.get(i);
                    boolean decoy = (Boolean)hyperScoreDecoys.get(i);
                    double eValue = eValuesMap.get(score);
                    psParameter.setIntermediateScore(PsmScore.hyperScore.index, eValue);
                    inputMap.setIntermediateScore(spectrumFile, advocateIndex, PsmScore.hyperScore.index, score, decoy, psmScoringPreferences);
                }
                continue;
            }
            missingEvalue.add(advocateIndex);
        }
        identification.updateObject(spectrumMatch.getKey(), spectrumMatch);
        return missingEvalue;
    }

    public void estimateIntermediateScoreProbabilities(Identification identification, InputMap inputMap, ProcessingParameters processingPreferences, WaitingHandler waitingHandler) {
        TargetDecoyMap targetDecoyMap;
        int scoreIndex;
        Iterator iterator;
        ArrayList scores;
        int totalProgress = 0;
        for (String spectrumFileName : identification.getSpectrumIdentification().keySet()) {
            for (int advocateIndex : inputMap.getIntermediateScoreInputAlgorithms(spectrumFileName)) {
                scores = new ArrayList(0);
                if (scores.size() <= 1) continue;
                iterator = scores.iterator();
                while (iterator.hasNext()) {
                    scoreIndex = (Integer)iterator.next();
                    targetDecoyMap = inputMap.getIntermediateScoreMap(spectrumFileName, advocateIndex, scoreIndex);
                    totalProgress += targetDecoyMap.getMapSize();
                }
            }
        }
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        waitingHandler.resetSecondaryProgressCounter();
        waitingHandler.setMaxSecondaryProgressCounter(totalProgress);
        for (String spectrumFileName : identification.getSpectrumIdentification().keySet()) {
            for (int advocateIndex : inputMap.getIntermediateScoreInputAlgorithms(spectrumFileName)) {
                scores = new ArrayList(0);
                if (scores.size() <= 1) continue;
                iterator = scores.iterator();
                while (iterator.hasNext()) {
                    scoreIndex = (Integer)iterator.next();
                    targetDecoyMap = inputMap.getIntermediateScoreMap(spectrumFileName, advocateIndex, scoreIndex);
                    targetDecoyMap.estimateProbabilities(waitingHandler);
                    if (!waitingHandler.isRunCanceled()) continue;
                    return;
                }
            }
        }
    }

    public void scorePsms(Identification identification, InputMap inputMap, ProcessingParameters processingPreferences, IdentificationParameters identificationParameters, WaitingHandler waitingHandler) {
        SpectrumMatch spectrumMatch;
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        waitingHandler.setMaxSecondaryProgressCounter(identification.getSpectrumIdentificationSize());
        PsmScoringParameters psmScoringPreferences = identificationParameters.getPsmScoringParameters();
        PSParameter psParameter = new PSParameter();
        SpectrumMatchesIterator psmIterator = identification.getSpectrumMatchesIterator(waitingHandler);
        while ((spectrumMatch = psmIterator.next()) != null) {
            String spectrumFile = spectrumMatch.getSpectrumFile();
            HashMap<Integer, TreeMap<Double, ArrayList<PeptideAssumption>>> assumptions = spectrumMatch.getPeptideAssumptionsMap();
            for (Map.Entry<Integer, TreeMap<Double, ArrayList<PeptideAssumption>>> entry1 : assumptions.entrySet()) {
                HashSet<Integer> scoresForAdvocate;
                int advocateIndex = entry1.getKey();
                if (!psmScoringPreferences.isScoringNeeded(advocateIndex) || (scoresForAdvocate = psmScoringPreferences.getScoreForAlgorithm(advocateIndex)).isEmpty()) continue;
                TreeMap<Double, ArrayList<PeptideAssumption>> advocateAssumptions = entry1.getValue();
                for (double eValue : advocateAssumptions.keySet()) {
                    for (SpectrumIdentificationAssumption spectrumIdentificationAssumption : advocateAssumptions.get(eValue)) {
                        if (!(spectrumIdentificationAssumption instanceof PeptideAssumption)) continue;
                        psParameter = (PSParameter)spectrumIdentificationAssumption.getUrParam(psParameter);
                        double score = 1.0;
                        if (scoresForAdvocate.size() == 1 || !this.fastaParameters.isTargetDecoy()) {
                            score = psParameter.getIntermediateScore(scoresForAdvocate.iterator().next());
                        } else {
                            for (int scoreIndex : scoresForAdvocate) {
                                TargetDecoyMap targetDecoyMap = inputMap.getIntermediateScoreMap(spectrumFile, advocateIndex, scoreIndex);
                                Double intermediateScore = psParameter.getIntermediateScore(scoreIndex);
                                if (intermediateScore == null) continue;
                                double p = targetDecoyMap.getProbability(intermediateScore);
                                score *= 1.0 - p;
                            }
                            score = 1.0 - score;
                        }
                        spectrumIdentificationAssumption.setScore(score);
                        PeptideAssumption peptideAssumption = (PeptideAssumption)spectrumIdentificationAssumption;
                        Peptide peptide = peptideAssumption.getPeptide();
                        boolean decoy = PeptideUtils.isDecoy(peptide, this.sequenceProvider);
                        inputMap.addEntry(advocateIndex, spectrumFile, spectrumIdentificationAssumption.getScore(), decoy);
                    }
                }
            }
            if (waitingHandler.isRunCanceled()) {
                return;
            }
            waitingHandler.increaseSecondaryProgressCounter();
            identification.updateObject(spectrumMatch.getKey(), spectrumMatch);
        }
        waitingHandler.setSecondaryProgressCounterIndeterminate(true);
    }

    private class PsmScorerRunnable
    implements Runnable {
        private final SpectrumMatchesIterator psmIterator;
        private final Identification identification;
        private final InputMap inputMap;
        private final IdentificationParameters identificationParameters;
        private final WaitingHandler waitingHandler;
        private final ExceptionHandler exceptionHandler;
        private final PeptideSpectrumAnnotator peptideSpectrumAnnotator = new PeptideSpectrumAnnotator();
        private final HyperScore hyperScore = new HyperScore();
        private final HashMap<Long, ArrayList<Integer>> missingEValues = new HashMap();

        public PsmScorerRunnable(SpectrumMatchesIterator psmIterator, Identification identification, InputMap inputMap, IdentificationParameters identificationParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) {
            this.psmIterator = psmIterator;
            this.identification = identification;
            this.inputMap = inputMap;
            this.identificationParameters = identificationParameters;
            this.waitingHandler = waitingHandler;
            this.exceptionHandler = exceptionHandler;
        }

        @Override
        public void run() {
            try {
                SpectrumMatch spectrumMatch;
                boolean increaseProgress = true;
                while ((spectrumMatch = this.psmIterator.next()) != null && !this.waitingHandler.isRunCanceled()) {
                    ArrayList<Integer> advocatesMissingEValues = PsmScorer.this.estimateIntermediateScores(this.identification, spectrumMatch, this.inputMap, this.identificationParameters, this.peptideSpectrumAnnotator, this.hyperScore, this.waitingHandler);
                    if (!advocatesMissingEValues.isEmpty()) {
                        this.missingEValues.put(spectrumMatch.getKey(), advocatesMissingEValues);
                        increaseProgress = !increaseProgress;
                    } else {
                        increaseProgress = true;
                    }
                    if (!increaseProgress || this.waitingHandler == null || this.waitingHandler.isRunCanceled()) continue;
                    this.waitingHandler.increaseSecondaryProgressCounter();
                }
            }
            catch (Exception e) {
                this.exceptionHandler.catchException(e);
                this.waitingHandler.setRunCanceled();
            }
        }

        public HyperScore getHyperScore() {
            return this.hyperScore;
        }

        public HashMap<Long, ArrayList<Integer>> getMissingEValues() {
            return this.missingEValues;
        }
    }

    private class MissingEValueEstimatorRunnable
    implements Runnable {
        private final SpectrumMatchesIterator psmIterator;
        private final InputMap inputMap;
        private final IdentificationParameters identificationParameters;
        private final WaitingHandler waitingHandler;
        private final ExceptionHandler exceptionHandler;
        private final HashMap<Long, ArrayList<Integer>> missingEValues;
        private final double defaultA;
        private final double defaultB;

        public MissingEValueEstimatorRunnable(HashMap<Long, ArrayList<Integer>> missingEValuesMap, double defaultA, double defaultB, SpectrumMatchesIterator psmIterator, InputMap inputMap, IdentificationParameters identificationParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) {
            this.missingEValues = missingEValuesMap;
            this.defaultA = defaultA;
            this.defaultB = defaultB;
            this.psmIterator = psmIterator;
            this.inputMap = inputMap;
            this.identificationParameters = identificationParameters;
            this.waitingHandler = waitingHandler;
            this.exceptionHandler = exceptionHandler;
        }

        @Override
        public void run() {
            try {
                SpectrumMatch spectrumMatch;
                boolean increaseProgress = true;
                PsmScoringParameters psmScoringPreferences = this.identificationParameters.getPsmScoringParameters();
                while ((spectrumMatch = this.psmIterator.next()) != null && !this.waitingHandler.isRunCanceled()) {
                    ArrayList<Integer> advocates = this.missingEValues.get(spectrumMatch.getKey());
                    if (advocates == null) continue;
                    String spectrumFile = spectrumMatch.getSpectrumFile();
                    String spectrumTitle = spectrumMatch.getSpectrumTitle();
                    HashMap<Integer, TreeMap<Double, ArrayList<PeptideAssumption>>> assumptions = spectrumMatch.getPeptideAssumptionsMap();
                    for (Map.Entry<Integer, TreeMap<Double, ArrayList<PeptideAssumption>>> entry : assumptions.entrySet()) {
                        int advocateIndex = entry.getKey();
                        if (!psmScoringPreferences.isScoringNeeded(advocateIndex)) continue;
                        TreeMap<Double, ArrayList<PeptideAssumption>> originalAssumptions = entry.getValue();
                        long nMatches = originalAssumptions.values().stream().flatMap(Collection::stream).count();
                        for (Map.Entry<Double, ArrayList<PeptideAssumption>> entry2 : originalAssumptions.entrySet()) {
                            for (PeptideAssumption peptideAssumption : entry2.getValue()) {
                                Peptide peptide = peptideAssumption.getPeptide();
                                boolean decoy = PeptideUtils.isDecoy(peptide, PsmScorer.this.sequenceProvider);
                                PSParameter psParameter = (PSParameter)peptideAssumption.getUrParam(PSParameter.dummy);
                                double hyperScore = -psParameter.getIntermediateScore(PsmScore.hyperScore.index).doubleValue();
                                if (!Double.isNaN(this.defaultA) && !Double.isNaN(this.defaultB)) {
                                    double eValue;
                                    if (hyperScore > 0.0) {
                                        hyperScore = FastMath.log10((double)hyperScore);
                                        eValue = HyperScore.getInterpolation(hyperScore, this.defaultA, this.defaultB);
                                    } else {
                                        eValue = nMatches;
                                    }
                                    psParameter.setIntermediateScore(PsmScore.hyperScore.index, eValue);
                                    this.inputMap.setIntermediateScore(spectrumFile, advocateIndex, PsmScore.hyperScore.index, eValue, decoy, psmScoringPreferences);
                                    continue;
                                }
                                this.inputMap.setIntermediateScore(spectrumFile, advocateIndex, PsmScore.hyperScore.index, -hyperScore, decoy, psmScoringPreferences);
                            }
                        }
                    }
                    if (!(increaseProgress = !increaseProgress) || this.waitingHandler == null || this.waitingHandler.isRunCanceled()) continue;
                    this.waitingHandler.increaseSecondaryProgressCounter();
                }
            }
            catch (Exception e) {
                this.exceptionHandler.catchException(e);
                this.waitingHandler.setRunCanceled();
            }
        }
    }
}

