/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.scoring.psm_scoring;

import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.PeptideVariantMatches;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class TieBreaker {
    private final HashMap<String, Integer> proteinCount;
    private final SearchParameters searchParameters;
    private final AnnotationParameters annotationParameters;
    private final ModificationParameters modificationParameters;
    private final SequenceMatchingParameters sequenceMatchingParameters;
    private final SequenceMatchingParameters modificationSequenceMatchingParameters;
    private final SequenceProvider sequenceProvider;
    private final SpectrumProvider spectrumProvider;
    private final PeptideSpectrumAnnotator peptideSpectrumAnnotator;

    public TieBreaker(HashMap<String, Integer> proteinCount, IdentificationParameters identificationParameters, PeptideSpectrumAnnotator peptideSpectrumAnnotator, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider) {
        this.proteinCount = proteinCount;
        this.annotationParameters = identificationParameters.getAnnotationParameters();
        this.searchParameters = identificationParameters.getSearchParameters();
        this.modificationParameters = this.searchParameters.getModificationParameters();
        this.sequenceMatchingParameters = identificationParameters.getSequenceMatchingParameters();
        this.modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
        this.peptideSpectrumAnnotator = peptideSpectrumAnnotator;
        this.sequenceProvider = sequenceProvider;
        this.spectrumProvider = spectrumProvider;
    }

    public PeptideAssumption getBestPeptideAssumption(String spectrumFile, String spectrumTitle, PeptideAssumption peptideAssumption1, PeptideAssumption peptideAssumption2, boolean silentFail) {
        double annotatedIntensity2;
        double massError2;
        int nCoveredAminoAcids2;
        int proteinMaxOccurrence2;
        int modCount2;
        int variantCount2;
        long matchingKey2;
        long matchingKey1 = peptideAssumption1.getPeptide().getMatchingKey(this.sequenceMatchingParameters);
        if (matchingKey1 == (matchingKey2 = peptideAssumption2.getPeptide().getMatchingKey(this.sequenceMatchingParameters))) {
            if (silentFail) {
                return peptideAssumption1;
            }
            throw new IllegalArgumentException("Tie during best match selection in spectrum " + spectrumTitle + " of file " + spectrumFile + "(" + peptideAssumption1.getPeptide().getSequence() + ") provided twice.");
        }
        int variantCount1 = this.variantsCount(peptideAssumption1);
        if (variantCount1 < (variantCount2 = this.variantsCount(peptideAssumption2))) {
            return peptideAssumption1;
        }
        if (variantCount1 > variantCount2) {
            return peptideAssumption2;
        }
        int modCount1 = peptideAssumption1.getPeptide().getNVariableModifications();
        if (modCount1 < (modCount2 = peptideAssumption2.getPeptide().getNVariableModifications())) {
            return peptideAssumption1;
        }
        if (modCount1 > modCount2) {
            return peptideAssumption2;
        }
        int proteinMaxOccurrence1 = this.proteinCount(peptideAssumption1);
        if (proteinMaxOccurrence1 > (proteinMaxOccurrence2 = this.proteinCount(peptideAssumption2))) {
            return peptideAssumption1;
        }
        if (proteinMaxOccurrence1 < proteinMaxOccurrence2) {
            return peptideAssumption2;
        }
        Spectrum spectrum = this.spectrumProvider.getSpectrum(spectrumFile, spectrumTitle);
        int nCoveredAminoAcids1 = this.nCoveredAminoAcids(spectrumFile, spectrumTitle, peptideAssumption1, spectrum, true);
        if (nCoveredAminoAcids1 > (nCoveredAminoAcids2 = this.nCoveredAminoAcids(spectrumFile, spectrumTitle, peptideAssumption2, spectrum, true))) {
            return peptideAssumption1;
        }
        if (nCoveredAminoAcids1 < nCoveredAminoAcids2) {
            return peptideAssumption2;
        }
        double massError1 = Math.abs(peptideAssumption1.getDeltaMz(spectrum.getPrecursor().mz, this.searchParameters.isPrecursorAccuracyTypePpm(), this.searchParameters.getMinIsotopicCorrection(), this.searchParameters.getMaxIsotopicCorrection()));
        if (massError1 < (massError2 = Math.abs(peptideAssumption2.getDeltaMz(spectrum.getPrecursor().mz, this.searchParameters.isPrecursorAccuracyTypePpm(), this.searchParameters.getMinIsotopicCorrection(), this.searchParameters.getMaxIsotopicCorrection())))) {
            return peptideAssumption1;
        }
        if (massError1 > massError2) {
            return peptideAssumption2;
        }
        nCoveredAminoAcids1 = this.nCoveredAminoAcids(spectrumFile, spectrumTitle, peptideAssumption1, spectrum, false);
        if (nCoveredAminoAcids1 > (nCoveredAminoAcids2 = this.nCoveredAminoAcids(spectrumFile, spectrumTitle, peptideAssumption2, spectrum, false))) {
            return peptideAssumption1;
        }
        if (nCoveredAminoAcids1 < nCoveredAminoAcids2) {
            return peptideAssumption2;
        }
        double annotatedIntensity1 = this.shareOfIntensityAnnotated(spectrumFile, spectrumTitle, peptideAssumption1, spectrum);
        if (annotatedIntensity1 > (annotatedIntensity2 = this.shareOfIntensityAnnotated(spectrumFile, spectrumTitle, peptideAssumption2, spectrum))) {
            return peptideAssumption1;
        }
        if (annotatedIntensity1 < annotatedIntensity2) {
            return peptideAssumption2;
        }
        return matchingKey1 < matchingKey2 ? peptideAssumption1 : peptideAssumption2;
    }

    private int variantsCount(PeptideAssumption peptideAssumption) {
        HashMap<String, HashMap<Integer, PeptideVariantMatches>> variantMatchesMap = peptideAssumption.getPeptide().getVariantMatches();
        return variantMatchesMap == null ? 0 : variantMatchesMap.values().stream().flatMap(variantMap -> variantMap.values().stream()).mapToInt(variantMatches -> variantMatches.getVariantMatches().size()).min().orElse(0);
    }

    private int proteinCount(PeptideAssumption peptideAssumption) {
        return peptideAssumption.getPeptide().getProteinMapping().navigableKeySet().stream().filter(accession -> this.proteinCount.containsKey(accession)).mapToInt(accession -> this.proteinCount.get(accession)).max().orElse(1);
    }

    private int nCoveredAminoAcids(String spectrumFile, String spectrumTitle, PeptideAssumption peptideAssumption, Spectrum spectrum, boolean intensityLimit) {
        SpecificAnnotationParameters specificAnnotationPreferences = this.annotationParameters.getSpecificAnnotationParameters(spectrumFile, spectrumTitle, peptideAssumption, this.modificationParameters, this.sequenceProvider, this.modificationSequenceMatchingParameters, this.peptideSpectrumAnnotator);
        Map<Integer, ArrayList<IonMatch>> coveredAminoAcids = this.peptideSpectrumAnnotator.getCoveredAminoAcids(this.annotationParameters, specificAnnotationPreferences, spectrumFile, spectrumTitle, spectrum, peptideAssumption.getPeptide(), this.modificationParameters, this.sequenceProvider, this.modificationSequenceMatchingParameters, intensityLimit);
        return coveredAminoAcids.size();
    }

    private double shareOfIntensityAnnotated(String spectrumFile, String spectrumTitle, PeptideAssumption peptideAssumption, Spectrum spectrum) {
        SpecificAnnotationParameters specificAnnotationPreferences = this.annotationParameters.getSpecificAnnotationParameters(spectrumFile, spectrumTitle, peptideAssumption, this.modificationParameters, this.sequenceProvider, this.modificationSequenceMatchingParameters, this.peptideSpectrumAnnotator);
        IonMatch[] ionMatches = this.peptideSpectrumAnnotator.getSpectrumAnnotation(this.annotationParameters, specificAnnotationPreferences, spectrumFile, spectrumTitle, spectrum, peptideAssumption.getPeptide(), this.modificationParameters, this.sequenceProvider, this.modificationSequenceMatchingParameters, false);
        double annotatedIntensity = Arrays.stream(ionMatches).collect(Collectors.toMap(ionMatch -> ionMatch.peakMz, ionMatch -> ionMatch.peakIntensity, (a, b) -> a, HashMap::new)).values().stream().mapToDouble(a -> a).sum();
        return annotatedIntensity / spectrum.getTotalIntensity();
    }
}

