/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.scoring.targetdecoy;

import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import eu.isas.peptideshaker.scoring.targetdecoy.TargetDecoyPoint;
import eu.isas.peptideshaker.scoring.targetdecoy.TargetDecoyResults;
import java.util.Arrays;
import java.util.HashMap;

public class TargetDecoySeries {
    private final double[] scores;
    private final double[] scoresLog;
    private final double[] confidence;
    private final double[] confidenceLog;
    private final double[] pep;
    private final double binSize = 5.0;
    private double[] tdBins;
    private double[] nTarget;
    private double[] nDecoy;
    private final double[] fdr;
    private final double[] fnr;
    private final double[] n;
    private final double[] fp;
    private final boolean[] decoy;
    private double probaNTotal;

    public TargetDecoySeries(HashMap<Double, TargetDecoyPoint> hitMap) {
        TargetDecoyPoint currentPoint;
        this.scores = new double[hitMap.size()];
        this.scoresLog = new double[this.scores.length];
        this.probaNTotal = 0.0;
        int counter = 0;
        double minScore = 0.0;
        double maxScore = 100.0;
        for (double score : hitMap.keySet()) {
            currentPoint = hitMap.get(score);
            double scoreLog = PSParameter.transformScore(score);
            this.scores[counter] = score;
            this.scoresLog[counter] = scoreLog;
            this.probaNTotal += (1.0 - currentPoint.p) * (double)currentPoint.nTarget;
            ++counter;
            if (scoreLog < minScore) {
                minScore = scoreLog;
            }
            if (!(scoreLog > maxScore)) continue;
            maxScore = scoreLog;
        }
        int histogramScoreMin = (int)minScore;
        int histogramScoreMax = (int)maxScore;
        this.initiateTDHistogram(histogramScoreMin, histogramScoreMax);
        Arrays.sort(this.scores);
        Arrays.sort(this.scoresLog);
        this.confidence = new double[this.scores.length];
        this.confidenceLog = new double[this.scores.length];
        this.fdr = new double[this.scores.length];
        this.fnr = new double[this.scores.length];
        this.n = new double[this.scores.length];
        this.fp = new double[this.scores.length];
        this.pep = new double[this.scores.length];
        this.decoy = new boolean[this.scores.length];
        double nTemp = 0.0;
        double fpTemp = 0.0;
        double probaTP = 0.0;
        for (int i = 0; i < this.scores.length; ++i) {
            int bin;
            double confidenceAtI;
            double score = this.scores[i];
            currentPoint = hitMap.get(score);
            nTemp += (double)currentPoint.nTarget;
            fpTemp += (double)currentPoint.nDecoy;
            double fnrTemp = 100.0 * (this.probaNTotal - (probaTP += (double)currentPoint.nTarget * (1.0 - currentPoint.p))) / this.probaNTotal;
            this.pep[i] = 100.0 * currentPoint.p;
            this.confidence[i] = confidenceAtI = 100.0 * (1.0 - currentPoint.p);
            int iInvert = this.scores.length - i - 1;
            this.confidenceLog[iInvert] = confidenceAtI;
            this.n[i] = nTemp;
            this.fp[i] = fpTemp;
            this.fdr[i] = 100.0 * fpTemp / nTemp;
            this.fnr[i] = fnrTemp;
            this.decoy[i] = currentPoint.nTarget == 0;
            double scoreLog = this.scoresLog[iInvert];
            int n = bin = (int)Math.round((scoreLog - (double)histogramScoreMin) / 5.0);
            this.nDecoy[n] = this.nDecoy[n] + (double)currentPoint.nDecoy;
            int n2 = bin;
            this.nTarget[n2] = this.nTarget[n2] + (double)currentPoint.nTarget;
        }
    }

    private void initiateTDHistogram(int histogramScoreMin, int histogramScoreMax) {
        int nBins = (int)Math.floor((double)histogramScoreMax / 5.0) - (int)Math.floor((double)histogramScoreMin / 5.0) + 1;
        this.tdBins = new double[nBins];
        this.nTarget = new double[nBins];
        this.nDecoy = new double[nBins];
        for (int i = 0; i < nBins; ++i) {
            this.tdBins[i] = (double)histogramScoreMin + (double)i * 5.0;
            this.nTarget[i] = 0.0;
            this.nDecoy[i] = 0.0;
        }
    }

    public void getFDRResults(TargetDecoyResults targetDecoyResults) {
        double threshold = targetDecoyResults.getFdrLimit();
        targetDecoyResults.setNoValidated(false);
        for (int i = this.scores.length - 1; i >= 0; --i) {
            if (this.fdr[i] <= threshold && !this.decoy[i]) {
                targetDecoyResults.setConfidenceLimit(this.confidence[i]);
                targetDecoyResults.setFdrLimit(this.fdr[i]);
                targetDecoyResults.setn(this.n[i]);
                targetDecoyResults.setnFP(this.fp[i]);
                targetDecoyResults.setFnrLimit(this.fnr[i]);
                targetDecoyResults.setnTPTotal(this.probaNTotal);
                targetDecoyResults.setScoreLimit(this.scores[i]);
                return;
            }
            if (i != 0) continue;
            targetDecoyResults.setNoValidated(true);
            targetDecoyResults.setFdrLimit(0.0);
            targetDecoyResults.setnFP(0.0);
            targetDecoyResults.setConfidenceLimit(0.0);
            targetDecoyResults.setn(0.0);
            targetDecoyResults.setFnrLimit(this.fnr[0]);
            targetDecoyResults.setnTPTotal(this.probaNTotal);
            targetDecoyResults.setScoreLimit(this.scores[0]);
        }
    }

    public void getConfidenceResults(TargetDecoyResults targetDecoyResults) {
        double threshold = targetDecoyResults.getConfidenceLimit();
        for (int i = 0; i < this.scores.length - 1; ++i) {
            if (!(this.confidence[i] < threshold)) continue;
            for (int k = i; k >= 0; --k) {
                if (this.decoy[k]) continue;
                targetDecoyResults.setNoValidated(false);
                targetDecoyResults.setFdrLimit(this.fdr[k]);
                targetDecoyResults.setnFP(this.fp[k]);
                targetDecoyResults.setConfidenceLimit(this.confidence[k]);
                targetDecoyResults.setFnrLimit(this.fnr[k]);
                targetDecoyResults.setn(this.n[k]);
                targetDecoyResults.setnTPTotal(this.probaNTotal);
                targetDecoyResults.setScoreLimit(this.scores[k]);
                return;
            }
            targetDecoyResults.setNoValidated(true);
            targetDecoyResults.setFdrLimit(0.0);
            targetDecoyResults.setnFP(0.0);
            targetDecoyResults.setConfidenceLimit(this.confidence[0]);
            targetDecoyResults.setn(0.0);
            targetDecoyResults.setnTPTotal(this.probaNTotal);
            targetDecoyResults.setFnrLimit(this.probaNTotal);
            targetDecoyResults.setScoreLimit(this.scores[0]);
            return;
        }
    }

    public void getFNRResults(TargetDecoyResults targetDecoyResults) {
        double threshold = targetDecoyResults.getFnrLimit();
        targetDecoyResults.setNoValidated(false);
        for (int i = this.scores.length - 1; i >= 0; --i) {
            if (!(this.fnr[i] > threshold) && i != 0) continue;
            for (int k = i; k < this.scores.length; ++k) {
                if (this.decoy[k]) continue;
                targetDecoyResults.setConfidenceLimit(this.confidence[k]);
                targetDecoyResults.setFdrLimit(this.fdr[k]);
                targetDecoyResults.setnFP(this.fp[k]);
                targetDecoyResults.setn(this.n[k]);
                targetDecoyResults.setFnrLimit(this.fnr[k]);
                targetDecoyResults.setnTPTotal(this.probaNTotal);
                targetDecoyResults.setScoreLimit(this.scores[k]);
                return;
            }
            targetDecoyResults.setNoValidated(true);
            targetDecoyResults.setFdrLimit(0.0);
            targetDecoyResults.setnFP(0.0);
            targetDecoyResults.setConfidenceLimit(this.confidence[0]);
            targetDecoyResults.setn(0.0);
            targetDecoyResults.setnTPTotal(this.probaNTotal);
            targetDecoyResults.setFnrLimit(this.probaNTotal);
            targetDecoyResults.setScoreLimit(this.scores[0]);
        }
    }

    public double[] getTdBins() {
        return this.tdBins;
    }

    public double[] getnTarget() {
        return this.nTarget;
    }

    public double[] getnDecoy() {
        return this.nDecoy;
    }

    public double[] getFDR() {
        return this.fdr;
    }

    public double[] getConfidence() {
        return this.confidence;
    }

    public double[] getConfidenceLog() {
        return this.confidenceLog;
    }

    public double[] getBenefit() {
        return Arrays.stream(this.fnr).map(fnrValue -> 100.0 - fnrValue).toArray();
    }

    public double[] getFNR() {
        return this.fnr;
    }

    public double[] getScores() {
        return this.scores;
    }

    public double[] getScoresLog() {
        return this.scoresLog;
    }

    public double[] getPEP() {
        return this.pep;
    }
}

