/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.stirred.modules;

import com.compomics.software.log.CliLogger;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.io.identification.IdfileReader;
import com.compomics.util.experiment.io.identification.IdfileReaderFactory;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.io.IoUtil;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.util.ArrayList;

public class IdImporter {
    private final File searchEngineResultsFile;
    private final IdfileReader idFileReader;

    public IdImporter(File searchEngineResultsFile, CliLogger cliLogger) {
        this.searchEngineResultsFile = searchEngineResultsFile;
        IdfileReaderFactory readerFactory = IdfileReaderFactory.getInstance();
        try {
            this.idFileReader = readerFactory.getFileReader(searchEngineResultsFile);
        }
        catch (OutOfMemoryError error) {
            String errorMessage = "Ran out of memory when parsing '" + IoUtil.getFileName(searchEngineResultsFile) + "'.";
            cliLogger.logError(errorMessage);
            throw new OutOfMemoryError(errorMessage);
        }
        if (this.idFileReader == null) {
            String errorMessage = "Identification result file '" + IoUtil.getFileName(searchEngineResultsFile) + "' not recognized.";
            cliLogger.logError(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public ArrayList<SpectrumMatch> loadSpectrumMatches(IdentificationParameters identificationParameters, SpectrumProvider spectrumProvider, WaitingHandler waitingHandler) {
        try {
            ArrayList<SpectrumMatch> arrayList = this.idFileReader.getAllSpectrumMatches(spectrumProvider, waitingHandler, identificationParameters.getSearchParameters(), identificationParameters.getSequenceMatchingParameters(), true);
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException("An exception occurred when parsing " + this.searchEngineResultsFile + ".", e);
        }
        finally {
            try {
                this.idFileReader.close();
            }
            catch (Exception exception) {}
        }
    }

    public IdfileReader getIdFileReader() {
        return this.idFileReader;
    }
}

