/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.cpdetector.util;

import info.monitorenter.cpdetector.util.Entry;
import info.monitorenter.cpdetector.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.StringTokenizer;

public class FileUtil {
    public static void removeDuplicateLineBreaks(File f) {
        String sep = StringUtil.getNewLine();
        if (!f.exists()) {
            System.err.println("FileUtil.removeDuplicateLineBreak(File f): " + f.getAbsolutePath() + " does not exist!");
            return;
        }
        if (f.isDirectory()) {
            System.err.println("FileUtil.removeDuplicateLineBreak(File f): " + f.getAbsolutePath() + " is a directory!");
            return;
        }
        try {
            int tmpread;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f), 1024);
            StringBuffer result = new StringBuffer();
            while ((tmpread = in.read()) != -1) {
                result.append((char)tmpread);
            }
            StringTokenizer toke = new StringTokenizer(result.toString(), sep, true);
            result = new StringBuffer();
            int breaks = 0;
            while (toke.hasMoreTokens()) {
                String tmpstring = toke.nextToken().trim();
                if (tmpstring.equals("") && breaks > 0) {
                    ++breaks;
                    continue;
                }
                if (tmpstring.equals("")) {
                    tmpstring = sep;
                    ++breaks;
                } else {
                    breaks = 0;
                }
                result.append(tmpstring);
            }
            f.delete();
            f.createNewFile();
            FileWriter out = new FileWriter(f);
            out.write(result.toString());
            out.flush();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException g) {
            g.printStackTrace(System.err);
        }
    }

    public static String getDefaultFileName(String name) {
        File f = new File(name);
        if (!f.exists()) {
            return f.getAbsolutePath();
        }
        Map.Entry cut = FileUtil.cutExtension(name);
        String prefix = (String)cut.getKey();
        String suffix = (String)cut.getValue();
        int num = 0;
        while (f.exists()) {
            f = new File(prefix + '_' + num + '.' + suffix);
            ++num;
        }
        return f.getAbsolutePath();
    }

    public static Map.Entry cutExtension(String filename) {
        String prefix;
        String suffix = null;
        StringTokenizer tokenizer = new StringTokenizer(filename, ".");
        int tokenCount = tokenizer.countTokens();
        if (tokenCount > 1) {
            StringBuffer prefCollect = new StringBuffer();
            while (tokenCount > 1) {
                prefCollect.append(tokenizer.nextToken());
                if (--tokenCount <= 1) continue;
                prefCollect.append(".");
            }
            prefix = prefCollect.toString();
            suffix = tokenizer.nextToken();
        } else {
            prefix = filename;
            suffix = "";
        }
        return new Entry(prefix, suffix);
    }

    public static Map.Entry cutDirectoryInformation(String path) {
        StringBuffer dir = new StringBuffer();
        String file = "";
        String fileseparator = System.getProperty("file.separator");
        StringTokenizer tokenizer = new StringTokenizer(path, fileseparator);
        int size = tokenizer.countTokens();
        switch (size) {
            case 0: {
                dir.append(new File(".").getAbsolutePath());
                break;
            }
            case 1: {
                File test = new File(tokenizer.nextToken());
                if (new File(path).isDirectory()) {
                    dir.append(test.getAbsolutePath());
                    break;
                }
                dir.append(new File(".").getAbsolutePath());
                file = path;
                break;
            }
            default: {
                while (tokenizer.hasMoreElements()) {
                    String token = tokenizer.nextToken();
                    if (tokenizer.hasMoreTokens()) {
                        dir.append(token);
                        dir.append(fileseparator);
                        continue;
                    }
                    if (new File(path).isFile()) {
                        file = token;
                        continue;
                    }
                    dir.append(token);
                }
                break block0;
            }
        }
        return new Entry(dir.toString(), file);
    }

    public static Map.Entry cutDirectoryInformation(URL path) {
        String suf;
        String pre;
        Entry ret = null;
        StringBuffer tmp = new StringBuffer();
        String parse = path.toExternalForm();
        if (parse.endsWith("/")) {
            pre = parse;
            suf = "";
        } else {
            StringTokenizer tokenizer = new StringTokenizer(path.getFile(), "/");
            tmp.append(path.getProtocol());
            tmp.append(":");
            tmp.append(path.getHost());
            pre = "";
            while (tokenizer.hasMoreElements()) {
                tmp.append(pre);
                pre = tokenizer.nextToken();
                tmp.append("/");
            }
            suf = pre;
            pre = tmp.toString();
        }
        ret = new Entry(pre, suf);
        return ret;
    }

    public static byte[] readRAM(File f) throws IOException {
        return FileUtil.readRAM(new FileInputStream(f), (int)f.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readRAM(InputStream in, int length) throws IOException {
        byte[] ret = new byte[length];
        try {
            int offset = 0;
            int read = 0;
            do {
                if ((read = in.read(ret, offset, length - read)) <= 0) continue;
                offset += read;
            } while (read != -1 && offset != length);
            byte[] byArray = ret;
            return byArray;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readRAM(InputStream in) throws IOException {
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream collect = new ByteArrayOutputStream(512);
        try {
            int read = 0;
            do {
                if ((read = in.read(buffer)) <= 0) continue;
                collect.write(buffer, 0, read);
            } while (read != -1);
            byte[] byArray = collect.toByteArray();
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public static InputStream readCache(File f) throws IOException {
        return new ByteArrayInputStream(FileUtil.readRAM(f));
    }

    public static boolean isAllASCII(File f) throws IOException {
        return FileUtil.isAllASCII(new FileInputStream(f));
    }

    public static boolean isAllASCII(InputStream in) throws IOException {
        boolean ret = true;
        int read = -1;
        do {
            if ((read = in.read()) <= 127) continue;
            ret = false;
            break;
        } while (read != -1);
        return ret;
    }

    public static boolean isEqual(File document, Charset a, Charset b) throws IOException {
        boolean ret = true;
        InputStreamReader aReader = new InputStreamReader((InputStream)new FileInputStream(document), a);
        InputStreamReader bReader = new InputStreamReader((InputStream)new FileInputStream(document), b);
        int readA = -1;
        int readB = -1;
        do {
            if ((readA = aReader.read()) == (readB = bReader.read())) continue;
            ret = false;
            break;
        } while (readA != -1 && readB != -1);
        return ret;
    }
}

