/*
 * Decompiled with CFR 0.152.
 */
package com.obrador;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.image.PixelGrabber;

class JpegInfo {
    String Comment;
    public Image imageobj;
    public int imageHeight;
    public int imageWidth;
    public int[] BlockWidth;
    public int[] BlockHeight;
    public int Precision = 8;
    public int NumberOfComponents = 3;
    public Object[] Components;
    public int[] CompID = new int[]{1, 2, 3};
    public int[] HsampFactor = new int[]{1, 1, 1};
    public int[] VsampFactor = new int[]{1, 1, 1};
    public int[] QtableNumber = new int[]{0, 1, 1};
    public int[] DCtableNumber = new int[]{0, 1, 1};
    public int[] ACtableNumber = new int[]{0, 1, 1};
    public boolean[] lastColumnIsDummy = new boolean[]{false, false, false};
    public boolean[] lastRowIsDummy = new boolean[]{false, false, false};
    public int Ss = 0;
    public int Se = 63;
    public int Ah = 0;
    public int Al = 0;
    public int[] compWidth;
    public int[] compHeight;
    public int MaxHsampFactor;
    public int MaxVsampFactor;

    public JpegInfo(Image image) {
        this.Components = new Object[this.NumberOfComponents];
        this.compWidth = new int[this.NumberOfComponents];
        this.compHeight = new int[this.NumberOfComponents];
        this.BlockWidth = new int[this.NumberOfComponents];
        this.BlockHeight = new int[this.NumberOfComponents];
        this.imageobj = image;
        this.imageWidth = image.getWidth(null);
        this.imageHeight = image.getHeight(null);
        this.Comment = "JPEG Encoder Copyright 1998, James R. Weeks and BioElectroMech.  ";
        this.getYCCArray();
    }

    public void setComment(String string) {
        this.Comment.concat(string);
    }

    public String getComment() {
        return this.Comment;
    }

    private void getYCCArray() {
        int n;
        int[] nArray = new int[this.imageWidth * this.imageHeight];
        PixelGrabber pixelGrabber = new PixelGrabber(this.imageobj.getSource(), 0, 0, this.imageWidth, this.imageHeight, nArray, 0, this.imageWidth);
        this.MaxHsampFactor = 1;
        this.MaxVsampFactor = 1;
        for (n = 0; n < this.NumberOfComponents; ++n) {
            this.MaxHsampFactor = Math.max(this.MaxHsampFactor, this.HsampFactor[n]);
            this.MaxVsampFactor = Math.max(this.MaxVsampFactor, this.VsampFactor[n]);
        }
        for (n = 0; n < this.NumberOfComponents; ++n) {
            this.compWidth[n] = (this.imageWidth % 8 != 0 ? (int)Math.ceil((double)this.imageWidth / 8.0) * 8 : this.imageWidth) / this.MaxHsampFactor * this.HsampFactor[n];
            if (this.compWidth[n] != this.imageWidth / this.MaxHsampFactor * this.HsampFactor[n]) {
                this.lastColumnIsDummy[n] = true;
            }
            this.BlockWidth[n] = (int)Math.ceil((double)this.compWidth[n] / 8.0);
            this.compHeight[n] = (this.imageHeight % 8 != 0 ? (int)Math.ceil((double)this.imageHeight / 8.0) * 8 : this.imageHeight) / this.MaxVsampFactor * this.VsampFactor[n];
            if (this.compHeight[n] != this.imageHeight / this.MaxVsampFactor * this.VsampFactor[n]) {
                this.lastRowIsDummy[n] = true;
            }
            this.BlockHeight[n] = (int)Math.ceil((double)this.compHeight[n] / 8.0);
        }
        try {
            if (!pixelGrabber.grabPixels()) {
                try {
                    throw new AWTException("Grabber returned false: " + pixelGrabber.status());
                }
                catch (Exception exception) {}
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        float[][] fArray = new float[this.compHeight[0]][this.compWidth[0]];
        float[][] fArray2 = new float[this.compHeight[0]][this.compWidth[0]];
        float[][] fArray3 = new float[this.compHeight[0]][this.compWidth[0]];
        int n2 = 0;
        for (n = 0; n < this.imageHeight; ++n) {
            for (int i = 0; i < this.imageWidth; ++i) {
                int n3 = nArray[n2] >> 16 & 0xFF;
                int n4 = nArray[n2] >> 8 & 0xFF;
                int n5 = nArray[n2] & 0xFF;
                fArray[n][i] = (float)(0.299 * (double)n3 + 0.587 * (double)n4 + 0.114 * (double)n5);
                fArray3[n][i] = 128.0f + (float)(-0.16874 * (double)n3 - 0.33126 * (double)n4 + 0.5 * (double)n5);
                fArray2[n][i] = 128.0f + (float)(0.5 * (double)n3 - 0.41869 * (double)n4 - 0.08131 * (double)n5);
                ++n2;
            }
        }
        this.Components[0] = fArray;
        this.Components[1] = fArray3;
        this.Components[2] = fArray2;
    }

    float[][] DownSample(float[][] fArray, int n) {
        int n2 = 0;
        int n3 = 0;
        float[][] fArray2 = new float[this.compHeight[n]][this.compWidth[n]];
        for (int i = 0; i < this.compHeight[n]; ++i) {
            int n4 = 1;
            for (int j = 0; j < this.compWidth[n]; ++j) {
                fArray2[i][j] = (fArray[n2][n3++] + fArray[n2++][n3--] + fArray[n2][n3++] + fArray[n2--][n3++] + (float)n4) / 4.0f;
                n4 ^= 3;
            }
            n2 += 2;
            n3 = 0;
        }
        return fArray2;
    }
}

