/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines.renderers;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.data.JSparklines3dDataSeries;
import no.uib.jsparklines.data.JSparklines3dDataset;
import no.uib.jsparklines.renderers.util.ReferenceArea;
import no.uib.jsparklines.renderers.util.ReferenceLine;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;

public class JSparklines3dTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private PlotType plotType;
    private ChartPanel chartPanel;
    private JFreeChart chart;
    private double maxXValue;
    private double minXValue;
    private double maxYValue = 0.0;
    private double minYValue = 0.0;
    private HashMap<String, ReferenceLine> referenceLinesXAxis;
    private HashMap<String, ReferenceArea> referenceAreasXAxis;
    private HashMap<String, ReferenceLine> referenceLinesYAxis;
    private HashMap<String, ReferenceArea> referenceAreasYAxis;

    public JSparklines3dTableCellRenderer(PlotType plotType, Double minXValue, Double maxXValue, Double minYValue, Double maxYValue) {
        this.plotType = plotType;
        this.minXValue = minXValue;
        this.maxXValue = maxXValue;
        this.minYValue = minYValue;
        this.maxYValue = maxYValue;
        this.referenceLinesXAxis = new HashMap();
        this.referenceAreasXAxis = new HashMap();
        this.referenceLinesYAxis = new HashMap();
        this.referenceAreasYAxis = new HashMap();
        this.setName("Table.cellRenderer");
        this.setLayout(new BorderLayout());
        if (minXValue > maxXValue) {
            throw new IllegalArgumentException("minXValue has to be smaller than maxXValue! Current values: minXValue: " + minXValue + ", maxXValue: " + maxXValue + ".");
        }
        if (minYValue > maxYValue) {
            throw new IllegalArgumentException("minYValue has to be smaller than maxYValue! Current values: minYValue: " + minYValue + ", maxYValue: " + maxYValue + ".");
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setBorder(c.getBorder());
        this.setOpaque(c.isOpaque());
        this.setBackground(c.getBackground());
        if (value == null) {
            Color bg = c.getBackground();
            c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            return c;
        }
        if (value instanceof String) {
            Color bg = c.getBackground();
            c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            return c;
        }
        if (!(value instanceof JSparklines3dDataset)) {
            return c;
        }
        JSparklines3dDataset sparkline3dDataset = (JSparklines3dDataset)value;
        ArrayList<Color> colors = new ArrayList<Color>();
        String tooltip = "<html>";
        if (this.plotType == PlotType.scatterPlot || this.plotType == PlotType.bubblePlot) {
            IntervalMarker marker;
            DefaultXYDataset xyDataset = null;
            DefaultXYZDataset xyzDataset = null;
            if (this.plotType == PlotType.scatterPlot) {
                xyDataset = new DefaultXYDataset();
            } else {
                xyzDataset = new DefaultXYZDataset();
            }
            for (int i = 0; i < sparkline3dDataset.getData().size(); ++i) {
                JSparklines3dDataSeries sparkline3dDataSeries = sparkline3dDataset.getData().get(i);
                tooltip = tooltip + "<font color=rgb(" + sparkline3dDataSeries.getSeriesColor().getRed() + "," + sparkline3dDataSeries.getSeriesColor().getGreen() + "," + sparkline3dDataSeries.getSeriesColor().getBlue() + ")>" + sparkline3dDataSeries.getSeriesLabel() + "<br>";
                colors.add(sparkline3dDataSeries.getSeriesColor());
                double[][] data = this.plotType == PlotType.scatterPlot ? new double[2][sparkline3dDataSeries.getData().size()] : new double[3][sparkline3dDataSeries.getData().size()];
                for (int j = 0; j < sparkline3dDataSeries.getData().size(); ++j) {
                    data[0][j] = sparkline3dDataSeries.getData().get(j).getX();
                    data[1][j] = sparkline3dDataSeries.getData().get(j).getY();
                    if (this.plotType != PlotType.bubblePlot) continue;
                    data[2][j] = sparkline3dDataSeries.getData().get(j).getZ();
                }
                if (this.plotType == PlotType.scatterPlot) {
                    xyDataset.addSeries((Comparable)((Object)sparkline3dDataSeries.getSeriesLabel()), data);
                    continue;
                }
                xyzDataset.addSeries((Comparable)((Object)sparkline3dDataSeries.getSeriesLabel()), data);
            }
            this.chart = this.plotType == PlotType.scatterPlot ? ChartFactory.createScatterPlot(null, null, null, (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false) : ChartFactory.createBubbleChart(null, null, null, (XYZDataset)xyzDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            XYPlot plot = this.chart.getXYPlot();
            plot.getDomainAxis().setUpperMargin(0.0);
            plot.getDomainAxis().setLowerMargin(0.0);
            Iterator<String> allReferencesLines = this.referenceLinesXAxis.keySet().iterator();
            while (allReferencesLines.hasNext()) {
                ReferenceLine currentReferenceLine = this.referenceLinesXAxis.get(allReferencesLines.next());
                plot.addDomainMarker((Marker)new ValueMarker(currentReferenceLine.getValue(), (Paint)currentReferenceLine.getLineColor(), (Stroke)new BasicStroke(currentReferenceLine.getLineWidth())));
            }
            Iterator<String> allReferenceAreas = this.referenceAreasXAxis.keySet().iterator();
            while (allReferenceAreas.hasNext()) {
                ReferenceArea currentReferenceArea = this.referenceAreasXAxis.get(allReferenceAreas.next());
                marker = new IntervalMarker(currentReferenceArea.getStart(), currentReferenceArea.getEnd(), (Paint)currentReferenceArea.getAreaColor());
                marker.setAlpha(currentReferenceArea.getAlpha());
                plot.addDomainMarker((Marker)marker);
            }
            allReferencesLines = this.referenceLinesYAxis.keySet().iterator();
            while (allReferencesLines.hasNext()) {
                ReferenceLine currentReferenceLine = this.referenceLinesYAxis.get(allReferencesLines.next());
                plot.addRangeMarker((Marker)new ValueMarker(currentReferenceLine.getValue(), (Paint)currentReferenceLine.getLineColor(), (Stroke)new BasicStroke(currentReferenceLine.getLineWidth())));
            }
            allReferenceAreas = this.referenceAreasYAxis.keySet().iterator();
            while (allReferenceAreas.hasNext()) {
                ReferenceArea currentReferenceArea = this.referenceAreasYAxis.get(allReferenceAreas.next());
                marker = new IntervalMarker(currentReferenceArea.getStart(), currentReferenceArea.getEnd(), (Paint)currentReferenceArea.getAreaColor());
                marker.setAlpha(currentReferenceArea.getAlpha());
                plot.addRangeMarker((Marker)marker);
            }
            plot.getDomainAxis().setRange(this.minXValue, this.maxXValue);
            plot.getRangeAxis().setRange(this.minYValue, this.maxYValue);
            plot.getRangeAxis().setVisible(false);
            plot.getDomainAxis().setVisible(false);
            plot.setRangeGridlinesVisible(false);
            plot.setDomainGridlinesVisible(false);
            if (this.plotType == PlotType.scatterPlot) {
                for (int i = 0; i < xyDataset.getSeriesCount(); ++i) {
                    plot.getRenderer().setSeriesPaint(i, (Paint)colors.get(i));
                }
            } else {
                for (int i = 0; i < xyzDataset.getSeriesCount(); ++i) {
                    plot.getRenderer().setSeriesPaint(i, (Paint)colors.get(i));
                }
            }
        }
        this.setToolTipText(tooltip + "</html>");
        this.chart.getPlot().setOutlineVisible(false);
        this.chart.getPlot().setBackgroundPaint((Paint)c.getBackground());
        this.chart.setBackgroundPaint((Paint)c.getBackground());
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setBackground(c.getBackground());
        this.removeAll();
        this.add((Component)this.chartPanel);
        return this;
    }

    public void addXAxisReferenceLine(String label, double value, float lineWidth, Color lineColor) {
        this.referenceLinesXAxis.put(label, new ReferenceLine(label, value, lineWidth, lineColor));
    }

    public void removeXAxisReferenceLine(String label) {
        this.referenceLinesXAxis.remove(label);
    }

    public void removeAllXAxisReferenceLines() {
        this.referenceLinesXAxis = new HashMap();
    }

    public HashMap<String, ReferenceLine> getAllXAxisReferenceLines() {
        return this.referenceLinesXAxis;
    }

    public void addXAxisReferenceArea(String label, double start, double end, Color areaColor, float alpha) {
        this.referenceAreasXAxis.put(label, new ReferenceArea(label, start, end, areaColor, alpha));
    }

    public void removeXAxisReferenceArea(String label) {
        this.referenceAreasXAxis.remove(label);
    }

    public void removeAllXAxisReferenceAreas() {
        this.referenceAreasXAxis = new HashMap();
    }

    public HashMap<String, ReferenceArea> getXAxisAllReferenceAreas() {
        return this.referenceAreasXAxis;
    }

    public void addYAxisReferenceLine(String label, double value, float lineWidth, Color lineColor) {
        this.referenceLinesYAxis.put(label, new ReferenceLine(label, value, lineWidth, lineColor));
    }

    public void removeYAxisReferenceLine(String label) {
        this.referenceLinesYAxis.remove(label);
    }

    public void removeAllYAxisReferenceLines() {
        this.referenceLinesYAxis = new HashMap();
    }

    public HashMap<String, ReferenceLine> getAllYAxisReferenceLines() {
        return this.referenceLinesYAxis;
    }

    public void addYAxisReferenceArea(String label, double start, double end, Color areaColor, float alpha) {
        this.referenceAreasYAxis.put(label, new ReferenceArea(label, start, end, areaColor, alpha));
    }

    public void removeYAxisReferenceArea(String label) {
        this.referenceAreasYAxis.remove(label);
    }

    public void removeAllYAxisReferenceAreas() {
        this.referenceAreasYAxis = new HashMap();
    }

    public HashMap<String, ReferenceArea> getYAxisAllReferenceAreas() {
        return this.referenceAreasYAxis;
    }

    public void setMaxXValue(double maxXValue) {
        this.maxXValue = maxXValue;
    }

    public void setMinXValue(double minXValue) {
        this.minXValue = minXValue;
    }

    public void setMaxYValue(double maxYValue) {
        this.maxYValue = maxYValue;
    }

    public void setMinYValue(double minYValue) {
        this.minYValue = minYValue;
    }

    public void setPlotType(PlotType plotType) {
        this.plotType = plotType;
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public static enum PlotType {
        scatterPlot,
        bubblePlot;

    }
}

