/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.jaxb.xml.xxindex;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import psidev.psi.tools.xxindex.FastXmlElementExtractor;
import psidev.psi.tools.xxindex.GzXmlElementExtractor;
import psidev.psi.tools.xxindex.StandardXpathAccess;
import psidev.psi.tools.xxindex.XmlElementExtractor;
import psidev.psi.tools.xxindex.XpathAccess;
import psidev.psi.tools.xxindex.index.IndexElement;
import psidev.psi.tools.xxindex.index.XpathIndex;
import uk.ac.ebi.pride.jaxb.xml.xxindex.XmlIndexer;

public class XmlIndexerFactory {
    private static final Logger logger = LoggerFactory.getLogger(XmlIndexerFactory.class);
    private static final XmlIndexerFactory instance = new XmlIndexerFactory();

    private XmlIndexerFactory() {
    }

    public static XmlIndexerFactory getInstance() {
        return instance;
    }

    public XmlIndexer buildIndex(File xmlFile, Set<String> xpaths) {
        return new XmlIndexerImpl(xmlFile, xpaths);
    }

    private class XmlIndexerImpl
    implements XmlIndexer {
        private File xmlFile = null;
        private XpathAccess xpathAccess = null;
        private XmlElementExtractor xmlExtractor = null;
        private XpathIndex index = null;

        private XmlIndexerImpl(File aXmlFile, Set<String> xpaths) {
            if (aXmlFile == null) {
                throw new IllegalStateException("XML File to index must not be null.");
            }
            if (!aXmlFile.exists()) {
                throw new IllegalStateException("XML File to index does not exist: " + this.xmlFile.getAbsolutePath());
            }
            this.xmlFile = aXmlFile;
            try {
                this.xpathAccess = new StandardXpathAccess(this.xmlFile, xpaths);
                this.xmlExtractor = this.xmlFile.getName().endsWith(".gz") ? new GzXmlElementExtractor() : new FastXmlElementExtractor(this.xmlFile);
                String encoding = this.xmlExtractor.detectFileEncoding(this.xmlFile.toURI().toURL());
                if (encoding != null) {
                    this.xmlExtractor.setEncoding(encoding);
                }
                this.index = this.xpathAccess.getIndex();
            }
            catch (IOException e) {
                logger.error("PrideIndexFactory$PrideIndexImpl.PrideIndexImpl", (Throwable)e);
                throw new IllegalStateException("Could not generate index file for: " + this.xmlFile, e);
            }
        }

        @Override
        public String getXmlByIndexElement(IndexElement indexElement) {
            if (indexElement != null) {
                return this.readXml(indexElement.getStart(), indexElement.getStop());
            }
            throw new IllegalStateException("Attempting to read NULL ByteRange");
        }

        @Override
        public List<String> getXmlStringList(String xpath) {
            ArrayList<String> xmlList = new ArrayList<String>();
            Iterator<String> xmlIter = this.getXmlStringIterator(xpath);
            while (xmlIter.hasNext()) {
                xmlList.add(xmlIter.next());
            }
            return xmlList;
        }

        @Override
        public String getXmlSnippet(long start, long stop) {
            return this.readXml(start, stop);
        }

        @Override
        public Iterator<String> getXmlStringIterator(String xpathExpression) {
            return this.xpathAccess.getXmlSnippetIterator(xpathExpression);
        }

        @Override
        public int getCount(String xpathExpression) {
            return this.index.getElementCount(xpathExpression);
        }

        public Set<String> getXpath() {
            return this.index.getKeys();
        }

        public List<IndexElement> getIndexElements(String xpathExpression) {
            return this.index.getElements(xpathExpression);
        }

        @Override
        public Iterator<String> getXmlStringWithinRange(String xpath, long start, long stop) {
            return this.xpathAccess.getXmlSnippetIterator(xpath, Long.valueOf(start), Long.valueOf(stop));
        }

        private String readXml(long start, long stop) {
            try {
                return this.xmlExtractor.readString(start, stop, this.xmlFile);
            }
            catch (IOException e) {
                logger.error("PrideIndexFactory$PrideIndexImpl.readXML", (Throwable)e);
                throw new IllegalStateException("Could not extract XML from file: " + this.xmlFile, e);
            }
        }
    }
}

