package eu.isas.reporter.gui;

import com.compomics.software.ToolFactory;
import com.compomics.util.gui.DummyFrame;
import static com.compomics.software.autoupdater.DownloadLatestZipFromRepo.downloadLatestZipFromRepo;
import com.compomics.software.autoupdater.GUIFileDAO;
import com.compomics.software.autoupdater.MavenJarFile;
import com.compomics.software.autoupdater.WebDAO;
import com.compomics.software.dialogs.JavaParametersDialog;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.gui.error_handlers.BugReport;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.file_handling.FileAndFileFilter;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.parameters.UtilitiesUserParameters;
import eu.isas.reporter.Reporter;
import eu.isas.reporter.utils.Properties;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.swing.*;
import javax.xml.stream.XMLStreamException;

/**
 * A simple welcome dialog with the option to open an existing project or create
 * a new one.
 *
 * @author Harald Barsnes
 * @author Marc Vaudel
 */
public class WelcomeDialog extends javax.swing.JDialog {

    /**
     * The Reporter parent frame.
     */
    private ReporterGUI reporterGUI;
    /**
     * A dummy parent frame to be able to show an icon in the task bar.
     */
    static private DummyFrame dummyParentFrame = new DummyFrame("", "/icons/reporter.gif");
    /**
     * The progress dialog.
     */
    private ProgressDialogX progressDialog;

    /**
     * Create a new WelcomeDialog.
     *
     * @param reporterGUI the dialog parent
     * @param showLowMemoryWarning show or hide the low memory warning
     * @param showJavaVersionWarning show or hide the java version warning
     * @param modal modal or not modal
     */
    public WelcomeDialog(ReporterGUI reporterGUI, boolean showLowMemoryWarning, boolean showJavaVersionWarning, boolean modal) {
        super(dummyParentFrame.setNewTitle(reporterGUI.getTitle()), modal);
        this.reporterGUI = reporterGUI;
        initComponents();

        if (!showLowMemoryWarning && !showJavaVersionWarning) {
            lowMemoryWarningLabel.setVisible(false);
        }
        if (showJavaVersionWarning) {
            lowMemoryWarningLabel.setText("<html><u>Java Version Warning!</u>");
        }

        setLocationRelativeTo(null);
        setVisible(true);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        quantifyJButton = new javax.swing.JButton();
        settingsPopupMenu = new javax.swing.JPopupMenu();
        settingsMenu = new javax.swing.JMenu();
        javaSettingsMenuItem = new javax.swing.JMenuItem();
        pathSettingsMenu = new javax.swing.JMenuItem();
        helpMenu = new javax.swing.JMenu();
        gettingStartedMenuItem = new javax.swing.JMenuItem();
        bugReportMenuItem = new javax.swing.JMenuItem();
        jSeparator2 = new javax.swing.JPopupMenu.Separator();
        aboutMenuItem = new javax.swing.JMenuItem();
        backgroundPanel = new javax.swing.JPanel();
        openJButton = new javax.swing.JButton();
        newJButton = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JSeparator();
        recentProjectsLabel = new javax.swing.JLabel();
        gettingStartedJButton1 = new javax.swing.JButton();
        openExampleDatasetJButton = new javax.swing.JButton();
        settingsLabel = new javax.swing.JLabel();
        lowMemoryWarningLabel = new javax.swing.JLabel();
        searchJButton = new javax.swing.JButton();
        reshakeJButton = new javax.swing.JButton();
        compomicsButton = new javax.swing.JButton();
        probeButton = new javax.swing.JButton();
        isasButton = new javax.swing.JButton();

        quantifyJButton.setFont(quantifyJButton.getFont().deriveFont(quantifyJButton.getFont().getStyle() | java.awt.Font.BOLD, quantifyJButton.getFont().getSize()+3));
        quantifyJButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/reporter_logo.png"))); // NOI18N
        quantifyJButton.setText("Reporter Ions");
        quantifyJButton.setToolTipText("<html>\nQuantify your proteins using reporter ions<br>\n(Coming soon...)\n</html>");
        quantifyJButton.setFocusPainted(false);
        quantifyJButton.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        quantifyJButton.setIconTextGap(11);
        quantifyJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                quantifyJButtonActionPerformed(evt);
            }
        });

        settingsMenu.setText("Settings");

        javaSettingsMenuItem.setText("Java Settings");
        javaSettingsMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                javaSettingsMenuItemActionPerformed(evt);
            }
        });
        settingsMenu.add(javaSettingsMenuItem);

        pathSettingsMenu.setText("Resource Settings");
        pathSettingsMenu.setEnabled(false);
        pathSettingsMenu.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                pathSettingsMenuActionPerformed(evt);
            }
        });
        settingsMenu.add(pathSettingsMenu);

        settingsPopupMenu.add(settingsMenu);

        helpMenu.setText("Help");

        gettingStartedMenuItem.setText("Getting Started");
        gettingStartedMenuItem.setEnabled(false);
        gettingStartedMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                gettingStartedMenuItemActionPerformed(evt);
            }
        });
        helpMenu.add(gettingStartedMenuItem);

        bugReportMenuItem.setText("Bug Report");
        bugReportMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bugReportMenuItemActionPerformed(evt);
            }
        });
        helpMenu.add(bugReportMenuItem);
        helpMenu.add(jSeparator2);

        aboutMenuItem.setText("About");
        aboutMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                aboutMenuItemActionPerformed(evt);
            }
        });
        helpMenu.add(aboutMenuItem);

        settingsPopupMenu.add(helpMenu);

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle("Welcome to Reporter");
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        backgroundPanel.setBackground(new java.awt.Color(255, 255, 255));

        openJButton.setFont(openJButton.getFont().deriveFont(openJButton.getFont().getStyle() | java.awt.Font.BOLD, openJButton.getFont().getSize()+3));
        openJButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/Reporter-shadow.png"))); // NOI18N
        openJButton.setText("Open Project");
        openJButton.setToolTipText("Open an existing Reporter project");
        openJButton.setEnabled(false);
        openJButton.setFocusPainted(false);
        openJButton.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        openJButton.setIconTextGap(14);
        openJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                openJButtonActionPerformed(evt);
            }
        });

        newJButton.setFont(newJButton.getFont().deriveFont(newJButton.getFont().getStyle() | java.awt.Font.BOLD, newJButton.getFont().getSize()+3));
        newJButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/Reporter-shadow.png"))); // NOI18N
        newJButton.setText("New Project");
        newJButton.setToolTipText("Create a new Reporter project");
        newJButton.setFocusPainted(false);
        newJButton.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        newJButton.setIconTextGap(18);
        newJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                newJButtonActionPerformed(evt);
            }
        });

        recentProjectsLabel.setFont(recentProjectsLabel.getFont().deriveFont(recentProjectsLabel.getFont().getStyle() | java.awt.Font.BOLD));
        recentProjectsLabel.setText("<html><a href>Recent Projects</html>");
        recentProjectsLabel.setToolTipText("Open recently opened projects");
        recentProjectsLabel.setEnabled(false);
        recentProjectsLabel.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);
        recentProjectsLabel.setIconTextGap(-4);
        recentProjectsLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                recentProjectsLabelMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                recentProjectsLabelMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                recentProjectsLabelMouseExited(evt);
            }
        });

        gettingStartedJButton1.setFont(gettingStartedJButton1.getFont().deriveFont(gettingStartedJButton1.getFont().getStyle() | java.awt.Font.BOLD, gettingStartedJButton1.getFont().getSize()+3));
        gettingStartedJButton1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/help-medium-shadow.png"))); // NOI18N
        gettingStartedJButton1.setText("Getting Started");
        gettingStartedJButton1.setToolTipText("Open the Getting Started tutorial");
        gettingStartedJButton1.setEnabled(false);
        gettingStartedJButton1.setFocusPainted(false);
        gettingStartedJButton1.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        gettingStartedJButton1.setIconTextGap(30);
        gettingStartedJButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                gettingStartedJButton1ActionPerformed(evt);
            }
        });

        openExampleDatasetJButton.setFont(openExampleDatasetJButton.getFont().deriveFont(openExampleDatasetJButton.getFont().getStyle() | java.awt.Font.BOLD, openExampleDatasetJButton.getFont().getSize()+3));
        openExampleDatasetJButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/peptideshaker_example_dataset.png"))); // NOI18N
        openExampleDatasetJButton.setText("Open Example");
        openExampleDatasetJButton.setToolTipText("Opens a Reporter example dataset");
        openExampleDatasetJButton.setEnabled(false);
        openExampleDatasetJButton.setFocusPainted(false);
        openExampleDatasetJButton.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        openExampleDatasetJButton.setIconTextGap(29);
        openExampleDatasetJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                openExampleDatasetJButtonActionPerformed(evt);
            }
        });

        settingsLabel.setFont(settingsLabel.getFont().deriveFont(settingsLabel.getFont().getStyle() | java.awt.Font.BOLD));
        settingsLabel.setText("<html><a href>Settings & Help</html>");
        settingsLabel.setToolTipText("Edit the general settings or see the basic help");
        settingsLabel.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);
        settingsLabel.setIconTextGap(-4);
        settingsLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                settingsLabelMouseClicked(evt);
            }
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                settingsLabelMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                settingsLabelMouseExited(evt);
            }
        });

        lowMemoryWarningLabel.setFont(lowMemoryWarningLabel.getFont().deriveFont(lowMemoryWarningLabel.getFont().getStyle() | java.awt.Font.BOLD));
        lowMemoryWarningLabel.setForeground(new java.awt.Color(255, 0, 0));
        lowMemoryWarningLabel.setText("<html><u>Low Memory Warning!</u>");
        lowMemoryWarningLabel.setToolTipText("Click to see details");
        lowMemoryWarningLabel.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);
        lowMemoryWarningLabel.setIconTextGap(-4);
        lowMemoryWarningLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                lowMemoryWarningLabelMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                lowMemoryWarningLabelMouseExited(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                lowMemoryWarningLabelMouseReleased(evt);
            }
        });

        searchJButton.setFont(searchJButton.getFont().deriveFont(searchJButton.getFont().getStyle() | java.awt.Font.BOLD, searchJButton.getFont().getSize()+3));
        searchJButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/searchgui-medium-shadow.png"))); // NOI18N
        searchJButton.setText("Start Search");
        searchJButton.setToolTipText("Start a SearchGUI protein identification search");
        searchJButton.setFocusPainted(false);
        searchJButton.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        searchJButton.setIconTextGap(30);
        searchJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                searchJButtonActionPerformed(evt);
            }
        });

        reshakeJButton.setFont(reshakeJButton.getFont().deriveFont(reshakeJButton.getFont().getStyle() | java.awt.Font.BOLD, reshakeJButton.getFont().getSize()+3));
        reshakeJButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/peptide-shaker-medium-orange-shadow.png"))); // NOI18N
        reshakeJButton.setText("PeptideShaker");
        reshakeJButton.setToolTipText("Start PeptideShaker");
        reshakeJButton.setFocusPainted(false);
        reshakeJButton.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        reshakeJButton.setIconTextGap(29);
        reshakeJButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                reshakeJButtonActionPerformed(evt);
            }
        });

        compomicsButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/compomics.png"))); // NOI18N
        compomicsButton.setToolTipText("Computational Omics and Systems Biology Group");
        compomicsButton.setBorder(null);
        compomicsButton.setBorderPainted(false);
        compomicsButton.setContentAreaFilled(false);
        compomicsButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                compomicsButtonMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                compomicsButtonMouseExited(evt);
            }
        });
        compomicsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                compomicsButtonActionPerformed(evt);
            }
        });

        probeButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/probe-new.png"))); // NOI18N
        probeButton.setToolTipText("Proteomics Unit at the University of Bergen");
        probeButton.setBorder(null);
        probeButton.setBorderPainted(false);
        probeButton.setContentAreaFilled(false);
        probeButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                probeButtonMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                probeButtonMouseExited(evt);
            }
        });
        probeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                probeButtonActionPerformed(evt);
            }
        });

        isasButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/icons/isas-cropped.png"))); // NOI18N
        isasButton.setToolTipText("<html>ISAS - Institute for Analytical Science</html>");
        isasButton.setBorder(null);
        isasButton.setBorderPainted(false);
        isasButton.setContentAreaFilled(false);
        isasButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                isasButtonMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                isasButtonMouseExited(evt);
            }
        });
        isasButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                isasButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout backgroundPanelLayout = new javax.swing.GroupLayout(backgroundPanel);
        backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(backgroundPanelLayout.createSequentialGroup()
                .addGap(27, 27, 27)
                .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(backgroundPanelLayout.createSequentialGroup()
                        .addGap(10, 10, 10)
                        .addComponent(settingsLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(lowMemoryWarningLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(90, 90, 90)
                        .addComponent(recentProjectsLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(10, 10, 10))
                    .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                        .addGroup(backgroundPanelLayout.createSequentialGroup()
                            .addComponent(newJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 250, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(openJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 254, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGroup(backgroundPanelLayout.createSequentialGroup()
                            .addComponent(openExampleDatasetJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 250, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(gettingStartedJButton1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addGroup(backgroundPanelLayout.createSequentialGroup()
                            .addComponent(searchJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 250, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(reshakeJButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
                .addGap(27, 27, 27))
            .addGroup(backgroundPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jSeparator1)
                .addContainerGap())
            .addGroup(backgroundPanelLayout.createSequentialGroup()
                .addGap(30, 30, 30)
                .addComponent(compomicsButton, javax.swing.GroupLayout.PREFERRED_SIZE, 139, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(probeButton, javax.swing.GroupLayout.PREFERRED_SIZE, 178, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(isasButton, javax.swing.GroupLayout.PREFERRED_SIZE, 161, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        backgroundPanelLayout.setVerticalGroup(
            backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup()
                .addGap(30, 30, 30)
                .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(newJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(openJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(searchJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(reshakeJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(gettingStartedJButton1, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(openExampleDatasetJButton, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(recentProjectsLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(settingsLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lowMemoryWarningLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(backgroundPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(compomicsButton)
                    .addComponent(probeButton, javax.swing.GroupLayout.PREFERRED_SIZE, 65, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(isasButton))
                .addContainerGap())
        );

        backgroundPanelLayout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {newJButton, openJButton});

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(backgroundPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * Open the dialog for creating a new project.
     *
     * @param evt
     */
    private void newJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newJButtonActionPerformed
        new NewDialog(this, reporterGUI, true);
    }//GEN-LAST:event_newJButtonActionPerformed

    /**
     * Open the dialog for opening an existing project.
     *
     * @param evt
     */
    private void openJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_openJButtonActionPerformed

        // @TODO: implement me!
        String psdbFileFilterDescription = "PeptideShaker (.psdb)";
        String zipFileFilterDescription = "Zipped PeptideShaker (.zip)";
        String lastSelectedFolderPath = reporterGUI.getLastSelectedFolder().getLastSelectedFolder();
        FileAndFileFilter selectedFileAndFilter = FileChooserUtil.getUserSelectedFile(this, new String[]{".psdb", ".zip"},
                new String[]{psdbFileFilterDescription, zipFileFilterDescription}, "Open PeptideShaker Project", lastSelectedFolderPath, null, true, false, false, 0);

        if (selectedFileAndFilter != null) {

//            File selectedFile = selectedFileAndFilter.getFile(); 
//            reporterGUI.getLastSelectedFolder().setLastSelectedFolder(selectedFile.getParent());
//
//            if (selectedFile.getName().endsWith(".zip")) {
//                setVisible(false);
//                reporterGUI.setVisible(true);
//                reporterGUI.importPeptideShakerZipFile(selectedFile);
//                dispose();
//            } else if (selectedFile.getName().endsWith(".psdb")) {
//                setVisible(false);
//                reporterGUI.setVisible(true);
//                reporterGUI.importPeptideShakerFile(selectedFile);
//                reporterGUI.getUserPreferences().addRecentProject(selectedFile);
//                reporterGUI.updateRecentProjectsList();
//                LastSelectedFolder lastSelectedFolder = reporterGUI.getLastSelectedFolder();
//                lastSelectedFolder.setLastSelectedFolder(selectedFile.getAbsolutePath());
//                dispose();
//            } else {
//                JOptionPane.showMessageDialog(this, "Not a PeptideShaker file (.psdb).", "Unsupported File.", JOptionPane.WARNING_MESSAGE);
//            }
        }
    }//GEN-LAST:event_openJButtonActionPerformed

    /**
     * Start Reporter.
     *
     * @param evt
     */
    private void quantifyJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_quantifyJButtonActionPerformed

        JOptionPane.showMessageDialog(this, "In development. Coming soon...", "In Developement...", JOptionPane.INFORMATION_MESSAGE,
                new javax.swing.ImageIcon(getClass().getResource("/icons/reporter_logo.png")));

//        new Thread(new Runnable() {
//            public void run() {
//                try {
//                    ToolFactory.startReporter(peptideShakerGUI);
//                } catch (Exception e) {
//                    peptideShakerGUI.catchException(e);
//                }
//            }
//        }, "StartReporter").start();
    }//GEN-LAST:event_quantifyJButtonActionPerformed

    /**
     * Change the cursor to a hand cursor.
     *
     * @param evt
     */
    private void recentProjectsLabelMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_recentProjectsLabelMouseEntered
        setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_recentProjectsLabelMouseEntered

    /**
     * Change the cursor back to the default cursor.
     *
     * @param evt
     */
    private void recentProjectsLabelMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_recentProjectsLabelMouseExited
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_recentProjectsLabelMouseExited

    /**
     * Open a recently opened project.
     *
     * @param evt
     */
    private void recentProjectsLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_recentProjectsLabelMouseClicked
//        JPopupMenu popupMenu = new JPopupMenu(); // @TODO: implement me!
//        reporterGUI.loadRecentProjectsList(popupMenu, this);
//        popupMenu.show(recentProjectsLabel, evt.getX(), evt.getY());
    }//GEN-LAST:event_recentProjectsLabelMouseClicked

    /**
     * Open the Getting Started tutorial.
     *
     * @param evt
     */
    private void gettingStartedJButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_gettingStartedJButton1ActionPerformed
        //new GettingStartedDialog(reporterGUI, this, true); // @TODO: implement me!
    }//GEN-LAST:event_gettingStartedJButton1ActionPerformed

    /**
     * Open the example dataset.
     *
     * @param evt
     */
    private void openExampleDatasetJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_openExampleDatasetJButtonActionPerformed
//        setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR)); // @TODO: implement me!
//        setVisible(false);
//        reporterGUI.setVisible(true);
//        dispose();
//        reporterGUI.openExampleFile();
//        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_openExampleDatasetJButtonActionPerformed

    /**
     * The dialog is closing. Close the main Reporter frame.
     *
     * @param evt
     */
    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        setVisible(false);
        reporterGUI.closeReporter();
    }//GEN-LAST:event_formWindowClosing

    /**
     * Open the settings pop up menu.
     *
     * @param evt
     */
    private void settingsLabelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_settingsLabelMouseClicked
        settingsPopupMenu.show(settingsLabel, evt.getX(), evt.getY());
    }//GEN-LAST:event_settingsLabelMouseClicked

    /**
     * Change the cursor to a hand cursor.
     *
     * @param evt
     */
    private void settingsLabelMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_settingsLabelMouseEntered
        setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_settingsLabelMouseEntered

    /**
     * Change the cursor back to the default cursor.
     *
     * @param evt
     */
    private void settingsLabelMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_settingsLabelMouseExited
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_settingsLabelMouseExited

    /**
     * Open the Java Parameters dialog.
     *
     * @param evt
     */
    private void javaSettingsMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_javaSettingsMenuItemActionPerformed
        new JavaParametersDialog(dummyParentFrame, reporterGUI, this, "Reporter", true);
    }//GEN-LAST:event_javaSettingsMenuItemActionPerformed

    /**
     * Open the Getting Started tutorial.
     *
     * @param evt
     */
    private void gettingStartedMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_gettingStartedMenuItemActionPerformed
        gettingStartedJButton1ActionPerformed(null);
    }//GEN-LAST:event_gettingStartedMenuItemActionPerformed

    /**
     * Opens a new bug report dialog.
     *
     * @param evt
     */
    private void bugReportMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bugReportMenuItemActionPerformed
        
        new BugReport(
                this, 
                reporterGUI.getLastSelectedFolder(), 
                "Reporter", 
                "reporter",
                new Properties().getVersion(), 
                "reporter", 
                "Reporter",
                new File(Reporter.getConfigFolder() + "/resources/Reporter.log")
        );
        
    }//GEN-LAST:event_bugReportMenuItemActionPerformed

    /**
     * Opens the About dialog.
     *
     * @param evt
     */
    private void aboutMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_aboutMenuItemActionPerformed
        
        new HelpDialog(
                reporterGUI, 
                getClass().getResource("/helpFiles/AboutReporter.html"),
                Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/help.GIF")),
                Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/reporter.gif")),
                "About Reporter"
        );
        
    }//GEN-LAST:event_aboutMenuItemActionPerformed

    /**
     * Change the cursor to a hand cursor.
     *
     * @param evt
     */
    private void lowMemoryWarningLabelMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lowMemoryWarningLabelMouseEntered
        setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_lowMemoryWarningLabelMouseEntered

    /**
     * Change the cursor back to the default cursor.
     *
     * @param evt
     */
    private void lowMemoryWarningLabelMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lowMemoryWarningLabelMouseExited
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_lowMemoryWarningLabelMouseExited

    /**
     * Open the Java Parameters dialog.
     *
     * @param evt
     */
    private void lowMemoryWarningLabelMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lowMemoryWarningLabelMouseReleased
        new JavaParametersDialog(dummyParentFrame, reporterGUI, this, "Reporter", true);
    }//GEN-LAST:event_lowMemoryWarningLabelMouseReleased

    /**
     * Open the Edit Paths dialog.
     *
     * @param evt
     */
    private void pathSettingsMenuActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pathSettingsMenuActionPerformed
        //reporterGUI.editPathSettings(this); // @TODO: implement me!
    }//GEN-LAST:event_pathSettingsMenuActionPerformed

    /**
     * Start SearchGUI.
     *
     * @param evt
     */
    private void searchJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_searchJButtonActionPerformed

        // @TODO: the default searchgui folder has to be set!!!
        this.setVisible(false);
        reporterGUI.setVisible(false);

        new Thread(new Runnable() {
            public void run() {
                try {
                    ToolFactory.startSearchGUI(dummyParentFrame, null, null, null, null, null, null, null, null, null);
                    reporterGUI.closeReporter();
                } catch (Exception e) {
                    reporterGUI.catchException(e);
                }
            }
        }, "StartSearchGUI").start();
        
    }//GEN-LAST:event_searchJButtonActionPerformed

    /**
     * Start PeptideShaker.
     *
     * @param evt
     */
    private void reshakeJButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_reshakeJButtonActionPerformed

        // @TODO: the default peptideshaker folder has to be set!!!
        this.setVisible(false);
        reporterGUI.setVisible(false);

        new Thread(new Runnable() {
            public void run() {
                try {
                    ToolFactory.startPeptideShaker(dummyParentFrame);
                    reporterGUI.closeReporter();
                } catch (Exception e) {
                    reporterGUI.catchException(e);
                }
            }
        }, "StartPeptideShaker").start();
    }//GEN-LAST:event_reshakeJButtonActionPerformed

    /**
     * Change the cursor to a hand cursor.
     *
     * @param evt
     */
    private void compomicsButtonMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_compomicsButtonMouseEntered
        setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_compomicsButtonMouseEntered

    /**
     * Change the cursor back to the default cursor.
     *
     * @param evt
     */
    private void compomicsButtonMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_compomicsButtonMouseExited
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_compomicsButtonMouseExited

    /**
     * Open the Compomics web page.
     *
     * @param evt
     */
    private void compomicsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_compomicsButtonActionPerformed
        setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://compomics.com");
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_compomicsButtonActionPerformed

    /**
     * Change the cursor to a hand cursor.
     *
     * @param evt
     */
    private void probeButtonMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_probeButtonMouseEntered
        setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_probeButtonMouseEntered

    /**
     * Change the cursor back to the default cursor.
     *
     * @param evt
     */
    private void probeButtonMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_probeButtonMouseExited
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_probeButtonMouseExited

    /**
     * Open the PROBE web page.
     *
     * @param evt
     */
    private void probeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_probeButtonActionPerformed
        setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("http://probe.uib.no");
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_probeButtonActionPerformed

    /**
     * Change the cursor to a hand cursor.
     *
     * @param evt
     */
    private void isasButtonMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_isasButtonMouseEntered
        setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
    }//GEN-LAST:event_isasButtonMouseEntered

    /**
     * Change the cursor back to the default cursor.
     *
     * @param evt
     */
    private void isasButtonMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_isasButtonMouseExited
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_isasButtonMouseExited

    /**
     * Open the ISAS web page.
     *
     * @param evt
     */
    private void isasButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_isasButtonActionPerformed
        setCursor(new java.awt.Cursor(java.awt.Cursor.WAIT_CURSOR));
        BareBonesBrowserLaunch.openURL("https://www.isas.de");
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
    }//GEN-LAST:event_isasButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuItem aboutMenuItem;
    private javax.swing.JPanel backgroundPanel;
    private javax.swing.JMenuItem bugReportMenuItem;
    private javax.swing.JButton compomicsButton;
    private javax.swing.JButton gettingStartedJButton1;
    private javax.swing.JMenuItem gettingStartedMenuItem;
    private javax.swing.JMenu helpMenu;
    private javax.swing.JButton isasButton;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JPopupMenu.Separator jSeparator2;
    private javax.swing.JMenuItem javaSettingsMenuItem;
    private javax.swing.JLabel lowMemoryWarningLabel;
    private javax.swing.JButton newJButton;
    private javax.swing.JButton openExampleDatasetJButton;
    private javax.swing.JButton openJButton;
    private javax.swing.JMenuItem pathSettingsMenu;
    private javax.swing.JButton probeButton;
    private javax.swing.JButton quantifyJButton;
    private javax.swing.JLabel recentProjectsLabel;
    private javax.swing.JButton reshakeJButton;
    private javax.swing.JButton searchJButton;
    private javax.swing.JLabel settingsLabel;
    private javax.swing.JMenu settingsMenu;
    private javax.swing.JPopupMenu settingsPopupMenu;
    // End of variables declaration//GEN-END:variables

    /**
     * Make sure that the dummy frame is hidden when the dialog is not visible.
     *
     * @param visible if the dialog is to be visible or not
     */
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            ((DummyFrame) getParent()).dispose();
        }
    }

    @Override
    public void setIconImage(Image image) {
        super.setIconImage(image);
        dummyParentFrame.setIconImage(image);
    }

    /**
     * Check for new version.
     *
     * @param searchGuiJarPath the path to the SearchGUI jar file
     * @return true if a new version is available
     */
    public boolean checkForNewSearchGUIVersion(String searchGuiJarPath) {

        try {

            File jarFile = new File(searchGuiJarPath);
            MavenJarFile oldMavenJarFile = new MavenJarFile(jarFile.toURI());

            URL jarRepository = new URL(
                    "https",
                    "genesis.ugent.be",
                    "/archiva/repository/maven2/"
            );

            return WebDAO.newVersionReleased(oldMavenJarFile, jarRepository);

        } catch (UnknownHostException ex) {

            System.out.println("Checking for new version failed. No internet connection.");
            // no internet connection
            return false;

        } catch (Exception e) {

            e.printStackTrace();
            return false;

        }
    }

    /**
     * Download SearchGUI.
     *
     * @return true if not canceled
     */
    public boolean downloadSearchGUI() {

        boolean firstTimeInstall = true;
        String installPath = null;

        UtilitiesUserParameters utilitiesUserParameters = reporterGUI.getUtilitiesUserParameters();

        if (utilitiesUserParameters.getSearchGuiPath() != null) {
            if (new File(utilitiesUserParameters.getSearchGuiPath()).getParentFile() != null
                    && new File(utilitiesUserParameters.getSearchGuiPath()).getParentFile().getParentFile() != null) {
                installPath = new File(utilitiesUserParameters.getSearchGuiPath()).getParentFile().getParent();
            }
        }

        final File downloadFolder;

        if (installPath == null) {
            installPath = "user.home";
            downloadFolder = FileChooserUtil.getUserSelectedFolder(this, "Select SearchGUI Folder", installPath, "SearchGUI Folder", "Select", false);
        } else {
            firstTimeInstall = false;
            downloadFolder = new File(installPath);
        }

        final boolean finalFirstTimeInstall = firstTimeInstall;

        if (downloadFolder != null) {

            progressDialog = new ProgressDialogX(dummyParentFrame,
                    Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/peptide-shaker.gif")),
                    Toolkit.getDefaultToolkit().getImage(getClass().getResource("/icons/peptide-shaker-orange.gif")),
                    true);

            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            progressDialog.setTitle("Downloading SearchGUI. Please Wait...");

            new Thread(new Runnable() {
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    } catch (IndexOutOfBoundsException e) {
                        // ignore
                    }
                }
            }, "ProgressDialog").start();

            Thread thread = new Thread("DownloadThread") {
                @Override
                public void run() {
                    try {
                        URL jarRepository = new URL(
                                "http", "genesis.ugent.be",
                                new StringBuilder().append("/maven2/").toString()
                        );

                        if (finalFirstTimeInstall) {

                            downloadLatestZipFromRepo(
                                    downloadFolder,
                                    "SearchGUI",
                                    "eu.isas.searchgui",
                                    "SearchGUI",
                                    "searchgui.ico",
                                    null,
                                    jarRepository,
                                    false,
                                    true,
                                    new GUIFileDAO(),
                                    progressDialog
                            );

                        } else {

                            downloadLatestZipFromRepo(
                                    new File(reporterGUI.getUtilitiesUserParameters().getSearchGuiPath()).toURI().toURL(),
                                    "SearchGUI",
                                    false,
                                    "searchgui.ico",
                                    null, jarRepository,
                                    false,
                                    true,
                                    new GUIFileDAO(),
                                    progressDialog
                            );

                        }

                    } catch (IOException e) {
                        e.printStackTrace();
                    } catch (URISyntaxException e) {
                        e.printStackTrace();
                    } catch (XMLStreamException e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.start();

            try {
                thread.join();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }

            if (progressDialog.isRunCanceled()) {

                progressDialog.setRunFinished();
                return false;

            } else {

                if (!progressDialog.isRunFinished()) {
                    progressDialog.setRunFinished();
                }

            }

            return true;
        }

        return false;
    }
}
